'use strict';


var Type = require('../type');


var _toString = Object.prototype.toString;


function resolveYamlPairs(state) {
  var index, length, pair, keys, result,
      object = state.result;

  result = new Array(object.length);

  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];

    if ('[object Object]' !== _toString.call(pair)) {
      return false;
    }

    keys = Object.keys(pair);

    if (1 !== keys.length) {
      return false;
    }

    result[index] = [ keys[0], pair[keys[0]] ];
  }

  state.result = result;
  return true;
}


module.exports = new Type('tag:yaml.org,2002:pairs', {
  loadKind: 'sequence',
  loadResolver: resolveYamlPairs
});
