/* global define, Membership */
define(['jquery',
    'edx-ui-toolkit/js/utils/spec-helpers/ajax-helpers',
    'js/instructor_dashboard/membership'],
    function($, AjaxHelpers) {
        'use strict';
        describe('Membership.AuthListWidget', function() {
            var membership, // eslint-disable-line no-unused-vars
                changeSelectedList;

            changeSelectedList = function(listName) {
                var i, options;
                options = document.getElementById('member-lists-selector').options;
                for (i = 0; i < options.length; i++) {
                    if (options[i].value === listName) {
                        document.getElementById('member-lists-selector').selectedIndex = i;
                        $('select#member-lists-selector').trigger('change');
                        break;
                    }
                }
            };

            beforeEach(function() {
                var membershipMain, membershipTpl;
                membershipMain = readFixtures('js/fixtures/instructor_dashboard/membership.html');
                membershipTpl = readFixtures(
                    'templates/instructor/instructor_dashboard_2/membership-list-widget.underscore'
                );
                appendSetFixtures(
                    "<script type='text/template' id='membership-list-widget-tpl'>" + membershipTpl + '</script>' +
                    membershipMain
                );
                membership = new window.InstructorDashboard.sections.Membership($('#membership'));
            });

            it('binds the ajax call and the result will be success for Group Moderator', function() {
                var requests = AjaxHelpers.requests(this),
                    data,
                    url = '/courses/course-v1:edx+ed202+2017_T3/instructor/api/list_forum_members';

                data = {
                    course_id: 'course-v1:edx+ed202+2017_T3',
                    'Group Moderator': [{
                        email: 'verified@example.com',
                        first_name: '',
                        group_name: 'Verified',
                        last_name: '',
                        username: 'verified'
                    }],
                    division_scheme: 'enrollment_track'
                };
                changeSelectedList('Group Moderator');

                AjaxHelpers.expectPostRequest(requests, url, 'rolename=Group+Moderator');
                AjaxHelpers.respondWithJson(requests, data);

                expect($('.auth-list-container.active').data('rolename')).toEqual('Group Moderator');

                expect($('.request-response-error').text()).toEqual('');

                // Both buttons should be enabled
                expect($('.auth-list-container.active .add').attr('disabled')).toBe(undefined);
                expect($('.auth-list-container.active .add-field').attr('disabled')).toBe(undefined);
            });

            it('When no discussions division scheme is selected error is shown and inputs are disabled', function() {
                var requests = AjaxHelpers.requests(this),
                    data,
                    url = '/courses/course-v1:edx+ed202+2017_T3/instructor/api/list_forum_members';

                data = {
                    course_id: 'course-v1:edx+ed202+2017_T3',
                    'Group Moderator': [{
                        email: 'verified@example.com',
                        first_name: '',
                        group_name: 'Verified',
                        last_name: '',
                        username: 'verified'
                    }],
                    division_scheme: 'none'
                };
                changeSelectedList('Group Moderator');

                AjaxHelpers.expectPostRequest(requests, url, 'rolename=Group+Moderator');
                AjaxHelpers.respondWithJson(requests, data);

                expect($('.auth-list-container.active').data('rolename')).toEqual('Group Moderator');

                // Error message is shown.
                expect($('.request-response-error').text()).toEqual('This role requires a divided discussions scheme.');

                // Both buttons should be disabled
                expect($('.auth-list-container.active .add').attr('disabled')).toBe('disabled');
                expect($('.auth-list-container.active .add-field').attr('disabled')).toBe('disabled');
            });
        });
    });
