/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import protex.AminoAcid;
import protex.AminoAcidTable;
import protex.FoldingException;
import protex.Protex;

public class StandardTable
extends AminoAcidTable {
    private Map table = new TreeMap();
    private Map abNameTable = new TreeMap();
    private double maxEnergy;
    private String contactEnergyListName = "";
    private static StandardTable instance;

    public static StandardTable getInstance() {
        if (instance == null) {
            instance = new StandardTable();
        }
        return instance;
    }

    private StandardTable() {
        try {
            this.add(new AminoAcid("R", "Arg", -15.86, 1, 1, false), 0.057);
            this.add(new AminoAcid("D", "Asp", -9.66, 1, -1, false), 0.053);
            this.add(new AminoAcid("E", "Glu", -7.75, 1, -1, false), 0.062);
            this.add(new AminoAcid("N", "Asn", -7.58, 1, 0, false), 0.044);
            this.add(new AminoAcid("K", "Lys", -6.49, 1, 1, false), 0.057);
            this.add(new AminoAcid("Q", "Gln", -6.48, 1, 0, false), 0.04);
            this.add(new AminoAcid("H", "His", -5.6, 1, 1, false), 0.022);
            this.add(new AminoAcid("S", "Ser", -4.34, 1, 0, false), 0.069);
            this.add(new AminoAcid("T", "Thr", -3.51, 1, 0, false), 0.058);
            this.add(new AminoAcid("Y", "Tyr", -1.08, 1, 0, false), 0.032);
            this.add(new AminoAcid("G", "Gly", 0.0, 0, 0, false), 0.072);
            this.add(new AminoAcid("P", "Pro", 0.01, 0, 0, false), 0.051);
            this.add(new AminoAcid("C", "Cys", 0.34, 0, 0, true), 0.017);
            this.add(new AminoAcid("A", "Ala", 0.87, 0, 0, false), 0.083);
            this.add(new AminoAcid("W", "Trp", 1.39, 0, 0, false), 0.013);
            this.add(new AminoAcid("M", "Met", 1.41, 0, 0, false), 0.024);
            this.add(new AminoAcid("F", "Phe", 2.04, 0, 0, false), 0.039);
            this.add(new AminoAcid("V", "Val", 3.1, 0, 0, false), 0.066);
            this.add(new AminoAcid("I", "Ile", 3.98, 0, 0, false), 0.052);
            this.add(new AminoAcid("L", "Leu", 3.98, 0, 0, false), 0.09);
            this.add(new AminoAcid("X", "XXX", 3.98, 0, 0, false), 0.0);
        }
        catch (FoldingException e) {
            System.err.println("shouldn't get here");
            e.printStackTrace();
        }
        this.normalize();
        if (!Protex.isApplet) {
            this.readInContactEnergies();
        }
    }

    @Override
    public Iterator getIterator() throws FoldingException {
        return this.table.keySet().iterator();
    }

    @Override
    public void add(AminoAcid a, double probability) throws FoldingException {
        String aName = a.getName().trim().toUpperCase();
        this.table.put(aName, new AcidInTable(a, probability));
        this.abNameTable.put(a.getAbName(), aName);
    }

    @Override
    public void add(AminoAcid a) throws FoldingException {
        throw new FoldingException("can't add to standard table without probability");
    }

    @Override
    public AminoAcid get(String name) {
        AcidInTable a = (AcidInTable)this.table.get(name.trim().toUpperCase());
        if (a == null) {
            return null;
        }
        return a.a;
    }

    @Override
    public AminoAcid getFromAbName(String abName) {
        String aName = (String)this.abNameTable.get(abName.trim().toUpperCase());
        if (aName == null) {
            return null;
        }
        AcidInTable a = (AcidInTable)this.table.get(aName);
        return a.a;
    }

    public AminoAcid getFromIndexNum(int indexNum) {
        Iterator it = this.table.keySet().iterator();
        while (it.hasNext()) {
            AminoAcid a = this.get((String)it.next());
            if (a.getIndexNum() != indexNum) continue;
            return a;
        }
        return null;
    }

    @Override
    public float getContrastScaler() {
        return 1.0f;
    }

    @Override
    public String getName() {
        return "standard";
    }

    @Override
    public AminoAcid[] getRandom(int length, int seed) {
        AminoAcid[] sequence = new AminoAcid[length];
        Random r = new Random(seed);
        int i = 0;
        while (i < sequence.length) {
            double d = r.nextDouble();
            double ptotal = 0.0;
            for (AcidInTable a : this.table.values()) {
                if (!(d < (ptotal += a.probability))) continue;
                sequence[i] = a.a;
                break;
            }
            ++i;
        }
        return sequence;
    }

    public AminoAcid[] getAllAcids() {
        AminoAcid[] sequence = new AminoAcid[this.table.size()];
        int i = 0;
        for (AcidInTable a : this.table.values()) {
            sequence[i] = a.a;
            ++i;
        }
        return sequence;
    }

    private void normalize() {
        double maxHI = Double.MIN_VALUE;
        double minHI = Double.MAX_VALUE;
        double ptotal = 0.0;
        for (AcidInTable a : this.table.values()) {
            ptotal += a.probability;
            if (a.a.getHydrophobicIndex() > maxHI) {
                maxHI = a.a.getHydrophobicIndex();
            }
            if (!(a.a.getHydrophobicIndex() < minHI)) continue;
            minHI = a.a.getHydrophobicIndex();
        }
        this.maxEnergy = Math.max(maxHI, -minHI);
        for (AcidInTable a : this.table.values()) {
            a.probability /= ptotal;
            a.a.setNormalizedHydrophobicIndex((a.a.getHydrophobicIndex() - minHI) / (maxHI - minHI));
        }
    }

    private void readInContactEnergies() {
        File contactEnergyFile = new File("ContactEnergies.txt");
        if (!contactEnergyFile.exists()) {
            return;
        }
        BufferedReader input = null;
        try {
            try {
                input = new BufferedReader(new FileReader("ContactEnergies.txt"));
                String line = null;
                boolean firstLine = true;
                while ((line = input.readLine()) != null) {
                    if (line.indexOf("#") != -1) {
                        line = line.trim();
                        StringBuffer b = new StringBuffer(line);
                        this.contactEnergyListName = b.deleteCharAt(0).toString();
                        System.out.println(this.contactEnergyListName);
                        continue;
                    }
                    String[] parts = line.split(",");
                    if (firstLine) {
                        int i = 1;
                        while (i < parts.length) {
                            AminoAcid a = this.get(parts[i]);
                            a.setIndexNum(i - 1);
                            ++i;
                        }
                        firstLine = false;
                        continue;
                    }
                    AminoAcid a = this.get(parts[0]);
                    int[] energies = new int[20];
                    int i = 1;
                    while (i < parts.length) {
                        energies[i - 1] = Math.round(100.0f * Float.parseFloat(parts[i]));
                        ++i;
                    }
                    a.setContactEnergies(energies);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String toString() {
        return "name\t\thi\tnormal\tprob\n" + this.table.toString();
    }

    @Override
    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    public String getContactEnergyListName() {
        return this.contactEnergyListName;
    }

    public static void main(String[] args) {
        StandardTable t = new StandardTable();
        System.out.println(t);
        AminoAcid[] list = ((AminoAcidTable)t).getRandom(15, 999);
        int i = 0;
        while (i < list.length) {
            System.out.println(list[i]);
            ++i;
        }
    }

    public void showContactEnergies() {
        Iterator it = this.table.keySet().iterator();
        StringBuffer b1 = new StringBuffer();
        StringBuffer b2 = new StringBuffer();
        b1.append(",");
        int i = 0;
        while (i < 20) {
            AminoAcid a = this.getFromIndexNum(i);
            b1.append(String.valueOf(a.getName()) + ",");
            b2.append(String.valueOf(a.getName()) + ",");
            int j = 0;
            while (j < 20) {
                b2.append(String.valueOf(a.getContactEnergy(j)) + ",");
                ++j;
            }
            b2.deleteCharAt(b2.length() - 1);
            b2.append("\n");
            ++i;
        }
        b1.deleteCharAt(b1.length() - 1);
        System.out.println(String.valueOf(b1.toString()) + "\n" + b2.toString());
    }

    private class AcidInTable
    implements Serializable {
        protected AminoAcid a;
        protected double probability;

        public AcidInTable(AminoAcid a, double probability) {
            this.a = a;
            this.probability = probability;
        }

        public String toString() {
            return String.valueOf(this.a.toString()) + '\t' + this.a.getHydrophobicIndex() + '\t' + this.a.getNormalizedHydrophobicIndex() + "\t\t" + this.probability + '\n';
        }
    }
}

