/*
 * Decompiled with CFR 0.152.
 */
package protex;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import protex.AminoAcidPalette;
import protex.FoldedPolypeptide;
import protex.FoldingWindow;
import protex.HistListFileFilter;
import protex.HistoryList;
import protex.ProteinPrinter;
import protex.ShapeMatcher;
import protex.StandardTable;
import protex.TargetShape;
import protex.TargetShapeDisplayDialog;
import protex.TargetShapeSelectionDialog;

public class Protex
extends JFrame {
    public static final String targetShapeFileName = "target_shapes.txt";
    public static final String contactEnergyListFileName = "ContactEnergies.txt";
    private static final String version = "3.0.2";
    public static final Color SS_BONDS_OFF_BACKGROUND = new Color(0.7f, 0.7f, 1.0f);
    public static final Color SS_BONDS_ON_BACKGROUND = new Color(0.7f, 1.0f, 1.0f);
    public static boolean isApplet;
    JPanel topMenuPanel;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenu energies;
    JRadioButtonMenuItem standard;
    JRadioButtonMenuItem custom;
    JMenuItem print;
    JMenuItem quit;
    JMenu histListMenu;
    JMenuItem save;
    JMenuItem saveAs;
    JMenuItem load;
    JMenuItem clearAll;
    JMenuItem saveToHTML;
    JMenu gameMenu;
    JCheckBoxMenuItem strictModeItem;
    JMenuItem chooseATargetShape;
    JMenuItem saveUpperAsTarget;
    JMenuItem saveLowerAsTarget;
    JMenu infoMenu;
    JMenuItem help;
    JMenuItem about;
    FoldingWindow upperFoldingWindow;
    FoldingWindow lowerFoldingWindow;
    HistoryList historyList;
    JScrollPane histListScrollPane;
    private boolean strictMatchingMode;
    ProteinPrinter printer;
    File outFile;
    private TargetShapeSelectionDialog targetShapeSelectionDialog;
    private TargetShapeDisplayDialog targetShapeDisplayDialog;
    private TargetShape currentTargetShape;

    public Protex(boolean isApplet) {
        super("Protein Investigator 3.0.2");
        Protex.isApplet = isApplet;
        this.addWindowListener(new ApplicationCloser());
        if (!isApplet) {
            this.printer = new ProteinPrinter();
        }
        this.outFile = null;
        this.currentTargetShape = null;
        this.strictMatchingMode = false;
        this.setupUI();
    }

    public static void main(String[] args) {
        Protex protex = new Protex(false);
        protex.pack();
        protex.setVisible(true);
    }

    private void setupUI() {
        StandardTable table = StandardTable.getInstance();
        this.topMenuPanel = new JPanel();
        this.topMenuPanel.setLayout(new BoxLayout(this.topMenuPanel, 0));
        this.menuBar = new JMenuBar();
        this.menuBar.setBorder(new BevelBorder(0));
        this.fileMenu = new JMenu("File");
        this.print = new JMenuItem("Print");
        this.fileMenu.add(this.print);
        if (!table.getContactEnergyListName().equals("")) {
            ButtonGroup group = new ButtonGroup();
            JMenu energies = new JMenu("Select Interaction Energies");
            this.standard = new JRadioButtonMenuItem("Standard Energies");
            this.custom = new JRadioButtonMenuItem(table.getContactEnergyListName());
            group.add(this.standard);
            group.add(this.custom);
            this.standard.setSelected(true);
            energies.add(this.standard);
            energies.add(this.custom);
            this.fileMenu.add(energies);
        }
        this.quit = new JMenuItem("Quit");
        this.fileMenu.add(this.quit);
        this.menuBar.add(this.fileMenu);
        this.histListMenu = new JMenu("History List");
        this.save = new JMenuItem("Save");
        this.histListMenu.add(this.save);
        this.saveAs = new JMenuItem("Save As...");
        this.histListMenu.add(this.saveAs);
        this.load = new JMenuItem("Load...");
        this.histListMenu.add(this.load);
        this.histListMenu.addSeparator();
        this.clearAll = new JMenuItem("Clear");
        this.histListMenu.add(this.clearAll);
        this.histListMenu.addSeparator();
        this.saveToHTML = new JMenuItem("Save as Web Page...");
        this.histListMenu.add(this.saveToHTML);
        this.menuBar.add(this.histListMenu);
        this.gameMenu = new JMenu("Game");
        this.strictModeItem = new JCheckBoxMenuItem("Strict Matching Mode");
        this.gameMenu.add(this.strictModeItem);
        this.chooseATargetShape = new JMenuItem("Choose a Target Shape...");
        this.gameMenu.add(this.chooseATargetShape);
        this.gameMenu.addSeparator();
        this.saveUpperAsTarget = new JMenuItem("Save Upper Protein as Target...");
        this.gameMenu.add(this.saveUpperAsTarget);
        this.saveLowerAsTarget = new JMenuItem("Save Lower Protein as Target...");
        this.gameMenu.add(this.saveLowerAsTarget);
        this.menuBar.add(this.gameMenu);
        this.menuBar.add(Box.createHorizontalGlue());
        this.infoMenu = new JMenu("Information");
        this.help = new JMenuItem("Help");
        this.infoMenu.add(this.help);
        this.about = new JMenuItem("About");
        this.infoMenu.add(this.about);
        this.menuBar.add(this.infoMenu);
        this.topMenuPanel.add(this.menuBar);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(Box.createRigidArea(new Dimension(225, 1)));
        JPanel aapPanel = new JPanel();
        aapPanel.setBorder(BorderFactory.createTitledBorder("Amino acids"));
        aapPanel.setLayout(new BoxLayout(aapPanel, 0));
        AminoAcidPalette aaPalette = new AminoAcidPalette(225, 180, 4, 5, false);
        aapPanel.setMaximumSize(new Dimension(250, 200));
        aapPanel.add(aaPalette);
        aapPanel.add(Box.createRigidArea(new Dimension(1, 180)));
        this.historyList = new HistoryList(new DefaultListModel(), this);
        this.histListScrollPane = new JScrollPane(this.historyList);
        this.histListScrollPane.setBorder(BorderFactory.createTitledBorder("History List"));
        this.histListScrollPane.setMaximumSize(new Dimension(250, 1000));
        leftPanel.add(aapPanel);
        leftPanel.add(this.histListScrollPane);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridLayout(2, 1));
        this.upperFoldingWindow = new FoldingWindow("Upper Folding Window", this);
        this.lowerFoldingWindow = new FoldingWindow("Lower Folding Window", this);
        rightPanel.add(this.upperFoldingWindow);
        rightPanel.add(this.lowerFoldingWindow);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(leftPanel);
        mainPanel.add(rightPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)this.topMenuPanel, "North");
        this.targetShapeSelectionDialog = new TargetShapeSelectionDialog(this);
        this.targetShapeDisplayDialog = new TargetShapeDisplayDialog(this);
        this.about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(null, "<html><body><center>Protein Investigator<br>Version 3.0.2<br>Copyright 2007<br>Brian White and MGX Team<br>brian.white@umb.edu</center</body></html>", "About ProtInv", 1);
            }
        });
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] all = null;
                File inFile = null;
                JFileChooser infileChooser = new JFileChooser();
                infileChooser.setFileFilter(new HistListFileFilter());
                int returnVal = infileChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    inFile = infileChooser.getSelectedFile();
                    try {
                        FileInputStream in = new FileInputStream(inFile);
                        ObjectInputStream s = new ObjectInputStream(in);
                        all = (Object[])s.readObject();
                        s.close();
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (all != null) {
                        Protex.this.historyList.clearList();
                        int i = 0;
                        while (i < all.length) {
                            Protex.this.historyList.add((FoldedPolypeptide)all[i]);
                            ++i;
                        }
                        Protex.this.histListScrollPane.revalidate();
                        Protex.this.histListScrollPane.repaint();
                    }
                }
            }
        });
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] all = Protex.this.historyList.getAll();
                if (all.length == 0) {
                    JOptionPane.showMessageDialog(null, "No History List to Save", "Blank History List", 2);
                    return;
                }
                if (Protex.this.outFile != null) {
                    Protex.this.saveToFile(Protex.this.outFile, all);
                } else {
                    Protex.this.saveToChosenFile(all);
                }
            }
        });
        this.saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] all = Protex.this.historyList.getAll();
                if (all.length == 0) {
                    JOptionPane.showMessageDialog(null, "No History List to Save", "Blank History List", 2);
                    return;
                }
                Protex.this.saveToChosenFile(all);
            }
        });
        this.clearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (JOptionPane.showConfirmDialog(null, "<html>Are you sure you want to clear the history list? <br>This cannot be undone!", "Confirm Clear", 2) == 0) {
                    Protex.this.historyList.clearList();
                }
            }
        });
        this.saveToHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File htmlDirectory = null;
                Object[] all = Protex.this.historyList.getAll();
                if (all.length == 0) {
                    JOptionPane.showMessageDialog(null, "No History List to Save", "Blank History List", 2);
                    return;
                }
                JFileChooser htmlFileChooser = new JFileChooser();
                htmlFileChooser.setDialogTitle("Choose a Folder to save the Web Page in");
                htmlFileChooser.setDialogType(1);
                int returnVal = htmlFileChooser.showSaveDialog(null);
                if (returnVal == 0) {
                    htmlDirectory = htmlFileChooser.getSelectedFile();
                    BufferedWriter htmlOutputStream = null;
                    try {
                        if (htmlDirectory.exists()) {
                            JOptionPane.showMessageDialog(null, "The Folder you selected already exists.", "Folder Already Exists", 2);
                            return;
                        }
                        try {
                            htmlDirectory.mkdirs();
                            htmlOutputStream = new BufferedWriter(new FileWriter(String.valueOf(htmlDirectory.toString()) + System.getProperty("file.separator") + "index.html"));
                            htmlOutputStream.write("<html>\n<head>\n");
                            htmlOutputStream.write("<title>History List</title>\n</head>\n");
                            htmlOutputStream.write("<body>\n");
                            htmlOutputStream.write("<h3>History List</h3>\n");
                            htmlOutputStream.write("<table border=1>\n");
                            int i = 0;
                            while (i < all.length) {
                                FoldedPolypeptide fp = (FoldedPolypeptide)all[i];
                                htmlOutputStream.write("<tr><td>");
                                htmlOutputStream.write("<b>Protein Sequence:</b>\n");
                                htmlOutputStream.write("<pre>" + fp.getAaSeq() + "</pre>\n");
                                htmlOutputStream.write("<b>Protein Structure:</b><br>\n");
                                htmlOutputStream.write("<img src=" + i + ".jpg>\n");
                                htmlOutputStream.write("</td></tr>\n");
                                ImageIcon pic = fp.getFullSizePic();
                                Image picImage = pic.getImage();
                                BufferedImage image = new BufferedImage(pic.getIconWidth(), pic.getIconHeight(), 1);
                                Graphics g = image.getGraphics();
                                g.drawImage(picImage, 0, 0, null);
                                g.dispose();
                                String jpegFileName = String.valueOf(htmlDirectory.toString()) + System.getProperty("file.separator") + i + ".jpg";
                                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(jpegFileName));
                                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                                JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
                                param.setQuality(1.0f, false);
                                encoder.setJPEGEncodeParam(param);
                                encoder.encode(image);
                                out.close();
                                ++i;
                            }
                            htmlOutputStream.write("</table></body>\n</html>\n");
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(null, "<html><body>Cannot Create Directory for Web Page Files<br>" + e.toString() + "</body></html>", "Problem Saving Files", 2);
                        }
                    }
                    finally {
                        try {
                            if (htmlOutputStream != null) {
                                htmlOutputStream.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        this.strictModeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Protex.this.strictMatchingMode = Protex.this.strictModeItem.getState();
                Protex.this.targetShapeDisplayDialog.setVisible(false);
            }
        });
        this.chooseATargetShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Protex.this.targetShapeSelectionDialog.showTargetShapeSelectionDialog();
            }
        });
        this.saveUpperAsTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Protex.this.saveAsTargetShape(Protex.this.upperFoldingWindow);
            }
        });
        this.saveLowerAsTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Protex.this.saveAsTargetShape(Protex.this.lowerFoldingWindow);
            }
        });
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Protex.this.onlineHelp();
            }
        });
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Protex.this.printer.printProteins(Protex.this.upperFoldingWindow, Protex.this.lowerFoldingWindow);
            }
        });
        this.quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (JOptionPane.showConfirmDialog(null, "Are you sure you want to quit?", "Confirm Quit", 2) == 0) {
                    System.exit(0);
                }
            }
        });
    }

    public void saveAsTargetShape(FoldingWindow fw) {
        if (fw.getOutputPalette().getDrawingPane().getGrid() == null) {
            return;
        }
        String targetName = (String)JOptionPane.showInputDialog(this, "Enter a name for this Target Shape", "Name the Target Shape", -1, null, null, null);
        if (targetName.equals("")) {
            return;
        }
        String foldingString = fw.getOutputPalette().getDrawingPane().getGrid().getPP().getDirectionSequence();
        File targetShapeFile = new File(targetShapeFileName);
        BufferedWriter targetShapeFileStream = null;
        try {
            try {
                targetShapeFileStream = new BufferedWriter(new FileWriter(targetShapeFileName, targetShapeFile.exists()));
                targetShapeFileStream.write(String.valueOf(targetName) + "," + foldingString + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (targetShapeFileStream != null) {
                        targetShapeFileStream.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (targetShapeFileStream != null) {
                    targetShapeFileStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setSelectedTargetShape(TargetShape ts) {
        this.currentTargetShape = ts;
        this.targetShapeSelectionDialog.goAway();
        this.targetShapeDisplayDialog.showTargetShapeDisplayDialog();
    }

    public TargetShape getCurrentTargetShape() {
        return this.currentTargetShape;
    }

    public void checkUpperAgainstTarget() {
        this.checkAgainstTarget(this.upperFoldingWindow);
    }

    public void checkLowerAgainstTarget() {
        this.checkAgainstTarget(this.lowerFoldingWindow);
    }

    private void checkAgainstTarget(FoldingWindow fw) {
        ShapeMatcher shapeMatcher = new ShapeMatcher(this.currentTargetShape.getShapeString(), this.strictMatchingMode);
        if (fw.getOutputPalette().getBackground().equals(Color.PINK)) {
            JOptionPane.showMessageDialog(this, "<html><body>Sorry, the protein sequence you entered<br>has not been folded yet.<br>Please click the FOLD button.</body></html>", "New Protein Not Folded Yet", 2);
            return;
        }
        if (fw.getOutputPalette().getDrawingPane().getGrid() == null) {
            JOptionPane.showMessageDialog(this, "<html><body>Sorry, there is no folded protein to match.<br>Please enter an amino acid sequence and click the FOLD button.</body></html>", "No Folded Protein", 2);
            return;
        }
        if (shapeMatcher.matchesTarget(fw.getOutputPalette().getDrawingPane().getGrid().getPP().getDirectionSequence())) {
            JOptionPane.showMessageDialog(this, "Congratulations, you got it right!", "Your Shape Matches the Target!", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Sorry, the shapes do not match.", "Shape Mismatch", 2);
        }
    }

    public boolean getStrictMatchingMode() {
        return this.strictMatchingMode;
    }

    private void onlineHelp() {
        final JEditorPane helpPane = new JEditorPane();
        helpPane.setEditable(false);
        helpPane.setContentType("text/html");
        try {
            helpPane.setPage(Protex.class.getResource("help/index1.html"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        JScrollPane helpScrollPane = new JScrollPane(helpPane);
        JDialog helpDialog = new JDialog((Frame)this, "Protein Investigator Help");
        helpDialog.getContentPane().setLayout(new BorderLayout());
        helpDialog.getContentPane().add((Component)helpScrollPane, "Center");
        Dimension screenSize = this.getToolkit().getScreenSize();
        helpDialog.setBounds(screenSize.width / 8, screenSize.height / 8, screenSize.width * 6 / 10, screenSize.height * 6 / 10);
        helpDialog.setVisible(true);
        helpPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        helpPane.setPage(e.getURL());
                    }
                    catch (IOException ioe) {
                        System.err.println(ioe.toString());
                    }
                }
            }
        });
    }

    public void addFoldedToHistList(FoldedPolypeptide fp) {
        this.historyList.add(fp);
        this.histListScrollPane.revalidate();
        this.histListScrollPane.repaint();
    }

    public void sendToUpperPanel(FoldedPolypeptide fp) {
        this.upperFoldingWindow.setFoldedPolypeptide(fp);
    }

    public void sendToLowerPanel(FoldedPolypeptide fp) {
        this.lowerFoldingWindow.setFoldedPolypeptide(fp);
    }

    public void saveToChosenFile(Object[] all) {
        JFileChooser outfileChooser = new JFileChooser();
        outfileChooser.setFileFilter(new HistListFileFilter());
        int returnVal = outfileChooser.showSaveDialog(null);
        if (returnVal == 0) {
            this.outFile = outfileChooser.getSelectedFile();
            if (!this.outFile.getName().endsWith(".histlist")) {
                this.outFile = new File(String.valueOf(this.outFile.getParent()) + System.getProperty("file.separator") + this.outFile.getName() + ".histlist");
            }
            this.saveToFile(this.outFile, all);
        }
    }

    public void saveToFile(File outFile, Object[] all) {
        try {
            FileOutputStream f = new FileOutputStream(outFile);
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(all);
            s.flush();
            s.close();
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.historyList.clearList();
        int i = 0;
        while (i < all.length) {
            this.historyList.add((FoldedPolypeptide)all[i]);
            ++i;
        }
        this.histListScrollPane.revalidate();
        this.histListScrollPane.repaint();
    }

    public FoldingWindow getUpperFoldingWindow() {
        return this.upperFoldingWindow;
    }

    class ApplicationCloser
    extends WindowAdapter {
        ApplicationCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

