/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Color;
import java.util.Iterator;
import protex.AminoAcid;
import protex.AminoAcidTable;
import protex.ColorCoder;

public class ShadingColorCoder
extends ColorCoder {
    private float maxRed = 1.0f;
    private float maxGreen = 1.0f;
    private float maxBlue = 1.0f;

    public ShadingColorCoder() {
    }

    public ShadingColorCoder(float f) {
        this();
    }

    @Override
    protected Color getCellColor(double hydrophobicIndex) {
        return this.getCellColor((float)hydrophobicIndex);
    }

    @Override
    protected Color getCellColor(float hydrophobicIndex) {
        float x = 0.99f * (1.0f - hydrophobicIndex * hydrophobicIndex * hydrophobicIndex);
        return new Color(this.maxRed * x, this.maxGreen * x, this.maxBlue * x);
    }

    public static void main(String[] args) {
        try {
            ShadingColorCoder cc = new ShadingColorCoder();
            AminoAcidTable standard = AminoAcidTable.makeTable("standard");
            Iterator i = standard.getIterator();
            while (i.hasNext()) {
                AminoAcid a = standard.get((String)i.next());
                Color color = cc.getCellColor(a.getHydrophobicIndex());
                Color opp = new Color(-color.getRGB());
                System.out.println(a + " " + color + " " + opp + " " + Integer.toHexString(color.getRGB()) + " " + Integer.toHexString(-color.getRGB()));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

