/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import protex.Protex;

public class TargetShapeDisplayDialog
extends JDialog {
    private Protex protex;
    private JPanel buttonPanel;
    private JButton checkUpperShapeButton;
    private JButton checkLowerShapeButton;
    private JButton cancelButton;

    public TargetShapeDisplayDialog(final Protex protex) {
        super(protex, "Try to Match this Target Shape", false);
        this.protex = protex;
        JPanel masterPanel = new JPanel();
        masterPanel.setLayout(new BoxLayout(masterPanel, 1));
        masterPanel.add(new PicturePanel());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        JPanel checkButtonPanel = new JPanel();
        checkButtonPanel.setLayout(new BoxLayout(checkButtonPanel, 1));
        this.checkUpperShapeButton = new JButton("Check Upper Protein for Matching Shape");
        checkButtonPanel.add(this.checkUpperShapeButton);
        this.checkLowerShapeButton = new JButton("Check Lower Protein for Matching Shape");
        checkButtonPanel.add(this.checkLowerShapeButton);
        this.buttonPanel.add(checkButtonPanel);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.cancelButton = new JButton("Cancel");
        this.buttonPanel.add(this.cancelButton);
        masterPanel.add(this.buttonPanel);
        this.getContentPane().add(masterPanel);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TargetShapeDisplayDialog.this.goAway();
            }
        });
        this.checkUpperShapeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                protex.checkUpperAgainstTarget();
            }
        });
        this.checkLowerShapeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                protex.checkLowerAgainstTarget();
            }
        });
    }

    public void showTargetShapeDisplayDialog() {
        int buttonPanelWidth = this.buttonPanel.getPreferredSize().width;
        int imageWidth = this.protex.getCurrentTargetShape().getBigPic().getIconWidth();
        this.setBounds(300, 300, Math.max(buttonPanelWidth, imageWidth), this.protex.getCurrentTargetShape().getBigPic().getIconHeight() + 60);
        this.setTitle(String.valueOf(this.protex.getCurrentTargetShape().getName()) + "; " + this.protex.getCurrentTargetShape().getNumAcids() + " amino acids.");
        this.setVisible(true);
    }

    public void goAway() {
        this.setVisible(false);
    }

    private class PicturePanel
    extends JPanel {
        PicturePanel() {
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(TargetShapeDisplayDialog.this.protex.getCurrentTargetShape().getBigPic().getImage(), 0, 0, null);
        }
    }
}

