/*
 * Decompiled with CFR 0.152.
 */
package Problems;

import GX.GenexGUI;
import Problems.GenexState;
import Problems.Problem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProblemPanel
extends JPanel {
    private static final String HTML_START = "<html><body>";
    private static final String HTML_END = "</body></html>";
    private JDialog parentDialog;
    private Problem prob;
    private GenexGUI genexGUI;
    private JLabel resultLabel;

    public ProblemPanel(JDialog parentDialog, Problem p, GenexGUI genexGUI) {
        this.parentDialog = parentDialog;
        this.prob = p;
        this.genexGUI = genexGUI;
        this.setupUI();
    }

    public void setupUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(HTML_START + this.prob.getDescription() + HTML_END), "First");
        JButton checkAnswerButton = new JButton("Check Answer");
        checkAnswerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProblemPanel.this.checkAnswer();
            }
        });
        this.add((Component)checkAnswerButton, "Last");
        this.resultLabel = new JLabel();
        this.add((Component)this.resultLabel, "Center");
    }

    public void checkAnswer() {
        GenexState state = this.genexGUI.getState();
        if (state == null) {
            return;
        }
        String result = this.prob.evaluate(state);
        if (result.equals("OK")) {
            this.remove(this.resultLabel);
            this.resultLabel = new JLabel("Correct!");
            this.resultLabel.setOpaque(true);
            this.resultLabel.setBackground(Color.GREEN);
            this.add(this.resultLabel);
            this.revalidate();
            this.repaint();
            this.parentDialog.pack();
            this.parentDialog.repaint();
        } else {
            this.remove(this.resultLabel);
            this.resultLabel = new JLabel(HTML_START + result + HTML_END);
            this.resultLabel.setOpaque(true);
            this.resultLabel.setBackground(Color.RED);
            this.add(this.resultLabel);
            this.revalidate();
            this.repaint();
            this.parentDialog.pack();
            this.parentDialog.repaint();
        }
    }
}

