/*
 * Decompiled with CFR 0.152.
 */
package GX;

import GX.DocumentRenderer;
import GX.Gene;
import GX.Genex;
import GX.GenexParams;
import GX.VisibleGene;
import Problems.GenexState;
import Problems.Problem;
import Problems.ProblemSetFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;

public class GenexGUI {
    private Problem[] problems;
    Gene workingGene;
    JTextPane textPane = new JTextPane();
    JLabel infoLabel = new JLabel("Selected Base = ");
    JButton resetButton = new JButton("Reset DNA Sequence");
    JButton newSequenceButton = new JButton("Enter New DNA Sequence");
    JButton addCaptionButton = new JButton("Enter a Caption");
    JButton printButton = new JButton("Print");
    JButton bwPrintButton = new JButton("Print in B&W");
    JButton helpButton = new JButton("Help");
    JButton aboutButton = new JButton("About");
    JButton problemSetButton = new JButton("Problem Set");
    String defaultDNA;
    String DNA;
    String promoterSequence;
    int promoterSpacing;
    String terminatorSequence;
    String intronStartSequence;
    String intronEndSequence;
    String polyATail;
    int headerLength;
    int DNASequenceLength;
    String defaultProtein;
    String defaultMaturemRNA;
    String caption;
    String previousProteinString;
    String currentProteinString;
    int caretPosition = 0;
    DocumentRenderer docRenderer;
    boolean allowPrinting = false;

    public void setupGUI(Container contentPane, GenexParams params, Problem[] problems) {
        this.defaultDNA = params.getDefaultDNA();
        this.DNA = params.getDefaultDNA();
        this.DNASequenceLength = this.DNA.length();
        this.promoterSequence = params.getPromoterSequence();
        this.promoterSpacing = params.getPromoterSpacing();
        this.terminatorSequence = params.getTerminatorSequence();
        this.intronStartSequence = params.getIntronStartSequence();
        this.intronEndSequence = params.getIntronEndSequence();
        this.polyATail = params.getPolyATail();
        this.allowPrinting = params.isAllowPrinting();
        this.problems = problems;
        if (this.intronStartSequence.equals("none") || this.intronEndSequence.equals("none")) {
            this.polyATail = "";
        }
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        scrollPane.setVerticalScrollBarPolicy(21);
        JPanel genePanel = new JPanel();
        genePanel.setLayout(new BoxLayout(genePanel, 0));
        genePanel.add(Box.createRigidArea(new Dimension(1, 300)));
        genePanel.add(scrollPane);
        JPanel sequencePanel = new JPanel();
        JPanel printPanel = new JPanel();
        if (this.allowPrinting) {
            this.docRenderer = new DocumentRenderer();
        }
        sequencePanel.add(this.resetButton);
        sequencePanel.add(this.newSequenceButton);
        sequencePanel.add(this.infoLabel);
        if (this.allowPrinting) {
            printPanel.add(this.addCaptionButton);
            printPanel.add(this.printButton);
            printPanel.add(this.bwPrintButton);
        }
        printPanel.add(this.helpButton);
        printPanel.add(this.aboutButton);
        if (problems != null) {
            printPanel.add(this.problemSetButton);
        }
        contentPane.add((Component)printPanel, "North");
        contentPane.add((Component)sequencePanel, "South");
        contentPane.add((Component)genePanel, "Center");
        this.textPane.setContentType("text/html");
        this.textPane.setDragEnabled(false);
        this.textPane.setEditable(false);
        this.addCaptionButton.setToolTipText("Add a descriptive caption to the bottom of the page.");
        this.caption = "";
        this.printButton.setToolTipText("<html>Print the page in color.<br><font color=red>This does not work well with Windows.</font></html>");
        this.bwPrintButton.setToolTipText("<html>Print the page in black and white.<br><font color=green>This works better with Windows.</font></html>");
        this.helpButton.setToolTipText("Open a window with help info.");
        this.problemSetButton.setToolTipText("Work through assigned problems");
        this.resetButton.setToolTipText("Restore the original DNA Sequence");
        this.newSequenceButton.setToolTipText("Enter an entirely new DNA sequence");
        this.caption = new String("");
        this.previousProteinString = new String("");
        this.currentProteinString = new String("");
        VisibleGene currentGene = this.expressGene(this.defaultDNA, -1);
        this.defaultMaturemRNA = currentGene.getGene()._mRNASequence;
        this.defaultProtein = currentGene.getGene()._proteinSequence;
        this.textPane.setText(String.valueOf(currentGene.getColorHTML()) + this.caption + "</pre></body></html>");
        this.headerLength = currentGene.getGene().getHeaderLength();
        this.DNASequenceLength = currentGene.getGene().getDNASequenceLength();
        this.currentProteinString = currentGene.getGene().getProteinString();
        this.textPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point pt = new Point(e.getX(), e.getY());
                int pos = GenexGUI.this.textPane.viewToModel(pt);
                int clickSite = pos - GenexGUI.this.headerLength;
                if (clickSite >= 0 && clickSite <= GenexGUI.this.DNASequenceLength) {
                    VisibleGene vg = GenexGUI.this.expressGene(GenexGUI.this.DNA, clickSite);
                    GenexGUI.this.refreshDisplay(vg, clickSite);
                    GenexGUI.this.DNASequenceLength = vg.getGene().getDNASequenceLength();
                    GenexGUI.this.caretPosition = clickSite;
                    GenexGUI.this.headerLength = vg.getGene().getHeaderLength();
                } else if (GenexGUI.this.textPane.getCaretPosition() != 0) {
                    GenexGUI.this.textPane.setCaretPosition(0);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.textPane.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                VisibleGene vg;
                StringBuffer workingDNAbuffer;
                String keyTyped = String.valueOf(e.getKeyChar());
                int keyNum = Character.getNumericValue(e.getKeyChar());
                if (keyTyped.equals("A") || keyTyped.equals("G") || keyTyped.equals("C") || keyTyped.equals("T")) {
                    GenexGUI.this.previousProteinString = GenexGUI.this.currentProteinString;
                    workingDNAbuffer = new StringBuffer(GenexGUI.this.DNA);
                    workingDNAbuffer.insert(GenexGUI.this.caretPosition, keyTyped);
                    GenexGUI.this.DNA = workingDNAbuffer.toString();
                    ++GenexGUI.this.caretPosition;
                    vg = GenexGUI.this.expressGene(GenexGUI.this.DNA, GenexGUI.this.caretPosition);
                    GenexGUI.this.refreshDisplay(vg, GenexGUI.this.caretPosition);
                    GenexGUI.this.currentProteinString = vg.getGene().getProteinString();
                    GenexGUI.this.DNASequenceLength = vg.getGene().getDNASequenceLength();
                    GenexGUI.this.headerLength = vg.getGene().getHeaderLength() + 1;
                }
                if (keyTyped.equals("a") || keyTyped.equals("g") || keyTyped.equals("c") || keyTyped.equals("t")) {
                    GenexGUI.this.previousProteinString = GenexGUI.this.currentProteinString;
                    workingDNAbuffer = new StringBuffer(GenexGUI.this.DNA);
                    workingDNAbuffer.replace(GenexGUI.this.caretPosition, GenexGUI.this.caretPosition + 1, keyTyped.toUpperCase());
                    GenexGUI.this.DNA = workingDNAbuffer.toString();
                    vg = GenexGUI.this.expressGene(GenexGUI.this.DNA, GenexGUI.this.caretPosition);
                    GenexGUI.this.refreshDisplay(vg, GenexGUI.this.caretPosition);
                    GenexGUI.this.currentProteinString = vg.getGene().getProteinString();
                    GenexGUI.this.DNASequenceLength = vg.getGene().getDNASequenceLength();
                    GenexGUI.this.headerLength = vg.getGene().getHeaderLength() + 1;
                }
                if (keyNum == -1) {
                    GenexGUI.this.previousProteinString = GenexGUI.this.currentProteinString;
                    workingDNAbuffer = new StringBuffer(GenexGUI.this.DNA);
                    workingDNAbuffer.deleteCharAt(GenexGUI.this.caretPosition);
                    GenexGUI.this.DNA = workingDNAbuffer.toString();
                    if (GenexGUI.this.caretPosition >= 0) {
                        --GenexGUI.this.caretPosition;
                    }
                    vg = GenexGUI.this.expressGene(GenexGUI.this.DNA, GenexGUI.this.caretPosition);
                    GenexGUI.this.refreshDisplay(vg, GenexGUI.this.caretPosition);
                    GenexGUI.this.currentProteinString = vg.getGene().getProteinString();
                    GenexGUI.this.DNASequenceLength = vg.getGene().getDNASequenceLength();
                    GenexGUI.this.headerLength = vg.getGene().getHeaderLength();
                }
                if (keyTyped.equals("+") || keyTyped.equals("-") || keyTyped.equals("=")) {
                    if (keyTyped.equals("+") || keyTyped.equals("=")) {
                        ++GenexGUI.this.caretPosition;
                        if (GenexGUI.this.caretPosition > GenexGUI.this.DNA.length() - 1) {
                            GenexGUI.this.caretPosition = GenexGUI.this.DNA.length() - 1;
                        }
                    } else {
                        --GenexGUI.this.caretPosition;
                        if (GenexGUI.this.caretPosition < 0) {
                            GenexGUI.this.caretPosition = 0;
                        }
                    }
                    VisibleGene vg2 = GenexGUI.this.expressGene(GenexGUI.this.DNA, GenexGUI.this.caretPosition);
                    GenexGUI.this.refreshDisplay(vg2, GenexGUI.this.caretPosition);
                    GenexGUI.this.DNASequenceLength = vg2.getGene().getDNASequenceLength();
                    GenexGUI.this.headerLength = vg2.getGene().getHeaderLength() + 1;
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                VisibleGene vg;
                if (e.getKeyCode() == 39) {
                    ++GenexGUI.this.caretPosition;
                    if (GenexGUI.this.caretPosition > GenexGUI.this.DNA.length() - 1) {
                        GenexGUI.this.caretPosition = GenexGUI.this.DNA.length() - 1;
                    }
                    vg = GenexGUI.this.expressGene(GenexGUI.this.DNA, GenexGUI.this.caretPosition);
                    GenexGUI.this.refreshDisplay(vg, GenexGUI.this.caretPosition);
                    GenexGUI.this.DNASequenceLength = vg.getGene().getDNASequenceLength();
                    GenexGUI.this.headerLength = vg.getGene().getHeaderLength() + 1;
                }
                if (e.getKeyCode() == 37) {
                    --GenexGUI.this.caretPosition;
                    if (GenexGUI.this.caretPosition < 0) {
                        GenexGUI.this.caretPosition = 0;
                    }
                    vg = GenexGUI.this.expressGene(GenexGUI.this.DNA, GenexGUI.this.caretPosition);
                    GenexGUI.this.refreshDisplay(vg, GenexGUI.this.caretPosition);
                    GenexGUI.this.DNASequenceLength = vg.getGene().getDNASequenceLength();
                    GenexGUI.this.headerLength = vg.getGene().getHeaderLength() + 1;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenexGUI.this.DNA = GenexGUI.this.defaultDNA;
                VisibleGene currentGene = GenexGUI.this.expressGene(GenexGUI.this.DNA, -1);
                GenexGUI.this.refreshDisplay(currentGene, -1);
                GenexGUI.this.currentProteinString = currentGene.getGene().getProteinString();
                GenexGUI.this.headerLength = currentGene.getGene().getHeaderLength();
                GenexGUI.this.DNASequenceLength = currentGene.getGene().getDNASequenceLength();
                GenexGUI.this.headerLength = currentGene.getGene().getHeaderLength();
            }
        });
        this.newSequenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newDNA = (String)JOptionPane.showInputDialog(null, "Enter new DNA Sequence", "New DNA Sequence", -1, null, null, GenexGUI.this.DNA);
                if (newDNA == null) {
                    return;
                }
                GenexGUI.this.previousProteinString = GenexGUI.this.currentProteinString;
                newDNA = newDNA.toUpperCase();
                GenexGUI.this.DNA = newDNA = newDNA.replaceAll("[^AGCT]", "");
                GenexGUI.this.caretPosition = -1;
                VisibleGene currentGene = GenexGUI.this.expressGene(GenexGUI.this.DNA, -1);
                GenexGUI.this.refreshDisplay(currentGene, -1);
                GenexGUI.this.currentProteinString = currentGene.getGene().getProteinString();
                GenexGUI.this.headerLength = currentGene.getGene().getHeaderLength();
                GenexGUI.this.DNASequenceLength = currentGene.getGene().getDNASequenceLength();
                GenexGUI.this.headerLength = currentGene.getGene().getHeaderLength();
            }
        });
        if (this.allowPrinting) {
            this.addCaptionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenexGUI.this.caption = (String)JOptionPane.showInputDialog(null, "Enter a Caption for this page.", "Caption:", -1, null, null, GenexGUI.this.caption);
                    if (GenexGUI.this.caption == null) {
                        return;
                    }
                    VisibleGene currentGene = GenexGUI.this.expressGene(GenexGUI.this.DNA, -1);
                    GenexGUI.this.refreshDisplay(currentGene, -1);
                    GenexGUI.this.headerLength = currentGene.getGene().getHeaderLength();
                    GenexGUI.this.DNASequenceLength = currentGene.getGene().getDNASequenceLength();
                    GenexGUI.this.headerLength = currentGene.getGene().getHeaderLength();
                }
            });
        }
        if (this.allowPrinting) {
            this.printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenexGUI.this.docRenderer.setScaleWidthToFit(true);
                    HTMLDocument htdoc = (HTMLDocument)GenexGUI.this.textPane.getDocument();
                    GenexGUI.this.docRenderer.print(htdoc);
                }
            });
        }
        if (this.allowPrinting) {
            this.bwPrintButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenexGUI.this.docRenderer.setScaleWidthToFit(true);
                    JTextPane bwPane = new JTextPane();
                    bwPane.setContentType("text/html");
                    VisibleGene currentGene = GenexGUI.this.expressGene(GenexGUI.this.DNA, GenexGUI.this.caretPosition);
                    bwPane.setText(String.valueOf(currentGene.getBwHTML()) + "\n" + GenexGUI.this.caption);
                    HTMLDocument htdoc = (HTMLDocument)bwPane.getDocument();
                    GenexGUI.this.docRenderer.print(htdoc);
                }
            });
        }
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL url = Genex.class.getResource("fig1.gif");
                ImageIcon pic = new ImageIcon(url);
                JOptionPane.showMessageDialog(null, "<html><body>Click the top strand of DNA to select a base.<br>Move <u>right</u> with + or right-arrow<br>Move <u>left</u> with - or left-arrow<br><u>Delete</u> a base with the Delete or Backspace Key.<br><u>Insert</u> a base with A, G, C, or T.<br><u>Replace</u> a base with a, g, c, or t.<br></body></html>", "Genex Help", -1, pic);
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "<html><body><center>Gene Explorer Version " + Genex.version + "<br>" + "<br>" + "Brian White (2011)<br>" + "brian.white@umb.edu" + "</body></html>", "About Genex", -1);
            }
        });
        this.problemSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenexGUI.this.workProblems();
            }
        });
    }

    public VisibleGene expressGene(String currentDNA, int selectedDNABase) {
        Gene currentGene = new Gene(currentDNA, this.promoterSequence, this.promoterSpacing, this.terminatorSequence, this.intronStartSequence, this.intronEndSequence, this.polyATail);
        currentGene.transcribe();
        currentGene.process();
        currentGene.translate();
        return new VisibleGene(currentGene.generateHTML(selectedDNABase), currentGene);
    }

    public void refreshDisplay(VisibleGene vg, int selectedBase) {
        if (selectedBase != -1) {
            this.infoLabel.setText("Selected Base = " + selectedBase);
        } else {
            this.infoLabel.setText("Selected Base = ");
        }
        this.textPane.setText(String.valueOf(vg.getColorHTML()) + "<font color=blue>" + this.previousProteinString + "</font></pre><br><br><br><font size=+1>" + this.caption + "</font></body></html>");
        this.workingGene = vg.theGene;
        this.textPane.setCaretPosition(0);
    }

    private void workProblems() {
        JDialog problemSetDialog = new JDialog();
        problemSetDialog.setTitle("Problem Set");
        problemSetDialog.add(ProblemSetFactory.buildProblemSet(problemSetDialog, this, this.problems));
        problemSetDialog.pack();
        problemSetDialog.setVisible(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        problemSetDialog.setLocation((screenSize.width - problemSetDialog.getWidth()) / 2, screenSize.height / 2);
    }

    public GenexState getState() {
        if (this.workingGene == null) {
            JOptionPane.showMessageDialog(null, "<html>It is too soon to check your answer;<br>please select a base, make a change, etc.</html>", "Problem Set Error", 2);
            return null;
        }
        return new GenexState(this.defaultDNA, this.defaultMaturemRNA, this.defaultProtein, this.caretPosition, this.DNA, this.workingGene._numberOfExons, this.workingGene._mRNASequence, this.workingGene._proteinSequence);
    }
}

