This is the main edX platform which consists of LMS and Studio.

See [code.edx.org](http://code.edx.org/) for other parts of the edX code base.

Installation
------------

Please refer to the following wiki pages in our [configuration repo](https://github.com/edx/configuration) to install edX:

* [edX Developer Stack](https://github.com/edx/configuration/wiki/edX-Developer-Stack)
<br/>These instructions are for developers who want to contribute or make changes to the edX source code.
* [edX Production Stack](https://github.com/edx/configuration/wiki/edX-Production-Stack)
<br/>Using Vagrant/Virtualbox this will setup all edX services on a single server in a production like configuration.
* [edX Ubuntu 12.04 64-bit Installation](https://github.com/edx/configuration/wiki/edX-Ubuntu-12.04-64-bit-Installation)
<br/>This will install edX on an existing Ubuntu 12.04 server.


License
-------

The code in this repository is licensed under version 3 of the AGPL unless
otherwise noted. Please see the
[`LICENSE`](https://github.com/edx/edx-platform/blob/master/LICENSE) file
for details.

Documentation
-------------

Documentation for developers, researchers, and course staff is located in the
`docs` subdirectory. Documentation is built using
[Sphinx](http://sphinx-doc.org/): you can [view the built documentation on
ReadTheDocs](http://docs.edx.org/).

Getting Help
------------

If you're having trouble, we have several different mailing lists where you can
ask for help:

* [openedx-ops](https://groups.google.com/forum/#!forum/openedx-ops):
  everything related to *running* Open edX. This includes
  installation issues, server management, cost analysis, and so on.
* [openedx-translation](https://groups.google.com/forum/#!forum/openedx-translation):
  everything related to *translating* Open edX into
  other languages. This includes volunteer translators, our internationalization
  infrastructure, issues related to Transifex, and so on.
* [openedx-analytics](https://groups.google.com/forum/#!forum/openedx-analytics):
  everything related to *analytics* in Open edX.
* [edx-code](https://groups.google.com/forum/#!forum/edx-code):
  everything related to the *code* in Open edX. This includes
  feature requests, idea proposals, refactorings, and so on.

You can also join our IRC channel: [`#edx-code` on Freenode](http://webchat.freenode.net/?channels=edx-code).

Issue Tracker
-------------

[We use JIRA for our issue tracker](https://openedx.atlassian.net/), not
GitHub Issues. To file a bug or request a new feature, please make a free
account on our JIRA and create a new issue! If you're filing a bug,
we'd appreciate it if you would follow
[our guidelines for filing high-quality, actionable bug reports](https://openedx.atlassian.net/wiki/display/SUST/How+to+File+a+Quality+Bug+Report).
Thanks!

How to Contribute
-----------------

Contributions are very welcome, but for legal reasons, you must submit a signed
[individual contributor's agreement](http://code.edx.org/individual-contributor-agreement.pdf)
before we can accept your contribution. See our
[CONTRIBUTING](https://github.com/edx/edx-platform/blob/master/CONTRIBUTING.rst)
file for more information -- it also contains guidelines for how to maintain
high code quality, which will make your contribution more likely to be accepted.

Reporting Security Issues
-------------------------

Please do not report security issues in public. Please email security@edx.org
