/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import protex.AcidInChain;
import protex.Direction;
import protex.GridPoint;
import protex.Polypeptide;

public abstract class Grid
implements Serializable {
    public static final int STRAIGHT = 0;
    public static final int BENT = 1;
    protected int numAcids;
    protected int size;
    protected Polypeptide pp;
    private int tieBreaker = 0;
    public Map directionMap = null;
    public Map straightMap;
    public Map bentMap;
    protected ArrayList ssBondList;
    protected AcidInChain[] acids;
    protected Direction[] allDirections = null;
    protected double energy;
    protected int freeEdges;

    public Grid() {
    }

    public Grid(Polypeptide pp) {
        this.pp = pp;
        this.numAcids = pp.getLength();
        this.acids = pp.getAcidArray();
        this.size = 2 * this.numAcids + 1;
        this.ssBondList = new ArrayList();
    }

    public int getSize() {
        return this.size;
    }

    public Polypeptide getPP() {
        return this.pp;
    }

    public ArrayList getssBondList() {
        return this.ssBondList;
    }

    protected Direction getFirstDirection() {
        return Direction.E;
    }

    public double getInfiniteEnergy() {
        return Double.MAX_VALUE;
    }

    protected abstract Direction[] getDirectionRing3();

    protected int getNumDirections() {
        return this.getDirectionRing3().length / 3;
    }

    public void setNextDirections() {
        this.setTieBreaker(this.tieBreaker);
    }

    public void setTieBreaker(int tieBreaker) {
        this.tieBreaker = tieBreaker;
        this.directionMap = tieBreaker == 0 ? this.straightMap : this.bentMap;
    }

    private Direction[] reverse(Direction[] array) {
        int n = array.length;
        Direction[] rev = new Direction[n];
        int i = 0;
        while (i < n) {
            rev[i] = array[n - 1 - i];
            ++i;
        }
        return rev;
    }

    public void setNextDirectionsStraight() {
        this.straightMap = new HashMap();
        int numDirections = this.getNumDirections();
        Direction[] ring = this.getDirectionRing3();
        int i = numDirections;
        while (i < 2 * numDirections) {
            Direction[] next = new Direction[numDirections - 1];
            next[0] = ring[i];
            int j = 1;
            while (j < numDirections / 2) {
                next[2 * j - 1] = ring[i + j];
                next[2 * j] = ring[i - j];
                ++j;
            }
            this.straightMap.put(ring[i], next);
            ++i;
        }
    }

    public void setNextDirectionsBent() {
        this.bentMap = new HashMap();
        for (Object direction : this.straightMap.keySet()) {
            Direction[] stuff = (Direction[])this.straightMap.get(direction);
            this.bentMap.put(direction, this.reverse(stuff));
        }
    }

    public abstract GridPoint getCenter();

    public abstract void set(int var1, GridPoint var2, Direction var3);

    protected abstract void unset(GridPoint var1);

    protected abstract void unset(GridPoint var1, int var2);

    protected void unsetAll() {
        int i = 0;
        while (i < this.numAcids) {
            this.unset(this.acids[i]);
            ++i;
        }
    }

    protected abstract void unset(AcidInChain var1);

    protected abstract AcidInChain get(GridPoint var1);

    protected abstract Direction getDirection(GridPoint var1, GridPoint var2);

    protected abstract Direction[] getAllDirections();

    protected abstract GridPoint nextCell(Direction var1, GridPoint var2);

    public abstract Direction[] getThirdPlacement();

    public double getEnergy(boolean custom, double hpIndex, double hIndex, double iIndex, double sIndex) {
        this.energy = 0.0;
        this.freeEdges = 0;
        if (custom) {
            System.out.println("Can't do unimplemented custom energy on non hex grid!");
        } else {
            int i = 0;
            while (i < this.numAcids) {
                AcidInChain a = this.acids[i];
                if (a.xyz != null) {
                    int free = 0;
                    int d = 0;
                    while (d < this.allDirections.length) {
                        if (this.get(this.nextCell(this.allDirections[d], a.xyz)) == null) {
                            ++free;
                        }
                        ++d;
                    }
                    this.energy += (double)free * a.hydrophobicIndex;
                    this.freeEdges += free;
                }
                ++i;
            }
        }
        return this.energy;
    }

    public double getFoldingIndex(boolean custom, double hpIndex, double hIndex, double iIndex, double sIndex) {
        this.computeStatistics(custom, hpIndex, hIndex, iIndex, sIndex);
        return (double)this.freeEdges / (double)(2 + 4 * this.pp.getLength());
    }

    public int getFreeEdges(boolean custom, double hpIndex, double hIndex, double iIndex, double sIndex) {
        this.computeStatistics(custom, hpIndex, hIndex, iIndex, sIndex);
        return this.freeEdges;
    }

    public void computeStatistics(boolean custom, double hpIndex, double hIndex, double iIndex, double sIndex) {
        this.getEnergy(custom, hpIndex, hIndex, iIndex, sIndex);
        this.setNeighbors();
    }

    public void setNeighbors() {
        this.pp.clearTopology();
        int i = 0;
        while (i < this.numAcids) {
            this.setNeighbors(this.acids[i]);
            ++i;
        }
    }

    public boolean isLastAcidPlaced() {
        return this.acids[this.numAcids - 1].xyz != null;
    }

    protected void setNeighbors(AcidInChain to) {
        GridPoint p = to.xyz;
        if (p == null) {
            return;
        }
        int d = 0;
        while (d < this.allDirections.length) {
            this.setNeighbor(to, p, this.allDirections[d]);
            ++d;
        }
    }

    protected void setNeighbor(AcidInChain to, GridPoint p, Direction d) {
        AcidInChain from = this.get(this.nextCell(d, p));
        if (from != null) {
            this.pp.addNeighbor(to, from);
        }
    }

    public Direction[] getNextDirection(Direction d) {
        return (Direction[])this.directionMap.get(d);
    }
}

