/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import protex.FoldingWindow;

public class ProteinPrinter
implements Printable {
    PageFormat pformat = new PageFormat();
    PrinterJob pJob;
    String upperAASeq;
    String lowerAASeq;
    BufferedImage upperProtein;
    BufferedImage lowerProtein;
    FoldingWindow ufw;
    FoldingWindow lfw;
    private static int printedWidth = 500;
    private static int printedHeight = 250;

    public ProteinPrinter() {
        this.pformat.setOrientation(1);
        this.pJob = PrinterJob.getPrinterJob();
        this.upperAASeq = "";
        this.lowerAASeq = "";
        this.ufw = null;
        this.lfw = null;
        this.upperProtein = null;
        this.lowerProtein = null;
    }

    public void printProteins(FoldingWindow ufw, FoldingWindow lfw) {
        if (ufw.getFullSizePic() == null && lfw.getFullSizePic() == null) {
            JOptionPane.showMessageDialog(null, "No Proteins to Print!", "Printer Warning", 0);
            return;
        }
        if (ufw.getFullSizePic() != null) {
            this.ufw = ufw;
            this.upperAASeq = ufw.getAaSeq();
            this.upperProtein = ufw.getFullSizePic();
        }
        if (lfw.getFullSizePic() != null) {
            this.lfw = lfw;
            this.lowerAASeq = lfw.getAaSeq();
            this.lowerProtein = lfw.getFullSizePic();
        }
        if (this.pJob.printDialog()) {
            this.pJob.setPrintable(this, this.pformat);
            try {
                this.pJob.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2d = (Graphics2D)g;
        if (pageIndex == 0) {
            g2d.translate(pf.getImageableX(), pf.getImageableY());
            if (this.ufw != null) {
                g2d.drawString(this.upperAASeq, 0, 20);
                g2d.drawImage(this.upperProtein, 0, 40, (int)((double)this.upperProtein.getWidth() / this.getScale(this.upperProtein)), (int)((double)this.upperProtein.getHeight() / this.getScale(this.upperProtein)), null);
            }
            if (this.lfw != null) {
                g2d.drawString(this.lowerAASeq, 0, 320);
                g2d.drawImage(this.lowerProtein, 0, 340, (int)((double)this.lowerProtein.getWidth() / this.getScale(this.lowerProtein)), (int)((double)this.lowerProtein.getHeight() / this.getScale(this.lowerProtein)), null);
            }
            return 0;
        }
        return 1;
    }

    private double getScale(BufferedImage image) {
        int imageHeight;
        double verticalScale;
        int imageWidth = image.getWidth(null);
        double horizontalScale = (double)imageWidth / (double)printedWidth;
        if (horizontalScale > (verticalScale = (double)(imageHeight = image.getHeight(null)) / (double)printedHeight)) {
            return horizontalScale;
        }
        return verticalScale;
    }
}

