/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.util.ArrayList;
import java.util.StringTokenizer;
import protex.AminoAcid;
import protex.AminoAcidTable;
import protex.Direction;
import protex.FoldingException;
import protex.IntegerFormatFoldingException;
import protex.Polypeptide;

public class PolypeptideFactory {
    private static PolypeptideFactory instance;
    private static final char[] DELIMITERS;

    static {
        DELIMITERS = new char[]{':', ','};
    }

    public static PolypeptideFactory getInstance() {
        if (instance == null) {
            instance = new PolypeptideFactory();
        }
        return instance;
    }

    public Polypeptide createPolypeptide(String[] args, boolean isSolution, boolean isRandom, String length, String seed, String tableName, int numAALetterCode, String ppId) throws FoldingException {
        return this.createPolypeptide(PolypeptideFactory.arrayToString(args), isSolution, isRandom, length, seed, tableName, numAALetterCode, ppId);
    }

    public Polypeptide createPolypeptide(String input, boolean isSolution, boolean isRandom, String length, String seed, String tableName, int numAALetterCode, String ppId) throws FoldingException {
        if (isSolution) {
            return this.createSolution(tableName, numAALetterCode, input, ppId);
        }
        if (isRandom) {
            return this.createRandom(tableName, length, seed, ppId);
        }
        return this.createFromAcids(tableName, numAALetterCode, input, ppId);
    }

    public Polypeptide createSolution(String tableName, int numAALetterCode, String input, String ppId) throws FoldingException {
        AminoAcidTable table = this.createTable(tableName);
        ArrayList acidString = this.getTokens(input);
        int numberOfTokens = acidString.size();
        int acidIndex = 0;
        int directionIndex = 0;
        AminoAcid[] acids = new AminoAcid[numberOfTokens / 2];
        Direction[] directions = new Direction[numberOfTokens / 2];
        int i = 0;
        while (i < numberOfTokens) {
            acids[acidIndex++] = this.parseAcid((String)acidString.get(i), table, numAALetterCode);
            directions[directionIndex++] = this.parseDirection((String)acidString.get(i + 1));
            i += 2;
        }
        return new Polypeptide(table, acids, directions, ppId);
    }

    public Polypeptide createRandom(String tableName, String length, String seed, String ppId) throws FoldingException {
        int len = 0;
        int s = -1;
        try {
            len = Integer.parseInt(length);
        }
        catch (NumberFormatException e) {
            throw new IntegerFormatFoldingException("Length: REQUIRED: integer GIVEN: " + length);
        }
        try {
            s = Integer.parseInt(seed);
        }
        catch (NumberFormatException e) {
            throw new IntegerFormatFoldingException("Seed:  REQUIRED: integer GIVEN: " + seed);
        }
        if (len < 1) {
            throw new IntegerFormatFoldingException("Length: REQUIRED: > 0 GIVEN: " + length);
        }
        if (s < 0) {
            throw new IntegerFormatFoldingException("Seed: REQUIRED:  >=0 GIVEN: " + seed);
        }
        return new Polypeptide(this.createTable(tableName), len, s, ppId);
    }

    public Polypeptide createFromAcids(String tableName, int numAALetterCode, String input, String ppId) throws FoldingException {
        AminoAcid[] acids;
        AminoAcidTable table = this.createTable(tableName);
        switch (numAALetterCode) {
            case 1: {
                char[] letters = input.toCharArray();
                acids = new AminoAcid[letters.length];
                int i = 0;
                while (i < letters.length) {
                    acids[i] = this.parseAcid(String.valueOf(letters[i]), table, numAALetterCode);
                    ++i;
                }
                break;
            }
            case 3: {
                ArrayList acidString = this.getTokens(input);
                acids = new AminoAcid[acidString.size()];
                int i = 0;
                while (i < acids.length) {
                    acids[i] = this.parseAcid((String)acidString.get(i), table, numAALetterCode);
                    ++i;
                }
                break;
            }
            default: {
                Object acids2 = null;
                throw new FoldingException("nonexistent number of letters in AA code " + numAALetterCode);
            }
        }
        return new Polypeptide(table, acids, ppId);
    }

    public ArrayList getTokens(String input) {
        int i = 0;
        while (i < DELIMITERS.length) {
            input = input.replace(DELIMITERS[i], ' ');
            ++i;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens;
    }

    public AminoAcid parseAcid(String acidString, AminoAcidTable table, int numAALetterCode) throws FoldingException {
        AminoAcid acid;
        switch (numAALetterCode) {
            case 1: {
                acid = table.getFromAbName(acidString);
                break;
            }
            case 3: {
                acid = table.get(acidString);
                break;
            }
            default: {
                Object acid2 = null;
                throw new FoldingException("nonexistent number of letters in AA code " + numAALetterCode);
            }
        }
        if (acid == null) {
            throw new FoldingException("acid not found. ACID: " + acidString + " TABLE: " + table.getName());
        }
        return acid;
    }

    public Direction parseDirection(String directionString) throws FoldingException {
        if (directionString.trim().equalsIgnoreCase("none")) {
            return Direction.none;
        }
        Direction direction = Direction.getDirection(directionString);
        if (direction == Direction.none) {
            throw new FoldingException("direction not found. DIRECTION:  " + directionString);
        }
        return direction;
    }

    private PolypeptideFactory() {
    }

    private static String arrayToString(String[] listOfIndices) {
        String s = "";
        int i = 0;
        while (i < listOfIndices.length) {
            s = String.valueOf(s) + listOfIndices[i] + " ";
            ++i;
        }
        return s;
    }

    private AminoAcidTable createTable(String tableName) throws FoldingException {
        AminoAcidTable table = AminoAcidTable.makeTable(tableName);
        return table;
    }
}

