/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import protex.Protex;
import protex.TargetShape;
import protex.TargetShapeCellRenderer;

public class TargetShapeList
extends JList {
    DefaultListModel targetShapeListDataModel;

    public TargetShapeList(ListModel dataModel, final Protex protex) {
        super(dataModel);
        this.setSelectionMode(0);
        this.setCellRenderer(new TargetShapeCellRenderer());
        this.targetShapeListDataModel = (DefaultListModel)dataModel;
        this.setFixedCellWidth(20);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    protex.setSelectedTargetShape((TargetShape)((TargetShapeList)evt.getSource()).getSelectedValue());
                }
            }
        });
    }

    public void add(TargetShape ts) {
        this.targetShapeListDataModel.addElement(ts);
    }

    public void deleteSelected() {
        if (this.getSelectedIndex() != -1) {
            this.targetShapeListDataModel.removeElementAt(this.getSelectedIndex());
        } else {
            JOptionPane.showMessageDialog(null, "You have not selected an item to delete.", "None Selected", 2);
        }
    }

    public void clearList() {
        this.targetShapeListDataModel.removeAllElements();
    }

    public Object[] getAll() {
        return this.targetShapeListDataModel.toArray();
    }
}

