// Generated by CoffeeScript 1.3.3
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  this.VideoSpeedControl = (function() {

    function VideoSpeedControl(player, speeds) {
      this.player = player;
      this.speeds = speeds;
      this.onSpeedChange = __bind(this.onSpeedChange, this);

      this.changeVideoSpeed = __bind(this.changeVideoSpeed, this);

      this.render();
      this.bind();
    }

    VideoSpeedControl.prototype.$ = function(selector) {
      return this.player.$(selector);
    };

    VideoSpeedControl.prototype.bind = function() {
      $(this.player).bind('speedChange', this.onSpeedChange);
      this.$('.video_speeds a').click(this.changeVideoSpeed);
      if (onTouchBasedDevice()) {
        return this.$('.speeds').click(function() {
          return $(this).toggleClass('open');
        });
      } else {
        this.$('.speeds').mouseenter(function() {
          return $(this).addClass('open');
        });
        this.$('.speeds').mouseleave(function() {
          return $(this).removeClass('open');
        });
        return this.$('.speeds').click(function(event) {
          event.preventDefault();
          return $(this).removeClass('open');
        });
      }
    };

    VideoSpeedControl.prototype.render = function() {
      var _this = this;
      this.$('.secondary-controls').prepend("<div class=\"speeds\">\n  <a href=\"#\">\n    <h3>Speed</h3>\n    <p class=\"active\"></p>\n  </a>\n  <ol class=\"video_speeds\"></ol>\n</div>");
      $.each(this.speeds, function(index, speed) {
        var link;
        link = $('<a>').attr({
          href: "#"
        }).html("" + speed + "x");
        return _this.$('.video_speeds').prepend($('<li>').attr('data-speed', speed).html(link));
      });
      return this.setSpeed(this.player.currentSpeed());
    };

    VideoSpeedControl.prototype.changeVideoSpeed = function(event) {
      event.preventDefault();
      if (!$(event.target).parent().hasClass('active')) {
        return $(this.player).trigger('speedChange', $(event.target).parent().data('speed'));
      }
    };

    VideoSpeedControl.prototype.onSpeedChange = function(event, speed) {
      return this.setSpeed(parseFloat(speed).toFixed(2).replace(/\.00$/, '.0'));
    };

    VideoSpeedControl.prototype.setSpeed = function(speed) {
      this.$('.video_speeds li').removeClass('active');
      this.$(".video_speeds li[data-speed='" + speed + "']").addClass('active');
      return this.$('.speeds p.active').html("" + speed + "x");
    };

    return VideoSpeedControl;

  })();

}).call(this);
