// Generated by CoffeeScript 1.3.3
(function() {

  this.Video = (function() {

    function Video(id, videos) {
      var _this = this;
      this.id = id;
      window.player = null;
      this.element = $("#video_" + this.id);
      this.parseVideos(videos);
      this.fetchMetadata();
      this.parseSpeed();
      $("#video_" + this.id).data('video', this);
      if (YT.Player) {
        this.embed();
      } else {
        window.onYouTubePlayerAPIReady = function() {
          return $('.course-content .video').each(function() {
            return $(this).data('video').embed();
          });
        };
      }
    }

    Video.prototype.youtubeId = function(speed) {
      return this.videos[speed || this.speed];
    };

    Video.prototype.parseVideos = function(videos) {
      var _this = this;
      this.videos = {};
      return $.each(videos.split(/,/), function(index, video) {
        var speed;
        video = video.split(/:/);
        speed = parseFloat(video[0]).toFixed(2).replace(/\.00$/, '.0');
        return _this.videos[speed] = video[1];
      });
    };

    Video.prototype.parseSpeed = function() {
      this.setSpeed($.cookie('video_speed'));
      return this.speeds = ($.map(this.videos, function(url, speed) {
        return speed;
      })).sort();
    };

    Video.prototype.setSpeed = function(newSpeed) {
      if (this.videos[newSpeed] !== void 0) {
        this.speed = newSpeed;
        return $.cookie('video_speed', "" + newSpeed, {
          expires: 3650,
          path: '/'
        });
      } else {
        return this.speed = '1.0';
      }
    };

    Video.prototype.embed = function() {
      return this.player = new VideoPlayer(this);
    };

    Video.prototype.fetchMetadata = function(url) {
      var _this = this;
      this.metadata = {};
      return $.each(this.videos, function(speed, url) {
        return $.get("http://gdata.youtube.com/feeds/api/videos/" + url + "?v=2&alt=jsonc", (function(data) {
          return _this.metadata[data.data.id] = data.data;
        }), 'jsonp');
      });
    };

    Video.prototype.getDuration = function() {
      return this.metadata[this.youtubeId()].duration;
    };

    return Video;

  })();

}).call(this);
