// Generated by CoffeeScript 1.3.3
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  this.VideoCaption = (function() {

    function VideoCaption(player, youtubeId) {
      this.player = player;
      this.youtubeId = youtubeId;
      this.toggle = __bind(this.toggle, this);

      this.seekPlayer = __bind(this.seekPlayer, this);

      this.onMouseLeave = __bind(this.onMouseLeave, this);

      this.onMovement = __bind(this.onMovement, this);

      this.onMouseEnter = __bind(this.onMouseEnter, this);

      this.onWindowResize = __bind(this.onWindowResize, this);

      this.onUpdatePlayTime = __bind(this.onUpdatePlayTime, this);

      this.render();
      this.bind();
    }

    VideoCaption.prototype.$ = function(selector) {
      return this.player.$(selector);
    };

    VideoCaption.prototype.bind = function() {
      $(window).bind('resize', this.onWindowResize);
      $(this.player).bind('resize', this.onWindowResize);
      $(this.player).bind('updatePlayTime', this.onUpdatePlayTime);
      this.$('.hide-subtitles').click(this.toggle);
      return this.$('.subtitles').mouseenter(this.onMouseEnter).mouseleave(this.onMouseLeave).mousemove(this.onMovement).bind('mousewheel', this.onMovement).bind('DOMMouseScroll', this.onMovement);
    };

    VideoCaption.prototype.captionURL = function() {
      return "/static/subs/" + this.youtubeId + ".srt.sjson";
    };

    VideoCaption.prototype.render = function() {
      this.$('.video-wrapper').after("<ol class=\"subtitles\"><li>Attempting to load captions...</li></ol>");
      this.$('.video-controls .secondary-controls').append("<a href=\"#\" class=\"hide-subtitles\" title=\"Turn off captions\">Captions</a>");
      this.$('.subtitles').css({
        maxHeight: this.$('.video-wrapper').height() - 5
      });
      return this.fetchCaption();
    };

    VideoCaption.prototype.fetchCaption = function() {
      var _this = this;
      return $.getWithPrefix(this.captionURL(), function(captions) {
        _this.captions = captions.text;
        _this.start = captions.start;
        return _this.renderCaption();
      });
    };

    VideoCaption.prototype.renderCaption = function() {
      var container,
        _this = this;
      container = $('<ol>');
      $.each(this.captions, function(index, text) {
        return container.append($('<li>').html(text).attr({
          'data-index': index,
          'data-start': _this.start[index]
        }));
      });
      this.$('.subtitles').html(container.html());
      this.$('.subtitles li[data-index]').click(this.seekPlayer);
      return this.$('.subtitles').prepend($('<li class="spacing">').height(this.topSpacingHeight())).append($('<li class="spacing">').height(this.bottomSpacingHeight()));
    };

    VideoCaption.prototype.search = function(time) {
      var index, max, min;
      min = 0;
      max = this.start.length - 1;
      while (min < max) {
        index = Math.ceil((max + min) / 2);
        if (time < this.start[index]) {
          max = index - 1;
        }
        if (time >= this.start[index]) {
          min = index;
        }
      }
      return min;
    };

    VideoCaption.prototype.onUpdatePlayTime = function(event, time) {
      var newIndex;
      time = Math.round(Time.convert(time, this.player.currentSpeed(), '1.0') * 1000 + 250);
      newIndex = this.search(time);
      if (newIndex !== void 0 && this.currentIndex !== newIndex) {
        if (this.currentIndex) {
          this.$(".subtitles li.current").removeClass('current');
        }
        this.$(".subtitles li[data-index='" + newIndex + "']").addClass('current');
        this.currentIndex = newIndex;
        return this.scrollCaption();
      }
    };

    VideoCaption.prototype.onWindowResize = function() {
      this.$('.subtitles').css({
        maxHeight: this.captionHeight()
      });
      this.$('.subtitles .spacing:first').height(this.topSpacingHeight());
      this.$('.subtitles .spacing:last').height(this.bottomSpacingHeight());
      return this.scrollCaption();
    };

    VideoCaption.prototype.onMouseEnter = function() {
      if (this.frozen) {
        clearTimeout(this.frozen);
      }
      return this.frozen = setTimeout(this.onMouseLeave, 10000);
    };

    VideoCaption.prototype.onMovement = function() {
      return this.onMouseEnter();
    };

    VideoCaption.prototype.onMouseLeave = function() {
      if (this.frozen) {
        clearTimeout(this.frozen);
      }
      this.frozen = null;
      if (this.player.isPlaying()) {
        return this.scrollCaption();
      }
    };

    VideoCaption.prototype.scrollCaption = function() {
      if (!this.frozen && this.$('.subtitles .current:first').length) {
        return this.$('.subtitles').scrollTo(this.$('.subtitles .current:first'), {
          offset: -this.calculateOffset(this.$('.subtitles .current:first'))
        });
      }
    };

    VideoCaption.prototype.seekPlayer = function(event) {
      var time;
      event.preventDefault();
      time = Math.round(Time.convert($(event.target).data('start'), '1.0', this.player.currentSpeed()) / 1000);
      return $(this.player).trigger('seek', time);
    };

    VideoCaption.prototype.calculateOffset = function(element) {
      return this.captionHeight() / 2 - element.height() / 2;
    };

    VideoCaption.prototype.topSpacingHeight = function() {
      return this.calculateOffset(this.$('.subtitles li:not(.spacing):first'));
    };

    VideoCaption.prototype.bottomSpacingHeight = function() {
      return this.calculateOffset(this.$('.subtitles li:not(.spacing):last'));
    };

    VideoCaption.prototype.toggle = function(event) {
      event.preventDefault();
      if (this.player.element.hasClass('closed')) {
        this.$('.hide-subtitles').attr('title', 'Turn off captions');
        this.player.element.removeClass('closed');
        return this.scrollCaption();
      } else {
        this.$('.hide-subtitles').attr('title', 'Turn on captions');
        return this.player.element.addClass('closed');
      }
    };

    VideoCaption.prototype.captionHeight = function() {
      if (this.player.element.hasClass('fullscreen')) {
        return $(window).height() - this.$('.video-controls').height();
      } else {
        return this.$('.video-wrapper').height();
      }
    };

    return VideoCaption;

  })();

}).call(this);
