// Generated by CoffeeScript 1.3.3
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  this.Problem = (function() {

    function Problem(id, url) {
      this.id = id;
      this.refreshAnswers = __bind(this.refreshAnswers, this);

      this.save = __bind(this.save, this);

      this.show = __bind(this.show, this);

      this.reset = __bind(this.reset, this);

      this.check = __bind(this.check, this);

      this.bind = __bind(this.bind, this);

      this.element = $("#problem_" + id);
      this.content_url = "" + url + "problem_get?id=" + this.id;
      this.render();
    }

    Problem.prototype.$ = function(selector) {
      return $(selector, this.element);
    };

    Problem.prototype.bind = function() {
      MathJax.Hub.Queue(["Typeset", MathJax.Hub]);
      window.update_schematics();
      this.$('section.action input:button').click(this.refreshAnswers);
      this.$('section.action input.check').click(this.check);
      this.$('section.action input.reset').click(this.reset);
      this.$('section.action input.show').click(this.show);
      return this.$('section.action input.save').click(this.save);
    };

    Problem.prototype.render = function(content) {
      if (content) {
        this.element.html(content);
        return this.bind();
      } else {
        return this.element.load(this.content_url, this.bind);
      }
    };

    Problem.prototype.check = function() {
      var _this = this;
      Logger.log('problem_check', this.answers);
      return $.postWithPrefix("/modx/problem/" + this.id + "/problem_check", this.answers, function(response) {
        switch (response.success) {
          case 'incorrect':
          case 'correct':
            return _this.render(response.contents);
          default:
            return alert(response.success);
        }
      });
    };

    Problem.prototype.reset = function() {
      var _this = this;
      Logger.log('problem_reset', this.answers);
      return $.postWithPrefix("/modx/problem/" + this.id + "/problem_reset", {
        id: this.id
      }, function(content) {
        return _this.render(content);
      });
    };

    Problem.prototype.show = function() {
      var _this = this;
      if (!this.element.hasClass('showed')) {
        Logger.log('problem_show', {
          problem: this.id
        });
        return $.postWithPrefix("/modx/problem/" + this.id + "/problem_show", function(response) {
          $.each(response, function(key, value) {
            var choice, _i, _len, _results;
            if ($.isArray(value)) {
              _results = [];
              for (_i = 0, _len = value.length; _i < _len; _i++) {
                choice = value[_i];
                _results.push(_this.$("label[for='input_" + key + "_" + choice + "']").attr({
                  correct_answer: 'true'
                }));
              }
              return _results;
            } else {
              return _this.$("#answer_" + key).text(value);
            }
          });
          _this.$('.show').val('Hide Answer');
          return _this.element.addClass('showed');
        });
      } else {
        this.$('[id^=answer_]').text('');
        this.$('[correct_answer]').attr({
          correct_answer: null
        });
        this.element.removeClass('showed');
        return this.$('.show').val('Show Answer');
      }
    };

    Problem.prototype.save = function() {
      var _this = this;
      Logger.log('problem_save', this.answers);
      return $.postWithPrefix("/modx/problem/" + this.id + "/problem_save", this.answers, function(response) {
        if (response.success) {
          return alert('Saved');
        }
      });
    };

    Problem.prototype.refreshAnswers = function() {
      this.$('input.schematic').each(function(index, element) {
        return element.schematic.update_value();
      });
      this.$(".CodeMirror").each(function(index, element) {
        if (element.CodeMirror.save) {
          return element.CodeMirror.save();
        }
      });
      return this.answers = this.$("[id^=input_" + this.id + "_]").serialize();
    };

    return Problem;

  })();

}).call(this);
