/*
 * Decompiled with CFR 0.152.
 */
package protex;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import protex.FoldingWindow;

public class SingleLetterCodeDocument
extends DefaultStyledDocument {
    final String allowedLetters = "ACDEFGHIKLMNPQRSTVWY";
    private FoldingWindow foldingWindow = null;

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String ucString = str.toUpperCase();
        char[] chars = ucString.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            String s = String.valueOf(chars[i]);
            if ("ACDEFGHIKLMNPQRSTVWY".indexOf(s) != -1) {
                super.insertString(offs, s, a);
            }
            --i;
        }
        this.foldingWindow.aaSeqChanged();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.foldingWindow.aaSeqChanged();
    }

    public void removeAll() {
        try {
            super.remove(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(offset, length, text, attrs);
        this.foldingWindow.aaSeqChanged();
    }

    public void setLinkedFoldingWindow(FoldingWindow fw) {
        this.foldingWindow = fw;
    }
}

