/*
 * Decompiled with CFR 0.152.
 */
package Requirements;

import Problems.GenexState;
import Requirements.Requirement;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;

public class MutationLocationRequirement
extends Requirement {
    private HashSet<Integer> desiredLocations = new HashSet();

    public MutationLocationRequirement(List<Element> elList) {
        for (Element e : elList) {
            if (e.getName().equals("Locations")) {
                String[] bases = e.getTextTrim().split(",");
                int i = 0;
                while (i < bases.length) {
                    this.desiredLocations.add(new Integer(Integer.parseInt(bases[i])));
                    ++i;
                }
            }
            if (!e.getName().equals("FailString")) continue;
            this.failureString = e.getTextTrim();
        }
    }

    @Override
    public boolean isSatisfied(GenexState state) {
        String startingDNA = state.getStartingDNAsequence();
        String currentDNA = state.getCurrentDNASequence();
        if (startingDNA.length() != currentDNA.length()) {
            return false;
        }
        int mutationLocation = -1;
        int i = 0;
        while (i < startingDNA.length()) {
            if (startingDNA.charAt(i) != currentDNA.charAt(i)) {
                mutationLocation = i;
                break;
            }
            ++i;
        }
        return this.desiredLocations.contains(new Integer(mutationLocation));
    }
}

