/*
 * Decompiled with CFR 0.152.
 */
package protex;

import java.awt.Color;
import java.util.ArrayList;
import protex.AcidInChain;
import protex.Direction;
import protex.Grid;
import protex.GridPoint;
import protex.Polypeptide;
import protex.SsBond;

public abstract class TwoDGrid
extends Grid {
    protected AcidInChain[][] cells;
    protected GridPoint[][] points;
    protected ArrayList hydrophobics;
    protected ArrayList hydrophilics;
    protected Color proteinColor = Color.white;
    protected ArrayList coreColors;
    protected Direction[] allDirections = null;
    protected double energy;
    protected int freeEdges;

    public TwoDGrid() {
    }

    public TwoDGrid(Polypeptide pp) {
        super(pp);
        this.hydrophobics = new ArrayList();
        this.hydrophilics = new ArrayList();
        this.cells = new AcidInChain[this.size][this.size];
        this.points = new GridPoint[this.size][this.size];
        this.coreColors = new ArrayList();
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                this.cells[i][j] = null;
                this.points[i][j] = new GridPoint(i, j);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public GridPoint getCenter() {
        return new GridPoint(this.size / 2, this.size / 2);
    }

    @Override
    public void set(int index, GridPoint p, Direction from) {
        AcidInChain a;
        this.cells[p.y][p.x] = a = this.acids[index];
        a.xyz = p;
        if (index > 0) {
            this.acids[index - 1].setNext(from);
        }
    }

    @Override
    protected void unset(GridPoint p) {
        this.unset(p.x, p.y);
    }

    @Override
    protected void unset(GridPoint p, int index) {
        this.unset(this.cells[p.y][p.x], index, p.x, p.y);
    }

    @Override
    protected void unset(AcidInChain a) {
        if (a != null && a.xyz != null) {
            this.unset(a.xyz.x, a.xyz.y);
        }
    }

    protected void unset(int x, int y) {
        AcidInChain a = this.cells[y][x];
        if (a != null) {
            this.unset(a, a.getIndex(), x, y);
        }
    }

    private void unset(AcidInChain a, int index, int x, int y) {
        this.cells[y][x] = null;
        a.xyz = null;
        if (index > 0) {
            this.acids[index - 1].setNext(Direction.none);
        }
    }

    @Override
    protected AcidInChain get(GridPoint p) {
        return this.get(p.x, p.y);
    }

    protected AcidInChain get(int x, int y) {
        return this.cells[y][x];
    }

    @Override
    protected Direction getDirection(GridPoint p1, GridPoint p2) {
        return this.getDirection(p1.x, p1.y, p2.x, p2.y);
    }

    protected Direction getDirection(int x1, int y1, int x2, int y2, int z1, int z2) {
        return this.getDirection(x1, y1, x2, y2);
    }

    protected abstract Direction getDirection(int var1, int var2, int var3, int var4);

    @Override
    protected abstract Direction[] getAllDirections();

    @Override
    protected abstract GridPoint nextCell(Direction var1, GridPoint var2);

    @Override
    public abstract Direction[] getThirdPlacement();

    @Override
    public double getEnergy(boolean custom, double hpIndex, double hIndex, double iIndex, double sIndex) {
        this.energy = 0.0;
        this.freeEdges = 0;
        if (custom) {
            int i = 0;
            while (i < this.numAcids) {
                AcidInChain a = this.acids[i];
                if (a.xyz != null) {
                    int d = 0;
                    while (d < this.allDirections.length) {
                        AcidInChain ac = this.get(this.nextCell(this.allDirections[d], a.xyz));
                        if (ac != null) {
                            this.energy += (double)a.getAminoAcid().getContactEnergy(ac.getAminoAcid().getIndexNum());
                        }
                        ++d;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            boolean[] availableForssBond = new boolean[this.numAcids];
            int i = 0;
            while (i < this.numAcids) {
                availableForssBond[i] = true;
                ++i;
            }
            this.ssBondList = new ArrayList();
            i = 0;
            while (i < this.numAcids) {
                AcidInChain a = this.acids[i];
                if (a.xyz != null) {
                    int free = 0;
                    int hbondContacts = 0;
                    int ionicInteractions = 0;
                    int ssBonds = 0;
                    int d = 0;
                    while (d < this.allDirections.length) {
                        AcidInChain ac = this.get(this.nextCell(this.allDirections[d], a.xyz));
                        if (ac == null) {
                            ++free;
                        } else {
                            hbondContacts += a.gethydrogenbondIndex() * ac.gethydrogenbondIndex();
                            ionicInteractions -= a.getionicIndex() * ac.getionicIndex();
                            if (a.getssIndex() && ac.getssIndex() && availableForssBond[i] && availableForssBond[ac.getIndex()] && Math.abs(i - ac.getIndex()) != 1) {
                                ++ssBonds;
                                availableForssBond[i] = false;
                                availableForssBond[ac.getIndex()] = false;
                                this.ssBondList.add(new SsBond(i, ac.getIndex()));
                            }
                        }
                        ++d;
                    }
                    this.energy += (double)free * a.hydrophobicIndex * hpIndex - (double)hbondContacts * hIndex - (double)ionicInteractions * iIndex - (double)ssBonds * sIndex;
                    this.freeEdges += free;
                    ++i;
                    continue;
                }
                break;
            }
        }
        return this.energy;
    }

    public void categorizeAcids() {
        int i = 0;
        while (i < this.numAcids) {
            AcidInChain a = this.acids[i];
            if (a.getHydrophobicIndex() >= 0.0 || a.getName().equalsIgnoreCase("tyr")) {
                this.hydrophobics.add(a);
            } else {
                this.hydrophilics.add(a);
            }
            ++i;
        }
    }

    @Override
    public double getFoldingIndex(boolean custom, double hpIndex, double hIndex, double iIndex, double sIndex) {
        this.computeStatistics(custom, hpIndex, hIndex, iIndex, sIndex);
        return (double)this.freeEdges / (double)(2 + 4 * this.pp.getLength());
    }

    @Override
    public int getFreeEdges(boolean custom, double hpIndex, double hIndex, double iIndex, double sIndex) {
        this.computeStatistics(custom, hpIndex, hIndex, iIndex, sIndex);
        return this.freeEdges;
    }

    @Override
    public void computeStatistics(boolean custom, double hpIndex, double hIndex, double iIndex, double sIndex) {
        this.getEnergy(custom, hpIndex, hIndex, iIndex, sIndex);
        this.setNeighbors();
    }

    @Override
    public void setNeighbors() {
        this.pp.clearTopology();
        int i = 0;
        while (i < this.numAcids) {
            this.setNeighbors(this.acids[i]);
            ++i;
        }
    }

    @Override
    public boolean isLastAcidPlaced() {
        return this.acids[this.numAcids - 1].xyz != null;
    }

    @Override
    protected void setNeighbors(AcidInChain to) {
        GridPoint p = to.xyz;
        if (p == null) {
            return;
        }
        int d = 0;
        while (d < this.allDirections.length) {
            this.setNeighbor(to, p, this.allDirections[d]);
            ++d;
        }
    }

    @Override
    protected void setNeighbor(AcidInChain to, GridPoint p, Direction d) {
        AcidInChain from = this.get(this.nextCell(d, p));
        if (from != null) {
            this.pp.addNeighbor(to, from);
        }
    }

    protected GridPoint getMin() {
        int minX = this.size;
        int minY = this.size;
        int i = 0;
        while (i < this.numAcids) {
            AcidInChain a = this.pp.getAminoAcid(i);
            if (a.xyz.x < minX) {
                minX = a.xyz.x;
            }
            if (a.xyz.y < minY) {
                minY = a.xyz.y;
            }
            ++i;
        }
        return new GridPoint(minX, minY);
    }

    protected GridPoint getMax() {
        int maxX = 0;
        int maxY = 0;
        int i = 0;
        while (i < this.numAcids) {
            AcidInChain a = this.pp.getAminoAcid(i);
            if (a.xyz.x > maxX) {
                maxX = a.xyz.x;
            }
            if (a.xyz.y > maxY) {
                maxY = a.xyz.y;
            }
            ++i;
        }
        return new GridPoint(maxX, maxY);
    }
}

