___JmolDate="$Date: 2012-12-08 08:11:44 -0600 (Sat, 08 Dec 2012) $"
___fullJmolProperties="src/org/jmol/viewer/Jmol.properties"
___JmolVersion="13.1.11_dev"
// core.z.js
//
// BH 11/6/2012 8:26:33 PM added instanceof Int32Array in String.instantialize
// BH 10/13/2012 11:38:07 PM corrected Integer.parseInt to allow only +-0123456789; created Integer.parseIntRadix
// BH 11/1/2012 added Short
// BH 9/10/2012 6:27:21 AM added java.net.URL... classes

;(function() {

java.lang.Number=Number;
if(Clazz.supportsNativeObject){
for(var i=0;i<Clazz.extendedObjectMethods.length;i++){
var p=Clazz.extendedObjectMethods[i];
Number.prototype[p]=JavaObject.prototype[p];
}
}

Number.__CLASS_NAME__="Number";
Clazz.implementOf(Number,java.io.Serializable);
Number.equals=Clazz.innerFunctions.equals;
Number.getName=Clazz.innerFunctions.getName;

Number.serialVersionUID=Number.prototype.serialVersionUID=-8742448824652078965;

Clazz.defineMethod(Number,"shortValue",
function(){
return Math.round(this)&0xffff;
});

Clazz.defineMethod(Number,"byteValue",
function(){
return Math.round(this)&0xff;
});

Clazz.defineMethod(Number,"intValue",
function(){
return Math.round(this)&0xffffffff;
});

Clazz.defineMethod(Number,"longValue",
function(){
return Math.round(this);
});

Clazz.defineMethod(Number,"floatValue",
function(){
return this.valueOf();
});
Clazz.defineMethod(Number,"doubleValue",
function(){
return this.valueOf();
});

Clazz.defineMethod(Number,"hashCode",
function(){
return this.valueOf();
});

java.lang.Integer=Integer=function(){
Clazz.instantialize(this,arguments);
};
Clazz.decorateAsType(Integer,"Integer",Number,Comparable,null,true);
Integer.prototype.valueOf=function(){return 0;};
Integer.toString=Integer.prototype.toString=function(){
if(arguments.length!=0){
return""+arguments[0];
}else if(this===Integer){
return"class java.lang.Integer";
}
return""+this.valueOf();
};

/*

Clazz.makeConstructor(Integer,
function(){
this.valueOf=function(){
return 0;
};
});
*/


Clazz.makeConstructor(Integer,
function(value){
var v=Math.round(value)&0xffffffff;
this.valueOf=function(){
return v;
};
},"Number");
/*
Clazz.makeConstructor(Integer,
function(s){
var value=Integer.parseInt(s,10);
this.valueOf=function(){
return value;
};
},"String");
*/
Integer.serialVersionUID=Integer.prototype.serialVersionUID=1360826667806852920;
Integer.MIN_VALUE=Integer.prototype.MIN_VALUE=-0x80000000;
Integer.MAX_VALUE=Integer.prototype.MAX_VALUE=0x7fffffff;
Integer.TYPE=Integer.prototype.TYPE=Integer;


Clazz.defineMethod(Integer,"bitCount",
function(i) {
  i = i - ((i >>> 1) & 0x55555555);
  i = (i & 0x33333333) + ((i >>> 2) & 0x33333333);
  i = (i + (i >>> 4)) & 0x0f0f0f0f;
  i = i + (i >>> 8);
  i = i + (i >>> 16);
  return i & 0x3f;
},"Number");
Integer.bitCount=Integer.prototype.bitCount;

Clazz.defineMethod(Integer,"numberOfLeadingZeros",
function(i) {
 if (i == 0) return 32;
 var n = 1;
 if (i >>> 16 == 0) { n += 16; i <<= 16; }
 if (i >>> 24 == 0) { n +=  8; i <<=  8; }
 if (i >>> 28 == 0) { n +=  4; i <<=  4; }
 if (i >>> 30 == 0) { n +=  2; i <<=  2; }
 n -= i >>> 31;
 return n;
},"Number");
Integer.numberOfLeadingZeros=Integer.prototype.numberOfLeadingZeros;

Clazz.defineMethod(Integer,"numberOfTrailingZeros",
function(i) {
  if (i == 0) return 32;
  var n = 31;
  var y = i <<16; if (y != 0) { n = n -16; i = y; }
  y = i << 8; if (y != 0) { n = n - 8; i = y; }
  y = i << 4; if (y != 0) { n = n - 4; i = y; }
  y = i << 2; if (y != 0) { n = n - 2; i = y; }
  return n - ((i << 1) >>> 31);
},"Number");
Integer.numberOfTrailingZeros=Integer.prototype.numberOfTrailingZeros;

Clazz.defineMethod(Integer,"parseIntRadix",
function(s,radix){
if(s==null){
throw new NumberFormatException("null");
}if(radix<2){
throw new NumberFormatException("radix "+radix+" less than Character.MIN_RADIX");
}if(radix>36){
throw new NumberFormatException("radix "+radix+" greater than Character.MAX_RADIX");
}
if (radix == 10) {
	for (var i = s.length; --i >= 0;) {
	  var c = s.charCodeAt(i);
	  if (c >= 48 && c <= 57) continue;
	  if (i > 0 || c != 43 && c != 45)
		  throw new NumberFormatException("Not a Number : "+s);

	}
}
var integer=parseInt(s,radix);
if(isNaN(integer)){
throw new NumberFormatException("Not a Number : "+s);
}
return integer;
},"String, Number");
Integer.parseIntRadix=Integer.prototype.parseIntRadix;

Clazz.defineMethod(Integer,"parseInt",
function(s){
return Integer.parseIntRadix(s,10);
},"String");
Integer.parseInt=Integer.prototype.parseInt;

Clazz.defineMethod(Integer,"$valueOf",
function(s){
return new Integer(Integer.parseIntRadix(s,10));
},"String");

Clazz.defineMethod(Integer,"$valueOf",
function(s){
return new Integer(s);
},"Number");

Clazz.defineMethod(Integer,"$valueOf",
function(s,r){
return new Integer(Integer.parseIntRadix(s,r));
},"String, Number");

Integer.$valueOf=Integer.prototype.$valueOf;
Clazz.defineMethod(Integer,"equals",
function(s){
if(s==null||!Clazz.instanceOf(s,Integer)){
return false;
}
return s.valueOf()==this.valueOf();
},"Object");
Integer.toHexString=Integer.prototype.toHexString=function(d){if(d.valueOf)d=d.valueOf();return d._numberToString(16);};
Integer.toOctalString=Integer.prototype.toOctalString=function(d){if(d.valueOf)d=d.valueOf();return d._numberToString(8);};
Integer.toBinaryString=Integer.prototype.toBinaryString=function(d){if(d.valueOf)d=d.valueOf();return d._numberToString(2);};

Integer.decode=Clazz.defineMethod(Integer,"decode",
function(nm){
var radix=10;
var index=0;
var negative=false;
var result;
if(nm.startsWith("-")){
negative=true;
index++;
}if(nm.startsWith("0x",index)||nm.startsWith("0X",index)){
index+=2;
radix=16;
}else if(nm.startsWith("#",index)){
index++;
radix=16;
}else if(nm.startsWith("0",index)&&nm.length>1+index){
index++;
radix=8;
}if(nm.startsWith("-",index))throw new NumberFormatException("Negative sign in wrong position");
try{
result=Integer.$valueOf(nm.substring(index),radix);
result=negative?new Integer(-result.intValue()):result;
}catch(e){
if(Clazz.instanceOf(e,NumberFormatException)){
var constant=negative?String.instantialize("-"+nm.substring(index)):nm.substring(index);
result=Integer.$valueOf(constant,radix);
}else{
throw e;
}
}
return result;
},"~S");


java.lang.Long=Long=function(){
Clazz.instantialize(this,arguments);
};
Clazz.decorateAsType(Long,"Long",Number,Comparable,null,true);
Long.prototype.valueOf=function(){return 0;};
Long.toString=Long.prototype.toString=function(){
if(arguments.length!=0){
return""+arguments[0];
}else if(this===Long){
return"class java.lang.Long";
}
return""+this.valueOf();
};
Clazz.makeConstructor(Long,
function(){
this.valueOf=function(){
return 0;
};
});
Clazz.makeConstructor(Long,
function(value){
var v=Math.round(value);
this.valueOf=function(){
return v;
};
},"Number");
Clazz.makeConstructor(Long,
function(s){
var value=Long.parseLong(s,10);
this.valueOf=function(){
return value;
};
},"String");
Long.serialVersionUID=Long.prototype.serialVersionUID=4290774380558885855;
Long.MIN_VALUE=Long.prototype.MIN_VALUE=-0x8000000000000000;
Long.MAX_VALUE=Long.prototype.MAX_VALUE=0x7fffffffffffffff;
Long.TYPE=Long.prototype.TYPE=Long;

Clazz.defineMethod(Long,"parseLong",
function(s,radix){
if(s==null){
throw new NumberFormatException("null");
}if(radix<2){
throw new NumberFormatException("radix "+radix+" less than Character.MIN_RADIX");
}if(radix>36){
throw new NumberFormatException("radix "+radix+" greater than Character.MAX_RADIX");
}
var longVal=parseInt(s,radix);
if(isNaN(longVal)){
throw new NumberFormatException("Not a Number : "+s);
}
return longVal;
},"String, Number");

Clazz.defineMethod(Long,"parseLong",
function(s){
return Long.parseLong(s,10);
},"String");

Long.parseLong=Long.prototype.parseLong;

Clazz.defineMethod(Long,"$valueOf",
function(s){
return new Long(Long.parseLong(s,10));
},"String");

Clazz.defineMethod(Long,"$valueOf",
function(s){
return new Long(s);
},"Number");

Clazz.defineMethod(Long,"$valueOf",
function(s,r){
return new Long(Long.parseLong(s,r));
},"String, Number");

Long.$valueOf=Long.prototype.$valueOf;
Clazz.defineMethod(Long,"equals",
function(s){
if(s==null||!Clazz.instanceOf(s,Long)){
return false;
}
return s.valueOf()==this.valueOf();
},"Object");
Long.toHexString=Long.prototype.toHexString=function(i){
return i.toString(16);
};
Long.toOctalString=Long.prototype.toOctalString=function(i){
return i.toString(8);
};
Long.toBinaryString=Long.prototype.toBinaryString=function(i){
return i.toString(2);
};


Long.decode=Clazz.defineMethod(Long,"decode",
function(nm){
var radix=10;
var index=0;
var negative=false;
var result;
if(nm.startsWith("-")){
negative=true;
index++;
}if(nm.startsWith("0x",index)||nm.startsWith("0X",index)){
index+=2;
radix=16;
}else if(nm.startsWith("#",index)){
index++;
radix=16;
}else if(nm.startsWith("0",index)&&nm.length>1+index){
index++;
radix=8;
}if(nm.startsWith("-",index))throw new NumberFormatException("Negative sign in wrong position");
try{
result=Long.$valueOf(nm.substring(index),radix);
result=negative?new Long(-result.longValue()):result;
}catch(e){
if(Clazz.instanceOf(e,NumberFormatException)){
var constant=negative?String.instantialize("-"+nm.substring(index)):nm.substring(index);
result=Long.$valueOf(constant,radix);
}else{
throw e;
}
}
return result;
},"~S");

java.lang.Short = Short = function () {
Clazz.instantialize (this, arguments);
};
Clazz.decorateAsType (Short, "Short", Number, Comparable, null, true);
Short.prototype.valueOf = function () { return 0; };
Short.toString = Short.prototype.toString = function () {
	if (arguments.length != 0) {
		return "" + arguments[0];
	} else if (this === Short) {
		return "class java.lang.Short"; // Short.class.toString
	}
	return "" + this.valueOf ();
};
Clazz.makeConstructor (Short,
function () {
this.valueOf = function () {
	return 0;
};
});
Clazz.makeConstructor (Short,
function (value) {
var v = Math.round (value) & 0xffffffff;
this.valueOf = function () {
	return v;
};
}, "Number");
Clazz.makeConstructor (Short,
function (s) {
var value = Short.parseShort (s, 10);
this.valueOf = function () {
	return value;
};
}, "String");
Short.serialVersionUID = Short.prototype.serialVersionUID = 7515723908773894738;
Short.MIN_VALUE = Short.prototype.MIN_VALUE = -32768;
Short.MAX_VALUE = Short.prototype.MAX_VALUE = 32767;
Short.TYPE = Short.prototype.TYPE = Short;

Clazz.defineMethod (Short, "parseShort",
function (s, radix) {
if (s == null) {
throw  new NumberFormatException ("null");
}if (radix < 2) {
throw  new NumberFormatException ("radix " + radix + " less than Character.MIN_RADIX");
}if (radix > 36) {
throw  new NumberFormatException ("radix " + radix + " greater than Character.MAX_RADIX");
}
var integer = parseInt (s, radix);
if(isNaN(integer)){
throw  new NumberFormatException ("Not a Number : " + s);
}
return integer;
}, "String, Number");
Short.parseShort = Short.prototype.parseShort;
Clazz.defineMethod (Short, "parseShort",
function (s) {
return Short.parseShort (s, 10);
}, "String");

Short.parseShort = Short.prototype.parseShort;

Clazz.defineMethod (Short, "$valueOf",
function (s) {
return new Short(Short.parseShort (s, 10));
}, "String");

Clazz.defineMethod (Short, "$valueOf",
function (s) {
return new Short(s);
}, "Number");

Clazz.defineMethod (Short, "$valueOf",
function (s, r) {
return new Short(Short.parseShort (s, r));
}, "String, Number");

Short.$valueOf = Short.prototype.$valueOf;
Clazz.defineMethod (Short, "equals",
function (s) {
if(s == null || !Clazz.instanceOf(s, Short) ){
	return false;
}
return s.valueOf()  == this.valueOf();
}, "Object");
Short.toHexString = Short.prototype.toHexString = function (i) {
	return i.toString (16);
};
Short.toOctalString = Short.prototype.toOctalString = function (i) {
	return i.toString (8);
};
Short.toBinaryString = Short.prototype.toBinaryString = function (i) {
	return i.toString (2);
};
Short.decode = Clazz.defineMethod (Short, "decode",
function (nm) {
var radix = 10;
var index = 0;
var negative = false;
var result;
if (nm.startsWith ("-")) {
negative = true;
index++;
}if (nm.startsWith ("0x", index) || nm.startsWith ("0X", index)) {
index += 2;
radix = 16;
} else if (nm.startsWith ("#", index)) {
index++;
radix = 16;
} else if (nm.startsWith ("0", index) && nm.length > 1 + index) {
index++;
radix = 8;
}if (nm.startsWith ("-", index)) throw  new NumberFormatException ("Negative sign in wrong position");
try {
result = Short.$valueOf (nm.substring (index), radix);
result = negative ?  new Short (-result.shortValue ()) : result;
} catch (e) {
if (Clazz.instanceOf (e, NumberFormatException)) {
var constant = negative ?  String.instantialize ("-" + nm.substring (index)) : nm.substring (index);
result = Short.$valueOf (constant, radix);
} else {
throw e;
}
}
return result;
}, "~S");

java.lang.Float=Float=function(){
Clazz.instantialize(this,arguments);
};
Clazz.decorateAsType(Float,"Float",Number,Comparable,null,true);
Float.prototype.valueOf=function(){return 0;};
Float.toString=Float.prototype.toString=function(){
if(arguments.length!=0){
return""+arguments[0];
}else if(this===Float){
return"class java.lang.Float";
}
return""+this.valueOf();
};
Clazz.makeConstructor(Float,
function(){
this.valueOf=function(){
return 0.0;
};
});
Clazz.makeConstructor(Float,
function(value){
this.valueOf=function(){
return value;
};
},"Number");
Clazz.makeConstructor(Float,
function(s){
var value=null;
if(s!=null){
value=Float.parseFloat(s);
}else{
value=0;
}
this.valueOf=function(){
return value;
};
},"String");
Float.serialVersionUID=Float.prototype.serialVersionUID=-2671257302660747028;
Float.MIN_VALUE=Float.prototype.MIN_VALUE=3.4028235e+38;
Float.MAX_VALUE=Float.prototype.MAX_VALUE=1.4e-45;
Float.NEGATIVE_INFINITY=Number.NEGATIVE_INFINITY;
Float.POSITIVE_INFINITY=Number.POSITIVE_INFINITY;
Float.NaN=Number.NaN;
Float.TYPE=Float.prototype.TYPE=Float;

Clazz.defineMethod(Float,"parseFloat",
function(s){
if(s==null){
throw new NumberFormatException("null");
}
var floatVal=parseFloat(s);
if(isNaN(floatVal)){
throw new NumberFormatException("Not a Number : "+s);
}
return floatVal;
},"String");
Float.parseFloat=Float.prototype.parseFloat;

Clazz.defineMethod(Float,"$valueOf",
function(s){
return new Float(Float.parseFloat(s,10));
},"String");

Clazz.defineMethod(Float,"$valueOf",
function(s){
return new Float(s);
},"Number");

Float.$valueOf=Float.prototype.$valueOf;
Clazz.defineMethod(Float,"isNaN",
function(num){
return isNaN(num);
},"Number");
Float.isNaN=Float.prototype.isNaN;
Clazz.defineMethod(Float,"isInfinite",
function(num){
return!isFinite(num);
},"Number");
Float.isInfinite=Float.prototype.isInfinite;

Clazz.defineMethod(Float,"equals",
function(s){
if(s==null||!Clazz.instanceOf(s,Float)){
return false;
}
return s.valueOf()==this.valueOf();
},"Object");

java.lang.Double=Double=function(){
Clazz.instantialize(this,arguments);
};
Clazz.decorateAsType(Double,"Double",Number,Comparable,null,true);
Double.prototype.valueOf=function(){return 0;};
Double.toString=Double.prototype.toString=function(){
if(arguments.length!=0){
return""+arguments[0];
}else if(this===Double){
return"class java.lang.Double";
}
return""+this.valueOf();
};
Clazz.makeConstructor(Double,
function(){
this.valueOf=function(){
return 0.0;
};
});
Clazz.makeConstructor(Double,
function(value){
this.valueOf=function(){
return value;
};
},"Number");
Clazz.makeConstructor(Double,
function(s){
var value=Double.parseDouble(s);
this.valueOf=function(){
return value;
};
},"String");

Double.serialVersionUID=Double.prototype.serialVersionUID=-9172774392245257468;
Double.MIN_VALUE=Double.prototype.MIN_VALUE=4.9e-324;
Double.MAX_VALUE=Double.prototype.MAX_VALUE=1.7976931348623157e+308;
Double.NEGATIVE_INFINITY=Number.NEGATIVE_INFINITY;
Double.POSITIVE_INFINITY=Number.POSITIVE_INFINITY;
Double.NaN=Number.NaN;
Double.TYPE=Double.prototype.TYPE=Double;

Clazz.defineMethod(Double,"isNaN",
function(num){
return isNaN(num);
},"Number");
Double.isNaN=Double.prototype.isNaN;
Clazz.defineMethod(Double,"isInfinite",
function(num){
return!isFinite(num);
},"Number");
Double.isInfinite=Double.prototype.isInfinite;

Clazz.defineMethod(Double,"parseDouble",
function(s){
if(s==null){
throw new NumberFormatException("null");
}
var doubleVal=parseFloat(s);
if(isNaN(doubleVal)){
throw new NumberFormatException("Not a Number : "+s);
}
return doubleVal;
},"String");
Double.parseDouble=Double.prototype.parseDouble;

Clazz.defineMethod(Double,"$valueOf",
function(s){
return new Double(this.parseDouble(s));
},"String");

Clazz.defineMethod(Double,"$valueOf",
function(v){
return new Double(v);
},"Number");

Double.$valueOf=Double.prototype.$valueOf;

Clazz.defineMethod(Double,"equals",
function(s){
if(s==null||!Clazz.instanceOf(s,Double)){
return false;
}
return s.valueOf()==this.valueOf();
},"Object");

java.lang.Byte=Byte=function(){
Clazz.instantialize(this,arguments);
};
Clazz.decorateAsType(Byte,"Byte",Number,Comparable,null,true);
Byte.prototype.valueOf=function(){return 0;};
Byte.toString=Byte.prototype.toString=function(){
if(arguments.length!=0){
return""+arguments[0];
}else if(this===Byte){
return"class java.lang.Byte";
}
return""+this.valueOf();
};
Clazz.makeConstructor(Byte,
function(){
this.valueOf=function(){
return 0;
};
});
Clazz.makeConstructor(Byte,
function(value){
var v=Math.round(value)&0xffffffff;
this.valueOf=function(){
return v;
};
},"Number");
Clazz.makeConstructor(Byte,
function(s){
var value=Byte.parseByte(s,10);
this.valueOf=function(){
return value;
};
},"String");
Byte.serialVersionUID=Byte.prototype.serialVersionUID=-7183698231559129828;
Byte.MIN_VALUE=Byte.prototype.MIN_VALUE=-128;
Byte.MAX_VALUE=Byte.prototype.MAX_VALUE=127;
Byte.SIZE=Byte.prototype.SIZE=8;
Byte.TYPE=Byte.prototype.TYPE=Byte;

Clazz.defineMethod(Byte,"parseByte",
function(s,radix){
if(s==null){
throw new NumberFormatException("null");
}if(radix<2){
throw new NumberFormatException("radix "+radix+" less than Character.MIN_RADIX");
}if(radix>36){
throw new NumberFormatException("radix "+radix+" greater than Character.MAX_RADIX");
}
var integer=parseInt(s,radix);
if(isNaN(integer)){
throw new NumberFormatException("Not a Number : "+s);
}
return integer;
},"String, Number");
Byte.parseByte=Byte.prototype.parseByte;
Clazz.defineMethod(Byte,"parseByte",
function(s){
return Byte.parseByte(s,10);
},"String");

Byte.parseByte=Byte.prototype.parseByte;

Clazz.defineMethod(Byte,"$valueOf",
function(s){
return new Byte(Byte.parseByte(s,10));
},"String");

Clazz.defineMethod(Byte,"$valueOf",
function(s){
return new Byte(s);
},"Number");

Clazz.defineMethod(Byte,"$valueOf",
function(s,r){
return new Byte(Byte.parseByte(s,r));
},"String, Number");

Byte.$valueOf=Byte.prototype.$valueOf;
Clazz.defineMethod(Byte,"equals",
function(s){
if(s==null||!Clazz.instanceOf(s,Byte)){
return false;
}
return s.valueOf()==this.valueOf();
},"Object");
Byte.toHexString=Byte.prototype.toHexString=function(i){
return i.toString(16);
};
Byte.toOctalString=Byte.prototype.toOctalString=function(i){
return i.toString(8);
};
Byte.toBinaryString=Byte.prototype.toBinaryString=function(i){
return i.toString(2);
};
Byte.decode=Clazz.defineMethod(Byte,"decode",
function(nm){
var radix=10;
var index=0;
var negative=false;
var result;
if(nm.startsWith("-")){
negative=true;
index++;
}if(nm.startsWith("0x",index)||nm.startsWith("0X",index)){
index+=2;
radix=16;
}else if(nm.startsWith("#",index)){
index++;
radix=16;
}else if(nm.startsWith("0",index)&&nm.length>1+index){
index++;
radix=8;
}if(nm.startsWith("-",index))throw new NumberFormatException("Negative sign in wrong position");
try{
result=Byte.$valueOf(nm.substring(index),radix);
result=negative?new Byte(-result.byteValue()):result;
}catch(e){
if(Clazz.instanceOf(e,NumberFormatException)){
var constant=negative?String.instantialize("-"+nm.substring(index)):nm.substring(index);
result=Byte.$valueOf(constant,radix);
}else{
throw e;
}
}
return result;
},"~S");

java.lang.Boolean=Boolean;
if(Clazz.supportsNativeObject){
for(var i=0;i<Clazz.extendedObjectMethods.length;i++){
var p=Clazz.extendedObjectMethods[i];
Boolean.prototype[p]=JavaObject.prototype[p];
}
}
Boolean.__CLASS_NAME__="Boolean";
Clazz.implementOf(Boolean,[java.io.Serializable,java.lang.Comparable]);
Boolean.equals=Clazz.innerFunctions.equals;
Boolean.getName=Clazz.innerFunctions.getName;
Boolean.serialVersionUID=Boolean.prototype.serialVersionUID=-3665804199014368530;

Clazz.makeConstructor(Boolean,
function(value){
this.valueOf=function(){
return value;
};
},"~B");
Clazz.makeConstructor(Boolean,
function(s){
this.valueOf=function(){
return Boolean.toBoolean(s);
};
},"~S");
Boolean.parseBoolean=Clazz.defineMethod(Boolean,"parseBoolean",
function(s){
return Boolean.toBoolean(s);
},"~S");
Clazz.defineMethod(Boolean,"booleanValue",
function(){
return this.valueOf();
});
Boolean.$valueOf=Clazz.defineMethod(Boolean,"$valueOf",
function(b){
return(b?Boolean.TRUE:Boolean.FALSE);
},"~B");
Boolean.$valueOf=Clazz.defineMethod(Boolean,"$valueOf",
function(s){
return Boolean.toBoolean(s)?Boolean.TRUE:Boolean.FALSE;
},"~S");
Boolean.toString=Clazz.defineMethod(Boolean,"toString",
function(b){
return b?"true":"false";
},"~B");
Clazz.defineMethod(Boolean,"toString",
function(){
return this.valueOf()?"true":"false";
});
Clazz.overrideMethod(Boolean,"hashCode",
function(){
return this.valueOf()?1231:1237;
});
Clazz.overrideMethod(Boolean,"equals",
function(obj){
if(Clazz.instanceOf(obj,Boolean)){
return this.booleanValue()==obj.booleanValue();
}return false;
},"~O");
Boolean.getBoolean=Clazz.defineMethod(Boolean,"getBoolean",
function(name){
var result=false;
try{
result=Boolean.toBoolean(System.getProperty(name));
}catch(e){
if(Clazz.instanceOf(e,IllegalArgumentException)){
}else if(Clazz.instanceOf(e,NullPointerException)){
}else{
throw e;
}
}
return result;
},"~S");
Clazz.overrideMethod(Boolean,"compareTo",
function(b){
return(b.value==this.value?0:(this.value?1:-1));
},"Boolean");
Boolean.toBoolean=Clazz.defineMethod(Boolean,"toBoolean",
($fz=function(name){
return((name!=null)&&name.equalsIgnoreCase("true"));
},$fz.isPrivate=true,$fz),"~S");
Boolean.TRUE=Boolean.prototype.TRUE=new Boolean(true);
Boolean.FALSE=Boolean.prototype.FALSE=new Boolean(false);
Boolean.TYPE=Boolean.prototype.TYPE=Boolean;
Encoding=new Object();
Encoding.UTF8="utf-8";
Encoding.UTF16="utf-16";
Encoding.ASCII="ascii";


Encoding.guessEncoding=function(str){
if(str.charCodeAt(0)==0xEF&&str.charCodeAt(1)==0xBB&&str.charCodeAt(2)==0xBF){
return Encoding.UTF8;
}else if(str.charCodeAt(0)==0xFF&&str.charCodeAt(1)==0xFE){
return Encoding.UTF16;
}else{
return Encoding.ASCII;
}
};

Encoding.readUTF8=function(str){
var encoding=this.guessEncoding(str);
var startIdx=0;
if(encoding==Encoding.UTF8){
startIdx=3;
}else if(encoding==Encoding.UTF16){
startIdx=2;
}
var arrs=new Array();
for(var i=startIdx;i<str.length;i++){
var charCode=str.charCodeAt(i);
if(charCode<0x80){
arrs[arrs.length]=str.charAt(i);
}else if(charCode>0xc0&&charCode<0xe0){
var c1=charCode&0x1f;
i++;
var c2=str.charCodeAt(i)&0x3f;
var c=(c1<<6)+c2;
arrs[arrs.length]=String.fromCharCode(c);
}else if(charCode>=0xe0){
var c1=charCode&0x0f;
i++;
var c2=str.charCodeAt(i)&0x3f;
i++;
var c3=str.charCodeAt(i)&0x3f;
var c=(c1<<12)+(c2<<6)+c3;
arrs[arrs.length]=String.fromCharCode(c);
}
}
return arrs.join('');
};

Encoding.convert2UTF8=function(str){
var encoding=this.guessEncoding(str);
var startIdx=0;
if(encoding==Encoding.UTF8){
return str;
}else if(encoding==Encoding.UTF16){
startIdx=2;
}

var offset=0;
var arrs=new Array(offset+str.length-startIdx);

for(var i=startIdx;i<str.length;i++){
var charCode=str.charCodeAt(i);
if(charCode<0x80){
arrs[offset+i-startIdx]=str.charAt(i);
}else if(charCode<=0x07ff){
var c1=0xc0+((charCode&0x07c0)>>6);
var c2=0x80+(charCode&0x003f);
arrs[offset+i-startIdx]=String.fromCharCode(c1)+String.fromCharCode(c2);
}else{
var c1=0xe0+((charCode&0xf000)>>12);
var c2=0x80+((charCode&0x0fc0)>>6);
var c3=0x80+(charCode&0x003f);
arrs[offset+i-startIdx]=String.fromCharCode(c1)+String.fromCharCode(c2)+String.fromCharCode(c3);
}
}
return arrs.join('');
};
Encoding.base64Chars=new Array(
'A','B','C','D','E','F','G','H',
'I','J','K','L','M','N','O','P',
'Q','R','S','T','U','V','W','X',
'Y','Z','a','b','c','d','e','f',
'g','h','i','j','k','l','m','n',
'o','p','q','r','s','t','u','v',
'w','x','y','z','0','1','2','3',
'4','5','6','7','8','9','+','/'
);
Encoding.encodeBase64=function(str){
if(str==null||str.length==0)return str;
var b64=Encoding.base64Chars;
var length=str.length;
var index=0;
var buf=[];
var c0,c1,c2;
while(index<length){
c0=str.charCodeAt(index++);
buf[buf.length]=b64[c0>>2];
if(index<length){
c1=str.charCodeAt(index++);
buf[buf.length]=b64[((c0<<4)&0x30)|(c1>>4)];
if(index<length){
c2=str.charCodeAt(index++);
buf[buf.length]=b64[((c1<<2)&0x3c)|(c2>>6)];
buf[buf.length]=b64[c2&0x3F];
}else{
buf[buf.length]=b64[((c1<<2)&0x3c)];
buf[buf.length]='=';
}
}else{
buf[buf.length]=b64[(c0<<4)&0x30];
buf[buf.length]='=';
buf[buf.length]='=';
}
}
return buf.join('');
};
Encoding.decodeBase64=function(str){
if(str==null||str.length==0)return str;
var b64=Encoding.base64Chars;
var xb64=Encoding.xBase64Chars;
if(Encoding.xBase64Chars==null){
xb64=new Object();
for(var i=0;i<b64.length;i++){
xb64[b64[i]]=i;
}
Encoding.xBase64Chars=xb64;
}
var length=str.length;
var index=0;
var buf=[];
var c0,c1,c2,c3;
var c=0;
while(index<length&&c++<60000){
c0=xb64[str.charAt(index++)];
c1=xb64[str.charAt(index++)];
c2=xb64[str.charAt(index++)];
c3=xb64[str.charAt(index++)];
buf[buf.length]=String.fromCharCode(((c0<<2)&0xff)|c1>>4);
if(c2!=null){
buf[buf.length]=String.fromCharCode(((c1<<4)&0xff)|c2>>2);
if(c3!=null){
buf[buf.length]=String.fromCharCode(((c2<<6)&0xff)|c3);
}
}
}
return buf.join('');
};

if(String.prototype.$replace==null){
java.lang.String=String;
if(Clazz.supportsNativeObject){
for(var i=0;i<Clazz.extendedObjectMethods.length;i++){
var p=Clazz.extendedObjectMethods[i];
if("to$tring"==p||"toString"==p||"equals"==p||"hashCode"==p){
continue;
}
String.prototype[p]=JavaObject.prototype[p];
}
}

Clazz.implementOf(String,[java.io.Serializable,CharSequence,Comparable]);

String.getName=Clazz.innerFunctions.getName;

String.serialVersionUID=String.prototype.serialVersionUID=-6849794470754667710;

String.prototype.$replace=function(c1,c2){

c1=c1.replace(/([\\\/\$\.\*\+\{\}\?\^\(\)\[\]])/g,function($0,$1){
return"\\"+$1;
});
var regExp=new RegExp(c1,"gm");
return this.replace(regExp,c2);
};
String.prototype.$generateExpFunction=function(str){
var arr=[];
var orders=[];
var idx=0;
arr[0]="";
var i=0;
for(;i<str.length;i++){
var ch=str.charAt(i);
if(i!=str.length-1&&ch=='\\'){
i++;
var c=str.charAt(i);
if(c=='\\'){
arr[idx]+='\\';
}
arr[idx]+=c;
}else if(i!=str.length-1&&ch=='$'){
i++;
orders[idx]=parseInt(str.charAt(i));
idx++;
arr[idx]="";
}else if(ch=='\r'){
arr[idx]+="\\r";
}else if(ch=='\n'){
arr[idx]+="\\n";
}else if(ch=='\t'){
arr[idx]+="\\t";
}else if(ch=='\"'){
arr[idx]+="\\\"";
}else{
arr[idx]+=ch;
}
}
var funStr="f = function (";
var max=Math.max.apply({},orders);
for(i=0;i<=max;i++){
funStr+="$"+i;
if(i!=max){
funStr+=", ";
}
}
funStr+=") { return ";
for(i=0;i<arr.length-1;i++){
funStr+="\""+arr[i]+"\" + $"+orders[i]+" + ";
}
funStr+="\""+arr[i]+"\"; }";
var f=null;
eval(funStr)
return f;
};

String.prototype.replaceAll=function(exp,str){
var regExp=new RegExp(exp,"gm");
return this.replace(regExp,this.$generateExpFunction(str));
};
String.prototype.replaceFirst=function(exp,str){
var regExp=new RegExp(exp,"m");
return this.replace(regExp,this.$generateExpFunction(str));
};
String.prototype.matches=function(exp){
if(exp!=null){
exp="^("+exp+")$";
}
var regExp=new RegExp(exp,"gm");
var m=this.match(regExp);
return m!=null&&m.length!=0;
};
String.prototype.regionMatches=function(ignoreCase,toffset,
other,ooffset,len){

if(typeof ignoreCase=="number"
||(ignoreCase!=true&&ignoreCase!=false)){
len=ooffset;
ooffset=other;
other=toffset;
toffset=ignoreCase;
ignoreCase=false;
}
var to=toffset;
var po=ooffset;

if((ooffset<0)||(toffset<0)||(toffset>this.length-len)||
(ooffset>other.length-len)){
return false;
}
var s1=this.substring(toffset,toffset+len);
var s2=other.substring(ooffset,ooffset+len);
if(ignoreCase){
s1=s1.toLowerCase();
s2=s2.toLowerCase();
}
return s1==s2;
};
String.prototype.$plit=function(regex,limit){

if(limit!=null&&limit>0){
if(limit==1){
return this;
}
var regExp=new RegExp("("+regex+")","gm");
var count=1;
var s=this.replace(regExp,function($0,$1){
count++;
if(count==limit){
return"@@_@@";
}else if(count>limit){
return $0;
}else{
return $0;
}
});
regExp=new RegExp(regex,"gm");
var arr=this.split(regExp);
if(arr.length>limit){
arr[limit-1]=s.substring(s.indexOf("@@_@@")+5);
arr.length=limit;
}
return arr;
}else{
var regExp=new RegExp(regex,"gm");
return this.split(regExp);
}
};

String.prototype.trim=function(){
var len=this.length;
var st=0;

while((st<len)&&(this.charAt(st)<=' ')){
st++;
}
while((st<len)&&(this.charAt(len-1)<=' ')){
len--;
}
return((st>0)||(len<len))?this.substring(st,len):this;
};

String.prototype.trim=function(){
return this.replace(/^\s+/g,'').replace(/\s+$/g,'');
};


String.prototype.startsWith_string_number=function(prefix,toffset){
var to=toffset;
var po=0;
var pc=prefix.length;

if((toffset<0)||(toffset>this.length-pc)){
return false;
}
while(--pc>=0){
if(this.charAt(to++)!=prefix.charAt(po++)){
return false;
}
}
return true;
};

String.prototype.startsWith=function(prefix){
if(arguments.length==1){
return this.startsWith_string_number(arguments[0],0);
}else if(arguments.length==2){
return this.startsWith_string_number(arguments[0],arguments[1]);
}else{
return false;
}
};

String.prototype.endsWith=function(suffix){
return this.startsWith(suffix,this.length-suffix.length);
};

String.prototype.equals=function(anObject){
return this.valueOf()==anObject;
};

String.prototype.equalsIgnoreCase=function(anotherString){
return(anotherString==null)?false:(this==anotherString
||this.toLowerCase()==anotherString.toLowerCase());
};


String.prototype.hash=0;

String.prototype.hashCode=function(){
var h=this.hash;
if(h==0){
var off=0;
var len=this.length;
for(var i=0;i<len;i++){
h=31*h+this.charCodeAt(off++);
h&=0xffffffff;
}
this.hash=h;
}
return h;
};

String.prototype.getBytes=function(){
if(arguments.length==4){
return this.getChars(arguments[0],arguments[1],arguments[2],arguments[3]);
}
var s=this;
if(arguments.length==1){
var cs=arguments[0].toString().toLowerCase();
var charset=[
"utf-8","UTF8","us-ascii","iso-8859-1","8859_1","gb2312","gb18030","gbk"
];
var existed=false;
for(var i=0;i<charset.length;i++){
if(charset[i]==cs){
existed=true;
break;
}
}
if(!existed){
throw new java.io.UnsupportedEncodingException();
}
if(cs=="utf-8"||cs=="utf8"){
s=Encoding.convert2UTF8(this);
}
}
var arrs=new Array(s.length);
var c=0,ii=0;
for(var i=0;i<s.length;i++){
c=s.charCodeAt(i);
if(c>255){
arrs[ii]=0x1a;
arrs[ii+1]=c&0xff;
arrs[ii+2]=(c&0xff00)>>8;
ii+=2;
}else{
arrs[ii]=c;
}
ii++;
}
return arrs;
};

String.prototype.compareTo=function(anotherString){
if(anotherString==null){
throw new java.lang.NullPointerException();
}
var len1=this.length;
var len2=anotherString.length;
var n=Math.min(len1,len2);
var k=0;
while(k<n){
var c1=this.charCodeAt(k);
var c2=anotherString.charCodeAt(k);
if(c1!=c2){
return c1-c2;
}
k++;
}
return len1-len2;
};

String.prototype.toCharArray=function(){
var result=new Array(this.length);
for(var i=0;i<this.length;i++){
result[i]=this.charAt(i);
}
return result;
};
String.value0f=String.valueOf;
String.valueOf=function(o){
if(o=="undefined"){
return String.value0f();
}
if(o instanceof Array){
if(arguments.length==1){
return o.join('');
}else{
var off=arguments[1];
var len=arguments[2];
var oo=new Array(len);
for(var i=0;i<len;i++){
oo[i]=o[off+i];
}
return oo.join('');
}
}
return""+o;
};

String.prototype.subSequence=function(beginIndex,endIndex){
return this.substring(beginIndex,endIndex);
};

String.prototype.compareToIgnoreCase=function(str){
if(str==null){
throw new NullPointerException();
}
var s1=this.toUpperCase();
var s2=str.toUpperCase();
if(s1==s2){
return 0;
}else{
var s1=this.toLowerCase();
var s2=str.toLowerCase();
if(s1==s2){
return 0;
}else if(s1>s2){
return 1;
}else{
return-1;
}
}
};

String.prototype.contentEquals=function(sb){
if(this.length!=sb.length()){
return false;
}
var v=sb.getValue();
var i=0;
var j=0;
var n=this.length;
while(n--!=0){
if(this.charCodeAt(i++)!=v[j++]){
return false;
}
}
return true;
};

String.prototype.getChars=function(srcBegin,srcEnd,dst,dstBegin){
if(srcBegin<0){
throw new StringIndexOutOfBoundsException(srcBegin);
}
if(srcEnd>this.length){
throw new StringIndexOutOfBoundsException(srcEnd);
}
if(srcBegin>srcEnd){
throw new StringIndexOutOfBoundsException(srcEnd-srcBegin);
}
if(dst==null){
throw new NullPointerException();
}
for(var i=0;i<srcEnd-srcBegin;i++){
dst[dstBegin+i]=this.charAt(srcBegin+i);
}
};
String.prototype.$concat=String.prototype.concat;
String.prototype.concat=function(s){
if(s==null){
throw new NullPointerException();
}
return this.$concat(s);
};

String.prototype.$lastIndexOf=String.prototype.lastIndexOf;
String.prototype.lastIndexOf=function(s,last){
if(last!=null&&last+this.length<=0){
return-1;
}
if(last!=null){
return this.$lastIndexOf(s,last);
}else{
return this.$lastIndexOf(s);
}
};

String.prototype.intern=function(){
return this.valueOf();
};
String.copyValueOf=String.prototype.copyValueOf=function(){
if(arguments.length==1){
return String.instantialize(arguments[0]);
}else{
return String.instantialize(arguments[0],arguments[1],arguments[2]);
}
};
String.indexOf=function(source,sourceOffset,sourceCount,
target,targetOffset,targetCount,fromIndex){
if(fromIndex>=sourceCount){
return(targetCount==0?sourceCount:-1);
}
if(fromIndex<0){
fromIndex=0;
}
if(targetCount==0){
return fromIndex;
}

var first=target[targetOffset];
var i=sourceOffset+fromIndex;
var max=sourceOffset+(sourceCount-targetCount);

startSearchForFirstChar:
while(true){

while(i<=max&&source[i]!=first){
i++;
}
if(i>max){
return-1;
}


var j=i+1;
var end=j+targetCount-1;
var k=targetOffset+1;
while(j<end){
if(source[j++]!=target[k++]){
i++;

continue startSearchForFirstChar;
}
}
return i-sourceOffset;
}
};

/*


String.instantialize=function(){
if(arguments.length==0){
return new String();
}else if(arguments.length==1){
var x=arguments[0];
if(typeof x=="string"||x instanceof String){
return new String(x);
}else if(x instanceof Array){
if(x.length>0&&typeof x[0]=="number"){
var arr=new Array(x.length);
for(var i=0;i<x.length;i++){
arr[i]=String.fromCharCode(x[i]&0xff);
}
return Encoding.readUTF8(arr.join(''));
}
return x.join('');
}else if(x.__CLASS_NAME__=="StringBuffer"
||x.__CLASS_NAME__=="java.lang.StringBuffer"){
var value=x.shareValue();
var length=x.length();
var valueCopy=new Array(length);
for(var i=0;i<length;i++){
valueCopy[i]=value[i];
}
return valueCopy.join('')

}else{
return""+x;
}
}else if(arguments.length==2){
var x=arguments[0];
var hibyte=arguments[1];
if(typeof hibyte=="string"){
return String.instantialize(x,0,x.length,hibyte);
}else{
return String.instantialize(x,hibyte,0,x.length);
}
}else if(arguments.length==3){
var bytes=arguments[0];
var offset=arguments[1];
var length=arguments[2];
if(arguments[2]instanceof Array){
bytes=arguments[2];
offset=arguments[0];
length=arguments[1];
}
var arr=new Array(length);
if(offset<0||length+offset>bytes.length){
throw new IndexOutOfBoundsException();
}
if(length>0){
var isChar=(bytes[offset].length!=null);
if(isChar){
for(var i=0;i<length;i++){
arr[i]=bytes[offset+i];
}
}else{
for(var i=0;i<length;i++){
arr[i]=String.fromCharCode(bytes[offset+i]);
}
}
}
return arr.join('');
}else if(arguments.length==4){
var bytes=arguments[0];
var y=arguments[3];
if(typeof y=="string"||y instanceof String){
var offset=arguments[1];
var length=arguments[2];
var arr=new Array(length);
for(var i=0;i<length;i++){
arr[i]=bytes[offset+i];
if(typeof arr[i]=="number"){
arr[i]=String.fromCharCode(arr[i]&0xff);
}
}
var cs=y.toLowerCase();
if(cs=="utf-8"||cs=="utf8"){
return Encoding.readUTF8(arr.join(''));
}else{
return arr.join('');
}
}else{
var count=arguments[3];
var offset=arguments[2];
var hibyte=arguments[1];
var value=new Array(count);
if(hibyte==0){
for(var i=count;i-->0;){
value[i]=String.fromCharCode(bytes[i+offset]&0xff);
}
}else{
hibyte<<=8;
for(var i=count;i-->0;){
value[i]=String.fromCharCode(hibyte|(bytes[i+offset]&0xff));
}
}
return value.join('');
}
}else{
var s="";
for(var i=0;i<arguments.length;i++){
s+=arguments[i];
}
return s;
}
};


*/


String.instantialize=function(){
switch (arguments.length) {
case 0:
	return new String();
case 1:
	var x=arguments[0];
	if(typeof x=="string"||x instanceof String){
		return new String(x);
	}
	if(x instanceof Array || x instanceof Int32Array){
		if(x.length>0&&typeof x[0]=="number"){
			var arr=new Array(x.length);
			for(var i=0;i<x.length;i++){
				arr[i]=String.fromCharCode(x[i]&0xff);
			}
			return Encoding.readUTF8(arr.join(''));
		}
		return x.join('');
	}
	if(x.__CLASS_NAME__=="StringBuffer"||x.__CLASS_NAME__=="java.lang.StringBuffer"){
		var value=x.shareValue();
		var length=x.length();
		var valueCopy=new Array(length);
		for(var i=0;i<length;i++){
			valueCopy[i]=value[i];
		}
		return valueCopy.join('')
	}
	return""+x;
case 2:	
	var x=arguments[0];
	var hibyte=arguments[1];
	if(typeof hibyte=="string"){
		return String.instantialize(x,0,x.length,hibyte);
	}
	return String.instantialize(x,hibyte,0,x.length);
case 3:
	var bytes=arguments[0];
	var offset=arguments[1];
	var length=arguments[2];
	if(arguments[2]instanceof Array){
		bytes=arguments[2];
		offset=arguments[0];
		length=arguments[1];
	}
	var arr=new Array(length);
	if(offset<0||length+offset>bytes.length){
		throw new IndexOutOfBoundsException();
	}
	if(length>0){
		var isChar=(bytes[offset].length!=null);
		if(isChar){
			for(var i=0;i<length;i++){
				arr[i]=bytes[offset+i];
			}
		}else{
			for(var i=0;i<length;i++){
				arr[i]=String.fromCharCode(bytes[offset+i]);
			}
		}
	}
	return arr.join('');
case 4:
	var bytes=arguments[0];
	var y=arguments[3];
	if(typeof y=="string"||y instanceof String){
		var offset=arguments[1];
		var length=arguments[2];
		var arr=new Array(length);
		for(var i=0;i<length;i++){
			arr[i]=bytes[offset+i];
			if(typeof arr[i]=="number"){
				arr[i]=String.fromCharCode(arr[i]&0xff);
			}
		}
		var cs=y.toLowerCase();
		if(cs=="utf-8"||cs=="utf8"){
			return Encoding.readUTF8(arr.join(''));
		}
		return arr.join('');
	}
	var count=arguments[3];
	var offset=arguments[2];
	var hibyte=arguments[1];
	var value=new Array(count);
	if(hibyte==0){
		for(var i=count;i-->0;){
			value[i]=String.fromCharCode(bytes[i+offset]&0xff);
		}
	}else{
		hibyte<<=8;
		for(var i=count;i-->0;){
			value[i]=String.fromCharCode(hibyte|(bytes[i+offset]&0xff));
		}
	}
	return value.join('');
default:
	var s="";
	for(var i=0;i<arguments.length;i++){
		s+=arguments[i];
	}
	return s;
}
};


if(navigator.userAgent.toLowerCase().indexOf("chrome")!=-1){
String.prototype.toString=function(){
return this;
};
}

}
c$=$_C(function(){
this.value=0;
$_Z(this,arguments);
},java.lang,"Character",null,[java.io.Serializable,Comparable]);
$_K(c$,
function(value){
this.value=value;
},"~N");
$_M(c$,"charValue",
function(){
return this.value;
});
$_V(c$,"hashCode",
function(){
return(this.value).charCodeAt(0);
});
$_V(c$,"equals",
function(obj){
if($_O(obj,Character)){
return(this.value).charCodeAt(0)==((obj).charValue()).charCodeAt(0);
}return false;
},"~O");
$_V(c$,"compareTo",
function(c){
return(this.value).charCodeAt(0)-(c.value).charCodeAt(0);
},"Character");
c$.toLowerCase=$_M(c$,"toLowerCase",
function(c){
return(""+c).toLowerCase().charAt(0);
},"~N");
c$.toUpperCase=$_M(c$,"toUpperCase",
function(c){
return(""+c).toUpperCase().charAt(0);
},"~N");
c$.isDigit=$_M(c$,"isDigit",
function(c){
if(('0').charCodeAt (0) <= (c).charCodeAt (0) && (c).charCodeAt (0) <= ('9').charCodeAt(0))return true;
if((c).charCodeAt(0)<1632)return false;
return false;
},"~N");
c$.isUpperCase=$_M(c$,"isUpperCase",
function(c){
if(('A').charCodeAt (0) <= (c).charCodeAt (0) && (c).charCodeAt (0) <= ('Z').charCodeAt(0)){
return true;
}return false;
},"~N");
c$.isLowerCase=$_M(c$,"isLowerCase",
function(c){
if(('a').charCodeAt (0) <= (c).charCodeAt (0) && (c).charCodeAt (0) <= ('z').charCodeAt(0)){
return true;
}return false;
},"~N");
c$.isWhitespace=$_M(c$,"isWhitespace",
function(c){
if(((c).charCodeAt(0)>=0x1c&&(c).charCodeAt(0)<=0x20)||((c).charCodeAt(0)>=0x9&&(c).charCodeAt(0)<=0xd))return true;
if((c).charCodeAt(0)==0x1680)return true;
if((c).charCodeAt(0)<0x2000||(c).charCodeAt(0)==0x2007)return false;
return(c).charCodeAt(0)<=0x200b||(c).charCodeAt(0)==0x2028||(c).charCodeAt(0)==0x2029||(c).charCodeAt(0)==0x3000;
},"~N");
c$.isLetter=$_M(c$,"isLetter",
function(c){
if((('A').charCodeAt (0) <= (c).charCodeAt (0) && (c).charCodeAt (0) <= ('Z').charCodeAt (0)) || (('a').charCodeAt (0) <= (c).charCodeAt (0) && (c).charCodeAt (0) <= ('z').charCodeAt(0)))return true;
if((c).charCodeAt(0)<128)return false;
return false;
},"~N");
c$.isLetterOrDigit=$_M(c$,"isLetterOrDigit",
function(c){
return Character.isLetter(c)||Character.isDigit(c);
},"~N");
c$.isSpaceChar=$_M(c$,"isSpaceChar",
function(c){
if((c).charCodeAt(0)==0x20||(c).charCodeAt(0)==0xa0||(c).charCodeAt(0)==0x1680)return true;
if((c).charCodeAt(0)<0x2000)return false;
return(c).charCodeAt(0)<=0x200b||(c).charCodeAt(0)==0x2028||(c).charCodeAt(0)==0x2029||(c).charCodeAt(0)==0x202f||(c).charCodeAt(0)==0x3000;
},"~N");
c$.digit=$_M(c$,"digit",
function(c,radix){
if(radix>=2&&radix<=36){
if((c).charCodeAt(0)<128){
var result=-1;
if(('0').charCodeAt (0) <= (c).charCodeAt (0) && (c).charCodeAt (0) <= ('9').charCodeAt(0)){
result=(c).charCodeAt(0)-('0').charCodeAt(0);
}else if(('a').charCodeAt (0) <= (c).charCodeAt (0) && (c).charCodeAt (0) <= ('z').charCodeAt(0)){
result=(c).charCodeAt(0)-(87);
}else if(('A').charCodeAt (0) <= (c).charCodeAt (0) && (c).charCodeAt (0) <= ('Z').charCodeAt(0)){
result=(c).charCodeAt(0)-(55);
}return result<radix?result:-1;
}}return-1;
},"~N,~N");
$_M(c$,"toString",
function(){
var buf=[this.value];
return String.valueOf(buf);
});
c$.toString=$_M(c$,"toString",
function(c){
{
if(this===Charater){
return"class java.lang.Charater";
}
}return String.valueOf(c);
},"~N");
$_S(c$,
"MIN_VALUE",'\u0000',
"MAX_VALUE",'\uffff',
"MIN_RADIX",2,
"MAX_RADIX",36,
"TYPE",null);

java.lang.Character.TYPE=java.lang.Character.prototype.TYPE=java.lang.Character;
Array.getComponentType=function(){
return Object;
};c$=$_T(java.lang.reflect,"Array");
c$.newInstance=$_M(c$,"newInstance",
function(componentType,size){
return $_A(length);
},"Class,~N");

java.util.Date=Date;
Clazz.decorateAsType(java.util.Date,"java.util.Date",null,[java.io.Serializable,Cloneable,Comparable]);

Clazz.defineMethod(java.util.Date,"clone",
function(){
return new Date(this.getTime());
});

Clazz.defineMethod(java.util.Date,"before",
function(when){
return this.getTime()<when.getTime();
},"java.util.Date");
Clazz.defineMethod(java.util.Date,"after",
function(when){
return this.getTime()>when.getTime();
},"java.util.Date");
Clazz.defineMethod(java.util.Date,"equals",
function(obj){
return Clazz.instanceOf(obj,java.util.Date)&&this.getTime()==(obj).getTime();
},"Object");
Clazz.defineMethod(java.util.Date,"compareTo",
function(anotherDate){
var thisTime=this.getTime();
var anotherTime=anotherDate.getTime();
return(thisTime<anotherTime?-1:(thisTime==anotherTime?0:1));
},"java.util.Date");
Clazz.defineMethod(java.util.Date,"compareTo",
function(o){
return this.compareTo(o);
},"Object");
Clazz.defineMethod(java.util.Date,"hashCode",
function(){
var ht=this.getTime();
return parseInt(ht)^parseInt((ht>>32));
});

c$=$_C(function(){
this.source=null;
$_Z(this,arguments);
},java.util,"EventObject",null,java.io.Serializable);
$_K(c$,
function(source){
if(source!=null)this.source=source;
else throw new IllegalArgumentException();
},"~O");
$_M(c$,"getSource",
function(){
return this.source;
});
$_V(c$,"toString",
function(){
return this.getClass().getName()+"[source="+String.valueOf(this.source)+']';
});
$_I(java.util,"EventListener");

c$=$_C(function(){
this.listener=null;
$_Z(this,arguments);
},java.util,"EventListenerProxy",null,java.util.EventListener);
$_K(c$,
function(listener){
this.listener=listener;
},"java.util.EventListener");
$_M(c$,"getListener",
function(){
return this.listener;
});
$_I(java.util,"Iterator");

$_I(java.util,"ListIterator",java.util.Iterator);
$_I(java.util,"Enumeration");
$_I(java.util,"Collection",Iterable);

$_I(java.util,"Set",java.util.Collection);
$_I(java.util,"Map");
$_I(java.util.Map,"Entry");

$_I(java.util,"List",java.util.Collection);

$_I(java.util,"Queue",java.util.Collection);
$_I(java.util,"RandomAccess");
c$=$_C(function(){
this.detailMessage=null;
this.cause=null;
this.stackTrace=null;
$_Z(this,arguments);
},java.lang,"Throwable",null,java.io.Serializable);
$_Y(c$,function(){
this.cause=this;
//alert("e0 "+ arguments.callee.caller.caller.caller.caller.caller)
});
$_K(c$,
function(){
this.fillInStackTrace();
});
$_K(c$,
function(message){
this.fillInStackTrace();
this.detailMessage=message;
},"~S");
$_K(c$,
function(message,cause){
this.fillInStackTrace();
this.detailMessage=message;
this.cause=cause;
},"~S,Throwable");
$_K(c$,
function(cause){
this.fillInStackTrace();
this.detailMessage=(cause==null?null:cause.toString());
this.cause=cause;
},"Throwable");
$_M(c$,"getMessage",
function(){
{
if(typeof this.message!="undefined"){
return this.message;
}
}return this.detailMessage;
});
$_M(c$,"getLocalizedMessage",
function(){
return this.getMessage();
});
$_M(c$,"getCause",
function(){
return(this.cause===this?null:this.cause);
});
$_M(c$,"initCause",
function(cause){
if(this.cause!==this)throw new IllegalStateException("Can't overwrite cause");
if(cause===this)throw new IllegalArgumentException("Self-causation not permitted");
this.cause=cause;
return this;
},"Throwable");
$_V(c$,"toString",
function(){
var s=this.getClass().getName();
var message=this.getLocalizedMessage();
return(message!=null)?(s+": "+message):s;
});
$_M(c$,"printStackTrace",
function(){
System.err.println(this);
for(var i=0;i<this.stackTrace.length;i++){
var t=this.stackTrace[i];
var x=t.methodName.indexOf("(");
var n=t.methodName.substring(0,x).replace(/\s+/g,"");
if(n!="construct"||t.nativeClazz==null
||Clazz.getInheritedLevel(t.nativeClazz,Throwable)<0){
System.err.println(t);
}
}
});
$_M(c$,"printStackTrace",
function(s){
this.printStackTrace();
},"java.io.PrintStream");
$_M(c$,"printStackTrace",
function(s){
this.printStackTrace();
},"java.io.PrintWriter");
$_M(c$,"fillInStackTrace",
function(){
this.stackTrace=new Array();
var caller=arguments.callee.caller;
var superCaller=null;
var callerList=new Array();
var index=Clazz.callingStackTraces.length-1;
var noLooping=true;
while(index>-1||caller!=null){
var clazzName=null;
var nativeClazz=null;
if(!noLooping||caller==Clazz.tryToSearchAndExecute||caller==$_U||caller==null){
if(index<0){
break;
}
noLooping=true;
superCaller=Clazz.callingStackTraces[index].caller;
nativeClazz=Clazz.callingStackTraces[index].owner;
index--;
}else{
superCaller=caller;
if(superCaller.claxxOwner!=null){
nativeClazz=superCaller.claxxOwner;
}else if(superCaller.exClazz!=null){
nativeClazz=superCaller.exClazz;
}
}
var st=new StackTraceElement(
((nativeClazz!=null&&nativeClazz.__CLASS_NAME__.length!=0)?
nativeClazz.__CLASS_NAME__:"anonymous"),
((superCaller.exName==null)?"anonymous":superCaller.exName)
+" ("+Clazz.getParamsType(superCaller.arguments)+")",
null,-1);
st.nativeClazz=nativeClazz;
this.stackTrace[this.stackTrace.length]=st;
for(var i=0;i<callerList.length;i++){
if(callerList[i]==superCaller){

var st=new StackTraceElement("lost","missing",null,-3);
st.nativeClazz=null;
this.stackTrace[this.stackTrace.length]=st;
noLooping=false;

}
}
if(superCaller!=null){
callerList[callerList.length]=superCaller;
}
caller=superCaller.arguments.callee.caller;
}
Clazz.initializingException=false;
return this;
});
$_M(c$,"setStackTrace",
function(stackTrace){
var defensiveCopy=stackTrace.clone();
for(var i=0;i<defensiveCopy.length;i++)if(defensiveCopy[i]==null)throw new NullPointerException("stackTrace["+i+"]");

this.stackTrace=defensiveCopy;
},"~A");

c$=$_C(function(){
this.declaringClass=null;
this.methodName=null;
this.fileName=null;
this.lineNumber=0;
$_Z(this,arguments);
},java.lang,"StackTraceElement",null,java.io.Serializable);
$_K(c$,
function(cls,method,file,line){
if(cls==null||method==null){
throw new NullPointerException();
}this.declaringClass=cls;
this.methodName=method;
this.fileName=file;
this.lineNumber=line;
},"~S,~S,~S,~N");
$_V(c$,"equals",
function(obj){
if(!($_O(obj,StackTraceElement))){
return false;
}var castObj=obj;
if((this.methodName==null)||(castObj.methodName==null)){
return false;
}if(!this.getMethodName().equals(castObj.getMethodName())){
return false;
}if(!this.getClassName().equals(castObj.getClassName())){
return false;
}var localFileName=this.getFileName();
if(localFileName==null){
if(castObj.getFileName()!=null){
return false;
}}else{
if(!localFileName.equals(castObj.getFileName())){
return false;
}}if(this.getLineNumber()!=castObj.getLineNumber()){
return false;
}return true;
},"~O");
$_M(c$,"getClassName",
function(){
return(this.declaringClass==null)?"<unknown class>":this.declaringClass;
});
$_M(c$,"getFileName",
function(){
return this.fileName;
});
$_M(c$,"getLineNumber",
function(){
return this.lineNumber;
});
$_M(c$,"getMethodName",
function(){
return(this.methodName==null)?"<unknown method>":this.methodName;
});
$_V(c$,"hashCode",
function(){
if(this.methodName==null){
return 0;
}return this.methodName.hashCode()^this.declaringClass.hashCode();
});
$_M(c$,"isNativeMethod",
function(){
return this.lineNumber==-2;
});
$_V(c$,"toString",
function(){
var buf=new StringBuilder(80);
buf.append(this.getClassName());
buf.append('.');
buf.append(this.getMethodName());
if(this.isNativeMethod()){
buf.append("(Native Method)");
}else{
var fName=this.getFileName();
if(fName==null){
buf.append("(Unknown Source)");
}else{
var lineNum=this.getLineNumber();
buf.append('(');
buf.append(fName);
if(lineNum>=0){
buf.append(':');
buf.append(lineNum);
}buf.append(')');
}}return buf.toString();
});

c$=$_T(java.lang,"Error",Throwable);

c$=$_T(java.lang,"LinkageError",Error);

c$=$_T(java.lang,"IncompatibleClassChangeError",LinkageError);

c$=$_T(java.lang,"AbstractMethodError",IncompatibleClassChangeError);

c$=$_T(java.lang,"AssertionError",Error);
$_K(c$,
function(detailMessage){
$_R(this,AssertionError,[String.valueOf(detailMessage),($_O(detailMessage,Throwable)?detailMessage:null)]);
},"~O");
$_K(c$,
function(detailMessage){
this.construct(String.valueOf(detailMessage));
},"~B");
$_K(c$,
function(detailMessage){
this.construct(String.valueOf(detailMessage));
},"~N");
$_K(c$,
function(detailMessage){
this.construct(Integer.toString(detailMessage));
},"~N");
$_K(c$,
function(detailMessage){
this.construct(Long.toString(detailMessage));
},"~N");
$_K(c$,
function(detailMessage){
this.construct(Float.toString(detailMessage));
},"~N");
$_K(c$,
function(detailMessage){
this.construct(Double.toString(detailMessage));
},"~N");

c$=$_T(java.lang,"ClassCircularityError",LinkageError);

c$=$_T(java.lang,"ClassFormatError",LinkageError);

c$=$_C(function(){
this.exception=null;
$_Z(this,arguments);
},java.lang,"ExceptionInInitializerError",LinkageError);
$_K(c$,
function(){
$_R(this,ExceptionInInitializerError);
this.initCause(null);
});
$_K(c$,
function(detailMessage){
$_R(this,ExceptionInInitializerError,[detailMessage]);
this.initCause(null);
},"~S");
$_K(c$,
function(exception){
$_R(this,ExceptionInInitializerError);
this.exception=exception;
this.initCause(exception);
},"Throwable");
$_M(c$,"getException",
function(){
return this.exception;
});
$_V(c$,"getCause",
function(){
return this.exception;
});

c$=$_T(java.lang,"IllegalAccessError",IncompatibleClassChangeError);

c$=$_T(java.lang,"InstantiationError",IncompatibleClassChangeError);

c$=$_T(java.lang,"VirtualMachineError",Error);

c$=$_T(java.lang,"InternalError",VirtualMachineError);

c$=$_T(java.lang,"NoClassDefFoundError",LinkageError);

c$=$_T(java.lang,"NoSuchFieldError",IncompatibleClassChangeError);

c$=$_T(java.lang,"NoSuchMethodError",IncompatibleClassChangeError);

c$=$_T(java.lang,"OutOfMemoryError",VirtualMachineError);

c$=$_T(java.lang,"StackOverflowError",VirtualMachineError);

c$=$_T(java.lang,"UnknownError",VirtualMachineError);

c$=$_T(java.lang,"UnsatisfiedLinkError",LinkageError);

c$=$_T(java.lang,"UnsupportedClassVersionError",ClassFormatError);

c$=$_T(java.lang,"VerifyError",LinkageError);

c$=$_T(java.lang,"ThreadDeath",Error);
$_K(c$,
function(){
$_R(this,ThreadDeath,[]);
});

c$=$_T(java.lang,"Exception",Throwable);

c$=$_T(java.lang,"RuntimeException",Exception);

c$=$_T(java.lang,"ArithmeticException",RuntimeException);

c$=$_T(java.lang,"IndexOutOfBoundsException",RuntimeException);

c$=$_T(java.lang,"ArrayIndexOutOfBoundsException",IndexOutOfBoundsException);
$_K(c$,
function(index){
$_R(this,ArrayIndexOutOfBoundsException,["Array index out of range: "+index]);
},"~N");

c$=$_T(java.lang,"ArrayStoreException",RuntimeException);

c$=$_T(java.lang,"ClassCastException",RuntimeException);

c$=$_C(function(){
this.ex=null;
$_Z(this,arguments);
},java.lang,"ClassNotFoundException",Exception);
$_K(c$,
function(){
$_R(this,ClassNotFoundException,[Clazz.castNullAs("Throwable")]);
});
$_K(c$,
function(detailMessage){
$_R(this,ClassNotFoundException,[detailMessage,null]);
},"~S");
$_K(c$,
function(detailMessage,exception){
$_R(this,ClassNotFoundException,[detailMessage]);
this.ex=exception;
},"~S,Throwable");
$_M(c$,"getException",
function(){
return this.ex;
});
$_V(c$,"getCause",
function(){
return this.ex;
});

c$=$_T(java.lang,"CloneNotSupportedException",Exception);

c$=$_T(java.lang,"IllegalAccessException",Exception);

c$=$_T(java.lang,"IllegalArgumentException",RuntimeException);
$_K(c$,
function(cause){
$_R(this,IllegalArgumentException,[(cause==null?null:cause.toString()),cause]);
},"Throwable");

c$=$_T(java.lang,"IllegalMonitorStateException",RuntimeException);

c$=$_T(java.lang,"IllegalStateException",RuntimeException);
$_K(c$,
function(cause){
$_R(this,IllegalStateException,[(cause==null?null:cause.toString()),cause]);
},"Throwable");

c$=$_T(java.lang,"IllegalThreadStateException",IllegalArgumentException);

c$=$_T(java.lang,"InstantiationException",Exception);

c$=$_T(java.lang,"InterruptedException",Exception);

c$=$_T(java.lang,"NegativeArraySizeException",RuntimeException);

c$=$_T(java.lang,"NoSuchFieldException",Exception);

c$=$_T(java.lang,"NoSuchMethodException",Exception);

c$=$_T(java.lang,"NullPointerException",RuntimeException);

c$=$_T(java.lang,"NumberFormatException",IllegalArgumentException);

c$=$_T(java.lang,"SecurityException",RuntimeException);
$_K(c$,
function(cause){
$_R(this,SecurityException,[(cause==null?null:cause.toString()),cause]);
},"Throwable");

c$=$_T(java.lang,"StringIndexOutOfBoundsException",IndexOutOfBoundsException);
$_K(c$,
function(index){
$_R(this,StringIndexOutOfBoundsException,["String index out of range: "+index]);
},"~N");

c$=$_T(java.lang,"UnsupportedOperationException",RuntimeException);
$_K(c$,
function(){
$_R(this,UnsupportedOperationException,[]);
});
$_K(c$,
function(cause){
$_R(this,UnsupportedOperationException,[(cause==null?null:cause.toString()),cause]);
},"Throwable");

c$=$_C(function(){
this.target=null;
$_Z(this,arguments);
},java.lang.reflect,"InvocationTargetException",Exception);
$_K(c$,
function(){
$_R(this,java.lang.reflect.InvocationTargetException,[Clazz.castNullAs("Throwable")]);
});
$_K(c$,
function(exception){
$_R(this,java.lang.reflect.InvocationTargetException,[null,exception]);
this.target=exception;
},"Throwable");
$_K(c$,
function(exception,detailMessage){
$_R(this,java.lang.reflect.InvocationTargetException,[detailMessage,exception]);
this.target=exception;
},"Throwable,~S");
$_M(c$,"getTargetException",
function(){
return this.target;
});
$_V(c$,"getCause",
function(){
return this.target;
});

c$=$_C(function(){
this.undeclaredThrowable=null;
$_Z(this,arguments);
},java.lang.reflect,"UndeclaredThrowableException",RuntimeException);
$_K(c$,
function(exception){
$_R(this,java.lang.reflect.UndeclaredThrowableException);
this.undeclaredThrowable=exception;
this.initCause(exception);
},"Throwable");
$_K(c$,
function(exception,detailMessage){
$_R(this,java.lang.reflect.UndeclaredThrowableException,[detailMessage]);
this.undeclaredThrowable=exception;
this.initCause(exception);
},"Throwable,~S");
$_M(c$,"getUndeclaredThrowable",
function(){
return this.undeclaredThrowable;
});
$_V(c$,"getCause",
function(){
return this.undeclaredThrowable;
});

c$=$_T(java.io,"IOException",Exception);


c$=$_T(java.io,"CharConversionException",java.io.IOException);

c$=$_T(java.io,"EOFException",java.io.IOException);

c$=$_T(java.io,"FileNotFoundException",java.io.IOException);

c$=$_C(function(){
this.bytesTransferred=0;
$_Z(this,arguments);
},java.io,"InterruptedIOException",java.io.IOException);

c$=$_T(java.io,"ObjectStreamException",java.io.IOException);

c$=$_C(function(){
this.classname=null;
$_Z(this,arguments);
},java.io,"InvalidClassException",java.io.ObjectStreamException);
$_K(c$,
function(className,detailMessage){
$_R(this,java.io.InvalidClassException,[detailMessage]);
this.classname=className;
},"~S,~S");
$_M(c$,"getMessage",
function(){
var msg=$_U(this,java.io.InvalidClassException,"getMessage",[]);
if(this.classname!=null){
msg=this.classname+';' + ' '+msg;
}return msg;
});

c$=$_T(java.io,"InvalidObjectException",java.io.ObjectStreamException);

c$=$_T(java.io,"NotActiveException",java.io.ObjectStreamException);

c$=$_T(java.io,"NotSerializableException",java.io.ObjectStreamException);

c$=$_C(function(){
this.eof=false;
this.length=0;
$_Z(this,arguments);
},java.io,"OptionalDataException",java.io.ObjectStreamException);

c$=$_T(java.io,"StreamCorruptedException",java.io.ObjectStreamException);

c$=$_T(java.io,"SyncFailedException",java.io.IOException);

c$=$_T(java.io,"UnsupportedEncodingException",java.io.IOException);

c$=$_T(java.io,"UTFDataFormatException",java.io.IOException);

c$=$_C(function(){
this.detail=null;
$_Z(this,arguments);
},java.io,"WriteAbortedException",java.io.ObjectStreamException);
$_K(c$,
function(detailMessage,rootCause){
$_R(this,java.io.WriteAbortedException,[detailMessage]);
this.detail=rootCause;
this.initCause(rootCause);
},"~S,Exception");
$_M(c$,"getMessage",
function(){
var msg=$_U(this,java.io.WriteAbortedException,"getMessage",[]);
if(this.detail!=null){
msg=msg+"; "+this.detail.toString();
}return msg;
});
$_V(c$,"getCause",
function(){
return this.detail;
});

c$=$_T(java.util,"ConcurrentModificationException",RuntimeException);
$_K(c$,
function(){
$_R(this,java.util.ConcurrentModificationException,[]);
});

c$=$_T(java.util,"EmptyStackException",RuntimeException);

c$=$_C(function(){
this.className=null;
this.key=null;
$_Z(this,arguments);
},java.util,"MissingResourceException",RuntimeException);
$_K(c$,
function(detailMessage,className,resourceName){
$_R(this,java.util.MissingResourceException,[detailMessage]);
this.className=className;
this.key=resourceName;
},"~S,~S,~S");
$_M(c$,"getClassName",
function(){
return this.className;
});
$_M(c$,"getKey",
function(){
return this.key;
});

c$=$_T(java.util,"NoSuchElementException",RuntimeException);

c$=$_T(java.util,"TooManyListenersException",Exception);

c$=$_T(java.lang,"Void");
$_S(c$,
"TYPE",null);
{
java.lang.Void.TYPE=java.lang.Void;
}$_I(java.lang.reflect,"GenericDeclaration");
$_I(java.lang.reflect,"AnnotatedElement");

c$=$_T(java.lang.reflect,"AccessibleObject",null,java.lang.reflect.AnnotatedElement);
$_K(c$,
function(){
});
$_M(c$,"isAccessible",
function(){
return false;
});
c$.setAccessible=$_M(c$,"setAccessible",
function(objects,flag){
return;
},"~A,~B");
$_M(c$,"setAccessible",
function(flag){
return;
},"~B");
$_V(c$,"isAnnotationPresent",
function(annotationType){
return false;
},"Class");
$_V(c$,"getDeclaredAnnotations",
function(){
return new Array(0);
});
$_V(c$,"getAnnotations",
function(){
return new Array(0);
});
$_V(c$,"getAnnotation",
function(annotationType){
return null;
},"Class");
c$.marshallArguments=$_M(c$,"marshallArguments",
function(parameterTypes,args){
return null;
},"~A,~A");
$_M(c$,"invokeV",
function(receiver,args){
return;
},"~O,~A");
$_M(c$,"invokeL",
function(receiver,args){
return null;
},"~O,~A");
$_M(c$,"invokeI",
function(receiver,args){
return 0;
},"~O,~A");
$_M(c$,"invokeJ",
function(receiver,args){
return 0;
},"~O,~A");
$_M(c$,"invokeF",
function(receiver,args){
return 0.0;
},"~O,~A");
$_M(c$,"invokeD",
function(receiver,args){
return 0.0;
},"~O,~A");
c$.emptyArgs=c$.prototype.emptyArgs=new Array(0);
$_I(java.lang.reflect,"InvocationHandler");
c$=$_I(java.lang.reflect,"Member");
$_S(c$,
"PUBLIC",0,
"DECLARED",1);

c$=$_T(java.lang.reflect,"Modifier");
$_K(c$,
function(){
});
c$.isAbstract=$_M(c$,"isAbstract",
function(modifiers){
return((modifiers&1024)!=0);
},"~N");
c$.isFinal=$_M(c$,"isFinal",
function(modifiers){
return((modifiers&16)!=0);
},"~N");
c$.isInterface=$_M(c$,"isInterface",
function(modifiers){
return((modifiers&512)!=0);
},"~N");
c$.isNative=$_M(c$,"isNative",
function(modifiers){
return((modifiers&256)!=0);
},"~N");
c$.isPrivate=$_M(c$,"isPrivate",
function(modifiers){
return((modifiers&2)!=0);
},"~N");
c$.isProtected=$_M(c$,"isProtected",
function(modifiers){
return((modifiers&4)!=0);
},"~N");
c$.isPublic=$_M(c$,"isPublic",
function(modifiers){
return((modifiers&1)!=0);
},"~N");
c$.isStatic=$_M(c$,"isStatic",
function(modifiers){
return((modifiers&8)!=0);
},"~N");
c$.isStrict=$_M(c$,"isStrict",
function(modifiers){
return((modifiers&2048)!=0);
},"~N");
c$.isSynchronized=$_M(c$,"isSynchronized",
function(modifiers){
return((modifiers&32)!=0);
},"~N");
c$.isTransient=$_M(c$,"isTransient",
function(modifiers){
return((modifiers&128)!=0);
},"~N");
c$.isVolatile=$_M(c$,"isVolatile",
function(modifiers){
return((modifiers&64)!=0);
},"~N");
c$.toString=$_M(c$,"toString",
function(modifiers){
var sb=new Array(0);
if(java.lang.reflect.Modifier.isPublic(modifiers))sb[sb.length]="public";
if(java.lang.reflect.Modifier.isProtected(modifiers))sb[sb.length]="protected";
if(java.lang.reflect.Modifier.isPrivate(modifiers))sb[sb.length]="private";
if(java.lang.reflect.Modifier.isAbstract(modifiers))sb[sb.length]="abstract";
if(java.lang.reflect.Modifier.isStatic(modifiers))sb[sb.length]="static";
if(java.lang.reflect.Modifier.isFinal(modifiers))sb[sb.length]="final";
if(java.lang.reflect.Modifier.isTransient(modifiers))sb[sb.length]="transient";
if(java.lang.reflect.Modifier.isVolatile(modifiers))sb[sb.length]="volatile";
if(java.lang.reflect.Modifier.isSynchronized(modifiers))sb[sb.length]="synchronized";
if(java.lang.reflect.Modifier.isNative(modifiers))sb[sb.length]="native";
if(java.lang.reflect.Modifier.isStrict(modifiers))sb[sb.length]="strictfp";
if(java.lang.reflect.Modifier.isInterface(modifiers))sb[sb.length]="interface";
if(sb.length>0){
return sb.join(" ");
}return"";
},"~N");
$_S(c$,
"PUBLIC",0x1,
"PRIVATE",0x2,
"PROTECTED",0x4,
"STATIC",0x8,
"FINAL",0x10,
"SYNCHRONIZED",0x20,
"VOLATILE",0x40,
"TRANSIENT",0x80,
"NATIVE",0x100,
"INTERFACE",0x200,
"ABSTRACT",0x400,
"STRICT",0x800,
"BRIDGE",0x40,
"VARARGS",0x80,
"SYNTHETIC",0x1000,
"ANNOTATION",0x2000,
"ENUM",0x4000);

c$=$_C(function(){
this.clazz=null;
this.parameterTypes=null;
this.exceptionTypes=null;
this.modifiers=0;
$_Z(this,arguments);
},java.lang.reflect,"Constructor",java.lang.reflect.AccessibleObject,[java.lang.reflect.GenericDeclaration,java.lang.reflect.Member]);
$_K(c$,
function(declaringClass,parameterTypes,checkedExceptions,modifiers){
$_R(this,java.lang.reflect.Constructor,[]);
this.clazz=declaringClass;
this.parameterTypes=parameterTypes;
this.exceptionTypes=checkedExceptions;
this.modifiers=modifiers;
},"Class,~A,~A,~N");
$_V(c$,"getTypeParameters",
function(){
return null;
});
$_M(c$,"toGenericString",
function(){
return null;
});
$_M(c$,"getGenericParameterTypes",
function(){
return null;
});
$_M(c$,"getGenericExceptionTypes",
function(){
return null;
});
$_M(c$,"getParameterAnnotations",
function(){
return null;
});
$_M(c$,"isVarArgs",
function(){
return false;
});
$_V(c$,"isSynthetic",
function(){
return false;
});
$_V(c$,"equals",
function(object){
if(object!=null&&$_O(object,java.lang.reflect.Constructor)){
var other=object;
if(this.getDeclaringClass()===other.getDeclaringClass()){
var params1=this.parameterTypes;
var params2=other.parameterTypes;
if(params1.length==params2.length){
for(var i=0;i<params1.length;i++){
if(params1[i]!==params2[i])return false;
}
return true;
}}}return false;
},"~O");
$_V(c$,"getDeclaringClass",
function(){
return this.clazz;
});
$_M(c$,"getExceptionTypes",
function(){
return this.exceptionTypes;
});
$_V(c$,"getModifiers",
function(){
return this.modifiers;
});
$_V(c$,"getName",
function(){
return this.getDeclaringClass().getName();
});
$_M(c$,"getParameterTypes",
function(){
return this.parameterTypes;
});
$_V(c$,"hashCode",
function(){
return this.getDeclaringClass().getName().hashCode();
});
$_M(c$,"newInstance",
function(args){
var instance=new this.clazz($_G);
$_Z(instance,args);
return instance;
},"~A");
$_V(c$,"toString",
function(){
return null;
});

c$=$_T(java.lang.reflect,"Field",java.lang.reflect.AccessibleObject,java.lang.reflect.Member);
$_V(c$,"isSynthetic",
function(){
return false;
});
$_M(c$,"toGenericString",
function(){
return null;
});
$_M(c$,"isEnumConstant",
function(){
return false;
});
$_M(c$,"getGenericType",
function(){
return null;
});
$_V(c$,"equals",
function(object){
return false;
},"~O");
$_V(c$,"getDeclaringClass",
function(){
return null;
});
$_V(c$,"getName",
function(){
return null;
});
$_M(c$,"getType",
function(){
return null;
});
$_V(c$,"hashCode",
function(){
return 0;
});
$_V(c$,"toString",
function(){
return null;
});

c$=$_C(function(){
this.clazz=null;
this.name=null;
this.returnType=null;
this.parameterTypes=null;
this.exceptionTypes=null;
this.modifiers=0;
$_Z(this,arguments);
},java.lang.reflect,"Method",java.lang.reflect.AccessibleObject,[java.lang.reflect.GenericDeclaration,java.lang.reflect.Member]);
$_K(c$,
function(declaringClass,name,parameterTypes,returnType,checkedExceptions,modifiers){
$_R(this,java.lang.reflect.Method,[]);
this.clazz=declaringClass;
this.name=name;
this.parameterTypes=parameterTypes;
this.returnType=returnType;
this.exceptionTypes=checkedExceptions;
this.modifiers=modifiers;
},"Class,~S,~A,Class,~A,~N");
$_V(c$,"getTypeParameters",
function(){
return null;
});
$_M(c$,"toGenericString",
function(){
return null;
});
$_M(c$,"getGenericParameterTypes",
function(){
return null;
});
$_M(c$,"getGenericExceptionTypes",
function(){
return null;
});
$_M(c$,"getGenericReturnType",
function(){
return null;
});
$_M(c$,"getParameterAnnotations",
function(){
return null;
});
$_M(c$,"isVarArgs",
function(){
return false;
});
$_M(c$,"isBridge",
function(){
return false;
});
$_V(c$,"isSynthetic",
function(){
return false;
});
$_M(c$,"getDefaultValue",
function(){
return null;
});
$_V(c$,"equals",
function(object){
if(object!=null&&$_O(object,java.lang.reflect.Method)){
var other=object;
if((this.getDeclaringClass()===other.getDeclaringClass())&&(this.getName()===other.getName())){
var params1=this.parameterTypes;
var params2=other.parameterTypes;
if(params1.length==params2.length){
for(var i=0;i<params1.length;i++){
if(params1[i]!==params2[i])return false;
}
return true;
}}}return false;
},"~O");
$_V(c$,"getDeclaringClass",
function(){
return this.clazz;
});
$_M(c$,"getExceptionTypes",
function(){
return this.exceptionTypes;
});
$_V(c$,"getModifiers",
function(){
return this.modifiers;
});
$_V(c$,"getName",
function(){
return this.name;
});
$_M(c$,"getParameterTypes",
function(){
return this.parameterTypes;
});
$_M(c$,"getReturnType",
function(){
return this.returnType;
});
$_V(c$,"hashCode",
function(){
return this.getDeclaringClass().getName().hashCode()^this.getName().hashCode();
});
$_M(c$,"invoke",
function(receiver,args){
var m=this.clazz.prototype[this.getName()];
if(m==null){
m=this.clazz[this.getName()];
}
if(m!=null){
m.apply(receiver,args);
}else{

}
},"~O,~A");
$_V(c$,"toString",
function(){
return null;
});
$_J("java.net");
c$=$_T(java.net,"URLEncoder");
c$.encode=$_M(c$,"encode",
function(s){
return encodeURIComponent(arguments[0]);
},"~S");
c$.encode=$_M(c$,"encode",
function(s,enc){
return encodeURIComponent(arguments[0]);
},"~S,~S");
$_S(c$,
"digits","0123456789ABCDEF");

c$=$_T(java.net,"MalformedURLException",java.io.IOException);




$_J("java.net");
$_L(null,"java.net.URLDecoder",["java.lang.NullPointerException"],function(){
c$=$_T(java.net,"URLDecoder");
c$.decode=$_M(c$,"decode",
function(s){
return decodeURIComponent(arguments[0]);
},"~S");
c$.decode=$_M(c$,"decode",
function(s,enc){
if(enc==null){
throw new NullPointerException();
}{
return decodeURIComponent(arguments[0]);
}return null;
},"~S,~S");
});

Clazz.declarePackage ("java.net");
Clazz.declareInterface (java.net, "URLStreamHandlerFactory");

Clazz.declarePackage ("java.net");
Clazz.load (null, "java.net.URLStreamHandler", ["java.lang.IllegalArgumentException", "$.SecurityException", "$.StringBuffer", "$.UnsupportedOperationException"], function () {
c$ = Clazz.declareType (java.net, "URLStreamHandler");
Clazz.defineMethod (c$, "openConnection",
function (u, p) {
throw  new UnsupportedOperationException ("Method not implemented.");
}, "java.net.URL,java.net.Proxy");
Clazz.defineMethod (c$, "parseURL",
function (u, spec, start, limit) {
var protocol = u.getProtocol ();
var authority = u.getAuthority ();
var userInfo = u.getUserInfo ();
var host = u.getHost ();
var port = u.getPort ();
var path = u.getPath ();
var query = u.getQuery ();
var ref = u.getRef ();
var isRelPath = false;
var queryOnly = false;
if (start < limit) {
var queryStart = spec.indexOf ('?');
queryOnly = queryStart == start;
if ((queryStart != -1) && (queryStart < limit)) {
query = spec.substring (queryStart + 1, limit);
if (limit > queryStart) limit = queryStart;
spec = spec.substring (0, queryStart);
}}var i = 0;
var isUNCName = (start <= limit - 4) && ((spec.charAt (start)).charCodeAt (0) == ('/').charCodeAt (0)) && ((spec.charAt (start + 1)).charCodeAt (0) == ('/').charCodeAt (0)) && ((spec.charAt (start + 2)).charCodeAt (0) == ('/').charCodeAt (0)) && ((spec.charAt (start + 3)).charCodeAt (0) == ('/').charCodeAt (0));
if (!isUNCName && (start <= limit - 2) && ((spec.charAt (start)).charCodeAt (0) == ('/').charCodeAt (0)) && ((spec.charAt (start + 1)).charCodeAt (0) == ('/').charCodeAt (0))) {
start += 2;
i = spec.indexOf ('/', start);
if (i < 0) {
i = spec.indexOf ('?', start);
if (i < 0) i = limit;
}host = authority = spec.substring (start, i);
var ind = authority.indexOf ('@');
if (ind != -1) {
userInfo = authority.substring (0, ind);
host = authority.substring (ind + 1);
} else {
userInfo = null;
}if (host != null) {
if (host.length > 0 && ((host.charAt (0)).charCodeAt (0) == ('[').charCodeAt (0))) {
throw  new IllegalArgumentException ("Invalid host: " + host);
} else {
ind = host.indexOf (':');
port = -1;
if (ind >= 0) {
if (host.length > (ind + 1)) {
port = Integer.parseInt (host.substring (ind + 1));
}host = host.substring (0, ind);
}}} else {
host = "";
}if (port < -1) throw  new IllegalArgumentException ("Invalid port number :" + port);
start = i;
if (authority != null && authority.length > 0) path = "";
}if (host == null) {
host = "";
}if (start < limit) {
if ((spec.charAt (start)).charCodeAt (0) == ('/').charCodeAt (0)) {
path = spec.substring (start, limit);
} else if (path != null && path.length > 0) {
isRelPath = true;
var ind = path.lastIndexOf ('/');
var seperator = "";
if (ind == -1 && authority != null) seperator = "/";
path = path.substring (0, ind + 1) + seperator + spec.substring (start, limit);
} else {
var seperator = (authority != null) ? "/" : "";
path = seperator + spec.substring (start, limit);
}} else if (queryOnly && path != null) {
var ind = path.lastIndexOf ('/');
if (ind < 0) ind = 0;
path = path.substring (0, ind) + "/";
}if (path == null) path = "";
if (isRelPath) {
while ((i = path.indexOf ("/./")) >= 0) {
path = path.substring (0, i) + path.substring (i + 2);
}
i = 0;
while ((i = path.indexOf ("/../", i)) >= 0) {
if (i > 0 && (limit = path.lastIndexOf ('/', i - 1)) >= 0 && (path.indexOf ("/../", limit) != 0)) {
path = path.substring (0, limit) + path.substring (i + 3);
i = 0;
} else {
i = i + 3;
}}
while (path.endsWith ("/..")) {
i = path.indexOf ("/..");
if ((limit = path.lastIndexOf ('/', i - 1)) >= 0) {
path = path.substring (0, limit + 1);
} else {
break;
}}
if (path.startsWith ("./") && path.length > 2) path = path.substring (2);
if (path.endsWith ("/.")) path = path.substring (0, path.length - 1);
}this.setURL (u, protocol, host, port, authority, userInfo, path, query, ref);
}, "java.net.URL,~S,~N,~N");
Clazz.defineMethod (c$, "getDefaultPort",
function () {
return -1;
});
Clazz.defineMethod (c$, "equals",
function (u1, u2) {
var ref1 = u1.getRef ();
var ref2 = u2.getRef ();
return (ref1 === ref2 || (ref1 != null && ref1.equals (ref2))) && this.sameFile (u1, u2);
}, "java.net.URL,java.net.URL");
Clazz.defineMethod (c$, "hashCode",
function (u) {
var h = 0;
var protocol = u.getProtocol ();
if (protocol != null) h += protocol.hashCode ();
h += u.toString ().hashCode ();
var file = u.getFile ();
if (file != null) h += file.hashCode ();
if (u.getPort () == -1) h += this.getDefaultPort ();
 else h += u.getPort ();
var ref = u.getRef ();
if (ref != null) h += ref.hashCode ();
return h;
}, "java.net.URL");
Clazz.defineMethod (c$, "sameFile",
function (u1, u2) {
if (!((u1.getProtocol () === u2.getProtocol ()) || (u1.getProtocol () != null && u1.getProtocol ().equalsIgnoreCase (u2.getProtocol ())))) return false;
if (!(u1.getFile () === u2.getFile () || (u1.getFile () != null && u1.getFile ().equals (u2.getFile ())))) return false;
var port1;
var port2;
port1 = (u1.getPort () != -1) ? u1.getPort () : u1.handler.getDefaultPort ();
port2 = (u2.getPort () != -1) ? u2.getPort () : u2.handler.getDefaultPort ();
if (port1 != port2) return false;
if (!this.hostsEqual (u1, u2)) return false;
return true;
}, "java.net.URL,java.net.URL");
Clazz.defineMethod (c$, "hostsEqual",
function (u1, u2) {
if (u1.getHost () != null && u2.getHost () != null) return u1.getHost ().equalsIgnoreCase (u2.getHost ());
 else return u1.getHost () == null && u2.getHost () == null;
}, "java.net.URL,java.net.URL");
Clazz.defineMethod (c$, "toExternalForm",
function (u) {
var len = u.getProtocol ().length + 1;
if (u.getAuthority () != null && u.getAuthority ().length > 0) len += 2 + u.getAuthority ().length;
if (u.getPath () != null) {
len += u.getPath ().length;
}if (u.getQuery () != null) {
len += 1 + u.getQuery ().length;
}if (u.getRef () != null) len += 1 + u.getRef ().length;
var result =  new StringBuffer (len);
result.append (u.getProtocol ());
result.append (":");
if (u.getAuthority () != null && u.getAuthority ().length > 0) {
result.append ("//");
result.append (u.getAuthority ());
}if (u.getPath () != null) {
result.append (u.getPath ());
}if (u.getQuery () != null) {
result.append ('?');
result.append (u.getQuery ());
}if (u.getRef () != null) {
result.append ("#");
result.append (u.getRef ());
}return result.toString ();
}, "java.net.URL");
Clazz.defineMethod (c$, "setURL",
function (u, protocol, host, port, authority, userInfo, path, query, ref) {
if (this !== u.handler) {
throw  new SecurityException ("handler for url different from this handler");
}u.set (u.getProtocol (), host, port, authority, userInfo, path, query, ref);
}, "java.net.URL,~S,~S,~N,~S,~S,~S,~S,~S");
Clazz.defineMethod (c$, "setURL",
function (u, protocol, host, port, file, ref) {
var authority = null;
var userInfo = null;
if (host != null && host.length != 0) {
authority = (port == -1) ? host : host + ":" + port;
var at = host.lastIndexOf ('@');
if (at != -1) {
userInfo = host.substring (0, at);
host = host.substring (at + 1);
}}var path = null;
var query = null;
if (file != null) {
var q = file.lastIndexOf ('?');
if (q != -1) {
query = file.substring (q + 1);
path = file.substring (0, q);
} else path = file;
}this.setURL (u, protocol, host, port, authority, userInfo, path, query, ref);
}, "java.net.URL,~S,~S,~N,~S,~S");
});

Clazz.declarePackage ("java.net");
c$ = Clazz.decorateAsClass (function () {
this.path = null;
this.query = null;
this.ref = null;
Clazz.instantialize (this, arguments);
}, java.net, "Parts");
Clazz.makeConstructor (c$,
function (file) {
var ind = file.indexOf ('#');
this.ref = ind < 0 ? null : file.substring (ind + 1);
file = ind < 0 ? file : file.substring (0, ind);
var q = file.lastIndexOf ('?');
if (q != -1) {
this.query = file.substring (q + 1);
this.path = file.substring (0, q);
} else {
this.path = file;
}}, "~S");
Clazz.defineMethod (c$, "getPath",
function () {
return this.path;
});
Clazz.defineMethod (c$, "getQuery",
function () {
return this.query;
});
Clazz.defineMethod (c$, "getRef",
function () {
return this.ref;
});

Clazz.declarePackage ("java.net");
Clazz.load (["java.util.Hashtable"], "java.net.URL", ["java.io.IOException", "java.lang.Character", "$.Error", "java.net.MalformedURLException", "$.Parts"], function () {
c$ = Clazz.decorateAsClass (function () {
this.protocol = null;
this.host = null;
this.port = -1;
this.file = null;
this.query = null;
this.authority = null;
this.path = null;
this.userInfo = null;
this.ref = null;
this.handler = null;
this.$hashCode = -1;
Clazz.instantialize (this, arguments);
}, java.net, "URL", null, java.io.Serializable);
Clazz.makeConstructor (c$,
function (protocol, host, port, file) {
this.construct (protocol, host, port, file, null);
}, "~S,~S,~N,~S");
Clazz.makeConstructor (c$,
function (protocol, host, file) {
this.construct (protocol, host, -1, file);
}, "~S,~S,~S");
Clazz.makeConstructor (c$,
function (protocol, host, port, file, handler) {
if (handler != null) {
var sm = System.getSecurityManager ();
if (sm != null) {
this.checkSpecifyHandler (sm);
}}protocol = protocol.toLowerCase ();
this.protocol = protocol;
if (host != null) {
if (host.indexOf (':') >= 0 && !host.startsWith ("[")) {
host = "[" + host + "]";
}this.host = host;
if (port < -1) {
throw  new java.net.MalformedURLException ("Invalid port number :" + port);
}this.port = port;
this.authority = (port == -1) ? host : host + ":" + port;
}var parts =  new java.net.Parts (file);
this.path = parts.getPath ();
this.query = parts.getQuery ();
if (this.query != null) {
this.file = this.path + "?" + this.query;
} else {
this.file = this.path;
}this.ref = parts.getRef ();
if (handler == null && (handler = java.net.URL.getURLStreamHandler (protocol)) == null) {
throw  new java.net.MalformedURLException ("unknown protocol: " + protocol);
}this.handler = handler;
}, "~S,~S,~N,~S,java.net.URLStreamHandler");
Clazz.makeConstructor (c$,
function (spec) {
this.construct (null, spec);
}, "~S");
Clazz.makeConstructor (c$,
function (context, spec) {
this.construct (context, spec, null);
}, "java.net.URL,~S");
Clazz.makeConstructor (c$,
function (context, spec, handler) {
var original = spec;
var i;
var limit;
var c;
var start = 0;
var newProtocol = null;
var aRef = false;
var isRelative = false;
if (handler != null) {
var sm = System.getSecurityManager ();
if (sm != null) {
this.checkSpecifyHandler (sm);
}}try {
limit = spec.length;
while ((limit > 0) && ((spec.charAt (limit - 1)).charCodeAt (0) <= (' ').charCodeAt (0))) {
limit--;
}
while ((start < limit) && ((spec.charAt (start)).charCodeAt (0) <= (' ').charCodeAt (0))) {
start++;
}
if (spec.regionMatches (true, start, "url:", 0, 4)) {
start += 4;
}if (start < spec.length && (spec.charAt (start)).charCodeAt (0) == ('#').charCodeAt (0)) {
aRef = true;
}for (i = start; !aRef && (i < limit) && ((c = (spec.charAt (i)).charCodeAt (0)) != ('/').charCodeAt (0)); i++) {
if (c == (':').charCodeAt (0)) {
var s = spec.substring (start, i).toLowerCase ();
if (this.isValidProtocol (s)) {
newProtocol = s;
start = i + 1;
}break;
}}
this.protocol = newProtocol;
if ((context != null) && ((newProtocol == null) || newProtocol.equalsIgnoreCase (context.protocol))) {
if (handler == null) {
handler = context.handler;
}if (context.path != null && context.path.startsWith ("/")) newProtocol = null;
if (newProtocol == null) {
this.protocol = context.protocol;
this.authority = context.authority;
this.userInfo = context.userInfo;
this.host = context.host;
this.port = context.port;
this.file = context.file;
this.path = context.path;
isRelative = true;
}}if (this.protocol == null) {
throw  new java.net.MalformedURLException ("no protocol: " + original);
}if (handler == null && (handler = java.net.URL.getURLStreamHandler (this.protocol)) == null) {
throw  new java.net.MalformedURLException ("unknown protocol: " + this.protocol);
}this.handler = handler;
i = spec.indexOf ('#', start);
if (i >= 0) {
this.ref = spec.substring (i + 1, limit);
limit = i;
}if (isRelative && start == limit) {
this.query = context.query;
if (this.ref == null) {
this.ref = context.ref;
}}
//Clazz.alert(["corz URL ", handler])
handler.parseURL (this, spec, start, limit);
} catch (e$$) {
if (Clazz.instanceOf (e$$, java.net.MalformedURLException)) {
var e = e$$;
{
throw e;
}
} else if (Clazz.instanceOf (e$$, Exception)) {
var e = e$$;
{
var exception =  new java.net.MalformedURLException (e.getMessage ());
exception.initCause (e);
throw exception;
}
} else {
throw e$$;
}
}
}, "java.net.URL,~S,java.net.URLStreamHandler");
Clazz.defineMethod (c$, "isValidProtocol",
($fz = function (protocol) {
var len = protocol.length;
if (len < 1) return false;
var c = protocol.charAt (0);
if (!Character.isLetter (c)) return false;
for (var i = 1; i < len; i++) {
c = protocol.charAt (i);
if (!Character.isLetterOrDigit (c) && (c).charCodeAt (0) != ('.').charCodeAt (0) && (c).charCodeAt (0) != ('+').charCodeAt (0) && (c).charCodeAt (0) != ('-').charCodeAt (0)) {
return false;
}}
return true;
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "checkSpecifyHandler",
($fz = function (sm) {
}, $fz.isPrivate = true, $fz), "SecurityManager");
Clazz.defineMethod (c$, "set",
function (protocol, host, port, file, ref) {
{
this.protocol = protocol;
this.host = host;
this.authority = port == -1 ? host : host + ":" + port;
this.port = port;
this.file = file;
this.ref = ref;
this.$hashCode = -1;
var q = file.lastIndexOf ('?');
if (q != -1) {
this.query = file.substring (q + 1);
this.path = file.substring (0, q);
} else this.path = file;
}}, "~S,~S,~N,~S,~S");
Clazz.defineMethod (c$, "set",
function (protocol, host, port, authority, userInfo, path, query, ref) {
{
this.protocol = protocol;
this.host = host;
this.port = port;
this.file = query == null ? path : path + "?" + query;
this.userInfo = userInfo;
this.path = path;
this.ref = ref;
this.$hashCode = -1;
this.query = query;
this.authority = authority;
}}, "~S,~S,~N,~S,~S,~S,~S,~S");
Clazz.defineMethod (c$, "getQuery",
function () {
return this.query;
});
Clazz.defineMethod (c$, "getPath",
function () {
return this.path;
});
Clazz.defineMethod (c$, "getUserInfo",
function () {
return this.userInfo;
});
Clazz.defineMethod (c$, "getAuthority",
function () {
return this.authority;
});
Clazz.defineMethod (c$, "getPort",
function () {
return this.port;
});
Clazz.defineMethod (c$, "getDefaultPort",
function () {
return this.handler.getDefaultPort ();
});
Clazz.defineMethod (c$, "getProtocol",
function () {
return this.protocol;
});
Clazz.defineMethod (c$, "getHost",
function () {
return this.host;
});
Clazz.defineMethod (c$, "getFile",
function () {
return this.file;
});
Clazz.defineMethod (c$, "getRef",
function () {
return this.ref;
});
Clazz.overrideMethod (c$, "equals",
function (obj) {
if (!(Clazz.instanceOf (obj, java.net.URL))) return false;
var u2 = obj;
return this.handler.equals (this, u2);
}, "~O");
Clazz.overrideMethod (c$, "hashCode",
function () {
if (this.$hashCode != -1) return this.$hashCode;
this.$hashCode = this.handler.hashCode (this);
return this.$hashCode;
});
Clazz.defineMethod (c$, "sameFile",
function (other) {
return this.handler.sameFile (this, other);
}, "java.net.URL");
Clazz.overrideMethod (c$, "toString",
function () {
return this.toExternalForm ();
});
Clazz.defineMethod (c$, "toExternalForm",
function () {
return this.handler.toExternalForm (this);
});
Clazz.defineMethod (c$, "openConnection",
function () {
return this.handler.openConnection (this);
});
Clazz.defineMethod (c$, "openStream",
function () {
return this.openConnection ().getInputStream ();
});
Clazz.defineMethod (c$, "getContent",
function () {
return this.openConnection ().getContent ();
});
Clazz.defineMethod (c$, "getContent",
function (classes) {
return this.openConnection ().getContent (classes);
}, "~A");
c$.setURLStreamHandlerFactory = Clazz.defineMethod (c$, "setURLStreamHandlerFactory",
function (fac) {
{
if (java.net.URL.factory != null) {
throw  new Error ("factory already defined");
}var security = System.getSecurityManager ();
if (security != null) {
security.checkSetFactory ();
}java.net.URL.handlers.clear ();
($t$ = java.net.URL.factory = fac, java.net.URL.prototype.factory = java.net.URL.factory, $t$);
}}, "java.net.URLStreamHandlerFactory");
c$.getURLStreamHandler = Clazz.defineMethod (c$, "getURLStreamHandler",
function (protocol) {
var handler = java.net.URL.handlers.get (protocol);
if (handler == null) {
if (java.net.URL.factory != null) {
handler = java.net.URL.factory.createURLStreamHandler (protocol);
}}return handler;
}, "~S");
Clazz.defineStatics (c$,
"factory", null);
c$.handlers = c$.prototype.handlers =  new java.util.Hashtable ();
c$.streamHandlerLock = c$.prototype.streamHandlerLock =  new JavaObject ();
});

if (Jmol.debugCode)return;

// 
//// java\util\MapEntry.js 
// 
$_L(["java.util.Map"],"java.util.MapEntry",null,function(){
c$=$_C(function(){
this.key=null;
this.value=null;
$_Z(this,arguments);
},java.util,"MapEntry",null,[java.util.Map.Entry,Cloneable]);
$_K(c$,
function(theKey){
this.key=theKey;
},"~O");
$_K(c$,
function(theKey,theValue){
this.key=theKey;
this.value=theValue;
},"~O,~O");
$_M(c$,"clone",
function(){
try{
return $_U(this,java.util.MapEntry,"clone",[]);
}catch(e){
if($_O(e,CloneNotSupportedException)){
return null;
}else{
throw e;
}
}
});
$_V(c$,"equals",
function(object){
if(this===object){
return true;
}if($_O(object,java.util.Map.Entry)){
var entry=object;
return(this.key==null?entry.getKey()==null:this.key.equals(entry.getKey()))&&(this.value==null?entry.getValue()==null:this.value.equals(entry.getValue()));
}return false;
},"~O");
$_V(c$,"getKey",
function(){
return this.key;
});
$_V(c$,"getValue",
function(){
return this.value;
});
$_V(c$,"hashCode",
function(){
return(this.key==null?0:this.key.hashCode())^(this.value==null?0:this.value.hashCode());
});
$_V(c$,"setValue",
function(object){
var result=this.value;
this.value=object;
return result;
},"~O");
$_V(c$,"toString",
function(){
return this.key+"="+this.value;
});
$_I(java.util.MapEntry,"Type");
});
// 
//// java\util\Dictionary.js 
// 
c$=$_T(java.util,"Dictionary");
$_K(c$,
function(){
});
// 
//// java\util\Hashtable.js 
// 
$_L(["java.util.Dictionary","$.Enumeration","$.Iterator","$.Map","$.MapEntry","$.NoSuchElementException"],"java.util.Hashtable",["java.lang.IllegalArgumentException","$.IllegalStateException","$.NullPointerException","$.StringBuilder","java.util.AbstractCollection","$.AbstractSet","$.Arrays","$.Collections","$.ConcurrentModificationException","java.util.MapEntry.Type"],function(){
c$=$_C(function(){
this.elementCount=0;
this.elementData=null;
this.loadFactor=0;
this.threshold=0;
this.firstSlot=0;
this.lastSlot=-1;
this.modCount=0;
if(!$_D("java.util.Hashtable.HashIterator")){
java.util.Hashtable.$Hashtable$HashIterator$();
}
if(!$_D("java.util.Hashtable.HashEnumerator")){
java.util.Hashtable.$Hashtable$HashEnumerator$();
}
$_Z(this,arguments);
},java.util,"Hashtable",java.util.Dictionary,[java.util.Map,Cloneable,java.io.Serializable]);
c$.newEntry=$_M(c$,"newEntry",
($fz=function(key,value,hash){
return new java.util.Hashtable.Entry(key,value);
},$fz.isPrivate=true,$fz),"~O,~O,~N");
$_K(c$,
function(){
this.construct(11);
});
$_K(c$,
function(capacity){
$_R(this,java.util.Hashtable,[]);
if(capacity>=0){
this.elementCount=0;
this.elementData=this.newElementArray(capacity==0?1:capacity);
this.firstSlot=this.elementData.length;
this.loadFactor=0.75;
this.computeMaxSize();
}else{
throw new IllegalArgumentException();
}},"~N");
$_K(c$,
function(capacity,loadFactor){
$_R(this,java.util.Hashtable,[]);
if(capacity>=0&&loadFactor>0){
this.elementCount=0;
this.firstSlot=capacity;
this.elementData=this.newElementArray(capacity==0?1:capacity);
this.loadFactor=loadFactor;
this.computeMaxSize();
}else{
throw new IllegalArgumentException();
}},"~N,~N");
$_K(c$,
function(map){
this.construct(map.size()<6?11:(Math.floor(map.size()*4/3))+11);
this.putAll(map);
},"java.util.Map");
$_M(c$,"newElementArray",
($fz=function(size){
return new Array(size);
},$fz.isPrivate=true,$fz),"~N");
$_V(c$,"clear",
function(){
this.elementCount=0;
java.util.Arrays.fill(this.elementData,null);
this.modCount++;
});
$_M(c$,"clone",
function(){
try{
var hashtable=$_U(this,java.util.Hashtable,"clone",[]);
hashtable.elementData=this.elementData.clone();
var entry;
for(var i=this.elementData.length;--i>=0;){
if((entry=this.elementData[i])!=null){
hashtable.elementData[i]=entry.clone();
}}
return hashtable;
}catch(e){
if($_O(e,CloneNotSupportedException)){
return null;
}else{
throw e;
}
}
});
$_M(c$,"computeMaxSize",
($fz=function(){
this.threshold=Math.round((this.elementData.length*this.loadFactor));
},$fz.isPrivate=true,$fz));
$_M(c$,"contains",
function(value){
if(value==null){
throw new NullPointerException();
}for(var i=this.elementData.length;--i>=0;){
var entry=this.elementData[i];
while(entry!=null){
if(value.equals(entry.value)){
return true;
}entry=entry.next;
}
}
return false;
},"~O");
$_V(c$,"containsKey",
function(key){
return this.getEntry(key)!=null;
},"~O");
$_V(c$,"containsValue",
function(value){
return this.contains(value);
},"~O");
$_V(c$,"elements",
function(){
if(this.elementCount==0){
return java.util.Hashtable.EMPTY_ENUMERATION;
}return $_N(java.util.Hashtable.HashEnumerator,this,null,false);
});
$_V(c$,"entrySet",
function(){
return new java.util.Collections.SynchronizedSet((($_D("java.util.Hashtable$2")?0:java.util.Hashtable.$Hashtable$2$()),$_N(java.util.Hashtable$2,this,null)),this);
});
$_V(c$,"equals",
function(object){
if(this===object){
return true;
}if($_O(object,java.util.Map)){
var map=object;
if(this.size()!=map.size()){
return false;
}var entries=this.entrySet();
for(var e,$e=map.entrySet().iterator();$e.hasNext()&&((e=$e.next())||true);){
if(!entries.contains(e)){
return false;
}}
return true;
}return false;
},"~O");
$_V(c$,"get",
function(key){
var hash=key.hashCode();
var index=(hash&0x7FFFFFFF)%this.elementData.length;
var entry=this.elementData[index];
while(entry!=null){
if(entry.equalsKey(key,hash)){
return entry.value;
}entry=entry.next;
}
return null;
},"~O");
$_M(c$,"getEntry",
function(key){
var hash=key.hashCode();
var index=(hash&0x7FFFFFFF)%this.elementData.length;
var entry=this.elementData[index];
while(entry!=null){
if(entry.equalsKey(key,hash)){
return entry;
}entry=entry.next;
}
return null;
},"~O");
$_V(c$,"hashCode",
function(){
var result=0;
var it=this.entrySet().iterator();
while(it.hasNext()){
var entry=it.next();
var key=entry.getKey();
var value=entry.getValue();
var hash=(key!==this?key.hashCode():0)^(value!==this?(value!=null?value.hashCode():0):0);
result+=hash;
}
return result;
});
$_V(c$,"isEmpty",
function(){
return this.elementCount==0;
});
$_V(c$,"keys",
function(){
if(this.elementCount==0){
return java.util.Hashtable.EMPTY_ENUMERATION;
}return $_N(java.util.Hashtable.HashEnumerator,this,null,true);
});
$_V(c$,"keySet",
function(){
return new java.util.Collections.SynchronizedSet((($_D("java.util.Hashtable$3")?0:java.util.Hashtable.$Hashtable$3$()),$_N(java.util.Hashtable$3,this,null)),this);
});
$_V(c$,"put",
function(key,value){
if(key!=null&&value!=null){
var hash=key.hashCode();
var index=(hash&0x7FFFFFFF)%this.elementData.length;
var entry=this.elementData[index];
while(entry!=null&&!entry.equalsKey(key,hash)){
entry=entry.next;
}
if(entry==null){
this.modCount++;
if(++this.elementCount>this.threshold){
this.rehash();
index=(hash&0x7FFFFFFF)%this.elementData.length;
}if(index<this.firstSlot){
this.firstSlot=index;
}if(index>this.lastSlot){
this.lastSlot=index;
}

entry=java.util.Hashtable.newEntry(key,value,hash);
entry.next=this.elementData[index];
this.elementData[index]=entry;
return null;
}var result=entry.value;
entry.value=value;
return result;
}throw new NullPointerException();
},"~O,~O");
$_V(c$,"putAll",
function(map){
for(var entry,$entry=map.entrySet().iterator();$entry.hasNext()&&((entry=$entry.next())||true);){
this.put(entry.getKey(),entry.getValue());
}
},"java.util.Map");

$_M(c$,"rehash",
function(){
var length=(this.elementData.length<<1)+1;
if(length==0){
length=1;
}var newFirst=length;
var newLast=-1;
var newData=this.newElementArray(length);
for(var i=this.lastSlot+1;--i>=this.firstSlot;){
var entry=this.elementData[i];
while(entry!=null){
var index=(entry.getKeyHash()&0x7FFFFFFF)%length;
if(index<newFirst){
newFirst=index;
}if(index>newLast){
newLast=index;
}var next=entry.next;
entry.next=newData[index];
newData[index]=entry;
entry=next;
}
}
this.firstSlot=newFirst;
this.lastSlot=newLast;
this.elementData=newData;
this.computeMaxSize();
});
$_V(c$,"remove",
function(key){
var hash=key.hashCode();
var index=(hash&0x7FFFFFFF)%this.elementData.length;
var last=null;
var entry=this.elementData[index];
while(entry!=null&&!entry.equalsKey(key,hash)){
last=entry;
entry=entry.next;
}
if(entry!=null){
this.modCount++;
if(last==null){
this.elementData[index]=entry.next;
}else{
last.next=entry.next;
}this.elementCount--;
var result=entry.value;
entry.value=null;
return result;
}return null;
},"~O");
$_V(c$,"size",
function(){
return this.elementCount;
});
$_V(c$,"toString",
function(){
if(this.isEmpty()){
return"{}";
}var buffer=new StringBuilder(this.size()*28);
buffer.append('{');
for(var i=this.lastSlot;i>=this.firstSlot;i--){
var entry=this.elementData[i];
while(entry!=null){
if(entry.key!==this){
buffer.append(entry.key);
}else{
buffer.append("(this Map)");
}buffer.append('=');
if(entry.value!==this){
buffer.append(entry.value);
}else{
buffer.append("(this Map)");
}buffer.append(", ");
entry=entry.next;
}
}
if(this.elementCount>0){
buffer.setLength(buffer.length()-2);
}buffer.append('}');
return buffer.toString();
});
$_V(c$,"values",
function(){
return new java.util.Collections.SynchronizedCollection((($_D("java.util.Hashtable$4")?0:java.util.Hashtable.$Hashtable$4$()),$_N(java.util.Hashtable$4,this,null)),this);
});
c$.$Hashtable$HashIterator$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.position=0;
this.expectedModCount=0;
this.type=null;
this.lastEntry=null;
this.lastPosition=0;
this.canRemove=false;
$_Z(this,arguments);
},java.util.Hashtable,"HashIterator",null,java.util.Iterator);
$_K(c$,
function(a){
this.type=a;
this.position=this.b$["java.util.Hashtable"].lastSlot;
this.expectedModCount=this.b$["java.util.Hashtable"].modCount;
},"java.util.MapEntry.Type");
$_V(c$,"hasNext",
function(){
if(this.lastEntry!=null&&this.lastEntry.next!=null){
return true;
}while(this.position>=this.b$["java.util.Hashtable"].firstSlot){
if(this.b$["java.util.Hashtable"].elementData[this.position]==null){
this.position--;
}else{
return true;
}}
return false;
});
$_V(c$,"next",
function(){
if(this.expectedModCount==this.b$["java.util.Hashtable"].modCount){
if(this.lastEntry!=null){
this.lastEntry=this.lastEntry.next;
}if(this.lastEntry==null){
while(this.position>=this.b$["java.util.Hashtable"].firstSlot&&(this.lastEntry=this.b$["java.util.Hashtable"].elementData[this.position])==null){
this.position--;
}
if(this.lastEntry!=null){
this.lastPosition=this.position;
this.position--;
}}if(this.lastEntry!=null){
this.canRemove=true;
return this.type.get(this.lastEntry);
}throw new java.util.NoSuchElementException();
}throw new java.util.ConcurrentModificationException();
});
$_V(c$,"remove",
function(){
if(this.expectedModCount==this.b$["java.util.Hashtable"].modCount){
if(this.canRemove){
this.canRemove=false;
{
var a=false;
var b=this.b$["java.util.Hashtable"].elementData[this.lastPosition];
if(b===this.lastEntry){
this.b$["java.util.Hashtable"].elementData[this.lastPosition]=b.next;
a=true;
}else{
while(b!=null&&b.next!==this.lastEntry){
b=b.next;
}
if(b!=null){
b.next=this.lastEntry.next;
a=true;
}}if(a){
this.b$["java.util.Hashtable"].modCount++;
this.b$["java.util.Hashtable"].elementCount--;
this.expectedModCount++;
return;
}}}else{
throw new IllegalStateException();
}}throw new java.util.ConcurrentModificationException();
});
c$=$_P();
};
c$.$Hashtable$HashEnumerator$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.key=false;
this.start=0;
this.entry=null;
$_Z(this,arguments);
},java.util.Hashtable,"HashEnumerator",null,java.util.Enumeration);
$_K(c$,
function(a){
this.key=a;
this.start=this.b$["java.util.Hashtable"].lastSlot+1;
},"~B");
$_V(c$,"hasMoreElements",
function(){
if(this.entry!=null){
return true;
}while(--this.start>=this.b$["java.util.Hashtable"].firstSlot){
if(this.b$["java.util.Hashtable"].elementData[this.start]!=null){
this.entry=this.b$["java.util.Hashtable"].elementData[this.start];
return true;
}}
return false;
});
$_V(c$,"nextElement",
function(){
if(this.hasMoreElements()){
var a=this.key?this.entry.key:this.entry.value;
this.entry=this.entry.next;
return a;
}throw new java.util.NoSuchElementException();
});
c$=$_P();
};
c$.$Hashtable$2$=function(){
$_H();
c$=$_W(java.util,"Hashtable$2",java.util.AbstractSet);
$_V(c$,"size",
function(){
return this.b$["java.util.Hashtable"].elementCount;
});
$_V(c$,"clear",
function(){
this.b$["java.util.Hashtable"].clear();
});
$_V(c$,"remove",
function(object){
if(this.contains(object)){
this.b$["java.util.Hashtable"].remove((object).getKey());
return true;
}return false;
},"~O");
$_M(c$,"contains",
function(object){
var entry=this.b$["java.util.Hashtable"].getEntry((object).getKey());
return object.equals(entry);
},"~O");
$_M(c$,"iterator",
function(){
return $_N(java.util.Hashtable.HashIterator,this,null,(($_D("java.util.Hashtable$2$1")?0:java.util.Hashtable.$Hashtable$2$1$()),$_N(java.util.Hashtable$2$1,this,null)));
});
c$=$_P();
};
c$.$Hashtable$2$1$=function(){
$_H();
c$=$_W(java.util,"Hashtable$2$1",null,java.util.MapEntry.Type);
$_V(c$,"get",
function(entry){
return entry;
},"java.util.MapEntry");
c$=$_P();
};
c$.$Hashtable$3$=function(){
$_H();
c$=$_W(java.util,"Hashtable$3",java.util.AbstractSet);
$_V(c$,"contains",
function(object){
return this.b$["java.util.Hashtable"].containsKey(object);
},"~O");
$_V(c$,"size",
function(){
return this.b$["java.util.Hashtable"].elementCount;
});
$_V(c$,"clear",
function(){
this.b$["java.util.Hashtable"].clear();
});
$_V(c$,"remove",
function(key){
if(this.b$["java.util.Hashtable"].containsKey(key)){
this.b$["java.util.Hashtable"].remove(key);
return true;
}return false;
},"~O");
$_V(c$,"iterator",
function(){
return $_N(java.util.Hashtable.HashIterator,this,null,(($_D("java.util.Hashtable$3$1")?0:java.util.Hashtable.$Hashtable$3$1$()),$_N(java.util.Hashtable$3$1,this,null)));
});
c$=$_P();
};
c$.$Hashtable$3$1$=function(){
$_H();
c$=$_W(java.util,"Hashtable$3$1",null,java.util.MapEntry.Type);
$_V(c$,"get",
function(entry){
return entry.key;
},"java.util.MapEntry");
c$=$_P();
};
c$.$Hashtable$4$=function(){
$_H();
c$=$_W(java.util,"Hashtable$4",java.util.AbstractCollection);
$_V(c$,"contains",
function(object){
return this.b$["java.util.Hashtable"].contains(object);
},"~O");
$_V(c$,"size",
function(){
return this.b$["java.util.Hashtable"].elementCount;
});
$_V(c$,"clear",
function(){
this.b$["java.util.Hashtable"].clear();
});
$_V(c$,"iterator",
function(){
return $_N(java.util.Hashtable.HashIterator,this,null,(($_D("java.util.Hashtable$4$1")?0:java.util.Hashtable.$Hashtable$4$1$()),$_N(java.util.Hashtable$4$1,this,null)));
});
c$=$_P();
};
c$.$Hashtable$4$1$=function(){
$_H();
c$=$_W(java.util,"Hashtable$4$1",null,java.util.MapEntry.Type);
$_V(c$,"get",
function(entry){
return entry.value;
},"java.util.MapEntry");
c$=$_P();
};
c$.$Hashtable$1$=function(){
$_H();
c$=$_W(java.util,"Hashtable$1",null,java.util.Enumeration);
$_V(c$,"hasMoreElements",
function(){
return false;
});
$_V(c$,"nextElement",
function(){
throw new java.util.NoSuchElementException();
});
c$=$_P();
};
$_H();
c$=$_C(function(){
this.next=null;
this.hashcode=0;
$_Z(this,arguments);
},java.util.Hashtable,"Entry",java.util.MapEntry);
$_K(c$,
function(a,b){
$_R(this,java.util.Hashtable.Entry,[a,b]);
this.hashcode=a.hashCode();
},"~O,~O");
$_M(c$,"clone",
function(){
var a=$_U(this,java.util.Hashtable.Entry,"clone",[]);
if(this.next!=null){
a.next=this.next.clone();

}
return a;
});
$_V(c$,"setValue",
function(a){
if(a==null){
throw new NullPointerException();
}var b=this.value;
this.value=a;
return b;
},"~O");
$_M(c$,"getKeyHash",
function(){
return this.key.hashCode();
});
$_M(c$,"equalsKey",
function(a,b){
return this.hashcode==a.hashCode()&&this.key.equals(a);
},"~O,~N");
$_V(c$,"toString",
function(){
return this.key+"="+this.value;
});
c$=$_P();
c$.EMPTY_ENUMERATION=c$.prototype.EMPTY_ENUMERATION=(($_D("java.util.Hashtable$1")?0:java.util.Hashtable.$Hashtable$1$()),$_N(java.util.Hashtable$1,this,null));
});
// 
//// java\net\URLConnection.js 
// 
Clazz.declarePackage ("java.net");
Clazz.load (null, "java.net.URLConnection", ["java.lang.IllegalStateException", "$.NullPointerException", "java.net.UnknownServiceException", "java.util.ArrayList"], function () {
c$ = Clazz.decorateAsClass (function () {
this.url = null;
this.doInput = true;
this.doOutput = false;
this.connected = false;
this.requests = null;
Clazz.instantialize (this, arguments);
}, java.net, "URLConnection");
Clazz.defineMethod (c$, "setDoInput", 
function (doinput) {
if (this.connected) throw  new IllegalStateException ("Already connected");
this.doInput = doinput;
}, "~B");
Clazz.defineMethod (c$, "getDoInput", 
function () {
return this.doInput;
});
Clazz.defineMethod (c$, "setDoOutput", 
function (dooutput) {
if (this.connected) throw  new IllegalStateException ("Already connected");
this.doOutput = dooutput;
}, "~B");
Clazz.defineMethod (c$, "getDoOutput", 
function () {
return this.doOutput;
});
Clazz.makeConstructor (c$, 
function (url) {
this.url = url;
}, "java.net.URL");
Clazz.defineMethod (c$, "getURL", 
function () {
return this.url;
});
Clazz.defineMethod (c$, "getInputStream", 
function () {
throw  new java.net.UnknownServiceException ("protocol doesn't support input");
});
Clazz.defineMethod (c$, "getOutputStream", 
function () {
throw  new java.net.UnknownServiceException ("protocol doesn't support output");
});
Clazz.defineMethod (c$, "setRequestProperty", 
function (key, value) {
if (this.connected) throw  new IllegalStateException ("Already connected");
if (key == null) throw  new NullPointerException ("key is null");
if (this.requests == null) this.requests =  new java.util.ArrayList ();
for (var i = this.requests.size (); --i >= 0; ) if (this.requests.get (i)[0].equals (key)) {
this.requests.get (i)[1] = value;
return;
}
this.requests.add ([key, value]);
}, "~S,~S");
});
// 
//// org\jmol\awtjs2d\JmolURLConnection.js 
// 
Clazz.declarePackage ("org.jmol.awtjs2d");
Clazz.load (["java.net.URLConnection"], "org.jmol.awtjs2d.JmolURLConnection", null, function () {
c$ = Clazz.decorateAsClass (function () {
this.bytesOut = null;
this.postOut = "";
Clazz.instantialize (this, arguments);
}, org.jmol.awtjs2d, "JmolURLConnection", java.net.URLConnection);
Clazz.defineMethod (c$, "doAjax", 
($fz = function () {
{
return Jmol._doAjax(this.url, this.postOut, this.bytesOut);
}}, $fz.isPrivate = true, $fz));
Clazz.overrideMethod (c$, "connect", 
function () {
});
Clazz.defineMethod (c$, "outputBytes", 
function (bytes) {
this.bytesOut = bytes;
}, "~A");
Clazz.defineMethod (c$, "outputString", 
function (post) {
this.postOut = post;
}, "~S");
Clazz.defineMethod (c$, "getStringXBuilder", 
function () {
return this.doAjax ();
});
});
// 
//// java\lang\AbstractStringBuilder.js 
// 
$_L(null,"java.lang.AbstractStringBuilder",["java.io.InvalidObjectException","java.lang.ArrayIndexOutOfBoundsException","$.IndexOutOfBoundsException","$.NegativeArraySizeException","$.NullPointerException","$.StringIndexOutOfBoundsException",null],function(){
c$=$_C(function(){
this.value=null;
this.count=0;
this.shared=false;
$_Z(this,arguments);
},java.lang,"AbstractStringBuilder");
$_M(c$,"getValue",
function(){
return this.value;
});
$_M(c$,"shareValue",
function(){
this.shared=true;
return this.value;
});
$_M(c$,"set",
function(val,len){
if(val==null)val=$_A(0,'\0');
if(val.length<len)throw new java.io.InvalidObjectException(("K0199"));
this.shared=false;
this.value=val;
this.count=len;
},"~A,~N");
$_K(c$,
function(){
this.value=$_A(16,'\0');
});
$_K(c$,
function(capacity){
if(capacity<0)throw new NegativeArraySizeException();
this.value=$_A(capacity,'\0');
},"~N");
$_K(c$,
function(string){
this.count=string.length;
this.shared=false;
this.value=$_A(this.count+16,'\0');
string.getChars(0,this.count,this.value,0);
},"~S");
$_M(c$,"enlargeBuffer",
($fz=function(min){
var twice=(this.value.length<<1)+2;
var newData=$_A(min>twice?min:twice,'\0');
System.arraycopy(this.value,0,newData,0,this.count);
this.value=newData;
this.shared=false;
},$fz.isPrivate=true,$fz),"~N");
$_M(c$,"appendNull",
function(){
var newSize=this.count+4;
if(newSize>this.value.length){
this.enlargeBuffer(newSize);
}else if(this.shared){
this.value=this.value.clone();
this.shared=false;
}this.value[this.count++]='n';
this.value[this.count++]='u';
this.value[this.count++]='l';
this.value[this.count++]='l';
});
$_M(c$,"append0",
function(chars){
var newSize=this.count+chars.length;
if(newSize>this.value.length){
this.enlargeBuffer(newSize);
}else if(this.shared){
this.value=this.value.clone();
this.shared=false;
}System.arraycopy(chars,0,this.value,this.count,chars.length);
this.count=newSize;
},"~A");
$_M(c$,"append0",
function(chars,start,length){
if(chars==null){
throw new NullPointerException();
}if(start>=0&&0<=length&&length<=chars.length-start){
var newSize=this.count+length;
if(newSize>this.value.length){
this.enlargeBuffer(newSize);
}else if(this.shared){
this.value=this.value.clone();
this.shared=false;
}System.arraycopy(chars,start,this.value,this.count,length);
this.count=newSize;
}else{
throw new ArrayIndexOutOfBoundsException();
}},"~A,~N,~N");
$_M(c$,"append0",
function(ch){
if(this.count==this.value.length){
this.enlargeBuffer(this.count+1);
}if(this.shared){
this.value=this.value.clone();
this.shared=false;
}this.value[this.count++]=ch;
},"~N");
$_M(c$,"append0",
function(string){
if(string==null){
this.appendNull();
return;
}var adding=string.length;
var newSize=this.count+adding;
if(newSize>this.value.length){
this.enlargeBuffer(newSize);
}else if(this.shared){
this.value=this.value.clone();
this.shared=false;
}string.getChars(0,adding,this.value,this.count);
this.count=newSize;
},"~S");
$_M(c$,"append0",
function(s,start,end){
if(s==null)s="null";
if(start<0||end<0||start>end||end>s.length())throw new IndexOutOfBoundsException();
this.append0(s.subSequence(start,end).toString());
},"CharSequence,~N,~N");
$_M(c$,"capacity",
function(){
return this.value.length;
});
$_M(c$,"charAt",
function(index){
if(index<0||index>=this.count)throw new StringIndexOutOfBoundsException(index);
return this.value[index];
},"~N");
$_M(c$,"delete0",
function(start,end){
if(start>=0){
if(end>this.count){
end=this.count;
}if(end==start){
return;
}if(end>start){
var length=this.count-end;
if(length>0){
if(!this.shared){
System.arraycopy(this.value,end,this.value,start,length);
}else{
var newData=$_A(this.value.length,'\0');
System.arraycopy(this.value,0,newData,0,start);
System.arraycopy(this.value,end,newData,start,length);
this.value=newData;
this.shared=false;
}}this.count-=end-start;
return;
}}throw new StringIndexOutOfBoundsException();
},"~N,~N");
$_M(c$,"deleteCharAt0",
function(location){
if(0>location||location>=this.count)throw new StringIndexOutOfBoundsException(location);
var length=this.count-location-1;
if(length>0){
if(!this.shared){
System.arraycopy(this.value,location+1,this.value,location,length);
}else{
var newData=$_A(this.value.length,'\0');
System.arraycopy(this.value,0,newData,0,location);
System.arraycopy(this.value,location+1,newData,location,length);
this.value=newData;
this.shared=false;
}}this.count--;
},"~N");
$_M(c$,"ensureCapacity",
function(min){
if(min>this.value.length){
this.enlargeBuffer(min);
}},"~N");
$_M(c$,"getChars",
function(start,end,dest,destStart){
if(start>this.count||end>this.count||start>end){
throw new StringIndexOutOfBoundsException();
}System.arraycopy(this.value,start,dest,destStart,end-start);
},"~N,~N,~A,~N");
$_M(c$,"insert0",
function(index,chars){
if(0>index||index>this.count){
throw new StringIndexOutOfBoundsException(index);
}if(chars.length!=0){
this.move(chars.length,index);
System.arraycopy(chars,0,this.value,index,chars.length);
this.count+=chars.length;
}},"~N,~A");
$_M(c$,"insert0",
function(index,chars,start,length){
if(0<=index&&index<=this.count){
if(start>=0&&0<=length&&length<=chars.length-start){
if(length!=0){
this.move(length,index);
System.arraycopy(chars,start,this.value,index,length);
this.count+=length;
}return;
}throw new StringIndexOutOfBoundsException("offset "+start+", len "+length+", array.length "+chars.length);
}throw new StringIndexOutOfBoundsException(index);
},"~N,~A,~N,~N");
$_M(c$,"insert0",
function(index,ch){
if(0>index||index>this.count){
throw new ArrayIndexOutOfBoundsException(index);
}this.move(1,index);
this.value[index]=ch;
this.count++;
},"~N,~N");
$_M(c$,"insert0",
function(index,string){
if(0<=index&&index<=this.count){
if(string==null)string="null";
var min=string.length;
if(min!=0){
this.move(min,index);
string.getChars(0,min,this.value,index);
this.count+=min;
}}else{
throw new StringIndexOutOfBoundsException(index);
}},"~N,~S");
$_M(c$,"insert0",
function(index,s,start,end){
if(s==null)s="null";
if(index<0||index>this.count||start<0||end<0||start>end||end>s.length())throw new IndexOutOfBoundsException();
this.insert0(index,s.subSequence(start,end).toString());
},"~N,CharSequence,~N,~N");
$_M(c$,"length",
function(){
return this.count;
});
$_M(c$,"move",
($fz=function(size,index){
var newSize;
if(this.value.length-this.count>=size){
if(!this.shared){
System.arraycopy(this.value,index,this.value,index+size,this.count-index);
return;
}newSize=this.value.length;
}else{
var a=this.count+size;
var b=(this.value.length<<1)+2;
newSize=a>b?a:b;
}var newData=$_A(newSize,'\0');
System.arraycopy(this.value,0,newData,0,index);
System.arraycopy(this.value,index,newData,index+size,this.count-index);
this.value=newData;
this.shared=false;
},$fz.isPrivate=true,$fz),"~N,~N");
$_M(c$,"replace0",
function(start,end,string){
if(start>=0){
if(end>this.count)end=this.count;
if(end>start){
var stringLength=string.length;
var diff=end-start-stringLength;
if(diff>0){
if(!this.shared){
System.arraycopy(this.value,end,this.value,start+stringLength,this.count-end);
}else{
var newData=$_A(this.value.length,'\0');
System.arraycopy(this.value,0,newData,0,start);
System.arraycopy(this.value,end,newData,start+stringLength,this.count-end);
this.value=newData;
this.shared=false;
}}else if(diff<0){
this.move(-diff,end);
}else if(this.shared){
this.value=this.value.clone();
this.shared=false;
}string.getChars(0,stringLength,this.value,start);
this.count-=diff;
return;
}if(start==end){
if(string==null)throw new NullPointerException();
this.insert0(start,string);
return;
}}throw new StringIndexOutOfBoundsException();
},"~N,~N,~S");
$_M(c$,"reverse0",
function(){
if(this.count<2){
return;
}if(!this.shared){
for(var i=0,end=this.count,mid=Math.floor(this.count/2);i<mid;i++){
var temp=this.value[--end];
this.value[end]=this.value[i];
this.value[i]=temp;
}
}else{
var newData=$_A(this.value.length,'\0');
for(var i=0,end=this.count;i<this.count;i++){
newData[--end]=this.value[i];
}
this.value=newData;
this.shared=false;
}});
$_M(c$,"setCharAt",
function(index,ch){
if(0>index||index>=this.count){
throw new StringIndexOutOfBoundsException(index);
}if(this.shared){
this.value=this.value.clone();
this.shared=false;
}this.value[index]=ch;
},"~N,~N");
$_M(c$,"setLength",
function(length){
if(length<0)throw new StringIndexOutOfBoundsException(length);
if(this.count<length){
if(length>this.value.length){
this.enlargeBuffer(length);
}else{
if(this.shared){
var newData=$_A(this.value.length,'\0');
System.arraycopy(this.value,0,newData,0,this.count);
this.value=newData;
this.shared=false;
}else{
for(var i=this.count;i<length;i++){
this.value[i]=String.fromCharCode(0);
}
}}}this.count=length;
},"~N");
$_M(c$,"substring",
function(start){
if(0<=start&&start<=this.count){
if(start==this.count)return"";
this.shared=true;
return String.instantialize(start,this.count-start,this.value);
}throw new StringIndexOutOfBoundsException(start);
},"~N");
$_M(c$,"substring",
function(start,end){
if(0<=start&&start<=end&&end<=this.count){
if(start==end)return"";
this.shared=true;
return String.instantialize(this.value,start,end-start);
}throw new StringIndexOutOfBoundsException();
},"~N,~N");
$_V(c$,"toString",
function(){
if(this.count==0)return"";
if(this.count>=256&&this.count<=(this.value.length>>1))return String.instantialize(this.value,0,this.count);
this.shared=true;
return String.instantialize(0,this.count,this.value);
});
$_M(c$,"subSequence",
function(start,end){
return this.substring(start,end);
},"~N,~N");
$_M(c$,"indexOf",
function(string){
return this.indexOf(string,0);
},"~S");
$_M(c$,"indexOf",
function(subString,start){
if(start<0)start=0;
var subCount=subString.length;
if(subCount>0){
if(subCount+start>this.count)return-1;
var firstChar=subString.charAt(0);
while(true){
var i=start;
var found=false;
for(;i<this.count;i++)if((this.value[i]).charCodeAt(0)==(firstChar).charCodeAt(0)){
found=true;
break;
}
if(!found||subCount+i>this.count)return-1;
var o1=i;
var o2=0;
while(++o2<subCount&&(this.value[++o1]).charCodeAt(0)==(subString.charAt(o2)).charCodeAt(0)){
}
if(o2==subCount)return i;
start=i+1;
}
}return(start<this.count||start==0)?start:this.count;
},"~S,~N");
$_M(c$,"lastIndexOf",
function(string){
return this.lastIndexOf(string,this.count);
},"~S");
$_M(c$,"lastIndexOf",
function(subString,start){
var subCount=subString.length;
if(subCount<=this.count&&start>=0){
if(subCount>0){
if(start>this.count-subCount)start=this.count-subCount;
var firstChar=subString.charAt(0);
while(true){
var i=start;
var found=false;
for(;i>=0;--i)if((this.value[i]).charCodeAt(0)==(firstChar).charCodeAt(0)){
found=true;
break;
}
if(!found)return-1;
var o1=i;
var o2=0;
while(++o2<subCount&&(this.value[++o1]).charCodeAt(0)==(subString.charAt(o2)).charCodeAt(0)){
}
if(o2==subCount)return i;
start=i-1;
}
}return start<this.count?start:this.count;
}return-1;
},"~S,~N");
$_M(c$,"trimToSize",
function(){
if(this.count<this.value.length){
var newValue=$_A(this.count,'\0');
System.arraycopy(this.value,0,newValue,0,this.count);
this.value=newValue;
this.shared=false;
}});
$_S(c$,
"INITIAL_CAPACITY",16);
});
// 
//// java\lang\StringBuffer.js 
// 
$_L(["java.lang.AbstractStringBuilder","$.Appendable"],"java.lang.StringBuffer",["java.lang.Character","$.Double","$.Float","$.Long"],function(){
c$=$_T(java.lang,"StringBuffer",AbstractStringBuilder,[Appendable,java.io.Serializable,CharSequence]);
$_K(c$,
function(cs){
if(cs==null){
throw new NullPointerException();
}
$_R(this,StringBuffer,[cs.toString()]);
},"CharSequence");
$_M(c$,"append",
function(b){
return this.append(b?"true":"false");
},"~B");
$_M(c$,"append",
function(ch){
this.append0(ch);
return this;
},"~N");
$_M(c$,"append",
function(d){
return this.append(Double.toString(d));
},"~N");
$_M(c$,"append",
function(obj){
if(obj==null){
this.appendNull();
}else{
this.append0(obj.toString());
}return this;
},"~O");
$_M(c$,"append",
function(string){
this.append0(string);
return this;
},"~S");
$_M(c$,"append",
function(sb){
if(sb==null){
this.appendNull();
}else{
{
this.append0(sb.getValue(),0,sb.length());
}}return this;
},"StringBuffer");
$_M(c$,"append",
function(chars){
this.append0(chars);
return this;
},"~A");
$_M(c$,"append",
function(chars,start,length){
this.append0(chars,start,length);
return this;
},"~A,~N,~N");
$_M(c$,"append",
function(s){
if(s==null){
this.appendNull();
}else{
this.append0(s.toString());
}return this;
},"CharSequence");
$_M(c$,"append",
function(s,start,end){
this.append0(s,start,end);
return this;
},"CharSequence,~N,~N");
$_M(c$,"appendCodePoint",
function(codePoint){
return this.append(Character.toChars(codePoint));
},"~N");
$_M(c$,"$delete",
function(start,end){
this.delete0(start,end);
return this;
},"~N,~N");
$_M(c$,"deleteCharAt",
function(location){
this.deleteCharAt0(location);
return this;
},"~N");
$_M(c$,"insert",
function(index,ch){
this.insert0(index,ch);
return this;
},"~N,~N");
$_M(c$,"insert",
function(index,b){
return this.insert(index,b?"true":"false");
},"~N,~B");
$_M(c$,"insert",
function(index,i){
return this.insert(index,Integer.toString(i));
},"~N,~N");
$_M(c$,"insert",
function(index,l){
return this.insert(index,Long.toString(l));
},"~N,~N");
$_M(c$,"insert",
function(index,d){
return this.insert(index,Double.toString(d));
},"~N,~N");
$_M(c$,"insert",
function(index,f){
return this.insert(index,Float.toString(f));
},"~N,~N");
$_M(c$,"insert",
function(index,obj){
return this.insert(index,obj==null?"null":obj.toString());
},"~N,~O");
$_M(c$,"insert",
function(index,string){
this.insert0(index,string);
return this;
},"~N,~S");
$_M(c$,"insert",
function(index,chars){
this.insert0(index,chars);
return this;
},"~N,~A");
$_M(c$,"insert",
function(index,chars,start,length){
this.insert0(index,chars,start,length);
return this;
},"~N,~A,~N,~N");
$_M(c$,"insert",
function(index,s){
this.insert0(index,s==null?"null":s.toString());
return this;
},"~N,CharSequence");
$_M(c$,"insert",
function(index,s,start,end){
this.insert0(index,s,start,end);
return this;
},"~N,CharSequence,~N,~N");
$_M(c$,"replace",
function(start,end,string){
this.replace0(start,end,string);
return this;
},"~N,~N,~S");
$_M(c$,"reverse",
function(){
this.reverse0();
return this;
});
$_V(c$,"subSequence",
function(start,end){
return $_U(this,StringBuffer,"substring",[start,end]);
},"~N,~N");
});
// 
//// java\lang\StringBuilder.js 
// 
$_L(["java.lang.AbstractStringBuilder","$.Appendable"],"java.lang.StringBuilder",["java.lang.Double","$.Float","$.Long"],function(){
c$=$_T(java.lang,"StringBuilder",AbstractStringBuilder,[Appendable,CharSequence,java.io.Serializable]);
$_K(c$,
function(seq){
$_R(this,StringBuilder,[seq.toString()]);
},"CharSequence");
$_M(c$,"append",
function(b){
this.append0(b?"true":"false");
return this;
},"~B");
$_M(c$,"append",
function(c){
this.append0(c);
return this;
},"~N");
$_M(c$,"append",
function(i){
this.append0(Integer.toString(i));
return this;
},"~N");
$_M(c$,"append",
function(lng){
this.append0(Long.toString(lng));
return this;
},"~N");
$_M(c$,"append",
function(f){
this.append0(Float.toString(f));
return this;
},"~N");
$_M(c$,"append",
function(d){
this.append0(Double.toString(d));
return this;
},"~N");
$_M(c$,"append",
function(obj){
if(obj==null){
this.appendNull();
}else{
this.append0(obj.toString());
}return this;
},"~O");
$_M(c$,"append",
function(str){
this.append0(str);
return this;
},"~S");
$_M(c$,"append",
function(sb){
if(sb==null){
this.appendNull();
}else{
this.append0(sb.getValue(),0,sb.length());
}return this;
},"StringBuffer");
$_M(c$,"append",
function(ch){
this.append0(ch);
return this;
},"~A");
$_M(c$,"append",
function(str,offset,len){
this.append0(str,offset,len);
return this;
},"~A,~N,~N");
$_M(c$,"append",
function(csq){
if(csq==null){
this.appendNull();
}else{
this.append0(csq.toString());
}return this;
},"CharSequence");
$_M(c$,"append",
function(csq,start,end){
this.append0(csq,start,end);
return this;
},"CharSequence,~N,~N");
$_M(c$,"$delete",
function(start,end){
this.delete0(start,end);
return this;
},"~N,~N");
$_M(c$,"deleteCharAt",
function(index){
this.deleteCharAt0(index);
return this;
},"~N");
$_M(c$,"insert",
function(offset,b){
this.insert0(offset,b?"true":"false");
return this;
},"~N,~B");
$_M(c$,"insert",
function(offset,c){
this.insert0(offset,c);
return this;
},"~N,~N");
$_M(c$,"insert",
function(offset,i){
this.insert0(offset,Integer.toString(i));
return this;
},"~N,~N");
$_M(c$,"insert",
function(offset,l){
this.insert0(offset,Long.toString(l));
return this;
},"~N,~N");
$_M(c$,"insert",
function(offset,f){
this.insert0(offset,Float.toString(f));
return this;
},"~N,~N");
$_M(c$,"insert",
function(offset,d){
this.insert0(offset,Double.toString(d));
return this;
},"~N,~N");
$_M(c$,"insert",
function(offset,obj){
this.insert0(offset,obj==null?"null":obj.toString());
return this;
},"~N,~O");
$_M(c$,"insert",
function(offset,str){
this.insert0(offset,str);
return this;
},"~N,~S");
$_M(c$,"insert",
function(offset,ch){
this.insert0(offset,ch);
return this;
},"~N,~A");
$_M(c$,"insert",
function(offset,str,strOffset,strLen){
this.insert0(offset,str,strOffset,strLen);
return this;
},"~N,~A,~N,~N");
$_M(c$,"insert",
function(offset,s){
this.insert0(offset,s==null?"null":s.toString());
return this;
},"~N,CharSequence");
$_M(c$,"insert",
function(offset,s,start,end){
this.insert0(offset,s,start,end);
return this;
},"~N,CharSequence,~N,~N");
$_M(c$,"replace",
function(start,end,str){
this.replace0(start,end,str);
return this;
},"~N,~N,~S");
$_M(c$,"reverse",
function(){
this.reverse0();
return this;
});
});
// 
//// java\util\AbstractCollection.js 
// 
$_L(["java.util.Collection"],"java.util.AbstractCollection",["java.lang.StringBuilder","$.UnsupportedOperationException","java.lang.reflect.Array"],function(){
c$=$_T(java.util,"AbstractCollection",null,java.util.Collection);
$_K(c$,
function(){
});
$_V(c$,"add",
function(object){
throw new UnsupportedOperationException();
},"~O");
$_V(c$,"addAll",
function(collection){
var result=false;
var it=collection.iterator();
while(it.hasNext()){
if(this.add(it.next())){
result=true;
}}
return result;
},"java.util.Collection");
$_V(c$,"clear",
function(){
var it=this.iterator();
while(it.hasNext()){
it.next();
it.remove();
}
});
$_V(c$,"contains",
function(object){
var it=this.iterator();
if(object!=null){
while(it.hasNext()){
if(object.equals(it.next())){
return true;
}}
}else{
while(it.hasNext()){
if(it.next()==null){
return true;
}}
}return false;
},"~O");
$_V(c$,"containsAll",
function(collection){
var it=collection.iterator();
while(it.hasNext()){
if(!this.contains(it.next())){
return false;
}}
return true;
},"java.util.Collection");
$_V(c$,"isEmpty",
function(){
return this.size()==0;
});
$_V(c$,"remove",
function(object){
var it=this.iterator();
if(object!=null){
while(it.hasNext()){
if(object.equals(it.next())){
it.remove();
return true;
}}
}else{
while(it.hasNext()){
if(it.next()==null){
it.remove();
return true;
}}
}return false;
},"~O");
$_V(c$,"removeAll",
function(collection){
var result=false;
var it=this.iterator();
while(it.hasNext()){
if(collection.contains(it.next())){
it.remove();
result=true;
}}
return result;
},"java.util.Collection");
$_V(c$,"retainAll",
function(collection){
var result=false;
var it=this.iterator();
while(it.hasNext()){
if(!collection.contains(it.next())){
it.remove();
result=true;
}}
return result;
},"java.util.Collection");
$_M(c$,"toArray",
function(){
var size=this.size();
var index=0;
var it=this.iterator();
var array=new Array(size);
while(index<size){
array[index++]=it.next();
}
return array;
});
$_M(c$,"toArray",
function(contents){
var size=this.size();
var index=0;
if(size>contents.length){
var ct=contents.getClass().getComponentType();
contents=java.lang.reflect.Array.newInstance(ct,size);
}for(var entry,$entry=this.iterator();$entry.hasNext()&&((entry=$entry.next())||true);){
contents[index++]=entry;
}
if(index<contents.length){
contents[index]=null;
}return contents;
},"~A");
$_V(c$,"toString",
function(){
if(this.isEmpty()){
return"[]";
}var buffer=new StringBuilder(this.size()*16);
buffer.append('[');
var it=this.iterator();
while(it.hasNext()){
var next=it.next();
if(next!==this){
buffer.append(next);
}else{
buffer.append("(this Collection)");
}if(it.hasNext()){
buffer.append(", ");
}}
buffer.append(']');
return buffer.toString();
});
});
// 
//// java\util\AbstractList.js 
// 
$_L(["java.util.AbstractCollection","$.Iterator","$.List","$.ListIterator","$.RandomAccess","$.NoSuchElementException"],"java.util.AbstractList",["java.lang.IllegalArgumentException","$.IllegalStateException","$.IndexOutOfBoundsException","$.UnsupportedOperationException","java.util.ConcurrentModificationException"],function(){
c$=$_C(function(){
this.modCount=0;
if(!$_D("java.util.AbstractList.SimpleListIterator")){
java.util.AbstractList.$AbstractList$SimpleListIterator$();
}
if(!$_D("java.util.AbstractList.FullListIterator")){
java.util.AbstractList.$AbstractList$FullListIterator$();
}
$_Z(this,arguments);
},java.util,"AbstractList",java.util.AbstractCollection,java.util.List);
$_M(c$,"add",
function(location,object){
throw new UnsupportedOperationException();
},"~N,~O");
$_M(c$,"add",
function(object){
this.add(this.size(),object);
return true;
},"~O");
$_M(c$,"addAll",
function(location,collection){
var it=collection.iterator();
while(it.hasNext()){
this.add(location++,it.next());
}
return!collection.isEmpty();
},"~N,java.util.Collection");
$_V(c$,"clear",
function(){
this.removeRange(0,this.size());
});
$_V(c$,"equals",
function(object){
if(this===object){
return true;
}if($_O(object,java.util.List)){
var list=object;
if(list.size()!=this.size()){
return false;
}var it1=this.iterator();
var it2=list.iterator();
while(it1.hasNext()){
var e1=it1.next();
var e2=it2.next();
if(!(e1==null?e2==null:e1.equals(e2))){
return false;
}}
return true;
}return false;
},"~O");
$_V(c$,"hashCode",
function(){
var result=1;
var it=this.iterator();
while(it.hasNext()){
var object=it.next();
result=(31*result)+(object==null?0:object.hashCode());
}
return result;
});
$_V(c$,"indexOf",
function(object){
var it=this.listIterator();
if(object!=null){
while(it.hasNext()){
if(object.equals(it.next())){
return it.previousIndex();
}}
}else{
while(it.hasNext()){
if(it.next()==null){
return it.previousIndex();
}}
}return-1;
},"~O");
$_V(c$,"iterator",
function(){
return $_N(java.util.AbstractList.SimpleListIterator,this,null);
});
$_V(c$,"lastIndexOf",
function(object){
var it=this.listIterator(this.size());
if(object!=null){
while(it.hasPrevious()){
if(object.equals(it.previous())){
return it.nextIndex();
}}
}else{
while(it.hasPrevious()){
if(it.previous()==null){
return it.nextIndex();
}}
}return-1;
},"~O");
$_M(c$,"listIterator",
function(){
return this.listIterator(0);
});
$_M(c$,"listIterator",
function(location){
return $_N(java.util.AbstractList.FullListIterator,this,null,location);
},"~N");
$_M(c$,"remove",
function(location){
throw new UnsupportedOperationException();
},"~N");
$_M(c$,"removeRange",
function(start,end){
var it=this.listIterator(start);
for(var i=start;i<end;i++){
it.next();
it.remove();
}
},"~N,~N");
$_V(c$,"set",
function(location,object){
throw new UnsupportedOperationException();
},"~N,~O");
$_V(c$,"subList",
function(start,end){
if(0<=start&&end<=this.size()){
if(start<=end){
if($_O(this,java.util.RandomAccess)){
return new java.util.AbstractList.SubAbstractListRandomAccess(this,start,end);
}return new java.util.AbstractList.SubAbstractList(this,start,end);
}throw new IllegalArgumentException();
}throw new IndexOutOfBoundsException();
},"~N,~N");
c$.$AbstractList$SimpleListIterator$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.pos=-1;
this.expectedModCount=0;
this.lastPosition=-1;
$_Z(this,arguments);
},java.util.AbstractList,"SimpleListIterator",null,java.util.Iterator);
$_K(c$,
function(){
this.expectedModCount=this.b$["java.util.AbstractList"].modCount;
});
$_V(c$,"hasNext",
function(){
return this.pos+1<this.b$["java.util.AbstractList"].size();
});
$_V(c$,"next",
function(){
if(this.expectedModCount==this.b$["java.util.AbstractList"].modCount){
try{
var a=this.b$["java.util.AbstractList"].get(this.pos+1);
this.lastPosition=++this.pos;
return a;
}catch(e){
if($_O(e,IndexOutOfBoundsException)){
throw new java.util.NoSuchElementException();
}else{
throw e;
}
}
}throw new java.util.ConcurrentModificationException();
});
$_V(c$,"remove",
function(){
if(this.expectedModCount==this.b$["java.util.AbstractList"].modCount){
try{
this.b$["java.util.AbstractList"].remove(this.lastPosition);
}catch(e){
if($_O(e,IndexOutOfBoundsException)){
throw new IllegalStateException();
}else{
throw e;
}
}
if(this.b$["java.util.AbstractList"].modCount!=this.expectedModCount){
this.expectedModCount++;
}if(this.pos==this.lastPosition){
this.pos--;
}this.lastPosition=-1;
}else{
throw new java.util.ConcurrentModificationException();
}});
c$=$_P();
};
c$.$AbstractList$FullListIterator$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
$_Z(this,arguments);
},java.util.AbstractList,"FullListIterator",java.util.AbstractList.SimpleListIterator,java.util.ListIterator,$_N(java.util.AbstractList.SimpleListIterator,this,null,$_G));
$_K(c$,
function(a){
$_R(this,java.util.AbstractList.FullListIterator);
if(0<=a&&a<=this.b$["java.util.AbstractList"].size()){
this.pos=a-1;
}else{
throw new IndexOutOfBoundsException();
}},"~N");
$_V(c$,"add",
function(a){
if(this.expectedModCount==this.b$["java.util.AbstractList"].modCount){
try{
this.b$["java.util.AbstractList"].add(this.pos+1,a);
}catch(e){
if($_O(e,IndexOutOfBoundsException)){
throw new java.util.NoSuchElementException();
}else{
throw e;
}
}
this.pos++;
this.lastPosition=-1;
if(this.b$["java.util.AbstractList"].modCount!=this.expectedModCount){
this.expectedModCount++;
}}else{
throw new java.util.ConcurrentModificationException();
}},"~O");
$_V(c$,"hasPrevious",
function(){
return this.pos>=0;
});
$_V(c$,"nextIndex",
function(){
return this.pos+1;
});
$_V(c$,"previous",
function(){
if(this.expectedModCount==this.b$["java.util.AbstractList"].modCount){
try{
var a=this.b$["java.util.AbstractList"].get(this.pos);
this.lastPosition=this.pos;
this.pos--;
return a;
}catch(e){
if($_O(e,IndexOutOfBoundsException)){
throw new java.util.NoSuchElementException();
}else{
throw e;
}
}
}throw new java.util.ConcurrentModificationException();
});
$_V(c$,"previousIndex",
function(){
return this.pos;
});
$_V(c$,"set",
function(a){
if(this.expectedModCount==this.b$["java.util.AbstractList"].modCount){
try{
this.b$["java.util.AbstractList"].set(this.lastPosition,a);
}catch(e){
if($_O(e,IndexOutOfBoundsException)){
throw new IllegalStateException();
}else{
throw e;
}
}
}else{
throw new java.util.ConcurrentModificationException();
}},"~O");
c$=$_P();
};
$_H();
c$=$_T(java.util.AbstractList,"SubAbstractListRandomAccess",java.util.AbstractList.SubAbstractList,java.util.RandomAccess);
c$=$_P();
$_H();
c$=$_C(function(){
this.fullList=null;
this.offset=0;
this.$size=0;
$_Z(this,arguments);
},java.util.AbstractList,"SubAbstractList",java.util.AbstractList);
$_K(c$,
function(a,b,c){
$_R(this,java.util.AbstractList.SubAbstractList);
this.fullList=a;
this.modCount=this.fullList.modCount;
this.offset=b;
this.$size=c-b;
},"java.util.AbstractList,~N,~N");
$_M(c$,"add",
function(a,b){
if(this.modCount==this.fullList.modCount){
if(0<=a&&a<=this.$size){
this.fullList.add(a+this.offset,b);
this.$size++;
this.modCount=this.fullList.modCount;
}else{
throw new IndexOutOfBoundsException();
}}else{
throw new java.util.ConcurrentModificationException();
}},"~N,~O");
$_M(c$,"addAll",
function(a,b){
if(this.modCount==this.fullList.modCount){
if(0<=a&&a<=this.$size){
var c=this.fullList.addAll(a+this.offset,b);
if(c){
this.$size+=b.size();
this.modCount=this.fullList.modCount;
}return c;
}throw new IndexOutOfBoundsException();
}throw new java.util.ConcurrentModificationException();
},"~N,java.util.Collection");
$_M(c$,"addAll",
function(a){
if(this.modCount==this.fullList.modCount){
var b=this.fullList.addAll(this.offset+this.$size,a);
if(b){
this.$size+=a.size();
this.modCount=this.fullList.modCount;
}return b;
}throw new java.util.ConcurrentModificationException();
},"java.util.Collection");
$_M(c$,"get",
function(a){
if(this.modCount==this.fullList.modCount){
if(0<=a&&a<this.$size){
return this.fullList.get(a+this.offset);
}throw new IndexOutOfBoundsException();
}throw new java.util.ConcurrentModificationException();
},"~N");
$_V(c$,"iterator",
function(){
return this.listIterator(0);
});
$_M(c$,"listIterator",
function(a){
if(this.modCount==this.fullList.modCount){
if(0<=a&&a<=this.$size){
return new java.util.AbstractList.SubAbstractList.SubAbstractListIterator(this.fullList.listIterator(a+this.offset),this,this.offset,this.$size);
}throw new IndexOutOfBoundsException();
}throw new java.util.ConcurrentModificationException();
},"~N");
$_M(c$,"remove",
function(a){
if(this.modCount==this.fullList.modCount){
if(0<=a&&a<this.$size){
var b=this.fullList.remove(a+this.offset);
this.$size--;
this.modCount=this.fullList.modCount;
return b;
}throw new IndexOutOfBoundsException();
}throw new java.util.ConcurrentModificationException();
},"~N");
$_M(c$,"removeRange",
function(a,b){
if(a!=b){
if(this.modCount==this.fullList.modCount){
this.fullList.removeRange(a+this.offset,b+this.offset);
this.$size-=b-a;
this.modCount=this.fullList.modCount;
}else{
throw new java.util.ConcurrentModificationException();
}}},"~N,~N");
$_M(c$,"set",
function(a,b){
if(this.modCount==this.fullList.modCount){
if(0<=a&&a<this.$size){
return this.fullList.set(a+this.offset,b);
}throw new IndexOutOfBoundsException();
}throw new java.util.ConcurrentModificationException();
},"~N,~O");
$_V(c$,"size",
function(){
return this.$size;
});
$_M(c$,"sizeChanged",
function(a){
if(a){
this.$size++;
}else{
this.$size--;
}this.modCount=this.fullList.modCount;
},"~B");
$_H();
c$=$_C(function(){
this.subList=null;
this.iterator=null;
this.start=0;
this.end=0;
$_Z(this,arguments);
},java.util.AbstractList.SubAbstractList,"SubAbstractListIterator",null,java.util.ListIterator);
$_K(c$,
function(a,b,c,d){
this.iterator=a;
this.subList=b;
this.start=c;
this.end=this.start+d;
},"java.util.ListIterator,java.util.AbstractList.SubAbstractList,~N,~N");
$_M(c$,"add",
function(a){
this.iterator.add(a);
this.subList.sizeChanged(true);
this.end++;
},"~O");
$_V(c$,"hasNext",
function(){
return this.iterator.nextIndex()<this.end;
});
$_V(c$,"hasPrevious",
function(){
return this.iterator.previousIndex()>=this.start;
});
$_M(c$,"next",
function(){
if(this.iterator.nextIndex()<this.end){
return this.iterator.next();
}throw new java.util.NoSuchElementException();
});
$_M(c$,"nextIndex",
function(){
return this.iterator.nextIndex()-this.start;
});
$_M(c$,"previous",
function(){
if(this.iterator.previousIndex()>=this.start){
return this.iterator.previous();
}throw new java.util.NoSuchElementException();
});
$_M(c$,"previousIndex",
function(){
var a=this.iterator.previousIndex();
if(a>=this.start){
return a-this.start;
}return-1;
});
$_M(c$,"remove",
function(){
this.iterator.remove();
this.subList.sizeChanged(false);
this.end--;
});
$_M(c$,"set",
function(a){
this.iterator.set(a);
},"~O");
c$=$_P();
c$=$_P();
});
// 
//// java\util\ArrayList.js 
// 
$_L(["java.util.AbstractList","$.List","$.RandomAccess"],"java.util.ArrayList",["java.lang.IllegalArgumentException","$.IndexOutOfBoundsException","java.lang.reflect.Array","java.util.Arrays"],function(){
c$=$_C(function(){
this.firstIndex=0;
this.lastIndex=0;
this.array=null;
$_Z(this,arguments);
},java.util,"ArrayList",java.util.AbstractList,[java.util.List,Cloneable,java.io.Serializable,java.util.RandomAccess]);
$_K(c$,
function(){
this.construct(0);
});
$_K(c$,
function(capacity){
$_R(this,java.util.ArrayList,[]);
this.firstIndex=this.lastIndex=0;
try{
this.array=this.newElementArray(capacity);
}catch(e){
if($_O(e,NegativeArraySizeException)){
throw new IllegalArgumentException();
}else{
throw e;
}
}
},"~N");
$_K(c$,
function(collection){
$_R(this,java.util.ArrayList,[]);
var size=collection.size();
this.firstIndex=this.lastIndex=0;
this.array=this.newElementArray(size+(Math.floor(size/10)));
this.addAll(collection);
},"java.util.Collection");
$_M(c$,"newElementArray",
($fz=function(size){
return new Array(size);
},$fz.isPrivate=true,$fz),"~N");
$_M(c$,"add",
function(location,object){
var size=this.size();
if(0<location&&location<size){
if(this.firstIndex==0&&this.lastIndex==this.array.length){
this.growForInsert(location,1);
}else if((location<Math.floor(size/2)&&this.firstIndex>0)||this.lastIndex==this.array.length){
System.arraycopy(this.array,this.firstIndex,this.array,--this.firstIndex,location);
}else{
var index=location+this.firstIndex;
System.arraycopy(this.array,index,this.array,index+1,size-location);
this.lastIndex++;
}this.array[location+this.firstIndex]=object;
}else if(location==0){
if(this.firstIndex==0){
this.growAtFront(1);
}this.array[--this.firstIndex]=object;
}else if(location==size){
if(this.lastIndex==this.array.length){
this.growAtEnd(1);
}this.array[this.lastIndex++]=object;
}else{
throw new IndexOutOfBoundsException();
}this.modCount++;
},"~N,~O");
$_M(c$,"add",
function(object){
if(this.lastIndex==this.array.length){
this.growAtEnd(1);
}this.array[this.lastIndex++]=object;
this.modCount++;
return true;
},"~O");
$_M(c$,"addAll",
function(location,collection){
var size=this.size();
if(location<0||location>size){
throw new IndexOutOfBoundsException();
}var growSize=collection.size();
if(0<location&&location<size){
if(this.array.length-size<growSize){
this.growForInsert(location,growSize);
}else if((location<Math.floor(size/2)&&this.firstIndex>0)||this.lastIndex>this.array.length-growSize){
var newFirst=this.firstIndex-growSize;
if(newFirst<0){
var index=location+this.firstIndex;
System.arraycopy(this.array,index,this.array,index-newFirst,size-location);
this.lastIndex-=newFirst;
newFirst=0;
}System.arraycopy(this.array,this.firstIndex,this.array,newFirst,location);
this.firstIndex=newFirst;
}else{
var index=location+this.firstIndex;
System.arraycopy(this.array,index,this.array,index+growSize,size-location);
this.lastIndex+=growSize;
}}else if(location==0){
this.growAtFront(growSize);
this.firstIndex-=growSize;
}else if(location==size){
if(this.lastIndex>this.array.length-growSize){
this.growAtEnd(growSize);
}this.lastIndex+=growSize;
}if(growSize>0){
var it=collection.iterator();
var index=location+this.firstIndex;
var end=index+growSize;
while(index<end){
this.array[index++]=it.next();
}
this.modCount++;
return true;
}return false;
},"~N,java.util.Collection");
$_M(c$,"addAll",
function(collection){
var growSize=collection.size();
if(growSize>0){
if(this.lastIndex>this.array.length-growSize){
this.growAtEnd(growSize);
}var it=collection.iterator();
var end=this.lastIndex+growSize;
while(this.lastIndex<end){
this.array[this.lastIndex++]=it.next();
}
this.modCount++;
return true;
}return false;
},"java.util.Collection");
$_V(c$,"clear",
function(){
if(this.firstIndex!=this.lastIndex){
java.util.Arrays.fill(this.array,this.firstIndex,this.lastIndex,null);
this.firstIndex=this.lastIndex=0;
this.modCount++;
}});
$_M(c$,"clone",
function(){
try{
var newList=$_U(this,java.util.ArrayList,"clone",[]);
newList.array=this.array.clone();
return newList;
}catch(e){
if($_O(e,CloneNotSupportedException)){
return null;
}else{
throw e;
}
}
});
$_V(c$,"contains",
function(object){
if(object!=null){
for(var i=this.firstIndex;i<this.lastIndex;i++){
if(object.equals(this.array[i])){
return true;
}}
}else{
for(var i=this.firstIndex;i<this.lastIndex;i++){
if(this.array[i]==null){
return true;
}}
}return false;
},"~O");
$_M(c$,"ensureCapacity",
function(minimumCapacity){
if(this.array.length<minimumCapacity){
if(this.firstIndex>0){
this.growAtFront(minimumCapacity-this.array.length);
}else{
this.growAtEnd(minimumCapacity-this.array.length);
}}},"~N");
$_V(c$,"get",
function(location){
if(0<=location&&location<this.size()){
return this.array[this.firstIndex+location];
}throw new IndexOutOfBoundsException();
},"~N");
$_M(c$,"growAtEnd",
($fz=function(required){
var size=this.size();
if(this.firstIndex>=required-(this.array.length-this.lastIndex)){
var newLast=this.lastIndex-this.firstIndex;
if(size>0){
System.arraycopy(this.array,this.firstIndex,this.array,0,size);
var start=newLast<this.firstIndex?this.firstIndex:newLast;
java.util.Arrays.fill(this.array,start,this.array.length,null);
}this.firstIndex=0;
this.lastIndex=newLast;
}else{
var increment=Math.floor(size/2);
if(required>increment){
increment=required;
}if(increment<12){
increment=12;
}var newArray=this.newElementArray(size+increment);
if(size>0){
System.arraycopy(this.array,this.firstIndex,newArray,this.firstIndex,size);
}this.array=newArray;
}},$fz.isPrivate=true,$fz),"~N");
$_M(c$,"growAtFront",
($fz=function(required){
var size=this.size();
if(this.array.length-this.lastIndex>=required){
var newFirst=this.array.length-size;
if(size>0){
System.arraycopy(this.array,this.firstIndex,this.array,newFirst,size);
var length=this.firstIndex+size>newFirst?newFirst:this.firstIndex+size;
java.util.Arrays.fill(this.array,this.firstIndex,length,null);
}this.firstIndex=newFirst;
this.lastIndex=this.array.length;
}else{
var increment=Math.floor(size/2);
if(required>increment){
increment=required;
}if(increment<12){
increment=12;
}var newArray=this.newElementArray(size+increment);
if(size>0){
System.arraycopy(this.array,this.firstIndex,newArray,newArray.length-size,size);
}this.firstIndex=newArray.length-size;
this.lastIndex=newArray.length;
this.array=newArray;
}},$fz.isPrivate=true,$fz),"~N");
$_M(c$,"growForInsert",
($fz=function(location,required){
var size=this.size();
var increment=Math.floor(size/2);
if(required>increment){
increment=required;
}if(increment<12){
increment=12;
}var newArray=this.newElementArray(size+increment);
if(location<Math.floor(size/2)){
var newFirst=newArray.length-(size+required);
System.arraycopy(this.array,location,newArray,location+increment,size-location);
System.arraycopy(this.array,this.firstIndex,newArray,newFirst,location);
this.firstIndex=newFirst;
this.lastIndex=newArray.length;
}else{
System.arraycopy(this.array,this.firstIndex,newArray,0,location);
System.arraycopy(this.array,location,newArray,location+required,size-location);
this.firstIndex=0;
this.lastIndex+=required;
}this.array=newArray;
},$fz.isPrivate=true,$fz),"~N,~N");
$_V(c$,"indexOf",
function(object){
if(object!=null){
for(var i=this.firstIndex;i<this.lastIndex;i++){
if(object.equals(this.array[i])){
return i-this.firstIndex;
}}
}else{
for(var i=this.firstIndex;i<this.lastIndex;i++){
if(this.array[i]==null){
return i-this.firstIndex;
}}
}return-1;
},"~O");
$_V(c$,"isEmpty",
function(){
return this.lastIndex==this.firstIndex;
});
$_V(c$,"lastIndexOf",
function(object){
if(object!=null){
for(var i=this.lastIndex-1;i>=this.firstIndex;i--){
if(object.equals(this.array[i])){
return i-this.firstIndex;
}}
}else{
for(var i=this.lastIndex-1;i>=this.firstIndex;i--){
if(this.array[i]==null){
return i-this.firstIndex;
}}
}return-1;
},"~O");
$_M(c$,"remove",
function(location){
var result;
var size=this.size();
if(0<=location&&location<size){
if(location==size-1){
result=this.array[--this.lastIndex];
this.array[this.lastIndex]=null;
}else if(location==0){
result=this.array[this.firstIndex];
this.array[this.firstIndex++]=null;
}else{
var elementIndex=this.firstIndex+location;
result=this.array[elementIndex];
if(location<Math.floor(size/2)){
System.arraycopy(this.array,this.firstIndex,this.array,this.firstIndex+1,location);
this.array[this.firstIndex++]=null;
}else{
System.arraycopy(this.array,elementIndex+1,this.array,elementIndex,size-location-1);
this.array[--this.lastIndex]=null;
}}}else{
throw new IndexOutOfBoundsException();
}this.modCount++;
return result;
},"~N");
$_V(c$,"removeRange",
function(start,end){
if(start>=0&&start<=end&&end<=this.size()){
if(start==end){
return;
}var size=this.size();
if(end==size){
java.util.Arrays.fill(this.array,this.firstIndex+start,this.lastIndex,null);
this.lastIndex=this.firstIndex+start;
}else if(start==0){
java.util.Arrays.fill(this.array,this.firstIndex,this.firstIndex+end,null);
this.firstIndex+=end;
}else{
System.arraycopy(this.array,this.firstIndex+end,this.array,this.firstIndex+start,size-end);
var newLast=this.lastIndex+start-end;
java.util.Arrays.fill(this.array,newLast,this.lastIndex,null);
this.lastIndex=newLast;
}this.modCount++;
}else{
throw new IndexOutOfBoundsException();
}},"~N,~N");
$_V(c$,"set",
function(location,object){
if(0<=location&&location<this.size()){
var result=this.array[this.firstIndex+location];
this.array[this.firstIndex+location]=object;
return result;
}throw new IndexOutOfBoundsException();
},"~N,~O");
$_V(c$,"size",
function(){
return this.lastIndex-this.firstIndex;
});
$_M(c$,"toArray",
function(){
var size=this.size();
var result=new Array(size);
System.arraycopy(this.array,this.firstIndex,result,0,size);
return result;
});
$_M(c$,"toArray",
function(contents){
var size=this.size();
if(size>contents.length){
var ct=contents.getClass().getComponentType();
contents=java.lang.reflect.Array.newInstance(ct,size);
}System.arraycopy(this.array,this.firstIndex,contents,0,size);
if(size<contents.length){
contents[size]=null;
}return contents;
},"~A");
$_M(c$,"trimToSize",
function(){
var size=this.size();
var newArray=this.newElementArray(size);
System.arraycopy(this.array,this.firstIndex,newArray,0,size);
this.array=newArray;
this.firstIndex=0;
this.lastIndex=this.array.length;
});
});
// 
//// java\util\AbstractSet.js 
// 
$_L(["java.util.AbstractCollection","$.Set"],"java.util.AbstractSet",null,function(){
c$=$_T(java.util,"AbstractSet",java.util.AbstractCollection,java.util.Set);
$_V(c$,"equals",
function(object){
if(this===object){
return true;
}if($_O(object,java.util.Set)){
var s=object;
return this.size()==s.size()&&this.containsAll(s);
}return false;
},"~O");
$_V(c$,"hashCode",
function(){
var result=0;
var it=this.iterator();
while(it.hasNext()){
var next=it.next();
result+=next==null?0:next.hashCode();
}
return result;
});
$_V(c$,"removeAll",
function(collection){
var result=false;
if(this.size()<=collection.size()){
var it=this.iterator();
while(it.hasNext()){
if(collection.contains(it.next())){
it.remove();
result=true;
}}
}else{
var it=collection.iterator();
while(it.hasNext()){
result=this.remove(it.next())||result;
}
}return result;
},"java.util.Collection");
});
// 
//// java\util\Arrays.js 
// 
$_L(["java.util.AbstractList","$.RandomAccess"],"java.util.Arrays",["java.lang.ArrayIndexOutOfBoundsException","$.IllegalArgumentException","$.NullPointerException"],function(){
c$=$_T(java.util,"Arrays");
c$.sort=$_M(c$,"sort",
function(a){
var aux=a.sort(function(o1,o2){
if(typeof o1=="string"||o1 instanceof Comparable){
return o1.compareTo(o2);
}
return o1-o2;
});
for(var i=0;i<a.length;i++){
a[i]=aux[i];
}
},"~A");
c$.sort=$_M(c$,"sort",
function(a,fromIndex,toIndex){
this.rangeCheck(a.length,fromIndex,toIndex);
var aux=new Array();
for(var i=fromIndex;i<toIndex;i++){
aux[i-fromIndex]=a[i];
}
aux=aux.sort(function(o1,o2){
if(typeof o1=="string"||o1 instanceof Comparable){
return o1.compareTo(o2);
}
return o1-o2;
});
for(var i=fromIndex;i<toIndex;i++){
a[i]=aux[i-fromIndex];
}
},"~A,~N,~N");
c$.sort=$_M(c$,"sort",
function(a,c){
var aux=a.sort(function(o1,o2){
if(c!=null){
return c.compare(o1,o2);
}else if(typeof o1=="string"||o1 instanceof Comparable){
return o1.compareTo(o2);
}
return o1-o2;
});
for(var i=0;i<a.length;i++){
a[i]=aux[i];
}
},"~A,java.util.Comparator");
c$.sort=$_M(c$,"sort",
function(a,fromIndex,toIndex,c){
this.rangeCheck(a.length,fromIndex,toIndex);
var aux=new Array();
for(var i=fromIndex;i<toIndex;i++){
aux[i-fromIndex]=a[i];
}
aux=aux.sort(function(o1,o2){
if(c!=null){
return c.compare(o1,o2);
}else if(typeof o1=="string"||o1 instanceof Comparable){
return o1.compareTo(o2);
}
return o1-o2;
});
for(var i=fromIndex;i<toIndex;i++){
a[i]=aux[i-fromIndex];
}
},"~A,~N,~N,java.util.Comparator");
c$.rangeCheck=$_M(c$,"rangeCheck",
($fz=function(arrayLen,fromIndex,toIndex){
if(fromIndex>toIndex)throw new IllegalArgumentException("fromIndex("+fromIndex+") > toIndex("+toIndex+")");
if(fromIndex<0)throw new ArrayIndexOutOfBoundsException(fromIndex);
if(toIndex>arrayLen)throw new ArrayIndexOutOfBoundsException(toIndex);
},$fz.isPrivate=true,$fz),"~N,~N,~N");
c$.binarySearch=$_M(c$,"binarySearch",
function(a,key){
var low=0;
var high=a.length-1;
while(low<=high){
var mid=(low+high)>>1;
var midVal=a[mid];
if(midVal<key)low=mid+1;
else if(midVal>key)high=mid-1;
else return mid;
}
return-(low+1);
},"~A,~N");
c$.binarySearch=$_M(c$,"binarySearch",
function(a,key){
var low=0;
var high=a.length-1;
while(low<=high){
var mid=(low+high)>>1;
var midVal=a[mid];
var cmp=(midVal).compareTo(key);
if(cmp<0)low=mid+1;
else if(cmp>0)high=mid-1;
else return mid;
}
return-(low+1);
},"~A,~O");
c$.binarySearch=$_M(c$,"binarySearch",
function(a,key,c){
if(c==null)return java.util.Arrays.binarySearch(a,key);
var low=0;
var high=a.length-1;
while(low<=high){
var mid=(low+high)>>1;
var midVal=a[mid];
var cmp=c.compare(midVal,key);
if(cmp<0)low=mid+1;
else if(cmp>0)high=mid-1;
else return mid;
}
return-(low+1);
},"~A,~O,java.util.Comparator");
c$.equals=$_M(c$,"equals",
function(a,a2){
if(a===a2)return true;
if(a==null||a2==null)return false;
var length=a.length;
if(a2.length!=length)return false;
for(var i=0;i<length;i++){
var o1=a[i];
var o2=a2[i];
{
if(!(o1==null?o2==null:(o1.equals==null?o1==o2:o1.equals(o2))))return false;
}}
return true;
},"~A,~A");
c$.fill=$_M(c$,"fill",
function(a,val){
java.util.Arrays.fill(a,0,a.length,val);
},"~A,~O");
c$.fill=$_M(c$,"fill",
function(a,fromIndex,toIndex,val){
java.util.Arrays.rangeCheck(a.length,fromIndex,toIndex);
for(var i=fromIndex;i<toIndex;i++)a[i]=val;

},"~A,~N,~N,~O");
c$.asList=$_M(c$,"asList",
function(a){
return new java.util.Arrays.ArrayList(a);
},"~A");
$_H();
c$=$_C(function(){
this.a=null;
$_Z(this,arguments);
},java.util.Arrays,"ArrayList",java.util.AbstractList,[java.util.RandomAccess,java.io.Serializable]);
$_K(c$,
function(a){
$_R(this,java.util.Arrays.ArrayList,[]);
if(a==null)throw new NullPointerException();
this.a=a;
},"~A");
$_V(c$,"size",
function(){
return this.a.length;
});
$_M(c$,"toArray",
function(){
return this.a.clone();
});
$_V(c$,"get",
function(a){
return this.a[a];
},"~N");
$_V(c$,"set",
function(a,b){
var c=this.a[a];
this.a[a]=b;
return c;
},"~N,~O");
$_V(c$,"indexOf",
function(a){
if(a==null){
for(var b=0;b<this.a.length;b++)if(this.a[b]==null)return b;

}else{
for(var b=0;b<this.a.length;b++)if(a.equals(this.a[b]))return b;

}return-1;
},"~O");
$_V(c$,"contains",
function(a){
return this.indexOf(a)!=-1;
},"~O");
c$=$_P();
$_S(c$,
"INSERTIONSORT_THRESHOLD",7);
});
// 
//// java\util\AbstractMap.js 
// 
$_L(["java.util.Map"],"java.util.AbstractMap",["java.lang.StringBuilder","$.UnsupportedOperationException","java.util.AbstractCollection","$.AbstractSet","$.Iterator"],function(){
c$=$_C(function(){
this.$keySet=null;
this.valuesCollection=null;
$_Z(this,arguments);
},java.util,"AbstractMap",null,java.util.Map);
$_K(c$,
function(){
});
$_V(c$,"clear",
function(){
this.entrySet().clear();
});
$_V(c$,"containsKey",
function(key){
var it=this.entrySet().iterator();
if(key!=null){
while(it.hasNext()){
if(key.equals(it.next().getKey())){
return true;
}}
}else{
while(it.hasNext()){
if(it.next().getKey()==null){
return true;
}}
}return false;
},"~O");
$_V(c$,"containsValue",
function(value){
var it=this.entrySet().iterator();
if(value!=null){
while(it.hasNext()){
if(value.equals(it.next().getValue())){
return true;
}}
}else{
while(it.hasNext()){
if(it.next().getValue()==null){
return true;
}}
}return false;
},"~O");
$_V(c$,"equals",
function(object){
if(this===object){
return true;
}if($_O(object,java.util.Map)){
var map=object;
if(this.size()!=map.size()){
return false;
}var objectSet=map.entrySet();
var it=this.entrySet().iterator();
while(it.hasNext()){
if(!objectSet.contains(it.next())){
return false;
}}
return true;
}return false;
},"~O");
$_V(c$,"get",
function(key){
var it=this.entrySet().iterator();
if(key!=null){
while(it.hasNext()){
var entry=it.next();
if(key.equals(entry.getKey())){
return entry.getValue();
}}
}else{
while(it.hasNext()){
var entry=it.next();
if(entry.getKey()==null){
return entry.getValue();
}}
}return null;
},"~O");
$_V(c$,"hashCode",
function(){
var result=0;
var it=this.entrySet().iterator();
while(it.hasNext()){
result+=it.next().hashCode();
}
return result;
});
$_V(c$,"isEmpty",
function(){
return this.size()==0;
});
$_V(c$,"keySet",
function(){
if(this.$keySet==null){
this.$keySet=(($_D("java.util.AbstractMap$1")?0:java.util.AbstractMap.$AbstractMap$1$()),$_N(java.util.AbstractMap$1,this,null));
}return this.$keySet;
});
$_V(c$,"put",
function(key,value){
throw new UnsupportedOperationException();
},"~O,~O");
$_V(c$,"putAll",
function(map){
for(var entry,$entry=map.entrySet().iterator();$entry.hasNext()&&((entry=$entry.next())||true);){
this.put(entry.getKey(),entry.getValue());
}
},"java.util.Map");
$_V(c$,"remove",
function(key){
var it=this.entrySet().iterator();
if(key!=null){
while(it.hasNext()){
var entry=it.next();
if(key.equals(entry.getKey())){
it.remove();
return entry.getValue();
}}
}else{
while(it.hasNext()){
var entry=it.next();
if(entry.getKey()==null){
it.remove();
return entry.getValue();
}}
}return null;
},"~O");
$_V(c$,"size",
function(){
return this.entrySet().size();
});
$_V(c$,"toString",
function(){
if(this.isEmpty()){
return"{}";
}var buffer=new StringBuilder(this.size()*28);
buffer.append('{');
var it=this.entrySet().iterator();
while(it.hasNext()){
var entry=it.next();
var key=entry.getKey();
if(key!==this){
buffer.append(key);
}else{
buffer.append("(this Map)");
}buffer.append('=');
var value=entry.getValue();
if(value!==this){
buffer.append(value);
}else{
buffer.append("(this Map)");
}if(it.hasNext()){
buffer.append(", ");
}}
buffer.append('}');
return buffer.toString();
});
$_V(c$,"values",
function(){
if(this.valuesCollection==null){
this.valuesCollection=(($_D("java.util.AbstractMap$2")?0:java.util.AbstractMap.$AbstractMap$2$()),$_N(java.util.AbstractMap$2,this,null));
}return this.valuesCollection;
});
$_M(c$,"clone",
function(){
var result=$_U(this,java.util.AbstractMap,"clone",[]);
result.$keySet=null;
result.valuesCollection=null;
return result;
});
c$.$AbstractMap$1$=function(){
$_H();
c$=$_W(java.util,"AbstractMap$1",java.util.AbstractSet);
$_V(c$,"contains",
function(object){
return this.b$["java.util.AbstractMap"].containsKey(object);
},"~O");
$_V(c$,"size",
function(){
return this.b$["java.util.AbstractMap"].size();
});
$_V(c$,"iterator",
function(){
return(($_D("java.util.AbstractMap$1$1")?0:java.util.AbstractMap.$AbstractMap$1$1$()),$_N(java.util.AbstractMap$1$1,this,null));
});
c$=$_P();
};
c$.$AbstractMap$1$1$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.setIterator=null;
$_Z(this,arguments);
},java.util,"AbstractMap$1$1",null,java.util.Iterator);
$_Y(c$,function(){
this.setIterator=this.b$["java.util.AbstractMap"].entrySet().iterator();
});
$_V(c$,"hasNext",
function(){
return this.setIterator.hasNext();
});
$_V(c$,"next",
function(){
return this.setIterator.next().getKey();
});
$_V(c$,"remove",
function(){
this.setIterator.remove();
});
c$=$_P();
};
c$.$AbstractMap$2$=function(){
$_H();
c$=$_W(java.util,"AbstractMap$2",java.util.AbstractCollection);
$_V(c$,"size",
function(){
return this.b$["java.util.AbstractMap"].size();
});
$_V(c$,"contains",
function(object){
return this.b$["java.util.AbstractMap"].containsValue(object);
},"~O");
$_V(c$,"iterator",
function(){
return(($_D("java.util.AbstractMap$2$1")?0:java.util.AbstractMap.$AbstractMap$2$1$()),$_N(java.util.AbstractMap$2$1,this,null));
});
c$=$_P();
};
c$.$AbstractMap$2$1$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.setIterator=null;
$_Z(this,arguments);
},java.util,"AbstractMap$2$1",null,java.util.Iterator);
$_Y(c$,function(){
this.setIterator=this.b$["java.util.AbstractMap"].entrySet().iterator();
});
$_V(c$,"hasNext",
function(){
return this.setIterator.hasNext();
});
$_V(c$,"next",
function(){
return this.setIterator.next().getValue();
});
$_V(c$,"remove",
function(){
this.setIterator.remove();
});
c$=$_P();
};
});
// 
//// java\util\SortedMap.js 
// 
$_L(["java.util.Map"],"java.util.SortedMap",null,function(){
$_I(java.util,"SortedMap",java.util.Map);
});
// 
//// java\util\SortedSet.js 
// 
$_L(["java.util.Set"],"java.util.SortedSet",null,function(){
$_I(java.util,"SortedSet",java.util.Set);
});
// 
//// java\util\Collections.js 
// 
$_L(["java.util.AbstractList","$.AbstractMap","$.AbstractSet","$.Collection","$.Iterator","$.List","$.ListIterator","$.Map","$.RandomAccess","$.Set","$.SortedMap","$.SortedSet","java.lang.NullPointerException","$.UnsupportedOperationException","java.lang.reflect.Array"],"java.util.Collections",["java.lang.ArrayIndexOutOfBoundsException","$.ClassCastException","$.IllegalArgumentException","$.IndexOutOfBoundsException","java.util.ArrayList","$.Arrays","$.Enumeration","java.util.Map.Entry","java.util.NoSuchElementException","$.Random"],function(){
c$=$_T(java.util,"Collections");
c$.binarySearch=$_M(c$,"binarySearch",
function(list,object){
if(list==null){
throw new NullPointerException();
}if(list.isEmpty()){
return-1;
}var key=object;
if(!($_O(list,java.util.RandomAccess))){
var it=list.listIterator();
while(it.hasNext()){
var result;
if((result=key.compareTo(it.next()))<=0){
if(result==0){
return it.previousIndex();
}return-it.previousIndex()-1;
}}
return-list.size()-1;
}var low=0;
var mid=list.size();
var high=mid-1;
var result=-1;
while(low<=high){
mid=(low+high)>>1;
if((result=key.compareTo(list.get(mid)))>0){
low=mid+1;
}else if(result==0){
return mid;
}else{
high=mid-1;
}}
return-mid-(result<0?1:2);
},"java.util.List,~O");
c$.binarySearch=$_M(c$,"binarySearch",
function(list,object,comparator){
if(comparator==null){
return java.util.Collections.binarySearch(list,object);
}if(!($_O(list,java.util.RandomAccess))){
var it=list.listIterator();
while(it.hasNext()){
var result;
if((result=comparator.compare(object,it.next()))<=0){
if(result==0){
return it.previousIndex();
}return-it.previousIndex()-1;
}}
return-list.size()-1;
}var low=0;
var mid=list.size();
var high=mid-1;
var result=-1;
while(low<=high){
mid=(low+high)>>1;
if((result=comparator.compare(object,list.get(mid)))>0){
low=mid+1;
}else if(result==0){
return mid;
}else{
high=mid-1;
}}
return-mid-(result<0?1:2);
},"java.util.List,~O,java.util.Comparator");
c$.copy=$_M(c$,"copy",
function(destination,source){
if(destination.size()<source.size()){
throw new ArrayIndexOutOfBoundsException();
}var srcIt=source.iterator();
var destIt=destination.listIterator();
while(srcIt.hasNext()){
try{
destIt.next();
}catch(e){
if($_O(e,java.util.NoSuchElementException)){
throw new ArrayIndexOutOfBoundsException();
}else{
throw e;
}
}
destIt.set(srcIt.next());
}
},"java.util.List,java.util.List");
c$.enumeration=$_M(c$,"enumeration",
function(collection){
var c=collection;
return(($_D("java.util.Collections$1")?0:java.util.Collections.$Collections$1$(c)),$_N(java.util.Collections$1,this,null));
},"java.util.Collection");

c$.fill=$_M(c$,"fill",
function(list,object){
var it=list.listIterator();
while(it.hasNext()){
it.next();
it.set(object);
}
},"java.util.List,~O");
c$.max=$_M(c$,"max",
function(collection){
var it=collection.iterator();
var max=it.next();
while(it.hasNext()){
var next=it.next();
if(max.compareTo(next)<0){
max=next;
}}
return max;
},"java.util.Collection");
c$.max=$_M(c$,"max",
function(collection,comparator){
var it=collection.iterator();
var max=it.next();
while(it.hasNext()){
var next=it.next();
if(comparator.compare(max,next)<0){
max=next;
}}
return max;
},"java.util.Collection,java.util.Comparator");
c$.min=$_M(c$,"min",
function(collection){
var it=collection.iterator();
var min=it.next();
while(it.hasNext()){
var next=it.next();
if(min.compareTo(next)>0){
min=next;
}}
return min;
},"java.util.Collection");
c$.min=$_M(c$,"min",
function(collection,comparator){
var it=collection.iterator();
var min=it.next();
while(it.hasNext()){
var next=it.next();
if(comparator.compare(min,next)>0){
min=next;
}}
return min;
},"java.util.Collection,java.util.Comparator");
c$.nCopies=$_M(c$,"nCopies",
function(length,object){
return new java.util.Collections.CopiesList(length,object);
},"~N,~O");
c$.reverse=$_M(c$,"reverse",
function(list){
var size=list.size();
var front=list.listIterator();
var back=list.listIterator(size);
for(var i=0;i<Math.floor(size/2);i++){
var frontNext=front.next();
var backPrev=back.previous();
front.set(backPrev);
back.set(frontNext);
}
},"java.util.List");
c$.reverseOrder=$_M(c$,"reverseOrder",
function(){
return new java.util.Collections.ReverseComparator();
});
c$.reverseOrder=$_M(c$,"reverseOrder",
function(c){
if(c==null){
return java.util.Collections.reverseOrder();
}return new java.util.Collections.ReverseComparatorWithComparator(c);
},"java.util.Comparator");
c$.shuffle=$_M(c$,"shuffle",
function(list){
java.util.Collections.shuffle(list,new java.util.Random());
},"java.util.List");
c$.shuffle=$_M(c$,"shuffle",
function(list,random){
if(!($_O(list,java.util.RandomAccess))){
var array=list.toArray();
for(var i=array.length-1;i>0;i--){
var index=random.nextInt()%(i+1);
if(index<0){
index=-index;
}var temp=array[i];
array[i]=array[index];
array[index]=temp;
}
var i=0;
var it=list.listIterator();
while(it.hasNext()){
it.next();
it.set(array[i++]);
}
}else{
var rawList=list;
for(var i=rawList.size()-1;i>0;i--){
var index=random.nextInt()%(i+1);
if(index<0){
index=-index;
}rawList.set(index,rawList.set(i,rawList.get(index)));
}
}},"java.util.List,java.util.Random");
c$.singleton=$_M(c$,"singleton",
function(object){
return new java.util.Collections.SingletonSet(object);
},"~O");
c$.singletonList=$_M(c$,"singletonList",
function(object){
return new java.util.Collections.SingletonList(object);
},"~O");
c$.singletonMap=$_M(c$,"singletonMap",
function(key,value){
return new java.util.Collections.SingletonMap(key,value);
},"~O,~O");
c$.sort=$_M(c$,"sort",
function(list){
var array=list.toArray();
java.util.Arrays.sort(array);
var i=0;
var it=list.listIterator();
while(it.hasNext()){
it.next();
it.set(array[i++]);
}
},"java.util.List");
c$.sort=$_M(c$,"sort",
function(list,comparator){
var array=list.toArray(new Array(list.size()));
java.util.Arrays.sort(array,comparator);
var i=0;
var it=list.listIterator();
while(it.hasNext()){
it.next();
it.set(array[i++]);
}
},"java.util.List,java.util.Comparator");
c$.swap=$_M(c$,"swap",
function(list,index1,index2){
if(list==null){
throw new NullPointerException();
}if(index1==index2){
return;
}var rawList=list;
rawList.set(index2,rawList.set(index1,rawList.get(index2)));
},"java.util.List,~N,~N");
c$.replaceAll=$_M(c$,"replaceAll",
function(list,obj,obj2){
var index;
var found=false;
while((index=list.indexOf(obj))>-1){
found=true;
list.set(index,obj2);
}
return found;
},"java.util.List,~O,~O");
c$.rotate=$_M(c$,"rotate",
function(lst,dist){
var list=lst;
var size=list.size();
if(size==0){
return;
}var normdist;
if(dist>0){
normdist=dist%size;
}else{
normdist=size-((dist%size)*(-1));
}if(normdist==0||normdist==size){
return;
}if($_O(list,java.util.RandomAccess)){
var temp=list.get(0);
var index=0;
var beginIndex=0;
for(var i=0;i<size;i++){
index=(index+normdist)%size;
temp=list.set(index,temp);
if(index==beginIndex){
index=++beginIndex;
temp=list.get(beginIndex);
}}
}else{
var divideIndex=(size-normdist)%size;
var sublist1=list.subList(0,divideIndex);
var sublist2=list.subList(divideIndex,size);
java.util.Collections.reverse(sublist1);
java.util.Collections.reverse(sublist2);
java.util.Collections.reverse(list);
}},"java.util.List,~N");
c$.indexOfSubList=$_M(c$,"indexOfSubList",
function(list,sublist){
var size=list.size();
var sublistSize=sublist.size();
if(sublistSize>size){
return-1;
}if(sublistSize==0){
return 0;
}var firstObj=sublist.get(0);
var index=list.indexOf(firstObj);
if(index==-1){
return-1;
}while(index<size&&(size-index>=sublistSize)){
var listIt=list.listIterator(index);
if((firstObj==null)?listIt.next()==null:firstObj.equals(listIt.next())){
var sublistIt=sublist.listIterator(1);
var difFound=false;
while(sublistIt.hasNext()){
var element=sublistIt.next();
if(!listIt.hasNext()){
return-1;
}if((element==null)?listIt.next()!=null:!element.equals(listIt.next())){
difFound=true;
break;
}}
if(!difFound){
return index;
}}index++;
}
return-1;
},"java.util.List,java.util.List");
c$.lastIndexOfSubList=$_M(c$,"lastIndexOfSubList",
function(list,sublist){
var sublistSize=sublist.size();
var size=list.size();
if(sublistSize>size){
return-1;
}if(sublistSize==0){
return size;
}var lastObj=sublist.get(sublistSize-1);
var index=list.lastIndexOf(lastObj);
while((index>-1)&&(index+1>=sublistSize)){
var listIt=list.listIterator(index+1);
if((lastObj==null)?listIt.previous()==null:lastObj.equals(listIt.previous())){
var sublistIt=sublist.listIterator(sublistSize-1);
var difFound=false;
while(sublistIt.hasPrevious()){
var element=sublistIt.previous();
if(!listIt.hasPrevious()){
return-1;
}if((element==null)?listIt.previous()!=null:!element.equals(listIt.previous())){
difFound=true;
break;
}}
if(!difFound){
return listIt.nextIndex();
}}index--;
}
return-1;
},"java.util.List,java.util.List");
c$.list=$_M(c$,"list",
function(enumeration){
var list=new java.util.ArrayList();
while(enumeration.hasMoreElements()){
list.add(enumeration.nextElement());
}
return list;
},"java.util.Enumeration");
c$.synchronizedCollection=$_M(c$,"synchronizedCollection",
function(collection){
if(collection==null){
throw new NullPointerException();
}return new java.util.Collections.SynchronizedCollection(collection);
},"java.util.Collection");
c$.synchronizedList=$_M(c$,"synchronizedList",
function(list){
if(list==null){
throw new NullPointerException();
}if($_O(list,java.util.RandomAccess)){
return new java.util.Collections.SynchronizedRandomAccessList(list);
}return new java.util.Collections.SynchronizedList(list);
},"java.util.List");
c$.synchronizedMap=$_M(c$,"synchronizedMap",
function(map){
if(map==null){
throw new NullPointerException();
}return new java.util.Collections.SynchronizedMap(map);
},"java.util.Map");
c$.synchronizedSet=$_M(c$,"synchronizedSet",
function(set){
if(set==null){
throw new NullPointerException();
}return new java.util.Collections.SynchronizedSet(set);
},"java.util.Set");
c$.synchronizedSortedMap=$_M(c$,"synchronizedSortedMap",
function(map){
if(map==null){
throw new NullPointerException();
}return new java.util.Collections.SynchronizedSortedMap(map);
},"java.util.SortedMap");
c$.synchronizedSortedSet=$_M(c$,"synchronizedSortedSet",
function(set){
if(set==null){
throw new NullPointerException();
}return new java.util.Collections.SynchronizedSortedSet(set);
},"java.util.SortedSet");
c$.unmodifiableCollection=$_M(c$,"unmodifiableCollection",
function(collection){
if(collection==null){
throw new NullPointerException();
}return new java.util.Collections.UnmodifiableCollection(collection);
},"java.util.Collection");
c$.unmodifiableList=$_M(c$,"unmodifiableList",
function(list){
if(list==null){
throw new NullPointerException();
}if($_O(list,java.util.RandomAccess)){
return new java.util.Collections.UnmodifiableRandomAccessList(list);
}return new java.util.Collections.UnmodifiableList(list);
},"java.util.List");
c$.unmodifiableMap=$_M(c$,"unmodifiableMap",
function(map){
if(map==null){
throw new NullPointerException();
}return new java.util.Collections.UnmodifiableMap(map);
},"java.util.Map");
c$.unmodifiableSet=$_M(c$,"unmodifiableSet",
function(set){
if(set==null){
throw new NullPointerException();
}return new java.util.Collections.UnmodifiableSet(set);
},"java.util.Set");
c$.unmodifiableSortedMap=$_M(c$,"unmodifiableSortedMap",
function(map){
if(map==null){
throw new NullPointerException();
}return new java.util.Collections.UnmodifiableSortedMap(map);
},"java.util.SortedMap");
c$.unmodifiableSortedSet=$_M(c$,"unmodifiableSortedSet",
function(set){
if(set==null){
throw new NullPointerException();
}return new java.util.Collections.UnmodifiableSortedSet(set);
},"java.util.SortedSet");
c$.frequency=$_M(c$,"frequency",
function(c,o){
if(c==null){
throw new NullPointerException();
}if(c.isEmpty()){
return 0;
}
var result=0;
var itr=c.iterator();
while(itr.hasNext()){
var e=itr.next();
if(o==null?e==null:o.equals(e)){
result++;
}}
return result;
},"java.util.Collection,~O");

c$.emptyList=$_M(c$,"emptyList",
function(){
return java.util.Collections.EMPTY_LIST;
});
c$.emptySet=$_M(c$,"emptySet",
function(){
return java.util.Collections.EMPTY_SET;
});
c$.emptyMap=$_M(c$,"emptyMap",
function(){
return java.util.Collections.EMPTY_MAP;
});
c$.checkedCollection=$_M(c$,"checkedCollection",
function(c,type){
return new java.util.Collections.CheckedCollection(c,type);
},"java.util.Collection,Class");
c$.checkedMap=$_M(c$,"checkedMap",
function(m,keyType,valueType){
return new java.util.Collections.CheckedMap(m,keyType,valueType);
},"java.util.Map,Class,Class");
c$.checkedList=$_M(c$,"checkedList",
function(list,type){
if($_O(list,java.util.RandomAccess)){
return new java.util.Collections.CheckedRandomAccessList(list,type);
}return new java.util.Collections.CheckedList(list,type);
},"java.util.List,Class");
c$.checkedSet=$_M(c$,"checkedSet",
function(s,type){
return new java.util.Collections.CheckedSet(s,type);
},"java.util.Set,Class");
c$.checkedSortedMap=$_M(c$,"checkedSortedMap",
function(m,keyType,valueType){
return new java.util.Collections.CheckedSortedMap(m,keyType,valueType);
},"java.util.SortedMap,Class,Class");
c$.checkedSortedSet=$_M(c$,"checkedSortedSet",
function(s,type){
return new java.util.Collections.CheckedSortedSet(s,type);
},"java.util.SortedSet,Class");
c$.addAll=$_M(c$,"addAll",
function(c,a){
var modified=false;
for(var i=0;i<a.length;i++){
modified=new Boolean(modified|c.add(a[i])).valueOf();
}
return modified;
},"java.util.Collection,~A");
c$.disjoint=$_M(c$,"disjoint",
function(c1,c2){
if(($_O(c1,java.util.Set))&&!($_O(c2,java.util.Set))||(c2.size())>c1.size()){
var tmp=c1;
c1=c2;
c2=tmp;
}var it=c1.iterator();
while(it.hasNext()){
if(c2.contains(it.next())){
return false;
}}
return true;
},"java.util.Collection,java.util.Collection");
c$.checkType=$_M(c$,"checkType",
function(obj,type){
if(!type.isInstance(obj)){
throw new ClassCastException("Attempt to insert "+obj.getClass()+" element into collection with element type "+type);
}return obj;
},"~O,Class");

c$.$Collections$1$=function(c){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.it=null;
$_Z(this,arguments);
},java.util,"Collections$1",null,java.util.Enumeration);

$_Y(c$,function(){
this.it=c.iterator();
});

$_M(c$,"hasMoreElements",
function(){
return this.it.hasNext();
});
$_M(c$,"nextElement",
function(){
return this.it.next();
});
c$=$_P();
};

$_H();
c$=$_C(function(){
this.n=0;
this.element=null;
$_Z(this,arguments);
},java.util.Collections,"CopiesList",java.util.AbstractList,java.io.Serializable);
$_K(c$,
function(a,b){
$_R(this,java.util.Collections.CopiesList,[]);
if(a<0){
throw new IllegalArgumentException();
}this.n=a;
this.element=b;
},"~N,~O");
$_V(c$,"contains",
function(a){
return this.element==null?a==null:this.element.equals(a);
},"~O");
$_V(c$,"size",
function(){
return this.n;
});
$_V(c$,"get",
function(a){
if(0<=a&&a<this.n){
return this.element;
}throw new IndexOutOfBoundsException();
},"~N");
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"EmptyList",java.util.AbstractList,java.io.Serializable);
$_V(c$,"contains",
function(a){
return false;
},"~O");
$_V(c$,"size",
function(){
return 0;
});
$_V(c$,"get",
function(a){
throw new IndexOutOfBoundsException();
},"~N");
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"EmptySet",java.util.AbstractSet,java.io.Serializable);
$_V(c$,"contains",
function(a){
return false;
},"~O");
$_V(c$,"size",
function(){
return 0;
});
$_V(c$,"iterator",
function(){
return(($_D("java.util.Collections$EmptySet$1")?0:java.util.Collections.EmptySet.$Collections$EmptySet$1$()),$_N(java.util.Collections$EmptySet$1,this,null));
});
c$.$Collections$EmptySet$1$=function(){
$_H();
c$=$_W(java.util,"Collections$EmptySet$1",null,java.util.Iterator);
$_V(c$,"hasNext",
function(){
return false;
});
$_V(c$,"next",
function(){
throw new java.util.NoSuchElementException();
});
$_V(c$,"remove",
function(){
throw new UnsupportedOperationException();
});
c$=$_P();
};
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"EmptyMap",java.util.AbstractMap,java.io.Serializable);
$_V(c$,"containsKey",
function(a){
return false;
},"~O");
$_V(c$,"containsValue",
function(a){
return false;
},"~O");
$_V(c$,"entrySet",
function(){
return java.util.Collections.EMPTY_SET;
});
$_V(c$,"get",
function(a){
return null;
},"~O");
$_V(c$,"keySet",
function(){
return java.util.Collections.EMPTY_SET;
});
$_V(c$,"values",
function(){
return java.util.Collections.EMPTY_LIST;
});
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"ReverseComparator",null,[java.util.Comparator,java.io.Serializable]);
$_V(c$,"compare",
function(a,b){
var c=b;
return c.compareTo(a);
},"~O,~O");
c$=$_P();
$_H();
c$=$_C(function(){
this.comparator=null;
$_Z(this,arguments);
},java.util.Collections,"ReverseComparatorWithComparator",null,[java.util.Comparator,java.io.Serializable]);
$_K(c$,
function(a){
this.comparator=a;
},"java.util.Comparator");
$_M(c$,"compare",
function(a,b){
return this.comparator.compare(b,a);
},"~O,~O");
c$=$_P();
$_H();
c$=$_C(function(){
this.element=null;
$_Z(this,arguments);
},java.util.Collections,"SingletonSet",java.util.AbstractSet,java.io.Serializable);
$_K(c$,
function(a){
$_R(this,java.util.Collections.SingletonSet,[]);
this.element=a;
},"~O");
$_V(c$,"contains",
function(a){
return this.element==null?a==null:this.element.equals(a);
},"~O");
$_V(c$,"size",
function(){
return 1;
});
$_V(c$,"iterator",
function(){
return(($_D("java.util.Collections$SingletonSet$1")?0:java.util.Collections.SingletonSet.$Collections$SingletonSet$1$()),$_N(java.util.Collections$SingletonSet$1,this,null));
});
c$.$Collections$SingletonSet$1$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.$hasNext=true;
$_Z(this,arguments);
},java.util,"Collections$SingletonSet$1",null,java.util.Iterator);
$_V(c$,"hasNext",
function(){
return this.$hasNext;
});
$_V(c$,"next",
function(){
if(this.$hasNext){
this.$hasNext=false;
return this.b$["java.util.Collections.SingletonSet"].element;
}throw new java.util.NoSuchElementException();
});
$_V(c$,"remove",
function(){
throw new UnsupportedOperationException();
});
c$=$_P();
};
c$=$_P();
$_H();
c$=$_C(function(){
this.element=null;
$_Z(this,arguments);
},java.util.Collections,"SingletonList",java.util.AbstractList,java.io.Serializable);
$_K(c$,
function(a){
$_R(this,java.util.Collections.SingletonList,[]);
this.element=a;
},"~O");
$_V(c$,"contains",
function(a){
return this.element==null?a==null:this.element.equals(a);
},"~O");
$_V(c$,"get",
function(a){
if(a==0){
return this.element;
}throw new IndexOutOfBoundsException();
},"~N");
$_V(c$,"size",
function(){
return 1;
});
c$=$_P();
$_H();
c$=$_C(function(){
this.k=null;
this.v=null;
$_Z(this,arguments);
},java.util.Collections,"SingletonMap",java.util.AbstractMap,java.io.Serializable);
$_K(c$,
function(a,b){
$_R(this,java.util.Collections.SingletonMap,[]);
this.k=a;
this.v=b;
},"~O,~O");
$_V(c$,"containsKey",
function(a){
return this.k==null?a==null:this.k.equals(a);
},"~O");
$_V(c$,"containsValue",
function(a){
return this.v==null?a==null:this.v.equals(a);
},"~O");
$_V(c$,"get",
function(a){
if(this.containsKey(a)){
return this.v;
}return null;
},"~O");
$_V(c$,"size",
function(){
return 1;
});
$_V(c$,"entrySet",
function(){
return(($_D("java.util.Collections$SingletonMap$1")?0:java.util.Collections.SingletonMap.$Collections$SingletonMap$1$()),$_N(java.util.Collections$SingletonMap$1,this,null));
});
c$.$Collections$SingletonMap$1$=function(){
$_H();
c$=$_W(java.util,"Collections$SingletonMap$1",java.util.AbstractSet);
$_V(c$,"contains",
function(a){
if($_O(a,java.util.Map.Entry)){
var b=a;
return this.b$["java.util.Collections.SingletonMap"].containsKey(b.getKey())&&this.b$["java.util.Collections.SingletonMap"].containsValue(b.getValue());
}return false;
},"~O");
$_V(c$,"size",
function(){
return 1;
});
$_V(c$,"iterator",
function(){
return(($_D("java.util.Collections$SingletonMap$1$1")?0:java.util.Collections.$Collections$SingletonMap$1$1$()),$_N(java.util.Collections$SingletonMap$1$1,this,null));
});
c$=$_P();
};
c$.$Collections$SingletonMap$1$1$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.$hasNext=true;
$_Z(this,arguments);
},java.util,"Collections$SingletonMap$1$1",null,java.util.Iterator);
$_V(c$,"hasNext",
function(){
return this.$hasNext;
});
$_V(c$,"next",
function(){
if(this.$hasNext){
this.$hasNext=false;
return(($_D("java.util.Collections$SingletonMap$1$1$1")?0:java.util.Collections.$Collections$SingletonMap$1$1$1$()),$_N(java.util.Collections$SingletonMap$1$1$1,this,null));
}throw new java.util.NoSuchElementException();
});
$_V(c$,"remove",
function(){
throw new UnsupportedOperationException();
});
c$=$_P();
};
c$.$Collections$SingletonMap$1$1$1$=function(){
$_H();
c$=$_W(java.util,"Collections$SingletonMap$1$1$1",null,java.util.Map.Entry);
$_V(c$,"equals",
function(a){
return this.b$["java.util.Collections$SingletonMap$1"].contains(a);
},"~O");
$_V(c$,"getKey",
function(){
return this.b$["java.util.Collections.SingletonMap"].k;
});
$_V(c$,"getValue",
function(){
return this.b$["java.util.Collections.SingletonMap"].v;
});
$_V(c$,"hashCode",
function(){
return(this.b$["java.util.Collections.SingletonMap"].k==null?0:this.b$["java.util.Collections.SingletonMap"].k.hashCode())^(this.b$["java.util.Collections.SingletonMap"].v==null?0:this.b$["java.util.Collections.SingletonMap"].v.hashCode());
});
$_V(c$,"setValue",
function(a){
throw new UnsupportedOperationException();
},"~O");
c$=$_P();
};
c$=$_P();
$_H();
c$=$_C(function(){
this.c=null;
this.mutex=null;
$_Z(this,arguments);
},java.util.Collections,"SynchronizedCollection",null,[java.util.Collection,java.io.Serializable]);
$_K(c$,
function(a){
this.c=a;
this.mutex=this;
},"java.util.Collection");
$_K(c$,
function(a,b){
this.c=a;
this.mutex=b;
},"java.util.Collection,~O");
$_M(c$,"add",
function(a){
{
return this.c.add(a);
}},"~O");
$_M(c$,"addAll",
function(a){
{
return this.c.addAll(a);
}},"java.util.Collection");
$_M(c$,"clear",
function(){
{
this.c.clear();
}});
$_M(c$,"contains",
function(a){
{
return this.c.contains(a);
}},"~O");
$_M(c$,"containsAll",
function(a){
{
return this.c.containsAll(a);
}},"java.util.Collection");
$_M(c$,"isEmpty",
function(){
{
return this.c.isEmpty();
}});
$_M(c$,"iterator",
function(){
{
return this.c.iterator();
}});
$_M(c$,"remove",
function(a){
{
return this.c.remove(a);
}},"~O");
$_M(c$,"removeAll",
function(a){
{
return this.c.removeAll(a);
}},"java.util.Collection");
$_M(c$,"retainAll",
function(a){
{
return this.c.retainAll(a);
}},"java.util.Collection");
$_M(c$,"size",
function(){
{
return this.c.size();
}});
$_M(c$,"toArray",
function(){
{
return this.c.toArray();
}});
$_M(c$,"toString",
function(){
{
return this.c.toString();
}});
$_M(c$,"toArray",
function(a){
{
return this.c.toArray(a);
}},"~A");
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"SynchronizedRandomAccessList",java.util.Collections.SynchronizedList,java.util.RandomAccess);
$_V(c$,"subList",
function(a,b){
{
return new java.util.Collections.SynchronizedRandomAccessList(this.list.subList(a,b),this.mutex);
}},"~N,~N");
c$=$_P();
$_H();
c$=$_C(function(){
this.list=null;
$_Z(this,arguments);
},java.util.Collections,"SynchronizedList",java.util.Collections.SynchronizedCollection,java.util.List);
$_K(c$,
function(a){
$_R(this,java.util.Collections.SynchronizedList,[a]);
this.list=a;
},"java.util.List");
$_K(c$,
function(a,b){
$_R(this,java.util.Collections.SynchronizedList,[a,b]);
this.list=a;
},"java.util.List,~O");
$_M(c$,"add",
function(a,b){
{
this.list.add(a,b);
}},"~N,~O");
$_M(c$,"addAll",
function(a,b){
{
return this.list.addAll(a,b);
}},"~N,java.util.Collection");
$_M(c$,"equals",
function(a){
{
return this.list.equals(a);
}},"~O");
$_M(c$,"get",
function(a){
{
return this.list.get(a);
}},"~N");
$_M(c$,"hashCode",
function(){
{
return this.list.hashCode();
}});
$_M(c$,"indexOf",
function(a){
{
return this.list.indexOf(a);
}},"~O");
$_M(c$,"lastIndexOf",
function(a){
{
return this.list.lastIndexOf(a);
}},"~O");
$_M(c$,"listIterator",
function(){
{
return this.list.listIterator();
}});
$_M(c$,"listIterator",
function(a){
{
return this.list.listIterator(a);
}},"~N");
$_M(c$,"remove",
function(a){
{
return this.list.remove(a);
}},"~N");
$_M(c$,"set",
function(a,b){
{
return this.list.set(a,b);
}},"~N,~O");
$_M(c$,"subList",
function(a,b){
{
return new java.util.Collections.SynchronizedList(this.list.subList(a,b),this.mutex);
}},"~N,~N");
c$=$_P();
$_H();
c$=$_C(function(){
this.m=null;
this.mutex=null;
$_Z(this,arguments);
},java.util.Collections,"SynchronizedMap",null,[java.util.Map,java.io.Serializable]);
$_K(c$,
function(a){
this.m=a;
this.mutex=this;
},"java.util.Map");
$_K(c$,
function(a,b){
this.m=a;
this.mutex=b;
},"java.util.Map,~O");
$_M(c$,"clear",
function(){
{
this.m.clear();
}});
$_M(c$,"containsKey",
function(a){
{
return this.m.containsKey(a);
}},"~O");
$_M(c$,"containsValue",
function(a){
{
return this.m.containsValue(a);
}},"~O");
$_M(c$,"entrySet",
function(){
{
return new java.util.Collections.SynchronizedSet(this.m.entrySet(),this.mutex);
}});
$_M(c$,"equals",
function(a){
{
return this.m.equals(a);
}},"~O");
$_M(c$,"get",
function(a){
{
return this.m.get(a);
}},"~O");
$_M(c$,"hashCode",
function(){
{
return this.m.hashCode();
}});
$_M(c$,"isEmpty",
function(){
{
return this.m.isEmpty();
}});
$_M(c$,"keySet",
function(){
{
return new java.util.Collections.SynchronizedSet(this.m.keySet(),this.mutex);
}});
$_M(c$,"put",
function(a,b){
{
return this.m.put(a,b);
}},"~O,~O");
$_M(c$,"putAll",
function(a){
{
this.m.putAll(a);
}},"java.util.Map");
$_M(c$,"remove",
function(a){
{
return this.m.remove(a);
}},"~O");
$_M(c$,"size",
function(){
{
return this.m.size();
}});
$_M(c$,"values",
function(){
{
return new java.util.Collections.SynchronizedCollection(this.m.values(),this.mutex);
}});
$_M(c$,"toString",
function(){
{
return this.m.toString();
}});
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"SynchronizedSet",java.util.Collections.SynchronizedCollection,java.util.Set);
$_V(c$,"equals",
function(a){
{
return this.c.equals(a);
}},"~O");
$_V(c$,"hashCode",
function(){
{
return this.c.hashCode();
}});
c$=$_P();
$_H();
c$=$_C(function(){
this.sm=null;
$_Z(this,arguments);
},java.util.Collections,"SynchronizedSortedMap",java.util.Collections.SynchronizedMap,java.util.SortedMap);
$_K(c$,
function(a){
$_R(this,java.util.Collections.SynchronizedSortedMap,[a]);
this.sm=a;
},"java.util.SortedMap");
$_K(c$,
function(a,b){
$_R(this,java.util.Collections.SynchronizedSortedMap,[a,b]);
this.sm=a;
},"java.util.SortedMap,~O");
$_M(c$,"comparator",
function(){
{
return this.sm.comparator();
}});
$_M(c$,"firstKey",
function(){
{
return this.sm.firstKey();
}});
$_M(c$,"headMap",
function(a){
{
return new java.util.Collections.SynchronizedSortedMap(this.sm.headMap(a),this.mutex);
}},"~O");
$_M(c$,"lastKey",
function(){
{
return this.sm.lastKey();
}});
$_M(c$,"subMap",
function(a,b){
{
return new java.util.Collections.SynchronizedSortedMap(this.sm.subMap(a,b),this.mutex);
}},"~O,~O");
$_M(c$,"tailMap",
function(a){
{
return new java.util.Collections.SynchronizedSortedMap(this.sm.tailMap(a),this.mutex);
}},"~O");
c$=$_P();
$_H();
c$=$_C(function(){
this.ss=null;
$_Z(this,arguments);
},java.util.Collections,"SynchronizedSortedSet",java.util.Collections.SynchronizedSet,java.util.SortedSet);
$_K(c$,
function(a){
$_R(this,java.util.Collections.SynchronizedSortedSet,[a]);
this.ss=a;
},"java.util.SortedSet");
$_K(c$,
function(a,b){
$_R(this,java.util.Collections.SynchronizedSortedSet,[a,b]);
this.ss=a;
},"java.util.SortedSet,~O");
$_M(c$,"comparator",
function(){
{
return this.ss.comparator();
}});
$_M(c$,"first",
function(){
{
return this.ss.first();
}});
$_M(c$,"headSet",
function(a){
{
return new java.util.Collections.SynchronizedSortedSet(this.ss.headSet(a),this.mutex);
}},"~O");
$_M(c$,"last",
function(){
{
return this.ss.last();
}});
$_M(c$,"subSet",
function(a,b){
{
return new java.util.Collections.SynchronizedSortedSet(this.ss.subSet(a,b),this.mutex);
}},"~O,~O");
$_M(c$,"tailSet",
function(a){
{
return new java.util.Collections.SynchronizedSortedSet(this.ss.tailSet(a),this.mutex);
}},"~O");
c$=$_P();
$_H();
c$=$_C(function(){
this.c=null;
$_Z(this,arguments);
},java.util.Collections,"UnmodifiableCollection",null,[java.util.Collection,java.io.Serializable]);
$_K(c$,
function(a){
this.c=a;
},"java.util.Collection");
$_V(c$,"add",
function(a){
throw new UnsupportedOperationException();
},"~O");
$_V(c$,"addAll",
function(a){
throw new UnsupportedOperationException();
},"java.util.Collection");
$_V(c$,"clear",
function(){
throw new UnsupportedOperationException();
});
$_M(c$,"contains",
function(a){
return this.c.contains(a);
},"~O");
$_M(c$,"containsAll",
function(a){
return this.c.containsAll(a);
},"java.util.Collection");
$_M(c$,"isEmpty",
function(){
return this.c.isEmpty();
});
$_M(c$,"iterator",
function(){
return(($_D("java.util.Collections$UnmodifiableCollection$1")?0:java.util.Collections.UnmodifiableCollection.$Collections$UnmodifiableCollection$1$()),$_N(java.util.Collections$UnmodifiableCollection$1,this,null));
});
$_V(c$,"remove",
function(a){
throw new UnsupportedOperationException();
},"~O");
$_V(c$,"removeAll",
function(a){
throw new UnsupportedOperationException();
},"java.util.Collection");
$_V(c$,"retainAll",
function(a){
throw new UnsupportedOperationException();
},"java.util.Collection");
$_M(c$,"size",
function(){
return this.c.size();
});
$_M(c$,"toArray",
function(){
return this.c.toArray();
});
$_M(c$,"toArray",
function(a){
return this.c.toArray(a);
},"~A");
$_M(c$,"toString",
function(){
return this.c.toString();
});
c$.$Collections$UnmodifiableCollection$1$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.iterator=null;
$_Z(this,arguments);
},java.util,"Collections$UnmodifiableCollection$1",null,java.util.Iterator);
$_Y(c$,function(){
this.iterator=this.b$["java.util.Collections.UnmodifiableCollection"].c.iterator();
});
$_M(c$,"hasNext",
function(){
return this.iterator.hasNext();
});
$_M(c$,"next",
function(){
return this.iterator.next();
});
$_V(c$,"remove",
function(){
throw new UnsupportedOperationException();
});
c$=$_P();
};
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"UnmodifiableRandomAccessList",java.util.Collections.UnmodifiableList,java.util.RandomAccess);
$_V(c$,"subList",
function(a,b){
return new java.util.Collections.UnmodifiableRandomAccessList(this.list.subList(a,b));
},"~N,~N");
c$=$_P();
$_H();
c$=$_C(function(){
this.list=null;
$_Z(this,arguments);
},java.util.Collections,"UnmodifiableList",java.util.Collections.UnmodifiableCollection,java.util.List);
$_K(c$,
function(a){
$_R(this,java.util.Collections.UnmodifiableList,[a]);
this.list=a;
},"java.util.List");
$_M(c$,"add",
function(a,b){
throw new UnsupportedOperationException();
},"~N,~O");
$_M(c$,"addAll",
function(a,b){
throw new UnsupportedOperationException();
},"~N,java.util.Collection");
$_M(c$,"equals",
function(a){
return this.list.equals(a);
},"~O");
$_M(c$,"get",
function(a){
return this.list.get(a);
},"~N");
$_M(c$,"hashCode",
function(){
return this.list.hashCode();
});
$_M(c$,"indexOf",
function(a){
return this.list.indexOf(a);
},"~O");
$_M(c$,"lastIndexOf",
function(a){
return this.list.lastIndexOf(a);
},"~O");
$_M(c$,"listIterator",
function(){
return this.listIterator(0);
});
$_M(c$,"listIterator",
function(a){
return(($_D("java.util.Collections$UnmodifiableList$1")?0:java.util.Collections.UnmodifiableList.$Collections$UnmodifiableList$1$()),$_N(java.util.Collections$UnmodifiableList$1,this,null));
},"~N");
$_M(c$,"remove",
function(a){
throw new UnsupportedOperationException();
},"~N");
$_V(c$,"set",
function(a,b){
throw new UnsupportedOperationException();
},"~N,~O");
$_M(c$,"subList",
function(a,b){
return new java.util.Collections.UnmodifiableList(this.list.subList(a,b));
},"~N,~N");
c$.$Collections$UnmodifiableList$1$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.iterator=null;
$_Z(this,arguments);
},java.util,"Collections$UnmodifiableList$1",null,java.util.ListIterator);
$_Y(c$,function(){
this.iterator=this.b$["java.util.Collections.UnmodifiableList"].list.listIterator(location);
});
$_V(c$,"add",
function(b){
throw new UnsupportedOperationException();
},"~O");
$_M(c$,"hasNext",
function(){
return this.iterator.hasNext();
});
$_M(c$,"hasPrevious",
function(){
return this.iterator.hasPrevious();
});
$_M(c$,"next",
function(){
return this.iterator.next();
});
$_M(c$,"nextIndex",
function(){
return this.iterator.nextIndex();
});
$_M(c$,"previous",
function(){
return this.iterator.previous();
});
$_M(c$,"previousIndex",
function(){
return this.iterator.previousIndex();
});
$_V(c$,"remove",
function(){
throw new UnsupportedOperationException();
});
$_V(c$,"set",
function(b){
throw new UnsupportedOperationException();
},"~O");
c$=$_P();
};
c$=$_P();
$_H();
c$=$_C(function(){
this.m=null;
$_Z(this,arguments);
},java.util.Collections,"UnmodifiableMap",null,[java.util.Map,java.io.Serializable]);
$_K(c$,
function(a){
this.m=a;
},"java.util.Map");
$_V(c$,"clear",
function(){
throw new UnsupportedOperationException();
});
$_M(c$,"containsKey",
function(a){
return this.m.containsKey(a);
},"~O");
$_M(c$,"containsValue",
function(a){
return this.m.containsValue(a);
},"~O");
$_M(c$,"entrySet",
function(){
return new java.util.Collections.UnmodifiableMap.UnmodifiableEntrySet(this.m.entrySet());
});
$_M(c$,"equals",
function(a){
return this.m.equals(a);
},"~O");
$_M(c$,"get",
function(a){
return this.m.get(a);
},"~O");
$_M(c$,"hashCode",
function(){
return this.m.hashCode();
});
$_M(c$,"isEmpty",
function(){
return this.m.isEmpty();
});
$_M(c$,"keySet",
function(){
return new java.util.Collections.UnmodifiableSet(this.m.keySet());
});
$_V(c$,"put",
function(a,b){
throw new UnsupportedOperationException();
},"~O,~O");
$_V(c$,"putAll",
function(a){
throw new UnsupportedOperationException();
},"java.util.Map");
$_V(c$,"remove",
function(a){
throw new UnsupportedOperationException();
},"~O");
$_M(c$,"size",
function(){
return this.m.size();
});
$_M(c$,"values",
function(){
return new java.util.Collections.UnmodifiableCollection(this.m.values());
});
$_M(c$,"toString",
function(){
return this.m.toString();
});
$_H();
c$=$_T(java.util.Collections.UnmodifiableMap,"UnmodifiableEntrySet",java.util.Collections.UnmodifiableSet);
$_V(c$,"iterator",
function(){
return(($_D("java.util.Collections$UnmodifiableMap$UnmodifiableEntrySet$1")?0:java.util.Collections.UnmodifiableMap.UnmodifiableEntrySet.$Collections$UnmodifiableMap$UnmodifiableEntrySet$1$()),$_N(java.util.Collections$UnmodifiableMap$UnmodifiableEntrySet$1,this,null));
});
$_M(c$,"toArray",
function(){
var a=this.c.size();
var b=new Array(a);
var c=this.iterator();
for(var d=a;--d>=0;){
b[d]=c.next();
}
return b;
});
$_M(c$,"toArray",
function(a){
var b=this.c.size();
var c=0;
var d=this.iterator();
if(b>a.length){
var e=a.getClass().getComponentType();
a=java.lang.reflect.Array.newInstance(e,b);
}while(c<b){
a[c++]=d.next();
}
if(c<a.length){
a[c]=null;
}return a;
},"~A");
c$.$Collections$UnmodifiableMap$UnmodifiableEntrySet$1$=function(){
$_H();
c$=$_C(function(){
$_B(this,arguments);
this.iterator=null;
$_Z(this,arguments);
},java.util,"Collections$UnmodifiableMap$UnmodifiableEntrySet$1",null,java.util.Iterator);
$_Y(c$,function(){
this.iterator=this.b$["java.util.Collections.UnmodifiableMap.UnmodifiableEntrySet"].c.iterator();
});
$_M(c$,"hasNext",
function(){
return this.iterator.hasNext();
});
$_M(c$,"next",
function(){
return new java.util.Collections.UnmodifiableMap.UnmodifiableEntrySet.UnmodifiableMapEntry(this.iterator.next());
});
$_V(c$,"remove",
function(){
throw new UnsupportedOperationException();
});
c$=$_P();
};
$_H();
c$=$_C(function(){
this.mapEntry=null;
$_Z(this,arguments);
},java.util.Collections.UnmodifiableMap.UnmodifiableEntrySet,"UnmodifiableMapEntry",null,java.util.Map.Entry);
$_K(c$,
function(a){
this.mapEntry=a;
},"java.util.Map.Entry");
$_M(c$,"equals",
function(a){
return this.mapEntry.equals(a);
},"~O");
$_M(c$,"getKey",
function(){
return this.mapEntry.getKey();
});
$_M(c$,"getValue",
function(){
return this.mapEntry.getValue();
});
$_M(c$,"hashCode",
function(){
return this.mapEntry.hashCode();
});
$_V(c$,"setValue",
function(a){
throw new UnsupportedOperationException();
},"~O");
$_M(c$,"toString",
function(){
return this.mapEntry.toString();
});
c$=$_P();
c$=$_P();
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"UnmodifiableSet",java.util.Collections.UnmodifiableCollection,java.util.Set);
$_V(c$,"equals",
function(a){
return this.c.equals(a);
},"~O");
$_V(c$,"hashCode",
function(){
return this.c.hashCode();
});
c$=$_P();
$_H();
c$=$_C(function(){
this.sm=null;
$_Z(this,arguments);
},java.util.Collections,"UnmodifiableSortedMap",java.util.Collections.UnmodifiableMap,java.util.SortedMap);
$_K(c$,
function(a){
$_R(this,java.util.Collections.UnmodifiableSortedMap,[a]);
this.sm=a;
},"java.util.SortedMap");
$_M(c$,"comparator",
function(){
return this.sm.comparator();
});
$_M(c$,"firstKey",
function(){
return this.sm.firstKey();
});
$_M(c$,"headMap",
function(a){
return new java.util.Collections.UnmodifiableSortedMap(this.sm.headMap(a));
},"~O");
$_M(c$,"lastKey",
function(){
return this.sm.lastKey();
});
$_M(c$,"subMap",
function(a,b){
return new java.util.Collections.UnmodifiableSortedMap(this.sm.subMap(a,b));
},"~O,~O");
$_M(c$,"tailMap",
function(a){
return new java.util.Collections.UnmodifiableSortedMap(this.sm.tailMap(a));
},"~O");
c$=$_P();
$_H();
c$=$_C(function(){
this.ss=null;
$_Z(this,arguments);
},java.util.Collections,"UnmodifiableSortedSet",java.util.Collections.UnmodifiableSet,java.util.SortedSet);
$_K(c$,
function(a){
$_R(this,java.util.Collections.UnmodifiableSortedSet,[a]);
this.ss=a;
},"java.util.SortedSet");
$_M(c$,"comparator",
function(){
return this.ss.comparator();
});
$_M(c$,"first",
function(){
return this.ss.first();
});
$_M(c$,"headSet",
function(a){
return new java.util.Collections.UnmodifiableSortedSet(this.ss.headSet(a));
},"~O");
$_M(c$,"last",
function(){
return this.ss.last();
});
$_M(c$,"subSet",
function(a,b){
return new java.util.Collections.UnmodifiableSortedSet(this.ss.subSet(a,b));
},"~O,~O");
$_M(c$,"tailSet",
function(a){
return new java.util.Collections.UnmodifiableSortedSet(this.ss.tailSet(a));
},"~O");
c$=$_P();
$_H();
c$=$_C(function(){
this.c=null;
this.type=null;
$_Z(this,arguments);
},java.util.Collections,"CheckedCollection",null,[java.util.Collection,java.io.Serializable]);
$_K(c$,
function(a,b){
if(a==null||b==null){
throw new NullPointerException();
}this.c=a;
this.type=b;
},"java.util.Collection,Class");
$_M(c$,"size",
function(){
return this.c.size();
});
$_M(c$,"isEmpty",
function(){
return this.c.isEmpty();
});
$_M(c$,"contains",
function(a){
return this.c.contains(a);
},"~O");
$_M(c$,"iterator",
function(){
var a=this.c.iterator();
if($_O(a,java.util.ListIterator)){
a=new java.util.Collections.CheckedListIterator(a,this.type);
}return a;
});
$_M(c$,"toArray",
function(){
return this.c.toArray();
});
$_M(c$,"toArray",
function(a){
return this.c.toArray(a);
},"~A");
$_M(c$,"add",
function(a){
return this.c.add(java.util.Collections.checkType(a,this.type));
},"~O");
$_M(c$,"remove",
function(a){
return this.c.remove(a);
},"~O");
$_M(c$,"containsAll",
function(a){
return this.c.containsAll(a);
},"java.util.Collection");
$_V(c$,"addAll",
function(a){
var b=a.size();
if(b==0){
return false;
}var c=new Array(b);
var d=a.iterator();
for(var e=0;e<b;e++){
c[e]=java.util.Collections.checkType(d.next(),this.type);
}
var f=false;
for(var g=0;g<b;g++){
f=new Boolean(f|this.c.add(c[g])).valueOf();
}
return f;
},"java.util.Collection");
$_M(c$,"removeAll",
function(a){
return this.c.removeAll(a);
},"java.util.Collection");
$_M(c$,"retainAll",
function(a){
return this.c.retainAll(a);
},"java.util.Collection");
$_M(c$,"clear",
function(){
this.c.clear();
});
$_M(c$,"toString",
function(){
return this.c.toString();
});
c$=$_P();
$_H();
c$=$_C(function(){
this.i=null;
this.type=null;
$_Z(this,arguments);
},java.util.Collections,"CheckedListIterator",null,java.util.ListIterator);
$_K(c$,
function(a,b){
this.i=a;
this.type=b;
},"java.util.ListIterator,Class");
$_M(c$,"hasNext",
function(){
return this.i.hasNext();
});
$_M(c$,"next",
function(){
return this.i.next();
});
$_M(c$,"remove",
function(){
this.i.remove();
});
$_M(c$,"hasPrevious",
function(){
return this.i.hasPrevious();
});
$_M(c$,"previous",
function(){
return this.i.previous();
});
$_M(c$,"nextIndex",
function(){
return this.i.nextIndex();
});
$_M(c$,"previousIndex",
function(){
return this.i.previousIndex();
});
$_M(c$,"set",
function(a){
this.i.set(java.util.Collections.checkType(a,this.type));
},"~O");
$_M(c$,"add",
function(a){
this.i.add(java.util.Collections.checkType(a,this.type));
},"~O");
c$=$_P();
$_H();
c$=$_C(function(){
this.l=null;
$_Z(this,arguments);
},java.util.Collections,"CheckedList",java.util.Collections.CheckedCollection,java.util.List);
$_K(c$,
function(a,b){
$_R(this,java.util.Collections.CheckedList,[a,b]);
this.l=a;
},"java.util.List,Class");
$_M(c$,"addAll",
function(a,b){
var c=b.size();
if(c==0){
return false;
}var d=new Array(c);
var e=b.iterator();
for(var f=0;f<c;f++){
d[f]=java.util.Collections.checkType(e.next(),this.type);
}
return this.l.addAll(a,java.util.Arrays.asList(d));
},"~N,java.util.Collection");
$_M(c$,"get",
function(a){
return this.l.get(a);
},"~N");
$_M(c$,"set",
function(a,b){
return this.l.set(a,java.util.Collections.checkType(b,this.type));
},"~N,~O");
$_M(c$,"add",
function(a,b){
this.l.add(a,java.util.Collections.checkType(b,this.type));
},"~N,~O");
$_M(c$,"remove",
function(a){
return this.l.remove(a);
},"~N");
$_M(c$,"indexOf",
function(a){
return this.l.indexOf(a);
},"~O");
$_M(c$,"lastIndexOf",
function(a){
return this.l.lastIndexOf(a);
},"~O");
$_M(c$,"listIterator",
function(){
return new java.util.Collections.CheckedListIterator(this.l.listIterator(),this.type);
});
$_M(c$,"listIterator",
function(a){
return new java.util.Collections.CheckedListIterator(this.l.listIterator(a),this.type);
},"~N");
$_M(c$,"subList",
function(a,b){
return java.util.Collections.checkedList(this.l.subList(a,b),this.type);
},"~N,~N");
$_M(c$,"equals",
function(a){
return this.l.equals(a);
},"~O");
$_M(c$,"hashCode",
function(){
return this.l.hashCode();
});
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"CheckedRandomAccessList",java.util.Collections.CheckedList,java.util.RandomAccess);
c$=$_P();
$_H();
c$=$_T(java.util.Collections,"CheckedSet",java.util.Collections.CheckedCollection,java.util.Set);
$_V(c$,"equals",
function(a){
return this.c.equals(a);
},"~O");
$_V(c$,"hashCode",
function(){
return this.c.hashCode();
});
c$=$_P();
$_H();
c$=$_C(function(){
this.m=null;
this.keyType=null;
this.valueType=null;
$_Z(this,arguments);
},java.util.Collections,"CheckedMap",null,[java.util.Map,java.io.Serializable]);
$_K(c$,
($fz=function(a,b,c){
if(a==null||b==null||c==null){
throw new NullPointerException();
}this.m=a;
this.keyType=b;
this.valueType=c;
},$fz.isPrivate=true,$fz),"java.util.Map,Class,Class");
$_M(c$,"size",
function(){
return this.m.size();
});
$_M(c$,"isEmpty",
function(){
return this.m.isEmpty();
});
$_M(c$,"containsKey",
function(a){
return this.m.containsKey(a);
},"~O");
$_M(c$,"containsValue",
function(a){
return this.m.containsValue(a);
},"~O");
$_M(c$,"get",
function(a){
return this.m.get(a);
},"~O");
$_M(c$,"put",
function(a,b){
return this.m.put(java.util.Collections.checkType(a,this.keyType),java.util.Collections.checkType(b,this.valueType));
},"~O,~O");
$_M(c$,"remove",
function(a){
return this.m.remove(a);
},"~O");
$_V(c$,"putAll",
function(a){
var b=a.size();
if(b==0){
return;
}var c=new Array(b);
var d=a.entrySet().iterator();
for(var e=0;e<b;e++){
var f=d.next();
java.util.Collections.checkType(f.getKey(),this.keyType);
java.util.Collections.checkType(f.getValue(),this.valueType);
c[e]=f;
}
for(var f=0;f<b;f++){
this.m.put(c[f].getKey(),c[f].getValue());
}
},"java.util.Map");
$_M(c$,"clear",
function(){
this.m.clear();
});
$_M(c$,"keySet",
function(){
return this.m.keySet();
});
$_M(c$,"values",
function(){
return this.m.values();
});
$_M(c$,"entrySet",
function(){
return new java.util.Collections.CheckedMap.CheckedEntrySet(this.m.entrySet(),this.valueType);
});
$_M(c$,"equals",
function(a){
return this.m.equals(a);
},"~O");
$_M(c$,"hashCode",
function(){
return this.m.hashCode();
});
$_M(c$,"toString",
function(){
return this.m.toString();
});
$_H();
c$=$_C(function(){
this.e=null;
this.valueType=null;
$_Z(this,arguments);
},java.util.Collections.CheckedMap,"CheckedEntry",null,java.util.Map.Entry);
$_K(c$,
function(a,b){
if(a==null){
throw new NullPointerException();
}this.e=a;
this.valueType=b;
},"java.util.Map.Entry,Class");
$_M(c$,"getKey",
function(){
return this.e.getKey();
});
$_M(c$,"getValue",
function(){
return this.e.getValue();
});
$_M(c$,"setValue",
function(a){
return this.e.setValue(java.util.Collections.checkType(a,this.valueType));
},"~O");
$_M(c$,"equals",
function(a){
return this.e.equals(a);
},"~O");
$_M(c$,"hashCode",
function(){
return this.e.hashCode();
});
c$=$_P();
$_H();
c$=$_C(function(){
this.s=null;
this.valueType=null;
$_Z(this,arguments);
},java.util.Collections.CheckedMap,"CheckedEntrySet",null,java.util.Set);
$_K(c$,
function(a,b){
this.s=a;
this.valueType=b;
},"java.util.Set,Class");
$_M(c$,"iterator",
function(){
return new java.util.Collections.CheckedMap.CheckedEntrySet.CheckedEntryIterator(this.s.iterator(),this.valueType);
});
$_M(c$,"toArray",
function(){
var a=this.size();
var b=new Array(a);
var c=this.iterator();
for(var d=0;d<a;d++){
b[d]=c.next();
}
return b;
});
$_M(c$,"toArray",
function(a){
var b=this.size();
if(a.length<b){
var c=a.getClass().getComponentType();
a=java.lang.reflect.Array.newInstance(c,b);
}var c=this.iterator();
for(var d=0;d<b;d++){
a[d]=c.next();
}
if(b<a.length){
a[b]=null;
}return a;
},"~A");
$_M(c$,"retainAll",
function(a){
return this.s.retainAll(a);
},"java.util.Collection");
$_M(c$,"removeAll",
function(a){
return this.s.removeAll(a);
},"java.util.Collection");
$_M(c$,"containsAll",
function(a){
return this.s.containsAll(a);
},"java.util.Collection");
$_V(c$,"addAll",
function(a){
throw new UnsupportedOperationException();
},"java.util.Collection");
$_M(c$,"remove",
function(a){
return this.s.remove(a);
},"~O");
$_M(c$,"contains",
function(a){
return this.s.contains(a);
},"~O");
$_V(c$,"add",
function(a){
throw new UnsupportedOperationException();
},"java.util.Map.Entry");
$_M(c$,"isEmpty",
function(){
return this.s.isEmpty();
});
$_M(c$,"clear",
function(){
this.s.clear();
});
$_M(c$,"size",
function(){
return this.s.size();
});
$_M(c$,"hashCode",
function(){
return this.s.hashCode();
});
$_M(c$,"equals",
function(a){
return this.s.equals(a);
},"~O");
$_H();
c$=$_C(function(){
this.i=null;
this.valueType=null;
$_Z(this,arguments);
},java.util.Collections.CheckedMap.CheckedEntrySet,"CheckedEntryIterator",null,java.util.Iterator);
$_K(c$,
function(a,b){
this.i=a;
this.valueType=b;
},"java.util.Iterator,Class");
$_M(c$,"hasNext",
function(){
return this.i.hasNext();
});
$_M(c$,"remove",
function(){
this.i.remove();
});
$_M(c$,"next",
function(){
return new java.util.Collections.CheckedMap.CheckedEntry(this.i.next(),this.valueType);
});
c$=$_P();
c$=$_P();
c$=$_P();
$_H();
c$=$_C(function(){
this.ss=null;
$_Z(this,arguments);
},java.util.Collections,"CheckedSortedSet",java.util.Collections.CheckedSet,java.util.SortedSet);
$_K(c$,
function(a,b){
$_R(this,java.util.Collections.CheckedSortedSet,[a,b]);
this.ss=a;
},"java.util.SortedSet,Class");
$_M(c$,"comparator",
function(){
return this.ss.comparator();
});
$_M(c$,"subSet",
function(a,b){
return new java.util.Collections.CheckedSortedSet(this.ss.subSet(a,b),this.type);
},"~O,~O");
$_M(c$,"headSet",
function(a){
return new java.util.Collections.CheckedSortedSet(this.ss.headSet(a),this.type);
},"~O");
$_M(c$,"tailSet",
function(a){
return new java.util.Collections.CheckedSortedSet(this.ss.tailSet(a),this.type);
},"~O");
$_M(c$,"first",
function(){
return this.ss.first();
});
$_M(c$,"last",
function(){
return this.ss.last();
});
c$=$_P();
$_H();
c$=$_C(function(){
this.sm=null;
$_Z(this,arguments);
},java.util.Collections,"CheckedSortedMap",java.util.Collections.CheckedMap,java.util.SortedMap);
$_K(c$,
function(a,b,c){
$_R(this,java.util.Collections.CheckedSortedMap,[a,b,c]);
this.sm=a;
},"java.util.SortedMap,Class,Class");
$_M(c$,"comparator",
function(){
return this.sm.comparator();
});
$_M(c$,"subMap",
function(a,b){
return new java.util.Collections.CheckedSortedMap(this.sm.subMap(a,b),this.keyType,this.valueType);
},"~O,~O");
$_M(c$,"headMap",
function(a){
return new java.util.Collections.CheckedSortedMap(this.sm.headMap(a),this.keyType,this.valueType);
},"~O");
$_M(c$,"tailMap",
function(a){
return new java.util.Collections.CheckedSortedMap(this.sm.tailMap(a),this.keyType,this.valueType);
},"~O");
$_M(c$,"firstKey",
function(){
return this.sm.firstKey();
});
$_M(c$,"lastKey",
function(){
return this.sm.lastKey();
});
c$=$_P();
c$.EMPTY_LIST=c$.prototype.EMPTY_LIST=new java.util.Collections.EmptyList();
c$.EMPTY_SET=c$.prototype.EMPTY_SET=new java.util.Collections.EmptySet();
c$.EMPTY_MAP=c$.prototype.EMPTY_MAP=new java.util.Collections.EmptyMap();
});
// 
//// java\util\Random.js 
// 
$_L(null,"java.util.Random",["java.lang.IllegalArgumentException"],function(){
c$=$_C(function(){
this.haveNextNextGaussian=false;
this.seed=0;
this.nextNextGaussian=0;
$_Z(this,arguments);
},java.util,"Random",null,java.io.Serializable);
$_K(c$,
function(){
this.setSeed(System.currentTimeMillis());
});
$_K(c$,
function(seed){
this.setSeed(seed);
},"~N");
$_M(c$,"next",
function(bits){
this.seed=(this.seed*25214903917+0xb)&(281474976710655);
return(this.seed>>>(48-bits));
},"~N");
$_M(c$,"nextBoolean",
function(){
return Math.random()>0.5;
});
$_M(c$,"nextBytes",
function(buf){
for(var i=0;i<bytes.length;i++){
bytes[i]=Math.round(0x100*Math.random());
}
},"~A");
$_M(c$,"nextDouble",
function(){
return Math.random();
});
$_M(c$,"nextFloat",
function(){
return Math.random();
});
$_M(c$,"nextGaussian",
function(){
if(this.haveNextNextGaussian){
this.haveNextNextGaussian=false;
return this.nextNextGaussian;
}var v1;
var v2;
var s;
do{
v1=2*this.nextDouble()-1;
v2=2*this.nextDouble()-1;
s=v1*v1+v2*v2;
}while(s>=1);
var norm=Math.sqrt(-2*Math.log(s)/s);
this.nextNextGaussian=v2*norm;
this.haveNextNextGaussian=true;
return v1*norm;
});
$_M(c$,"nextInt",
function(){
return Math.ceil(0xffff*Math.random())-0x8000;
});
$_M(c$,"nextInt",
function(n){
if(n>0){
if((n&-n)==n){
return((n*this.next(31))>>31);
}var bits;
var val;
do{
bits=this.next(31);
val=bits%n;
}while(bits-val+(n-1)<0);
return val;
}throw new IllegalArgumentException();
},"~N");
$_M(c$,"nextLong",
function(){
return Math.ceil(0xffffffff*Math.random())-0x80000000;
});
$_M(c$,"setSeed",
function(seed){
this.seed=(seed^25214903917)&(281474976710655);
this.haveNextNextGaussian=false;
},"~N");
$_S(c$,
"multiplier",0x5deece66d);
});
// 
//// org\jmol\awtjs2d\JmolURLConnection.js 
// 
Clazz.declarePackage ("org.jmol.awtjs2d");
Clazz.load (["java.net.URLConnection"], "org.jmol.awtjs2d.JmolURLConnection", null, function () {
c$ = Clazz.decorateAsClass (function () {
this.bytesOut = null;
this.postOut = "";
Clazz.instantialize (this, arguments);
}, org.jmol.awtjs2d, "JmolURLConnection", java.net.URLConnection);
Clazz.defineMethod (c$, "doAjax", 
($fz = function () {
{
return Jmol._doAjax(this.url, this.postOut, this.bytesOut);
}}, $fz.isPrivate = true, $fz));
Clazz.overrideMethod (c$, "connect", 
function () {
});
Clazz.defineMethod (c$, "outputBytes", 
function (bytes) {
this.bytesOut = bytes;
}, "~A");
Clazz.defineMethod (c$, "outputString", 
function (post) {
this.postOut = post;
}, "~S");
Clazz.defineMethod (c$, "getStringXBuilder", 
function () {
return this.doAjax ();
});
});
// 
//// org\jmol\api\JmolCallbackListener.js 
// 
Clazz.declarePackage ("org.jmol.api");
Clazz.declareInterface (org.jmol.api, "JmolCallbackListener");
// 
//// org\jmol\api\JmolStatusListener.js 
// 
Clazz.declarePackage ("org.jmol.api");
Clazz.load (["org.jmol.api.JmolCallbackListener"], "org.jmol.api.JmolStatusListener", null, function () {
Clazz.declareInterface (org.jmol.api, "JmolStatusListener", org.jmol.api.JmolCallbackListener);
});
// 
//// org\jmol\api\JmolSyncInterface.js 
// 
Clazz.declarePackage ("org.jmol.api");
Clazz.declareInterface (org.jmol.api, "JmolSyncInterface");
// 
//// org\jmol\appletjs\Jmol.js 
// 
Clazz.declarePackage ("org.jmol.appletjs");
Clazz.load (["org.jmol.api.JmolStatusListener", "$.JmolSyncInterface", "java.util.Hashtable"], "org.jmol.appletjs.Jmol", ["java.lang.Boolean", "java.net.URL", "java.util.ArrayList", "org.jmol.appletjs.JmolAppletRegistry", "org.jmol.constant.EnumCallback", "org.jmol.i18n.GT", "org.jmol.util.Escape", "$.Logger", "$.Parser", "$.StringXBuilder", "$.TextFormat", "org.jmol.viewer.JmolConstants", "$.Viewer"], function () {
c$ = Clazz.decorateAsClass (function () {
this.language = null;
this.doTranslate = true;
this.haveDocumentAccess = false;
this.isStereoSlave = false;
this.loading = false;
this.mayScript = true;
this.htmlName = null;
this.fullName = null;
this.syncId = null;
this.outputBuffer = null;
this.gRight = null;
this.viewer = null;
this.b$ = null;
this.viewerOptions = null;
this.htParams = null;
this.jmol = null;
if (!Clazz.isClassDefined ("org.jmol.appletjs.Jmol.MyStatusListener")) {
org.jmol.appletjs.Jmol.$Jmol$MyStatusListener$ ();
}
Clazz.instantialize (this, arguments);
}, org.jmol.appletjs, "Jmol", null, org.jmol.api.JmolSyncInterface);
Clazz.prepareFields (c$, function () {
this.b$ =  new java.util.Hashtable ();
this.htParams =  new java.util.Hashtable ();
});
Clazz.makeConstructor (c$, 
function (viewerOptions) {
if (viewerOptions == null) viewerOptions =  new java.util.Hashtable ();
this.viewerOptions = viewerOptions;
for (var entry, $entry = viewerOptions.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) this.htParams.put (entry.getKey ().toLowerCase (), entry.getValue ());

this.init ();
}, "java.util.Map");
Clazz.defineMethod (c$, "jmolReady", 
function () {
System.out.println ("Jmol applet " + this.fullName + " ready");
this.viewer.getBooleanProperty ("__appletReady");
});
Clazz.defineMethod (c$, "destroy", 
function () {
this.gRight = null;
org.jmol.appletjs.JmolAppletRegistry.checkOut (this.fullName);
this.viewer.setModeMouse (-1);
this.viewer.getBooleanProperty ("__appletDestroyed");
this.viewer = null;
System.out.println ("Jmol applet " + this.fullName + " destroyed");
});
Clazz.defineMethod (c$, "setStereoGraphics", 
function (isStereo) {
{
}return null;
}, "~B");
Clazz.defineMethod (c$, "init", 
function () {
this.jmol = this;
this.htmlName = this.getParameter ("name");
this.syncId = this.getParameter ("syncId");
this.fullName = this.htmlName + "__" + this.syncId + "__";
System.out.println ("Jmol JavaScript applet " + this.fullName + " initializing");
this.setLogging ();
this.viewerOptions.remove ("debug");
this.viewerOptions.put ("fullName", this.fullName);
this.mayScript = true;
org.jmol.appletjs.JmolAppletRegistry.checkIn (this.fullName, this);
this.initWindows ();
this.initApplication ();
});
Clazz.defineMethod (c$, "initWindows", 
($fz = function () {
this.viewerOptions.put ("applet", Boolean.TRUE);
if (this.getParameter ("statusListener") == null) this.viewerOptions.put ("statusListener", Clazz.innerTypeInstance (org.jmol.appletjs.Jmol.MyStatusListener, this, null));
this.viewer =  new org.jmol.viewer.Viewer (this.viewerOptions);
this.mayScript = true;
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "initApplication", 
($fz = function () {
this.viewer.pushHoldRepaint ();
var emulate = this.getValueLowerCase ("emulate", "jmol");
this.setStringProperty ("defaults", emulate.equals ("chime") ? "RasMol" : "Jmol");
this.setStringProperty ("backgroundColor", this.getValue ("bgcolor", this.getValue ("boxbgcolor", "black")));
this.loading = true;
for (var item, $item = 0, $$item = org.jmol.constant.EnumCallback.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) {
this.setValue (item.name () + "Callback", null);
}
this.loading = false;
this.language = org.jmol.i18n.GT.getLanguage ();
System.out.println ("language=" + this.language);
var scriptParam = this.getValue ("script", "");
this.viewer.popHoldRepaint ();
if (scriptParam.length > 0) this.scriptProcessor (scriptParam, null, 1);
this.jmolReady ();
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "setLogging", 
($fz = function () {
var iLevel = (this.getValue ("logLevel", (this.getBooleanValue ("debug", false) ? "5" : "4"))).charCodeAt (0) - 48;
if (iLevel != 4) System.out.println ("setting logLevel=" + iLevel + " -- To change, use script \"set logLevel [0-5]\"");
org.jmol.util.Logger.setLogLevel (iLevel);
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "getParameter", 
($fz = function (paramName) {
var o = this.htParams.get (paramName.toLowerCase ());
return (o == null ? null :  String.instantialize (o.toString ()));
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "getBooleanValue", 
($fz = function (propertyName, defaultValue) {
var value = this.getValue (propertyName, defaultValue ? "true" : "");
return (value.equalsIgnoreCase ("true") || value.equalsIgnoreCase ("on") || value.equalsIgnoreCase ("yes"));
}, $fz.isPrivate = true, $fz), "~S,~B");
Clazz.defineMethod (c$, "getValue", 
($fz = function (propertyName, defaultValue) {
var stringValue = this.getParameter (propertyName);
System.out.println ("getValue " + propertyName + " = " + stringValue);
if (stringValue != null) return stringValue;
return defaultValue;
}, $fz.isPrivate = true, $fz), "~S,~S");
Clazz.defineMethod (c$, "getValueLowerCase", 
($fz = function (paramName, defaultValue) {
var value = this.getValue (paramName, defaultValue);
if (value != null) {
value = value.trim ().toLowerCase ();
if (value.length == 0) value = null;
}return value;
}, $fz.isPrivate = true, $fz), "~S,~S");
Clazz.defineMethod (c$, "setValue", 
($fz = function (name, defaultValue) {
this.setStringProperty (name, this.getValue (name, defaultValue));
}, $fz.isPrivate = true, $fz), "~S,~S");
Clazz.defineMethod (c$, "setStringProperty", 
($fz = function (name, value) {
if (value == null) return;
org.jmol.util.Logger.info (name + " = \"" + value + "\"");
this.viewer.setStringProperty (name, value);
}, $fz.isPrivate = true, $fz), "~S,~S");
Clazz.defineMethod (c$, "sendJsTextStatus", 
function (message) {
System.out.println (message);
}, "~S");
Clazz.defineMethod (c$, "sendJsTextareaStatus", 
function (message) {
System.out.println (message);
}, "~S");
Clazz.defineMethod (c$, "handleEvent", 
function (e) {
if (this.viewer == null) return false;
return this.viewer.handleOldJvm10Event (e.id, e.x, e.y, e.modifiers, e.when);
}, "java.awt.Event");
Clazz.defineMethod (c$, "scriptProcessor", 
($fz = function (script, statusParams, processType) {
if (script == null || script.length == 0) return "";
switch (processType) {
case 0:
var err = this.viewer.scriptCheck (script);
return (Clazz.instanceOf (err, String) ? err : "");
case 1:
if (statusParams != null) return this.viewer.scriptWaitStatus (script, statusParams).toString ();
return this.viewer.scriptWait (script);
case 2:
default:
return this.viewer.script (script);
}
}, $fz.isPrivate = true, $fz), "~S,~S,~N");
Clazz.defineMethod (c$, "script", 
function (script) {
this.scriptNoWait (script);
}, "~S");
Clazz.defineMethod (c$, "scriptNoWait", 
function (script) {
if (script == null || script.length == 0) return "";
return this.scriptProcessor (script, null, 2);
}, "~S");
Clazz.defineMethod (c$, "scriptCheck", 
function (script) {
if (script == null || script.length == 0) return "";
return this.scriptProcessor (script, null, 0);
}, "~S");
Clazz.defineMethod (c$, "scriptWait", 
function (script) {
return this.scriptWait (script, null);
}, "~S");
Clazz.defineMethod (c$, "scriptWait", 
function (script, statusParams) {
if (script == null || script.length == 0) return "";
this.outputBuffer = null;
return this.scriptProcessor (script, statusParams, 1);
}, "~S,~S");
Clazz.defineMethod (c$, "scriptWaitOutput", 
function (script) {
if (script == null || script.length == 0) return "";
this.outputBuffer =  new org.jmol.util.StringXBuilder ();
this.viewer.scriptWaitStatus (script, "");
var str = (this.outputBuffer == null ? "" : this.outputBuffer.toString ());
this.outputBuffer = null;
return str;
}, "~S");
Clazz.defineMethod (c$, "syncScript", 
function (script) {
this.viewer.syncScript (script, "~", 0);
}, "~S");
Clazz.defineMethod (c$, "getAppletInfo", 
function () {
return org.jmol.i18n.GT._ ("Jmol Applet version {0} {1}.\n\nAn OpenScience project.\n\nSee http://www.jmol.org for more information", [org.jmol.viewer.JmolConstants.version, org.jmol.viewer.JmolConstants.date]) + "\nhtmlName = " + org.jmol.util.Escape.escapeStr (this.htmlName) + "\nsyncId = " + org.jmol.util.Escape.escapeStr (this.syncId) + "\ndocumentBase = " + org.jmol.util.Escape.escapeStr ("" + this.getProperty ("documentBase")) + "\ncodeBase = " + org.jmol.util.Escape.escapeStr ("" + this.getProperty ("codeBase"));
});
Clazz.defineMethod (c$, "getProperty", 
function (infoType) {
return this.viewer.getProperty (null, infoType, "");
}, "~S");
Clazz.defineMethod (c$, "getProperty", 
function (infoType, paramInfo) {
return this.viewer.getProperty (null, infoType, paramInfo);
}, "~S,~S");
Clazz.defineMethod (c$, "getPropertyAsString", 
function (infoType) {
return this.viewer.getProperty ("readable", infoType, "").toString ();
}, "~S");
Clazz.defineMethod (c$, "getPropertyAsString", 
function (infoType, paramInfo) {
return this.viewer.getProperty ("readable", infoType, paramInfo).toString ();
}, "~S,~S");
Clazz.defineMethod (c$, "getPropertyAsJSON", 
function (infoType) {
return this.viewer.getProperty ("JSON", infoType, "").toString ();
}, "~S");
Clazz.defineMethod (c$, "getPropertyAsJSON", 
function (infoType, paramInfo) {
return this.viewer.getProperty ("JSON", infoType, paramInfo).toString ();
}, "~S,~S");
Clazz.defineMethod (c$, "loadInlineString", 
function (strModel, script, isAppend) {
var errMsg = this.viewer.loadInline (strModel, isAppend);
if (errMsg == null) this.script (script);
return errMsg;
}, "~S,~S,~B");
Clazz.defineMethod (c$, "loadInlineArray", 
function (strModels, script, isAppend) {
if (strModels == null || strModels.length == 0) return null;
var errMsg = this.viewer.loadInline (strModels, isAppend);
if (errMsg == null) this.script (script);
return errMsg;
}, "~A,~S,~B");
c$.sendCallback = Clazz.defineMethod (c$, "sendCallback", 
function (strInfo, callback, data) {
if (callback == null || callback.length == 0) {
} else if (callback.equals ("alert")) {
{
alert(strInfo);
return "";
}} else {
var tokens = org.jmol.util.TextFormat.split (callback, '.');
{
try{
var o = window[tokens[0]]
for (i = 1; i < tokens.length; i++){
o = o[tokens[i]]
}
return o(data[0],data[1],data[2],data[3],data[4],data[5],data[6],data[7]);
} catch (e) {
System.out.println(callback + " failed " + e);
}
}}return "";
}, "~S,~S,~A");
Clazz.overrideMethod (c$, "register", 
function (id, jsi) {
org.jmol.appletjs.JmolAppletRegistry.checkIn (id, jsi);
}, "~S,org.jmol.api.JmolSyncInterface");
c$.$Jmol$MyStatusListener$ = function () {
Clazz.pu$h ();
c$ = Clazz.decorateAsClass (function () {
Clazz.prepareCallback (this, arguments);
this.haveNotifiedError = false;
Clazz.instantialize (this, arguments);
}, org.jmol.appletjs.Jmol, "MyStatusListener", null, org.jmol.api.JmolStatusListener);
Clazz.overrideMethod (c$, "getRegistryInfo", 
function () {
org.jmol.appletjs.JmolAppletRegistry.checkIn (null, null);
return org.jmol.appletjs.JmolAppletRegistry.htRegistry;
});
Clazz.overrideMethod (c$, "resizeInnerPanel", 
function (a) {
}, "~S");
Clazz.overrideMethod (c$, "notifyEnabled", 
function (a) {
switch (a) {
case org.jmol.constant.EnumCallback.ANIMFRAME:
case org.jmol.constant.EnumCallback.ECHO:
case org.jmol.constant.EnumCallback.ERROR:
case org.jmol.constant.EnumCallback.EVAL:
case org.jmol.constant.EnumCallback.LOADSTRUCT:
case org.jmol.constant.EnumCallback.MEASURE:
case org.jmol.constant.EnumCallback.MESSAGE:
case org.jmol.constant.EnumCallback.PICK:
case org.jmol.constant.EnumCallback.SYNC:
case org.jmol.constant.EnumCallback.SCRIPT:
return true;
case org.jmol.constant.EnumCallback.APPLETREADY:
case org.jmol.constant.EnumCallback.ATOMMOVED:
case org.jmol.constant.EnumCallback.CLICK:
case org.jmol.constant.EnumCallback.HOVER:
case org.jmol.constant.EnumCallback.MINIMIZATION:
case org.jmol.constant.EnumCallback.RESIZE:
break;
}
return (this.b$["org.jmol.appletjs.Jmol"].b$.get (a) != null);
}, "org.jmol.constant.EnumCallback");
Clazz.defineMethod (c$, "notifyCallback", 
function (a, b) {
var c = this.b$["org.jmol.appletjs.Jmol"].b$.get (a);
var d = (c != null && (b == null || b[0] == null));
var e = false;
if (b != null) b[0] = this.b$["org.jmol.appletjs.Jmol"].htmlName;
var f = (b == null || b[1] == null ? null : b[1].toString ());
switch (a) {
case org.jmol.constant.EnumCallback.APPLETREADY:
b[3] = this.b$["org.jmol.appletjs.Jmol"].jmol;
break;
case org.jmol.constant.EnumCallback.ERROR:
case org.jmol.constant.EnumCallback.EVAL:
case org.jmol.constant.EnumCallback.HOVER:
case org.jmol.constant.EnumCallback.MINIMIZATION:
case org.jmol.constant.EnumCallback.RESIZE:
break;
case org.jmol.constant.EnumCallback.CLICK:
if ("alert".equals (c)) f = "x=" + b[1] + " y=" + b[2] + " action=" + b[3] + " clickCount=" + b[4];
break;
case org.jmol.constant.EnumCallback.ANIMFRAME:
var g = b[1];
var h = g[0];
var i = g[1];
var j = g[2];
var k = g[3];
var l = g[4];
var m = (h <= -2);
var n = (k < 0 ? -1 : 1);
var o = (l < 0 ? -1 : 1);
if (d) {
b = [this.b$["org.jmol.appletjs.Jmol"].htmlName, Integer.$valueOf (Math.max (h, -2 - h)), Integer.$valueOf (i), Integer.$valueOf (j), Integer.$valueOf (Math.abs (k)), Integer.$valueOf (Math.abs (l)), Integer.$valueOf (m ? 1 : 0), Integer.$valueOf (n), Integer.$valueOf (o)];
}break;
case org.jmol.constant.EnumCallback.ECHO:
var p = (b.length == 2);
var q = (p || (b[2]).intValue () == 1);
if (!d) {
if (q) e = true;
d = (!p && (c = this.b$["org.jmol.appletjs.Jmol"].b$.get ((a = org.jmol.constant.EnumCallback.MESSAGE))) != null);
}if (!e) this.output (f);
break;
case org.jmol.constant.EnumCallback.LOADSTRUCT:
var r = b[4];
if (r != null) {
r = (r.indexOf ("NOTE:") >= 0 ? "" : org.jmol.i18n.GT._ ("File Error:")) + r;
this.showStatus (r);
this.notifyCallback (org.jmol.constant.EnumCallback.MESSAGE, ["", r]);
return;
}break;
case org.jmol.constant.EnumCallback.MEASURE:
if (!d) d = ((c = this.b$["org.jmol.appletjs.Jmol"].b$.get ((a = org.jmol.constant.EnumCallback.MESSAGE))) != null);
var s = b[3];
if (s.indexOf ("Picked") >= 0 || s.indexOf ("Sequence") >= 0) {
this.showStatus (f);
e = true;
} else if (s.indexOf ("Completed") >= 0) {
f = s + ": " + f;
e = true;
}break;
case org.jmol.constant.EnumCallback.MESSAGE:
e = !d;
d = new Boolean (d & (f != null)).valueOf ();
if (!e) this.output (f);
break;
case org.jmol.constant.EnumCallback.PICK:
this.showStatus (f);
e = true;
break;
case org.jmol.constant.EnumCallback.SCRIPT:
var t = (b[3]).intValue ();
if (t > 0) {
this.notifyScriptTermination ();
} else if (!d) {
d = ((c = this.b$["org.jmol.appletjs.Jmol"].b$.get ((a = org.jmol.constant.EnumCallback.MESSAGE))) != null);
}this.output (f);
this.showStatus (f);
break;
case org.jmol.constant.EnumCallback.SYNC:
this.sendScript (f, b[2], true, d);
return;
}
if (e) {
var u = this.b$["org.jmol.appletjs.Jmol"].viewer.getProperty ("DATA_API", "getAppConsole", null);
if (u != null) {
u.notifyCallback (a, b);
this.output (f);
this.b$["org.jmol.appletjs.Jmol"].sendJsTextareaStatus (f);
}}if (!d || !this.b$["org.jmol.appletjs.Jmol"].mayScript) return;
try {
org.jmol.appletjs.Jmol.sendCallback (f, c, b);
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
if (!this.haveNotifiedError) if (org.jmol.util.Logger.debugging) {
org.jmol.util.Logger.debug (a.name () + "Callback call error to " + c + ": " + e);
}this.haveNotifiedError = true;
} else {
throw e;
}
}
}, "org.jmol.constant.EnumCallback,~A");
Clazz.defineMethod (c$, "output", 
($fz = function (a) {
if (this.b$["org.jmol.appletjs.Jmol"].outputBuffer != null && a != null) this.b$["org.jmol.appletjs.Jmol"].outputBuffer.append (a).appendC ('\n');
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "notifyScriptTermination", 
($fz = function () {
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "notifySync", 
($fz = function (a, b) {
var c = this.b$["org.jmol.appletjs.Jmol"].b$.get (org.jmol.constant.EnumCallback.SYNC);
if (!this.b$["org.jmol.appletjs.Jmol"].mayScript || c == null) return a;
try {
{
return eval(syncCallback)(this.htmlName, info, appletName);
}} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
if (!this.haveNotifiedError) if (org.jmol.util.Logger.debugging) {
org.jmol.util.Logger.debug ("syncCallback call error to " + c + ": " + e);
}this.haveNotifiedError = true;
} else {
throw e;
}
}
return a;
}, $fz.isPrivate = true, $fz), "~S,~S");
Clazz.overrideMethod (c$, "setCallbackFunction", 
function (a, b) {
if (a.equalsIgnoreCase ("modelkit")) return;
if (a.equalsIgnoreCase ("language")) {
this.consoleMessage ("");
this.consoleMessage (null);
return;
}var c = org.jmol.constant.EnumCallback.getCallback (a);
if (c != null && (this.b$["org.jmol.appletjs.Jmol"].loading || c !== org.jmol.constant.EnumCallback.EVAL)) {
if (b == null) this.b$["org.jmol.appletjs.Jmol"].b$.remove (c);
 else this.b$["org.jmol.appletjs.Jmol"].b$.put (c, b);
return;
}this.consoleMessage ("Available callbacks include: " + org.jmol.constant.EnumCallback.getNameList ().$replace (';', ' ').trim ());
}, "~S,~S");
Clazz.overrideMethod (c$, "eval", 
function (a) {
var b = a.indexOf ("\1");
if (b >= 0) return this.sendScript (a.substring (b + 1), a.substring (0, b), false, false);
if (this.b$["org.jmol.appletjs.Jmol"].b$.get (org.jmol.constant.EnumCallback.EVAL) != null) {
this.notifyCallback (org.jmol.constant.EnumCallback.EVAL, [null, a]);
return "";
}try {
{
return "" + eval(a);// strEval -- Java2Script is compressing this file for some reason
}} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
org.jmol.util.Logger.error ("# error evaluating " + a + ":" + e.toString ());
} else {
throw e;
}
}
return "";
}, "~S");
Clazz.overrideMethod (c$, "createImage", 
function (a, b, c, d) {
return null;
}, "~S,~S,~O,~N");
Clazz.overrideMethod (c$, "functionXY", 
function (a, b, c) {
var d =  Clazz.newFloatArray (Math.abs (b), Math.abs (c), 0);
if (!this.b$["org.jmol.appletjs.Jmol"].mayScript || b == 0 || c == 0) return d;
try {
if (b > 0 && c > 0) {
for (var e = 0; e < b; e++) for (var f = 0; f < c; f++) {
{
fxy[i][j] = eval(functionName)(this.htmlName, i, j);
}}

} else if (c > 0) {
var e;
{
data = eval(functionName)(this.htmlName, nX, nY);
}b = Math.abs (b);
var f =  Clazz.newFloatArray (b * c, 0);
org.jmol.util.Parser.parseStringInfestedFloatArray (e, null, f);
for (var g = 0, h = 0; g < b; g++) {
for (var i = 0; i < c; i++, h++) {
d[g][i] = f[h];
}
}
} else {
{
data = eval(functionName)(htmlName, nX, nY, fxy);
}}} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
org.jmol.util.Logger.error ("Exception " + e.getMessage () + " with nX, nY: " + b + " " + c);
} else {
throw e;
}
}
return d;
}, "~S,~N,~N");
Clazz.overrideMethod (c$, "functionXYZ", 
function (a, b, c, d) {
var e =  Clazz.newFloatArray (Math.abs (b), Math.abs (c), Math.abs (d), 0);
if (!this.b$["org.jmol.appletjs.Jmol"].mayScript || b == 0 || c == 0 || d == 0) return e;
try {
{
eval(functionName)(this.htmlName, nX, nY, nZ, fxyz);
}} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
org.jmol.util.Logger.error ("Exception " + e.getMessage () + " for " + a + " with nX, nY, nZ: " + b + " " + c + " " + d);
} else {
throw e;
}
}
return e;
}, "~S,~N,~N,~N");
Clazz.overrideMethod (c$, "showUrl", 
function (a) {
if (org.jmol.util.Logger.debugging) {
org.jmol.util.Logger.debug ("showUrl(" + a + ")");
}if (a != null && a.length > 0) {
try {
var b =  new java.net.URL (Clazz.castNullAs ("java.net.URL"), a, null);
{
window.open(url);
}} catch (mue) {
if (Clazz.exceptionOf (mue, java.net.MalformedURLException)) {
this.consoleMessage ("Malformed URL:" + a);
} else {
throw mue;
}
}
}}, "~S");
Clazz.defineMethod (c$, "finalize", 
function () {
org.jmol.util.Logger.debug ("MyStatusListener finalize " + this);
Clazz.superCall (this, org.jmol.appletjs.Jmol.MyStatusListener, "finalize", []);
});
Clazz.defineMethod (c$, "showStatus", 
($fz = function (a) {
try {
System.out.println (a);
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "consoleMessage", 
($fz = function (a) {
this.notifyCallback (org.jmol.constant.EnumCallback.ECHO, ["", a]);
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "sendScript", 
($fz = function (a, b, c, d) {
if (d) {
a = this.notifySync (a, b);
if (a == null || a.length == 0 || a.equals ("0")) return "";
}var e =  new java.util.ArrayList ();
org.jmol.appletjs.JmolAppletRegistry.findApplets (b, this.b$["org.jmol.appletjs.Jmol"].syncId, this.b$["org.jmol.appletjs.Jmol"].fullName, e);
var f = e.size ();
if (f == 0) {
if (!d && !b.equals ("*")) org.jmol.util.Logger.error (this.b$["org.jmol.appletjs.Jmol"].fullName + " couldn't find applet " + b);
return "";
}var g = (c ? null :  new org.jmol.util.StringXBuilder ());
var h = (c && a.equals ("GET_GRAPHICS"));
var i = (c && a.equals ("SET_GRAPHICS_OFF"));
if (h) this.b$["org.jmol.appletjs.Jmol"].gRight = null;
for (var j = 0; j < f; j++) {
var k = e.get (j);
var l = org.jmol.appletjs.JmolAppletRegistry.htRegistry.get (k);
var m = (Clazz.instanceOf (l, org.jmol.api.JmolScriptInterface));
if (org.jmol.util.Logger.debugging) org.jmol.util.Logger.debug (this.b$["org.jmol.appletjs.Jmol"].fullName + " sending to " + k + ": " + a);
try {
if (m && (h || i)) {
this.b$["org.jmol.appletjs.Jmol"].gRight = (l).setStereoGraphics (h);
return "";
}if (c) l.syncScript (a);
 else if (m) g.append ((l).scriptWait (a, "output")).append ("\n");
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
var n = this.b$["org.jmol.appletjs.Jmol"].htmlName + " couldn't send to " + k + ": " + a + ": " + e;
org.jmol.util.Logger.error (n);
if (!c) g.append (n);
} else {
throw e;
}
}
}
return (c ? "" : g.toString ());
}, $fz.isPrivate = true, $fz), "~S,~S,~B,~B");
Clazz.overrideMethod (c$, "getProperty", 
function (a) {
return null;
}, "~S");
c$ = Clazz.p0p ();
};
Clazz.defineStatics (c$,
"SCRIPT_CHECK", 0,
"SCRIPT_WAIT", 1,
"SCRIPT_NOWAIT", 2);
});
// 
//// org\jmol\appletjs\JmolAppletRegistry.js 
// 
Clazz.declarePackage ("org.jmol.appletjs");
Clazz.load (["java.util.Hashtable"], "org.jmol.appletjs.JmolAppletRegistry", ["org.jmol.util.Logger", "$.TextFormat"], function () {
c$ = Clazz.declareType (org.jmol.appletjs, "JmolAppletRegistry");
c$.checkIn = Clazz.defineMethod (c$, "checkIn", 
function (name, applet) {
org.jmol.appletjs.JmolAppletRegistry.cleanRegistry ();
if (name != null) {
org.jmol.util.Logger.info ("AppletRegistry.checkIn(" + name + ")");
org.jmol.appletjs.JmolAppletRegistry.htRegistry.put (name, applet);
}if (org.jmol.util.Logger.debugging) {
for (var entry, $entry = org.jmol.appletjs.JmolAppletRegistry.htRegistry.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var theApplet = entry.getKey ();
org.jmol.util.Logger.debug (theApplet + " " + entry.getValue ());
}
}}, "~S,org.jmol.api.JmolSyncInterface");
c$.checkOut = Clazz.defineMethod (c$, "checkOut", 
function (name) {
org.jmol.appletjs.JmolAppletRegistry.htRegistry.remove (name);
}, "~S");
c$.findApplets = Clazz.defineMethod (c$, "findApplets", 
function (appletName, mySyncId, excludeName, apps) {
if (appletName != null && appletName.indexOf (",") >= 0) {
var names = org.jmol.util.TextFormat.split (appletName, ',');
for (var i = 0; i < names.length; i++) org.jmol.appletjs.JmolAppletRegistry.findApplets (names[i], mySyncId, excludeName, apps);

return;
}var ext = "__" + mySyncId + "__";
if (appletName == null || appletName.equals ("*") || appletName.equals (">")) {
for (var appletName2, $appletName2 = org.jmol.appletjs.JmolAppletRegistry.htRegistry.keySet ().iterator (); $appletName2.hasNext () && ((appletName2 = $appletName2.next ()) || true);) {
if (!appletName2.equals (excludeName) && appletName2.indexOf (ext) > 0) {
apps.add (appletName2);
}}
return;
}if (appletName.indexOf ("__") < 0) appletName += ext;
if (!org.jmol.appletjs.JmolAppletRegistry.htRegistry.containsKey (appletName)) appletName = "jmolApplet" + appletName;
if (!appletName.equals (excludeName) && org.jmol.appletjs.JmolAppletRegistry.htRegistry.containsKey (appletName)) {
apps.add (appletName);
}}, "~S,~S,~S,java.util.List");
c$.cleanRegistry = Clazz.defineMethod (c$, "cleanRegistry", 
($fz = function () {
}, $fz.isPrivate = true, $fz));
c$.htRegistry = c$.prototype.htRegistry =  new java.util.Hashtable ();
});
// 
//// java\lang\Enum.js 
// 
$_L(null,"java.lang.Enum",["java.lang.CloneNotSupportedException","$.IllegalArgumentException","$.NullPointerException","java.security.AccessController","$.PrivilegedExceptionAction",null],function(){
c$=$_C(function(){
this.$name=null;
this.$ordinal=0;
$_Z(this,arguments);
},java.lang,"Enum",null,[java.io.Serializable,Comparable]);
$_K(c$,
function(name,ordinal){
this.$name=name;
this.$ordinal=ordinal;
},"~S,~N");
$_M(c$,"name",
function(){
return this.$name;
});
$_M(c$,"ordinal",
function(){
return this.$ordinal;
});
$_V(c$,"toString",
function(){
return this.$name;
});
$_V(c$,"equals",
function(other){
return this===other;
},"~O");
$_V(c$,"hashCode",
function(){
return this.$ordinal+(this.$name==null?0:this.$name.hashCode());
});
$_V(c$,"clone",
function(){
throw new CloneNotSupportedException(("KA004"));
});
$_V(c$,"compareTo",
function(o){
return this.$ordinal-o.$ordinal;
},"~O");
$_M(c$,"getDeclaringClass",
function(){
var myClass=this.getClass();
var mySuperClass=myClass.getSuperclass();
if(Enum===mySuperClass){
return myClass;
}return mySuperClass;
});
c$.$valueOf=$_M(c$,"$valueOf",
function(enumType,name){
if((enumType==null)||(name==null)){
throw new NullPointerException(("KA001"));
}var values=Enum.getValues(enumType);
if(values==null){
throw new IllegalArgumentException(("KA005"));
}for(var enumConst,$enumConst=0,$$enumConst=values;$enumConst<$$enumConst.length&&((enumConst=$$enumConst[$enumConst])||true);$enumConst++){
if(enumConst.$name.equals(name)){
return enumConst;
}}
throw new IllegalArgumentException(("KA006"));
},"Class,~S");
c$.getValues=$_M(c$,"getValues",
function(enumType){
try{
var values=java.security.AccessController.doPrivileged((($_D("Enum$1")?0:java.lang.Enum.$Enum$1$()),$_N(Enum$1,this,$_F("enumType",enumType))));
return values.invoke(enumType,Clazz.castNullAs("Array"));
}catch(e){
if($_O(e,Exception)){
return null;
}else{
throw e;
}
}
},"Class");
c$.$Enum$1$=function(){
$_H();
c$=$_W(null,"Enum$1",null,java.security.PrivilegedExceptionAction);
$_V(c$,"run",
function(){
var valsMethod=this.f$.enumType.getMethod("values",null);
valsMethod.setAccessible(true);
return valsMethod;
});
c$=$_P();
};
});
// 
//// org\jmol\constant\EnumCallback.js 
// 
Clazz.declarePackage ("org.jmol.constant");
Clazz.load (["java.lang.Enum"], "org.jmol.constant.EnumCallback", ["org.jmol.util.StringXBuilder"], function () {
c$ = Clazz.declareType (org.jmol.constant, "EnumCallback", Enum);
c$.getCallback = Clazz.defineMethod (c$, "getCallback", 
function (name) {
name = name.toUpperCase ();
name = name.substring (0, Math.max (name.indexOf ("CALLBACK"), 0));
for (var item, $item = 0, $$item = org.jmol.constant.EnumCallback.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (item.name ().equalsIgnoreCase (name)) return item;

return null;
}, "~S");
c$.getNameList = Clazz.defineMethod (c$, "getNameList", 
function () {
if (org.jmol.constant.EnumCallback.nameList == null) {
var names =  new org.jmol.util.StringXBuilder ();
for (var item, $item = 0, $$item = org.jmol.constant.EnumCallback.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) names.append (item.name ().toLowerCase ()).append ("Callback;");

($t$ = org.jmol.constant.EnumCallback.nameList = names.toString (), org.jmol.constant.EnumCallback.prototype.nameList = org.jmol.constant.EnumCallback.nameList, $t$);
}return org.jmol.constant.EnumCallback.nameList;
});
c$.nameList = null;
Clazz.defineEnumConstant (c$, "ANIMFRAME", 0, []);
Clazz.defineEnumConstant (c$, "APPLETREADY", 1, []);
Clazz.defineEnumConstant (c$, "ATOMMOVED", 2, []);
Clazz.defineEnumConstant (c$, "CLICK", 3, []);
Clazz.defineEnumConstant (c$, "ECHO", 4, []);
Clazz.defineEnumConstant (c$, "ERROR", 5, []);
Clazz.defineEnumConstant (c$, "EVAL", 6, []);
Clazz.defineEnumConstant (c$, "HOVER", 7, []);
Clazz.defineEnumConstant (c$, "LOADSTRUCT", 8, []);
Clazz.defineEnumConstant (c$, "MEASURE", 9, []);
Clazz.defineEnumConstant (c$, "MESSAGE", 10, []);
Clazz.defineEnumConstant (c$, "MINIMIZATION", 11, []);
Clazz.defineEnumConstant (c$, "PICK", 12, []);
Clazz.defineEnumConstant (c$, "RESIZE", 13, []);
Clazz.defineEnumConstant (c$, "SCRIPT", 14, []);
Clazz.defineEnumConstant (c$, "SYNC", 15, []);
});
// 
//// org\jmol\i18n\GT.js 
// 
Clazz.declarePackage ("org.jmol.i18n");
Clazz.load (null, "org.jmol.i18n.GT", ["java.text.MessageFormat"], function () {
c$ = Clazz.declareType (org.jmol.i18n, "GT");
Clazz.makeConstructor (c$, 
function (la) {
}, "~S");
c$.getLanguage = Clazz.defineMethod (c$, "getLanguage", 
function () {
return "en_US";
});
c$.ignoreApplicationBundle = Clazz.defineMethod (c$, "ignoreApplicationBundle", 
function () {
});
c$.setDoTranslate = Clazz.defineMethod (c$, "setDoTranslate", 
function (TF) {
}, "~B");
c$.getDoTranslate = Clazz.defineMethod (c$, "getDoTranslate", 
function () {
return false;
});
c$._ = Clazz.defineMethod (c$, "_", 
function (string) {
return string;
}, "~S");
c$._ = Clazz.defineMethod (c$, "_", 
function (string, item) {
return org.jmol.i18n.GT.getString (string, [item]);
}, "~S,~S");
c$._ = Clazz.defineMethod (c$, "_", 
function (string, item) {
return org.jmol.i18n.GT.getString (string, [Integer.$valueOf (item)]);
}, "~S,~N");
c$._ = Clazz.defineMethod (c$, "_", 
function (string, objects) {
return org.jmol.i18n.GT.getString (string, objects);
}, "~S,~A");
c$._ = Clazz.defineMethod (c$, "_", 
function (string, t) {
return string;
}, "~S,~B");
c$._ = Clazz.defineMethod (c$, "_", 
function (string, item, t) {
return org.jmol.i18n.GT.getString (string, [item]);
}, "~S,~S,~B");
c$._ = Clazz.defineMethod (c$, "_", 
function (string, item, t) {
return org.jmol.i18n.GT.getString (string, [Integer.$valueOf (item)]);
}, "~S,~N,~B");
c$._ = Clazz.defineMethod (c$, "_", 
function (string, objects, t) {
return (objects == null ? string : org.jmol.i18n.GT.getString (string, objects));
}, "~S,~A,~B");
c$.getString = Clazz.defineMethod (c$, "getString", 
($fz = function (string, objects) {
return java.text.MessageFormat.format (string, objects);
}, $fz.isPrivate = true, $fz), "~S,~A");
});
// 
//// org\jmol\util\Escape.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Escape", ["java.lang.Character", "$.Float", "java.util.ArrayList", "org.jmol.script.ScriptVariable", "org.jmol.util.BitSetUtil", "$.Matrix3f", "$.Matrix4f", "$.Parser", "$.Point3f", "$.Point4f", "$.StringXBuilder", "$.TextFormat"], function () {
c$ = Clazz.declareType (org.jmol.util, "Escape");
c$.escapeColor = Clazz.defineMethod (c$, "escapeColor", 
function (argb) {
return "[x" + org.jmol.util.Escape.getHexColorFromRGB (argb) + "]";
}, "~N");
c$.getHexColorFromRGB = Clazz.defineMethod (c$, "getHexColorFromRGB", 
function (argb) {
if (argb == 0) return null;
var r = "00" + Integer.toHexString ((argb >> 16) & 0xFF);
r = r.substring (r.length - 2);
var g = "00" + Integer.toHexString ((argb >> 8) & 0xFF);
g = g.substring (g.length - 2);
var b = "00" + Integer.toHexString (argb & 0xFF);
b = b.substring (b.length - 2);
return r + g + b;
}, "~N");
c$.escapePt = Clazz.defineMethod (c$, "escapePt", 
function (xyz) {
if (xyz == null) return "null";
return "{" + xyz.x + " " + xyz.y + " " + xyz.z + "}";
}, "org.jmol.util.Tuple3f");
c$.matrixToScript = Clazz.defineMethod (c$, "matrixToScript", 
function (m) {
return org.jmol.util.TextFormat.replaceAllCharacters (m.toString (), "\n\r ", "").$replace ('\t', ' ');
}, "~O");
c$.escape = Clazz.defineMethod (c$, "escape", 
function (x) {
if (Clazz.instanceOf (x, String)) return org.jmol.util.Escape.escapeStr (x);
if (Clazz.instanceOf (x, java.util.List)) return org.jmol.util.Escape.escapeVar (x);
if (Clazz.instanceOf (x, org.jmol.util.BitSet)) return org.jmol.util.Escape.escapeBs (x, true);
if (Clazz.instanceOf (x, org.jmol.util.Matrix3f)) return org.jmol.util.TextFormat.simpleReplace ((x).toString (), "\t", ",\t");
if (Clazz.instanceOf (x, org.jmol.util.Matrix4f)) return org.jmol.util.TextFormat.simpleReplace ((x).toString (), "\t", ",\t");
if (Clazz.instanceOf (x, org.jmol.util.Tuple3f)) return org.jmol.util.Escape.escapePt (x);
if (Clazz.instanceOf (x, org.jmol.util.Point4f)) {
var xyzw = x;
return "{" + xyzw.x + " " + xyzw.y + " " + xyzw.z + " " + xyzw.w + "}";
}if (Clazz.instanceOf (x, org.jmol.util.AxisAngle4f)) {
var a = x;
return "{" + a.x + " " + a.y + " " + a.z + " " + (a.angle * 180 / 3.141592653589793) + "}";
}if (Clazz.instanceOf (x, java.util.Map)) return org.jmol.util.Escape.escapeMap (x);
if (org.jmol.util.Escape.isAS (x)) return org.jmol.util.Escape.escapeStrA (x, true);
if (org.jmol.util.Escape.isAP (x)) return org.jmol.util.Escape.escapeAP (x);
if (Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array)) return org.jmol.util.Escape.toJSON (null, x);
return (x == null ? "null" : x.toString ());
}, "~O");
c$.isAS = Clazz.defineMethod (c$, "isAS", 
function (x) {
{
return Clazz.isAS(x);
}}, "~O");
c$.isASS = Clazz.defineMethod (c$, "isASS", 
function (x) {
{
return Clazz.isASS(x);
}}, "~O");
c$.isAP = Clazz.defineMethod (c$, "isAP", 
function (x) {
{
return Clazz.isAP(x);
}}, "~O");
c$.isAF = Clazz.defineMethod (c$, "isAF", 
function (x) {
return Clazz.instanceOf (x, Array);
}, "~O");
c$.isAFloat = Clazz.defineMethod (c$, "isAFloat", 
function (x) {
return Clazz.instanceOf (x, Array);
}, "~O");
c$.isAV = Clazz.defineMethod (c$, "isAV", 
function (x) {
return Clazz.instanceOf (x, Array);
}, "~O");
c$.isAD = Clazz.defineMethod (c$, "isAD", 
function (x) {
return Clazz.instanceOf (x, Array);
}, "~O");
c$.isAB = Clazz.defineMethod (c$, "isAB", 
function (x) {
return Clazz.instanceOf (x, Array);
}, "~O");
c$.isAI = Clazz.defineMethod (c$, "isAI", 
function (x) {
return Clazz.instanceOf (x, Array);
}, "~O");
c$.isAII = Clazz.defineMethod (c$, "isAII", 
function (x) {
{
return Clazz.isAII(x);
}}, "~O");
c$.isAFF = Clazz.defineMethod (c$, "isAFF", 
function (x) {
{
return Clazz.isAFF(x);
}}, "~O");
c$.isAFFF = Clazz.defineMethod (c$, "isAFFF", 
function (x) {
{
return Clazz.isAFFF(x);
}}, "~O");
c$.escapeStr = Clazz.defineMethod (c$, "escapeStr", 
function (str) {
if (str == null) return "\"\"";
var haveEscape = false;
var i = 0;
for (; i < "\\\\\tt\rr\nn\"\"".length; i += 2) if (str.indexOf ("\\\\\tt\rr\nn\"\"".charAt (i)) >= 0) {
haveEscape = true;
break;
}
if (haveEscape) while (i < "\\\\\tt\rr\nn\"\"".length) {
var pt = -1;
var ch = "\\\\\tt\rr\nn\"\"".charAt (i++);
var ch2 = "\\\\\tt\rr\nn\"\"".charAt (i++);
var sb =  new org.jmol.util.StringXBuilder ();
var pt0 = 0;
while ((pt = str.indexOf (ch, pt + 1)) >= 0) {
sb.append (str.substring (pt0, pt)).appendC ('\\').appendC (ch2);
pt0 = pt + 1;
}
sb.append (str.substring (pt0, str.length));
str = sb.toString ();
}
for (i = str.length; --i >= 0; ) if (str.charCodeAt (i) > 0x7F) str = str.substring (0, i) + org.jmol.util.Escape.unicode (str.charAt (i)) + str.substring (i + 1);

return "\"" + str + "\"";
}, "~S");
c$.unicode = Clazz.defineMethod (c$, "unicode", 
($fz = function (c) {
var s = "0000" + Integer.toHexString (c.charCodeAt (0));
return "\\u" + s.substring (s.length - 4);
}, $fz.isPrivate = true, $fz), "~S");
c$.escapeVar = Clazz.defineMethod (c$, "escapeVar", 
function (list) {
if (list == null) return org.jmol.util.Escape.escapeStr ("");
var s =  new org.jmol.util.StringXBuilder ();
s.append ("[");
for (var i = 0; i < list.size (); i++) {
if (i > 0) s.append (", ");
s.append (org.jmol.util.Escape.escapeNice (list.get (i).asString ()));
}
s.append ("]");
return s.toString ();
}, "java.util.ArrayList");
c$.escapeMap = Clazz.defineMethod (c$, "escapeMap", 
function (ht) {
var sb =  new org.jmol.util.StringXBuilder ();
sb.append ("{ ");
var sep = "";
for (var entry, $entry = ht.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var key = entry.getKey ();
sb.append (sep).append (org.jmol.util.Escape.escapeStr (key)).appendC (':');
var val = entry.getValue ();
if (!(Clazz.instanceOf (val, org.jmol.script.ScriptVariable))) val = org.jmol.script.ScriptVariable.getVariable (val);
sb.append ((val).escape ());
sep = ",";
}
sb.append (" }");
return sb.toString ();
}, "java.util.Map");
c$.escapeFloatA = Clazz.defineMethod (c$, "escapeFloatA", 
function (f, asArray) {
if (asArray) return org.jmol.util.Escape.toJSON (null, f);
var sb =  new org.jmol.util.StringXBuilder ();
for (var i = 0; i < f.length; i++) {
if (i > 0) sb.appendC ('\n');
sb.appendF (f[i]);
}
return sb.toString ();
}, "~A,~B");
c$.escapeFloatAA = Clazz.defineMethod (c$, "escapeFloatAA", 
function (f, addSemi) {
var sb =  new org.jmol.util.StringXBuilder ();
var eol = (addSemi ? ";\n" : "\n");
for (var i = 0; i < f.length; i++) if (f[i] != null) {
if (i > 0) sb.append (eol);
for (var j = 0; j < f[i].length; j++) sb.appendF (f[i][j]).appendC ('\t');

}
return sb.toString ();
}, "~A,~B");
c$.escapeFloatAAA = Clazz.defineMethod (c$, "escapeFloatAAA", 
function (f, addSemi) {
var sb =  new org.jmol.util.StringXBuilder ();
var eol = (addSemi ? ";\n" : "\n");
if (f[0] == null || f[0][0] == null) return "0 0 0" + eol;
sb.appendI (f.length).append (" ").appendI (f[0].length).append (" ").appendI (f[0][0].length);
for (var i = 0; i < f.length; i++) if (f[i] != null) {
sb.append (eol);
for (var j = 0; j < f[i].length; j++) if (f[i][j] != null) {
sb.append (eol);
for (var k = 0; k < f[i][j].length; k++) sb.appendF (f[i][j][k]).appendC ('\t');

}
}
return sb.toString ();
}, "~A,~B");
c$.escapeStrA = Clazz.defineMethod (c$, "escapeStrA", 
function (list, nicely) {
if (list == null) return org.jmol.util.Escape.escapeStr ("");
var s =  new org.jmol.util.StringXBuilder ();
s.append ("[");
for (var i = 0; i < list.length; i++) {
if (i > 0) s.append (", ");
s.append (nicely ? org.jmol.util.Escape.escapeNice (list[i]) : org.jmol.util.Escape.escapeStr (list[i]));
}
s.append ("]");
return s.toString ();
}, "~A,~B");
c$.escapeAI = Clazz.defineMethod (c$, "escapeAI", 
function (x) {
if (x == null) return org.jmol.util.Escape.escapeStr ("");
var s =  new org.jmol.util.StringXBuilder ();
s.append ("[");
var ilist = x;
for (var i = 0; i < ilist.length; i++) {
if (i > 0) s.append (", ");
s.appendI (ilist[i]);
}
return s.append ("]").toString ();
}, "~O");
c$.escapeAF = Clazz.defineMethod (c$, "escapeAF", 
function (x) {
if (x == null) return org.jmol.util.Escape.escapeStr ("");
var s =  new org.jmol.util.StringXBuilder ();
s.append ("[");
var flist = x;
for (var i = 0; i < flist.length; i++) {
if (i > 0) s.append (", ");
s.appendF (flist[i]);
}
return s.append ("]").toString ();
}, "~O");
c$.escapeAP = Clazz.defineMethod (c$, "escapeAP", 
function (x) {
if (x == null) return org.jmol.util.Escape.escapeStr ("");
var s =  new org.jmol.util.StringXBuilder ();
s.append ("[");
var plist = x;
for (var i = 0; i < plist.length; i++) {
if (i > 0) s.append (", ");
s.append (org.jmol.util.Escape.escapePt (plist[i]));
}
return s.append ("]").toString ();
}, "~O");
c$.escapeNice = Clazz.defineMethod (c$, "escapeNice", 
($fz = function (s) {
if (s == null) return "null";
var f = org.jmol.util.Parser.parseFloatStrict (s);
return (Float.isNaN (f) ? org.jmol.util.Escape.escapeStr (s) : s);
}, $fz.isPrivate = true, $fz), "~S");
c$.unescapePointOrBitsetOrMatrixOrArray = Clazz.defineMethod (c$, "unescapePointOrBitsetOrMatrixOrArray", 
function (s) {
if (s.charAt (0) == '{') return org.jmol.util.Escape.unescapePoint (s);
if ((org.jmol.util.Escape.isStringArray (s) || s.startsWith ("[{") && s.indexOf ("[{") == s.lastIndexOf ("[{")) && s.indexOf (',') < 0 && s.indexOf ('.') < 0 && s.indexOf ('-') < 0) return org.jmol.util.Escape.unescapeBitset (s);
if (s.startsWith ("[[")) return org.jmol.util.Escape.unescapeMatrix (s);
return s;
}, "~S");
c$.isStringArray = Clazz.defineMethod (c$, "isStringArray", 
function (s) {
return s.startsWith ("({") && s.lastIndexOf ("({") == 0 && s.indexOf ("})") == s.length - 2;
}, "~S");
c$.unescapePoint = Clazz.defineMethod (c$, "unescapePoint", 
function (strPoint) {
if (strPoint == null || strPoint.length == 0) return strPoint;
var str = strPoint.$replace ('\n', ' ').trim ();
if (str.charAt (0) != '{' || str.charAt (str.length - 1) != '}') return strPoint;
var points =  Clazz.newFloatArray (5, 0);
var nPoints = 0;
str = str.substring (1, str.length - 1);
var next =  Clazz.newIntArray (1, 0);
for (; nPoints < 5; nPoints++) {
points[nPoints] = org.jmol.util.Parser.parseFloatNext (str, next);
if (Float.isNaN (points[nPoints])) {
if (next[0] >= str.length || str.charAt (next[0]) != ',') break;
next[0]++;
nPoints--;
}}
if (nPoints == 3) return org.jmol.util.Point3f.new3 (points[0], points[1], points[2]);
if (nPoints == 4) return org.jmol.util.Point4f.new4 (points[0], points[1], points[2], points[3]);
return strPoint;
}, "~S");
c$.unescapeBitset = Clazz.defineMethod (c$, "unescapeBitset", 
function (str) {
var ch;
var len;
if (str == null || (len = (str = str.trim ()).length) < 4 || str.equalsIgnoreCase ("({null})") || (ch = str.charAt (0)) != '(' && ch != '[' || str.charAt (len - 1) != (ch == '(' ? ')' : ']') || str.charAt (1) != '{' || str.indexOf ('}') != len - 2) return null;
len -= 2;
for (var i = len; --i >= 2; ) if (!Character.isDigit (ch = str.charAt (i)) && ch != ' ' && ch != '\t' && ch != ':') return null;

var lastN = len;
while (Character.isDigit (str.charAt (--lastN))) {
}
if (++lastN == len) lastN = 0;
 else try {
lastN = Integer.parseInt (str.substring (lastN, len));
} catch (e) {
if (Clazz.exceptionOf (e, NumberFormatException)) {
return null;
} else {
throw e;
}
}
var bs = org.jmol.util.BitSetUtil.newBitSet (lastN);
lastN = -1;
var iPrev = -1;
var iThis = -2;
for (var i = 2; i <= len; i++) {
switch (ch = str.charAt (i)) {
case '\t':
case ' ':
case '}':
if (iThis < 0) break;
if (iThis < lastN) return null;
lastN = iThis;
if (iPrev < 0) iPrev = iThis;
bs.setBits (iPrev, iThis + 1);
iPrev = -1;
iThis = -2;
break;
case ':':
iPrev = lastN = iThis;
iThis = -2;
break;
default:
if (Character.isDigit (ch)) {
if (iThis < 0) iThis = 0;
iThis = (iThis << 3) + (iThis << 1) + (ch.charCodeAt (0) - 48);
}}
}
return (iPrev >= 0 ? null : bs);
}, "~S");
c$.unescapeMatrix = Clazz.defineMethod (c$, "unescapeMatrix", 
function (strMatrix) {
if (strMatrix == null || strMatrix.length == 0) return strMatrix;
var str = strMatrix.$replace ('\n', ' ').trim ();
if (str.lastIndexOf ("[[") != 0 || str.indexOf ("]]") != str.length - 2) return strMatrix;
var points =  Clazz.newFloatArray (16, 0);
str = str.substring (2, str.length - 2).$replace ('[', ' ').$replace (']', ' ').$replace (',', ' ');
var next =  Clazz.newIntArray (1, 0);
var nPoints = 0;
for (; nPoints < 16; nPoints++) {
points[nPoints] = org.jmol.util.Parser.parseFloatNext (str, next);
if (Float.isNaN (points[nPoints])) {
break;
}}
if (!Float.isNaN (org.jmol.util.Parser.parseFloatNext (str, next))) return strMatrix;
if (nPoints == 9) return org.jmol.util.Matrix3f.newA (points);
if (nPoints == 16) return org.jmol.util.Matrix4f.newA (points);
return strMatrix;
}, "~S");
c$.escapeBs = Clazz.defineMethod (c$, "escapeBs", 
function (bs, isAtoms) {
var chOpen = (isAtoms ? '(' : '[');
var chClose = (isAtoms ? ')' : ']');
if (bs == null) return chOpen + "{}" + chClose;
var s =  new org.jmol.util.StringXBuilder ();
s.append (chOpen + "{");
var imax = bs.length ();
var iLast = -1;
var iFirst = -2;
var i = -1;
while (++i <= imax) {
var isSet = bs.get (i);
if (i == imax || iLast >= 0 && !isSet) {
if (iLast >= 0 && iFirst != iLast) s.append ((iFirst == iLast - 1 ? " " : ":") + iLast);
if (i == imax) break;
iLast = -1;
}if (bs.get (i)) {
if (iLast < 0) {
s.append ((iFirst == -2 ? "" : " ") + i);
iFirst = i;
}iLast = i;
}}
s.append ("}").appendC (chClose);
return s.toString ();
}, "org.jmol.util.BitSet,~B");
c$.packageJSONSb = Clazz.defineMethod (c$, "packageJSONSb", 
($fz = function (infoType, sb) {
return org.jmol.util.Escape.packageJSON (infoType, sb.toString ());
}, $fz.isPrivate = true, $fz), "~S,org.jmol.util.StringXBuilder");
c$.packageJSON = Clazz.defineMethod (c$, "packageJSON", 
($fz = function (infoType, info) {
if (infoType == null) return info;
return "\"" + infoType + "\": " + info;
}, $fz.isPrivate = true, $fz), "~S,~S");
c$.fixString = Clazz.defineMethod (c$, "fixString", 
($fz = function (s) {
if (s == null || s.indexOf ("{\"") == 0) return s;
s = org.jmol.util.TextFormat.simpleReplace (s, "\"", "''");
s = org.jmol.util.TextFormat.simpleReplace (s, "\n", " | ");
return "\"" + s + "\"";
}, $fz.isPrivate = true, $fz), "~S");
c$.toJSON = Clazz.defineMethod (c$, "toJSON", 
function (infoType, info) {
var sb =  new org.jmol.util.StringXBuilder ();
var sep = "";
if (info == null) return org.jmol.util.Escape.packageJSON (infoType, Clazz.castNullAs ("String"));
if (Clazz.instanceOf (info, Integer) || Clazz.instanceOf (info, Float) || Clazz.instanceOf (info, Double)) return org.jmol.util.Escape.packageJSON (infoType, info.toString ());
if (Clazz.instanceOf (info, String)) return org.jmol.util.Escape.packageJSON (infoType, org.jmol.util.Escape.fixString (info));
if (org.jmol.util.Escape.isAS (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.fixString ((info)[i]));
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (org.jmol.util.Escape.isAI (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).appendI ((info)[i]);
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (org.jmol.util.Escape.isAF (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).appendF ((info)[i]);
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (org.jmol.util.Escape.isAD (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).appendD ((info)[i]);
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (org.jmol.util.Escape.isAP (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep);
org.jmol.util.Escape.addJsonTuple (sb, (info)[i]);
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (org.jmol.util.Escape.isASS (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.toJSON (null, (info)[i]));
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (org.jmol.util.Escape.isAII (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.toJSON (null, (info)[i]));
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (org.jmol.util.Escape.isAFF (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.toJSON (null, (info)[i]));
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (org.jmol.util.Escape.isAFFF (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.toJSON (null, (info)[i]));
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (Clazz.instanceOf (info, java.util.List)) {
sb.append ("[ ");
var imax = (info).size ();
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.toJSON (null, (info).get (i)));
sep = ",";
}
sb.append (" ]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (Clazz.instanceOf (info, org.jmol.util.Matrix4f)) {
var x =  Clazz.newFloatArray (4, 0);
var m4 = info;
sb.appendC ('[');
for (var i = 0; i < 4; i++) {
if (i > 0) sb.appendC (',');
m4.getRow (i, x);
sb.append (org.jmol.util.Escape.toJSON (null, x));
}
sb.appendC (']');
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (Clazz.instanceOf (info, org.jmol.util.Matrix3f)) {
var x =  Clazz.newFloatArray (3, 0);
var m3 = info;
sb.appendC ('[');
for (var i = 0; i < 3; i++) {
if (i > 0) sb.appendC (',');
m3.getRow (i, x);
sb.append (org.jmol.util.Escape.toJSON (null, x));
}
sb.appendC (']');
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (Clazz.instanceOf (info, org.jmol.util.Tuple3f)) {
org.jmol.util.Escape.addJsonTuple (sb, info);
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (Clazz.instanceOf (info, org.jmol.util.AxisAngle4f)) {
sb.append ("[").appendF ((info).x).append (",").appendF ((info).y).append (",").appendF ((info).z).append (",").appendF (((info).angle * 180 / 3.141592653589793)).append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (Clazz.instanceOf (info, org.jmol.util.Point4f)) {
sb.append ("[").appendF ((info).x).append (",").appendF ((info).y).append (",").appendF ((info).z).append (",").appendF ((info).w).append ("]");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}if (Clazz.instanceOf (info, java.util.Map)) {
sb.append ("{ ");
var e = (info).keySet ().iterator ();
while (e.hasNext ()) {
var key = e.next ();
sb.append (sep).append (org.jmol.util.Escape.packageJSON (key, org.jmol.util.Escape.toJSON (null, (info).get (key))));
sep = ",";
}
sb.append (" }");
return org.jmol.util.Escape.packageJSONSb (infoType, sb);
}return org.jmol.util.Escape.packageJSON (infoType, org.jmol.util.Escape.fixString (info.toString ()));
}, "~S,~O");
c$.addJsonTuple = Clazz.defineMethod (c$, "addJsonTuple", 
($fz = function (sb, pt) {
sb.append ("[").appendF (pt.x).append (",").appendF (pt.y).append (",").appendF (pt.z).append ("]");
}, $fz.isPrivate = true, $fz), "org.jmol.util.StringXBuilder,org.jmol.util.Tuple3f");
c$.toReadable = Clazz.defineMethod (c$, "toReadable", 
function (name, info) {
var sb =  new org.jmol.util.StringXBuilder ();
var sep = "";
if (info == null) return "null";
if (Clazz.instanceOf (info, String)) return org.jmol.util.Escape.packageReadable (name, null, org.jmol.util.Escape.escapeStr (info));
if (org.jmol.util.Escape.isAS (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.escapeStr ((info)[i]));
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageReadableSb (name, "String[" + imax + "]", sb);
}if (org.jmol.util.Escape.isAI (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).appendI ((info)[i]);
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageReadableSb (name, "int[" + imax + "]", sb);
}if (org.jmol.util.Escape.isAF (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).appendF ((info)[i]);
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageReadableSb (name, "float[" + imax + "]", sb);
}if (org.jmol.util.Escape.isAP (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.escapePt ((info)[i]));
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageReadableSb (name, "point3f[" + imax + "]", sb);
}if (org.jmol.util.Escape.isASS (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.toReadable (null, (info)[i]));
sep = ",\n";
}
sb.append ("]");
return org.jmol.util.Escape.packageReadableSb (name, "String[" + imax + "][]", sb);
}if (org.jmol.util.Escape.isAII (info)) {
sb.append ("[");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.toReadable (null, (info)[i]));
sep = ",";
}
sb.append ("]");
return org.jmol.util.Escape.packageReadableSb (name, "int[" + imax + "][]", sb);
}if (org.jmol.util.Escape.isAFF (info)) {
sb.append ("[\n");
var imax = (info).length;
for (var i = 0; i < imax; i++) {
sb.append (sep).append (org.jmol.util.Escape.toReadable (null, (info)[i]));
sep = ",\n";
}
sb.append ("]");
return org.jmol.util.Escape.packageReadableSb (name, "float[][]", sb);
}if (Clazz.instanceOf (info, java.util.List)) {
var imax = (info).size ();
for (var i = 0; i < imax; i++) {
sb.append (org.jmol.util.Escape.toReadable (name + "[" + (i + 1) + "]", (info).get (i)));
}
return org.jmol.util.Escape.packageReadableSb (name, "List[" + imax + "]", sb);
}if (Clazz.instanceOf (info, org.jmol.util.Matrix3f) || Clazz.instanceOf (info, org.jmol.util.Tuple3f) || Clazz.instanceOf (info, org.jmol.util.Point4f) || Clazz.instanceOf (info, org.jmol.util.AxisAngle4f)) {
sb.append (org.jmol.util.Escape.escape (info));
return org.jmol.util.Escape.packageReadableSb (name, null, sb);
}if (Clazz.instanceOf (info, java.util.Map)) {
var e = (info).keySet ().iterator ();
while (e.hasNext ()) {
var key = e.next ();
sb.append (org.jmol.util.Escape.toReadable ((name == null ? "" : name + ".") + key, (info).get (key)));
}
return sb.toString ();
}return org.jmol.util.Escape.packageReadable (name, null, info.toString ());
}, "~S,~O");
c$.packageReadableSb = Clazz.defineMethod (c$, "packageReadableSb", 
($fz = function (infoName, infoType, sb) {
return org.jmol.util.Escape.packageReadable (infoName, infoType, sb.toString ());
}, $fz.isPrivate = true, $fz), "~S,~S,org.jmol.util.StringXBuilder");
c$.packageReadable = Clazz.defineMethod (c$, "packageReadable", 
($fz = function (infoName, infoType, info) {
var s = (infoType == null ? "" : infoType + "\t");
if (infoName == null) return s + info;
return "\n" + infoName + "\t" + (infoType == null ? "" : "*" + infoType + "\t") + info;
}, $fz.isPrivate = true, $fz), "~S,~S,~S");
c$.escapeModelFileNumber = Clazz.defineMethod (c$, "escapeModelFileNumber", 
function (iv) {
return "" + (Clazz.doubleToInt (iv / 1000000)) + "." + (iv % 1000000);
}, "~N");
c$.encapsulateData = Clazz.defineMethod (c$, "encapsulateData", 
function (name, data, depth) {
return "  DATA \"" + name + "\"\n" + (depth == 2 ? org.jmol.util.Escape.escapeFloatAA (data, true) + ";\n" : depth == 3 ? org.jmol.util.Escape.escapeFloatAAA (data, true) + ";\n" : data) + "    END \"" + name + "\";\n";
}, "~S,~O,~N");
c$.unescapeUnicode = Clazz.defineMethod (c$, "unescapeUnicode", 
function (s) {
var ichMax = s.length;
var sb = org.jmol.util.StringXBuilder.newN (ichMax);
var ich = 0;
while (ich < ichMax) {
var ch = s.charAt (ich++);
if (ch == '\\' && ich < ichMax) {
ch = s.charAt (ich++);
switch (ch) {
case 'u':
if (ich < ichMax) {
var unicode = 0;
for (var k = 4; --k >= 0 && ich < ichMax; ) {
var chT = s.charAt (ich);
var hexit = org.jmol.util.Escape.getHexitValue (chT);
if (hexit < 0) break;
unicode <<= 4;
unicode += hexit;
++ich;
}
ch = String.fromCharCode (unicode);
}}
}sb.appendC (ch);
}
return sb.toString ();
}, "~S");
c$.getHexitValue = Clazz.defineMethod (c$, "getHexitValue", 
function (ch) {
if (ch >= '0' && ch <= '9') return ch.charCodeAt (0) - 48;
 else if (ch >= 'a' && ch <= 'f') return 10 + ch.charCodeAt (0) - 97;
 else if (ch >= 'A' && ch <= 'F') return 10 + ch.charCodeAt (0) - 65;
 else return -1;
}, "~S");
c$.unescapeStringArray = Clazz.defineMethod (c$, "unescapeStringArray", 
function (data) {
if (data == null || !data.startsWith ("[") || !data.endsWith ("]")) return null;
var v =  new java.util.ArrayList ();
var next =  Clazz.newIntArray (1, 0);
next[0] = 1;
while (next[0] < data.length) {
var s = org.jmol.util.Parser.getQuotedStringNext (data, next);
if (s == null) return null;
v.add (s);
while (next[0] < data.length && data.charAt (next[0]) != '"') next[0]++;

}
return v.toArray ( new Array (v.size ()));
}, "~S");
c$.escapeUrl = Clazz.defineMethod (c$, "escapeUrl", 
function (url) {
url = org.jmol.util.TextFormat.simpleReplace (url, "\n", "");
url = org.jmol.util.TextFormat.simpleReplace (url, "%", "%25");
url = org.jmol.util.TextFormat.simpleReplace (url, "[", "%5B");
url = org.jmol.util.TextFormat.simpleReplace (url, "]", "%5D");
url = org.jmol.util.TextFormat.simpleReplace (url, " ", "%20");
return url;
}, "~S");
Clazz.defineStatics (c$,
"escapable", "\\\\\tt\rr\nn\"\"");
});
// 
//// org\jmol\util\LoggerInterface.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.declareInterface (org.jmol.util, "LoggerInterface");
// 
//// org\jmol\util\DefaultLogger.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.LoggerInterface"], "org.jmol.util.DefaultLogger", ["org.jmol.util.Logger"], function () {
c$ = Clazz.declareType (org.jmol.util, "DefaultLogger", null, org.jmol.util.LoggerInterface);
Clazz.defineMethod (c$, "log", 
function (out, level, txt, e) {
if (out === System.err) System.out.flush ();
if ((out != null) && ((txt != null) || (e != null))) {
txt = (txt != null ? txt : "");
out.println ((org.jmol.util.Logger.logLevel () ? "[" + org.jmol.util.Logger.getLevel (level) + "] " : "") + txt + (e != null ? ": " + e.getMessage () : ""));
if (e != null) {
var elements = e.getStackTrace ();
if (elements != null) {
for (var i = 0; i < elements.length; i++) {
out.println (elements[i].getClassName () + " - " + elements[i].getLineNumber () + " - " + elements[i].getMethodName ());
}
}}}if (out === System.err) System.err.flush ();
}, "java.io.PrintStream,~N,~S,Throwable");
Clazz.overrideMethod (c$, "debug", 
function (txt) {
this.log (System.out, 5, txt, null);
}, "~S");
Clazz.overrideMethod (c$, "info", 
function (txt) {
this.log (System.out, 4, txt, null);
}, "~S");
Clazz.overrideMethod (c$, "warn", 
function (txt) {
this.log (System.out, 3, txt, null);
}, "~S");
Clazz.overrideMethod (c$, "warnEx", 
function (txt, e) {
this.log (System.out, 3, txt, e);
}, "~S,Throwable");
Clazz.overrideMethod (c$, "error", 
function (txt) {
this.log (System.err, 2, txt, null);
}, "~S");
Clazz.overrideMethod (c$, "errorEx", 
function (txt, e) {
this.log (System.err, 2, txt, e);
}, "~S,Throwable");
Clazz.overrideMethod (c$, "fatal", 
function (txt) {
this.log (System.err, 1, txt, null);
}, "~S");
Clazz.overrideMethod (c$, "fatalEx", 
function (txt, e) {
this.log (System.err, 1, txt, e);
}, "~S,Throwable");
});
// 
//// org\jmol\util\Logger.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["java.util.Hashtable", "org.jmol.util.DefaultLogger"], "org.jmol.util.Logger", ["java.lang.Long", "$.Runtime"], function () {
c$ = Clazz.declareType (org.jmol.util, "Logger");
c$.getProperty = Clazz.defineMethod (c$, "getProperty", 
($fz = function (level, defaultValue) {
try {
var property = System.getProperty ("jmol.logger." + level, null);
if (property != null) {
return (property.equalsIgnoreCase ("true"));
}} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
return defaultValue;
}, $fz.isPrivate = true, $fz), "~S,~B");
c$.setLogger = Clazz.defineMethod (c$, "setLogger", 
function (logger) {
($t$ = org.jmol.util.Logger._logger = logger, org.jmol.util.Logger.prototype._logger = org.jmol.util.Logger._logger, $t$);
($t$ = org.jmol.util.Logger.debugging = org.jmol.util.Logger.isActiveLevel (5) || org.jmol.util.Logger.isActiveLevel (6), org.jmol.util.Logger.prototype.debugging = org.jmol.util.Logger.debugging, $t$);
}, "org.jmol.util.LoggerInterface");
c$.isActiveLevel = Clazz.defineMethod (c$, "isActiveLevel", 
function (level) {
return org.jmol.util.Logger._logger != null && level >= 0 && level < 7 && org.jmol.util.Logger._activeLevels[level];
}, "~N");
c$.setActiveLevel = Clazz.defineMethod (c$, "setActiveLevel", 
function (level, active) {
if (level < 0) level = 0;
if (level >= 7) level = 6;
org.jmol.util.Logger._activeLevels[level] = active;
($t$ = org.jmol.util.Logger.debugging = org.jmol.util.Logger.isActiveLevel (5) || org.jmol.util.Logger.isActiveLevel (6), org.jmol.util.Logger.prototype.debugging = org.jmol.util.Logger.debugging, $t$);
}, "~N,~B");
c$.setLogLevel = Clazz.defineMethod (c$, "setLogLevel", 
function (level) {
for (var i = 7; --i >= 0; ) org.jmol.util.Logger.setActiveLevel (i, i <= level);

}, "~N");
c$.getLevel = Clazz.defineMethod (c$, "getLevel", 
function (level) {
switch (level) {
case 6:
return "DEBUGHIGH";
case 5:
return "DEBUG";
case 4:
return "INFO";
case 3:
return "WARN";
case 2:
return "ERROR";
case 1:
return "FATAL";
}
return "????";
}, "~N");
c$.logLevel = Clazz.defineMethod (c$, "logLevel", 
function () {
return org.jmol.util.Logger._logLevel;
});
c$.doLogLevel = Clazz.defineMethod (c$, "doLogLevel", 
function (log) {
($t$ = org.jmol.util.Logger._logLevel = log, org.jmol.util.Logger.prototype._logLevel = org.jmol.util.Logger._logLevel, $t$);
}, "~B");
c$.debug = Clazz.defineMethod (c$, "debug", 
function (txt) {
if (!org.jmol.util.Logger.debugging) return;
try {
org.jmol.util.Logger._logger.debug (txt);
} catch (t) {
}
}, "~S");
c$.info = Clazz.defineMethod (c$, "info", 
function (txt) {
try {
if (org.jmol.util.Logger.isActiveLevel (4)) {
org.jmol.util.Logger._logger.info (txt);
}} catch (t) {
}
}, "~S");
c$.warn = Clazz.defineMethod (c$, "warn", 
function (txt) {
try {
if (org.jmol.util.Logger.isActiveLevel (3)) {
org.jmol.util.Logger._logger.warn (txt);
}} catch (t) {
}
}, "~S");
c$.warnEx = Clazz.defineMethod (c$, "warnEx", 
function (txt, e) {
try {
if (org.jmol.util.Logger.isActiveLevel (3)) {
org.jmol.util.Logger._logger.warnEx (txt, e);
}} catch (t) {
}
}, "~S,Throwable");
c$.error = Clazz.defineMethod (c$, "error", 
function (txt) {
try {
if (org.jmol.util.Logger.isActiveLevel (2)) {
org.jmol.util.Logger._logger.error (txt);
}} catch (t) {
}
}, "~S");
c$.errorEx = Clazz.defineMethod (c$, "errorEx", 
function (txt, e) {
try {
if (org.jmol.util.Logger.isActiveLevel (2)) {
org.jmol.util.Logger._logger.errorEx (txt, e);
}} catch (t) {
}
}, "~S,Throwable");
c$.getLogLevel = Clazz.defineMethod (c$, "getLogLevel", 
function () {
for (var i = 7; --i >= 0; ) if (org.jmol.util.Logger.isActiveLevel (i)) return i;

return 0;
});
c$.fatal = Clazz.defineMethod (c$, "fatal", 
function (txt) {
try {
if (org.jmol.util.Logger.isActiveLevel (1)) {
org.jmol.util.Logger._logger.fatal (txt);
}} catch (t) {
}
}, "~S");
c$.fatalEx = Clazz.defineMethod (c$, "fatalEx", 
function (txt, e) {
try {
if (org.jmol.util.Logger.isActiveLevel (1)) {
org.jmol.util.Logger._logger.fatalEx (txt, e);
}} catch (t) {
}
}, "~S,Throwable");
c$.startTimer = Clazz.defineMethod (c$, "startTimer", 
function (msg) {
if (msg == null) return;
org.jmol.util.Logger.htTiming.put (msg, Long.$valueOf (System.currentTimeMillis ()));
}, "~S");
c$.checkTimer = Clazz.defineMethod (c$, "checkTimer", 
function (msg, andReset) {
if (msg == null) return -1;
var t = org.jmol.util.Logger.htTiming.get (msg);
if (t == null) return -1;
var time = System.currentTimeMillis () - t.longValue ();
if (!msg.startsWith ("(")) org.jmol.util.Logger.info ("Time for " + msg + ": " + (time) + " ms");
if (andReset) org.jmol.util.Logger.startTimer (msg);
return time;
}, "~S,~B");
c$.checkMemory = Clazz.defineMethod (c$, "checkMemory", 
function () {
var bTotal = 0;
var bFree = 0;
var bMax = 0;
try {
var runtime = Runtime.getRuntime ();
runtime.gc ();
bTotal = runtime.totalMemory ();
bFree = runtime.freeMemory ();
bMax = runtime.maxMemory ();
} catch (e) {
}
org.jmol.util.Logger.info ("Memory: Total-Free=" + (bTotal - bFree) + "; Total=" + bTotal + "; Free=" + bFree + "; Max=" + bMax);
});
c$._logger = c$.prototype._logger =  new org.jmol.util.DefaultLogger ();
Clazz.defineStatics (c$,
"LEVEL_FATAL", 1,
"LEVEL_ERROR", 2,
"LEVEL_WARN", 3,
"LEVEL_INFO", 4,
"LEVEL_DEBUG", 5,
"LEVEL_DEBUGHIGH", 6,
"LEVEL_MAX", 7,
"_activeLevels",  Clazz.newBooleanArray (7, false),
"_logLevel", false,
"debugging", false,
"debuggingHigh", false);
{
org.jmol.util.Logger._activeLevels[6] = org.jmol.util.Logger.getProperty ("debugHigh", false);
org.jmol.util.Logger._activeLevels[5] = org.jmol.util.Logger.getProperty ("debug", false);
org.jmol.util.Logger._activeLevels[4] = org.jmol.util.Logger.getProperty ("info", true);
org.jmol.util.Logger._activeLevels[3] = org.jmol.util.Logger.getProperty ("warn", true);
org.jmol.util.Logger._activeLevels[2] = org.jmol.util.Logger.getProperty ("error", true);
org.jmol.util.Logger._activeLevels[1] = org.jmol.util.Logger.getProperty ("fatal", true);
($t$ = org.jmol.util.Logger._logLevel = org.jmol.util.Logger.getProperty ("logLevel", false), org.jmol.util.Logger.prototype._logLevel = org.jmol.util.Logger._logLevel, $t$);
($t$ = org.jmol.util.Logger.debugging = (org.jmol.util.Logger._logger != null && (org.jmol.util.Logger._activeLevels[5] || org.jmol.util.Logger._activeLevels[6])), org.jmol.util.Logger.prototype.debugging = org.jmol.util.Logger.debugging, $t$);
($t$ = org.jmol.util.Logger.debuggingHigh = (org.jmol.util.Logger.debugging && org.jmol.util.Logger._activeLevels[6]), org.jmol.util.Logger.prototype.debuggingHigh = org.jmol.util.Logger.debuggingHigh, $t$);
}c$.htTiming = c$.prototype.htTiming =  new java.util.Hashtable ();
});
// 
//// org\jmol\util\Parser.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Parser", ["java.lang.Float", "org.jmol.util.ArrayUtil", "$.Logger", "$.TextFormat"], function () {
c$ = Clazz.declareType (org.jmol.util, "Parser");
c$.parseStringInfestedFloatArray = Clazz.defineMethod (c$, "parseStringInfestedFloatArray", 
function (str, bs, data) {
return org.jmol.util.Parser.parseFloatArrayBsData (org.jmol.util.Parser.getTokens (str), bs, data);
}, "~S,org.jmol.util.BitSet,~A");
c$.parseFloatArray = Clazz.defineMethod (c$, "parseFloatArray", 
function (str) {
return org.jmol.util.Parser.parseFloatArrayNext (str,  Clazz.newIntArray (1, 0));
}, "~S");
c$.parseFloatArrayNext = Clazz.defineMethod (c$, "parseFloatArrayNext", 
function (str, next) {
var pt = next[0];
if (pt < 0) return  Clazz.newFloatArray (0, 0);
pt = str.indexOf ("[", pt);
if (pt >= 0) str = str.substring (pt + 1);
next[0] = pt + 1;
pt = str.indexOf ("]");
if (pt < 0) pt = str.length;
 else str = str.substring (0, pt);
next[0] += pt + 1;
var tokens = org.jmol.util.Parser.getTokens (str);
var f =  Clazz.newFloatArray (tokens.length, 0);
var n = org.jmol.util.Parser.parseFloatArrayBsData (tokens, null, f);
for (var i = n; i < f.length; i++) f[i] = NaN;

return f;
}, "~S,~A");
c$.parseFloatArrayBsData = Clazz.defineMethod (c$, "parseFloatArrayBsData", 
function (tokens, bs, data) {
var len = data.length;
var nTokens = tokens.length;
var n = 0;
var max = 0;
var haveBitSet = (bs != null);
for (var i = (haveBitSet ? bs.nextSetBit (0) : 0); i >= 0 && i < len && n < nTokens; i = (haveBitSet ? bs.nextSetBit (i + 1) : i + 1)) {
var f;
while (Float.isNaN (f = org.jmol.util.Parser.parseFloatStr (tokens[n++])) && n < nTokens) {
}
if (!Float.isNaN (f)) data[(max = i)] = f;
if (n == nTokens) break;
}
return max + 1;
}, "~A,org.jmol.util.BitSet,~A");
c$.fixDataString = Clazz.defineMethod (c$, "fixDataString", 
($fz = function (str) {
str = str.$replace (';', str.indexOf ('\n') < 0 ? '\n' : ' ');
str = org.jmol.util.TextFormat.trim (str, "\n \t");
str = org.jmol.util.TextFormat.simpleReplace (str, "\n ", "\n");
str = org.jmol.util.TextFormat.simpleReplace (str, "\n\n", "\n");
return str;
}, $fz.isPrivate = true, $fz), "~S");
c$.parseFloatArray2d = Clazz.defineMethod (c$, "parseFloatArray2d", 
function (str) {
str = org.jmol.util.Parser.fixDataString (str);
var lines = org.jmol.util.Parser.markLines (str, '\n');
var nLines = lines.length;
var data = org.jmol.util.ArrayUtil.newFloat2 (nLines);
for (var iLine = 0, pt = 0; iLine < nLines; pt = lines[iLine++]) {
var tokens = org.jmol.util.Parser.getTokens (str.substring (pt, lines[iLine]));
org.jmol.util.Parser.parseFloatArrayData (tokens, data[iLine] =  Clazz.newFloatArray (tokens.length, 0));
}
return data;
}, "~S");
c$.parseFloatArray3d = Clazz.defineMethod (c$, "parseFloatArray3d", 
function (str) {
str = org.jmol.util.Parser.fixDataString (str);
var lines = org.jmol.util.Parser.markLines (str, '\n');
var nLines = lines.length;
var tokens = org.jmol.util.Parser.getTokens (str.substring (0, lines[0]));
if (tokens.length != 3) return  Clazz.newFloatArray (0, 0, 0, 0);
var nX = org.jmol.util.Parser.parseInt (tokens[0]);
var nY = org.jmol.util.Parser.parseInt (tokens[1]);
var nZ = org.jmol.util.Parser.parseInt (tokens[2]);
if (nX < 1 || nY < 1 || nZ < 1) return  Clazz.newFloatArray (1, 1, 1, 0);
var data = org.jmol.util.ArrayUtil.newFloat3 (nX, nY);
var iX = 0;
var iY = 0;
for (var iLine = 1, pt = lines[0]; iLine < nLines && iX < nX; pt = lines[iLine++]) {
tokens = org.jmol.util.Parser.getTokens (str.substring (pt, lines[iLine]));
if (tokens.length < nZ) continue;
org.jmol.util.Parser.parseFloatArrayData (tokens, data[iX][iY] =  Clazz.newFloatArray (tokens.length, 0));
if (++iY == nY) {
iX++;
iY = 0;
}}
if (iX != nX) {
org.jmol.util.Logger.info ("Error reading 3D data -- nX = " + nX + ", but only " + iX + " blocks read");
return  Clazz.newFloatArray (1, 1, 1, 0);
}return data;
}, "~S");
c$.setSelectedFloats = Clazz.defineMethod (c$, "setSelectedFloats", 
function (f, bs, data) {
var isAll = (bs == null);
var i0 = (isAll ? 0 : bs.nextSetBit (0));
for (var i = i0; i >= 0 && i < data.length; i = (isAll ? i + 1 : bs.nextSetBit (i + 1))) data[i] = f;

}, "~N,org.jmol.util.BitSet,~A");
c$.extractData = Clazz.defineMethod (c$, "extractData", 
function (data, field, nBytes, firstLine) {
return org.jmol.util.Parser.parseFloatArrayFromMatchAndField (data, null, 0, 0, null, field, nBytes, null, firstLine);
}, "~S,~N,~N,~N");
c$.parseFloatArrayFromMatchAndField = Clazz.defineMethod (c$, "parseFloatArrayFromMatchAndField", 
function (str, bs, fieldMatch, fieldMatchColumnCount, matchData, field, fieldColumnCount, data, firstLine) {
var f;
var i = -1;
var isMatch = (matchData != null);
var lines = org.jmol.util.Parser.markLines (str, (str.indexOf ('\n') >= 0 ? '\n' : ';'));
var iLine = (firstLine <= 1 || firstLine >= lines.length ? 0 : firstLine - 1);
var pt = (iLine == 0 ? 0 : lines[iLine - 1]);
var nLines = lines.length;
if (data == null) data =  Clazz.newFloatArray (nLines - iLine, 0);
var len = data.length;
var minLen = (fieldColumnCount <= 0 ? Math.max (field, fieldMatch) : Math.max (field + fieldColumnCount, fieldMatch + fieldMatchColumnCount) - 1);
var haveBitSet = (bs != null);
for (; iLine < nLines; iLine++) {
var line = str.substring (pt, lines[iLine]).trim ();
pt = lines[iLine];
var tokens = (fieldColumnCount <= 0 ? org.jmol.util.Parser.getTokens (line) : null);
if (fieldColumnCount <= 0) {
if (tokens.length < minLen || Float.isNaN (f = org.jmol.util.Parser.parseFloatStr (tokens[field - 1]))) continue;
} else {
if (line.length < minLen || Float.isNaN (f = org.jmol.util.Parser.parseFloatStr (line.substring (field - 1, field + fieldColumnCount - 1)))) continue;
}var iData;
if (isMatch) {
iData = org.jmol.util.Parser.parseInt (tokens == null ? line.substring (fieldMatch - 1, fieldMatch + fieldMatchColumnCount - 1) : tokens[fieldMatch - 1]);
if (iData == -2147483648 || iData < 0 || iData >= len || (iData = matchData[iData]) < 0) continue;
if (haveBitSet) bs.set (iData);
} else {
if (haveBitSet) i = bs.nextSetBit (i + 1);
 else i++;
if (i < 0 || i >= len) return data;
iData = i;
}data[iData] = f;
}
return data;
}, "~S,org.jmol.util.BitSet,~N,~N,~A,~N,~N,~A,~N");
c$.parseFloatArrayData = Clazz.defineMethod (c$, "parseFloatArrayData", 
function (tokens, data) {
org.jmol.util.Parser.parseFloatArrayDataN (tokens, data, data.length);
}, "~A,~A");
c$.parseFloatArrayDataN = Clazz.defineMethod (c$, "parseFloatArrayDataN", 
function (tokens, data, nData) {
for (var i = nData; --i >= 0; ) data[i] = (i >= tokens.length ? NaN : org.jmol.util.Parser.parseFloatStr (tokens[i]));

}, "~A,~A,~N");
c$.parseFloatStr = Clazz.defineMethod (c$, "parseFloatStr", 
function (str) {
return org.jmol.util.Parser.parseFloatNext (str, [0]);
}, "~S");
c$.parseFloatStrict = Clazz.defineMethod (c$, "parseFloatStrict", 
function (str) {
var cch = str.length;
if (cch == 0) return NaN;
return org.jmol.util.Parser.parseFloatChecked (str, cch, [0], true);
}, "~S");
c$.parseInt = Clazz.defineMethod (c$, "parseInt", 
function (str) {
return org.jmol.util.Parser.parseIntNext (str, [0]);
}, "~S");
c$.getTokens = Clazz.defineMethod (c$, "getTokens", 
function (line) {
return org.jmol.util.Parser.getTokensAt (line, 0);
}, "~S");
c$.parseToken = Clazz.defineMethod (c$, "parseToken", 
function (str) {
return org.jmol.util.Parser.parseTokenNext (str, [0]);
}, "~S");
c$.parseTrimmed = Clazz.defineMethod (c$, "parseTrimmed", 
function (str) {
return org.jmol.util.Parser.parseTrimmedRange (str, 0, str.length);
}, "~S");
c$.parseTrimmedAt = Clazz.defineMethod (c$, "parseTrimmedAt", 
function (str, ichStart) {
return org.jmol.util.Parser.parseTrimmedRange (str, ichStart, str.length);
}, "~S,~N");
c$.parseTrimmedRange = Clazz.defineMethod (c$, "parseTrimmedRange", 
function (str, ichStart, ichMax) {
var cch = str.length;
if (ichMax < cch) cch = ichMax;
if (cch < ichStart) return "";
return org.jmol.util.Parser.parseTrimmedChecked (str, ichStart, cch);
}, "~S,~N,~N");
c$.markLines = Clazz.defineMethod (c$, "markLines", 
function (data, eol) {
var nLines = 0;
for (var i = data.length; --i >= 0; ) if (data.charAt (i) == eol) nLines++;

var lines =  Clazz.newIntArray (nLines + 1, 0);
lines[nLines--] = data.length;
for (var i = data.length; --i >= 0; ) if (data.charAt (i) == eol) lines[nLines--] = i + 1;

return lines;
}, "~S,~S");
c$.parseFloatNext = Clazz.defineMethod (c$, "parseFloatNext", 
function (str, next) {
var cch = str.length;
if (next[0] < 0 || next[0] >= cch) return NaN;
return org.jmol.util.Parser.parseFloatChecked (str, cch, next, false);
}, "~S,~A");
c$.parseFloatRange = Clazz.defineMethod (c$, "parseFloatRange", 
function (str, ichMax, next) {
var cch = str.length;
if (ichMax > cch) ichMax = cch;
if (next[0] < 0 || next[0] >= ichMax) return NaN;
return org.jmol.util.Parser.parseFloatChecked (str, ichMax, next, false);
}, "~S,~N,~A");
c$.parseFloatChecked = Clazz.defineMethod (c$, "parseFloatChecked", 
($fz = function (str, ichMax, next, isStrict) {
var digitSeen = false;
var value = 0;
var ich = next[0];
if (isStrict && str.indexOf ('\n') != str.lastIndexOf ('\n')) return NaN;
while (ich < ichMax && org.jmol.util.Parser.isWhiteSpace (str, ich)) ++ich;

var negative = false;
if (ich < ichMax && str.charAt (ich) == '-') {
++ich;
negative = true;
}var ch = String.fromCharCode (0);
while (ich < ichMax && (ch = str.charAt (ich)) >= '0' && ch <= '9') {
value = value * 10 + (ch.charCodeAt (0) - 48);
++ich;
digitSeen = true;
}
var isDecimal = false;
if (ch == '.') {
isDecimal = true;
var iscale = 0;
while (++ich < ichMax && (ch = str.charAt (ich)) >= '0' && ch <= '9') {
if (iscale < org.jmol.util.Parser.decimalScale.length) value += (ch.charCodeAt (0) - 48) * org.jmol.util.Parser.decimalScale[iscale];
++iscale;
digitSeen = true;
}
}var isExponent = false;
if (!digitSeen) value = NaN;
 else if (negative) value = -value;
if (ich < ichMax && (ch == 'E' || ch == 'e' || ch == 'D')) {
isExponent = true;
if (++ich >= ichMax) return NaN;
ch = str.charAt (ich);
if ((ch == '+') && (++ich >= ichMax)) return NaN;
next[0] = ich;
var exponent = org.jmol.util.Parser.parseIntChecked (str, ichMax, next);
if (exponent == -2147483648) return NaN;
if (exponent > 0) value *= ((exponent < org.jmol.util.Parser.tensScale.length) ? org.jmol.util.Parser.tensScale[exponent - 1] : Math.pow (10, exponent));
 else if (exponent < 0) value *= ((-exponent < org.jmol.util.Parser.decimalScale.length) ? org.jmol.util.Parser.decimalScale[-exponent - 1] : Math.pow (10, exponent));
} else {
next[0] = ich;
}if (value == -Infinity) value = -3.4028235E38;
 else if (value == Infinity) value = 3.4028235E38;
return (!isStrict || (!isExponent || isDecimal) && org.jmol.util.Parser.checkTrailingText (str, next[0], ichMax) ? value : NaN);
}, $fz.isPrivate = true, $fz), "~S,~N,~A,~B");
c$.checkTrailingText = Clazz.defineMethod (c$, "checkTrailingText", 
($fz = function (str, ich, ichMax) {
var ch;
while (ich < ichMax && ((ch = str.charAt (ich)) == ' ' || ch == '\t' || ch == '\n' || ch == ';')) ++ich;

return (ich == ichMax);
}, $fz.isPrivate = true, $fz), "~S,~N,~N");
c$.parseIntNext = Clazz.defineMethod (c$, "parseIntNext", 
function (str, next) {
var cch = str.length;
if (next[0] < 0 || next[0] >= cch) return -2147483648;
return org.jmol.util.Parser.parseIntChecked (str, cch, next);
}, "~S,~A");
c$.parseIntRange = Clazz.defineMethod (c$, "parseIntRange", 
function (str, ichMax, next) {
var cch = str.length;
if (ichMax > cch) ichMax = cch;
if (next[0] < 0 || next[0] >= ichMax) return -2147483648;
return org.jmol.util.Parser.parseIntChecked (str, ichMax, next);
}, "~S,~N,~A");
c$.parseIntChecked = Clazz.defineMethod (c$, "parseIntChecked", 
($fz = function (str, ichMax, next) {
var digitSeen = false;
var value = 0;
var ich = next[0];
if (ich < 0) return -2147483648;
var ch;
while (ich < ichMax && org.jmol.util.Parser.isWhiteSpace (str, ich)) ++ich;

var negative = false;
if (ich < ichMax && str.charAt (ich) == '-') {
negative = true;
++ich;
}while (ich < ichMax && (ch = str.charAt (ich)) >= '0' && ch <= '9') {
value = value * 10 + (ch.charCodeAt (0) - 48);
digitSeen = true;
++ich;
}
if (!digitSeen) value = -2147483648;
 else if (negative) value = -value;
next[0] = ich;
return value;
}, $fz.isPrivate = true, $fz), "~S,~N,~A");
c$.getTokensAt = Clazz.defineMethod (c$, "getTokensAt", 
function (line, ich) {
if (line == null) return null;
var cchLine = line.length;
if (ich < 0 || ich > cchLine) return null;
var tokenCount = org.jmol.util.Parser.countTokens (line, ich);
var tokens =  new Array (tokenCount);
var next =  Clazz.newIntArray (1, 0);
next[0] = ich;
for (var i = 0; i < tokenCount; ++i) tokens[i] = org.jmol.util.Parser.parseTokenChecked (line, cchLine, next);

return tokens;
}, "~S,~N");
c$.countTokens = Clazz.defineMethod (c$, "countTokens", 
($fz = function (line, ich) {
var tokenCount = 0;
if (line != null) {
var ichMax = line.length;
while (true) {
while (ich < ichMax && org.jmol.util.Parser.isWhiteSpace (line, ich)) ++ich;

if (ich == ichMax) break;
++tokenCount;
do {
++ich;
} while (ich < ichMax && !org.jmol.util.Parser.isWhiteSpace (line, ich));
}
}return tokenCount;
}, $fz.isPrivate = true, $fz), "~S,~N");
c$.parseTokenNext = Clazz.defineMethod (c$, "parseTokenNext", 
function (str, next) {
var cch = str.length;
if (next[0] < 0 || next[0] >= cch) return null;
return org.jmol.util.Parser.parseTokenChecked (str, cch, next);
}, "~S,~A");
c$.parseTokenRange = Clazz.defineMethod (c$, "parseTokenRange", 
function (str, ichMax, next) {
var cch = str.length;
if (ichMax > cch) ichMax = cch;
if (next[0] < 0 || next[0] >= ichMax) return null;
return org.jmol.util.Parser.parseTokenChecked (str, ichMax, next);
}, "~S,~N,~A");
c$.parseTokenChecked = Clazz.defineMethod (c$, "parseTokenChecked", 
($fz = function (str, ichMax, next) {
var ich = next[0];
while (ich < ichMax && org.jmol.util.Parser.isWhiteSpace (str, ich)) ++ich;

var ichNonWhite = ich;
while (ich < ichMax && !org.jmol.util.Parser.isWhiteSpace (str, ich)) ++ich;

next[0] = ich;
if (ichNonWhite == ich) return null;
return str.substring (ichNonWhite, ich);
}, $fz.isPrivate = true, $fz), "~S,~N,~A");
c$.parseTrimmedChecked = Clazz.defineMethod (c$, "parseTrimmedChecked", 
($fz = function (str, ich, ichMax) {
while (ich < ichMax && org.jmol.util.Parser.isWhiteSpace (str, ich)) ++ich;

var ichLast = ichMax - 1;
while (ichLast >= ich && org.jmol.util.Parser.isWhiteSpace (str, ichLast)) --ichLast;

if (ichLast < ich) return "";
return str.substring (ich, ichLast + 1);
}, $fz.isPrivate = true, $fz), "~S,~N,~N");
c$.concatTokens = Clazz.defineMethod (c$, "concatTokens", 
function (tokens, iFirst, iEnd) {
var str = "";
var sep = "";
for (var i = iFirst; i < iEnd; i++) {
if (i < tokens.length) {
str += sep + tokens[i];
sep = " ";
}}
return str;
}, "~A,~N,~N");
c$.getQuotedStringAt = Clazz.defineMethod (c$, "getQuotedStringAt", 
function (line, ipt0) {
var next = [ipt0];
return org.jmol.util.Parser.getQuotedStringNext (line, next);
}, "~S,~N");
c$.getQuotedStringNext = Clazz.defineMethod (c$, "getQuotedStringNext", 
function (line, next) {
var value = line;
var i = next[0];
if (i < 0 || (i = value.indexOf ("\"", i)) < 0) return "";
next[0] = ++i;
value = value.substring (i);
i = -1;
while (++i < value.length && value.charAt (i) != '"') if (value.charAt (i) == '\\') i++;

next[0] += i + 1;
return value.substring (0, i);
}, "~S,~A");
c$.isWhiteSpace = Clazz.defineMethod (c$, "isWhiteSpace", 
($fz = function (str, ich) {
var ch;
return (ich >= 0 && ((ch = str.charAt (ich)) == ' ' || ch == '\t' || ch == '\n'));
}, $fz.isPrivate = true, $fz), "~S,~N");
c$.isOneOf = Clazz.defineMethod (c$, "isOneOf", 
function (key, semiList) {
return key.indexOf (";") < 0 && (';' + semiList + ';').indexOf (';' + key + ';') >= 0;
}, "~S,~S");
c$.getQuotedAttribute = Clazz.defineMethod (c$, "getQuotedAttribute", 
function (info, name) {
var i = info.indexOf (name + "=");
return (i < 0 ? null : org.jmol.util.Parser.getQuotedStringAt (info, i));
}, "~S,~S");
c$.parseIntRadix = Clazz.defineMethod (c$, "parseIntRadix", 
function (s, i) {
{
return Integer.parseIntRadix(s, i); // special
}}, "~S,~N");
c$.approx = Clazz.defineMethod (c$, "approx", 
function (f, n) {
return Math.round (f * n) / n;
}, "~N,~N");
Clazz.defineStatics (c$,
"decimalScale", [0.1, 0.01, 0.001, 0.0001, 0.00001, 0.000001, 0.0000001, 0.00000001],
"tensScale", [10, 100, 1000, 10000, 100000, 1000000]);
});
// 
//// org\jmol\util\TextFormat.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.TextFormat", ["java.lang.Boolean", "$.Character", "$.Double", "$.Float", "org.jmol.util.Parser", "$.StringXBuilder"], function () {
c$ = Clazz.declareType (org.jmol.util, "TextFormat");
Clazz.prepareFields (c$, function () {
{
org.jmol.util.TextFormat.useNumberLocalization[0] = Boolean.TRUE;
}});
c$.setUseNumberLocalization = Clazz.defineMethod (c$, "setUseNumberLocalization", 
function (TF) {
org.jmol.util.TextFormat.useNumberLocalization[0] = (TF ? Boolean.TRUE : Boolean.FALSE);
}, "~B");
c$.formatDecimal = Clazz.defineMethod (c$, "formatDecimal", 
function (value, decimalDigits) {
if (decimalDigits == 2147483647 || value == -Infinity || value == Infinity || Float.isNaN (value)) return "" + value;
var n;
if (decimalDigits < 0) {
decimalDigits = -decimalDigits;
if (decimalDigits > org.jmol.util.TextFormat.formattingStrings.length) decimalDigits = org.jmol.util.TextFormat.formattingStrings.length;
if (value == 0) return org.jmol.util.TextFormat.formattingStrings[decimalDigits] + "E+0";
n = 0;
var d;
if (Math.abs (value) < 1) {
n = 10;
d = value * 1e-10;
} else {
n = -10;
d = value * 1e10;
}var s = ("" + d).toUpperCase ();
var i = s.indexOf ("E");
n = org.jmol.util.Parser.parseInt (s.substring (i + 1)) + n;
return (i < 0 ? "" + value : org.jmol.util.TextFormat.formatDecimal (org.jmol.util.Parser.parseFloatStr (s.substring (0, i)), decimalDigits - 1) + "E" + (n >= 0 ? "+" : "") + n);
}if (decimalDigits >= org.jmol.util.TextFormat.formattingStrings.length) decimalDigits = org.jmol.util.TextFormat.formattingStrings.length - 1;
var s1 = ("" + value).toUpperCase ();
var isNeg = s1.startsWith ("-");
if (isNeg) s1 = s1.substring (1);
var pt = s1.indexOf (".");
if (pt < 0) return s1 + org.jmol.util.TextFormat.formattingStrings[decimalDigits].substring (1);
var pt1 = s1.indexOf ("E-");
if (pt1 > 0) {
n = org.jmol.util.Parser.parseInt (s1.substring (pt1 + 1));
s1 = "0." + "0000000000000000000000000000000000000000".substring (0, -n - 1) + s1.substring (0, 1) + s1.substring (2, pt1);
pt = 1;
}pt1 = s1.indexOf ("E");
if (pt1 > 0) {
n = org.jmol.util.Parser.parseInt (s1.substring (pt1 + 1));
s1 = s1.substring (0, 1) + s1.substring (2, pt1) + "0000000000000000000000000000000000000000";
s1 = s1.substring (0, n + 1) + "." + s1.substring (n + 1);
pt = s1.indexOf (".");
}var len = s1.length;
var pt2 = decimalDigits + pt + 1;
if (pt2 < len && s1.charAt (pt2) >= '5') {
return org.jmol.util.TextFormat.formatDecimal (value + (isNeg ? -1 : 1) * org.jmol.util.TextFormat.formatAdds[decimalDigits], decimalDigits);
}var sb = org.jmol.util.StringXBuilder.newS (s1.substring (0, (decimalDigits == 0 ? pt : ++pt)));
for (var i = 0; i < decimalDigits; i++, pt++) {
if (pt < len) sb.appendC (s1.charAt (pt));
 else sb.appendC ('0');
}
s1 = (isNeg ? "-" : "") + sb;
return (Boolean.TRUE.equals (org.jmol.util.TextFormat.useNumberLocalization[0]) ? s1 : s1.$replace (',', '.'));
}, "~N,~N");
c$.formatF = Clazz.defineMethod (c$, "formatF", 
function (value, width, precision, alignLeft, zeroPad) {
return org.jmol.util.TextFormat.formatS (org.jmol.util.TextFormat.formatDecimal (value, precision), width, 0, alignLeft, zeroPad);
}, "~N,~N,~N,~B,~B");
c$.formatD = Clazz.defineMethod (c$, "formatD", 
function (value, width, precision, alignLeft, zeroPad, allowOverflow) {
return org.jmol.util.TextFormat.formatS (org.jmol.util.TextFormat.formatDecimal (value, -1 - precision), width, 0, alignLeft, zeroPad);
}, "~N,~N,~N,~B,~B,~B");
c$.formatS = Clazz.defineMethod (c$, "formatS", 
function (value, width, precision, alignLeft, zeroPad) {
if (value == null) return "";
var len = value.length;
if (precision != 2147483647 && precision > 0 && precision < len) value = value.substring (0, precision);
 else if (precision < 0 && len + precision >= 0) value = value.substring (len + precision + 1);
var padLength = width - value.length;
if (padLength <= 0) return value;
var isNeg = (zeroPad && !alignLeft && value.charAt (0) == '-');
var padChar = (zeroPad ? '0' : ' ');
var padChar0 = (isNeg ? '-' : padChar);
var sb =  new org.jmol.util.StringXBuilder ();
if (alignLeft) sb.append (value);
sb.appendC (padChar0);
for (var i = padLength; --i > 0; ) sb.appendC (padChar);

if (!alignLeft) sb.append (isNeg ? padChar + value.substring (1) : value);
return sb.toString ();
}, "~S,~N,~N,~B,~B");
c$.formatStringS = Clazz.defineMethod (c$, "formatStringS", 
function (strFormat, key, strT) {
return org.jmol.util.TextFormat.formatString (strFormat, key, strT, NaN, NaN, false);
}, "~S,~S,~S");
c$.formatStringF = Clazz.defineMethod (c$, "formatStringF", 
function (strFormat, key, floatT) {
return org.jmol.util.TextFormat.formatString (strFormat, key, null, floatT, NaN, false);
}, "~S,~S,~N");
c$.formatStringI = Clazz.defineMethod (c$, "formatStringI", 
function (strFormat, key, intT) {
return org.jmol.util.TextFormat.formatString (strFormat, key, "" + intT, NaN, NaN, false);
}, "~S,~S,~N");
c$.sprintf = Clazz.defineMethod (c$, "sprintf", 
function (strFormat, list, values) {
if (values == null) return strFormat;
var n = list.length;
if (n == values.length) try {
for (var o = 0; o < n; o++) {
if (values[o] == null) continue;
switch (list.charAt (o)) {
case 's':
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "s", values[o], NaN, NaN, true);
break;
case 'f':
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "f", null, (values[o]).floatValue (), NaN, true);
break;
case 'i':
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "d", "" + values[o], NaN, NaN, true);
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "i", "" + values[o], NaN, NaN, true);
break;
case 'd':
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "e", null, NaN, (values[o]).doubleValue (), true);
break;
case 'p':
var pVal = values[o];
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "p", null, pVal.x, NaN, true);
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "p", null, pVal.y, NaN, true);
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "p", null, pVal.z, NaN, true);
break;
case 'q':
var qVal = values[o];
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "q", null, qVal.x, NaN, true);
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "q", null, qVal.y, NaN, true);
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "q", null, qVal.z, NaN, true);
strFormat = org.jmol.util.TextFormat.formatString (strFormat, "q", null, qVal.w, NaN, true);
break;
case 'S':
var sVal = values[o];
for (var i = 0; i < sVal.length; i++) strFormat = org.jmol.util.TextFormat.formatString (strFormat, "s", sVal[i], NaN, NaN, true);

break;
case 'F':
var fVal = values[o];
for (var i = 0; i < fVal.length; i++) strFormat = org.jmol.util.TextFormat.formatString (strFormat, "f", null, fVal[i], NaN, true);

break;
case 'I':
var iVal = values[o];
for (var i = 0; i < iVal.length; i++) strFormat = org.jmol.util.TextFormat.formatString (strFormat, "d", "" + iVal[i], NaN, NaN, true);

for (var i = 0; i < iVal.length; i++) strFormat = org.jmol.util.TextFormat.formatString (strFormat, "i", "" + iVal[i], NaN, NaN, true);

break;
case 'D':
var dVal = values[o];
for (var i = 0; i < dVal.length; i++) strFormat = org.jmol.util.TextFormat.formatString (strFormat, "e", null, NaN, dVal[i], true);

}
}
return org.jmol.util.TextFormat.simpleReplace (strFormat, "%%", "%");
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
System.out.println ("TextFormat.sprintf error " + list + " " + strFormat);
return org.jmol.util.TextFormat.simpleReplace (strFormat, "%", "?");
}, "~S,~S,~A");
c$.formatString = Clazz.defineMethod (c$, "formatString", 
($fz = function (strFormat, key, strT, floatT, doubleT, doOne) {
if (strFormat == null) return null;
if ("".equals (strFormat)) return "";
var len = key.length;
if (strFormat.indexOf ("%") < 0 || len == 0 || strFormat.indexOf (key) < 0) return strFormat;
var strLabel = "";
var ich;
var ichPercent;
var ichKey;
for (ich = 0; (ichPercent = strFormat.indexOf ('%', ich)) >= 0 && (ichKey = strFormat.indexOf (key, ichPercent + 1)) >= 0; ) {
if (ich != ichPercent) strLabel += strFormat.substring (ich, ichPercent);
ich = ichPercent + 1;
if (ichKey > ichPercent + 6) {
strLabel += '%';
continue;
}try {
var alignLeft = false;
if (strFormat.charAt (ich) == '-') {
alignLeft = true;
++ich;
}var zeroPad = false;
if (strFormat.charAt (ich) == '0') {
zeroPad = true;
++ich;
}var ch;
var width = 0;
while ((ch = strFormat.charAt (ich)) >= '0' && (ch <= '9')) {
width = (10 * width) + (ch.charCodeAt (0) - 48);
++ich;
}
var precision = 2147483647;
var isExponential = false;
if (strFormat.charAt (ich) == '.') {
++ich;
if ((ch = strFormat.charAt (ich)) == '-') {
isExponential = true;
++ich;
}if ((ch = strFormat.charAt (ich)) >= '0' && ch <= '9') {
precision = ch.charCodeAt (0) - 48;
++ich;
}if (isExponential) precision = -precision - (strT == null ? 1 : 0);
}var st = strFormat.substring (ich, ich + len);
if (!st.equals (key)) {
ich = ichPercent + 1;
strLabel += '%';
continue;
}ich += len;
if (!Float.isNaN (floatT)) strLabel += org.jmol.util.TextFormat.formatF (floatT, width, precision, alignLeft, zeroPad);
 else if (strT != null) strLabel += org.jmol.util.TextFormat.formatS (strT, width, precision, alignLeft, zeroPad);
 else if (!Double.isNaN (doubleT)) strLabel += org.jmol.util.TextFormat.formatD (doubleT, width, precision, alignLeft, zeroPad, true);
if (doOne) break;
} catch (ioobe) {
if (Clazz.exceptionOf (ioobe, IndexOutOfBoundsException)) {
ich = ichPercent;
break;
} else {
throw ioobe;
}
}
}
strLabel += strFormat.substring (ich);
return strLabel;
}, $fz.isPrivate = true, $fz), "~S,~S,~S,~N,~N,~B");
c$.formatCheck = Clazz.defineMethod (c$, "formatCheck", 
function (strFormat) {
if (strFormat == null || strFormat.indexOf ('p') < 0 && strFormat.indexOf ('q') < 0) return strFormat;
strFormat = org.jmol.util.TextFormat.simpleReplace (strFormat, "%%", "\1");
strFormat = org.jmol.util.TextFormat.simpleReplace (strFormat, "%p", "%6.2p");
strFormat = org.jmol.util.TextFormat.simpleReplace (strFormat, "%q", "%6.2q");
var format = org.jmol.util.TextFormat.split (strFormat, '%');
var sb =  new org.jmol.util.StringXBuilder ();
sb.append (format[0]);
for (var i = 1; i < format.length; i++) {
var f = "%" + format[i];
var pt;
if (f.length >= 3) {
if ((pt = f.indexOf ('p')) >= 0) f = org.jmol.util.TextFormat.fdup (f, pt, 3);
if ((pt = f.indexOf ('q')) >= 0) f = org.jmol.util.TextFormat.fdup (f, pt, 4);
}sb.append (f);
}
return sb.toString ().$replace ('\1', '%');
}, "~S");
c$.fdup = Clazz.defineMethod (c$, "fdup", 
($fz = function (f, pt, n) {
var ch;
var count = 0;
for (var i = pt; --i >= 1; ) {
if (Character.isDigit (ch = f.charAt (i))) continue;
switch (ch) {
case '.':
if (count++ != 0) return f;
continue;
case '-':
if (i != 1) return f;
continue;
default:
return f;
}
}
var s = f.substring (0, pt + 1);
var sb =  new org.jmol.util.StringXBuilder ();
for (var i = 0; i < n; i++) sb.append (s);

sb.append (f.substring (pt + 1));
return sb.toString ();
}, $fz.isPrivate = true, $fz), "~S,~N,~N");
c$.splitChars = Clazz.defineMethod (c$, "splitChars", 
function (text, run) {
if (text.length == 0) return  new Array (0);
var n = 1;
var i = text.indexOf (run);
var lines;
var runLen = run.length;
if (i < 0 || runLen == 0) {
lines =  new Array (1);
lines[0] = text;
return lines;
}var len = text.length - runLen;
for (; i >= 0 && i < len; n++) i = text.indexOf (run, i + runLen);

lines =  new Array (n);
i = 0;
var ipt = 0;
var pt = 0;
for (; (ipt = text.indexOf (run, i)) >= 0 && pt + 1 < n; ) {
lines[pt++] = text.substring (i, ipt);
i = ipt + runLen;
}
if (text.indexOf (run, len) != len) len += runLen;
lines[pt] = text.substring (i, len);
return lines;
}, "~S,~S");
c$.replaceAllCharacters = Clazz.defineMethod (c$, "replaceAllCharacters", 
function (str, strFrom, strTo) {
for (var i = strFrom.length; --i >= 0; ) {
var chFrom = strFrom.substring (i, i + 1);
str = org.jmol.util.TextFormat.simpleReplace (str, chFrom, strTo);
}
return str;
}, "~S,~S,~S");
c$.replaceAllCharacter = Clazz.defineMethod (c$, "replaceAllCharacter", 
function (str, strFrom, chTo) {
if (str == null) return null;
for (var i = strFrom.length; --i >= 0; ) str = str.$replace (strFrom.charAt (i), chTo);

return str;
}, "~S,~S,~S");
c$.simpleReplace = Clazz.defineMethod (c$, "simpleReplace", 
function (str, strFrom, strTo) {
if (str == null || str.indexOf (strFrom) < 0 || strFrom.equals (strTo)) return str;
var fromLength = strFrom.length;
if (fromLength == 0) return str;
var isOnce = (strTo.indexOf (strFrom) >= 0);
var ipt;
while (str.indexOf (strFrom) >= 0) {
var s =  new org.jmol.util.StringXBuilder ();
var ipt0 = 0;
while ((ipt = str.indexOf (strFrom, ipt0)) >= 0) {
s.append (str.substring (ipt0, ipt)).append (strTo);
ipt0 = ipt + fromLength;
}
s.append (str.substring (ipt0));
str = s.toString ();
if (isOnce) break;
}
return str;
}, "~S,~S,~S");
c$.trim = Clazz.defineMethod (c$, "trim", 
function (str, chars) {
if (chars.length == 0) return str.trim ();
var len = str.length;
var k = 0;
while (k < len && chars.indexOf (str.charAt (k)) >= 0) k++;

var m = str.length - 1;
while (m > k && chars.indexOf (str.charAt (m)) >= 0) m--;

return str.substring (k, m + 1);
}, "~S,~S");
c$.split = Clazz.defineMethod (c$, "split", 
function (text, ch) {
return org.jmol.util.TextFormat.splitChars (text, "" + ch);
}, "~S,~S");
c$.lFill = Clazz.defineMethod (c$, "lFill", 
function (s, s1, s2) {
s.append (s2);
var n = s1.length - s2.length;
if (n > 0) s.append (s1.substring (0, n));
}, "org.jmol.util.StringXBuilder,~S,~S");
c$.rFill = Clazz.defineMethod (c$, "rFill", 
function (s, s1, s2) {
var n = s1.length - s2.length;
if (n > 0) s.append (s1.substring (0, n));
s.append (s2);
}, "org.jmol.util.StringXBuilder,~S,~S");
c$.safeTruncate = Clazz.defineMethod (c$, "safeTruncate", 
function (f, n) {
if (f > -0.0010 && f < 0.001) f = 0;
return (f + "         ").substring (0, n);
}, "~N,~N");
c$.isWild = Clazz.defineMethod (c$, "isWild", 
function (s) {
return s != null && (s.indexOf ("*") >= 0 || s.indexOf ("?") >= 0);
}, "~S");
c$.isMatch = Clazz.defineMethod (c$, "isMatch", 
function (s, strWildcard, checkStar, allowInitialStar) {
var ich = 0;
var cchWildcard = strWildcard.length;
var cchs = s.length;
if (cchs == 0 || cchWildcard == 0) return (cchs == cchWildcard || cchWildcard == 1 && strWildcard.charAt (0) == '*');
var isStar0 = (checkStar && allowInitialStar ? strWildcard.charAt (0) == '*' : false);
if (isStar0 && strWildcard.charAt (cchWildcard - 1) == '*') return (cchWildcard < 3 || s.indexOf (strWildcard.substring (1, cchWildcard - 1)) >= 0);
var qqq = "????";
while (qqq.length < s.length) qqq += qqq;

if (checkStar) {
if (allowInitialStar && isStar0) strWildcard = qqq + strWildcard.substring (1);
if (strWildcard.charAt (ich = strWildcard.length - 1) == '*') strWildcard = strWildcard.substring (0, ich) + qqq;
cchWildcard = strWildcard.length;
}if (cchWildcard < cchs) return false;
ich = 0;
while (cchWildcard > cchs) {
if (allowInitialStar && strWildcard.charAt (ich) == '?') {
++ich;
} else if (strWildcard.charAt (ich + cchWildcard - 1) != '?') {
return false;
}--cchWildcard;
}
for (var i = cchs; --i >= 0; ) {
var charWild = strWildcard.charAt (ich + i);
if (charWild == '?') continue;
if (charWild != s.charAt (i) && (charWild != '\1' || s.charAt (i) != '?')) return false;
}
return true;
}, "~S,~S,~B,~B");
c$.join = Clazz.defineMethod (c$, "join", 
function (s, c, i0) {
if (s.length < i0) return null;
var sb =  new org.jmol.util.StringXBuilder ();
sb.append (s[i0++]);
for (var i = i0; i < s.length; i++) sb.appendC (c).append (s[i]);

return sb.toString ();
}, "~A,~S,~N");
c$.replaceQuotedStrings = Clazz.defineMethod (c$, "replaceQuotedStrings", 
function (s, list, newList) {
var n = list.size ();
for (var i = 0; i < n; i++) {
var name = list.get (i);
var newName = newList.get (i);
if (!newName.equals (name)) s = org.jmol.util.TextFormat.simpleReplace (s, "\"" + name + "\"", "\"" + newName + "\"");
}
return s;
}, "~S,java.util.List,java.util.List");
c$.replaceStrings = Clazz.defineMethod (c$, "replaceStrings", 
function (s, list, newList) {
var n = list.size ();
for (var i = 0; i < n; i++) {
var name = list.get (i);
var newName = newList.get (i);
if (!newName.equals (name)) s = org.jmol.util.TextFormat.simpleReplace (s, name, newName);
}
return s;
}, "~S,java.util.List,java.util.List");
Clazz.defineStatics (c$,
"formattingStrings", ["0", "0.0", "0.00", "0.000", "0.0000", "0.00000", "0.000000", "0.0000000", "0.00000000", "0.000000000"],
"zeros", "0000000000000000000000000000000000000000",
"formatAdds", [0.5, 0.05, 0.005, 0.0005, 0.00005, 0.000005, 0.0000005, 0.00000005, 0.000000005, 0.0000000005]);
c$.useNumberLocalization = c$.prototype.useNumberLocalization =  new Array (1);
});
// 
//// org\jmol\util\StringXBuilder.js 
// 
Clazz.declarePackage ("org.jmol.util");
c$ = Clazz.decorateAsClass (function () {
this.sb = null;
this.s = null;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "StringXBuilder");
Clazz.makeConstructor (c$, 
function () {
{
this.s = "";
}});
c$.newN = Clazz.defineMethod (c$, "newN", 
function (n) {
{
return new org.jmol.util.StringXBuilder();
}}, "~N");
c$.newS = Clazz.defineMethod (c$, "newS", 
function (s) {
{
var sb = new org.jmol.util.StringXBuilder();
sb.s = s;
return sb;
}}, "~S");
Clazz.defineMethod (c$, "append", 
function (s) {
{
this.s += s
}return this;
}, "~S");
Clazz.defineMethod (c$, "appendC", 
function (c) {
{
this.s += c;
}return this;
}, "~S");
Clazz.defineMethod (c$, "appendI", 
function (i) {
{
this.s += i
}return this;
}, "~N");
Clazz.defineMethod (c$, "appendB", 
function (b) {
{
this.s += b
}return this;
}, "~B");
Clazz.defineMethod (c$, "appendF", 
function (f) {
{
var sf = "" + f;
if (sf.indexOf(".") < 0 && sf.indexOf("e") < 0)
sf += ".0" ;
this.s += sf;
}return this;
}, "~N");
Clazz.defineMethod (c$, "appendD", 
function (d) {
{
var sf = "" + d;
if (sf.indexOf(".") < 0 && sf.indexOf("e") < 0)
sf += ".0" ;
this.s += sf;
}return this;
}, "~N");
Clazz.defineMethod (c$, "appendSB", 
function (buf) {
{
this.s += buf.s;
}return this;
}, "org.jmol.util.StringXBuilder");
Clazz.defineMethod (c$, "appendO", 
function (data) {
{
this.s += data.toString();
}return this;
}, "~O");
Clazz.defineMethod (c$, "appendCB", 
function (cb, off, len) {
{
for (var i = len,j=off; --i >= 0;)
this.s += cb[j++];
}}, "~A,~N,~N");
Clazz.overrideMethod (c$, "toString", 
function () {
{
return this.s;
}});
Clazz.defineMethod (c$, "length", 
function () {
{
return this.s.length;
}});
Clazz.defineMethod (c$, "indexOf", 
function (s) {
{
return this.s.indexOf(s);
}}, "~S");
Clazz.defineMethod (c$, "charAt", 
function (i) {
{
return this.s.charAt(i);
}}, "~N");
Clazz.defineMethod (c$, "setLength", 
function (n) {
{
this.s = this.s.substring(0, n);
}}, "~N");
Clazz.defineMethod (c$, "lastIndexOf", 
function (s) {
{
return this.s.lastIndexOf(s);
}}, "~S");
Clazz.defineMethod (c$, "indexOf2", 
function (s, i) {
{
return this.s.indexOf(s, i);
}}, "~S,~N");
Clazz.defineMethod (c$, "substring", 
function (i) {
{
return this.s.substring(i);
}}, "~N");
Clazz.defineMethod (c$, "substring2", 
function (i, j) {
{
return this.s.substring(i, j);
}}, "~N,~N");
Clazz.defineMethod (c$, "toBytes", 
function (off, len) {
if (len < 0) len = this.length () - off;
var b =  Clazz.newByteArray (len, 0);
for (var i = off + len, j = i - off; --i >= off; ) b[--j] = (this.charAt (i)).charCodeAt (0);

return b;
}, "~N,~N");
// 
//// java\text\MessageFormat.js 
// 
$_J("java.text");
c$=$_C(function(){
this.pattern=null;
$_Z(this,arguments);
},java.text,"MessageFormat");

//$_K(c$,
//function(pattern){
//this.pattern=pattern;
//},"~S");
//$_K(c$,
//function(pattern,locale){
//this.pattern=pattern;
//},"~S,java.util.Locale");
c$.format=$_M(c$,"format",
function(pattern,args){
return pattern.replace(/\{(\d+)\}/g,function($0,$1){
var i=parseInt($1);
if(args==null)return null;
return args[i];
});
},"~S,~A");
//$_M(c$,"format",
//function(obj){
//return java.text.MessageFormat.format(this.pattern,[obj]);
//},"~O");
// 
//// org\jmol\script\Token.js 
// 
Clazz.declarePackage ("org.jmol.script");
Clazz.load (["java.util.Hashtable"], "org.jmol.script.Token", ["java.lang.Boolean", "java.util.ArrayList", "$.Arrays", "org.jmol.util.ArrayUtil", "$.Logger"], function () {
c$ = Clazz.decorateAsClass (function () {
this.tok = 0;
this.value = null;
this.intValue = 2147483647;
Clazz.instantialize (this, arguments);
}, org.jmol.script, "Token");
Clazz.makeConstructor (c$, 
function () {
});
Clazz.makeConstructor (c$, 
function (tok) {
this.tok = tok;
}, "~N");
c$.newTokenIntVal = Clazz.defineMethod (c$, "newTokenIntVal", 
function (tok, intValue, value) {
var token =  new org.jmol.script.Token (tok);
token.intValue = intValue;
token.value = value;
return token;
}, "~N,~N,~O");
c$.newTokenObj = Clazz.defineMethod (c$, "newTokenObj", 
function (tok, value) {
var token =  new org.jmol.script.Token (tok);
token.value = value;
return token;
}, "~N,~O");
c$.newToken = Clazz.defineMethod (c$, "newToken", 
function (tok, intValue) {
var token =  new org.jmol.script.Token (tok);
token.intValue = intValue;
return token;
}, "~N,~N");
c$.intToken = Clazz.defineMethod (c$, "intToken", 
function (intValue) {
var token =  new org.jmol.script.Token (2);
token.intValue = intValue;
return token;
}, "~N");
c$.tokAttr = Clazz.defineMethod (c$, "tokAttr", 
function (a, b) {
return (a & b) == (b & b);
}, "~N,~N");
c$.tokAttrOr = Clazz.defineMethod (c$, "tokAttrOr", 
function (a, b1, b2) {
return (a & b1) == (b1 & b1) || (a & b2) == (b2 & b2);
}, "~N,~N,~N");
c$.getPrecedence = Clazz.defineMethod (c$, "getPrecedence", 
function (tokOperator) {
return ((tokOperator >> 4) & 0xF);
}, "~N");
c$.getMaxMathParams = Clazz.defineMethod (c$, "getMaxMathParams", 
function (tokCommand) {
return ((tokCommand >> 9) & 0x7);
}, "~N");
c$.addToken = Clazz.defineMethod (c$, "addToken", 
function (ident, token) {
org.jmol.script.Token.tokenMap.put (ident, token);
}, "~S,org.jmol.script.Token");
c$.getTokenFromName = Clazz.defineMethod (c$, "getTokenFromName", 
function (name) {
return org.jmol.script.Token.tokenMap.get (name);
}, "~S");
c$.getTokFromName = Clazz.defineMethod (c$, "getTokFromName", 
function (name) {
var token = org.jmol.script.Token.getTokenFromName (name.toLowerCase ());
return (token == null ? 0 : token.tok);
}, "~S");
c$.nameOf = Clazz.defineMethod (c$, "nameOf", 
function (tok) {
for (var token, $token = org.jmol.script.Token.tokenMap.values ().iterator (); $token.hasNext () && ((token = $token.next ()) || true);) {
if (token.tok == tok) return "" + token.value;
}
return "0x" + Integer.toHexString (tok);
}, "~N");
Clazz.overrideMethod (c$, "toString", 
function () {
return "Token[" + org.jmol.script.Token.astrType[this.tok < 14 ? this.tok : 14] + "(" + (this.tok % (512)) + "/0x" + Integer.toHexString (this.tok) + ")" + ((this.intValue == 2147483647) ? "" : " intValue=" + this.intValue + "(0x" + Integer.toHexString (this.intValue) + ")") + ((this.value == null) ? "" : Clazz.instanceOf (this.value, String) ? " value=\"" + this.value + "\"" : " value=" + this.value) + "]";
});
c$.getCommandSet = Clazz.defineMethod (c$, "getCommandSet", 
function (strBegin) {
var cmds = "";
var htSet =  new java.util.Hashtable ();
var nCmds = 0;
var s = (strBegin == null || strBegin.length == 0 ? null : strBegin.toLowerCase ());
var isMultiCharacter = (s != null && s.length > 1);
for (var entry, $entry = org.jmol.script.Token.tokenMap.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var name = entry.getKey ();
var token = entry.getValue ();
if ((token.tok & 4096) != 0 && (s == null || name.indexOf (s) == 0) && (isMultiCharacter || (token.value).equals (name))) htSet.put (name, Boolean.TRUE);
}
for (var entry, $entry = htSet.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var name = entry.getKey ();
if (name.charAt (name.length - 1) != 's' || !htSet.containsKey (name.substring (0, name.length - 1))) cmds += (nCmds++ == 0 ? "" : ";") + name;
}
return cmds;
}, "~S");
c$.getAtomPropertiesLike = Clazz.defineMethod (c$, "getAtomPropertiesLike", 
function (type) {
type = type.toLowerCase ();
var v =  new java.util.ArrayList ();
var isAll = (type.length == 0);
for (var entry, $entry = org.jmol.script.Token.tokenMap.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var name = entry.getKey ();
if (name.charAt (0) == '_') continue;
var token = entry.getValue ();
if (org.jmol.script.Token.tokAttr (token.tok, 1078984704) && (isAll || name.toLowerCase ().startsWith (type))) {
if (isAll || !(token.value).toLowerCase ().startsWith (type)) token = org.jmol.script.Token.newTokenObj (token.tok, name);
v.add (token);
}}
return (v.size () == 0 ? null : v);
}, "~S");
c$.getTokensLike = Clazz.defineMethod (c$, "getTokensLike", 
function (type) {
var attr = (type.equals ("setparam") ? 536870912 : type.equals ("misc") ? 1073741824 : type.equals ("mathfunc") ? 135266304 : 4096);
var notattr = (attr == 536870912 ? 1610612736 : 0);
var v =  new java.util.ArrayList ();
for (var entry, $entry = org.jmol.script.Token.tokenMap.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var name = entry.getKey ();
var token = entry.getValue ();
if (org.jmol.script.Token.tokAttr (token.tok, attr) && (notattr == 0 || !org.jmol.script.Token.tokAttr (token.tok, notattr))) v.add (name);
}
var a = v.toArray ( new Array (v.size ()));
java.util.Arrays.sort (a);
return a;
}, "~S");
c$.getSettableTokFromString = Clazz.defineMethod (c$, "getSettableTokFromString", 
function (s) {
var tok = org.jmol.script.Token.getTokFromName (s);
return (tok != 0 && org.jmol.script.Token.tokAttr (tok, 2048) && !org.jmol.script.Token.tokAttr (tok, 1141899264) ? tok : 0);
}, "~S");
c$.completeCommand = Clazz.defineMethod (c$, "completeCommand", 
function (map, isSet, asCommand, str, n) {
if (map == null) map = org.jmol.script.Token.tokenMap;
 else asCommand = false;
var v =  new java.util.ArrayList ();
str = str.toLowerCase ();
for (var name, $name = map.keySet ().iterator (); $name.hasNext () && ((name = $name.next ()) || true);) {
if (!name.startsWith (str)) continue;
var tok = org.jmol.script.Token.getTokFromName (name);
if (asCommand ? org.jmol.script.Token.tokAttr (tok, 4096) : isSet ? org.jmol.script.Token.tokAttr (tok, 536870912) && !org.jmol.script.Token.tokAttr (tok, 1610612736) : true) v.add (name);
}
return org.jmol.util.ArrayUtil.sortedItem (v, n);
}, "java.util.Map,~B,~B,~S,~N");
c$.getParamType = Clazz.defineMethod (c$, "getParamType", 
function (tok) {
if (!org.jmol.script.Token.tokAttr (tok, 536870912)) return 0;
return tok & 662700032;
}, "~N");
Clazz.defineStatics (c$,
"nada", 0,
"integer", 2,
"decimal", 3,
"string", 4,
"seqcode", 5,
"hash", 6,
"varray", 7,
"point3f", 8,
"point4f", 9,
"bitset", 10,
"matrix3f", 11,
"matrix4f", 12,
"listf", 13,
"keyword", 14,
"astrType", ["nada", "identifier", "integer", "decimal", "string", "seqcode", "hash", "array", "point", "point4", "bitset", "matrix3f", "matrix4f", "listf", "keyword"],
"setparam", (536870912),
"misc", (1073741824),
"deprecatedparam", 1610612736,
"identifier", 1073741824,
"scriptCommand", (4096),
"atomExpressionCommand", 12288,
"implicitStringCommand", 20480,
"mathExpressionCommand", 36864,
"flowCommand", 102400,
"shapeCommand", 135168,
"noArgs", (262144),
"defaultON", (524288),
"expression", (1048576),
"predefinedset", 3145728,
"atomproperty", 1078984704,
"strproperty", 1087373312,
"intproperty", 1095761920,
"floatproperty", 1112539136,
"PROPERTYFLAGS", 1137704960,
"strparam", 545259520,
"intparam", 553648128,
"floatparam", 570425344,
"booleanparam", 603979776,
"paramTypes", (662700032),
"mathproperty", 1141899264,
"mathfunc", 135266304,
"mathop", 269484032,
"comparator", 269484288,
"center", 12289,
"define", 1060866,
"$delete", 12291,
"display", 1610625028,
"fixed", 1060869,
"hide", 12294,
"restrict", 12295,
"subset", 3158024,
"zap", 1060873,
"print", 36865,
"returncmd", 36866,
"set", 1085443,
"$var", 36868,
"log", 36869,
"echo", 537022465,
"help", 20482,
"hover", 544771,
"message", 20485,
"pause", 20487,
"elseif", 102402,
"elsecmd", 364547,
"endifcmd", 364548,
"whilecmd", 102406,
"breakcmd", 102407,
"continuecmd", 102408,
"end", 1150985,
"switchcmd", 102410,
"casecmd", 102411,
"catchcmd", 102412,
"defaultcmd", 102413,
"trycmd", 364558,
"animation", 4097,
"assign", 4098,
"background", 1610616835,
"bind", 4100,
"bondorder", 4101,
"calculate", 4102,
"cd", 1069064,
"centerAt", 4105,
"connect", 4106,
"console", 528395,
"delay", 528397,
"depth", 554176526,
"exit", 266255,
"exitjmol", 266256,
"font", 4114,
"frame", 4115,
"gotocmd", 20500,
"hbond", 1612189718,
"history", 1610616855,
"initialize", 266264,
"invertSelected", 4121,
"loop", 528410,
"mapProperty", 1052700,
"minimize", 4126,
"move", 4128,
"moveto", 4130,
"navigate", 4131,
"parallel", 102436,
"plot", 4133,
"pop", 266278,
"process", 102439,
"push", 266280,
"quit", 266281,
"ramachandran", 1052714,
"redomove", 4139,
"refresh", 266284,
"reset", 4141,
"restore", 4142,
"resume", 266287,
"rotate", 528432,
"rotateSelected", 4145,
"save", 4146,
"selectionhalos", 1611141171,
"show", 4148,
"slab", 554176565,
"spin", 1611141175,
"ssbond", 1611141176,
"step", 266298,
"stereo", 528443,
"sync", 4156,
"timeout", 536875070,
"translate", 4160,
"translateSelected", 4162,
"unbind", 4164,
"undomove", 4165,
"vibration", 4166,
"zoom", 4168,
"zoomTo", 4170,
"axes", 1611272194,
"dipole", 135174,
"draw", 135176,
"frank", 1611272202,
"isosurface", 135180,
"lcaocartoon", 135182,
"measurements", 537006096,
"mo", 1183762,
"pmesh", 135188,
"plot3d", 135190,
"polyhedra", 135192,
"struts", 1708058,
"unitcell", 1614417948,
"vector", 135198,
"wireframe", 659488,
"expressionBegin", 1048577,
"expressionEnd", 1048578,
"all", 1048579,
"branch", 1048580,
"coord", 1048582,
"dollarsign", 1048583,
"per", 1048584,
"isaromatic", 1048585,
"leftbrace", 1048586,
"none", 1048587,
"off", 1048588,
"on", 1048589,
"rightbrace", 1048590,
"semicolon", 1048591,
"spec_alternate", 1048607,
"spec_atom", 1048608,
"spec_chain", 1048609,
"spec_model", 1048610,
"spec_model2", 1048611,
"spec_name_pattern", 1048612,
"spec_resid", 1048613,
"spec_seqcode", 1048614,
"spec_seqcode_range", 1048615,
"amino", 3145730,
"dna", 3145732,
"hetero", 1613758470,
"helixalpha", 3145735,
"helix310", 3145736,
"helixpi", 3145738,
"hydrogen", 1613758476,
"nucleic", 3145742,
"protein", 3145744,
"purine", 3145746,
"pyrimidine", 3145748,
"rna", 3145750,
"solvent", 1613758488,
"sidechain", 3145754,
"surface", 3145756,
"thismodel", 3145758,
"sheet", 3145760,
"spine", 3145762,
"carbohydrate", 3145764,
"clickable", 3145766,
"displayed", 3145768,
"hidden", 3145770,
"specialposition", 3145772,
"visible", 3145774,
"basemodel", 3145776,
"leftparen", 269484048,
"rightparen", 269484049,
"opIf", 806354977,
"colon", 269484066,
"comma", 269484080,
"leftsquare", 269484096,
"rightsquare", 269484097,
"opOr", 269484112,
"opXor", 269484113,
"opToggle", 269484114,
"opAnd", 269484128,
"opNot", 269484144,
"opAND", 269484160,
"opGT", 269484432,
"opGE", 269484433,
"opLE", 269484434,
"opLT", 269484435,
"opEQ", 269484436,
"opNE", 269484438,
"minus", 269484192,
"plus", 269484193,
"divide", 269484208,
"times", 269484209,
"percent", 269484210,
"leftdivide", 269484211,
"unaryMinus", 269484224,
"minusMinus", 269484225,
"plusPlus", 269484226,
"timestimes", 269484227,
"propselector", 269484241,
"andequals", 269484242,
"minmaxmask", 480,
"min", 32,
"max", 64,
"average", 96,
"sum", 128,
"sum2", 160,
"stddev", 192,
"selectedfloat", 224,
"allfloat", 256,
"settable", 2048,
"atoms", 1141899265,
"bonds", 1678770178,
"length", 1141899267,
"lines", 1141899268,
"reverse", 1141899269,
"size", 1141899270,
"type", 1141899272,
"boundbox", 1679429641,
"xyz", 1146095626,
"fracxyz", 1146095627,
"screenxyz", 1146095628,
"fuxyz", 1146095629,
"unitxyz", 1146093582,
"vibxyz", 1146095631,
"w", 1141899280,
"keys", 1141899281,
"occupancy", 1129318401,
"radius", 1666189314,
"structure", 1641025539,
"atomtype", 1087375361,
"atomname", 1087375362,
"altloc", 1087373315,
"chain", 1087373316,
"element", 1087375365,
"group", 1087373318,
"group1", 1087373319,
"sequence", 1087373320,
"identify", 1087373321,
"insertion", 1087373322,
"shape", 1087373323,
"strucid", 1087373324,
"symbol", 1087375373,
"symmetry", 1089470478,
"atomno", 1095763969,
"atomid", 1095761922,
"atomindex", 1095761923,
"bondcount", 1095761924,
"cell", 1095761925,
"configuration", 1095766022,
"elemisono", 1095761927,
"elemno", 1095763976,
"formalcharge", 1632634889,
"groupid", 1095761930,
"groupindex", 1095761931,
"model", 1095766028,
"modelindex", 1095761933,
"molecule", 1095761934,
"polymer", 1095761935,
"polymerlength", 1095761936,
"resno", 1095761937,
"site", 1095761938,
"strucno", 1095761939,
"valence", 1095763988,
"adpmax", 1112539137,
"adpmin", 1112539138,
"covalent", 1112539139,
"eta", 1112539140,
"mass", 1112539141,
"omega", 1112539142,
"phi", 1112539143,
"psi", 1112539144,
"screenx", 1112539145,
"screeny", 1112539146,
"screenz", 1112539147,
"straightness", 1112539148,
"surfacedistance", 1112539149,
"theta", 1112539150,
"unitx", 1112539151,
"unity", 1112539152,
"unitz", 1112539153,
"atomx", 1112541185,
"atomy", 1112541186,
"atomz", 1112541187,
"fracx", 1112541188,
"fracy", 1112541189,
"fracz", 1112541190,
"fux", 1112541191,
"fuy", 1112541192,
"fuz", 1112541193,
"hydrophobic", 1114638346,
"ionic", 1112541195,
"partialcharge", 1112541196,
"property", 1716520973,
"selected", 1114638350,
"temperature", 1112541199,
"vanderwaals", 1649412112,
"vectorscale", 1649410065,
"vibx", 1112541202,
"viby", 1112541203,
"vibz", 1112541204,
"x", 1112541205,
"y", 1112541206,
"z", 1112541207,
"backbone", 1115297793,
"cartoon", 1113200642,
"dots", 1113198595,
"ellipsoid", 1113198596,
"geosurface", 1113198597,
"halo", 1113200646,
"meshRibbon", 1113200647,
"ribbon", 1113200649,
"rocket", 1113200650,
"spacefill", 1113200651,
"star", 1113200652,
"strands", 1650071565,
"trace", 1113200654,
"angle", 135266305,
"array", 135266306,
"axisangle", 135266307,
"color", 1766856708,
"compare", 135270405,
"connected", 135266310,
"data", 135270407,
"format", 1288701960,
"$function", 135368713,
"getproperty", 135270410,
"label", 1826248715,
"helix", 137363468,
"measure", 1746538509,
"now", 135266318,
"plane", 135266319,
"point", 135266320,
"quaternion", 135270417,
"sort", 1276117010,
"count", 1276117011,
"within", 135266324,
"write", 135270421,
"cache", 135270422,
"acos", 135266819,
"sin", 135266820,
"cos", 135266821,
"sqrt", 135266822,
"file", 1229984263,
"forcmd", 135369224,
"ifcmd", 135369225,
"abs", 135266826,
"javascript", 135287308,
"div", 1276117504,
"dot", 1276117505,
"join", 1276117506,
"mul", 1276117507,
"split", 1276117508,
"sub", 1276117509,
"trim", 1276117510,
"volume", 1313866247,
"col", 1276117512,
"row", 1276117513,
"cross", 135267329,
"load", 135271426,
"random", 135267332,
"script", 135271429,
"substructure", 1238369286,
"search", 135267335,
"smiles", 135267336,
"contact", 135402505,
"add", 1276118017,
"distance", 1276118018,
"find", 1276118532,
"replace", 1276118019,
"hkl", 135267841,
"intersection", 135267842,
"prompt", 135304707,
"select", 135280132,
"bin", 1276118529,
"symop", 1297090050,
"bondmode", 1610612737,
"fontsize", 1610612738,
"measurementnumbers", 1610612739,
"scale3d", 1610612740,
"togglelabel", 1610612741,
"backgroundmodel", 536870914,
"debug", 536870916,
"defaultlattice", 536870918,
"highlight", 536870920,
"showscript", 536870922,
"specular", 536870924,
"trajectory", 536870926,
"undo", 536870928,
"usercolorscheme", 536870930,
"appletproxy", 545259522,
"atomtypes", 545259524,
"axescolor", 545259526,
"axis1color", 545259528,
"axis2color", 545259530,
"axis3color", 545259532,
"backgroundcolor", 545259534,
"boundboxcolor", 545259536,
"currentlocalpath", 545259538,
"dataseparator", 545259540,
"defaultanglelabel", 545259542,
"defaultlabelpdb", 545259543,
"defaultlabelxyz", 545259544,
"defaultcolorscheme", 545259545,
"defaultdirectory", 545259546,
"defaultdistancelabel", 545259547,
"defaultdropscript", 545259548,
"defaultloadfilter", 545259549,
"defaultloadscript", 545259550,
"defaults", 545259552,
"defaulttorsionlabel", 545259554,
"defaultvdw", 545259555,
"edsurlcutoff", 545259556,
"edsurlformat", 545259557,
"energyunits", 545259558,
"filecachedirectory", 545259559,
"forcefield", 545259560,
"helppath", 545259561,
"hoverlabel", 545259562,
"language", 545259564,
"loadformat", 545259565,
"loadligandformat", 545259566,
"logfile", 545259567,
"measurementunits", 545259568,
"nmrurlformat", 545259569,
"pathforallfiles", 545259570,
"picking", 545259572,
"pickingstyle", 545259574,
"picklabel", 545259576,
"propertycolorscheme", 545259578,
"quaternionframe", 545259580,
"smilesurlformat", 545259582,
"smiles2dimageformat", 545259584,
"unitcellcolor", 545259586,
"axesscale", 570425346,
"bondtolerance", 570425348,
"cameradepth", 570425350,
"defaultdrawarrowscale", 570425352,
"defaulttranslucent", 570425354,
"dipolescale", 570425356,
"ellipsoidaxisdiameter", 570425358,
"gestureswipefactor", 570425359,
"hbondsangleminimum", 570425360,
"hbondsdistancemaximum", 570425361,
"hoverdelay", 570425362,
"loadatomdatatolerance", 570425363,
"minbonddistance", 570425364,
"minimizationcriterion", 570425365,
"mousedragfactor", 570425366,
"mousewheelfactor", 570425367,
"multiplebondradiusfactor", 570425368,
"multiplebondspacing", 570425369,
"navfps", 570425370,
"navigationdepth", 570425371,
"navigationslab", 570425372,
"navigationspeed", 570425374,
"navx", 570425376,
"navy", 570425378,
"navz", 570425380,
"pointgroupdistancetolerance", 570425382,
"pointgrouplineartolerance", 570425384,
"rotationradius", 570425388,
"scaleangstromsperinch", 570425390,
"sheetsmoothing", 570425392,
"slabrange", 570425393,
"solventproberadius", 570425394,
"spinfps", 570425396,
"spinx", 570425398,
"spiny", 570425400,
"spinz", 570425402,
"stereodegrees", 570425404,
"strutdefaultradius", 570425406,
"strutlengthmaximum", 570425408,
"vibrationperiod", 570425412,
"vibrationscale", 570425414,
"visualrange", 570425416,
"ambientpercent", 553648130,
"animationfps", 553648132,
"axesmode", 553648134,
"bondradiusmilliangstroms", 553648136,
"delaymaximumms", 553648138,
"diffusepercent", 553648142,
"dotdensity", 553648143,
"dotscale", 553648144,
"ellipsoiddotcount", 553648145,
"helixstep", 553648146,
"hermitelevel", 553648147,
"historylevel", 553648148,
"isosurfacepropertysmoothingpower", 553648149,
"loglevel", 553648150,
"meshscale", 553648151,
"minimizationsteps", 553648152,
"minpixelselradius", 553648153,
"percentvdwatom", 553648154,
"perspectivemodel", 553648155,
"phongexponent", 553648156,
"pickingspinrate", 553648158,
"propertyatomnumberfield", 553648159,
"propertyatomnumbercolumncount", 553648160,
"propertydatacolumncount", 553648162,
"propertydatafield", 553648164,
"repaintwaitms", 553648165,
"ribbonaspectratio", 553648166,
"scriptreportinglevel", 553648168,
"smallmoleculemaxatoms", 553648170,
"specularexponent", 553648172,
"specularpercent", 553648174,
"specularpower", 553648176,
"strandcount", 553648178,
"strandcountformeshribbon", 553648180,
"strandcountforstrands", 553648182,
"strutspacing", 553648184,
"zdepth", 553648186,
"zslab", 553648188,
"zshadepower", 553648190,
"allowembeddedscripts", 603979778,
"allowgestures", 603979780,
"allowkeystrokes", 603979781,
"allowmodelkit", 603979782,
"allowmoveatoms", 603979783,
"allowmultitouch", 603979784,
"allowrotateselected", 603979785,
"antialiasdisplay", 603979786,
"antialiasimages", 603979788,
"antialiastranslucent", 603979790,
"appendnew", 603979792,
"applysymmetrytobonds", 603979794,
"atompicking", 603979796,
"autobond", 603979798,
"autofps", 603979800,
"axesmolecular", 603979804,
"axesorientationrasmol", 603979806,
"axesunitcell", 603979808,
"axeswindow", 603979810,
"bondmodeor", 603979812,
"bondpicking", 603979814,
"cartoonbaseedges", 603979818,
"cartoonrockets", 603979819,
"cartoonfancy", 603979820,
"chaincasesensitive", 603979821,
"colorrasmol", 603979822,
"debugscript", 603979824,
"defaultstructuredssp", 603979825,
"disablepopupmenu", 603979826,
"displaycellparameters", 603979828,
"dotsselectedonly", 603979829,
"dotsurface", 603979830,
"dragselected", 603979831,
"drawhover", 603979832,
"drawpicking", 603979833,
"dsspcalchydrogen", 603979834,
"dynamicmeasurements", 603979835,
"ellipsoidarcs", 603979836,
"ellipsoidaxes", 603979837,
"ellipsoidball", 603979838,
"ellipsoiddots", 603979839,
"ellipsoidfill", 603979840,
"filecaching", 603979842,
"fontcaching", 603979844,
"fontscaling", 603979845,
"forceautobond", 603979846,
"fractionalrelative", 603979848,
"greyscalerendering", 603979850,
"hbondsbackbone", 603979852,
"hbondsrasmol", 603979853,
"hbondssolid", 603979854,
"hidenameinpopup", 603979858,
"hidenavigationpoint", 603979860,
"hidenotselected", 603979862,
"highresolution", 603979864,
"imagestate", 603979868,
"iskiosk", 603979869,
"isosurfacekey", 603979870,
"isosurfacepropertysmoothing", 603979871,
"justifymeasurements", 603979872,
"languagetranslation", 603979873,
"legacyautobonding", 603979874,
"logcommands", 603979875,
"loggestures", 603979876,
"measureallmodels", 603979877,
"measurementlabels", 603979878,
"messagestylechime", 603979879,
"minimizationrefresh", 603979880,
"minimizationsilent", 603979881,
"modelkitmode", 603979882,
"monitorenergy", 603979883,
"multiprocessor", 603979884,
"navigatesurface", 603979885,
"navigationmode", 603979886,
"navigationperiodic", 603979887,
"partialdots", 603979888,
"pdbaddhydrogens", 603979889,
"pdbgetheader", 603979890,
"pdbsequential", 603979891,
"perspectivedepth", 603979892,
"preservestate", 603979893,
"rangeselected", 603979894,
"refreshing", 603979896,
"ribbonborder", 603979898,
"rocketbarrels", 603979900,
"saveproteinstructurestate", 603979902,
"scriptqueue", 603979904,
"selectallmodels", 603979906,
"selecthetero", 603979908,
"selecthydrogen", 603979910,
"showaxes", 603979914,
"showboundbox", 603979916,
"showfrank", 603979918,
"showhiddenselectionhalos", 603979920,
"showhydrogens", 603979922,
"showkeystrokes", 603979924,
"showmeasurements", 603979926,
"showmultiplebonds", 603979928,
"shownavigationpointalways", 603979930,
"showtiming", 603979934,
"showunitcell", 603979936,
"slabbyatom", 603979938,
"slabbymolecule", 603979940,
"slabenabled", 603979942,
"smartaromatic", 603979944,
"solventprobe", 603979948,
"ssbondsbackbone", 603979952,
"statusreporting", 603979954,
"strutsmultiple", 603979955,
"syncmouse", 603979956,
"syncscript", 603979958,
"testflag1", 603979960,
"testflag2", 603979962,
"testflag3", 603979964,
"testflag4", 603979966,
"tracealpha", 603979967,
"usearcball", 603979969,
"useminimizationthread", 603979970,
"usenumberlocalization", 603979972,
"vectorsymmetry", 603979973,
"waitformoveto", 603979974,
"windowcentered", 603979975,
"wireframerotation", 603979976,
"zerobasedxyzrasmol", 603979978,
"zoomenabled", 603979980,
"zoomlarge", 603979982,
"zshade", 603979984,
"absolute", 1073741826,
"addhydrogens", 1073741828,
"adjust", 1073741830,
"align", 1073741832,
"allconnected", 1073741834,
"angstroms", 1073741836,
"anisotropy", 1073741838,
"append", 1073741839,
"arc", 1074790416,
"area", 1073741842,
"aromatic", 1076887572,
"arrow", 1073741846,
"as", 1073741848,
"atomicorbital", 1073741850,
"auto", 1073741852,
"axis", 1073741854,
"babel", 1073741856,
"babel21", 1073741858,
"back", 1073741860,
"barb", 1073741861,
"backlit", 1073741862,
"basepair", 1073741864,
"binary", 1073741866,
"blockdata", 1073741868,
"bondset", 1073741870,
"bottom", 1073741871,
"brillouin", 1073741872,
"cancel", 1073741874,
"cap", 1074790451,
"cavity", 1073741876,
"centroid", 1073741877,
"check", 1073741878,
"chemical", 1073741879,
"circle", 1073741880,
"clash", 1073741881,
"clear", 1073741882,
"clipboard", 1073741884,
"collapsed", 1073741886,
"colorscheme", 1073741888,
"command", 1073741890,
"commands", 1073741892,
"constraint", 1073741894,
"contour", 1073741896,
"contourlines", 1073741898,
"contours", 1073741900,
"corners", 1073741902,
"create", 1073741904,
"criterion", 1073741905,
"crossed", 1073741906,
"curve", 1073741908,
"cutoff", 1073741910,
"cylinder", 1073741912,
"density", 1073741914,
"dssp", 1073741915,
"diameter", 1073741916,
"direction", 1073741918,
"discrete", 1073741920,
"displacement", 1073741922,
"distancefactor", 1073741924,
"dotted", 1073741926,
"downsample", 1073741928,
"drawing", 1073741929,
"eccentricity", 1073741930,
"ed", 1074790508,
"edges", 1073741934,
"energy", 1073741935,
"error", 1073741936,
"facecenteroffset", 1073741937,
"fill", 1073741938,
"filter", 1073741940,
"first", 1073741942,
"fixedtemp", 1073741946,
"flat", 1073741948,
"fps", 1074790526,
"from", 1073741952,
"front", 1073741954,
"frontedges", 1073741956,
"frontlit", 1073741958,
"frontonly", 1073741960,
"full", 1073741961,
"fullplane", 1073741962,
"fullylit", 1073741964,
"functionxy", 1073741966,
"functionxyz", 1073741968,
"gridpoints", 1073741970,
"homo", 1073741973,
"id", 1074790550,
"ignore", 1073741976,
"inchi", 1073741977,
"inchikey", 1073741978,
"image", 1073741979,
"$in", 1073741980,
"increment", 1073741981,
"info", 1073741982,
"inline", 1073741983,
"insideout", 1073741984,
"interior", 1073741986,
"internal", 1073741988,
"intramolecular", 1073741989,
"intermolecular", 1073741990,
"jmol", 1073741992,
"last", 1073741993,
"lattice", 1073741994,
"lighting", 1073741995,
"left", 1073741996,
"line", 1073741998,
"link", 1073741999,
"linedata", 1073742000,
"list", 1073742001,
"lobe", 1073742002,
"lonepair", 1073742004,
"lp", 1073742006,
"lumo", 1073742008,
"manifest", 1073742010,
"maxset", 1073742014,
"menu", 1073742015,
"mep", 1073742016,
"mesh", 1073742018,
"middle", 1073742019,
"minset", 1073742020,
"mlp", 1073742022,
"mode", 1073742024,
"modify", 1073742025,
"modifyorcreate", 1073742026,
"modelbased", 1073742028,
"molecular", 1073742030,
"monomer", 1073742032,
"mrc", 1073742033,
"msms", 1073742034,
"name", 1073742035,
"nci", 1073742036,
"next", 1073742037,
"nmr", 1073742038,
"nocontourlines", 1073742039,
"nocross", 1073742040,
"nodebug", 1073742041,
"nodots", 1073742042,
"noedges", 1073742044,
"nofill", 1073742046,
"nohead", 1073742048,
"noload", 1073742050,
"nomesh", 1073742052,
"noplane", 1073742054,
"normal", 1073742056,
"notfrontonly", 1073742058,
"notriangles", 1073742060,
"obj", 1073742062,
"object", 1073742064,
"offset", 1073742066,
"offsetside", 1073742068,
"once", 1073742070,
"only", 1073742072,
"opaque", 1073742074,
"orbital", 1073742076,
"orientation", 1073742077,
"origin", 1073742078,
"out", 1073742079,
"packed", 1073742080,
"palindrome", 1073742082,
"parameters", 1073742083,
"path", 1073742084,
"pdb", 1074790662,
"pdbheader", 1073742088,
"period", 1073742090,
"perpendicular", 1073742092,
"phase", 1073742094,
"play", 1073742096,
"playrev", 1073742098,
"pocket", 1073742100,
"pointgroup", 1073742102,
"pointsperangstrom", 1073742104,
"polygon", 1073742106,
"prev", 1073742108,
"probe", 1073742109,
"rad", 1073742110,
"radical", 1073742112,
"range", 1073742114,
"rasmol", 1073742116,
"reference", 1073742118,
"remove", 1073742119,
"residue", 1073742120,
"resolution", 1073742122,
"reversecolor", 1073742124,
"rewind", 1073742126,
"right", 1073742128,
"rotate45", 1073742130,
"rotation", 1073742132,
"rubberband", 1073742134,
"sasurface", 1073742136,
"scale", 1073742138,
"scene", 1073742139,
"selection", 1073742140,
"shapely", 1073742144,
"sigma", 1073742146,
"sign", 1073742147,
"silent", 1073742148,
"solid", 1073742150,
"spacegroup", 1073742152,
"sphere", 1073742154,
"squared", 1073742156,
"state", 1073742158,
"stop", 1073742162,
"supercell", 1073742163,
"ticks", 1073742164,
"title", 1073742166,
"titleformat", 1073742168,
"to", 1074790746,
"top", 1074790748,
"torsion", 1073742174,
"transform", 1073742176,
"translation", 1073742178,
"translucent", 1073742180,
"triangles", 1073742182,
"url", 1074790760,
"user", 1073742186,
"val", 1073742188,
"variable", 1073742190,
"variables", 1073742192,
"vertices", 1073742194,
"spacebeforesquare", 1073742195,
"width", 1073742196);
c$.tokenSpaceBeforeSquare = c$.prototype.tokenSpaceBeforeSquare = org.jmol.script.Token.newTokenObj (1073742195, " ");
c$.tokenOn = c$.prototype.tokenOn = org.jmol.script.Token.newTokenIntVal (1048589, 1, "on");
c$.tokenOff = c$.prototype.tokenOff = org.jmol.script.Token.newTokenIntVal (1048588, 0, "off");
c$.tokenAll = c$.prototype.tokenAll = org.jmol.script.Token.newTokenObj (1048579, "all");
c$.tokenIf = c$.prototype.tokenIf = org.jmol.script.Token.newTokenObj (135369225, "if");
c$.tokenAnd = c$.prototype.tokenAnd = org.jmol.script.Token.newTokenObj (269484128, "and");
c$.tokenAND = c$.prototype.tokenAND = org.jmol.script.Token.newTokenObj (269484160, "");
c$.tokenOr = c$.prototype.tokenOr = org.jmol.script.Token.newTokenObj (269484112, "or");
c$.tokenAndFALSE = c$.prototype.tokenAndFALSE = org.jmol.script.Token.newTokenObj (269484128, "and");
c$.tokenOrTRUE = c$.prototype.tokenOrTRUE = org.jmol.script.Token.newTokenObj (269484112, "or");
c$.tokenOpIf = c$.prototype.tokenOpIf = org.jmol.script.Token.newTokenObj (806354977, "?");
c$.tokenComma = c$.prototype.tokenComma = org.jmol.script.Token.newTokenObj (269484080, ",");
c$.tokenDefineString = c$.prototype.tokenDefineString = org.jmol.script.Token.newTokenIntVal (1060866, 4, "@");
c$.tokenPlus = c$.prototype.tokenPlus = org.jmol.script.Token.newTokenObj (269484193, "+");
c$.tokenMinus = c$.prototype.tokenMinus = org.jmol.script.Token.newTokenObj (269484192, "-");
c$.tokenTimes = c$.prototype.tokenTimes = org.jmol.script.Token.newTokenObj (269484209, "*");
c$.tokenDivide = c$.prototype.tokenDivide = org.jmol.script.Token.newTokenObj (269484208, "/");
c$.tokenLeftParen = c$.prototype.tokenLeftParen = org.jmol.script.Token.newTokenObj (269484048, "(");
c$.tokenRightParen = c$.prototype.tokenRightParen = org.jmol.script.Token.newTokenObj (269484049, ")");
c$.tokenArraySquare = c$.prototype.tokenArraySquare = org.jmol.script.Token.newTokenObj (135266306, "[");
c$.tokenArraySelector = c$.prototype.tokenArraySelector = org.jmol.script.Token.newTokenObj (269484096, "[");
c$.tokenExpressionBegin = c$.prototype.tokenExpressionBegin = org.jmol.script.Token.newTokenObj (1048577, "expressionBegin");
c$.tokenExpressionEnd = c$.prototype.tokenExpressionEnd = org.jmol.script.Token.newTokenObj (1048578, "expressionEnd");
c$.tokenConnected = c$.prototype.tokenConnected = org.jmol.script.Token.newTokenObj (135266310, "connected");
c$.tokenCoordinateBegin = c$.prototype.tokenCoordinateBegin = org.jmol.script.Token.newTokenObj (1048586, "{");
c$.tokenRightBrace = c$.prototype.tokenRightBrace = org.jmol.script.Token.newTokenObj (1048590, "}");
c$.tokenCoordinateEnd = c$.prototype.tokenCoordinateEnd = org.jmol.script.Token.tokenRightBrace;
c$.tokenColon = c$.prototype.tokenColon = org.jmol.script.Token.newTokenObj (269484066, ":");
c$.tokenSetCmd = c$.prototype.tokenSetCmd = org.jmol.script.Token.newTokenObj (1085443, "set");
c$.tokenSet = c$.prototype.tokenSet = org.jmol.script.Token.newTokenIntVal (1085443, 61, "");
c$.tokenSetArray = c$.prototype.tokenSetArray = org.jmol.script.Token.newTokenIntVal (1085443, 91, "");
c$.tokenSetProperty = c$.prototype.tokenSetProperty = org.jmol.script.Token.newTokenIntVal (1085443, 46, "");
c$.tokenSetVar = c$.prototype.tokenSetVar = org.jmol.script.Token.newTokenIntVal (1085443, 61, "var");
c$.tokenEquals = c$.prototype.tokenEquals = org.jmol.script.Token.newTokenObj (269484436, "=");
c$.tokenScript = c$.prototype.tokenScript = org.jmol.script.Token.newTokenObj (135271429, "script");
c$.tokenSwitch = c$.prototype.tokenSwitch = org.jmol.script.Token.newTokenObj (102410, "switch");
c$.tokenMap = c$.prototype.tokenMap =  new java.util.Hashtable ();
{
var arrayPairs = ["(", org.jmol.script.Token.tokenLeftParen, ")", org.jmol.script.Token.tokenRightParen, "and", org.jmol.script.Token.tokenAnd, "&", null, "&&", null, "or", org.jmol.script.Token.tokenOr, "|", null, "||", null, "?", org.jmol.script.Token.tokenOpIf, ",", org.jmol.script.Token.tokenComma, "+=",  new org.jmol.script.Token (269484242), "-=", null, "*=", null, "/=", null, "\\=", null, "&=", null, "|=", null, "not",  new org.jmol.script.Token (269484144), "!", null, "xor",  new org.jmol.script.Token (269484113), "tog",  new org.jmol.script.Token (269484114), "<",  new org.jmol.script.Token (269484435), "<=",  new org.jmol.script.Token (269484434), ">=",  new org.jmol.script.Token (269484433), ">",  new org.jmol.script.Token (269484432), "=", org.jmol.script.Token.tokenEquals, "==", null, "!=",  new org.jmol.script.Token (269484438), "<>", null, "within",  new org.jmol.script.Token (135266324), ".",  new org.jmol.script.Token (1048584), "[",  new org.jmol.script.Token (269484096), "]",  new org.jmol.script.Token (269484097), "{",  new org.jmol.script.Token (1048586), "}",  new org.jmol.script.Token (1048590), "$",  new org.jmol.script.Token (1048583), "%",  new org.jmol.script.Token (269484210), ":", org.jmol.script.Token.tokenColon, ";",  new org.jmol.script.Token (1048591), "++",  new org.jmol.script.Token (269484226), "--",  new org.jmol.script.Token (269484225), "**",  new org.jmol.script.Token (269484227), "+", org.jmol.script.Token.tokenPlus, "-", org.jmol.script.Token.tokenMinus, "*", org.jmol.script.Token.tokenTimes, "/", org.jmol.script.Token.tokenDivide, "\\",  new org.jmol.script.Token (269484211), "animation",  new org.jmol.script.Token (4097), "anim", null, "assign",  new org.jmol.script.Token (4098), "axes",  new org.jmol.script.Token (1611272194), "backbone",  new org.jmol.script.Token (1115297793), "background",  new org.jmol.script.Token (1610616835), "bind",  new org.jmol.script.Token (4100), "bondorder",  new org.jmol.script.Token (4101), "boundbox",  new org.jmol.script.Token (1679429641), "boundingBox", null, "break",  new org.jmol.script.Token (102407), "calculate",  new org.jmol.script.Token (4102), "cartoon",  new org.jmol.script.Token (1113200642), "cartoons", null, "case",  new org.jmol.script.Token (102411), "catch",  new org.jmol.script.Token (102412), "cd",  new org.jmol.script.Token (1069064), "center",  new org.jmol.script.Token (12289), "centre", null, "centerat",  new org.jmol.script.Token (4105), "color",  new org.jmol.script.Token (1766856708), "colour", null, "compare",  new org.jmol.script.Token (135270405), "configuration",  new org.jmol.script.Token (1095766022), "conformation", null, "config", null, "connect",  new org.jmol.script.Token (4106), "console",  new org.jmol.script.Token (528395), "contact",  new org.jmol.script.Token (135402505), "contacts", null, "continue",  new org.jmol.script.Token (102408), "data",  new org.jmol.script.Token (135270407), "default",  new org.jmol.script.Token (102413), "define",  new org.jmol.script.Token (1060866), "@", null, "delay",  new org.jmol.script.Token (528397), "delete",  new org.jmol.script.Token (12291), "density",  new org.jmol.script.Token (1073741914), "depth",  new org.jmol.script.Token (554176526), "dipole",  new org.jmol.script.Token (135174), "dipoles", null, "display",  new org.jmol.script.Token (1610625028), "dot",  new org.jmol.script.Token (1276117505), "dots",  new org.jmol.script.Token (1113198595), "draw",  new org.jmol.script.Token (135176), "echo",  new org.jmol.script.Token (537022465), "ellipsoid",  new org.jmol.script.Token (1113198596), "ellipsoids", null, "else",  new org.jmol.script.Token (364547), "elseif",  new org.jmol.script.Token (102402), "end",  new org.jmol.script.Token (1150985), "endif",  new org.jmol.script.Token (364548), "exit",  new org.jmol.script.Token (266255), "file",  new org.jmol.script.Token (1229984263), "files", null, "font",  new org.jmol.script.Token (4114), "for",  new org.jmol.script.Token (135369224), "format",  new org.jmol.script.Token (1288701960), "frame",  new org.jmol.script.Token (4115), "frames", null, "frank",  new org.jmol.script.Token (1611272202), "function",  new org.jmol.script.Token (135368713), "functions", null, "geosurface",  new org.jmol.script.Token (1113198597), "getProperty",  new org.jmol.script.Token (135270410), "goto",  new org.jmol.script.Token (20500), "halo",  new org.jmol.script.Token (1113200646), "halos", null, "helix",  new org.jmol.script.Token (137363468), "helixalpha",  new org.jmol.script.Token (3145735), "helix310",  new org.jmol.script.Token (3145736), "helixpi",  new org.jmol.script.Token (3145738), "hbond",  new org.jmol.script.Token (1612189718), "hbonds", null, "help",  new org.jmol.script.Token (20482), "hide",  new org.jmol.script.Token (12294), "history",  new org.jmol.script.Token (1610616855), "hover",  new org.jmol.script.Token (544771), "if",  new org.jmol.script.Token (135369225), "in",  new org.jmol.script.Token (1073741980), "initialize",  new org.jmol.script.Token (266264), "invertSelected",  new org.jmol.script.Token (4121), "isosurface",  new org.jmol.script.Token (135180), "javascript",  new org.jmol.script.Token (135287308), "label",  new org.jmol.script.Token (1826248715), "labels", null, "lcaoCartoon",  new org.jmol.script.Token (135182), "lcaoCartoons", null, "load",  new org.jmol.script.Token (135271426), "log",  new org.jmol.script.Token (36869), "loop",  new org.jmol.script.Token (528410), "measure",  new org.jmol.script.Token (1746538509), "measures", null, "monitor", null, "monitors", null, "meshribbon",  new org.jmol.script.Token (1113200647), "meshribbons", null, "message",  new org.jmol.script.Token (20485), "minimize",  new org.jmol.script.Token (4126), "minimization", null, "mo",  new org.jmol.script.Token (1183762), "model",  new org.jmol.script.Token (1095766028), "models", null, "move",  new org.jmol.script.Token (4128), "moveTo",  new org.jmol.script.Token (4130), "navigate",  new org.jmol.script.Token (4131), "navigation", null, "origin",  new org.jmol.script.Token (1073742078), "out",  new org.jmol.script.Token (1073742079), "parallel",  new org.jmol.script.Token (102436), "pause",  new org.jmol.script.Token (20487), "wait", null, "plot",  new org.jmol.script.Token (4133), "plot3d",  new org.jmol.script.Token (135190), "pmesh",  new org.jmol.script.Token (135188), "polygon",  new org.jmol.script.Token (1073742106), "polyhedra",  new org.jmol.script.Token (135192), "print",  new org.jmol.script.Token (36865), "process",  new org.jmol.script.Token (102439), "prompt",  new org.jmol.script.Token (135304707), "quaternion",  new org.jmol.script.Token (135270417), "quaternions", null, "quit",  new org.jmol.script.Token (266281), "ramachandran",  new org.jmol.script.Token (1052714), "rama", null, "refresh",  new org.jmol.script.Token (266284), "reset",  new org.jmol.script.Token (4141), "unset", null, "restore",  new org.jmol.script.Token (4142), "restrict",  new org.jmol.script.Token (12295), "return",  new org.jmol.script.Token (36866), "ribbon",  new org.jmol.script.Token (1113200649), "ribbons", null, "rocket",  new org.jmol.script.Token (1113200650), "rockets", null, "rotate",  new org.jmol.script.Token (528432), "rotateSelected",  new org.jmol.script.Token (4145), "save",  new org.jmol.script.Token (4146), "script", org.jmol.script.Token.tokenScript, "source", null, "select",  new org.jmol.script.Token (135280132), "selectionHalos",  new org.jmol.script.Token (1611141171), "selectionHalo", null, "showSelections", null, "set", org.jmol.script.Token.tokenSetCmd, "sheet",  new org.jmol.script.Token (3145760), "show",  new org.jmol.script.Token (4148), "slab",  new org.jmol.script.Token (554176565), "spacefill",  new org.jmol.script.Token (1113200651), "cpk", null, "spin",  new org.jmol.script.Token (1611141175), "ssbond",  new org.jmol.script.Token (1611141176), "ssbonds", null, "star",  new org.jmol.script.Token (1113200652), "stars", null, "step",  new org.jmol.script.Token (266298), "steps", null, "stereo",  new org.jmol.script.Token (528443), "strand",  new org.jmol.script.Token (1650071565), "strands", null, "structure",  new org.jmol.script.Token (1641025539), "_structure", null, "strucNo",  new org.jmol.script.Token (1095761939), "struts",  new org.jmol.script.Token (1708058), "strut", null, "subset",  new org.jmol.script.Token (3158024), "switch", org.jmol.script.Token.tokenSwitch, "synchronize",  new org.jmol.script.Token (4156), "sync", null, "trace",  new org.jmol.script.Token (1113200654), "translate",  new org.jmol.script.Token (4160), "translateSelected",  new org.jmol.script.Token (4162), "try",  new org.jmol.script.Token (364558), "unbind",  new org.jmol.script.Token (4164), "unitcell",  new org.jmol.script.Token (1614417948), "var",  new org.jmol.script.Token (36868), "vector",  new org.jmol.script.Token (135198), "vectors", null, "vibration",  new org.jmol.script.Token (4166), "while",  new org.jmol.script.Token (102406), "wireframe",  new org.jmol.script.Token (659488), "write",  new org.jmol.script.Token (135270421), "zap",  new org.jmol.script.Token (1060873), "zoom",  new org.jmol.script.Token (4168), "zoomTo",  new org.jmol.script.Token (4170), "atom",  new org.jmol.script.Token (1141899265), "atoms", null, "axis",  new org.jmol.script.Token (1073741854), "axisangle",  new org.jmol.script.Token (135266307), "basepair",  new org.jmol.script.Token (1073741864), "basepairs", null, "orientation",  new org.jmol.script.Token (1073742077), "orientations", null, "pdbheader",  new org.jmol.script.Token (1073742088), "polymer",  new org.jmol.script.Token (1095761935), "polymers", null, "residue",  new org.jmol.script.Token (1073742120), "residues", null, "rotation",  new org.jmol.script.Token (1073742132), "row",  new org.jmol.script.Token (1276117513), "sequence",  new org.jmol.script.Token (1087373320), "shape",  new org.jmol.script.Token (1087373323), "state",  new org.jmol.script.Token (1073742158), "symbol",  new org.jmol.script.Token (1087375373), "symmetry",  new org.jmol.script.Token (1089470478), "spaceGroup",  new org.jmol.script.Token (1073742152), "transform",  new org.jmol.script.Token (1073742176), "translation",  new org.jmol.script.Token (1073742178), "url",  new org.jmol.script.Token (1074790760), "abs",  new org.jmol.script.Token (135266826), "absolute",  new org.jmol.script.Token (1073741826), "acos",  new org.jmol.script.Token (135266819), "add",  new org.jmol.script.Token (1276118017), "adpmax",  new org.jmol.script.Token (1112539137), "adpmin",  new org.jmol.script.Token (1112539138), "align",  new org.jmol.script.Token (1073741832), "all", org.jmol.script.Token.tokenAll, "altloc",  new org.jmol.script.Token (1087373315), "altlocs", null, "amino",  new org.jmol.script.Token (3145730), "angle",  new org.jmol.script.Token (135266305), "array",  new org.jmol.script.Token (135266306), "as",  new org.jmol.script.Token (1073741848), "atomID",  new org.jmol.script.Token (1095761922), "_atomID", null, "_a", null, "atomIndex",  new org.jmol.script.Token (1095761923), "atomName",  new org.jmol.script.Token (1087375362), "atomno",  new org.jmol.script.Token (1095763969), "atomType",  new org.jmol.script.Token (1087375361), "atomX",  new org.jmol.script.Token (1112541185), "atomY",  new org.jmol.script.Token (1112541186), "atomZ",  new org.jmol.script.Token (1112541187), "average",  new org.jmol.script.Token (96), "babel",  new org.jmol.script.Token (1073741856), "babel21",  new org.jmol.script.Token (1073741858), "back",  new org.jmol.script.Token (1073741860), "backlit",  new org.jmol.script.Token (1073741862), "baseModel",  new org.jmol.script.Token (3145776), "bin",  new org.jmol.script.Token (1276118529), "bondCount",  new org.jmol.script.Token (1095761924), "bottom",  new org.jmol.script.Token (1073741871), "branch",  new org.jmol.script.Token (1048580), "brillouin",  new org.jmol.script.Token (1073741872), "bzone", null, "wignerSeitz", null, "cache",  new org.jmol.script.Token (135270422), "carbohydrate",  new org.jmol.script.Token (3145764), "cell",  new org.jmol.script.Token (1095761925), "chain",  new org.jmol.script.Token (1087373316), "chains", null, "clash",  new org.jmol.script.Token (1073741881), "clear",  new org.jmol.script.Token (1073741882), "clickable",  new org.jmol.script.Token (3145766), "clipboard",  new org.jmol.script.Token (1073741884), "connected",  new org.jmol.script.Token (135266310), "constraint",  new org.jmol.script.Token (1073741894), "contourLines",  new org.jmol.script.Token (1073741898), "coord",  new org.jmol.script.Token (1048582), "coordinates", null, "coords", null, "cos",  new org.jmol.script.Token (135266821), "cross",  new org.jmol.script.Token (135267329), "covalent",  new org.jmol.script.Token (1112539139), "direction",  new org.jmol.script.Token (1073741918), "displacement",  new org.jmol.script.Token (1073741922), "displayed",  new org.jmol.script.Token (3145768), "distance",  new org.jmol.script.Token (1276118018), "div",  new org.jmol.script.Token (1276117504), "DNA",  new org.jmol.script.Token (3145732), "dotted",  new org.jmol.script.Token (1073741926), "DSSP",  new org.jmol.script.Token (1073741915), "element",  new org.jmol.script.Token (1087375365), "elemno",  new org.jmol.script.Token (1095763976), "_e",  new org.jmol.script.Token (1095761927), "error",  new org.jmol.script.Token (1073741936), "fill",  new org.jmol.script.Token (1073741938), "find",  new org.jmol.script.Token (1276118532), "fixedTemperature",  new org.jmol.script.Token (1073741946), "forcefield",  new org.jmol.script.Token (545259560), "formalCharge",  new org.jmol.script.Token (1632634889), "charge", null, "eta",  new org.jmol.script.Token (1112539140), "front",  new org.jmol.script.Token (1073741954), "frontlit",  new org.jmol.script.Token (1073741958), "frontOnly",  new org.jmol.script.Token (1073741960), "fullylit",  new org.jmol.script.Token (1073741964), "fx",  new org.jmol.script.Token (1112541188), "fy",  new org.jmol.script.Token (1112541189), "fz",  new org.jmol.script.Token (1112541190), "fxyz",  new org.jmol.script.Token (1146095627), "fux",  new org.jmol.script.Token (1112541191), "fuy",  new org.jmol.script.Token (1112541192), "fuz",  new org.jmol.script.Token (1112541193), "fuxyz",  new org.jmol.script.Token (1146095629), "group",  new org.jmol.script.Token (1087373318), "groups", null, "group1",  new org.jmol.script.Token (1087373319), "groupID",  new org.jmol.script.Token (1095761930), "_groupID", null, "_g", null, "groupIndex",  new org.jmol.script.Token (1095761931), "hidden",  new org.jmol.script.Token (3145770), "highlight",  new org.jmol.script.Token (536870920), "hkl",  new org.jmol.script.Token (135267841), "hydrophobic",  new org.jmol.script.Token (1114638346), "hydrophobicity", null, "hydro", null, "id",  new org.jmol.script.Token (1074790550), "identify",  new org.jmol.script.Token (1087373321), "ident", null, "image",  new org.jmol.script.Token (1073741979), "info",  new org.jmol.script.Token (1073741982), "inline",  new org.jmol.script.Token (1073741983), "insertion",  new org.jmol.script.Token (1087373322), "insertions", null, "intramolecular",  new org.jmol.script.Token (1073741989), "intra", null, "intermolecular",  new org.jmol.script.Token (1073741990), "inter", null, "ionic",  new org.jmol.script.Token (1112541195), "ionicRadius", null, "isAromatic",  new org.jmol.script.Token (1048585), "Jmol",  new org.jmol.script.Token (1073741992), "join",  new org.jmol.script.Token (1276117506), "keys",  new org.jmol.script.Token (1141899281), "last",  new org.jmol.script.Token (1073741993), "left",  new org.jmol.script.Token (1073741996), "length",  new org.jmol.script.Token (1141899267), "lines",  new org.jmol.script.Token (1141899268), "list",  new org.jmol.script.Token (1073742001), "mass",  new org.jmol.script.Token (1112539141), "max",  new org.jmol.script.Token (64), "mep",  new org.jmol.script.Token (1073742016), "mesh",  new org.jmol.script.Token (1073742018), "middle",  new org.jmol.script.Token (1073742019), "min",  new org.jmol.script.Token (32), "mlp",  new org.jmol.script.Token (1073742022), "mode",  new org.jmol.script.Token (1073742024), "modify",  new org.jmol.script.Token (1073742025), "modifyOrCreate",  new org.jmol.script.Token (1073742026), "molecule",  new org.jmol.script.Token (1095761934), "molecules", null, "modelIndex",  new org.jmol.script.Token (1095761933), "monomer",  new org.jmol.script.Token (1073742032), "mul",  new org.jmol.script.Token (1276117507), "nci",  new org.jmol.script.Token (1073742036), "next",  new org.jmol.script.Token (1073742037), "noDots",  new org.jmol.script.Token (1073742042), "noFill",  new org.jmol.script.Token (1073742046), "noMesh",  new org.jmol.script.Token (1073742052), "none",  new org.jmol.script.Token (1048587), "null", null, "inherit", null, "normal",  new org.jmol.script.Token (1073742056), "noContourLines",  new org.jmol.script.Token (1073742039), "notFrontOnly",  new org.jmol.script.Token (1073742058), "noTriangles",  new org.jmol.script.Token (1073742060), "now",  new org.jmol.script.Token (135266318), "nucleic",  new org.jmol.script.Token (3145742), "occupancy",  new org.jmol.script.Token (1129318401), "off", org.jmol.script.Token.tokenOff, "false", null, "on", org.jmol.script.Token.tokenOn, "true", null, "omega",  new org.jmol.script.Token (1112539142), "only",  new org.jmol.script.Token (1073742072), "opaque",  new org.jmol.script.Token (1073742074), "partialCharge",  new org.jmol.script.Token (1112541196), "phi",  new org.jmol.script.Token (1112539143), "plane",  new org.jmol.script.Token (135266319), "planar", null, "play",  new org.jmol.script.Token (1073742096), "playRev",  new org.jmol.script.Token (1073742098), "point",  new org.jmol.script.Token (135266320), "points", null, "pointGroup",  new org.jmol.script.Token (1073742102), "polymerLength",  new org.jmol.script.Token (1095761936), "previous",  new org.jmol.script.Token (1073742108), "prev", null, "probe",  new org.jmol.script.Token (1073742109), "property",  new org.jmol.script.Token (1716520973), "properties", null, "protein",  new org.jmol.script.Token (3145744), "psi",  new org.jmol.script.Token (1112539144), "purine",  new org.jmol.script.Token (3145746), "pyrimidine",  new org.jmol.script.Token (3145748), "random",  new org.jmol.script.Token (135267332), "range",  new org.jmol.script.Token (1073742114), "rasmol",  new org.jmol.script.Token (1073742116), "replace",  new org.jmol.script.Token (1276118019), "resno",  new org.jmol.script.Token (1095761937), "resume",  new org.jmol.script.Token (266287), "rewind",  new org.jmol.script.Token (1073742126), "reverse",  new org.jmol.script.Token (1141899269), "right",  new org.jmol.script.Token (1073742128), "RNA",  new org.jmol.script.Token (3145750), "rubberband",  new org.jmol.script.Token (1073742134), "saSurface",  new org.jmol.script.Token (1073742136), "scale",  new org.jmol.script.Token (1073742138), "scene",  new org.jmol.script.Token (1073742139), "search",  new org.jmol.script.Token (135267335), "smarts", null, "selected",  new org.jmol.script.Token (1114638350), "shapely",  new org.jmol.script.Token (1073742144), "sidechain",  new org.jmol.script.Token (3145754), "sin",  new org.jmol.script.Token (135266820), "site",  new org.jmol.script.Token (1095761938), "size",  new org.jmol.script.Token (1141899270), "smiles",  new org.jmol.script.Token (135267336), "substructure",  new org.jmol.script.Token (1238369286), "solid",  new org.jmol.script.Token (1073742150), "sort",  new org.jmol.script.Token (1276117010), "specialPosition",  new org.jmol.script.Token (3145772), "sqrt",  new org.jmol.script.Token (135266822), "split",  new org.jmol.script.Token (1276117508), "stddev",  new org.jmol.script.Token (192), "straightness",  new org.jmol.script.Token (1112539148), "structureId",  new org.jmol.script.Token (1087373324), "supercell",  new org.jmol.script.Token (1073742163), "sub",  new org.jmol.script.Token (1276117509), "sum",  new org.jmol.script.Token (128), "sum2",  new org.jmol.script.Token (160), "surface",  new org.jmol.script.Token (3145756), "surfaceDistance",  new org.jmol.script.Token (1112539149), "symop",  new org.jmol.script.Token (1297090050), "sx",  new org.jmol.script.Token (1112539145), "sy",  new org.jmol.script.Token (1112539146), "sz",  new org.jmol.script.Token (1112539147), "sxyz",  new org.jmol.script.Token (1146095628), "temperature",  new org.jmol.script.Token (1112541199), "relativeTemperature", null, "theta",  new org.jmol.script.Token (1112539150), "thisModel",  new org.jmol.script.Token (3145758), "ticks",  new org.jmol.script.Token (1073742164), "top",  new org.jmol.script.Token (1074790748), "torsion",  new org.jmol.script.Token (1073742174), "trajectory",  new org.jmol.script.Token (536870926), "trajectories", null, "translucent",  new org.jmol.script.Token (1073742180), "triangles",  new org.jmol.script.Token (1073742182), "trim",  new org.jmol.script.Token (1276117510), "type",  new org.jmol.script.Token (1141899272), "ux",  new org.jmol.script.Token (1112539151), "uy",  new org.jmol.script.Token (1112539152), "uz",  new org.jmol.script.Token (1112539153), "uxyz",  new org.jmol.script.Token (1146093582), "user",  new org.jmol.script.Token (1073742186), "valence",  new org.jmol.script.Token (1095763988), "vanderWaals",  new org.jmol.script.Token (1649412112), "vdw", null, "vdwRadius", null, "visible",  new org.jmol.script.Token (3145774), "volume",  new org.jmol.script.Token (1313866247), "vx",  new org.jmol.script.Token (1112541202), "vy",  new org.jmol.script.Token (1112541203), "vz",  new org.jmol.script.Token (1112541204), "vxyz",  new org.jmol.script.Token (1146095631), "xyz",  new org.jmol.script.Token (1146095626), "w",  new org.jmol.script.Token (1141899280), "x",  new org.jmol.script.Token (1112541205), "y",  new org.jmol.script.Token (1112541206), "z",  new org.jmol.script.Token (1112541207), "addHydrogens",  new org.jmol.script.Token (1073741828), "allConnected",  new org.jmol.script.Token (1073741834), "angstroms",  new org.jmol.script.Token (1073741836), "anisotropy",  new org.jmol.script.Token (1073741838), "append",  new org.jmol.script.Token (1073741839), "arc",  new org.jmol.script.Token (1074790416), "area",  new org.jmol.script.Token (1073741842), "aromatic",  new org.jmol.script.Token (1076887572), "arrow",  new org.jmol.script.Token (1073741846), "auto",  new org.jmol.script.Token (1073741852), "barb",  new org.jmol.script.Token (1073741861), "binary",  new org.jmol.script.Token (1073741866), "blockData",  new org.jmol.script.Token (1073741868), "cancel",  new org.jmol.script.Token (1073741874), "cap",  new org.jmol.script.Token (1074790451), "cavity",  new org.jmol.script.Token (1073741876), "centroid",  new org.jmol.script.Token (1073741877), "check",  new org.jmol.script.Token (1073741878), "chemical",  new org.jmol.script.Token (1073741879), "circle",  new org.jmol.script.Token (1073741880), "collapsed",  new org.jmol.script.Token (1073741886), "col",  new org.jmol.script.Token (1276117512), "colorScheme",  new org.jmol.script.Token (1073741888), "command",  new org.jmol.script.Token (1073741890), "commands",  new org.jmol.script.Token (1073741892), "contour",  new org.jmol.script.Token (1073741896), "contours",  new org.jmol.script.Token (1073741900), "corners",  new org.jmol.script.Token (1073741902), "count",  new org.jmol.script.Token (1276117011), "criterion",  new org.jmol.script.Token (1073741905), "create",  new org.jmol.script.Token (1073741904), "crossed",  new org.jmol.script.Token (1073741906), "curve",  new org.jmol.script.Token (1073741908), "cutoff",  new org.jmol.script.Token (1073741910), "cylinder",  new org.jmol.script.Token (1073741912), "diameter",  new org.jmol.script.Token (1073741916), "discrete",  new org.jmol.script.Token (1073741920), "distanceFactor",  new org.jmol.script.Token (1073741924), "downsample",  new org.jmol.script.Token (1073741928), "drawing",  new org.jmol.script.Token (1073741929), "eccentricity",  new org.jmol.script.Token (1073741930), "ed",  new org.jmol.script.Token (1074790508), "edges",  new org.jmol.script.Token (1073741934), "energy",  new org.jmol.script.Token (1073741935), "exitJmol",  new org.jmol.script.Token (266256), "faceCenterOffset",  new org.jmol.script.Token (1073741937), "filter",  new org.jmol.script.Token (1073741940), "first",  new org.jmol.script.Token (1073741942), "fixed",  new org.jmol.script.Token (1060869), "fix", null, "flat",  new org.jmol.script.Token (1073741948), "fps",  new org.jmol.script.Token (1074790526), "from",  new org.jmol.script.Token (1073741952), "frontEdges",  new org.jmol.script.Token (1073741956), "full",  new org.jmol.script.Token (1073741961), "fullPlane",  new org.jmol.script.Token (1073741962), "functionXY",  new org.jmol.script.Token (1073741966), "functionXYZ",  new org.jmol.script.Token (1073741968), "gridPoints",  new org.jmol.script.Token (1073741970), "homo",  new org.jmol.script.Token (1073741973), "ignore",  new org.jmol.script.Token (1073741976), "InChI",  new org.jmol.script.Token (1073741977), "InChIKey",  new org.jmol.script.Token (1073741978), "increment",  new org.jmol.script.Token (1073741981), "insideout",  new org.jmol.script.Token (1073741984), "interior",  new org.jmol.script.Token (1073741986), "intersection",  new org.jmol.script.Token (135267842), "intersect", null, "internal",  new org.jmol.script.Token (1073741988), "lattice",  new org.jmol.script.Token (1073741994), "line",  new org.jmol.script.Token (1073741998), "lineData",  new org.jmol.script.Token (1073742000), "link",  new org.jmol.script.Token (1073741999), "lobe",  new org.jmol.script.Token (1073742002), "lonePair",  new org.jmol.script.Token (1073742004), "lp",  new org.jmol.script.Token (1073742006), "lumo",  new org.jmol.script.Token (1073742008), "manifest",  new org.jmol.script.Token (1073742010), "mapProperty",  new org.jmol.script.Token (1052700), "map", null, "maxSet",  new org.jmol.script.Token (1073742014), "menu",  new org.jmol.script.Token (1073742015), "minSet",  new org.jmol.script.Token (1073742020), "modelBased",  new org.jmol.script.Token (1073742028), "molecular",  new org.jmol.script.Token (1073742030), "mrc",  new org.jmol.script.Token (1073742033), "msms",  new org.jmol.script.Token (1073742034), "name",  new org.jmol.script.Token (1073742035), "nmr",  new org.jmol.script.Token (1073742038), "noCross",  new org.jmol.script.Token (1073742040), "noDebug",  new org.jmol.script.Token (1073742041), "noEdges",  new org.jmol.script.Token (1073742044), "noHead",  new org.jmol.script.Token (1073742048), "noLoad",  new org.jmol.script.Token (1073742050), "noPlane",  new org.jmol.script.Token (1073742054), "object",  new org.jmol.script.Token (1073742064), "obj",  new org.jmol.script.Token (1073742062), "offset",  new org.jmol.script.Token (1073742066), "offsetSide",  new org.jmol.script.Token (1073742068), "once",  new org.jmol.script.Token (1073742070), "orbital",  new org.jmol.script.Token (1073742076), "atomicOrbital",  new org.jmol.script.Token (1073741850), "packed",  new org.jmol.script.Token (1073742080), "palindrome",  new org.jmol.script.Token (1073742082), "parameters",  new org.jmol.script.Token (1073742083), "path",  new org.jmol.script.Token (1073742084), "pdb",  new org.jmol.script.Token (1074790662), "period",  new org.jmol.script.Token (1073742090), "periodic", null, "perpendicular",  new org.jmol.script.Token (1073742092), "perp", null, "phase",  new org.jmol.script.Token (1073742094), "pocket",  new org.jmol.script.Token (1073742100), "pointsPerAngstrom",  new org.jmol.script.Token (1073742104), "radical",  new org.jmol.script.Token (1073742112), "rad",  new org.jmol.script.Token (1073742110), "reference",  new org.jmol.script.Token (1073742118), "remove",  new org.jmol.script.Token (1073742119), "resolution",  new org.jmol.script.Token (1073742122), "reverseColor",  new org.jmol.script.Token (1073742124), "rotate45",  new org.jmol.script.Token (1073742130), "selection",  new org.jmol.script.Token (1073742140), "sigma",  new org.jmol.script.Token (1073742146), "sign",  new org.jmol.script.Token (1073742147), "silent",  new org.jmol.script.Token (1073742148), "sphere",  new org.jmol.script.Token (1073742154), "squared",  new org.jmol.script.Token (1073742156), "stop",  new org.jmol.script.Token (1073742162), "title",  new org.jmol.script.Token (1073742166), "titleFormat",  new org.jmol.script.Token (1073742168), "to",  new org.jmol.script.Token (1074790746), "value",  new org.jmol.script.Token (1073742188), "variable",  new org.jmol.script.Token (1073742190), "variables",  new org.jmol.script.Token (1073742192), "vertices",  new org.jmol.script.Token (1073742194), "width",  new org.jmol.script.Token (1073742196), "backgroundModel",  new org.jmol.script.Token (536870914), "debug",  new org.jmol.script.Token (536870916), "defaultLattice",  new org.jmol.script.Token (536870918), "measurements",  new org.jmol.script.Token (537006096), "measurement", null, "scale3D",  new org.jmol.script.Token (1610612740), "toggleLabel",  new org.jmol.script.Token (1610612741), "userColorScheme",  new org.jmol.script.Token (536870930), "timeout",  new org.jmol.script.Token (536875070), "timeouts", null, "appletProxy",  new org.jmol.script.Token (545259522), "atomTypes",  new org.jmol.script.Token (545259524), "axesColor",  new org.jmol.script.Token (545259526), "axis1Color",  new org.jmol.script.Token (545259528), "axis2Color",  new org.jmol.script.Token (545259530), "axis3Color",  new org.jmol.script.Token (545259532), "backgroundColor",  new org.jmol.script.Token (545259534), "bondmode",  new org.jmol.script.Token (1610612737), "boundBoxColor",  new org.jmol.script.Token (545259536), "boundingBoxColor", null, "currentLocalPath",  new org.jmol.script.Token (545259538), "dataSeparator",  new org.jmol.script.Token (545259540), "defaultAngleLabel",  new org.jmol.script.Token (545259542), "defaultColorScheme",  new org.jmol.script.Token (545259545), "defaultColors", null, "defaultDirectory",  new org.jmol.script.Token (545259546), "defaultDistanceLabel",  new org.jmol.script.Token (545259547), "defaultDropScript",  new org.jmol.script.Token (545259548), "defaultLabelPDB",  new org.jmol.script.Token (545259543), "defaultLabelXYZ",  new org.jmol.script.Token (545259544), "defaultLoadFilter",  new org.jmol.script.Token (545259549), "defaultLoadScript",  new org.jmol.script.Token (545259550), "defaults",  new org.jmol.script.Token (545259552), "defaultTorsionLabel",  new org.jmol.script.Token (545259554), "defaultVDW",  new org.jmol.script.Token (545259555), "edsUrlCutoff",  new org.jmol.script.Token (545259556), "edsUrlFormat",  new org.jmol.script.Token (545259557), "energyUnits",  new org.jmol.script.Token (545259558), "fileCacheDirectory",  new org.jmol.script.Token (545259559), "fontsize",  new org.jmol.script.Token (1610612738), "helpPath",  new org.jmol.script.Token (545259561), "hoverLabel",  new org.jmol.script.Token (545259562), "language",  new org.jmol.script.Token (545259564), "loadFormat",  new org.jmol.script.Token (545259565), "loadLigandFormat",  new org.jmol.script.Token (545259566), "logFile",  new org.jmol.script.Token (545259567), "measurementUnits",  new org.jmol.script.Token (545259568), "nmrUrlFormat",  new org.jmol.script.Token (545259569), "pathForAllFiles",  new org.jmol.script.Token (545259570), "picking",  new org.jmol.script.Token (545259572), "pickingStyle",  new org.jmol.script.Token (545259574), "pickLabel",  new org.jmol.script.Token (545259576), "propertyColorScheme",  new org.jmol.script.Token (545259578), "quaternionFrame",  new org.jmol.script.Token (545259580), "smilesUrlFormat",  new org.jmol.script.Token (545259582), "smiles2dImageFormat",  new org.jmol.script.Token (545259584), "unitCellColor",  new org.jmol.script.Token (545259586), "axesScale",  new org.jmol.script.Token (570425346), "axisScale", null, "bondTolerance",  new org.jmol.script.Token (570425348), "cameraDepth",  new org.jmol.script.Token (570425350), "defaultDrawArrowScale",  new org.jmol.script.Token (570425352), "defaultTranslucent",  new org.jmol.script.Token (570425354), "dipoleScale",  new org.jmol.script.Token (570425356), "ellipsoidAxisDiameter",  new org.jmol.script.Token (570425358), "gestureSwipeFactor",  new org.jmol.script.Token (570425359), "hbondsAngleMinimum",  new org.jmol.script.Token (570425360), "hbondsDistanceMaximum",  new org.jmol.script.Token (570425361), "hoverDelay",  new org.jmol.script.Token (570425362), "loadAtomDataTolerance",  new org.jmol.script.Token (570425363), "minBondDistance",  new org.jmol.script.Token (570425364), "minimizationCriterion",  new org.jmol.script.Token (570425365), "mouseDragFactor",  new org.jmol.script.Token (570425366), "mouseWheelFactor",  new org.jmol.script.Token (570425367), "navFPS",  new org.jmol.script.Token (570425370), "navigationDepth",  new org.jmol.script.Token (570425371), "navigationSlab",  new org.jmol.script.Token (570425372), "navigationSpeed",  new org.jmol.script.Token (570425374), "navX",  new org.jmol.script.Token (570425376), "navY",  new org.jmol.script.Token (570425378), "navZ",  new org.jmol.script.Token (570425380), "pointGroupDistanceTolerance",  new org.jmol.script.Token (570425382), "pointGroupLinearTolerance",  new org.jmol.script.Token (570425384), "radius",  new org.jmol.script.Token (1666189314), "rotationRadius",  new org.jmol.script.Token (570425388), "scaleAngstromsPerInch",  new org.jmol.script.Token (570425390), "sheetSmoothing",  new org.jmol.script.Token (570425392), "slabRange",  new org.jmol.script.Token (570425393), "solventProbeRadius",  new org.jmol.script.Token (570425394), "spinFPS",  new org.jmol.script.Token (570425396), "spinX",  new org.jmol.script.Token (570425398), "spinY",  new org.jmol.script.Token (570425400), "spinZ",  new org.jmol.script.Token (570425402), "stereoDegrees",  new org.jmol.script.Token (570425404), "strutDefaultRadius",  new org.jmol.script.Token (570425406), "strutLengthMaximum",  new org.jmol.script.Token (570425408), "vectorScale",  new org.jmol.script.Token (1649410065), "vectorSymmetry",  new org.jmol.script.Token (603979973), "vibrationPeriod",  new org.jmol.script.Token (570425412), "vibrationScale",  new org.jmol.script.Token (570425414), "visualRange",  new org.jmol.script.Token (570425416), "ambientPercent",  new org.jmol.script.Token (553648130), "ambient", null, "animationFps",  new org.jmol.script.Token (553648132), "axesMode",  new org.jmol.script.Token (553648134), "bondRadiusMilliAngstroms",  new org.jmol.script.Token (553648136), "delayMaximumMs",  new org.jmol.script.Token (553648138), "diffusePercent",  new org.jmol.script.Token (553648142), "diffuse", null, "dotDensity",  new org.jmol.script.Token (553648143), "dotScale",  new org.jmol.script.Token (553648144), "ellipsoidDotCount",  new org.jmol.script.Token (553648145), "helixStep",  new org.jmol.script.Token (553648146), "hermiteLevel",  new org.jmol.script.Token (553648147), "historyLevel",  new org.jmol.script.Token (553648148), "lighting",  new org.jmol.script.Token (1073741995), "logLevel",  new org.jmol.script.Token (553648150), "meshScale",  new org.jmol.script.Token (553648151), "minimizationSteps",  new org.jmol.script.Token (553648152), "minPixelSelRadius",  new org.jmol.script.Token (553648153), "percentVdwAtom",  new org.jmol.script.Token (553648154), "perspectiveModel",  new org.jmol.script.Token (553648155), "phongExponent",  new org.jmol.script.Token (553648156), "pickingSpinRate",  new org.jmol.script.Token (553648158), "propertyAtomNumberField",  new org.jmol.script.Token (553648159), "propertyAtomNumberColumnCount",  new org.jmol.script.Token (553648160), "propertyDataColumnCount",  new org.jmol.script.Token (553648162), "propertyDataField",  new org.jmol.script.Token (553648164), "repaintWaitMs",  new org.jmol.script.Token (553648165), "ribbonAspectRatio",  new org.jmol.script.Token (553648166), "scriptReportingLevel",  new org.jmol.script.Token (553648168), "showScript",  new org.jmol.script.Token (536870922), "smallMoleculeMaxAtoms",  new org.jmol.script.Token (553648170), "specular",  new org.jmol.script.Token (536870924), "specularExponent",  new org.jmol.script.Token (553648172), "specularPercent",  new org.jmol.script.Token (553648174), "specPercent", null, "specularPower",  new org.jmol.script.Token (553648176), "specpower", null, "strandCount",  new org.jmol.script.Token (553648178), "strandCountForMeshRibbon",  new org.jmol.script.Token (553648180), "strandCountForStrands",  new org.jmol.script.Token (553648182), "strutSpacing",  new org.jmol.script.Token (553648184), "zDepth",  new org.jmol.script.Token (553648186), "zSlab",  new org.jmol.script.Token (553648188), "zshadePower",  new org.jmol.script.Token (553648190), "allowEmbeddedScripts",  new org.jmol.script.Token (603979778), "allowGestures",  new org.jmol.script.Token (603979780), "allowKeyStrokes",  new org.jmol.script.Token (603979781), "allowModelKit",  new org.jmol.script.Token (603979782), "allowMoveAtoms",  new org.jmol.script.Token (603979783), "allowMultiTouch",  new org.jmol.script.Token (603979784), "allowRotateSelected",  new org.jmol.script.Token (603979785), "antialiasDisplay",  new org.jmol.script.Token (603979786), "antialiasImages",  new org.jmol.script.Token (603979788), "antialiasTranslucent",  new org.jmol.script.Token (603979790), "appendNew",  new org.jmol.script.Token (603979792), "applySymmetryToBonds",  new org.jmol.script.Token (603979794), "atomPicking",  new org.jmol.script.Token (603979796), "autobond",  new org.jmol.script.Token (603979798), "autoFPS",  new org.jmol.script.Token (603979800), "axesMolecular",  new org.jmol.script.Token (603979804), "axesOrientationRasmol",  new org.jmol.script.Token (603979806), "axesUnitCell",  new org.jmol.script.Token (603979808), "axesWindow",  new org.jmol.script.Token (603979810), "bondModeOr",  new org.jmol.script.Token (603979812), "bondPicking",  new org.jmol.script.Token (603979814), "bonds",  new org.jmol.script.Token (1678770178), "bond", null, "cartoonBaseEdges",  new org.jmol.script.Token (603979818), "cartoonFancy",  new org.jmol.script.Token (603979820), "cartoonRockets",  new org.jmol.script.Token (603979819), "chainCaseSensitive",  new org.jmol.script.Token (603979821), "colorRasmol",  new org.jmol.script.Token (603979822), "debugScript",  new org.jmol.script.Token (603979824), "defaultStructureDssp",  new org.jmol.script.Token (603979825), "disablePopupMenu",  new org.jmol.script.Token (603979826), "displayCellParameters",  new org.jmol.script.Token (603979828), "dotsSelectedOnly",  new org.jmol.script.Token (603979829), "dotSurface",  new org.jmol.script.Token (603979830), "dragSelected",  new org.jmol.script.Token (603979831), "drawHover",  new org.jmol.script.Token (603979832), "drawPicking",  new org.jmol.script.Token (603979833), "dsspCalculateHydrogenAlways",  new org.jmol.script.Token (603979834), "dynamicMeasurements",  new org.jmol.script.Token (603979835), "ellipsoidArcs",  new org.jmol.script.Token (603979836), "ellipsoidAxes",  new org.jmol.script.Token (603979837), "ellipsoidBall",  new org.jmol.script.Token (603979838), "ellipsoidDots",  new org.jmol.script.Token (603979839), "ellipsoidFill",  new org.jmol.script.Token (603979840), "fileCaching",  new org.jmol.script.Token (603979842), "fontCaching",  new org.jmol.script.Token (603979844), "fontScaling",  new org.jmol.script.Token (603979845), "forceAutoBond",  new org.jmol.script.Token (603979846), "fractionalRelative",  new org.jmol.script.Token (603979848), "greyscaleRendering",  new org.jmol.script.Token (603979850), "hbondsBackbone",  new org.jmol.script.Token (603979852), "hbondsRasmol",  new org.jmol.script.Token (603979853), "hbondsSolid",  new org.jmol.script.Token (603979854), "hetero",  new org.jmol.script.Token (1613758470), "hideNameInPopup",  new org.jmol.script.Token (603979858), "hideNavigationPoint",  new org.jmol.script.Token (603979860), "hideNotSelected",  new org.jmol.script.Token (603979862), "highResolution",  new org.jmol.script.Token (603979864), "hydrogen",  new org.jmol.script.Token (1613758476), "hydrogens", null, "imageState",  new org.jmol.script.Token (603979868), "isKiosk",  new org.jmol.script.Token (603979869), "isosurfaceKey",  new org.jmol.script.Token (603979870), "isosurfacePropertySmoothing",  new org.jmol.script.Token (603979871), "isosurfacePropertySmoothingPower",  new org.jmol.script.Token (553648149), "justifyMeasurements",  new org.jmol.script.Token (603979872), "languageTranslation",  new org.jmol.script.Token (603979873), "legacyAutoBonding",  new org.jmol.script.Token (603979874), "logCommands",  new org.jmol.script.Token (603979875), "logGestures",  new org.jmol.script.Token (603979876), "measureAllModels",  new org.jmol.script.Token (603979877), "measurementLabels",  new org.jmol.script.Token (603979878), "measurementNumbers",  new org.jmol.script.Token (1610612739), "messageStyleChime",  new org.jmol.script.Token (603979879), "minimizationRefresh",  new org.jmol.script.Token (603979880), "minimizationSilent",  new org.jmol.script.Token (603979881), "modelkitMode",  new org.jmol.script.Token (603979882), "monitorEnergy",  new org.jmol.script.Token (603979883), "multipleBondRadiusFactor",  new org.jmol.script.Token (570425368), "multipleBondSpacing",  new org.jmol.script.Token (570425369), "multiProcessor",  new org.jmol.script.Token (603979884), "navigateSurface",  new org.jmol.script.Token (603979885), "navigationMode",  new org.jmol.script.Token (603979886), "navigationPeriodic",  new org.jmol.script.Token (603979887), "partialDots",  new org.jmol.script.Token (603979888), "pdbAddHydrogens",  new org.jmol.script.Token (603979889), "pdbGetHeader",  new org.jmol.script.Token (603979890), "pdbSequential",  new org.jmol.script.Token (603979891), "perspectiveDepth",  new org.jmol.script.Token (603979892), "preserveState",  new org.jmol.script.Token (603979893), "rangeSelected",  new org.jmol.script.Token (603979894), "redoMove",  new org.jmol.script.Token (4139), "refreshing",  new org.jmol.script.Token (603979896), "ribbonBorder",  new org.jmol.script.Token (603979898), "rocketBarrels",  new org.jmol.script.Token (603979900), "saveProteinStructureState",  new org.jmol.script.Token (603979902), "scriptQueue",  new org.jmol.script.Token (603979904), "selectAllModels",  new org.jmol.script.Token (603979906), "selectHetero",  new org.jmol.script.Token (603979908), "selectHydrogen",  new org.jmol.script.Token (603979910), "showAxes",  new org.jmol.script.Token (603979914), "showBoundBox",  new org.jmol.script.Token (603979916), "showBoundingBox", null, "showFrank",  new org.jmol.script.Token (603979918), "showHiddenSelectionHalos",  new org.jmol.script.Token (603979920), "showHydrogens",  new org.jmol.script.Token (603979922), "showKeyStrokes",  new org.jmol.script.Token (603979924), "showMeasurements",  new org.jmol.script.Token (603979926), "showMultipleBonds",  new org.jmol.script.Token (603979928), "showNavigationPointAlways",  new org.jmol.script.Token (603979930), "showTiming",  new org.jmol.script.Token (603979934), "showUnitcell",  new org.jmol.script.Token (603979936), "slabByAtom",  new org.jmol.script.Token (603979938), "slabByMolecule",  new org.jmol.script.Token (603979940), "slabEnabled",  new org.jmol.script.Token (603979942), "smartAromatic",  new org.jmol.script.Token (603979944), "solvent",  new org.jmol.script.Token (1613758488), "solventProbe",  new org.jmol.script.Token (603979948), "ssBondsBackbone",  new org.jmol.script.Token (603979952), "statusReporting",  new org.jmol.script.Token (603979954), "strutsMultiple",  new org.jmol.script.Token (603979955), "syncMouse",  new org.jmol.script.Token (603979956), "syncScript",  new org.jmol.script.Token (603979958), "testFlag1",  new org.jmol.script.Token (603979960), "testFlag2",  new org.jmol.script.Token (603979962), "testFlag3",  new org.jmol.script.Token (603979964), "testFlag4",  new org.jmol.script.Token (603979966), "traceAlpha",  new org.jmol.script.Token (603979967), "undo",  new org.jmol.script.Token (536870928), "undoMove",  new org.jmol.script.Token (4165), "useArcBall",  new org.jmol.script.Token (603979969), "useMinimizationThread",  new org.jmol.script.Token (603979970), "useNumberLocalization",  new org.jmol.script.Token (603979972), "waitForMoveTo",  new org.jmol.script.Token (603979974), "windowCentered",  new org.jmol.script.Token (603979975), "wireframeRotation",  new org.jmol.script.Token (603979976), "zeroBasedXyzRasmol",  new org.jmol.script.Token (603979978), "zoomEnabled",  new org.jmol.script.Token (603979980), "zoomLarge",  new org.jmol.script.Token (603979982), "zShade",  new org.jmol.script.Token (603979984)];
var tokenLast = null;
var stringThis;
var tokenThis;
var lcase;
for (var i = 0; i + 1 < arrayPairs.length; i += 2) {
stringThis = arrayPairs[i];
lcase = stringThis.toLowerCase ();
tokenThis = arrayPairs[i + 1];
if (tokenThis == null) tokenThis = tokenLast;
if (tokenThis.value == null) tokenThis.value = stringThis;
if (org.jmol.script.Token.tokenMap.get (lcase) != null) org.jmol.util.Logger.error ("duplicate token definition:" + lcase);
org.jmol.script.Token.tokenMap.put (lcase, tokenThis);
tokenLast = tokenThis;
}
}});
// 
//// org\jmol\util\Point3f.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.Tuple3f"], "org.jmol.util.Point3f", null, function () {
c$ = Clazz.declareType (org.jmol.util, "Point3f", org.jmol.util.Tuple3f);
c$.newP = Clazz.defineMethod (c$, "newP", 
function (t) {
var p =  new org.jmol.util.Point3f ();
p.x = t.x;
p.y = t.y;
p.z = t.z;
return p;
}, "org.jmol.util.Tuple3f");
c$.new3 = Clazz.defineMethod (c$, "new3", 
function (x, y, z) {
var p =  new org.jmol.util.Point3f ();
p.x = x;
p.y = y;
p.z = z;
return p;
}, "~N,~N,~N");
Clazz.defineMethod (c$, "distanceSquared", 
function (p1) {
var dx = this.x - p1.x;
var dy = this.y - p1.y;
var dz = this.z - p1.z;
return (dx * dx + dy * dy + dz * dz);
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "distance", 
function (p1) {
return Math.sqrt (this.distanceSquared (p1));
}, "org.jmol.util.Point3f");
});
// 
//// org\jmol\script\ScriptVariable.js 
// 
Clazz.declarePackage ("org.jmol.script");
Clazz.load (["org.jmol.script.Token", "org.jmol.util.Point3f"], "org.jmol.script.ScriptVariable", ["java.lang.Boolean", "$.Float", "java.util.ArrayList", "$.Arrays", "$.Collections", "$.Hashtable", "org.jmol.modelset.Bond", "org.jmol.util.BitSet", "$.BitSetUtil", "$.Escape", "$.Measure", "$.Parser", "$.StringXBuilder", "$.TextFormat"], function () {
c$ = Clazz.decorateAsClass (function () {
this.index = 2147483647;
this.flags = 2;
this.myName = null;
if (!Clazz.isClassDefined ("org.jmol.script.ScriptVariable.Sort")) {
org.jmol.script.ScriptVariable.$ScriptVariable$Sort$ ();
}
Clazz.instantialize (this, arguments);
}, org.jmol.script, "ScriptVariable", org.jmol.script.Token);
Clazz.makeConstructor (c$, 
function (tok) {
Clazz.superConstructor (this, org.jmol.script.ScriptVariable, []);
this.tok = tok;
}, "~N");
c$.newVariable = Clazz.defineMethod (c$, "newVariable", 
function (tok, value) {
var sv =  new org.jmol.script.ScriptVariable (tok);
sv.value = value;
return sv;
}, "~N,~O");
c$.newScriptVariableBs = Clazz.defineMethod (c$, "newScriptVariableBs", 
function (bs, index) {
var sv =  new org.jmol.script.ScriptVariable (10);
sv.value = bs;
if (index >= 0) sv.index = index;
return sv;
}, "org.jmol.util.BitSet,~N");
c$.newScriptVariableToken = Clazz.defineMethod (c$, "newScriptVariableToken", 
function (x) {
var sv =  new org.jmol.script.ScriptVariable (x.tok);
sv.intValue = x.intValue;
sv.value = x.value;
return sv;
}, "org.jmol.script.Token");
c$.newScriptVariableIntValue = Clazz.defineMethod (c$, "newScriptVariableIntValue", 
function (tok, intValue, value) {
var sv =  new org.jmol.script.ScriptVariable (tok);
sv.intValue = intValue;
sv.value = value;
return sv;
}, "~N,~N,~O");
c$.typeOf = Clazz.defineMethod (c$, "typeOf", 
function (x) {
var tok = (x == null ? 0 : x.tok);
switch (tok) {
case 1048589:
case 1048588:
return "boolean";
case 10:
return (Clazz.instanceOf (x.value, org.jmol.modelset.Bond.BondSet) ? "bondset" : "bitset");
case 2:
case 3:
case 8:
case 9:
case 4:
case 7:
case 6:
case 11:
case 12:
return org.jmol.script.Token.astrType[tok];
}
return "?";
}, "org.jmol.script.ScriptVariable");
c$.sizeOf = Clazz.defineMethod (c$, "sizeOf", 
function (x) {
switch (x == null ? 0 : x.tok) {
case 10:
return org.jmol.util.BitSetUtil.cardinalityOf (org.jmol.script.ScriptVariable.bsSelectToken (x));
case 1048589:
case 1048588:
return -1;
case 2:
return -2;
case 3:
return -4;
case 8:
return -8;
case 9:
return -16;
case 11:
return -32;
case 12:
return -64;
case 4:
return (x.value).length;
case 7:
return x.intValue == 2147483647 ? (x).getList ().size () : org.jmol.script.ScriptVariable.sizeOf (org.jmol.script.ScriptVariable.selectItemTok (x));
case 6:
return (x.value).size ();
default:
return 0;
}
}, "org.jmol.script.Token");
c$.isVariableType = Clazz.defineMethod (c$, "isVariableType", 
function (x) {
return (Clazz.instanceOf (x, org.jmol.script.ScriptVariable) || Clazz.instanceOf (x, org.jmol.util.BitSet) || Clazz.instanceOf (x, Boolean) || Clazz.instanceOf (x, Float) || Clazz.instanceOf (x, Integer) || Clazz.instanceOf (x, org.jmol.util.Point3f) || Clazz.instanceOf (x, org.jmol.util.Vector3f) || Clazz.instanceOf (x, org.jmol.util.Point4f) || Clazz.instanceOf (x, org.jmol.util.Quaternion) || Clazz.instanceOf (x, String) || Clazz.instanceOf (x, java.util.Map) || Clazz.instanceOf (x, java.util.List) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array) || Clazz.instanceOf (x, Array));
}, "~O");
c$.getVariable = Clazz.defineMethod (c$, "getVariable", 
function (x) {
if (x == null) return org.jmol.script.ScriptVariable.newVariable (4, "");
if (Clazz.instanceOf (x, org.jmol.script.ScriptVariable)) return x;
if (Clazz.instanceOf (x, Boolean)) return org.jmol.script.ScriptVariable.getBoolean ((x).booleanValue ());
if (Clazz.instanceOf (x, Integer)) return  new org.jmol.script.ScriptVariableInt ((x).intValue ());
if (Clazz.instanceOf (x, Float)) return org.jmol.script.ScriptVariable.newVariable (3, x);
if (Clazz.instanceOf (x, String)) {
x = org.jmol.script.ScriptVariable.unescapePointOrBitsetAsVariable (x);
if (Clazz.instanceOf (x, org.jmol.script.ScriptVariable)) return x;
return org.jmol.script.ScriptVariable.newVariable (4, x);
}if (Clazz.instanceOf (x, org.jmol.util.Point3f)) return org.jmol.script.ScriptVariable.newVariable (8, x);
if (Clazz.instanceOf (x, org.jmol.util.Vector3f)) return org.jmol.script.ScriptVariable.newVariable (8, org.jmol.util.Point3f.newP (x));
if (Clazz.instanceOf (x, org.jmol.util.BitSet)) return org.jmol.script.ScriptVariable.newVariable (10, x);
if (Clazz.instanceOf (x, org.jmol.util.Point4f)) return org.jmol.script.ScriptVariable.newVariable (9, x);
if (Clazz.instanceOf (x, org.jmol.util.Quaternion)) return org.jmol.script.ScriptVariable.newVariable (9, (x).toPoint4f ());
if (Clazz.instanceOf (x, org.jmol.util.Matrix3f)) return org.jmol.script.ScriptVariable.newVariable (11, x);
if (Clazz.instanceOf (x, org.jmol.util.Matrix4f)) return org.jmol.script.ScriptVariable.newVariable (12, x);
if (org.jmol.util.Escape.isAFloat (x)) return org.jmol.script.ScriptVariable.newVariable (13, x);
if (Clazz.instanceOf (x, java.util.Map)) return org.jmol.script.ScriptVariable.getVariableMap (x);
if (Clazz.instanceOf (x, java.util.List)) return org.jmol.script.ScriptVariable.getVariableList (x);
if (org.jmol.util.Escape.isAI (x)) return org.jmol.script.ScriptVariable.getVariableAI (x);
if (org.jmol.util.Escape.isAF (x)) return org.jmol.script.ScriptVariable.getVariableAF (x);
if (org.jmol.util.Escape.isAD (x)) return org.jmol.script.ScriptVariable.getVariableAD (x);
if (org.jmol.util.Escape.isAII (x)) return org.jmol.script.ScriptVariable.getVariableAII (x);
if (org.jmol.util.Escape.isAFF (x)) return org.jmol.script.ScriptVariable.getVariableAFF (x);
if (org.jmol.util.Escape.isAS (x)) return org.jmol.script.ScriptVariable.getVariableAS (x);
if (org.jmol.util.Escape.isAV (x)) return org.jmol.script.ScriptVariable.getVariableAV (x);
if (org.jmol.util.Escape.isAP (x)) return org.jmol.script.ScriptVariable.getVariableAP (x);
return org.jmol.script.ScriptVariable.newVariable (4, org.jmol.util.Escape.toReadable (null, x));
}, "~O");
c$.getVariableMap = Clazz.defineMethod (c$, "getVariableMap", 
function (x) {
var ht = x;
var e = ht.keySet ().iterator ();
while (e.hasNext ()) {
if (!(Clazz.instanceOf (ht.get (e.next ()), org.jmol.script.ScriptVariable))) {
var x2 =  new java.util.Hashtable ();
for (var entry, $entry = ht.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var key = entry.getKey ();
var o = entry.getValue ();
if (org.jmol.script.ScriptVariable.isVariableType (o)) x2.put (key, org.jmol.script.ScriptVariable.getVariable (o));
 else x2.put (key, org.jmol.script.ScriptVariable.newVariable (4, org.jmol.util.Escape.toReadable (null, o)));
}
x = x2;
}break;
}
return org.jmol.script.ScriptVariable.newVariable (6, x);
}, "~O");
c$.getVariableList = Clazz.defineMethod (c$, "getVariableList", 
function (v) {
var len = v.size ();
if (len > 0 && Clazz.instanceOf (v.get (0), org.jmol.script.ScriptVariable)) return org.jmol.script.ScriptVariable.newVariable (7, v);
var objects =  new java.util.ArrayList ();
for (var i = 0; i < len; i++) objects.add (org.jmol.script.ScriptVariable.getVariable (v.get (i)));

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "java.util.List");
c$.getVariableAV = Clazz.defineMethod (c$, "getVariableAV", 
function (v) {
var objects =  new java.util.ArrayList ();
for (var i = 0; i < v.length; i++) objects.add (v[i]);

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "~A");
c$.getVariableAD = Clazz.defineMethod (c$, "getVariableAD", 
function (f) {
var objects =  new java.util.ArrayList ();
for (var i = 0; i < f.length; i++) objects.add (org.jmol.script.ScriptVariable.newVariable (3, Float.$valueOf (f[i])));

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "~A");
c$.getVariableAS = Clazz.defineMethod (c$, "getVariableAS", 
function (s) {
var objects =  new java.util.ArrayList ();
for (var i = 0; i < s.length; i++) objects.add (org.jmol.script.ScriptVariable.newVariable (4, s[i]));

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "~A");
c$.getVariableAP = Clazz.defineMethod (c$, "getVariableAP", 
function (p) {
var objects =  new java.util.ArrayList ();
for (var i = 0; i < p.length; i++) objects.add (org.jmol.script.ScriptVariable.newVariable (8, p[i]));

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "~A");
c$.getVariableAFF = Clazz.defineMethod (c$, "getVariableAFF", 
function (fx) {
var objects =  new java.util.ArrayList ();
for (var i = 0; i < fx.length; i++) objects.add (org.jmol.script.ScriptVariable.getVariableAF (fx[i]));

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "~A");
c$.getVariableAII = Clazz.defineMethod (c$, "getVariableAII", 
function (ix) {
var objects =  new java.util.ArrayList ();
for (var i = 0; i < ix.length; i++) objects.add (org.jmol.script.ScriptVariable.getVariableAI (ix[i]));

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "~A");
c$.getVariableAF = Clazz.defineMethod (c$, "getVariableAF", 
function (f) {
var objects =  new java.util.ArrayList ();
for (var i = 0; i < f.length; i++) objects.add (org.jmol.script.ScriptVariable.newVariable (3, Float.$valueOf (f[i])));

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "~A");
c$.getVariableAI = Clazz.defineMethod (c$, "getVariableAI", 
function (ix) {
var objects =  new java.util.ArrayList ();
for (var i = 0; i < ix.length; i++) objects.add (org.jmol.script.ScriptVariable.newVariable (2, Integer.$valueOf (ix[i])));

return org.jmol.script.ScriptVariable.newVariable (7, objects);
}, "~A");
Clazz.defineMethod (c$, "set", 
function (v, asCopy) {
this.index = v.index;
this.intValue = v.intValue;
this.tok = v.tok;
this.value = v.value;
if (asCopy) {
switch (this.tok) {
case 6:
this.value =  new java.util.Hashtable (v.value);
break;
case 7:
var o2 =  new java.util.ArrayList ();
var o1 = v.getList ();
for (var i = 0; i < o1.size (); i++) o2.add (o1.get (i));

this.value = o2;
break;
}
}return this;
}, "org.jmol.script.ScriptVariable,~B");
Clazz.defineMethod (c$, "setName", 
function (name) {
this.myName = name;
this.flags |= 1;
return this;
}, "~S");
Clazz.defineMethod (c$, "setGlobal", 
function () {
this.flags &= -3;
return this;
});
Clazz.defineMethod (c$, "canIncrement", 
function () {
return org.jmol.script.Token.tokAttr (this.flags, 1);
});
Clazz.defineMethod (c$, "increment", 
function (n) {
if (!this.canIncrement ()) return false;
switch (this.tok) {
case 2:
this.intValue += n;
break;
case 3:
this.value =  new Float ((this.value).floatValue () + n);
break;
default:
this.value = org.jmol.script.ScriptVariable.nValue (this);
if (Clazz.instanceOf (this.value, Integer)) {
this.tok = 2;
this.intValue = (this.value).intValue ();
} else {
this.tok = 3;
}}
return true;
}, "~N");
Clazz.defineMethod (c$, "asBoolean", 
function () {
return org.jmol.script.ScriptVariable.bValue (this);
});
Clazz.defineMethod (c$, "asInt", 
function () {
return org.jmol.script.ScriptVariable.iValue (this);
});
Clazz.defineMethod (c$, "asFloat", 
function () {
return org.jmol.script.ScriptVariable.fValue (this);
});
Clazz.defineMethod (c$, "asString", 
function () {
return org.jmol.script.ScriptVariable.sValue (this);
});
c$.oValue = Clazz.defineMethod (c$, "oValue", 
function (x) {
switch (x == null ? 0 : x.tok) {
case 1048589:
return Boolean.TRUE;
case 0:
case 1048588:
return Boolean.FALSE;
case 2:
return Integer.$valueOf (x.intValue);
case 10:
case 135266306:
return org.jmol.script.ScriptVariable.selectItemVar (x).value;
default:
return x.value;
}
}, "org.jmol.script.ScriptVariable");
c$.nValue = Clazz.defineMethod (c$, "nValue", 
function (x) {
var iValue;
switch (x == null ? 0 : x.tok) {
case 3:
return x.value;
case 2:
iValue = x.intValue;
break;
case 4:
if ((x.value).indexOf (".") >= 0) return  new Float (org.jmol.script.ScriptVariable.toFloat (x.value));
iValue = Clazz.floatToInt (org.jmol.script.ScriptVariable.toFloat (x.value));
break;
default:
iValue = 0;
}
return Integer.$valueOf (iValue);
}, "org.jmol.script.Token");
c$.bValue = Clazz.defineMethod (c$, "bValue", 
($fz = function (x) {
switch (x == null ? 0 : x.tok) {
case 1048589:
case 6:
return true;
case 1048588:
return false;
case 2:
return x.intValue != 0;
case 3:
case 4:
case 7:
return org.jmol.script.ScriptVariable.fValue (x) != 0;
case 10:
return org.jmol.script.ScriptVariable.iValue (x) != 0;
case 8:
case 9:
case 11:
case 12:
return Math.abs (org.jmol.script.ScriptVariable.fValue (x)) > 0.0001;
default:
return false;
}
}, $fz.isPrivate = true, $fz), "org.jmol.script.Token");
c$.iValue = Clazz.defineMethod (c$, "iValue", 
function (x) {
switch (x == null ? 0 : x.tok) {
case 1048589:
return 1;
case 1048588:
return 0;
case 2:
return x.intValue;
case 3:
case 7:
case 4:
case 8:
case 9:
case 11:
case 12:
return Clazz.floatToInt (org.jmol.script.ScriptVariable.fValue (x));
case 10:
return org.jmol.util.BitSetUtil.cardinalityOf (org.jmol.script.ScriptVariable.bsSelectToken (x));
default:
return 0;
}
}, "org.jmol.script.Token");
c$.fValue = Clazz.defineMethod (c$, "fValue", 
function (x) {
switch (x == null ? 0 : x.tok) {
case 1048589:
return 1;
case 1048588:
return 0;
case 2:
return x.intValue;
case 3:
return (x.value).floatValue ();
case 7:
var i = x.intValue;
if (i == 2147483647) return (x).getList ().size ();
case 4:
return org.jmol.script.ScriptVariable.toFloat (org.jmol.script.ScriptVariable.sValue (x));
case 10:
return org.jmol.script.ScriptVariable.iValue (x);
case 8:
return (x.value).distance (org.jmol.script.ScriptVariable.pt0);
case 9:
return org.jmol.util.Measure.distanceToPlane (x.value, org.jmol.script.ScriptVariable.pt0);
case 11:
var pt =  new org.jmol.util.Point3f ();
(x.value).transform (pt);
return pt.distance (org.jmol.script.ScriptVariable.pt0);
case 12:
var pt1 =  new org.jmol.util.Point3f ();
(x.value).transform (pt1);
return pt1.distance (org.jmol.script.ScriptVariable.pt0);
default:
return 0;
}
}, "org.jmol.script.Token");
c$.sValue = Clazz.defineMethod (c$, "sValue", 
function (x) {
if (x == null) return "";
var i;
var sb;
var map;
switch (x.tok) {
case 1048589:
return "true";
case 1048588:
return "false";
case 2:
return "" + x.intValue;
case 10:
return org.jmol.util.Escape.escapeBs (org.jmol.script.ScriptVariable.bsSelectToken (x), !(Clazz.instanceOf (x.value, org.jmol.modelset.Bond.BondSet)));
case 7:
var sv = (x).getList ();
i = x.intValue;
if (i <= 0) i = sv.size () - i;
if (i != 2147483647) return (i < 1 || i > sv.size () ? "" : org.jmol.script.ScriptVariable.sValue (sv.get (i - 1)));
case 6:
sb =  new org.jmol.util.StringXBuilder ();
map =  new java.util.Hashtable ();
org.jmol.script.ScriptVariable.sValueArray (sb, x, map, 0, false);
return sb.toString ();
case 4:
var s = x.value;
i = x.intValue;
if (i <= 0) i = s.length - i;
if (i == 2147483647) return s;
if (i < 1 || i > s.length) return "";
return "" + s.charAt (i - 1);
case 8:
case 9:
case 11:
case 12:
return org.jmol.util.Escape.escape (x.value);
default:
return x.value.toString ();
}
}, "org.jmol.script.Token");
c$.sValueArray = Clazz.defineMethod (c$, "sValueArray", 
($fz = function (sb, vx, map, level, isEscaped) {
switch (vx.tok) {
case 6:
if (map.containsKey (vx)) {
sb.append (isEscaped ? "{}" : vx.myName == null ? "<circular reference>" : "<" + vx.myName + ">");
break;
}map.put (vx, Boolean.TRUE);
var ht = vx.value;
var keys = ht.keySet ().toArray ();
java.util.Arrays.sort (keys);
if (isEscaped) {
sb.append ("{ ");
var sep = "";
for (var i = 0; i < keys.length; i++) {
var key = keys[i];
sb.append (sep).append (org.jmol.util.Escape.escapeStr (key)).appendC (':');
org.jmol.script.ScriptVariable.sValueArray (sb, ht.get (key), map, level + 1, true);
sep = ", ";
}
sb.append (" }");
break;
}for (var i = 0; i < keys.length; i++) {
sb.append (keys[i]).append ("\t:");
var v = ht.get (keys[i]);
var sb2 =  new org.jmol.util.StringXBuilder ();
org.jmol.script.ScriptVariable.sValueArray (sb2, v, map, level + 1, isEscaped);
var value = sb2.toString ();
sb.append (value.indexOf ("\n") >= 0 ? "\n" : "\t");
sb.append (value).append ("\n");
}
break;
case 7:
if (map.containsKey (vx)) {
sb.append (isEscaped ? "[]" : vx.myName == null ? "<circular reference>" : "<" + vx.myName + ">");
break;
}map.put (vx, Boolean.TRUE);
if (isEscaped) sb.append ("[");
var sx = vx.getList ();
for (var i = 0; i < sx.size (); i++) {
if (isEscaped && i > 0) sb.append (",");
var sv = sx.get (i);
org.jmol.script.ScriptVariable.sValueArray (sb, sv, map, level + 1, isEscaped);
if (!isEscaped) sb.append ("\n");
}
if (isEscaped) sb.append ("]");
break;
default:
if (!isEscaped) for (var j = 0; j < level - 1; j++) sb.append ("\t");

sb.append (isEscaped ? vx.escape () : org.jmol.script.ScriptVariable.sValue (vx));
}
}, $fz.isPrivate = true, $fz), "org.jmol.util.StringXBuilder,org.jmol.script.ScriptVariable,java.util.Map,~N,~B");
c$.ptValue = Clazz.defineMethod (c$, "ptValue", 
function (x) {
switch (x.tok) {
case 8:
return x.value;
case 4:
var o = org.jmol.util.Escape.unescapePoint (x.value);
if (Clazz.instanceOf (o, org.jmol.util.Point3f)) return o;
}
return null;
}, "org.jmol.script.ScriptVariable");
c$.pt4Value = Clazz.defineMethod (c$, "pt4Value", 
function (x) {
switch (x.tok) {
case 9:
return x.value;
case 4:
var o = org.jmol.util.Escape.unescapePoint (x.value);
if (!(Clazz.instanceOf (o, org.jmol.util.Point4f))) break;
return o;
}
return null;
}, "org.jmol.script.ScriptVariable");
c$.toFloat = Clazz.defineMethod (c$, "toFloat", 
($fz = function (s) {
if (s.equalsIgnoreCase ("true")) return 1;
if (s.equalsIgnoreCase ("false") || s.length == 0) return 0;
return org.jmol.util.Parser.parseFloatStrict (s);
}, $fz.isPrivate = true, $fz), "~S");
c$.concatList = Clazz.defineMethod (c$, "concatList", 
function (x1, x2, asNew) {
var v1 = x1.getList ();
var v2 = x2.getList ();
if (!asNew) {
if (v2 == null) v1.add (org.jmol.script.ScriptVariable.newScriptVariableToken (x2));
 else for (var i = 0; i < v2.size (); i++) v1.add (v2.get (i));

return x1;
}var vlist =  new java.util.ArrayList ((v1 == null ? 1 : v1.size ()) + (v2 == null ? 1 : v2.size ()));
if (v1 == null) vlist.add (x1);
 else for (var i = 0; i < v1.size (); i++) vlist.add (v1.get (i));

if (v2 == null) vlist.add (x2);
 else for (var i = 0; i < v2.size (); i++) vlist.add (v2.get (i));

return org.jmol.script.ScriptVariable.getVariableList (vlist);
}, "org.jmol.script.ScriptVariable,org.jmol.script.ScriptVariable,~B");
c$.bsSelectToken = Clazz.defineMethod (c$, "bsSelectToken", 
function (x) {
x = org.jmol.script.ScriptVariable.selectItemTok (x, -2147483648);
return x.value;
}, "org.jmol.script.Token");
c$.bsSelectVar = Clazz.defineMethod (c$, "bsSelectVar", 
function ($var) {
if ($var.index == 2147483647) $var = org.jmol.script.ScriptVariable.selectItemVar ($var);
return $var.value;
}, "org.jmol.script.ScriptVariable");
c$.bsSelectRange = Clazz.defineMethod (c$, "bsSelectRange", 
function (x, n) {
x = org.jmol.script.ScriptVariable.selectItemTok (x);
x = org.jmol.script.ScriptVariable.selectItemTok (x, (n <= 0 ? n : 1));
x = org.jmol.script.ScriptVariable.selectItemTok (x, (n <= 0 ? 2147483646 : n));
return x.value;
}, "org.jmol.script.Token,~N");
c$.selectItemVar = Clazz.defineMethod (c$, "selectItemVar", 
function ($var) {
if ($var.index != 2147483647 || $var.tok == 7 && $var.intValue == 2147483647) return $var;
return org.jmol.script.ScriptVariable.selectItemVar2 ($var, -2147483648);
}, "org.jmol.script.ScriptVariable");
c$.selectItemTok = Clazz.defineMethod (c$, "selectItemTok", 
function ($var) {
return org.jmol.script.ScriptVariable.selectItemTok ($var, -2147483648);
}, "org.jmol.script.Token");
c$.selectItemVar2 = Clazz.defineMethod (c$, "selectItemVar2", 
function ($var, i2) {
return org.jmol.script.ScriptVariable.selectItemTok ($var, i2);
}, "org.jmol.script.ScriptVariable,~N");
c$.selectItemTok = Clazz.defineMethod (c$, "selectItemTok", 
function (tokenIn, i2) {
switch (tokenIn.tok) {
case 11:
case 12:
case 10:
case 7:
case 4:
break;
default:
return tokenIn;
}
var bs = null;
var s = null;
var i1 = tokenIn.intValue;
if (i1 == 2147483647) {
if (i2 == -2147483648) i2 = i1;
var v = org.jmol.script.ScriptVariable.newScriptVariableIntValue (tokenIn.tok, i2, tokenIn.value);
return v;
}var len = 0;
var isInputSelected = (Clazz.instanceOf (tokenIn, org.jmol.script.ScriptVariable) && (tokenIn).index != 2147483647);
var tokenOut = org.jmol.script.ScriptVariable.newScriptVariableIntValue (tokenIn.tok, 2147483647, null);
switch (tokenIn.tok) {
case 10:
if (Clazz.instanceOf (tokenIn.value, org.jmol.modelset.Bond.BondSet)) {
bs =  new org.jmol.modelset.Bond.BondSet (tokenIn.value, (tokenIn.value).getAssociatedAtoms ());
len = org.jmol.util.BitSetUtil.cardinalityOf (bs);
} else {
bs = org.jmol.util.BitSetUtil.copy (tokenIn.value);
len = (isInputSelected ? 1 : org.jmol.util.BitSetUtil.cardinalityOf (bs));
}break;
case 7:
len = (tokenIn).getList ().size ();
break;
case 4:
s = tokenIn.value;
len = s.length;
break;
case 11:
len = -3;
break;
case 12:
len = -4;
break;
}
if (len < 0) {
len = -len;
if (i1 > 0 && Math.abs (i1) > len) {
var col = i1 % 10;
var row = Clazz.doubleToInt ((i1 - col) / 10);
if (col > 0 && col <= len && row <= len) {
if (tokenIn.tok == 11) return org.jmol.script.ScriptVariable.newVariable (3,  new Float ((tokenIn.value).getElement (row - 1, col - 1)));
return org.jmol.script.ScriptVariable.newVariable (3,  new Float ((tokenIn.value).getElement (row - 1, col - 1)));
}return org.jmol.script.ScriptVariable.newVariable (4, "");
}if (Math.abs (i1) > len) return org.jmol.script.ScriptVariable.newVariable (4, "");
var data =  Clazz.newFloatArray (len, 0);
if (len == 3) {
if (i1 < 0) (tokenIn.value).getColumn (-1 - i1, data);
 else (tokenIn.value).getRow (i1 - 1, data);
} else {
if (i1 < 0) (tokenIn.value).getColumn (-1 - i1, data);
 else (tokenIn.value).getRow (i1 - 1, data);
}if (i2 == -2147483648) return org.jmol.script.ScriptVariable.getVariableAF (data);
if (i2 < 1 || i2 > len) return org.jmol.script.ScriptVariable.newVariable (4, "");
return org.jmol.script.ScriptVariable.newVariable (3,  new Float (data[i2 - 1]));
}if (i1 <= 0) i1 = len + i1;
if (i1 < 1) i1 = 1;
if (i2 == 0) i2 = len;
 else if (i2 < 0) i2 = len + i2;
if (i2 > len) i2 = len;
 else if (i2 < i1) i2 = i1;
switch (tokenIn.tok) {
case 10:
tokenOut.value = bs;
if (isInputSelected) {
if (i1 > 1) bs.clearAll ();
break;
}var n = 0;
for (var j = bs.nextSetBit (0); j >= 0; j = bs.nextSetBit (j + 1)) if (++n < i1 || n > i2) bs.clear (j);

break;
case 4:
if (i1 < 1 || i1 > len) tokenOut.value = "";
 else tokenOut.value = s.substring (i1 - 1, i2);
break;
case 7:
if (i1 < 1 || i1 > len || i2 > len) return org.jmol.script.ScriptVariable.newVariable (4, "");
if (i2 == i1) return (tokenIn).getList ().get (i1 - 1);
var o2 =  new java.util.ArrayList ();
var o1 = (tokenIn).getList ();
n = i2 - i1 + 1;
for (var i = 0; i < n; i++) o2.add (org.jmol.script.ScriptVariable.newScriptVariableToken (o1.get (i + i1 - 1)));

tokenOut.value = o2;
break;
}
return tokenOut;
}, "org.jmol.script.Token,~N");
Clazz.defineMethod (c$, "setSelectedValue", 
function (selector, $var) {
if (selector == 2147483647) return false;
var len;
switch (this.tok) {
case 11:
case 12:
len = (this.tok == 11 ? 3 : 4);
if (selector > 10) {
var col = selector % 10;
var row = Clazz.doubleToInt ((selector - col) / 10);
if (col > 0 && col <= len && row <= len) {
if (this.tok == 11) (this.value).setElement (row - 1, col - 1, org.jmol.script.ScriptVariable.fValue ($var));
 else (this.value).setElement (row - 1, col - 1, org.jmol.script.ScriptVariable.fValue ($var));
return true;
}}if (selector != 0 && Math.abs (selector) <= len && $var.tok == 7) {
var sv = $var.getList ();
if (sv.size () == len) {
var data =  Clazz.newFloatArray (len, 0);
for (var i = 0; i < len; i++) data[i] = org.jmol.script.ScriptVariable.fValue (sv.get (i));

if (selector > 0) {
if (this.tok == 11) (this.value).setRowA (selector - 1, data);
 else (this.value).setRow (selector - 1, data);
} else {
if (this.tok == 11) (this.value).setColumnA (-1 - selector, data);
 else (this.value).setColumn (-1 - selector, data);
}return true;
}}return false;
case 4:
var str = this.value;
var pt = str.length;
if (selector <= 0) selector = pt + selector;
if (--selector < 0) selector = 0;
while (selector >= str.length) str += " ";

this.value = str.substring (0, selector) + org.jmol.script.ScriptVariable.sValue ($var) + str.substring (selector + 1);
return true;
case 7:
len = this.getList ().size ();
if (selector <= 0) selector = len + selector;
if (--selector < 0) selector = 0;
if (len <= selector) {
for (var i = len; i <= selector; i++) this.getList ().add (org.jmol.script.ScriptVariable.newVariable (4, ""));

}this.getList ().set (selector, $var);
return true;
}
return false;
}, "~N,org.jmol.script.ScriptVariable");
Clazz.defineMethod (c$, "escape", 
function () {
switch (this.tok) {
case 4:
return org.jmol.util.Escape.escape (this.value);
case 7:
case 6:
var sb =  new org.jmol.util.StringXBuilder ();
var map =  new java.util.Hashtable ();
org.jmol.script.ScriptVariable.sValueArray (sb, this, map, 0, true);
return sb.toString ();
default:
return org.jmol.script.ScriptVariable.sValue (this);
}
});
c$.unescapePointOrBitsetAsVariable = Clazz.defineMethod (c$, "unescapePointOrBitsetAsVariable", 
function (o) {
if (o == null) return o;
var v = null;
var s = null;
if (Clazz.instanceOf (o, org.jmol.script.ScriptVariable)) {
var sv = o;
switch (sv.tok) {
case 8:
case 9:
case 11:
case 12:
case 10:
v = sv.value;
break;
case 4:
s = sv.value;
break;
default:
s = org.jmol.script.ScriptVariable.sValue (sv);
break;
}
} else if (Clazz.instanceOf (o, String)) {
s = o;
}if (s != null && s.length == 0) return s;
if (v == null) v = org.jmol.util.Escape.unescapePointOrBitsetOrMatrixOrArray (s);
if (Clazz.instanceOf (v, org.jmol.util.Point3f)) return (org.jmol.script.ScriptVariable.newVariable (8, v));
if (Clazz.instanceOf (v, org.jmol.util.Point4f)) return org.jmol.script.ScriptVariable.newVariable (9, v);
if (Clazz.instanceOf (v, org.jmol.util.BitSet)) {
if (s != null && s.indexOf ("[{") == 0) v =  new org.jmol.modelset.Bond.BondSet (v);
return org.jmol.script.ScriptVariable.newVariable (10, v);
}if (Clazz.instanceOf (v, org.jmol.util.Matrix3f)) return (org.jmol.script.ScriptVariable.newVariable (11, v));
if (Clazz.instanceOf (v, org.jmol.util.Matrix4f)) return org.jmol.script.ScriptVariable.newVariable (12, v);
return o;
}, "~O");
c$.getBoolean = Clazz.defineMethod (c$, "getBoolean", 
function (value) {
return org.jmol.script.ScriptVariable.newScriptVariableToken (value ? org.jmol.script.ScriptVariable.vT : org.jmol.script.ScriptVariable.vF);
}, "~B");
c$.sprintf = Clazz.defineMethod (c$, "sprintf", 
function (strFormat, $var) {
if ($var == null) return strFormat;
var vd = (strFormat.indexOf ("d") >= 0 || strFormat.indexOf ("i") >= 0 ?  Clazz.newIntArray (1, 0) : null);
var vf = (strFormat.indexOf ("f") >= 0 ?  Clazz.newFloatArray (1, 0) : null);
var ve = (strFormat.indexOf ("e") >= 0 ?  Clazz.newDoubleArray (1, 0) : null);
var getS = (strFormat.indexOf ("s") >= 0);
var getP = (strFormat.indexOf ("p") >= 0 && $var.tok == 8);
var getQ = (strFormat.indexOf ("q") >= 0 && $var.tok == 9);
var of = [vd, vf, ve, null, null, null];
if ($var.tok != 7) return org.jmol.script.ScriptVariable.sprintf (strFormat, $var, of, vd, vf, ve, getS, getP, getQ);
var sv = $var.getList ();
var list2 =  new Array (sv.size ());
for (var i = 0; i < list2.length; i++) list2[i] = org.jmol.script.ScriptVariable.sprintf (strFormat, sv.get (i), of, vd, vf, ve, getS, getP, getQ);

return list2;
}, "~S,org.jmol.script.ScriptVariable");
c$.sprintf = Clazz.defineMethod (c$, "sprintf", 
($fz = function (strFormat, $var, of, vd, vf, ve, getS, getP, getQ) {
if (vd != null) vd[0] = org.jmol.script.ScriptVariable.iValue ($var);
if (vf != null) vf[0] = org.jmol.script.ScriptVariable.fValue ($var);
if (ve != null) ve[0] = org.jmol.script.ScriptVariable.fValue ($var);
if (getS) of[3] = org.jmol.script.ScriptVariable.sValue ($var);
if (getP) of[4] = $var.value;
if (getQ) of[5] = $var.value;
return org.jmol.util.TextFormat.sprintf (strFormat, "IFDspq", of);
}, $fz.isPrivate = true, $fz), "~S,org.jmol.script.ScriptVariable,~A,~A,~A,~A,~B,~B,~B");
c$.sprintfArray = Clazz.defineMethod (c$, "sprintfArray", 
function (args) {
switch (args.length) {
case 0:
return "";
case 1:
return org.jmol.script.ScriptVariable.sValue (args[0]);
}
var format = org.jmol.util.TextFormat.split (org.jmol.util.TextFormat.simpleReplace (org.jmol.script.ScriptVariable.sValue (args[0]), "%%", "\1"), '%');
var sb =  new org.jmol.util.StringXBuilder ();
sb.append (format[0]);
for (var i = 1; i < format.length; i++) {
var ret = org.jmol.script.ScriptVariable.sprintf (org.jmol.util.TextFormat.formatCheck ("%" + format[i]), (i < args.length ? args[i] : null));
if (org.jmol.util.Escape.isAS (ret)) {
var list = ret;
for (var j = 0; j < list.length; j++) sb.append (list[j]).append ("\n");

continue;
}sb.append (ret);
}
return sb.toString ();
}, "~A");
Clazz.defineMethod (c$, "toString", 
function () {
return Clazz.superCall (this, org.jmol.script.ScriptVariable, "toString", []) + "[" + this.myName + " index =" + this.index + " intValue=" + this.intValue + "]";
});
c$.getBitSet = Clazz.defineMethod (c$, "getBitSet", 
function (x, allowNull) {
switch (x.tok) {
case 10:
return org.jmol.script.ScriptVariable.bsSelectVar (x);
case 7:
var bs =  new org.jmol.util.BitSet ();
var sv = x.value;
for (var i = 0; i < sv.size (); i++) if (!sv.get (i).unEscapeBitSetArray (bs) && allowNull) return null;

return bs;
}
return (allowNull ? null :  new org.jmol.util.BitSet ());
}, "org.jmol.script.ScriptVariable,~B");
c$.areEqual = Clazz.defineMethod (c$, "areEqual", 
function (x1, x2) {
if (x1 == null || x2 == null) return false;
if (x1.tok == 4 && x2.tok == 4) return org.jmol.script.ScriptVariable.sValue (x1).equalsIgnoreCase (org.jmol.script.ScriptVariable.sValue (x2));
if (x1.tok == 8 && x2.tok == 8) return ((x1.value).distance (x2.value) < 0.000001);
if (x1.tok == 9 && x2.tok == 9) return ((x1.value).distance (x2.value) < 0.000001);
return (Math.abs (org.jmol.script.ScriptVariable.fValue (x1) - org.jmol.script.ScriptVariable.fValue (x2)) < 0.000001);
}, "org.jmol.script.ScriptVariable,org.jmol.script.ScriptVariable");
Clazz.defineMethod (c$, "sortOrReverse", 
function (arrayPt) {
var x = this.getList ();
if (x == null || x.size () < 2) return this;
if (arrayPt == -2147483648) {
var n = x.size ();
for (var i = 0; i < n; i++) {
var v = x.get (i);
x.set (i, x.get (--n));
x.set (n, v);
}
} else {
java.util.Collections.sort (this.getList (), Clazz.innerTypeInstance (org.jmol.script.ScriptVariable.Sort, this, null, --arrayPt));
}return this;
}, "~N");
Clazz.defineMethod (c$, "unEscapeBitSetArray", 
function (bs) {
switch (this.tok) {
case 4:
var bs1 = org.jmol.util.Escape.unescapeBitset (this.value);
if (bs1 == null) return false;
bs.or (bs1);
return true;
case 10:
bs.or (this.value);
return true;
}
return false;
}, "org.jmol.util.BitSet");
c$.unEscapeBitSetArray = Clazz.defineMethod (c$, "unEscapeBitSetArray", 
function (x, allowNull) {
var bs =  new org.jmol.util.BitSet ();
for (var i = 0; i < x.size (); i++) if (!x.get (i).unEscapeBitSetArray (bs) && allowNull) return null;

return bs;
}, "java.util.ArrayList,~B");
c$.listValue = Clazz.defineMethod (c$, "listValue", 
function (x) {
if (x.tok != 7) return [org.jmol.script.ScriptVariable.sValue (x)];
var sv = (x).getList ();
var list =  new Array (sv.size ());
for (var i = sv.size (); --i >= 0; ) list[i] = org.jmol.script.ScriptVariable.sValue (sv.get (i));

return list;
}, "org.jmol.script.Token");
c$.flistValue = Clazz.defineMethod (c$, "flistValue", 
function (x, nMin) {
if (x.tok != 7) return [org.jmol.script.ScriptVariable.fValue (x)];
var sv = (x).getList ();
var list;
list =  Clazz.newFloatArray (Math.max (nMin, sv.size ()), 0);
if (nMin == 0) nMin = list.length;
for (var i = Math.min (sv.size (), nMin); --i >= 0; ) list[i] = org.jmol.script.ScriptVariable.fValue (sv.get (i));

return list;
}, "org.jmol.script.Token,~N");
Clazz.defineMethod (c$, "toArray", 
function () {
var dim;
var m3 = null;
var m4 = null;
switch (this.tok) {
case 11:
m3 = this.value;
dim = 3;
break;
case 12:
m4 = this.value;
dim = 4;
break;
default:
return;
}
this.tok = 7;
var o2 =  new java.util.ArrayList (dim);
for (var i = 0; i < dim; i++) {
var a =  Clazz.newFloatArray (dim, 0);
if (m3 == null) m4.getRow (i, a);
 else m3.getRow (i, a);
o2.set (i, org.jmol.script.ScriptVariable.getVariableAF (a));
}
this.value = o2;
});
Clazz.defineMethod (c$, "mapValue", 
function (key) {
return (this.tok == 6 ? (this.value).get (key) : null);
}, "~S");
Clazz.defineMethod (c$, "getList", 
function () {
return (this.tok == 7 ? this.value : null);
});
c$.$ScriptVariable$Sort$ = function () {
Clazz.pu$h ();
c$ = Clazz.decorateAsClass (function () {
Clazz.prepareCallback (this, arguments);
this.arrayPt = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.script.ScriptVariable, "Sort", null, java.util.Comparator);
Clazz.makeConstructor (c$, 
function (a) {
this.arrayPt = a;
}, "~N");
Clazz.overrideMethod (c$, "compare", 
function (a, b) {
if (a.tok != b.tok) {
if (a.tok == 3 || a.tok == 2 || b.tok == 3 || b.tok == 2) {
var c = org.jmol.script.ScriptVariable.fValue (a);
var d = org.jmol.script.ScriptVariable.fValue (b);
return (c < d ? -1 : c > d ? 1 : 0);
}if (a.tok == 4 || b.tok == 4) return org.jmol.script.ScriptVariable.sValue (a).compareTo (org.jmol.script.ScriptVariable.sValue (b));
}switch (a.tok) {
case 4:
return org.jmol.script.ScriptVariable.sValue (a).compareTo (org.jmol.script.ScriptVariable.sValue (b));
case 7:
var c = a.getList ();
var d = b.getList ();
if (c.size () != d.size ()) return (c.size () < d.size () ? -1 : 1);
var e = this.arrayPt;
if (e < 0) e += c.size ();
if (e < 0 || e >= c.size ()) return 0;
return this.compare (c.get (e), d.get (e));
default:
var f = org.jmol.script.ScriptVariable.fValue (a);
var g = org.jmol.script.ScriptVariable.fValue (b);
return (f < g ? -1 : f > g ? 1 : 0);
}
}, "org.jmol.script.ScriptVariable,org.jmol.script.ScriptVariable");
c$ = Clazz.p0p ();
};
c$.vT = c$.prototype.vT = org.jmol.script.ScriptVariable.newScriptVariableIntValue (1048589, 1, "true");
c$.vF = c$.prototype.vF = org.jmol.script.ScriptVariable.newScriptVariableIntValue (1048588, 0, "false");
c$.vAll = c$.prototype.vAll = org.jmol.script.ScriptVariable.newVariable (1048579, "all");
Clazz.defineStatics (c$,
"FLAG_CANINCREMENT", 1,
"FLAG_LOCALVAR", 2);
c$.pt0 = c$.prototype.pt0 =  new org.jmol.util.Point3f ();
});
// 
//// org\jmol\util\ArrayUtil.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.ArrayUtil", ["java.util.Arrays"], function () {
c$ = Clazz.declareType (org.jmol.util, "ArrayUtil");
c$.ensureLength = Clazz.defineMethod (c$, "ensureLength", 
function (array, minimumLength) {
if (array != null && org.jmol.util.ArrayUtil.getLength (array) >= minimumLength) return array;
return org.jmol.util.ArrayUtil.arrayCopyObject (array, minimumLength);
}, "~O,~N");
c$.ensureLengthS = Clazz.defineMethod (c$, "ensureLengthS", 
function (array, minimumLength) {
if (array != null && array.length >= minimumLength) return array;
return org.jmol.util.ArrayUtil.arrayCopyS (array, minimumLength);
}, "~A,~N");
c$.ensureLengthA = Clazz.defineMethod (c$, "ensureLengthA", 
function (array, minimumLength) {
if (array != null && array.length >= minimumLength) return array;
return org.jmol.util.ArrayUtil.arrayCopyF (array, minimumLength);
}, "~A,~N");
c$.ensureLengthI = Clazz.defineMethod (c$, "ensureLengthI", 
function (array, minimumLength) {
if (array != null && array.length >= minimumLength) return array;
return org.jmol.util.ArrayUtil.arrayCopyI (array, minimumLength);
}, "~A,~N");
c$.ensureLengthShort = Clazz.defineMethod (c$, "ensureLengthShort", 
function (array, minimumLength) {
if (array != null && array.length >= minimumLength) return array;
return org.jmol.util.ArrayUtil.arrayCopyShort (array, minimumLength);
}, "~A,~N");
c$.ensureLengthByte = Clazz.defineMethod (c$, "ensureLengthByte", 
function (array, minimumLength) {
if (array != null && array.length >= minimumLength) return array;
return org.jmol.util.ArrayUtil.arrayCopyByte (array, minimumLength);
}, "~A,~N");
c$.doubleLength = Clazz.defineMethod (c$, "doubleLength", 
function (array) {
return org.jmol.util.ArrayUtil.arrayCopyObject (array, (array == null ? 16 : 2 * org.jmol.util.ArrayUtil.getLength (array)));
}, "~O");
c$.doubleLengthS = Clazz.defineMethod (c$, "doubleLengthS", 
function (array) {
return org.jmol.util.ArrayUtil.arrayCopyS (array, (array == null ? 16 : 2 * array.length));
}, "~A");
c$.doubleLengthF = Clazz.defineMethod (c$, "doubleLengthF", 
function (array) {
return org.jmol.util.ArrayUtil.arrayCopyF (array, (array == null ? 16 : 2 * array.length));
}, "~A");
c$.doubleLengthI = Clazz.defineMethod (c$, "doubleLengthI", 
function (array) {
return org.jmol.util.ArrayUtil.arrayCopyI (array, (array == null ? 16 : 2 * array.length));
}, "~A");
c$.doubleLengthShort = Clazz.defineMethod (c$, "doubleLengthShort", 
function (array) {
return org.jmol.util.ArrayUtil.arrayCopyShort (array, (array == null ? 16 : 2 * array.length));
}, "~A");
c$.doubleLengthByte = Clazz.defineMethod (c$, "doubleLengthByte", 
function (array) {
return org.jmol.util.ArrayUtil.arrayCopyByte (array, (array == null ? 16 : 2 * array.length));
}, "~A");
c$.doubleLengthBool = Clazz.defineMethod (c$, "doubleLengthBool", 
function (array) {
return org.jmol.util.ArrayUtil.arrayCopyBool (array, (array == null ? 16 : 2 * array.length));
}, "~A");
c$.deleteElements = Clazz.defineMethod (c$, "deleteElements", 
function (array, firstElement, nElements) {
if (nElements == 0 || array == null) return array;
var oldLength = org.jmol.util.ArrayUtil.getLength (array);
if (firstElement >= oldLength) return array;
var n = oldLength - (firstElement + nElements);
if (n < 0) n = 0;
var t = org.jmol.util.ArrayUtil.newInstanceO (array, firstElement + n);
if (firstElement > 0) System.arraycopy (array, 0, t, 0, firstElement);
if (n > 0) System.arraycopy (array, firstElement + nElements, t, firstElement, n);
return t;
}, "~O,~N,~N");
c$.arrayCopyObject = Clazz.defineMethod (c$, "arrayCopyObject", 
function (array, newLength) {
if (array == null) {
return null;
}var oldLength = org.jmol.util.ArrayUtil.getLength (array);
if (newLength == oldLength) return array;
var t = org.jmol.util.ArrayUtil.newInstanceO (array, newLength);
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
return t;
}, "~O,~N");
c$.newInstanceO = Clazz.defineMethod (c$, "newInstanceO", 
($fz = function (array, n) {
{
return new Array(n);
}}, $fz.isPrivate = true, $fz), "~O,~N");
c$.getLength = Clazz.defineMethod (c$, "getLength", 
($fz = function (array) {
{
return array.length
}}, $fz.isPrivate = true, $fz), "~O");
c$.arrayCopyS = Clazz.defineMethod (c$, "arrayCopyS", 
function (array, newLength) {
if (newLength < 0) newLength = array.length;
var t =  new Array (newLength);
if (array != null) {
var oldLength = array.length;
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
}return t;
}, "~A,~N");
c$.arrayCopyII = Clazz.defineMethod (c$, "arrayCopyII", 
function (array, newLength) {
var t = org.jmol.util.ArrayUtil.newInt2 (newLength);
if (array != null) {
var oldLength = array.length;
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
}return t;
}, "~A,~N");
c$.arrayCopyPt = Clazz.defineMethod (c$, "arrayCopyPt", 
function (array, newLength) {
if (newLength < 0) newLength = array.length;
var t =  new Array (newLength);
if (array != null) {
var oldLength = array.length;
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
}return t;
}, "~A,~N");
c$.arrayCopyF = Clazz.defineMethod (c$, "arrayCopyF", 
function (array, newLength) {
if (newLength < 0) newLength = array.length;
var t =  Clazz.newFloatArray (newLength, 0);
if (array != null) {
var oldLength = array.length;
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
}return t;
}, "~A,~N");
c$.arrayCopyI = Clazz.defineMethod (c$, "arrayCopyI", 
function (array, newLength) {
if (newLength < 0) newLength = array.length;
var t =  Clazz.newIntArray (newLength, 0);
if (array != null) {
var oldLength = array.length;
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
}return t;
}, "~A,~N");
c$.arrayCopyRangeI = Clazz.defineMethod (c$, "arrayCopyRangeI", 
function (array, i0, n) {
if (array == null) return null;
var oldLength = array.length;
if (n == -1) n = oldLength;
if (n == -2) n = Clazz.doubleToInt (oldLength / 2);
n = n - i0;
var t =  Clazz.newIntArray (n, 0);
System.arraycopy (array, i0, t, 0, n);
return t;
}, "~A,~N,~N");
c$.arrayCopyRangeRevI = Clazz.defineMethod (c$, "arrayCopyRangeRevI", 
function (array, i0, n) {
if (array == null) return null;
var t = org.jmol.util.ArrayUtil.arrayCopyRangeI (array, i0, n);
if (n < 0) n = array.length;
for (var i = Clazz.doubleToInt (n / 2); --i >= 0; ) org.jmol.util.ArrayUtil.swapInt (t, i, n - 1 - i);

return t;
}, "~A,~N,~N");
c$.arrayCopyShort = Clazz.defineMethod (c$, "arrayCopyShort", 
function (array, newLength) {
if (newLength < 0) newLength = array.length;
var t =  Clazz.newShortArray (newLength, 0);
if (array != null) {
var oldLength = array.length;
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
}return t;
}, "~A,~N");
c$.arrayCopyByte = Clazz.defineMethod (c$, "arrayCopyByte", 
function (array, newLength) {
if (newLength < 0) newLength = array.length;
var t =  Clazz.newByteArray (newLength, 0);
if (array != null) {
var oldLength = array.length;
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
}return t;
}, "~A,~N");
c$.arrayCopyBool = Clazz.defineMethod (c$, "arrayCopyBool", 
function (array, newLength) {
if (newLength < 0) newLength = array.length;
var t =  Clazz.newBooleanArray (newLength, false);
if (array != null) {
var oldLength = array.length;
System.arraycopy (array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
}return t;
}, "~A,~N");
c$.swapInt = Clazz.defineMethod (c$, "swapInt", 
function (array, indexA, indexB) {
var t = array[indexA];
array[indexA] = array[indexB];
array[indexB] = t;
}, "~A,~N,~N");
c$.dumpArray = Clazz.defineMethod (c$, "dumpArray", 
function (msg, A, x1, x2, y1, y2) {
var s = "dumpArray: " + msg + "\n";
for (var x = x1; x <= x2; x++) s += "\t*" + x + "*";

for (var y = y2; y >= y1; y--) {
s += "\n*" + y + "*";
for (var x = x1; x <= x2; x++) s += "\t" + (x < A.length && y < A[x].length ? A[x][y] : NaN);

}
return s;
}, "~S,~A,~N,~N,~N,~N");
c$.dumpIntArray = Clazz.defineMethod (c$, "dumpIntArray", 
function (A, n) {
var str = "";
for (var i = 0; i < n; i++) str += " " + A[i];

return str;
}, "~A,~N");
c$.sortedItem = Clazz.defineMethod (c$, "sortedItem", 
function (v, n) {
if (v.size () == 0) return null;
if (v.size () == 1) return v.get (0);
var keys = v.toArray ( new Array (v.size ()));
java.util.Arrays.sort (keys);
return keys[n % keys.length];
}, "java.util.List,~N");
c$.createArrayOfArrayList = Clazz.defineMethod (c$, "createArrayOfArrayList", 
function (size) {
return  new Array (size);
}, "~N");
c$.createArrayOfHashtable = Clazz.defineMethod (c$, "createArrayOfHashtable", 
function (size) {
return  new Array (size);
}, "~N");
c$.swap = Clazz.defineMethod (c$, "swap", 
function (o, i, j) {
var oi = o[i];
o[i] = o[j];
o[j] = oi;
}, "~A,~N,~N");
c$.newFloat2 = Clazz.defineMethod (c$, "newFloat2", 
function (n) {
{
return Clazz.newArray(n, null);
}}, "~N");
c$.newInt2 = Clazz.defineMethod (c$, "newInt2", 
function (n) {
{
return Clazz.newArray(n, null);
}}, "~N");
c$.newFloat3 = Clazz.defineMethod (c$, "newFloat3", 
function (nx, ny) {
{
return Clazz.newArray(nx, null);
}}, "~N,~N");
c$.newInt4 = Clazz.defineMethod (c$, "newInt4", 
function (n) {
{
return Clazz.newArray(n, null);
}}, "~N");
c$.newShort2 = Clazz.defineMethod (c$, "newShort2", 
function (n) {
{
return Clazz.newArray(n, null);
}}, "~N");
c$.newByte2 = Clazz.defineMethod (c$, "newByte2", 
function (n) {
{
return Clazz.newArray(n, null);
}}, "~N");
});
// 
//// org\jmol\util\BitSet.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.BitSet", ["java.lang.IndexOutOfBoundsException", "$.InternalError", "$.NegativeArraySizeException", "org.jmol.util.StringXBuilder"], function () {
c$ = Clazz.decorateAsClass (function () {
this.words = null;
this.wordsInUse = 0;
this.sizeIsSticky = false;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "BitSet", null, Cloneable);
c$.wordIndex = Clazz.defineMethod (c$, "wordIndex", 
($fz = function (bitIndex) {
return bitIndex >> 5;
}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineMethod (c$, "recalculateWordsInUse", 
($fz = function () {
var i;
for (i = this.wordsInUse - 1; i >= 0; i--) if (this.words[i] != 0) break;

this.wordsInUse = i + 1;
}, $fz.isPrivate = true, $fz));
Clazz.makeConstructor (c$, 
function () {
this.initWords (32);
this.sizeIsSticky = false;
});
c$.newN = Clazz.defineMethod (c$, "newN", 
function (nbits) {
var bs =  new org.jmol.util.BitSet ();
bs.init (nbits);
return bs;
}, "~N");
Clazz.defineMethod (c$, "init", 
($fz = function (nbits) {
if (nbits < 0) throw  new NegativeArraySizeException ("nbits < 0: " + nbits);
this.initWords (nbits);
this.sizeIsSticky = true;
}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineMethod (c$, "initWords", 
($fz = function (nbits) {
this.words =  Clazz.newIntArray (org.jmol.util.BitSet.wordIndex (nbits - 1) + 1, 0);
}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineMethod (c$, "ensureCapacity", 
($fz = function (wordsRequired) {
if (this.words.length < wordsRequired) {
var request = Math.max (2 * this.words.length, wordsRequired);
this.setLength (request);
this.sizeIsSticky = false;
}}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineMethod (c$, "expandTo", 
($fz = function (wordIndex) {
var wordsRequired = wordIndex + 1;
if (this.wordsInUse < wordsRequired) {
this.ensureCapacity (wordsRequired);
this.wordsInUse = wordsRequired;
}}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineMethod (c$, "set", 
function (bitIndex) {
if (bitIndex < 0) throw  new IndexOutOfBoundsException ("bitIndex < 0: " + bitIndex);
var wordIndex = org.jmol.util.BitSet.wordIndex (bitIndex);
this.expandTo (wordIndex);
this.words[wordIndex] |= (1 << bitIndex);
}, "~N");
Clazz.defineMethod (c$, "setBitTo", 
function (bitIndex, value) {
if (value) this.set (bitIndex);
 else this.clear (bitIndex);
}, "~N,~B");
Clazz.defineMethod (c$, "setBits", 
function (fromIndex, toIndex) {
if (fromIndex == toIndex) return;
var startWordIndex = org.jmol.util.BitSet.wordIndex (fromIndex);
var endWordIndex = org.jmol.util.BitSet.wordIndex (toIndex - 1);
this.expandTo (endWordIndex);
var firstWordMask = -1 << fromIndex;
var lastWordMask = -1 >>> -toIndex;
if (startWordIndex == endWordIndex) {
this.words[startWordIndex] |= (firstWordMask & lastWordMask);
} else {
this.words[startWordIndex] |= firstWordMask;
for (var i = startWordIndex + 1; i < endWordIndex; i++) this.words[i] = -1;

this.words[endWordIndex] |= lastWordMask;
}}, "~N,~N");
Clazz.defineMethod (c$, "clear", 
function (bitIndex) {
if (bitIndex < 0) throw  new IndexOutOfBoundsException ("bitIndex < 0: " + bitIndex);
var wordIndex = org.jmol.util.BitSet.wordIndex (bitIndex);
if (wordIndex >= this.wordsInUse) return;
this.words[wordIndex] &= ~(1 << bitIndex);
this.recalculateWordsInUse ();
}, "~N");
Clazz.defineMethod (c$, "clearBits", 
function (fromIndex, toIndex) {
if (fromIndex == toIndex) return;
var startWordIndex = org.jmol.util.BitSet.wordIndex (fromIndex);
if (startWordIndex >= this.wordsInUse) return;
var endWordIndex = org.jmol.util.BitSet.wordIndex (toIndex - 1);
if (endWordIndex >= this.wordsInUse) {
toIndex = this.length ();
endWordIndex = this.wordsInUse - 1;
}var firstWordMask = -1 << fromIndex;
var lastWordMask = -1 >>> -toIndex;
if (startWordIndex == endWordIndex) {
this.words[startWordIndex] &= ~(firstWordMask & lastWordMask);
} else {
this.words[startWordIndex] &= ~firstWordMask;
for (var i = startWordIndex + 1; i < endWordIndex; i++) this.words[i] = 0;

this.words[endWordIndex] &= ~lastWordMask;
}this.recalculateWordsInUse ();
}, "~N,~N");
Clazz.defineMethod (c$, "clearAll", 
function () {
while (this.wordsInUse > 0) this.words[--this.wordsInUse] = 0;

});
Clazz.defineMethod (c$, "get", 
function (bitIndex) {
if (bitIndex < 0) throw  new IndexOutOfBoundsException ("bitIndex < 0: " + bitIndex);
var wordIndex = org.jmol.util.BitSet.wordIndex (bitIndex);
return (wordIndex < this.wordsInUse) && ((this.words[wordIndex] & (1 << bitIndex)) != 0);
}, "~N");
Clazz.defineMethod (c$, "nextSetBit", 
function (fromIndex) {
if (fromIndex < 0) throw  new IndexOutOfBoundsException ("fromIndex < 0: " + fromIndex);
var u = org.jmol.util.BitSet.wordIndex (fromIndex);
if (u >= this.wordsInUse) return -1;
var word = this.words[u] & (-1 << fromIndex);
while (true) {
if (word != 0) return (u * 32) + Integer.numberOfTrailingZeros (word);
if (++u == this.wordsInUse) return -1;
word = this.words[u];
}
}, "~N");
Clazz.defineMethod (c$, "nextClearBit", 
function (fromIndex) {
if (fromIndex < 0) throw  new IndexOutOfBoundsException ("fromIndex < 0: " + fromIndex);
var u = org.jmol.util.BitSet.wordIndex (fromIndex);
if (u >= this.wordsInUse) return fromIndex;
var word = ~this.words[u] & (-1 << fromIndex);
while (true) {
if (word != 0) return (u * 32) + Integer.numberOfTrailingZeros (word);
if (++u == this.wordsInUse) return this.wordsInUse * 32;
word = ~this.words[u];
}
}, "~N");
Clazz.defineMethod (c$, "length", 
function () {
if (this.wordsInUse == 0) return 0;
return 32 * (this.wordsInUse - 1) + (32 - Integer.numberOfLeadingZeros (this.words[this.wordsInUse - 1]));
});
Clazz.defineMethod (c$, "isEmpty", 
function () {
return this.wordsInUse == 0;
});
Clazz.defineMethod (c$, "intersects", 
function (set) {
for (var i = Math.min (this.wordsInUse, set.wordsInUse) - 1; i >= 0; i--) if ((this.words[i] & set.words[i]) != 0) return true;

return false;
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "cardinality", 
function () {
var sum = 0;
for (var i = 0; i < this.wordsInUse; i++) sum += Integer.bitCount (this.words[i]);

return sum;
});
Clazz.defineMethod (c$, "and", 
function (set) {
if (this === set) return;
while (this.wordsInUse > set.wordsInUse) this.words[--this.wordsInUse] = 0;

for (var i = 0; i < this.wordsInUse; i++) this.words[i] &= set.words[i];

this.recalculateWordsInUse ();
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "or", 
function (set) {
if (this === set) return;
var wordsInCommon = Math.min (this.wordsInUse, set.wordsInUse);
if (this.wordsInUse < set.wordsInUse) {
this.ensureCapacity (set.wordsInUse);
this.wordsInUse = set.wordsInUse;
}for (var i = 0; i < wordsInCommon; i++) this.words[i] |= set.words[i];

if (wordsInCommon < set.wordsInUse) System.arraycopy (set.words, wordsInCommon, this.words, wordsInCommon, this.wordsInUse - wordsInCommon);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "xor", 
function (set) {
var wordsInCommon = Math.min (this.wordsInUse, set.wordsInUse);
if (this.wordsInUse < set.wordsInUse) {
this.ensureCapacity (set.wordsInUse);
this.wordsInUse = set.wordsInUse;
}for (var i = 0; i < wordsInCommon; i++) this.words[i] ^= set.words[i];

if (wordsInCommon < set.wordsInUse) System.arraycopy (set.words, wordsInCommon, this.words, wordsInCommon, set.wordsInUse - wordsInCommon);
this.recalculateWordsInUse ();
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "andNot", 
function (set) {
for (var i = Math.min (this.wordsInUse, set.wordsInUse) - 1; i >= 0; i--) this.words[i] &= ~set.words[i];

this.recalculateWordsInUse ();
}, "org.jmol.util.BitSet");
Clazz.overrideMethod (c$, "hashCode", 
function () {
var h = 1234;
for (var i = this.wordsInUse; --i >= 0; ) h ^= this.words[i] * (i + 1);

return ((h >> 32) ^ h);
});
Clazz.defineMethod (c$, "size", 
function () {
return this.words.length * 32;
});
Clazz.overrideMethod (c$, "equals", 
function (obj) {
if (!(Clazz.instanceOf (obj, org.jmol.util.BitSet))) return false;
if (this === obj) return true;
var set = obj;
if (this.wordsInUse != set.wordsInUse) return false;
for (var i = 0; i < this.wordsInUse; i++) if (this.words[i] != set.words[i]) return false;

return true;
}, "~O");
Clazz.defineMethod (c$, "clone", 
function () {
if (!this.sizeIsSticky && this.wordsInUse != this.words.length) this.setLength (this.wordsInUse);
return org.jmol.util.BitSet.copy (this);
});
Clazz.defineMethod (c$, "setLength", 
($fz = function (n) {
var a =  Clazz.newIntArray (n, 0);
System.arraycopy (this.words, 0, a, 0, Math.min (this.wordsInUse, n));
this.words = a;
}, $fz.isPrivate = true, $fz), "~N");
Clazz.overrideMethod (c$, "toString", 
function () {
var numBits = (this.wordsInUse > 128) ? this.cardinality () : this.wordsInUse * 32;
var b = org.jmol.util.StringXBuilder.newN (6 * numBits + 2);
b.appendC ('{');
var i = this.nextSetBit (0);
if (i != -1) {
b.appendI (i);
for (i = this.nextSetBit (i + 1); i >= 0; i = this.nextSetBit (i + 1)) {
var endOfRun = this.nextClearBit (i);
do {
b.append (", ").appendI (i);
} while (++i < endOfRun);
}
}b.appendC ('}');
return b.toString ();
});
c$.copy = Clazz.defineMethod (c$, "copy", 
function (bitsetToCopy) {
try {
var bs = bitsetToCopy.superClone ();
var wordCount = bitsetToCopy.wordsInUse;
if (wordCount == 0) bs.words = org.jmol.util.BitSet.emptyBitmap;
 else {
bs.words =  Clazz.newIntArray (wordCount, 0);
System.arraycopy (bitsetToCopy.words, 0, bs.words, 0, wordCount);
}return bs;
} catch (e) {
if (Clazz.exceptionOf (e, CloneNotSupportedException)) {
throw  new InternalError ();
} else {
throw e;
}
}
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "superClone", 
($fz = function () {
return Clazz.superCall (this, org.jmol.util.BitSet, "clone", []);
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "cardinalityN", 
function (max) {
var n = this.cardinality ();
for (var i = this.length (); --i >= max; ) if (this.get (i)) n--;

return n;
}, "~N");
Clazz.defineStatics (c$,
"ADDRESS_BITS_PER_WORD", 5,
"BITS_PER_WORD", 32,
"WORD_MASK", 0xffffffff,
"emptyBitmap",  Clazz.newIntArray (0, 0));
});
// 
//// org\jmol\util\BitSetUtil.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.BitSet"], "org.jmol.util.BitSetUtil", null, function () {
c$ = Clazz.declareType (org.jmol.util, "BitSetUtil");
c$.newAndSetBit = Clazz.defineMethod (c$, "newAndSetBit", 
function (i) {
var bs = org.jmol.util.BitSetUtil.newBitSet (i + 1);
bs.set (i);
return bs;
}, "~N");
c$.areEqual = Clazz.defineMethod (c$, "areEqual", 
function (a, b) {
return (a == null || b == null ? a == null && b == null : a.equals (b));
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
c$.haveCommon = Clazz.defineMethod (c$, "haveCommon", 
function (a, b) {
return (a == null || b == null ? false : a.intersects (b));
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
c$.cardinalityOf = Clazz.defineMethod (c$, "cardinalityOf", 
function (bs) {
return (bs == null ? 0 : bs.cardinality ());
}, "org.jmol.util.BitSet");
c$.newBitSet2 = Clazz.defineMethod (c$, "newBitSet2", 
function (i0, i1) {
var bs = org.jmol.util.BitSetUtil.newBitSet (i1);
bs.setBits (i0, i1);
return bs;
}, "~N,~N");
c$.setAll = Clazz.defineMethod (c$, "setAll", 
function (n) {
var bs = org.jmol.util.BitSetUtil.newBitSet (n);
bs.setBits (0, n);
return bs;
}, "~N");
c$.andNot = Clazz.defineMethod (c$, "andNot", 
function (a, b) {
if (b != null && a != null) a.andNot (b);
return a;
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
c$.copy = Clazz.defineMethod (c$, "copy", 
function (bs) {
return bs == null ? null : bs.clone ();
}, "org.jmol.util.BitSet");
c$.copy2 = Clazz.defineMethod (c$, "copy2", 
function (a, b) {
if (a == null || b == null) return null;
b.clearAll ();
b.or (a);
return b;
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
c$.copyInvert = Clazz.defineMethod (c$, "copyInvert", 
function (bs, n) {
return (bs == null ? null : org.jmol.util.BitSetUtil.andNot (org.jmol.util.BitSetUtil.setAll (n), bs));
}, "org.jmol.util.BitSet,~N");
c$.invertInPlace = Clazz.defineMethod (c$, "invertInPlace", 
function (bs, n) {
return org.jmol.util.BitSetUtil.copy2 (org.jmol.util.BitSetUtil.copyInvert (bs, n), bs);
}, "org.jmol.util.BitSet,~N");
c$.toggleInPlace = Clazz.defineMethod (c$, "toggleInPlace", 
function (a, b) {
if (a.equals (b)) {
a.clearAll ();
} else if (org.jmol.util.BitSetUtil.andNot (org.jmol.util.BitSetUtil.copy (b), a).length () == 0) {
org.jmol.util.BitSetUtil.andNot (a, b);
} else {
a.or (b);
}return a;
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
c$.deleteBits = Clazz.defineMethod (c$, "deleteBits", 
function (bs, bsDelete) {
if (bs == null || bsDelete == null) return bs;
var ipt = bsDelete.nextSetBit (0);
if (ipt < 0) return bs;
var len = bs.length ();
var lend = Math.min (len, bsDelete.length ());
var i;
for (i = bsDelete.nextClearBit (ipt); i < lend && i >= 0; i = bsDelete.nextClearBit (i + 1)) bs.setBitTo (ipt++, bs.get (i));

for (i = lend; i < len; i++) bs.setBitTo (ipt++, bs.get (i));

if (ipt < len) bs.clearBits (ipt, len);
return bs;
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
c$.newBitSet = Clazz.defineMethod (c$, "newBitSet", 
function (nFree) {
return org.jmol.util.BitSet.newN (nFree);
}, "~N");
c$.bsNull = c$.prototype.bsNull =  new org.jmol.util.BitSet ();
c$.emptySet = c$.prototype.emptySet =  new org.jmol.util.BitSet ();
});
// 
//// org\jmol\util\Matrix3f.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Matrix3f", ["java.lang.ArrayIndexOutOfBoundsException", "org.jmol.util.Tuple3f"], function () {
c$ = Clazz.decorateAsClass (function () {
this.m00 = 0;
this.m01 = 0;
this.m02 = 0;
this.m10 = 0;
this.m11 = 0;
this.m12 = 0;
this.m20 = 0;
this.m21 = 0;
this.m22 = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Matrix3f", null, java.io.Serializable);
Clazz.makeConstructor (c$, 
function () {
});
c$.newA = Clazz.defineMethod (c$, "newA", 
function (v) {
var m =  new org.jmol.util.Matrix3f ();
m.setA (v);
return m;
}, "~A");
c$.newM = Clazz.defineMethod (c$, "newM", 
function (m1) {
var m =  new org.jmol.util.Matrix3f ();
m.m00 = m1.m00;
m.m01 = m1.m01;
m.m02 = m1.m02;
m.m10 = m1.m10;
m.m11 = m1.m11;
m.m12 = m1.m12;
m.m20 = m1.m20;
m.m21 = m1.m21;
m.m22 = m1.m22;
return m;
}, "org.jmol.util.Matrix3f");
Clazz.overrideMethod (c$, "toString", 
function () {
return "[\n  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "]" + "\n  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "]" + "\n  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "] ]";
});
Clazz.defineMethod (c$, "setIdentity", 
function () {
this.m00 = 1.0;
this.m01 = 0.0;
this.m02 = 0.0;
this.m10 = 0.0;
this.m11 = 1.0;
this.m12 = 0.0;
this.m20 = 0.0;
this.m21 = 0.0;
this.m22 = 1.0;
});
Clazz.defineMethod (c$, "setElement", 
function (row, column, value) {
if (row == 0) if (column == 0) this.m00 = value;
 else if (column == 1) this.m01 = value;
 else if (column == 2) this.m02 = value;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
 else if (row == 1) if (column == 0) this.m10 = value;
 else if (column == 1) this.m11 = value;
 else if (column == 2) this.m12 = value;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
 else if (row == 2) if (column == 0) this.m20 = value;
 else if (column == 1) this.m21 = value;
 else if (column == 2) this.m22 = value;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
 else throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 2 and is " + row);
}, "~N,~N,~N");
Clazz.defineMethod (c$, "getElement", 
function (row, column) {
if (row == 0) if (column == 0) return this.m00;
 else if (column == 1) return this.m01;
 else if (column == 2) return this.m02;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
 else if (row == 1) if (column == 0) return this.m10;
 else if (column == 1) return this.m11;
 else if (column == 2) return this.m12;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
 else if (row == 2) if (column == 0) return this.m20;
 else if (column == 1) return this.m21;
 else if (column == 2) return this.m22;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
 else throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 2 and is " + row);
}, "~N,~N");
Clazz.defineMethod (c$, "setRow", 
function (row, x, y, z) {
if (row == 0) {
this.m00 = x;
this.m01 = y;
this.m02 = z;
} else if (row == 1) {
this.m10 = x;
this.m11 = y;
this.m12 = z;
} else if (row == 2) {
this.m20 = x;
this.m21 = y;
this.m22 = z;
} else {
throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 2 and is " + row);
}}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "setRowV", 
function (row, v) {
if (row == 0) {
this.m00 = v.x;
this.m01 = v.y;
this.m02 = v.z;
} else if (row == 1) {
this.m10 = v.x;
this.m11 = v.y;
this.m12 = v.z;
} else if (row == 2) {
this.m20 = v.x;
this.m21 = v.y;
this.m22 = v.z;
} else {
throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 2 and is " + row);
}}, "~N,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "getRow", 
function (row, v) {
if (row == 0) {
v[0] = this.m00;
v[1] = this.m01;
v[2] = this.m02;
} else if (row == 1) {
v[0] = this.m10;
v[1] = this.m11;
v[2] = this.m12;
} else if (row == 2) {
v[0] = this.m20;
v[1] = this.m21;
v[2] = this.m22;
} else {
throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 2 and is " + row);
}}, "~N,~A");
Clazz.defineMethod (c$, "setRowA", 
function (row, v) {
if (row == 0) {
this.m00 = v[0];
this.m01 = v[1];
this.m02 = v[2];
} else if (row == 1) {
this.m10 = v[0];
this.m11 = v[1];
this.m12 = v[2];
} else if (row == 2) {
this.m20 = v[0];
this.m21 = v[1];
this.m22 = v[2];
} else {
throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 2 and is " + row);
}}, "~N,~A");
Clazz.defineMethod (c$, "setColumn", 
function (column, x, y, z) {
if (column == 0) {
this.m00 = x;
this.m10 = y;
this.m20 = z;
} else if (column == 1) {
this.m01 = x;
this.m11 = y;
this.m21 = z;
} else if (column == 2) {
this.m02 = x;
this.m12 = y;
this.m22 = z;
} else {
throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
}}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "setColumnV", 
function (column, v) {
if (column == 0) {
this.m00 = v.x;
this.m10 = v.y;
this.m20 = v.z;
} else if (column == 1) {
this.m01 = v.x;
this.m11 = v.y;
this.m21 = v.z;
} else if (column == 2) {
this.m02 = v.x;
this.m12 = v.y;
this.m22 = v.z;
} else {
throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
}}, "~N,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "setColumnA", 
function (column, v) {
if (column == 0) {
this.m00 = v[0];
this.m10 = v[1];
this.m20 = v[2];
} else if (column == 1) {
this.m01 = v[0];
this.m11 = v[1];
this.m21 = v[2];
} else if (column == 2) {
this.m02 = v[0];
this.m12 = v[1];
this.m22 = v[2];
} else {
throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
}}, "~N,~A");
Clazz.defineMethod (c$, "getColumnV", 
function (column, v) {
if (column == 0) {
v.x = this.m00;
v.y = this.m10;
v.z = this.m20;
} else if (column == 1) {
v.x = this.m01;
v.y = this.m11;
v.z = this.m21;
} else if (column == 2) {
v.x = this.m02;
v.y = this.m12;
v.z = this.m22;
} else {
throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
}}, "~N,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "getColumn", 
function (column, v) {
if (column == 0) {
v[0] = this.m00;
v[1] = this.m10;
v[2] = this.m20;
} else if (column == 1) {
v[0] = this.m01;
v[1] = this.m11;
v[2] = this.m21;
} else if (column == 2) {
v[0] = this.m02;
v[1] = this.m12;
v[2] = this.m22;
} else {
throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 2 and is " + column);
}}, "~N,~A");
Clazz.defineMethod (c$, "add", 
function (m1) {
this.m00 += m1.m00;
this.m01 += m1.m01;
this.m02 += m1.m02;
this.m10 += m1.m10;
this.m11 += m1.m11;
this.m12 += m1.m12;
this.m20 += m1.m20;
this.m21 += m1.m21;
this.m22 += m1.m22;
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "sub", 
function (m1) {
this.m00 -= m1.m00;
this.m01 -= m1.m01;
this.m02 -= m1.m02;
this.m10 -= m1.m10;
this.m11 -= m1.m11;
this.m12 -= m1.m12;
this.m20 -= m1.m20;
this.m21 -= m1.m21;
this.m22 -= m1.m22;
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "transpose", 
function () {
var tmp = this.m01;
this.m01 = this.m10;
this.m10 = tmp;
tmp = this.m02;
this.m02 = this.m20;
this.m20 = tmp;
tmp = this.m12;
this.m12 = this.m21;
this.m21 = tmp;
});
Clazz.defineMethod (c$, "transposeM", 
function (m1) {
this.setM (m1);
this.transpose ();
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "setAA", 
function (a1) {
this.setFromAxisAngle (a1.x, a1.y, a1.z, a1.angle);
}, "org.jmol.util.AxisAngle4f");
Clazz.defineMethod (c$, "setFromAxisAngle", 
($fz = function (x, y, z, angle) {
var n = Math.sqrt (x * x + y * y + z * z);
n = 1 / n;
x *= n;
y *= n;
z *= n;
var c = Math.cos (angle);
var s = Math.sin (angle);
var omc = 1.0 - c;
this.m00 = (c + x * x * omc);
this.m11 = (c + y * y * omc);
this.m22 = (c + z * z * omc);
var tmp1 = x * y * omc;
var tmp2 = z * s;
this.m01 = (tmp1 - tmp2);
this.m10 = (tmp1 + tmp2);
tmp1 = x * z * omc;
tmp2 = y * s;
this.m02 = (tmp1 + tmp2);
this.m20 = (tmp1 - tmp2);
tmp1 = y * z * omc;
tmp2 = x * s;
this.m12 = (tmp1 - tmp2);
this.m21 = (tmp1 + tmp2);
}, $fz.isPrivate = true, $fz), "~N,~N,~N,~N");
Clazz.defineMethod (c$, "setM", 
function (m1) {
this.m00 = m1.m00;
this.m01 = m1.m01;
this.m02 = m1.m02;
this.m10 = m1.m10;
this.m11 = m1.m11;
this.m12 = m1.m12;
this.m20 = m1.m20;
this.m21 = m1.m21;
this.m22 = m1.m22;
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "setA", 
function (m) {
this.m00 = m[0];
this.m01 = m[1];
this.m02 = m[2];
this.m10 = m[3];
this.m11 = m[4];
this.m12 = m[5];
this.m20 = m[6];
this.m21 = m[7];
this.m22 = m[8];
}, "~A");
Clazz.defineMethod (c$, "invertM", 
function (m1) {
this.setM (m1);
this.invert ();
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "invert", 
function () {
var s = this.determinant ();
if (s == 0.0) return;
s = 1 / s;
this.set (this.m11 * this.m22 - this.m12 * this.m21, this.m02 * this.m21 - this.m01 * this.m22, this.m01 * this.m12 - this.m02 * this.m11, this.m12 * this.m20 - this.m10 * this.m22, this.m00 * this.m22 - this.m02 * this.m20, this.m02 * this.m10 - this.m00 * this.m12, this.m10 * this.m21 - this.m11 * this.m20, this.m01 * this.m20 - this.m00 * this.m21, this.m00 * this.m11 - this.m01 * this.m10);
this.mulf (s);
});
Clazz.defineMethod (c$, "determinant", 
function () {
return this.m00 * (this.m11 * this.m22 - this.m21 * this.m12) - this.m01 * (this.m10 * this.m22 - this.m20 * this.m12) + this.m02 * (this.m10 * this.m21 - this.m20 * this.m11);
});
Clazz.defineMethod (c$, "setScale", 
function (scale) {
this.m00 = scale;
this.m01 = 0.0;
this.m02 = 0.0;
this.m10 = 0.0;
this.m11 = scale;
this.m12 = 0.0;
this.m20 = 0.0;
this.m21 = 0.0;
this.m22 = scale;
}, "~N");
Clazz.defineMethod (c$, "rotX", 
function (angle) {
var c = Math.cos (angle);
var s = Math.sin (angle);
this.m00 = 1.0;
this.m01 = 0.0;
this.m02 = 0.0;
this.m10 = 0.0;
this.m11 = c;
this.m12 = -s;
this.m20 = 0.0;
this.m21 = s;
this.m22 = c;
}, "~N");
Clazz.defineMethod (c$, "rotY", 
function (angle) {
var c = Math.cos (angle);
var s = Math.sin (angle);
this.m00 = c;
this.m01 = 0.0;
this.m02 = s;
this.m10 = 0.0;
this.m11 = 1.0;
this.m12 = 0.0;
this.m20 = -s;
this.m21 = 0.0;
this.m22 = c;
}, "~N");
Clazz.defineMethod (c$, "rotZ", 
function (angle) {
var c = Math.cos (angle);
var s = Math.sin (angle);
this.m00 = c;
this.m01 = -s;
this.m02 = 0.0;
this.m10 = s;
this.m11 = c;
this.m12 = 0.0;
this.m20 = 0.0;
this.m21 = 0.0;
this.m22 = 1.0;
}, "~N");
Clazz.defineMethod (c$, "mulf", 
function (scalar) {
this.m00 *= scalar;
this.m01 *= scalar;
this.m02 *= scalar;
this.m10 *= scalar;
this.m11 *= scalar;
this.m12 *= scalar;
this.m20 *= scalar;
this.m21 *= scalar;
this.m22 *= scalar;
}, "~N");
Clazz.defineMethod (c$, "mul", 
function (m1) {
this.mul2 (this, m1);
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "mul2", 
function (m1, m2) {
this.set (m1.m00 * m2.m00 + m1.m01 * m2.m10 + m1.m02 * m2.m20, m1.m00 * m2.m01 + m1.m01 * m2.m11 + m1.m02 * m2.m21, m1.m00 * m2.m02 + m1.m01 * m2.m12 + m1.m02 * m2.m22, m1.m10 * m2.m00 + m1.m11 * m2.m10 + m1.m12 * m2.m20, m1.m10 * m2.m01 + m1.m11 * m2.m11 + m1.m12 * m2.m21, m1.m10 * m2.m02 + m1.m11 * m2.m12 + m1.m12 * m2.m22, m1.m20 * m2.m00 + m1.m21 * m2.m10 + m1.m22 * m2.m20, m1.m20 * m2.m01 + m1.m21 * m2.m11 + m1.m22 * m2.m21, m1.m20 * m2.m02 + m1.m21 * m2.m12 + m1.m22 * m2.m22);
}, "org.jmol.util.Matrix3f,org.jmol.util.Matrix3f");
Clazz.overrideMethod (c$, "equals", 
function (o) {
if (!(Clazz.instanceOf (o, org.jmol.util.Matrix3f))) return false;
var m = o;
return this.m00 == m.m00 && this.m01 == m.m01 && this.m02 == m.m02 && this.m10 == m.m10 && this.m11 == m.m11 && this.m12 == m.m12 && this.m20 == m.m20 && this.m21 == m.m21 && this.m22 == m.m22;
}, "~O");
Clazz.overrideMethod (c$, "hashCode", 
function () {
return org.jmol.util.Tuple3f.floatToIntBits0 (this.m00) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m01) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m02) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m10) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m11) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m12) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m20) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m21) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m22);
});
Clazz.defineMethod (c$, "setZero", 
function () {
this.m00 = 0.0;
this.m01 = 0.0;
this.m02 = 0.0;
this.m10 = 0.0;
this.m11 = 0.0;
this.m12 = 0.0;
this.m20 = 0.0;
this.m21 = 0.0;
this.m22 = 0.0;
});
Clazz.defineMethod (c$, "transform", 
function (t) {
this.transform2 (t, t);
}, "org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "transform2", 
function (t, result) {
result.set (this.m00 * t.x + this.m01 * t.y + this.m02 * t.z, this.m10 * t.x + this.m11 * t.y + this.m12 * t.z, this.m20 * t.x + this.m21 * t.y + this.m22 * t.z);
}, "org.jmol.util.Tuple3f,org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "set", 
($fz = function (m00, m01, m02, m10, m11, m12, m20, m21, m22) {
this.m00 = m00;
this.m01 = m01;
this.m02 = m02;
this.m10 = m10;
this.m11 = m11;
this.m12 = m12;
this.m20 = m20;
this.m21 = m21;
this.m22 = m22;
}, $fz.isPrivate = true, $fz), "~N,~N,~N,~N,~N,~N,~N,~N,~N");
});
// 
//// org\jmol\util\Matrix4f.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Matrix4f", ["java.lang.ArrayIndexOutOfBoundsException", "org.jmol.util.Tuple3f"], function () {
c$ = Clazz.decorateAsClass (function () {
this.m00 = 0;
this.m01 = 0;
this.m02 = 0;
this.m03 = 0;
this.m10 = 0;
this.m11 = 0;
this.m12 = 0;
this.m13 = 0;
this.m20 = 0;
this.m21 = 0;
this.m22 = 0;
this.m23 = 0;
this.m30 = 0;
this.m31 = 0;
this.m32 = 0;
this.m33 = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Matrix4f", null, java.io.Serializable);
Clazz.makeConstructor (c$, 
function () {
});
c$.newA = Clazz.defineMethod (c$, "newA", 
function (v) {
var m =  new org.jmol.util.Matrix4f ();
m.m00 = v[0];
m.m01 = v[1];
m.m02 = v[2];
m.m03 = v[3];
m.m10 = v[4];
m.m11 = v[5];
m.m12 = v[6];
m.m13 = v[7];
m.m20 = v[8];
m.m21 = v[9];
m.m22 = v[10];
m.m23 = v[11];
m.m30 = v[12];
m.m31 = v[13];
m.m32 = v[14];
m.m33 = v[15];
return m;
}, "~A");
c$.newM = Clazz.defineMethod (c$, "newM", 
function (m1) {
var m =  new org.jmol.util.Matrix4f ();
m.m00 = m1.m00;
m.m01 = m1.m01;
m.m02 = m1.m02;
m.m03 = m1.m03;
m.m10 = m1.m10;
m.m11 = m1.m11;
m.m12 = m1.m12;
m.m13 = m1.m13;
m.m20 = m1.m20;
m.m21 = m1.m21;
m.m22 = m1.m22;
m.m23 = m1.m23;
m.m30 = m1.m30;
m.m31 = m1.m31;
m.m32 = m1.m32;
m.m33 = m1.m33;
return m;
}, "org.jmol.util.Matrix4f");
c$.newMV = Clazz.defineMethod (c$, "newMV", 
function (m1, t) {
var m =  new org.jmol.util.Matrix4f ();
m.setMV (m1, t);
return m;
}, "org.jmol.util.Matrix3f,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "setMV", 
function (m1, t) {
this.setM3 (m1);
this.setTranslation (t);
}, "org.jmol.util.Matrix3f,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "setAA", 
function (a1) {
this.setFromAxisAngle (a1.x, a1.y, a1.z, a1.angle);
}, "org.jmol.util.AxisAngle4f");
Clazz.defineMethod (c$, "setFromAxisAngle", 
($fz = function (x, y, z, angle) {
var n = Math.sqrt (x * x + y * y + z * z);
n = 1 / n;
x *= n;
y *= n;
z *= n;
var c = Math.cos (angle);
var s = Math.sin (angle);
var omc = 1.0 - c;
this.m00 = (c + x * x * omc);
this.m11 = (c + y * y * omc);
this.m22 = (c + z * z * omc);
var tmp1 = x * y * omc;
var tmp2 = z * s;
this.m01 = (tmp1 - tmp2);
this.m10 = (tmp1 + tmp2);
tmp1 = x * z * omc;
tmp2 = y * s;
this.m02 = (tmp1 + tmp2);
this.m20 = (tmp1 - tmp2);
tmp1 = y * z * omc;
tmp2 = x * s;
this.m12 = (tmp1 - tmp2);
this.m21 = (tmp1 + tmp2);
}, $fz.isPrivate = true, $fz), "~N,~N,~N,~N");
Clazz.defineMethod (c$, "setM", 
function (m1) {
this.m00 = m1.m00;
this.m01 = m1.m01;
this.m02 = m1.m02;
this.m03 = m1.m03;
this.m10 = m1.m10;
this.m11 = m1.m11;
this.m12 = m1.m12;
this.m13 = m1.m13;
this.m20 = m1.m20;
this.m21 = m1.m21;
this.m22 = m1.m22;
this.m23 = m1.m23;
this.m30 = m1.m30;
this.m31 = m1.m31;
this.m32 = m1.m32;
this.m33 = m1.m33;
}, "org.jmol.util.Matrix4f");
Clazz.overrideMethod (c$, "toString", 
function () {
return "[\n  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "\t" + this.m03 + "]" + "\n  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "\t" + this.m13 + "]" + "\n  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "\t" + this.m23 + "]" + "\n  [" + this.m30 + "\t" + this.m31 + "\t" + this.m32 + "\t" + this.m33 + "] ]";
});
Clazz.defineMethod (c$, "setIdentity", 
function () {
this.m00 = 1.0;
this.m01 = 0.0;
this.m02 = 0.0;
this.m03 = 0.0;
this.m10 = 0.0;
this.m11 = 1.0;
this.m12 = 0.0;
this.m13 = 0.0;
this.m20 = 0.0;
this.m21 = 0.0;
this.m22 = 1.0;
this.m23 = 0.0;
this.m30 = 0.0;
this.m31 = 0.0;
this.m32 = 0.0;
this.m33 = 1.0;
});
Clazz.defineMethod (c$, "setElement", 
function (row, column, value) {
if (row == 0) if (column == 0) this.m00 = value;
 else if (column == 1) this.m01 = value;
 else if (column == 2) this.m02 = value;
 else if (column == 3) this.m03 = value;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
 else if (row == 1) if (column == 0) this.m10 = value;
 else if (column == 1) this.m11 = value;
 else if (column == 2) this.m12 = value;
 else if (column == 3) this.m13 = value;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
 else if (row == 2) if (column == 0) this.m20 = value;
 else if (column == 1) this.m21 = value;
 else if (column == 2) this.m22 = value;
 else if (column == 3) this.m23 = value;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
 else if (row == 3) if (column == 0) this.m30 = value;
 else if (column == 1) this.m31 = value;
 else if (column == 2) this.m32 = value;
 else if (column == 3) this.m33 = value;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
 else throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 2 and is " + row);
}, "~N,~N,~N");
Clazz.defineMethod (c$, "getElement", 
function (row, column) {
if (row == 0) if (column == 0) return this.m00;
 else if (column == 1) return this.m01;
 else if (column == 2) return this.m02;
 else if (column == 3) return this.m03;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
 else if (row == 1) if (column == 0) return this.m10;
 else if (column == 1) return this.m11;
 else if (column == 2) return this.m12;
 else if (column == 3) return this.m13;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
 else if (row == 2) if (column == 0) return this.m20;
 else if (column == 1) return this.m21;
 else if (column == 2) return this.m22;
 else if (column == 3) return this.m23;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
 else if (row == 3) if (column == 0) return this.m30;
 else if (column == 1) return this.m31;
 else if (column == 2) return this.m32;
 else if (column == 3) return this.m33;
 else throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
 else throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 3 and is " + row);
}, "~N,~N");
Clazz.defineMethod (c$, "get", 
function (trans) {
trans.x = this.m03;
trans.y = this.m13;
trans.z = this.m23;
}, "org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "getRotationScale", 
function (m1) {
m1.m00 = this.m00;
m1.m01 = this.m01;
m1.m02 = this.m02;
m1.m10 = this.m10;
m1.m11 = this.m11;
m1.m12 = this.m12;
m1.m20 = this.m20;
m1.m21 = this.m21;
m1.m22 = this.m22;
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "setRotationScale", 
function (m1) {
this.m00 = m1.m00;
this.m01 = m1.m01;
this.m02 = m1.m02;
this.m10 = m1.m10;
this.m11 = m1.m11;
this.m12 = m1.m12;
this.m20 = m1.m20;
this.m21 = m1.m21;
this.m22 = m1.m22;
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "setRow", 
function (row, v) {
if (row == 0) {
this.m00 = v[0];
this.m01 = v[1];
this.m02 = v[2];
this.m03 = v[3];
} else if (row == 1) {
this.m10 = v[0];
this.m11 = v[1];
this.m12 = v[2];
this.m13 = v[3];
} else if (row == 2) {
this.m20 = v[0];
this.m21 = v[1];
this.m22 = v[2];
this.m23 = v[3];
} else if (row == 3) {
this.m30 = v[0];
this.m31 = v[1];
this.m32 = v[2];
this.m33 = v[3];
} else {
throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 3 and is " + row);
}}, "~N,~A");
Clazz.defineMethod (c$, "getRow", 
function (row, v) {
if (row == 0) {
v[0] = this.m00;
v[1] = this.m01;
v[2] = this.m02;
v[3] = this.m03;
} else if (row == 1) {
v[0] = this.m10;
v[1] = this.m11;
v[2] = this.m12;
v[3] = this.m13;
} else if (row == 2) {
v[0] = this.m20;
v[1] = this.m21;
v[2] = this.m22;
v[3] = this.m23;
} else if (row == 3) {
v[0] = this.m30;
v[1] = this.m31;
v[2] = this.m32;
v[3] = this.m33;
} else {
throw  new ArrayIndexOutOfBoundsException ("row must be 0 to 3 and is " + row);
}}, "~N,~A");
Clazz.defineMethod (c$, "setColumn4", 
function (column, x, y, z, w) {
if (column == 0) {
this.m00 = x;
this.m10 = y;
this.m20 = z;
this.m30 = w;
} else if (column == 1) {
this.m01 = x;
this.m11 = y;
this.m21 = z;
this.m31 = w;
} else if (column == 2) {
this.m02 = x;
this.m12 = y;
this.m22 = z;
this.m32 = w;
} else if (column == 3) {
this.m03 = x;
this.m13 = y;
this.m23 = z;
this.m33 = w;
} else {
throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
}}, "~N,~N,~N,~N,~N");
Clazz.defineMethod (c$, "setColumn", 
function (column, v) {
if (column == 0) {
this.m00 = v[0];
this.m10 = v[1];
this.m20 = v[2];
this.m30 = v[3];
} else if (column == 1) {
this.m01 = v[0];
this.m11 = v[1];
this.m21 = v[2];
this.m31 = v[3];
} else if (column == 2) {
this.m02 = v[0];
this.m12 = v[1];
this.m22 = v[2];
this.m32 = v[3];
} else if (column == 3) {
this.m03 = v[0];
this.m13 = v[1];
this.m23 = v[2];
this.m33 = v[3];
} else {
throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
}}, "~N,~A");
Clazz.defineMethod (c$, "getColumn", 
function (column, v) {
if (column == 0) {
v[0] = this.m00;
v[1] = this.m10;
v[2] = this.m20;
v[3] = this.m30;
} else if (column == 1) {
v[0] = this.m01;
v[1] = this.m11;
v[2] = this.m21;
v[3] = this.m31;
} else if (column == 2) {
v[0] = this.m02;
v[1] = this.m12;
v[2] = this.m22;
v[3] = this.m32;
} else if (column == 3) {
v[0] = this.m03;
v[1] = this.m13;
v[2] = this.m23;
v[3] = this.m33;
} else {
throw  new ArrayIndexOutOfBoundsException ("column must be 0 to 3 and is " + column);
}}, "~N,~A");
Clazz.defineMethod (c$, "sub", 
function (m1) {
this.m00 -= m1.m00;
this.m01 -= m1.m01;
this.m02 -= m1.m02;
this.m03 -= m1.m03;
this.m10 -= m1.m10;
this.m11 -= m1.m11;
this.m12 -= m1.m12;
this.m13 -= m1.m13;
this.m20 -= m1.m20;
this.m21 -= m1.m21;
this.m22 -= m1.m22;
this.m23 -= m1.m23;
this.m30 -= m1.m30;
this.m31 -= m1.m31;
this.m32 -= m1.m32;
this.m33 -= m1.m33;
}, "org.jmol.util.Matrix4f");
Clazz.defineMethod (c$, "transpose", 
function () {
var tmp = this.m01;
this.m01 = this.m10;
this.m10 = tmp;
tmp = this.m02;
this.m02 = this.m20;
this.m20 = tmp;
tmp = this.m03;
this.m03 = this.m30;
this.m30 = tmp;
tmp = this.m12;
this.m12 = this.m21;
this.m21 = tmp;
tmp = this.m13;
this.m13 = this.m31;
this.m31 = tmp;
tmp = this.m23;
this.m23 = this.m32;
this.m32 = tmp;
});
Clazz.defineMethod (c$, "invertM", 
function (m1) {
this.setM (m1);
this.invert ();
}, "org.jmol.util.Matrix4f");
Clazz.defineMethod (c$, "invert", 
function () {
var s = this.determinant ();
if (s == 0.0) return;
s = 1 / s;
this.set (this.m11 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m12 * (this.m23 * this.m31 - this.m21 * this.m33) + this.m13 * (this.m21 * this.m32 - this.m22 * this.m31), this.m21 * (this.m02 * this.m33 - this.m03 * this.m32) + this.m22 * (this.m03 * this.m31 - this.m01 * this.m33) + this.m23 * (this.m01 * this.m32 - this.m02 * this.m31), this.m31 * (this.m02 * this.m13 - this.m03 * this.m12) + this.m32 * (this.m03 * this.m11 - this.m01 * this.m13) + this.m33 * (this.m01 * this.m12 - this.m02 * this.m11), this.m01 * (this.m13 * this.m22 - this.m12 * this.m23) + this.m02 * (this.m11 * this.m23 - this.m13 * this.m21) + this.m03 * (this.m12 * this.m21 - this.m11 * this.m22), this.m12 * (this.m20 * this.m33 - this.m23 * this.m30) + this.m13 * (this.m22 * this.m30 - this.m20 * this.m32) + this.m10 * (this.m23 * this.m32 - this.m22 * this.m33), this.m22 * (this.m00 * this.m33 - this.m03 * this.m30) + this.m23 * (this.m02 * this.m30 - this.m00 * this.m32) + this.m20 * (this.m03 * this.m32 - this.m02 * this.m33), this.m32 * (this.m00 * this.m13 - this.m03 * this.m10) + this.m33 * (this.m02 * this.m10 - this.m00 * this.m12) + this.m30 * (this.m03 * this.m12 - this.m02 * this.m13), this.m02 * (this.m13 * this.m20 - this.m10 * this.m23) + this.m03 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m00 * (this.m12 * this.m23 - this.m13 * this.m22), this.m13 * (this.m20 * this.m31 - this.m21 * this.m30) + this.m10 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m11 * (this.m23 * this.m30 - this.m20 * this.m33), this.m23 * (this.m00 * this.m31 - this.m01 * this.m30) + this.m20 * (this.m01 * this.m33 - this.m03 * this.m31) + this.m21 * (this.m03 * this.m30 - this.m00 * this.m33), this.m33 * (this.m00 * this.m11 - this.m01 * this.m10) + this.m30 * (this.m01 * this.m13 - this.m03 * this.m11) + this.m31 * (this.m03 * this.m10 - this.m00 * this.m13), this.m03 * (this.m11 * this.m20 - this.m10 * this.m21) + this.m00 * (this.m13 * this.m21 - this.m11 * this.m23) + this.m01 * (this.m10 * this.m23 - this.m13 * this.m20), this.m10 * (this.m22 * this.m31 - this.m21 * this.m32) + this.m11 * (this.m20 * this.m32 - this.m22 * this.m30) + this.m12 * (this.m21 * this.m30 - this.m20 * this.m31), this.m20 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m21 * (this.m00 * this.m32 - this.m02 * this.m30) + this.m22 * (this.m01 * this.m30 - this.m00 * this.m31), this.m30 * (this.m02 * this.m11 - this.m01 * this.m12) + this.m31 * (this.m00 * this.m12 - this.m02 * this.m10) + this.m32 * (this.m01 * this.m10 - this.m00 * this.m11), this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20));
this.mul (s);
});
Clazz.defineMethod (c$, "determinant", 
function () {
return (this.m00 * this.m11 - this.m01 * this.m10) * (this.m22 * this.m33 - this.m23 * this.m32) - (this.m00 * this.m12 - this.m02 * this.m10) * (this.m21 * this.m33 - this.m23 * this.m31) + (this.m00 * this.m13 - this.m03 * this.m10) * (this.m21 * this.m32 - this.m22 * this.m31) + (this.m01 * this.m12 - this.m02 * this.m11) * (this.m20 * this.m33 - this.m23 * this.m30) - (this.m01 * this.m13 - this.m03 * this.m11) * (this.m20 * this.m32 - this.m22 * this.m30) + (this.m02 * this.m13 - this.m03 * this.m12) * (this.m20 * this.m31 - this.m21 * this.m30);
});
Clazz.defineMethod (c$, "setM3", 
function (m1) {
this.m00 = m1.m00;
this.m01 = m1.m01;
this.m02 = m1.m02;
this.m03 = 0.0;
this.m10 = m1.m10;
this.m11 = m1.m11;
this.m12 = m1.m12;
this.m13 = 0.0;
this.m20 = m1.m20;
this.m21 = m1.m21;
this.m22 = m1.m22;
this.m23 = 0.0;
this.m30 = 0.0;
this.m31 = 0.0;
this.m32 = 0.0;
this.m33 = 1.0;
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "setA", 
function (m) {
this.m00 = m[0];
this.m01 = m[1];
this.m02 = m[2];
this.m03 = m[3];
this.m10 = m[4];
this.m11 = m[5];
this.m12 = m[6];
this.m13 = m[7];
this.m20 = m[8];
this.m21 = m[9];
this.m22 = m[10];
this.m23 = m[11];
this.m30 = m[12];
this.m31 = m[13];
this.m32 = m[14];
this.m33 = m[15];
}, "~A");
Clazz.defineMethod (c$, "setTranslation", 
function (trans) {
this.m03 = trans.x;
this.m13 = trans.y;
this.m23 = trans.z;
}, "org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "rotX", 
function (angle) {
var c = Math.cos (angle);
var s = Math.sin (angle);
this.m00 = 1.0;
this.m01 = 0.0;
this.m02 = 0.0;
this.m03 = 0.0;
this.m10 = 0.0;
this.m11 = c;
this.m12 = -s;
this.m13 = 0.0;
this.m20 = 0.0;
this.m21 = s;
this.m22 = c;
this.m23 = 0.0;
this.m30 = 0.0;
this.m31 = 0.0;
this.m32 = 0.0;
this.m33 = 1.0;
}, "~N");
Clazz.defineMethod (c$, "rotY", 
function (angle) {
var c = Math.cos (angle);
var s = Math.sin (angle);
this.m00 = c;
this.m01 = 0.0;
this.m02 = s;
this.m03 = 0.0;
this.m10 = 0.0;
this.m11 = 1.0;
this.m12 = 0.0;
this.m13 = 0.0;
this.m20 = -s;
this.m21 = 0.0;
this.m22 = c;
this.m23 = 0.0;
this.m30 = 0.0;
this.m31 = 0.0;
this.m32 = 0.0;
this.m33 = 1.0;
}, "~N");
Clazz.defineMethod (c$, "rotZ", 
function (angle) {
var c = Math.cos (angle);
var s = Math.sin (angle);
this.m00 = c;
this.m01 = -s;
this.m02 = 0.0;
this.m03 = 0.0;
this.m10 = s;
this.m11 = c;
this.m12 = 0.0;
this.m13 = 0.0;
this.m20 = 0.0;
this.m21 = 0.0;
this.m22 = 1.0;
this.m23 = 0.0;
this.m30 = 0.0;
this.m31 = 0.0;
this.m32 = 0.0;
this.m33 = 1.0;
}, "~N");
Clazz.defineMethod (c$, "mul", 
($fz = function (scalar) {
this.m00 *= scalar;
this.m01 *= scalar;
this.m02 *= scalar;
this.m03 *= scalar;
this.m10 *= scalar;
this.m11 *= scalar;
this.m12 *= scalar;
this.m13 *= scalar;
this.m20 *= scalar;
this.m21 *= scalar;
this.m22 *= scalar;
this.m23 *= scalar;
this.m30 *= scalar;
this.m31 *= scalar;
this.m32 *= scalar;
this.m33 *= scalar;
}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineMethod (c$, "mul", 
function (m1) {
this.mul2 (this, m1);
}, "org.jmol.util.Matrix4f");
Clazz.defineMethod (c$, "mul2", 
function (m1, m2) {
this.set (m1.m00 * m2.m00 + m1.m01 * m2.m10 + m1.m02 * m2.m20 + m1.m03 * m2.m30, m1.m00 * m2.m01 + m1.m01 * m2.m11 + m1.m02 * m2.m21 + m1.m03 * m2.m31, m1.m00 * m2.m02 + m1.m01 * m2.m12 + m1.m02 * m2.m22 + m1.m03 * m2.m32, m1.m00 * m2.m03 + m1.m01 * m2.m13 + m1.m02 * m2.m23 + m1.m03 * m2.m33, m1.m10 * m2.m00 + m1.m11 * m2.m10 + m1.m12 * m2.m20 + m1.m13 * m2.m30, m1.m10 * m2.m01 + m1.m11 * m2.m11 + m1.m12 * m2.m21 + m1.m13 * m2.m31, m1.m10 * m2.m02 + m1.m11 * m2.m12 + m1.m12 * m2.m22 + m1.m13 * m2.m32, m1.m10 * m2.m03 + m1.m11 * m2.m13 + m1.m12 * m2.m23 + m1.m13 * m2.m33, m1.m20 * m2.m00 + m1.m21 * m2.m10 + m1.m22 * m2.m20 + m1.m23 * m2.m30, m1.m20 * m2.m01 + m1.m21 * m2.m11 + m1.m22 * m2.m21 + m1.m23 * m2.m31, m1.m20 * m2.m02 + m1.m21 * m2.m12 + m1.m22 * m2.m22 + m1.m23 * m2.m32, m1.m20 * m2.m03 + m1.m21 * m2.m13 + m1.m22 * m2.m23 + m1.m23 * m2.m33, m1.m30 * m2.m00 + m1.m31 * m2.m10 + m1.m32 * m2.m20 + m1.m33 * m2.m30, m1.m30 * m2.m01 + m1.m31 * m2.m11 + m1.m32 * m2.m21 + m1.m33 * m2.m31, m1.m30 * m2.m02 + m1.m31 * m2.m12 + m1.m32 * m2.m22 + m1.m33 * m2.m32, m1.m30 * m2.m03 + m1.m31 * m2.m13 + m1.m32 * m2.m23 + m1.m33 * m2.m33);
}, "org.jmol.util.Matrix4f,org.jmol.util.Matrix4f");
Clazz.overrideMethod (c$, "equals", 
function (o) {
if (!(Clazz.instanceOf (o, org.jmol.util.Matrix4f))) return false;
var m = o;
return (this.m00 == m.m00 && this.m01 == m.m01 && this.m02 == m.m02 && this.m03 == m.m03 && this.m10 == m.m10 && this.m11 == m.m11 && this.m12 == m.m12 && this.m13 == m.m13 && this.m20 == m.m20 && this.m21 == m.m21 && this.m22 == m.m22 && this.m23 == m.m23 && this.m30 == m.m30 && this.m31 == m.m31 && this.m32 == m.m32 && this.m33 == m.m33);
}, "~O");
Clazz.overrideMethod (c$, "hashCode", 
function () {
return org.jmol.util.Tuple3f.floatToIntBits0 (this.m00) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m01) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m02) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m03) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m10) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m11) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m12) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m13) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m20) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m21) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m22) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m23) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m30) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m31) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m32) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.m33);
});
Clazz.defineMethod (c$, "transformT2", 
function (vec, vecOut) {
vecOut.set (this.m00 * vec.x + this.m01 * vec.y + this.m02 * vec.z + this.m03 * vec.w, this.m10 * vec.x + this.m11 * vec.y + this.m12 * vec.z + this.m13 * vec.w, this.m20 * vec.x + this.m21 * vec.y + this.m22 * vec.z + this.m23 * vec.w, this.m30 * vec.x + this.m31 * vec.y + this.m32 * vec.z + this.m33 * vec.w);
}, "org.jmol.util.Tuple4f,org.jmol.util.Tuple4f");
Clazz.defineMethod (c$, "transform4", 
function (vec) {
this.transformT2 (vec, vec);
}, "org.jmol.util.Tuple4f");
Clazz.defineMethod (c$, "transform2", 
function (point, pointOut) {
try {
pointOut.set (this.m00 * point.x + this.m01 * point.y + this.m02 * point.z + this.m03, this.m10 * point.x + this.m11 * point.y + this.m12 * point.z + this.m13, this.m20 * point.x + this.m21 * point.y + this.m22 * point.z + this.m23);
} catch (e) {
if (Clazz.exceptionOf (e, NullPointerException)) {
} else {
throw e;
}
}
}, "org.jmol.util.Point3f,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "transform", 
function (point) {
this.transform2 (point, point);
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "transformV2", 
function (normal, normalOut) {
normalOut.set (this.m00 * normal.x + this.m01 * normal.y + this.m02 * normal.z, this.m10 * normal.x + this.m11 * normal.y + this.m12 * normal.z, this.m20 * normal.x + this.m21 * normal.y + this.m22 * normal.z);
}, "org.jmol.util.Vector3f,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "transformV", 
function (normal) {
this.transformV2 (normal, normal);
}, "org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "setZero", 
function () {
this.m00 = 0.0;
this.m01 = 0.0;
this.m02 = 0.0;
this.m03 = 0.0;
this.m10 = 0.0;
this.m11 = 0.0;
this.m12 = 0.0;
this.m13 = 0.0;
this.m20 = 0.0;
this.m21 = 0.0;
this.m22 = 0.0;
this.m23 = 0.0;
this.m30 = 0.0;
this.m31 = 0.0;
this.m32 = 0.0;
this.m33 = 0.0;
});
Clazz.defineMethod (c$, "set", 
($fz = function (m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
this.m00 = m00;
this.m01 = m01;
this.m02 = m02;
this.m03 = m03;
this.m10 = m10;
this.m11 = m11;
this.m12 = m12;
this.m13 = m13;
this.m20 = m20;
this.m21 = m21;
this.m22 = m22;
this.m23 = m23;
this.m30 = m30;
this.m31 = m31;
this.m32 = m32;
this.m33 = m33;
}, $fz.isPrivate = true, $fz), "~N,~N,~N,~N,~N,~N,~N,~N,~N,~N,~N,~N,~N,~N,~N,~N");
});
// 
//// org\jmol\util\JmolEdge.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["java.lang.Enum"], "org.jmol.util.JmolEdge", null, function () {
c$ = Clazz.decorateAsClass (function () {
this.index = -1;
this.order = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "JmolEdge");
c$.getArgbHbondType = Clazz.defineMethod (c$, "getArgbHbondType", 
function (order) {
var argbIndex = ((order & 30720) >> 11);
return org.jmol.util.JmolEdge.argbsHbondType[argbIndex];
}, "~N");
c$.getBondOrderNumberFromOrder = Clazz.defineMethod (c$, "getBondOrderNumberFromOrder", 
function (order) {
order &= -131073;
if (order == 131071 || order == 65535) return "0";
if (org.jmol.modelset.Bond.isHydrogen (order) || (order & 256) != 0) return org.jmol.util.JmolEdge.EnumBondOrder.SINGLE.number;
if ((order & 224) != 0) return (order >> 5) + "." + (order & 0x1F);
return org.jmol.util.JmolEdge.EnumBondOrder.getNumberFromCode (order);
}, "~N");
c$.getCmlBondOrder = Clazz.defineMethod (c$, "getCmlBondOrder", 
function (order) {
var sname = org.jmol.util.JmolEdge.getBondOrderNameFromOrder (order);
switch (sname.charAt (0)) {
case 's':
case 'd':
case 't':
return "" + sname.toUpperCase ().charAt (0);
case 'a':
if (sname.indexOf ("Double") >= 0) return "D";
 else if (sname.indexOf ("Single") >= 0) return "S";
return "aromatic";
case 'p':
if (sname.indexOf (" ") >= 0) return sname.substring (sname.indexOf (" ") + 1);
return "partial12";
}
return null;
}, "~N");
c$.getBondOrderNameFromOrder = Clazz.defineMethod (c$, "getBondOrderNameFromOrder", 
function (order) {
order &= -131073;
switch (order) {
case 65535:
case 131071:
return "";
case 32768:
return org.jmol.util.JmolEdge.EnumBondOrder.STRUT.$$name;
case 1:
return org.jmol.util.JmolEdge.EnumBondOrder.SINGLE.$$name;
case 2:
return org.jmol.util.JmolEdge.EnumBondOrder.DOUBLE.$$name;
}
if ((order & 224) != 0) return "partial " + org.jmol.util.JmolEdge.getBondOrderNumberFromOrder (order);
if (org.jmol.modelset.Bond.isHydrogen (order)) return org.jmol.util.JmolEdge.EnumBondOrder.H_REGULAR.$$name;
if ((order & 256) != 0) return org.jmol.util.JmolEdge.EnumBondOrder.SINGLE.$$name;
return org.jmol.util.JmolEdge.EnumBondOrder.getNameFromCode (order);
}, "~N");
c$.getPartialBondDotted = Clazz.defineMethod (c$, "getPartialBondDotted", 
function (order) {
return (order & 0x1F);
}, "~N");
c$.getPartialBondOrder = Clazz.defineMethod (c$, "getPartialBondOrder", 
function (order) {
return ((order & -131073) >> 5);
}, "~N");
c$.getCovalentBondOrder = Clazz.defineMethod (c$, "getCovalentBondOrder", 
function (order) {
if ((order & 1023) == 0) return 0;
order &= -131073;
if ((order & 224) != 0) return org.jmol.util.JmolEdge.getPartialBondOrder (order);
if ((order & 256) != 0) order &= -257;
if ((order & 0xF8) != 0) order = 1;
return order & 7;
}, "~N");
c$.getBondOrderFromFloat = Clazz.defineMethod (c$, "getBondOrderFromFloat", 
function (fOrder) {
switch (Clazz.floatToInt (fOrder * 10)) {
case 10:
return 1;
case 5:
case -10:
return 33;
case 15:
return 515;
case -15:
return 66;
case 20:
return 2;
case 25:
return 97;
case -25:
return 100;
case 30:
return 3;
case 40:
return 4;
}
return 131071;
}, "~N");
c$.getBondOrderFromString = Clazz.defineMethod (c$, "getBondOrderFromString", 
function (name) {
return org.jmol.util.JmolEdge.EnumBondOrder.getCodeFromName (name);
}, "~S");
Clazz.pu$h ();
c$ = Clazz.decorateAsClass (function () {
this.code = 0;
this.number = null;
this.$$name = null;
Clazz.instantialize (this, arguments);
}, org.jmol.util.JmolEdge, "EnumBondOrder", Enum);
Clazz.makeConstructor (c$, 
($fz = function (a, b, c) {
this.code = a;
this.number = b;
this.$$name = c;
}, $fz.isPrivate = true, $fz), "~N,~S,~S");
c$.getCodeFromName = Clazz.defineMethod (c$, "getCodeFromName", 
function (a) {
for (var item, $item = 0, $$item = org.jmol.util.JmolEdge.EnumBondOrder.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (item.$$name.equalsIgnoreCase (a)) return item.code;

return 131071;
}, "~S");
c$.getNameFromCode = Clazz.defineMethod (c$, "getNameFromCode", 
function (a) {
for (var item, $item = 0, $$item = org.jmol.util.JmolEdge.EnumBondOrder.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (item.code == a) return item.$$name;

return "?";
}, "~N");
c$.getNumberFromCode = Clazz.defineMethod (c$, "getNumberFromCode", 
function (a) {
for (var item, $item = 0, $$item = org.jmol.util.JmolEdge.EnumBondOrder.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (item.code == a) return item.number;

return "?";
}, "~N");
Clazz.defineEnumConstant (c$, "SINGLE", 0, [1, "1", "single"]);
Clazz.defineEnumConstant (c$, "DOUBLE", 1, [2, "2", "double"]);
Clazz.defineEnumConstant (c$, "TRIPLE", 2, [3, "3", "triple"]);
Clazz.defineEnumConstant (c$, "QUADRUPLE", 3, [4, "4", "quadruple"]);
Clazz.defineEnumConstant (c$, "AROMATIC", 4, [515, "1.5", "aromatic"]);
Clazz.defineEnumConstant (c$, "STRUT", 5, [32768, "1", "struts"]);
Clazz.defineEnumConstant (c$, "H_REGULAR", 6, [2048, "1", "hbond"]);
Clazz.defineEnumConstant (c$, "PARTIAL01", 7, [33, "0.5", "partial"]);
Clazz.defineEnumConstant (c$, "PARTIAL12", 8, [66, "1.5", "partialDouble"]);
Clazz.defineEnumConstant (c$, "PARTIAL23", 9, [97, "2.5", "partialTriple"]);
Clazz.defineEnumConstant (c$, "PARTIAL32", 10, [100, "2.5", "partialTriple2"]);
Clazz.defineEnumConstant (c$, "AROMATIC_SINGLE", 11, [513, "1", "aromaticSingle"]);
Clazz.defineEnumConstant (c$, "AROMATIC_DOUBLE", 12, [514, "2", "aromaticDouble"]);
Clazz.defineEnumConstant (c$, "UNSPECIFIED", 13, [17, "1", "unspecified"]);
c$ = Clazz.p0p ();
Clazz.defineStatics (c$,
"BOND_STEREO_MASK", 0x400,
"BOND_STEREO_NEAR", 0x401,
"BOND_STEREO_FAR", 0x411,
"BOND_AROMATIC_MASK", 0x200,
"BOND_AROMATIC_SINGLE", 0x201,
"BOND_AROMATIC_DOUBLE", 0x202,
"BOND_AROMATIC", 0x203,
"BOND_SULFUR_MASK", 0x100,
"BOND_PARTIAL_MASK", 0xE0,
"BOND_PARTIAL01", 0x21,
"BOND_PARTIAL12", 0x42,
"BOND_PARTIAL23", 0x61,
"BOND_PARTIAL32", 0x64,
"BOND_COVALENT_MASK", 0x3FF,
"BOND_COVALENT_SINGLE", 1,
"BOND_COVALENT_DOUBLE", 2,
"BOND_COVALENT_TRIPLE", 3,
"BOND_COVALENT_QUADRUPLE", 4,
"BOND_ORDER_UNSPECIFIED", 0x11,
"BOND_ORDER_ANY", 0xFFFF,
"BOND_ORDER_NULL", 0x1FFFF,
"BOND_NEW", 0x20000,
"BOND_STRUT", 0x8000,
"BOND_HBOND_SHIFT", 11,
"BOND_HYDROGEN_MASK", 30720,
"BOND_H_REGULAR", 2048,
"BOND_H_CALC_MASK", 28672,
"BOND_H_CALC", 4096,
"BOND_H_PLUS_2", 6144,
"BOND_H_PLUS_3", 8192,
"BOND_H_PLUS_4", 10240,
"BOND_H_PLUS_5", 12288,
"BOND_H_MINUS_3", 14336,
"BOND_H_MINUS_4", 16384,
"BOND_H_NUCLEOTIDE", 18432,
"argbsHbondType", [0xFFFF69B4, 0xFFFFFF00, 0xFFFFFF00, 0xFFFFFFFF, 0xFFFF00FF, 0xFFFF0000, 0xFFFFA500, 0xFF00FFFF, 0xFF00FF00, 0xFFFF8080],
"FLAG_AROMATIC_DOUBLE", 16,
"FLAG_AROMATIC_DEFINED", 8,
"FLAG_AROMATIC_STRICT", 4,
"FLAG_IGNORE_STEREOCHEMISTRY", 2,
"FLAG_NO_AROMATIC", 1);
});
// 
//// org\jmol\modelset\Bond.js 
// 
Clazz.declarePackage ("org.jmol.modelset");
Clazz.load (["org.jmol.util.BitSet", "$.JmolEdge", "org.jmol.viewer.JmolConstants"], "org.jmol.modelset.Bond", ["org.jmol.util.BitSetUtil", "$.Colix"], function () {
c$ = Clazz.decorateAsClass (function () {
this.atom1 = null;
this.atom2 = null;
this.mad = 0;
this.colix = 0;
this.shapeVisibilityFlags = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.modelset, "Bond", org.jmol.util.JmolEdge);
Clazz.defineMethod (c$, "getMad", 
function () {
return this.mad;
});
Clazz.defineMethod (c$, "getColix", 
function () {
return this.colix;
});
Clazz.makeConstructor (c$, 
function (atom1, atom2, order, mad, colix) {
Clazz.superConstructor (this, org.jmol.modelset.Bond, []);
this.atom1 = atom1;
this.atom2 = atom2;
this.colix = colix;
this.setOrder (order);
this.setMad (mad);
}, "org.jmol.modelset.Atom,org.jmol.modelset.Atom,~N,~N,~N");
Clazz.defineMethod (c$, "setMad", 
function (mad) {
this.mad = mad;
this.setShapeVisibility (mad != 0);
}, "~N");
Clazz.defineMethod (c$, "setShapeVisibilityFlags", 
function (shapeVisibilityFlags) {
this.shapeVisibilityFlags = shapeVisibilityFlags;
}, "~N");
Clazz.defineMethod (c$, "getShapeVisibilityFlags", 
function () {
return this.shapeVisibilityFlags;
});
Clazz.defineMethod (c$, "setShapeVisibility", 
function (isVisible) {
var wasVisible = ((this.shapeVisibilityFlags & org.jmol.modelset.Bond.myVisibilityFlag) != 0);
if (wasVisible == isVisible) return;
this.atom1.addDisplayedBond (org.jmol.modelset.Bond.myVisibilityFlag, isVisible);
this.atom2.addDisplayedBond (org.jmol.modelset.Bond.myVisibilityFlag, isVisible);
if (isVisible) this.shapeVisibilityFlags |= org.jmol.modelset.Bond.myVisibilityFlag;
 else this.shapeVisibilityFlags &= ~org.jmol.modelset.Bond.myVisibilityFlag;
}, "~B");
Clazz.defineMethod (c$, "getIdentity", 
function () {
return (this.index + 1) + " " + this.getOrderNumberAsString () + " " + this.atom1.getInfo () + " -- " + this.atom2.getInfo () + " " + this.atom1.distance (this.atom2);
});
Clazz.overrideMethod (c$, "isCovalent", 
function () {
return (this.order & 1023) != 0;
});
Clazz.defineMethod (c$, "isHydrogen", 
function () {
return org.jmol.modelset.Bond.isHydrogen (this.order);
});
c$.isHydrogen = Clazz.defineMethod (c$, "isHydrogen", 
function (order) {
return (order & 30720) != 0;
}, "~N");
Clazz.defineMethod (c$, "isStereo", 
function () {
return (this.order & 1024) != 0;
});
Clazz.defineMethod (c$, "isPartial", 
function () {
return (this.order & 224) != 0;
});
Clazz.defineMethod (c$, "isAromatic", 
function () {
return (this.order & 512) != 0;
});
Clazz.defineMethod (c$, "setPaletteID", 
function (pid) {
}, "~N");
Clazz.defineMethod (c$, "getEnergy", 
function () {
return 0;
});
Clazz.defineMethod (c$, "getValence", 
function () {
return (!this.isCovalent () ? 0 : this.isPartial () || this.is (515) ? 1 : this.order & 7);
});
Clazz.defineMethod (c$, "deleteAtomReferences", 
function () {
if (this.atom1 != null) this.atom1.deleteBond (this);
if (this.atom2 != null) this.atom2.deleteBond (this);
this.atom1 = this.atom2 = null;
});
Clazz.defineMethod (c$, "setColix", 
function (colix) {
this.colix = colix;
}, "~N");
Clazz.defineMethod (c$, "setTranslucent", 
function (isTranslucent, translucentLevel) {
this.colix = org.jmol.util.Colix.getColixTranslucent3 (this.colix, isTranslucent, translucentLevel);
}, "~B,~N");
Clazz.defineMethod (c$, "isTranslucent", 
function () {
return org.jmol.util.Colix.isColixTranslucent (this.colix);
});
Clazz.defineMethod (c$, "setOrder", 
function (order) {
if (this.atom1.getElementNumber () == 16 && this.atom2.getElementNumber () == 16) order |= 256;
if (order == 512) order = 515;
this.order = order | (this.order & 131072);
}, "~N");
Clazz.defineMethod (c$, "getAtom1", 
function () {
return this.atom1;
});
Clazz.defineMethod (c$, "getAtom2", 
function () {
return this.atom2;
});
Clazz.overrideMethod (c$, "getAtomIndex1", 
function () {
return this.atom1.index;
});
Clazz.overrideMethod (c$, "getAtomIndex2", 
function () {
return this.atom2.index;
});
Clazz.defineMethod (c$, "getRadius", 
function () {
return this.mad / 2000;
});
Clazz.overrideMethod (c$, "getCovalentOrder", 
function () {
return org.jmol.util.JmolEdge.getCovalentBondOrder (this.order);
});
Clazz.defineMethod (c$, "getOrderName", 
function () {
return org.jmol.util.JmolEdge.getBondOrderNameFromOrder (this.order);
});
Clazz.defineMethod (c$, "getOrderNumberAsString", 
function () {
return org.jmol.util.JmolEdge.getBondOrderNumberFromOrder (this.order);
});
Clazz.defineMethod (c$, "getColix1", 
function () {
return org.jmol.util.Colix.getColixInherited (this.colix, this.atom1.colixAtom);
});
Clazz.defineMethod (c$, "getColix2", 
function () {
return org.jmol.util.Colix.getColixInherited (this.colix, this.atom2.colixAtom);
});
Clazz.defineMethod (c$, "getOtherAtom", 
function (thisAtom) {
return (this.atom1 === thisAtom ? this.atom2 : this.atom2 === thisAtom ? this.atom1 : null);
}, "org.jmol.modelset.Atom");
Clazz.defineMethod (c$, "setIndex", 
function (i) {
this.index = i;
}, "~N");
Clazz.defineMethod (c$, "is", 
function (bondType) {
return (this.order & -131073) == bondType;
}, "~N");
Clazz.overrideMethod (c$, "getOtherAtomNode", 
function (thisAtom) {
return (this.atom1 === thisAtom ? this.atom2 : this.atom2 === thisAtom ? this.atom1 : null);
}, "org.jmol.util.JmolNode");
Clazz.overrideMethod (c$, "toString", 
function () {
return this.atom1 + " - " + this.atom2;
});
Clazz.pu$h ();
c$ = Clazz.decorateAsClass (function () {
this.associatedAtoms = null;
Clazz.instantialize (this, arguments);
}, org.jmol.modelset.Bond, "BondSet", org.jmol.util.BitSet);
Clazz.makeConstructor (c$, 
function () {
Clazz.superConstructor (this, org.jmol.modelset.Bond.BondSet, []);
});
Clazz.defineMethod (c$, "getAssociatedAtoms", 
function () {
return this.associatedAtoms;
});
Clazz.makeConstructor (c$, 
function (a) {
Clazz.superConstructor (this, org.jmol.modelset.Bond.BondSet, []);
org.jmol.util.BitSetUtil.copy2 (a, this);
}, "org.jmol.util.BitSet");
Clazz.makeConstructor (c$, 
function (a, b) {
this.construct (a);
this.associatedAtoms = b;
}, "org.jmol.util.BitSet,~A");
c$ = Clazz.p0p ();
c$.myVisibilityFlag = c$.prototype.myVisibilityFlag = org.jmol.viewer.JmolConstants.getShapeVisibilityFlag (1);
});
// 
//// org\jmol\util\Measure.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Measure", ["java.lang.Float", "java.util.ArrayList", "org.jmol.util.Eigen", "$.Escape", "$.Logger", "$.Point3f", "$.Point4f", "$.Quaternion", "$.Vector3f", "org.jmol.viewer.JmolConstants"], function () {
c$ = Clazz.declareType (org.jmol.util, "Measure");
c$.computeAngle = Clazz.defineMethod (c$, "computeAngle", 
function (pointA, pointB, pointC, vectorBA, vectorBC, asDegrees) {
vectorBA.sub2 (pointA, pointB);
vectorBC.sub2 (pointC, pointB);
var angle = vectorBA.angle (vectorBC);
return (asDegrees ? angle / 0.017453292 : angle);
}, "org.jmol.util.Tuple3f,org.jmol.util.Tuple3f,org.jmol.util.Tuple3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,~B");
c$.computeAngleABC = Clazz.defineMethod (c$, "computeAngleABC", 
function (pointA, pointB, pointC, asDegrees) {
var vectorBA =  new org.jmol.util.Vector3f ();
var vectorBC =  new org.jmol.util.Vector3f ();
return org.jmol.util.Measure.computeAngle (pointA, pointB, pointC, vectorBA, vectorBC, asDegrees);
}, "org.jmol.util.Tuple3f,org.jmol.util.Tuple3f,org.jmol.util.Tuple3f,~B");
c$.computeTorsion = Clazz.defineMethod (c$, "computeTorsion", 
function (p1, p2, p3, p4, asDegrees) {
var ijx = p1.x - p2.x;
var ijy = p1.y - p2.y;
var ijz = p1.z - p2.z;
var kjx = p3.x - p2.x;
var kjy = p3.y - p2.y;
var kjz = p3.z - p2.z;
var klx = p3.x - p4.x;
var kly = p3.y - p4.y;
var klz = p3.z - p4.z;
var ax = ijy * kjz - ijz * kjy;
var ay = ijz * kjx - ijx * kjz;
var az = ijx * kjy - ijy * kjx;
var cx = kjy * klz - kjz * kly;
var cy = kjz * klx - kjx * klz;
var cz = kjx * kly - kjy * klx;
var ai2 = 1 / (ax * ax + ay * ay + az * az);
var ci2 = 1 / (cx * cx + cy * cy + cz * cz);
var ai = Math.sqrt (ai2);
var ci = Math.sqrt (ci2);
var denom = ai * ci;
var cross = ax * cx + ay * cy + az * cz;
var cosang = cross * denom;
if (cosang > 1) {
cosang = 1;
}if (cosang < -1) {
cosang = -1;
}var torsion = Math.acos (cosang);
var dot = ijx * cx + ijy * cy + ijz * cz;
var absDot = Math.abs (dot);
torsion = (dot / absDot > 0) ? torsion : -torsion;
return (asDegrees ? torsion / 0.017453292 : torsion);
}, "org.jmol.util.Tuple3f,org.jmol.util.Tuple3f,org.jmol.util.Tuple3f,org.jmol.util.Tuple3f,~B");
c$.computeHelicalAxis = Clazz.defineMethod (c$, "computeHelicalAxis", 
function (id, tokType, a, b, dq) {
var vab =  new org.jmol.util.Vector3f ();
vab.sub2 (b, a);
var theta = dq.getTheta ();
var n = dq.getNormal ();
var v_dot_n = vab.dot (n);
if (Math.abs (v_dot_n) < 0.0001) v_dot_n = 0;
if (tokType == 1073741854) {
if (v_dot_n != 0) n.scale (v_dot_n);
return n;
}var va_prime_d =  new org.jmol.util.Vector3f ();
va_prime_d.cross (vab, n);
if (va_prime_d.dot (va_prime_d) != 0) va_prime_d.normalize ();
var vda =  new org.jmol.util.Vector3f ();
var vcb = org.jmol.util.Vector3f.newV (n);
if (v_dot_n == 0) v_dot_n = 1.4E-45;
vcb.scale (v_dot_n);
vda.sub2 (vcb, vab);
vda.scale (0.5);
va_prime_d.scale (theta == 0 ? 0 : (vda.length () / Math.tan (theta / 2 / 180 * 3.141592653589793)));
var r = org.jmol.util.Vector3f.newV (va_prime_d);
if (theta != 0) r.add (vda);
if (tokType == 1666189314) return r;
var pt_a_prime = org.jmol.util.Point3f.newP (a);
pt_a_prime.sub (r);
if (tokType == 135266320) {
return pt_a_prime;
}if (v_dot_n != 1.4E-45) n.scale (v_dot_n);
var pt_b_prime = org.jmol.util.Point3f.newP (pt_a_prime);
pt_b_prime.add (n);
theta = org.jmol.util.Measure.computeTorsion (a, pt_a_prime, pt_b_prime, b, true);
if (Float.isNaN (theta) || r.length () < 0.0001) theta = dq.getThetaDirectedV (n);
if (tokType == 135266305) return  new Float (theta);
if (tokType == 135176) return "draw ID \"" + id + "\" VECTOR " + org.jmol.util.Escape.escapePt (pt_a_prime) + " " + org.jmol.util.Escape.escapePt (n) + " color " + (theta < 0 ? "{255.0 200.0 0.0}" : "{255.0 0.0 128.0}");
if (tokType == 1746538509) return "measure " + org.jmol.util.Escape.escapePt (a) + org.jmol.util.Escape.escapePt (pt_a_prime) + org.jmol.util.Escape.escapePt (pt_b_prime) + org.jmol.util.Escape.escapePt (b);
var residuesPerTurn = Math.abs (theta == 0 ? 0 : 360 / theta);
var pitch = Math.abs (v_dot_n == 1.4E-45 ? 0 : n.length () * (theta == 0 ? 1 : 360 / theta));
switch (tokType) {
case 135266306:
return [pt_a_prime, n, r, org.jmol.util.Point3f.new3 (theta, pitch, residuesPerTurn)];
case 1073742001:
return [org.jmol.util.Escape.escapePt (pt_a_prime), org.jmol.util.Escape.escapePt (n), org.jmol.util.Escape.escapePt (r), org.jmol.util.Escape.escapePt (org.jmol.util.Point3f.new3 (theta, pitch, residuesPerTurn))];
default:
return null;
}
}, "~S,~N,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Quaternion");
c$.getPlaneThroughPoints = Clazz.defineMethod (c$, "getPlaneThroughPoints", 
function (pointA, pointB, pointC, vNorm, vAB, vAC, plane) {
var w = org.jmol.util.Measure.getNormalThroughPoints (pointA, pointB, pointC, vNorm, vAB, vAC);
plane.set (vNorm.x, vNorm.y, vNorm.z, w);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,org.jmol.util.Point4f");
c$.getPlaneThroughPoint = Clazz.defineMethod (c$, "getPlaneThroughPoint", 
function (pt, normal, plane) {
plane.set (normal.x, normal.y, normal.z, -normal.dot (org.jmol.util.Vector3f.newV (pt)));
}, "org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Point4f");
c$.distanceToPlane = Clazz.defineMethod (c$, "distanceToPlane", 
function (plane, pt) {
return (plane == null ? NaN : (plane.x * pt.x + plane.y * pt.y + plane.z * pt.z + plane.w) / Math.sqrt (plane.x * plane.x + plane.y * plane.y + plane.z * plane.z));
}, "org.jmol.util.Point4f,org.jmol.util.Point3f");
c$.distanceToPlaneD = Clazz.defineMethod (c$, "distanceToPlaneD", 
function (plane, d, pt) {
return (plane == null ? NaN : (plane.x * pt.x + plane.y * pt.y + plane.z * pt.z + plane.w) / d);
}, "org.jmol.util.Point4f,~N,org.jmol.util.Point3f");
c$.distanceToPlane = Clazz.defineMethod (c$, "distanceToPlane", 
function (norm, w, pt) {
return (norm == null ? NaN : (norm.x * pt.x + norm.y * pt.y + norm.z * pt.z + w) / Math.sqrt (norm.x * norm.x + norm.y * norm.y + norm.z * norm.z));
}, "org.jmol.util.Vector3f,~N,org.jmol.util.Point3f");
c$.calcNormalizedNormal = Clazz.defineMethod (c$, "calcNormalizedNormal", 
function (pointA, pointB, pointC, vNormNorm, vAB, vAC) {
vAB.sub2 (pointB, pointA);
vAC.sub2 (pointC, pointA);
vNormNorm.cross (vAB, vAC);
vNormNorm.normalize ();
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f");
c$.getDirectedNormalThroughPoints = Clazz.defineMethod (c$, "getDirectedNormalThroughPoints", 
function (pointA, pointB, pointC, ptRef, vNorm, vAB, vAC) {
var nd = org.jmol.util.Measure.getNormalThroughPoints (pointA, pointB, pointC, vNorm, vAB, vAC);
if (ptRef != null) {
var pt0 = org.jmol.util.Point3f.newP (pointA);
pt0.add (vNorm);
var d = pt0.distance (ptRef);
pt0.setT (pointA);
pt0.sub (vNorm);
if (d > pt0.distance (ptRef)) {
vNorm.scale (-1);
nd = -nd;
}}return nd;
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f");
c$.getNormalThroughPoints = Clazz.defineMethod (c$, "getNormalThroughPoints", 
function (pointA, pointB, pointC, vNorm, vAB, vAC) {
org.jmol.util.Measure.calcNormalizedNormal (pointA, pointB, pointC, vNorm, vAB, vAC);
vAB.setT (pointA);
return -vAB.dot (vNorm);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f");
c$.getPlaneProjection = Clazz.defineMethod (c$, "getPlaneProjection", 
function (pt, plane, ptProj, vNorm) {
var dist = org.jmol.util.Measure.distanceToPlane (plane, pt);
vNorm.set (plane.x, plane.y, plane.z);
vNorm.normalize ();
vNorm.scale (-dist);
ptProj.setT (pt);
ptProj.add (vNorm);
}, "org.jmol.util.Point3f,org.jmol.util.Point4f,org.jmol.util.Point3f,org.jmol.util.Vector3f");
c$.getNormalFromCenter = Clazz.defineMethod (c$, "getNormalFromCenter", 
function (ptCenter, ptA, ptB, ptC, isOutward, normal) {
var vAB =  new org.jmol.util.Vector3f ();
var vAC =  new org.jmol.util.Vector3f ();
var d = org.jmol.util.Measure.getNormalThroughPoints (ptA, ptB, ptC, normal, vAB, vAC);
var isReversed = (org.jmol.util.Measure.distanceToPlane (normal, d, ptCenter) > 0);
if (isReversed == isOutward) normal.scale (-1.0);
return !isReversed;
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,~B,org.jmol.util.Vector3f");
c$.getNormalToLine = Clazz.defineMethod (c$, "getNormalToLine", 
function (pointA, pointB, vNormNorm) {
vNormNorm.sub2 (pointA, pointB);
vNormNorm.cross (vNormNorm, org.jmol.viewer.JmolConstants.axisY);
vNormNorm.normalize ();
if (Float.isNaN (vNormNorm.x)) vNormNorm.set (1, 0, 0);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Vector3f");
c$.getBisectingPlane = Clazz.defineMethod (c$, "getBisectingPlane", 
function (pointA, vAB, ptTemp, vTemp, plane) {
ptTemp.scaleAdd2 (0.5, vAB, pointA);
vTemp.setT (vAB);
vTemp.normalize ();
org.jmol.util.Measure.getPlaneThroughPoint (ptTemp, vTemp, plane);
}, "org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Point4f");
c$.projectOntoAxis = Clazz.defineMethod (c$, "projectOntoAxis", 
function (point, axisA, axisUnitVector, vectorProjection) {
vectorProjection.sub2 (point, axisA);
var projectedLength = vectorProjection.dot (axisUnitVector);
point.setT (axisUnitVector);
point.scaleAdd (projectedLength, axisA);
vectorProjection.sub2 (point, axisA);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f");
c$.calcBestAxisThroughPoints = Clazz.defineMethod (c$, "calcBestAxisThroughPoints", 
function (points, axisA, axisUnitVector, vectorProjection, nTriesMax) {
var nPoints = points.length;
axisA.setT (points[0]);
axisUnitVector.sub2 (points[nPoints - 1], axisA);
axisUnitVector.normalize ();
org.jmol.util.Measure.calcAveragePointN (points, nPoints, axisA);
var nTries = 0;
while (nTries++ < nTriesMax && org.jmol.util.Measure.findAxis (points, nPoints, axisA, axisUnitVector, vectorProjection) > 0.001) {
}
var tempA = org.jmol.util.Point3f.newP (points[0]);
org.jmol.util.Measure.projectOntoAxis (tempA, axisA, axisUnitVector, vectorProjection);
axisA.setT (tempA);
}, "~A,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,~N");
c$.findAxis = Clazz.defineMethod (c$, "findAxis", 
function (points, nPoints, axisA, axisUnitVector, vectorProjection) {
var sumXiYi =  new org.jmol.util.Vector3f ();
var vTemp =  new org.jmol.util.Vector3f ();
var pt =  new org.jmol.util.Point3f ();
var ptProj =  new org.jmol.util.Point3f ();
var a = org.jmol.util.Vector3f.newV (axisUnitVector);
var sum_Xi2 = 0;
var sum_Yi2 = 0;
for (var i = nPoints; --i >= 0; ) {
pt.setT (points[i]);
ptProj.setT (pt);
org.jmol.util.Measure.projectOntoAxis (ptProj, axisA, axisUnitVector, vectorProjection);
vTemp.sub2 (pt, ptProj);
sum_Yi2 += vTemp.lengthSquared ();
vTemp.cross (vectorProjection, vTemp);
sumXiYi.add (vTemp);
sum_Xi2 += vectorProjection.lengthSquared ();
}
var m = org.jmol.util.Vector3f.newV (sumXiYi);
m.scale (1 / sum_Xi2);
vTemp.cross (m, axisUnitVector);
axisUnitVector.add (vTemp);
axisUnitVector.normalize ();
vTemp.setT (axisUnitVector);
vTemp.sub (a);
return vTemp.length ();
}, "~A,~N,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f");
c$.calcAveragePoint = Clazz.defineMethod (c$, "calcAveragePoint", 
function (pointA, pointB, pointC) {
pointC.set ((pointA.x + pointB.x) / 2, (pointA.y + pointB.y) / 2, (pointA.z + pointB.z) / 2);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f");
c$.calcAveragePointN = Clazz.defineMethod (c$, "calcAveragePointN", 
function (points, nPoints, averagePoint) {
averagePoint.setT (points[0]);
for (var i = 1; i < nPoints; i++) averagePoint.add (points[i]);

averagePoint.scale (1 / nPoints);
}, "~A,~N,org.jmol.util.Point3f");
c$.getCenterAndPoints = Clazz.defineMethod (c$, "getCenterAndPoints", 
function (vPts) {
var n = vPts.size ();
var pts =  new Array (n + 1);
pts[0] =  new org.jmol.util.Point3f ();
if (n > 0) {
for (var i = 0; i < n; i++) {
pts[0].add (pts[i + 1] = vPts.get (i));
}
pts[0].scale (1 / n);
}return pts;
}, "java.util.List");
c$.getTransformMatrix4 = Clazz.defineMethod (c$, "getTransformMatrix4", 
function (ptsA, ptsB, m, centerA) {
var cptsA = org.jmol.util.Measure.getCenterAndPoints (ptsA);
var cptsB = org.jmol.util.Measure.getCenterAndPoints (ptsB);
var retStddev =  Clazz.newFloatArray (2, 0);
var q = org.jmol.util.Measure.calculateQuaternionRotation ([cptsA, cptsB], retStddev, false);
var v = org.jmol.util.Vector3f.newV (cptsB[0]);
v.sub (cptsA[0]);
m.setMV (q.getMatrix (), v);
if (centerA != null) centerA.setT (cptsA[0]);
return retStddev[1];
}, "java.util.List,java.util.List,org.jmol.util.Matrix4f,org.jmol.util.Point3f");
c$.calculateQuaternionRotation = Clazz.defineMethod (c$, "calculateQuaternionRotation", 
function (centerAndPoints, retStddev, doReport) {
retStddev[1] = NaN;
var q =  new org.jmol.util.Quaternion ();
if (centerAndPoints[0].length == 1 || centerAndPoints[0].length != centerAndPoints[1].length) return q;
var n = centerAndPoints[0].length - 1;
if (doReport) for (var i = 1; i <= n; i++) {
var aij = centerAndPoints[0][i];
var bij = centerAndPoints[1][i];
if (Clazz.instanceOf (aij, org.jmol.modelset.Atom)) org.jmol.util.Logger.info (" atom 1 " + (aij).getInfo () + "\tatom 2 " + (bij).getInfo ());
 else break;
}
if (n < 2) return q;
var Sxx = 0;
var Sxy = 0;
var Sxz = 0;
var Syx = 0;
var Syy = 0;
var Syz = 0;
var Szx = 0;
var Szy = 0;
var Szz = 0;
for (var i = n + 1; --i >= 1; ) {
var aij = centerAndPoints[0][i];
var bij = centerAndPoints[1][i];
var ptA = org.jmol.util.Point3f.newP (aij);
ptA.sub (centerAndPoints[0][0]);
var ptB = org.jmol.util.Point3f.newP (bij);
ptB.sub (centerAndPoints[0][1]);
Sxx += ptA.x * ptB.x;
Sxy += ptA.x * ptB.y;
Sxz += ptA.x * ptB.z;
Syx += ptA.y * ptB.x;
Syy += ptA.y * ptB.y;
Syz += ptA.y * ptB.z;
Szx += ptA.z * ptB.x;
Szy += ptA.z * ptB.y;
Szz += ptA.z * ptB.z;
}
retStddev[0] = org.jmol.util.Measure.getRmsd (centerAndPoints, q);
var N =  Clazz.newDoubleArray (4, 4, 0);
N[0][0] = Sxx + Syy + Szz;
N[0][1] = N[1][0] = Syz - Szy;
N[0][2] = N[2][0] = Szx - Sxz;
N[0][3] = N[3][0] = Sxy - Syx;
N[1][1] = Sxx - Syy - Szz;
N[1][2] = N[2][1] = Sxy + Syx;
N[1][3] = N[3][1] = Szx + Sxz;
N[2][2] = -Sxx + Syy - Szz;
N[2][3] = N[3][2] = Syz + Szy;
N[3][3] = -Sxx - Syy + Szz;
var eigen = org.jmol.util.Eigen.newM (N);
var v = eigen.getEigenvectorsFloatTransposed ()[3];
q = org.jmol.util.Quaternion.newP4 (org.jmol.util.Point4f.new4 (v[1], v[2], v[3], v[0]));
retStddev[1] = org.jmol.util.Measure.getRmsd (centerAndPoints, q);
return q;
}, "~A,~A,~B");
c$.getRmsd = Clazz.defineMethod (c$, "getRmsd", 
function (centerAndPoints, q) {
var sum = 0;
var sum2 = 0;
var n = centerAndPoints[0].length - 1;
var ptAnew =  new org.jmol.util.Point3f ();
for (var i = n + 1; --i >= 1; ) {
ptAnew.setT (centerAndPoints[0][i]);
ptAnew.sub (centerAndPoints[0][0]);
q.transformP2 (ptAnew, ptAnew);
ptAnew.add (centerAndPoints[1][0]);
var d = ptAnew.distance (centerAndPoints[1][i]);
sum += d;
sum2 += d * d;
}
return Math.sqrt ((sum2 - sum * sum / n) / (n - 1));
}, "~A,org.jmol.util.Quaternion");
c$.transformPoints = Clazz.defineMethod (c$, "transformPoints", 
function (vPts, m4, center) {
var v =  new java.util.ArrayList ();
for (var i = 0; i < vPts.size (); i++) {
var pt = org.jmol.util.Point3f.newP (vPts.get (i));
pt.sub (center);
m4.transform2 (pt, pt);
pt.add (center);
v.add (pt);
}
return v;
}, "java.util.List,org.jmol.util.Matrix4f,org.jmol.util.Point3f");
c$.isInTetrahedron = Clazz.defineMethod (c$, "isInTetrahedron", 
function (pt, ptA, ptB, ptC, ptD, plane, vTemp, vTemp2, vTemp3, fullyEnclosed) {
org.jmol.util.Measure.getPlaneThroughPoints (ptC, ptD, ptA, vTemp, vTemp2, vTemp3, plane);
var b = (org.jmol.util.Measure.distanceToPlane (plane, pt) >= 0);
org.jmol.util.Measure.getPlaneThroughPoints (ptA, ptD, ptB, vTemp, vTemp2, vTemp3, plane);
if (b != (org.jmol.util.Measure.distanceToPlane (plane, pt) >= 0)) return false;
org.jmol.util.Measure.getPlaneThroughPoints (ptB, ptD, ptC, vTemp, vTemp2, vTemp3, plane);
if (b != (org.jmol.util.Measure.distanceToPlane (plane, pt) >= 0)) return false;
org.jmol.util.Measure.getPlaneThroughPoints (ptA, ptB, ptC, vTemp, vTemp2, vTemp3, plane);
var d = org.jmol.util.Measure.distanceToPlane (plane, pt);
if (fullyEnclosed) return (b == (d >= 0));
var d1 = org.jmol.util.Measure.distanceToPlane (plane, ptD);
return d1 * d <= 0 || Math.abs (d1) > Math.abs (d);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point3f,org.jmol.util.Point4f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,~B");
c$.getIntersectionPP = Clazz.defineMethod (c$, "getIntersectionPP", 
function (plane1, plane2) {
var a1 = plane1.x;
var b1 = plane1.y;
var c1 = plane1.z;
var d1 = plane1.w;
var a2 = plane2.x;
var b2 = plane2.y;
var c2 = plane2.z;
var d2 = plane2.w;
var norm1 = org.jmol.util.Vector3f.new3 (a1, b1, c1);
var norm2 = org.jmol.util.Vector3f.new3 (a2, b2, c2);
var nxn =  new org.jmol.util.Vector3f ();
nxn.cross (norm1, norm2);
var ax = Math.abs (nxn.x);
var ay = Math.abs (nxn.y);
var az = Math.abs (nxn.z);
var x;
var y;
var z;
var diff;
var type = (ax > ay ? (ax > az ? 1 : 3) : ay > az ? 2 : 3);
switch (type) {
case 1:
x = 0;
diff = (b1 * c2 - b2 * c1);
if (Math.abs (diff) < 0.01) return null;
y = (c1 * d2 - c2 * d1) / diff;
z = (b2 * d1 - d2 * b1) / diff;
break;
case 2:
diff = (a1 * c2 - a2 * c1);
if (Math.abs (diff) < 0.01) return null;
x = (c1 * d2 - c2 * d1) / diff;
y = 0;
z = (a2 * d1 - d2 * a1) / diff;
break;
case 3:
default:
diff = (a1 * b2 - a2 * b1);
if (Math.abs (diff) < 0.01) return null;
x = (b1 * d2 - b2 * d1) / diff;
y = (a2 * d1 - d2 * a1) / diff;
z = 0;
}
var list =  new java.util.ArrayList ();
list.add (org.jmol.util.Point3f.new3 (x, y, z));
nxn.normalize ();
list.add (nxn);
return list;
}, "org.jmol.util.Point4f,org.jmol.util.Point4f");
c$.getIntersection = Clazz.defineMethod (c$, "getIntersection", 
function (pt1, v, plane, ptRet, tempNorm, vTemp) {
org.jmol.util.Measure.getPlaneProjection (pt1, plane, ptRet, tempNorm);
tempNorm.set (plane.x, plane.y, plane.z);
tempNorm.normalize ();
if (v == null) v = org.jmol.util.Vector3f.newV (tempNorm);
var l_dot_n = v.dot (tempNorm);
if (Math.abs (l_dot_n) < 0.01) return null;
vTemp.setT (ptRet);
vTemp.sub (pt1);
ptRet.scaleAdd2 (vTemp.dot (tempNorm) / l_dot_n, v, pt1);
return ptRet;
}, "org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Point4f,org.jmol.util.Point3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f");
Clazz.defineStatics (c$,
"radiansPerDegree", (0.017453292519943295));
});
// 
//// org\jmol\util\Tuple3f.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Tuple3f", ["java.lang.Float"], function () {
c$ = Clazz.decorateAsClass (function () {
this.x = 0;
this.y = 0;
this.z = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Tuple3f", null, java.io.Serializable);
Clazz.makeConstructor (c$, 
function () {
});
Clazz.defineMethod (c$, "set", 
function (x, y, z) {
this.x = x;
this.y = y;
this.z = z;
}, "~N,~N,~N");
Clazz.defineMethod (c$, "setA", 
function (t) {
this.x = t[0];
this.y = t[1];
this.z = t[2];
}, "~A");
Clazz.defineMethod (c$, "setT", 
function (t1) {
this.x = t1.x;
this.y = t1.y;
this.z = t1.z;
}, "org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "add2", 
function (t1, t2) {
this.x = t1.x + t2.x;
this.y = t1.y + t2.y;
this.z = t1.z + t2.z;
}, "org.jmol.util.Tuple3f,org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "add", 
function (t1) {
this.x += t1.x;
this.y += t1.y;
this.z += t1.z;
}, "org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "sub2", 
function (t1, t2) {
this.x = t1.x - t2.x;
this.y = t1.y - t2.y;
this.z = t1.z - t2.z;
}, "org.jmol.util.Tuple3f,org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "sub", 
function (t1) {
this.x -= t1.x;
this.y -= t1.y;
this.z -= t1.z;
}, "org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "scale", 
function (s) {
this.x *= s;
this.y *= s;
this.z *= s;
}, "~N");
Clazz.defineMethod (c$, "scaleAdd2", 
function (s, t1, t2) {
this.x = s * t1.x + t2.x;
this.y = s * t1.y + t2.y;
this.z = s * t1.z + t2.z;
}, "~N,org.jmol.util.Tuple3f,org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "scaleAdd", 
function (s, t1) {
this.x = s * this.x + t1.x;
this.y = s * this.y + t1.y;
this.z = s * this.z + t1.z;
}, "~N,org.jmol.util.Tuple3f");
Clazz.overrideMethod (c$, "hashCode", 
function () {
var bits = 1;
bits = 31 * bits + org.jmol.util.Tuple3f.floatToIntBits0 (this.x);
bits = 31 * bits + org.jmol.util.Tuple3f.floatToIntBits0 (this.y);
bits = 31 * bits + org.jmol.util.Tuple3f.floatToIntBits0 (this.z);
return (bits ^ (bits >> 32));
});
c$.floatToIntBits0 = Clazz.defineMethod (c$, "floatToIntBits0", 
function (f) {
return (f == 0 ? 0 : Float.floatToIntBits (f));
}, "~N");
Clazz.overrideMethod (c$, "equals", 
function (t1) {
if (!(Clazz.instanceOf (t1, org.jmol.util.Tuple3f))) return false;
var t2 = t1;
return (this.x == t2.x && this.y == t2.y && this.z == t2.z);
}, "~O");
Clazz.overrideMethod (c$, "toString", 
function () {
return "(" + this.x + ", " + this.y + ", " + this.z + ")";
});
});
// 
//// org\jmol\util\Tuple4f.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Tuple4f", ["org.jmol.util.Tuple3f"], function () {
c$ = Clazz.decorateAsClass (function () {
this.x = 0;
this.y = 0;
this.z = 0;
this.w = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Tuple4f", null, java.io.Serializable);
Clazz.makeConstructor (c$, 
function () {
});
Clazz.defineMethod (c$, "set", 
function (x, y, z, w) {
this.x = x;
this.y = y;
this.z = z;
this.w = w;
}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "scale", 
function (s) {
this.x *= s;
this.y *= s;
this.z *= s;
this.w *= s;
}, "~N");
Clazz.overrideMethod (c$, "hashCode", 
function () {
return org.jmol.util.Tuple3f.floatToIntBits0 (this.x) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.y) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.z) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.w);
});
Clazz.overrideMethod (c$, "equals", 
function (o) {
if (!(Clazz.instanceOf (o, org.jmol.util.Tuple4f))) return false;
var t = o;
return (this.x == t.x && this.y == t.y && this.z == t.z && this.w == t.w);
}, "~O");
Clazz.overrideMethod (c$, "toString", 
function () {
return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
});
});
// 
//// org\jmol\util\Point4f.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.Tuple4f"], "org.jmol.util.Point4f", null, function () {
c$ = Clazz.declareType (org.jmol.util, "Point4f", org.jmol.util.Tuple4f);
c$.new4 = Clazz.defineMethod (c$, "new4", 
function (x, y, z, w) {
var pt =  new org.jmol.util.Point4f ();
pt.set (x, y, z, w);
return pt;
}, "~N,~N,~N,~N");
c$.newPt = Clazz.defineMethod (c$, "newPt", 
function (value) {
var pt =  new org.jmol.util.Point4f ();
pt.set (value.x, value.y, value.z, value.w);
return pt;
}, "org.jmol.util.Point4f");
Clazz.defineMethod (c$, "distance", 
function (p1) {
var dx = this.x - p1.x;
var dy = this.y - p1.y;
var dz = this.z - p1.z;
var dw = this.w - p1.w;
return Math.sqrt (dx * dx + dy * dy + dz * dz + dw * dw);
}, "org.jmol.util.Point4f");
});
// 
//// org\jmol\io\Encoding.js 
// 
Clazz.declarePackage ("org.jmol.io");
Clazz.load (["java.lang.Enum"], "org.jmol.io.Encoding", null, function () {
c$ = Clazz.declareType (org.jmol.io, "Encoding", Enum);
Clazz.defineEnumConstant (c$, "NONE", 0, []);
Clazz.defineEnumConstant (c$, "UTF8", 1, []);
Clazz.defineEnumConstant (c$, "UTF_16BE", 2, []);
Clazz.defineEnumConstant (c$, "UTF_16LE", 3, []);
Clazz.defineEnumConstant (c$, "UTF_32BE", 4, []);
Clazz.defineEnumConstant (c$, "UTF_32LE", 5, []);
});
// 
//// java\io\FilterInputStream.js 
// 
Clazz.load (["java.io.InputStream"], "java.io.FilterInputStream", null, function () {
c$ = Clazz.decorateAsClass (function () {
this.$in = null;
Clazz.instantialize (this, arguments);
}, java.io, "FilterInputStream", java.io.InputStream);
Clazz.makeConstructor (c$, 
function ($in) {
Clazz.superConstructor (this, java.io.FilterInputStream, []);
this.$in = $in;
}, "java.io.InputStream");
Clazz.defineMethod (c$, "readByteAsInt", 
function () {
return this.$in.readByteAsInt ();
});
Clazz.defineMethod (c$, "read", 
function (b, off, len) {
return this.$in.read (b, off, len);
}, "~A,~N,~N");
Clazz.defineMethod (c$, "skip", 
function (n) {
return this.$in.skip (n);
}, "~N");
Clazz.defineMethod (c$, "available", 
function () {
return this.$in.available ();
});
Clazz.defineMethod (c$, "close", 
function () {
this.$in.close ();
});
Clazz.defineMethod (c$, "mark", 
function (readlimit) {
this.$in.mark (readlimit);
}, "~N");
Clazz.defineMethod (c$, "reset", 
function () {
this.$in.reset ();
});
Clazz.defineMethod (c$, "markSupported", 
function () {
return this.$in.markSupported ();
});
});
// 
//// java\io\BufferedInputStream.js 
// 
Clazz.load (["java.io.FilterInputStream"], "java.io.BufferedInputStream", ["java.io.IOException", "java.lang.IndexOutOfBoundsException"], function () {
c$ = Clazz.decorateAsClass (function () {
this.buf = null;
this.count = 0;
this.pos = 0;
this.markpos = -1;
this.marklimit = 0;
Clazz.instantialize (this, arguments);
}, java.io, "BufferedInputStream", java.io.FilterInputStream);
Clazz.defineMethod (c$, "getInIfOpen", 
($fz = function () {
var input = this.$in;
if (input == null) throw  new java.io.IOException ("Stream closed");
return input;
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "getBufIfOpen", 
($fz = function () {
var buffer = this.buf;
if (buffer == null) throw  new java.io.IOException ("Stream closed");
return buffer;
}, $fz.isPrivate = true, $fz));
Clazz.makeConstructor (c$, 
function ($in) {
Clazz.superConstructor (this, java.io.BufferedInputStream, [$in]);
this.buf =  Clazz.newByteArray (java.io.BufferedInputStream.defaultBufferSize, 0);
}, "java.io.InputStream");
Clazz.defineMethod (c$, "fill", 
($fz = function () {
var buffer = this.getBufIfOpen ();
if (this.markpos < 0) this.pos = 0;
 else if (this.pos >= buffer.length) if (this.markpos > 0) {
var sz = this.pos - this.markpos;
System.arraycopy (buffer, this.markpos, buffer, 0, sz);
this.pos = sz;
this.markpos = 0;
} else if (buffer.length >= this.marklimit) {
this.markpos = -1;
this.pos = 0;
} else {
var nsz = this.pos * 2;
if (nsz > this.marklimit) nsz = this.marklimit;
var nbuf =  Clazz.newByteArray (nsz, 0);
System.arraycopy (buffer, 0, nbuf, 0, this.pos);
buffer = this.buf = nbuf;
}this.count = this.pos;
var n = this.getInIfOpen ().read (buffer, this.pos, buffer.length - this.pos);
if (n > 0) this.count = n + this.pos;
}, $fz.isPrivate = true, $fz));
Clazz.overrideMethod (c$, "readByteAsInt", 
function () {
if (this.pos >= this.count) {
this.fill ();
if (this.pos >= this.count) return -1;
}return this.getBufIfOpen ()[this.pos++] & 0xff;
});
Clazz.defineMethod (c$, "read1", 
($fz = function (b, off, len) {
var avail = this.count - this.pos;
if (avail <= 0) {
if (len >= this.getBufIfOpen ().length && this.markpos < 0) {
return this.getInIfOpen ().read (b, off, len);
}this.fill ();
avail = this.count - this.pos;
if (avail <= 0) return -1;
}var cnt = (avail < len) ? avail : len;
System.arraycopy (this.getBufIfOpen (), this.pos, b, off, cnt);
this.pos += cnt;
return cnt;
}, $fz.isPrivate = true, $fz), "~A,~N,~N");
Clazz.overrideMethod (c$, "read", 
function (b, off, len) {
this.getBufIfOpen ();
if ((off | len | (off + len) | (b.length - (off + len))) < 0) {
throw  new IndexOutOfBoundsException ();
} else if (len == 0) {
return 0;
}var n = 0;
for (; ; ) {
var nread = this.read1 (b, off + n, len - n);
if (nread <= 0) return (n == 0) ? nread : n;
n += nread;
if (n >= len) return n;
var input = this.$in;
if (input != null && input.available () <= 0) return n;
}
}, "~A,~N,~N");
Clazz.overrideMethod (c$, "skip", 
function (n) {
this.getBufIfOpen ();
if (n <= 0) {
return 0;
}var avail = this.count - this.pos;
if (avail <= 0) {
if (this.markpos < 0) return this.getInIfOpen ().skip (n);
this.fill ();
avail = this.count - this.pos;
if (avail <= 0) return 0;
}var skipped = (avail < n) ? avail : n;
this.pos += skipped;
return skipped;
}, "~N");
Clazz.overrideMethod (c$, "available", 
function () {
var n = this.count - this.pos;
var avail = this.getInIfOpen ().available ();
return n > (2147483647 - avail) ? 2147483647 : n + avail;
});
Clazz.overrideMethod (c$, "mark", 
function (readlimit) {
this.marklimit = readlimit;
this.markpos = this.pos;
}, "~N");
Clazz.overrideMethod (c$, "reset", 
function () {
this.getBufIfOpen ();
if (this.markpos < 0) throw  new java.io.IOException ("Resetting to invalid mark");
this.pos = this.markpos;
});
Clazz.overrideMethod (c$, "markSupported", 
function () {
return true;
});
Clazz.overrideMethod (c$, "close", 
function () {
var input = this.$in;
this.$in = null;
if (input != null) input.close ();
return;
});
Clazz.defineStatics (c$,
"defaultBufferSize", 8192);
});
// 
//// java\util\Properties.js 
// 
$_L(["java.util.Hashtable"],"java.util.Properties",["java.lang.NullPointerException","$.StringBuffer"],function(){
c$=$_C(function(){
this.builder=null;
this.defaults=null;
$_Z(this,arguments);
},java.util,"Properties",java.util.Hashtable);

$_K(c$,
function(properties){
$_R(this,java.util.Properties,[]);
this.defaults=properties;
},"java.util.Properties");
$_M(c$,"dumpString",
($fz=function(buffer,string,key){
var i=0;
if(!key&&i<string.length&&(string.charAt(i)).charCodeAt(0)==(' ').charCodeAt(0)){
buffer.append("\\ ");
i++;
}for(;i<string.length;i++){
var ch=string.charAt(i);
switch(ch){
case'\t':
buffer.append("\\t");
break;
case'\n':
buffer.append("\\n");
break;
case'\f':
buffer.append("\\f");
break;
case'\r':
buffer.append("\\r");
break;
default:
if("\\#!=:".indexOf(ch)>=0||(key&&(ch).charCodeAt(0)==(' ').charCodeAt(0))){
buffer.append('\\');
}if((ch).charCodeAt(0)>=(' ').charCodeAt (0) && (ch).charCodeAt (0) <= ('~').charCodeAt(0)){
buffer.append(ch);
}else{
var hex=Integer.toHexString(ch.charCodeAt(0));
buffer.append("\\u");
for(var j=0;j<4-hex.length;j++){
buffer.append("0");
}
buffer.append(hex);
}}
}
},$fz.isPrivate=true,$fz),"StringBuilder,~S,~B");
$_M(c$,"getProperty",
function(name){
var result=this.get(name);
var property=$_O(result,String)?result:null;
if(property==null&&this.defaults!=null){
property=this.defaults.getProperty(name);
}return property;
},"~S");
$_M(c$,"getProperty",
function(name,defaultValue){
var result=this.get(name);
var property=$_O(result,String)?result:null;
if(property==null&&this.defaults!=null){
property=this.defaults.getProperty(name);
}if(property==null){
return defaultValue;
}return property;
},"~S,~S");
$_M(c$,"list",
function(out){
if(out==null){
throw new NullPointerException();
}var buffer=new StringBuffer(80);
var keys=this.propertyNames();
while(keys.hasMoreElements()){
var key=keys.nextElement();
buffer.append(key);
buffer.append('=');
var property=this.get(key);
var def=this.defaults;
while(property==null){
property=def.get(key);
def=def.defaults;
}
if(property.length>40){
buffer.append(property.substring(0,37));
buffer.append("...");
}else{
buffer.append(property);
}out.println(buffer.toString());
buffer.setLength(0);
}
},"java.io.PrintStream");
$_M(c$,"list",
function(writer){
if(writer==null){
throw new NullPointerException();
}var buffer=new StringBuffer(80);
var keys=this.propertyNames();
while(keys.hasMoreElements()){
var key=keys.nextElement();
buffer.append(key);
buffer.append('=');
var property=this.get(key);
var def=this.defaults;
while(property==null){
property=def.get(key);
def=def.defaults;
}
if(property.length>40){
buffer.append(property.substring(0,37));
buffer.append("...");
}else{
buffer.append(property);
}writer.println(buffer.toString());
buffer.setLength(0);
}
},"java.io.PrintWriter");
$_M(c$,"load",
function($in){

},"java.io.InputStream");
$_M(c$,"propertyNames",
function(){
if(this.defaults==null){
return this.keys();
}var set=new java.util.Hashtable(this.defaults.size()+this.size());
var keys=this.defaults.propertyNames();
while(keys.hasMoreElements()){
set.put(keys.nextElement(),set);
}
keys=this.keys();
while(keys.hasMoreElements()){
set.put(keys.nextElement(),set);
}
return set.keys();
});
$_M(c$,"save",
function(out,comment){
try{
this.store(out,comment);
}catch(e){
if($_O(e,java.io.IOException)){
}else{
throw e;
}
}
},"java.io.OutputStream,~S");
$_M(c$,"setProperty",
function(name,value){
return this.put(name,value);
},"~S,~S");
$_M(c$,"store",
function(out,comment){

},"java.io.OutputStream,~S");
$_M(c$,"loadFromXML",
function($in){

},"java.io.InputStream");
$_M(c$,"storeToXML",
function(os,comment){

},"java.io.OutputStream,~S");
$_M(c$,"storeToXML",
function(os,comment,encoding){

},"java.io.OutputStream,~S,~S");
$_M(c$,"substitutePredefinedEntries",
($fz=function(s){
return s.replaceAll("&","&amp;").replaceAll("<","&lt;").replaceAll(">","&gt;").replaceAll("\u0027","&apos;").replaceAll("\"","&quot;");
},$fz.isPrivate=true,$fz),"~S");
$_S(c$,
"PROP_DTD_NAME","http://java.sun.com/dtd/properties.dtd",
"PROP_DTD","<?xml version=\"1.0\" encoding=\"UTF-8\"?>    <!ELEMENT properties (comment?, entry*) >    <!ATTLIST properties version CDATA #FIXED \"1.0\" >    <!ELEMENT comment (#PCDATA) >    <!ELEMENT entry (#PCDATA) >    <!ATTLIST entry key CDATA #REQUIRED >",
"NONE",0,
"SLASH",1,
"UNICODE",2,
"CONTINUE",3,
"KEY_DONE",4,
"IGNORE",5,
"lineSeparator",null);

});
// 
//// org\jmol\util\Elements.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.BitSet"], "org.jmol.util.Elements", ["java.util.Hashtable", "org.jmol.util.Logger"], function () {
c$ = Clazz.declareType (org.jmol.util, "Elements");
c$.getAtomicMass = Clazz.defineMethod (c$, "getAtomicMass", 
function (i) {
return (i < 1 || i >= org.jmol.util.Elements.atomicMass.length ? 0 : org.jmol.util.Elements.atomicMass[i]);
}, "~N");
c$.elementNumberFromSymbol = Clazz.defineMethod (c$, "elementNumberFromSymbol", 
function (elementSymbol, isSilent) {
if (org.jmol.util.Elements.htElementMap == null) {
var map =  new java.util.Hashtable ();
for (var elementNumber = org.jmol.util.Elements.elementNumberMax; --elementNumber >= 0; ) {
var symbol = org.jmol.util.Elements.elementSymbols[elementNumber];
var boxed = Integer.$valueOf (elementNumber);
map.put (symbol, boxed);
if (symbol.length == 2) map.put (symbol.toUpperCase (), boxed);
}
for (var i = org.jmol.util.Elements.altElementMax; --i >= 4; ) {
var symbol = org.jmol.util.Elements.altElementSymbols[i];
var boxed = Integer.$valueOf (org.jmol.util.Elements.altElementNumbers[i]);
map.put (symbol, boxed);
if (symbol.length == 2) map.put (symbol.toUpperCase (), boxed);
}
($t$ = org.jmol.util.Elements.htElementMap = map, org.jmol.util.Elements.prototype.htElementMap = org.jmol.util.Elements.htElementMap, $t$);
}if (elementSymbol == null) return 0;
var boxedAtomicNumber = org.jmol.util.Elements.htElementMap.get (elementSymbol);
if (boxedAtomicNumber != null) return boxedAtomicNumber.intValue ();
if (!isSilent) org.jmol.util.Logger.error ("'" + elementSymbol + "' is not a recognized symbol");
return 0;
}, "~S,~B");
c$.elementSymbolFromNumber = Clazz.defineMethod (c$, "elementSymbolFromNumber", 
function (elementNumber) {
if (elementNumber >= org.jmol.util.Elements.elementNumberMax) {
for (var j = org.jmol.util.Elements.altElementMax; --j >= 0; ) if (elementNumber == org.jmol.util.Elements.altElementNumbers[j]) return org.jmol.util.Elements.altElementSymbols[j];

elementNumber %= 128;
}if (elementNumber < 0 || elementNumber >= org.jmol.util.Elements.elementNumberMax) elementNumber = 0;
return org.jmol.util.Elements.elementSymbols[elementNumber];
}, "~N");
c$.elementNameFromNumber = Clazz.defineMethod (c$, "elementNameFromNumber", 
function (elementNumber) {
if (elementNumber >= org.jmol.util.Elements.elementNumberMax) {
for (var j = org.jmol.util.Elements.altElementMax; --j >= 0; ) if (elementNumber == org.jmol.util.Elements.altElementNumbers[j]) return org.jmol.util.Elements.altElementNames[j];

elementNumber %= 128;
}if (elementNumber < 0 || elementNumber >= org.jmol.util.Elements.elementNumberMax) elementNumber = 0;
return org.jmol.util.Elements.elementNames[elementNumber];
}, "~N");
c$.altElementNameFromIndex = Clazz.defineMethod (c$, "altElementNameFromIndex", 
function (i) {
return org.jmol.util.Elements.altElementNames[i];
}, "~N");
c$.altElementNumberFromIndex = Clazz.defineMethod (c$, "altElementNumberFromIndex", 
function (i) {
return org.jmol.util.Elements.altElementNumbers[i];
}, "~N");
c$.altElementSymbolFromIndex = Clazz.defineMethod (c$, "altElementSymbolFromIndex", 
function (i) {
return org.jmol.util.Elements.altElementSymbols[i];
}, "~N");
c$.altIsotopeSymbolFromIndex = Clazz.defineMethod (c$, "altIsotopeSymbolFromIndex", 
function (i) {
var code = org.jmol.util.Elements.altElementNumbers[i];
return (code >> 7) + org.jmol.util.Elements.elementSymbolFromNumber (code & 127);
}, "~N");
c$.altIsotopeSymbolFromIndex2 = Clazz.defineMethod (c$, "altIsotopeSymbolFromIndex2", 
function (i) {
var code = org.jmol.util.Elements.altElementNumbers[i];
return org.jmol.util.Elements.elementSymbolFromNumber (code & 127) + (code >> 7);
}, "~N");
c$.getElementNumber = Clazz.defineMethod (c$, "getElementNumber", 
function (atomicAndIsotopeNumber) {
return (atomicAndIsotopeNumber % 128);
}, "~N");
c$.getIsotopeNumber = Clazz.defineMethod (c$, "getIsotopeNumber", 
function (atomicAndIsotopeNumber) {
return (atomicAndIsotopeNumber >> 7);
}, "~N");
c$.getAtomicAndIsotopeNumber = Clazz.defineMethod (c$, "getAtomicAndIsotopeNumber", 
function (n, mass) {
return ((n < 0 ? 0 : n) + (mass <= 0 ? 0 : mass << 7));
}, "~N,~N");
c$.altElementIndexFromNumber = Clazz.defineMethod (c$, "altElementIndexFromNumber", 
function (atomicAndIsotopeNumber) {
for (var i = 0; i < org.jmol.util.Elements.altElementMax; i++) if (org.jmol.util.Elements.altElementNumbers[i] == atomicAndIsotopeNumber) return i;

return 0;
}, "~N");
c$.getNaturalIsotope = Clazz.defineMethod (c$, "getNaturalIsotope", 
function (elementNumber) {
for (var i = 0; i < org.jmol.util.Elements.naturalIsotopeMasses.length; i += 2) if (org.jmol.util.Elements.naturalIsotopeMasses[i] == elementNumber) return org.jmol.util.Elements.naturalIsotopeMasses[++i];

return 0;
}, "~N");
c$.isNaturalIsotope = Clazz.defineMethod (c$, "isNaturalIsotope", 
function (isotopeSymbol) {
return ("1H,12C,14N,".indexOf (isotopeSymbol + ",") >= 0);
}, "~S");
c$.getBondingRadiusFloat = Clazz.defineMethod (c$, "getBondingRadiusFloat", 
function (atomicNumberAndIsotope, charge) {
var atomicNumber = org.jmol.util.Elements.getElementNumber (atomicNumberAndIsotope);
if (charge > 0 && org.jmol.util.Elements.bsCations.get (atomicNumber)) return org.jmol.util.Elements.getBondingRadFromTable (atomicNumber, charge, org.jmol.util.Elements.cationLookupTable);
if (charge < 0 && org.jmol.util.Elements.bsAnions.get (atomicNumber)) return org.jmol.util.Elements.getBondingRadFromTable (atomicNumber, charge, org.jmol.util.Elements.anionLookupTable);
return org.jmol.util.Elements.covalentMars[atomicNumber] / 1000;
}, "~N,~N");
c$.getBondingRadFromTable = Clazz.defineMethod (c$, "getBondingRadFromTable", 
function (atomicNumber, charge, table) {
var ionic = ((atomicNumber << 4) + (charge + 4));
var iVal = 0;
var iMid = 0;
var iMin = 0;
var iMax = Clazz.doubleToInt (table.length / 2);
while (iMin != iMax) {
iMid = Clazz.doubleToInt ((iMin + iMax) / 2);
iVal = table[iMid << 1];
if (iVal > ionic) iMax = iMid;
 else if (iVal < ionic) iMin = iMid + 1;
 else return table[(iMid << 1) + 1] / 1000;
}
if (iVal > ionic) iMid--;
iVal = table[iMid << 1];
if (atomicNumber != (iVal >> 4)) iMid++;
return table[(iMid << 1) + 1] / 1000;
}, "~N,~N,~A");
c$.getVanderwaalsMar = Clazz.defineMethod (c$, "getVanderwaalsMar", 
function (i, type) {
return org.jmol.util.Elements.vanderwaalsMars[(i << 2) + (type.pt % 4)];
}, "~N,org.jmol.constant.EnumVdw");
c$.getHydrophobicity = Clazz.defineMethod (c$, "getHydrophobicity", 
function (i) {
return (i < 1 || i >= org.jmol.util.Elements.hydrophobicities.length ? 0 : org.jmol.util.Elements.hydrophobicities[i]);
}, "~N");
c$.getAllredRochowElectroNeg = Clazz.defineMethod (c$, "getAllredRochowElectroNeg", 
function (elemno) {
return (elemno > 0 && elemno < org.jmol.util.Elements.electroNegativities.length ? org.jmol.util.Elements.electroNegativities[elemno] : 0);
}, "~N");
Clazz.defineStatics (c$,
"elementSymbols", ["Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"],
"atomicMass", [0, 1.008, 4.003, 6.941, 9.012, 10.81, 12.011, 14.007, 15.999, 18.998, 20.18, 22.99, 24.305, 26.981, 28.086, 30.974, 32.07, 35.453, 39.948, 39.1, 40.08, 44.956, 47.88, 50.941, 52, 54.938, 55.847, 58.93, 58.69, 63.55, 65.39, 69.72, 72.61, 74.92, 78.96, 79.9, 83.8, 85.47, 87.62, 88.91, 91.22, 92.91, 95.94, 98.91, 101.07, 102.91, 106.42, 107.87, 112.41, 114.82, 118.71, 121.75, 127.6, 126.91, 131.29, 132.91, 137.33, 138.91, 140.12, 140.91, 144.24, 144.9, 150.36, 151.96, 157.25, 158.93, 162.5, 164.93, 167.26, 168.93, 173.04, 174.97, 178.49, 180.95, 183.85, 186.21, 190.2, 192.22, 195.08, 196.97, 200.59, 204.38, 207.2, 208.98, 210, 210, 222, 223, 226.03, 227.03, 232.04, 231.04, 238.03, 237.05, 239.1, 243.1, 247.1, 247.1, 252.1, 252.1, 257.1, 256.1, 259.1, 260.1, 261, 262, 263, 262, 265, 268]);
c$.elementNumberMax = c$.prototype.elementNumberMax = org.jmol.util.Elements.elementSymbols.length;
Clazz.defineStatics (c$,
"htElementMap", null,
"elementNames", ["unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"],
"naturalIsotopeMasses", [1, 1, 6, 12, 7, 14, 8, 16],
"naturalIsotopes", "1H,12C,14N,",
"firstIsotope", 4,
"altElementNumbers", [0, 13, 16, 55, 257, 385, 1414, 1670, 1798, 1927]);
c$.altElementMax = c$.prototype.altElementMax = org.jmol.util.Elements.altElementNumbers.length;
Clazz.defineStatics (c$,
"altElementSymbols", ["Xx", "Al", "S", "Cs", "D", "T", "11C", "13C", "14C", "15N"],
"altElementNames", ["dummy", "aluminium", "sulphur", "caesium", "deuterium", "tritium", "", "", "", ""],
"VdwPROBE", "#VDW radii for PROBE;{_H}.vdw = 1.0;{_H and connected(_C) and not connected(within(smiles,\'[a]\'))}.vdw = 1.17;{_C}.vdw = 1.75;{_C and connected(3) and connected(_O)}.vdw = 1.65;{_N}.vdw = 1.55;{_O}.vdw = 1.4;{_P}.vdw = 1.8;{_S}.vdw = 1.8;message VDW radii for H, C, N, O, P, and S set according to Word, et al., J. Mol. Biol. (1999) 285, 1711-1733",
"vanderwaalsMars", [1000, 1000, 1000, 1000, 1200, 1100, 1100, 1200, 1400, 1400, 2200, 1400, 1820, 1810, 1220, 2200, 1700, 1530, 628, 1900, 2080, 1920, 1548, 1800, 1950, 1700, 1548, 1700, 1850, 1550, 1400, 1600, 1700, 1520, 1348, 1550, 1730, 1470, 1300, 1500, 1540, 1540, 2020, 1540, 2270, 2270, 2200, 2400, 1730, 1730, 1500, 2200, 2050, 1840, 1500, 2100, 2100, 2100, 2200, 2100, 2080, 1800, 1880, 1950, 2000, 1800, 1808, 1800, 1970, 1750, 1748, 1800, 1880, 1880, 2768, 1880, 2750, 2750, 2388, 2800, 1973, 2310, 1948, 2400, 1700, 2300, 1320, 2300, 1700, 2150, 1948, 2150, 1700, 2050, 1060, 2050, 1700, 2050, 1128, 2050, 1700, 2050, 1188, 2050, 1700, 2050, 1948, 2050, 1700, 2000, 1128, 2000, 1630, 2000, 1240, 2000, 1400, 2000, 1148, 2000, 1390, 2100, 1148, 2100, 1870, 1870, 1548, 2100, 1700, 2110, 3996, 2100, 1850, 1850, 828, 2050, 1900, 1900, 900, 1900, 2100, 1830, 1748, 1900, 2020, 2020, 1900, 2020, 1700, 3030, 2648, 2900, 1700, 2490, 2020, 2550, 1700, 2400, 1608, 2400, 1700, 2300, 1420, 2300, 1700, 2150, 1328, 2150, 1700, 2100, 1748, 2100, 1700, 2050, 1800, 2050, 1700, 2050, 1200, 2050, 1700, 2000, 1220, 2000, 1630, 2050, 1440, 2050, 1720, 2100, 1548, 2100, 1580, 2200, 1748, 2200, 1930, 2200, 1448, 2200, 2170, 1930, 1668, 2250, 2200, 2170, 1120, 2200, 2060, 2060, 1260, 2100, 2150, 1980, 1748, 2100, 2160, 2160, 2100, 2160, 1700, 3430, 3008, 3000, 1700, 2680, 2408, 2700, 1700, 2500, 1828, 2500, 1700, 2480, 1860, 2480, 1700, 2470, 1620, 2470, 1700, 2450, 1788, 2450, 1700, 2430, 1760, 2430, 1700, 2420, 1740, 2420, 1700, 2400, 1960, 2400, 1700, 2380, 1688, 2380, 1700, 2370, 1660, 2370, 1700, 2350, 1628, 2350, 1700, 2330, 1608, 2330, 1700, 2320, 1588, 2320, 1700, 2300, 1568, 2300, 1700, 2280, 1540, 2280, 1700, 2270, 1528, 2270, 1700, 2250, 1400, 2250, 1700, 2200, 1220, 2200, 1700, 2100, 1260, 2100, 1700, 2050, 1300, 2050, 1700, 2000, 1580, 2000, 1700, 2000, 1220, 2000, 1720, 2050, 1548, 2050, 1660, 2100, 1448, 2100, 1550, 2050, 1980, 2050, 1960, 1960, 1708, 2200, 2020, 2020, 2160, 2300, 1700, 2070, 1728, 2300, 1700, 1970, 1208, 2000, 1700, 2020, 1120, 2000, 1700, 2200, 2300, 2000, 1700, 3480, 3240, 2000, 1700, 2830, 2568, 2000, 1700, 2000, 2120, 2000, 1700, 2400, 1840, 2400, 1700, 2000, 1600, 2000, 1860, 2300, 1748, 2300, 1700, 2000, 1708, 2000, 1700, 2000, 1668, 2000, 1700, 2000, 1660, 2000, 1700, 2000, 1648, 2000, 1700, 2000, 1640, 2000, 1700, 2000, 1628, 2000, 1700, 2000, 1620, 2000, 1700, 2000, 1608, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1588, 2000, 1700, 2000, 1580, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000],
"covalentMars", [0, 230, 930, 680, 350, 830, 680, 680, 680, 640, 1120, 970, 1100, 1350, 1200, 750, 1020, 990, 1570, 1330, 990, 1440, 1470, 1330, 1350, 1350, 1340, 1330, 1500, 1520, 1450, 1220, 1170, 1210, 1220, 1210, 1910, 1470, 1120, 1780, 1560, 1480, 1470, 1350, 1400, 1450, 1500, 1590, 1690, 1630, 1460, 1460, 1470, 1400, 1980, 1670, 1340, 1870, 1830, 1820, 1810, 1800, 1800, 1990, 1790, 1760, 1750, 1740, 1730, 1720, 1940, 1720, 1570, 1430, 1370, 1350, 1370, 1320, 1500, 1500, 1700, 1550, 1540, 1540, 1680, 1700, 2400, 2000, 1900, 1880, 1790, 1610, 1580, 1550, 1530, 1510, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600],
"FORMAL_CHARGE_MIN", -4,
"FORMAL_CHARGE_MAX", 7,
"cationLookupTable", [53, 680, 69, 440, 70, 350, 85, 350, 87, 230, 104, 160, 117, 680, 119, 160, 121, 130, 133, 220, 138, 90, 155, 80, 165, 1120, 181, 970, 197, 820, 198, 660, 215, 510, 229, 650, 232, 420, 247, 440, 249, 350, 262, 2190, 264, 370, 266, 300, 281, 340, 283, 270, 293, 1540, 309, 1330, 325, 1180, 326, 990, 343, 732, 357, 960, 358, 940, 359, 760, 360, 680, 374, 880, 375, 740, 376, 630, 377, 590, 389, 810, 390, 890, 391, 630, 394, 520, 406, 800, 407, 660, 408, 600, 411, 460, 422, 740, 423, 640, 438, 720, 439, 630, 454, 690, 469, 960, 470, 720, 485, 880, 486, 740, 501, 810, 503, 620, 518, 730, 520, 530, 535, 580, 537, 460, 549, 660, 552, 500, 554, 420, 569, 470, 571, 390, 597, 1470, 614, 1120, 631, 893, 645, 1090, 648, 790, 661, 1000, 664, 740, 665, 690, 677, 930, 680, 700, 682, 620, 699, 979, 712, 670, 727, 680, 742, 800, 744, 650, 757, 1260, 758, 890, 773, 1140, 774, 970, 791, 810, 806, 930, 808, 710, 823, 760, 825, 620, 837, 820, 840, 700, 842, 560, 857, 620, 859, 500, 885, 1670, 901, 1530, 902, 1340, 917, 1390, 919, 1016, 933, 1270, 935, 1034, 936, 920, 951, 1013, 952, 900, 967, 995, 983, 979, 999, 964, 1014, 1090, 1015, 950, 1031, 938, 1047, 923, 1048, 840, 1063, 908, 1079, 894, 1095, 881, 1111, 870, 1126, 930, 1127, 858, 1143, 850, 1160, 780, 1177, 680, 1192, 700, 1194, 620, 1208, 720, 1211, 560, 1224, 880, 1226, 690, 1240, 680, 1254, 800, 1256, 650, 1269, 1370, 1271, 850, 1285, 1270, 1286, 1100, 1301, 1470, 1303, 950, 1318, 1200, 1320, 840, 1333, 980, 1335, 960, 1337, 740, 1354, 670, 1371, 620, 1397, 1800, 1414, 1430, 1431, 1180, 1448, 1020, 1463, 1130, 1464, 980, 1465, 890, 1480, 970, 1482, 800, 1495, 1100, 1496, 950, 1499, 710, 1511, 1080, 1512, 930, 1527, 1070, 1528, 920],
"anionLookupTable", [19, 1540, 96, 2600, 113, 1710, 130, 1360, 131, 680, 147, 1330, 241, 2120, 258, 1840, 275, 1810, 512, 2720, 529, 2220, 546, 1980, 563, 1960, 800, 2940, 803, 3700, 817, 2450, 834, 2110, 835, 2500, 851, 2200]);
c$.bsCations = c$.prototype.bsCations =  new org.jmol.util.BitSet ();
c$.bsAnions = c$.prototype.bsAnions =  new org.jmol.util.BitSet ();
{
for (var i = 0; i < org.jmol.util.Elements.anionLookupTable.length; i += 2) org.jmol.util.Elements.bsAnions.set (org.jmol.util.Elements.anionLookupTable[i] >> 4);

for (var i = 0; i < org.jmol.util.Elements.cationLookupTable.length; i += 2) org.jmol.util.Elements.bsCations.set (org.jmol.util.Elements.cationLookupTable[i] >> 4);

}Clazz.defineStatics (c$,
"hydrophobicities", [0, 0.62, -2.53, -0.78, -0.9, 0.29, -0.85, -0.74, 0.48, -0.4, 1.38, 1.06, -1.5, 0.64, 1.19, 0.12, -0.18, -0.05, 0.81, 0.26, 1.08]);
{
if ((org.jmol.util.Elements.elementNames.length != org.jmol.util.Elements.elementNumberMax) || (Clazz.doubleToInt (org.jmol.util.Elements.vanderwaalsMars.length / 4) != org.jmol.util.Elements.elementNumberMax) || (org.jmol.util.Elements.covalentMars.length != org.jmol.util.Elements.elementNumberMax)) {
org.jmol.util.Logger.error ("ERROR!!! Element table length mismatch:\n elementSymbols.length=" + org.jmol.util.Elements.elementSymbols.length + "\n elementNames.length=" + org.jmol.util.Elements.elementNames.length + "\n vanderwaalsMars.length=" + org.jmol.util.Elements.vanderwaalsMars.length + "\n covalentMars.length=" + org.jmol.util.Elements.covalentMars.length);
}}Clazz.defineStatics (c$,
"electroNegativities", [0, 2.2, 0, 0.97, 1.47, 2.01, 2.5, 3.07, 3.5, 4.1, 0, 1.01, 1.23, 1.47, 1.74, 2.06, 2.44, 2.83, 0, 0.91, 1.04, 1.2, 1.32, 1.45, 1.56, 1.6, 1.64, 1.7, 1.75, 1.75, 1.66, 1.82, 2.02, 2.2, 2.48, 2.74, 0, 0.89, 0.99, 1.11, 1.22, 1.23, 1.3, 1.36, 1.42, 1.45, 1.35, 1.42, 1.46, 1.49, 1.72, 1.82, 2.01, 2.21]);
});
// 
//// org\jmol\util\Vector3f.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.Tuple3f"], "org.jmol.util.Vector3f", null, function () {
c$ = Clazz.declareType (org.jmol.util, "Vector3f", org.jmol.util.Tuple3f);
c$.newV = Clazz.defineMethod (c$, "newV", 
function (t) {
var v =  new org.jmol.util.Vector3f ();
v.x = t.x;
v.y = t.y;
v.z = t.z;
return v;
}, "org.jmol.util.Tuple3f");
c$.new3 = Clazz.defineMethod (c$, "new3", 
function (x, y, z) {
var v =  new org.jmol.util.Vector3f ();
v.x = x;
v.y = y;
v.z = z;
return v;
}, "~N,~N,~N");
Clazz.defineMethod (c$, "lengthSquared", 
function () {
return this.x * this.x + this.y * this.y + this.z * this.z;
});
Clazz.defineMethod (c$, "length", 
function () {
return Math.sqrt (this.lengthSquared ());
});
Clazz.defineMethod (c$, "cross", 
function (v1, v2) {
this.set (v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
}, "org.jmol.util.Vector3f,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "dot", 
function (v) {
return this.x * v.x + this.y * v.y + this.z * v.z;
}, "org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "normalize", 
function () {
var d = this.length ();
this.x /= d;
this.y /= d;
this.z /= d;
});
Clazz.defineMethod (c$, "angle", 
function (v1) {
var xx = this.y * v1.z - this.z * v1.y;
var yy = this.z * v1.x - this.x * v1.z;
var zz = this.x * v1.y - this.y * v1.x;
var cross = Math.sqrt (xx * xx + yy * yy + zz * zz);
return Math.abs (Math.atan2 (cross, this.dot (v1)));
}, "org.jmol.util.Vector3f");
});
// 
//// org\jmol\viewer\JmolConstants.js 
// 
Clazz.declarePackage ("org.jmol.viewer");
Clazz.load (["java.io.BufferedInputStream", "java.util.Properties", "org.jmol.util.Elements", "$.StringXBuilder", "$.Vector3f"], "org.jmol.viewer.JmolConstants", ["java.lang.NullPointerException", "java.util.Hashtable", "org.jmol.util.Logger", "$.Parser"], function () {
c$ = Clazz.declareType (org.jmol.viewer, "JmolConstants");
c$.embedScript = Clazz.defineMethod (c$, "embedScript", 
function (s) {
return "\n/**" + "**** Jmol Embedded Script ****" + " \n" + s + "\n**/";
}, "~S");
c$.getSpecialAtomName = Clazz.defineMethod (c$, "getSpecialAtomName", 
function (atomID) {
return org.jmol.viewer.JmolConstants.specialAtomNames[atomID];
}, "~N");
c$.getSpecialAtomNames = Clazz.defineMethod (c$, "getSpecialAtomNames", 
($fz = function () {
($t$ = org.jmol.viewer.JmolConstants.htSpecialAtoms =  new java.util.Hashtable (), org.jmol.viewer.JmolConstants.prototype.htSpecialAtoms = org.jmol.viewer.JmolConstants.htSpecialAtoms, $t$);
for (var i = org.jmol.viewer.JmolConstants.specialAtomNames.length; --i >= 0; ) {
var specialAtomName = org.jmol.viewer.JmolConstants.specialAtomNames[i];
if (specialAtomName != null) org.jmol.viewer.JmolConstants.htSpecialAtoms.put (specialAtomName, Integer.$valueOf (i));
}
}, $fz.isPrivate = true, $fz));
c$.lookupSpecialAtomID = Clazz.defineMethod (c$, "lookupSpecialAtomID", 
function (atomName) {
if (org.jmol.viewer.JmolConstants.htSpecialAtoms == null) org.jmol.viewer.JmolConstants.getSpecialAtomNames ();
var boxedAtomID = org.jmol.viewer.JmolConstants.htSpecialAtoms.get (atomName);
if (boxedAtomID != null) return (boxedAtomID.intValue ());
return 0;
}, "~S");
c$.getAminoAcidValenceAndCharge = Clazz.defineMethod (c$, "getAminoAcidValenceAndCharge", 
function (res, name, ret) {
if (res == null || res.length == 0 || res.length > 3 || name.equals ("CA") || name.equals ("CB")) return false;
var ch0 = name.charAt (0);
var ch1 = (name.length == 1 ? '\0' : name.charAt (1));
var isSp2 = false;
var bondCount = ret[3];
switch (res.length) {
case 3:
if (name.length == 1) {
switch (ch0) {
case 'N':
if (bondCount > 1) return false;
ret[1] = 1;
break;
case 'O':
isSp2 = ("HOH;DOD;WAT".indexOf (res) < 0);
break;
default:
isSp2 = true;
}
} else {
var id = res + ch0;
isSp2 = ("ARGN;ASNN;ASNO;ASPO;GLNN;GLNO;GLUO;HISN;HISC;PHECTRPC;TRPN;TYRC".indexOf (id) >= 0);
if ("LYSN".indexOf (id) >= 0) {
ret[1] = 1;
} else if (ch0 == 'O' && ch1 == 'X') {
ret[1] = -1;
}}break;
case 1:
case 2:
if (name.length > 2 && name.charAt (2) == '\'') return false;
switch (ch0) {
case 'C':
if (ch1 == '7') return false;
break;
case 'N':
switch (ch1) {
case '1':
case '3':
if ("A3;A1;C3;G3;I3".indexOf ("" + res.charAt (res.length - 1) + ch1) >= 0) ret[0]--;
break;
case '7':
ret[0]--;
break;
}
break;
}
isSp2 = true;
}
if (isSp2) {
switch (ch0) {
case 'N':
ret[2] = 2;
break;
case 'C':
ret[2] = 2;
ret[0]--;
break;
case 'O':
ret[0]--;
break;
}
}return true;
}, "~S,~S,~A");
c$.getStandardPdbHydrogenCount = Clazz.defineMethod (c$, "getStandardPdbHydrogenCount", 
function (pt) {
return (pt < 0 || pt >= org.jmol.viewer.JmolConstants.pdbHydrogenCount.length ? -1 : org.jmol.viewer.JmolConstants.pdbHydrogenCount[pt]);
}, "~N");
c$.getPdbBondInfo = Clazz.defineMethod (c$, "getPdbBondInfo", 
function (pt) {
if (pt < 0 || pt > org.jmol.viewer.JmolConstants.pdbBondInfo.length) return null;
var s = org.jmol.viewer.JmolConstants.pdbBondInfo[pt];
var temp = org.jmol.util.Parser.getTokens (s);
var info =  new Array (Clazz.doubleToInt (temp.length / 2));
for (var i = 0, p = 0; i < info.length; i++) {
var source = temp[p++];
var target = temp[p++];
if (target.length == 1) switch (target.charAt (0)) {
case 'N':
target = "H@H2";
break;
case 'B':
target = "HB3@HB2";
break;
case 'D':
target = "HD2@HD3";
break;
case 'G':
target = "HG3@HG2";
break;
case '2':
target = "H2''@H2'";
break;
case '5':
target = "H5''@H5'";
break;
}
if (target.charAt (0) != 'H' && source.compareTo (target) > 0) {
s = target;
target = source;
source = s;
}info[i] = [source, target, (target.startsWith ("H") ? "1" : "2")];
}
return info;
}, "~N");
c$.checkCarbohydrate = Clazz.defineMethod (c$, "checkCarbohydrate", 
function (group3) {
return (group3 != null && ",[AHR],[AMU],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLC],[GUP],[LXC],[MAN],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[GCU],[MTL],[NAG],[NDG],[RHA],[SOR],[SOL],[SOE],[XYL],[A2G],[LBT],[NGA],[SIA],[SLB],[AFL],[AGC],[GLB],[NAN],[RAA]".indexOf ("[" + group3.toUpperCase () + "]") >= 0);
}, "~S");
c$.getGroup3List = Clazz.defineMethod (c$, "getGroup3List", 
function () {
if (org.jmol.viewer.JmolConstants.group3List != null) return org.jmol.viewer.JmolConstants.group3List;
var s =  new org.jmol.util.StringXBuilder ();
for (var i = 1; i < 42; i++) s.append (",[").append ((org.jmol.viewer.JmolConstants.predefinedGroup3Names[i] + "   ").substring (0, 3) + "]");

s.append (",[AHR],[AMU],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLC],[GUP],[LXC],[MAN],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[GCU],[MTL],[NAG],[NDG],[RHA],[SOR],[SOL],[SOE],[XYL],[A2G],[LBT],[NGA],[SIA],[SLB],[AFL],[AGC],[GLB],[NAN],[RAA]");
($t$ = org.jmol.viewer.JmolConstants.group3Count = Clazz.doubleToInt (s.length () / 6), org.jmol.viewer.JmolConstants.prototype.group3Count = org.jmol.viewer.JmolConstants.group3Count, $t$);
return ($t$ = org.jmol.viewer.JmolConstants.group3List = s.toString (), org.jmol.viewer.JmolConstants.prototype.group3List = org.jmol.viewer.JmolConstants.group3List, $t$);
});
c$.isHetero = Clazz.defineMethod (c$, "isHetero", 
function (group3) {
return org.jmol.viewer.JmolConstants.getGroup3Pt (group3) >= 42;
}, "~S");
c$.getGroup3Pt = Clazz.defineMethod (c$, "getGroup3Pt", 
($fz = function (group3) {
org.jmol.viewer.JmolConstants.getGroup3List ();
var sb =  new org.jmol.util.StringXBuilder ().append ("[");
sb.append (group3);
switch (group3.length) {
case 1:
sb.append ("  ");
break;
case 2:
sb.append (" ");
break;
}
var pt = org.jmol.viewer.JmolConstants.group3List.indexOf (sb.toString ());
return (pt < 0 ? 2147483647 : Clazz.doubleToInt (pt / 6) + 1);
}, $fz.isPrivate = true, $fz), "~S");
c$.getGroup3Count = Clazz.defineMethod (c$, "getGroup3Count", 
function () {
if (org.jmol.viewer.JmolConstants.group3Count > 0) return org.jmol.viewer.JmolConstants.group3Count;
org.jmol.viewer.JmolConstants.getGroup3List ();
return ($t$ = org.jmol.viewer.JmolConstants.group3Count = Clazz.doubleToInt (org.jmol.viewer.JmolConstants.group3List.length / 6), org.jmol.viewer.JmolConstants.prototype.group3Count = org.jmol.viewer.JmolConstants.group3Count, $t$);
});
c$.isShapeSecondary = Clazz.defineMethod (c$, "isShapeSecondary", 
function (i) {
return i >= 9 && i < 16;
}, "~N");
c$.shapeTokenIndex = Clazz.defineMethod (c$, "shapeTokenIndex", 
function (tok) {
switch (tok) {
case 1141899265:
return 0;
case 1678770178:
case 659488:
return 1;
case 1612189718:
return 2;
case 1611141176:
return 3;
case 1708058:
return 4;
case 1826248715:
return 5;
case 1746538509:
case 537006096:
return 6;
case 1113200652:
return 7;
case 1113200646:
return 8;
case 1115297793:
return 9;
case 1113200654:
return 10;
case 1113200642:
return 11;
case 1650071565:
return 12;
case 1113200647:
return 13;
case 1113200649:
return 14;
case 1113200650:
return 15;
case 1113198595:
return 16;
case 135174:
return 17;
case 135198:
return 18;
case 1113198597:
return 19;
case 1113198596:
return 20;
case 135192:
return 21;
case 135176:
return 22;
case 135180:
return 23;
case 135402505:
return 24;
case 135182:
return 25;
case 1183762:
return 26;
case 135188:
return 27;
case 135190:
return 28;
case 537022465:
return 29;
case 1611272194:
return 30;
case 1679429641:
return 31;
case 1614417948:
return 32;
case 544771:
return 33;
case 1611272202:
return 34;
}
return -1;
}, "~N");
c$.getShapeClassName = Clazz.defineMethod (c$, "getShapeClassName", 
function (shapeID, isRenderer) {
if (shapeID < 0) return org.jmol.viewer.JmolConstants.shapeClassBases[~shapeID];
return "org.jmol." + (isRenderer ? "render" : "shape") + (shapeID >= 9 && shapeID < 16 ? "bio." : shapeID >= 16 && shapeID < 23 ? "special." : shapeID >= 23 && shapeID < 29 ? "surface." : ".") + org.jmol.viewer.JmolConstants.shapeClassBases[shapeID];
}, "~N,~B");
c$.getShapeVisibilityFlag = Clazz.defineMethod (c$, "getShapeVisibilityFlag", 
function (shapeID) {
return (4 << shapeID);
}, "~N");
Clazz.defineStatics (c$,
"copyright", "(C) 2012 Jmol Development",
"version", null,
"date", null);
{
var tmpVersion = null;
var tmpDate = null;
var bis = null;
var is = null;
try {
{
tmpVersion = ___JmolVersion; tmpDate = ___JmolDate;
}if (tmpDate != null) {
tmpDate = tmpDate.substring (8, 24);
tmpVersion = tmpVersion.substring (1, tmpVersion.length - 1);
}} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
} finally {
tmpVersion = ___JmolVersion; tmpDate = ___JmolDate;
}
($t$ = org.jmol.viewer.JmolConstants.version = (tmpVersion != null ? tmpVersion : "(Unknown version)"), org.jmol.viewer.JmolConstants.prototype.version = org.jmol.viewer.JmolConstants.version, $t$);
($t$ = org.jmol.viewer.JmolConstants.date = (tmpDate != null ? tmpDate : "(Unknown date)"), org.jmol.viewer.JmolConstants.prototype.date = org.jmol.viewer.JmolConstants.date, $t$);
}Clazz.defineStatics (c$,
"officialRelease", false,
"CLASSBASE_OPTIONS", "org.jmol.",
"DEFAULT_HELP_PATH", "http://chemapps.stolaf.edu/jmol/docs/index.htm",
"EMBEDDED_SCRIPT_TAG", "**** Jmol Embedded Script ****",
"NOTE_SCRIPT_FILE", "NOTE: file recognized as a script file: ",
"SCRIPT_EDITOR_IGNORE", "\1## EDITOR_IGNORE ##",
"LOAD_ATOM_DATA_TYPES", "xyz;vxyz;vibration;temperature;occupancy;partialcharge",
"radiansPerDegree", (0.017453292519943295),
"allowedQuaternionFrames", "RC;RP;a;b;c;n;p;q;x;",
"EXPORT_DRIVER_LIST", "Idtf;Maya;Povray;Vrml;X3d;Tachyon;Obj");
c$.center = c$.prototype.center = org.jmol.util.Vector3f.new3 (0, 0, 0);
c$.axisX = c$.prototype.axisX = org.jmol.util.Vector3f.new3 (1, 0, 0);
c$.axisY = c$.prototype.axisY = org.jmol.util.Vector3f.new3 (0, 1, 0);
c$.axisZ = c$.prototype.axisZ = org.jmol.util.Vector3f.new3 (0, 0, 1);
c$.axisNX = c$.prototype.axisNX = org.jmol.util.Vector3f.new3 (-1, 0, 0);
c$.axisNY = c$.prototype.axisNY = org.jmol.util.Vector3f.new3 (0, -1, 0);
c$.axisNZ = c$.prototype.axisNZ = org.jmol.util.Vector3f.new3 (0, 0, -1);
c$.unitAxisVectors = c$.prototype.unitAxisVectors = [org.jmol.viewer.JmolConstants.axisX, org.jmol.viewer.JmolConstants.axisY, org.jmol.viewer.JmolConstants.axisZ, org.jmol.viewer.JmolConstants.axisNX, org.jmol.viewer.JmolConstants.axisNY, org.jmol.viewer.JmolConstants.axisNZ];
Clazz.defineStatics (c$,
"XY_ZTOP", 100,
"DEFAULT_PERCENT_VDW_ATOM", 23,
"DEFAULT_BOND_RADIUS", 0.15,
"DEFAULT_BOND_MILLIANGSTROM_RADIUS", Clazz.floatToShort (150.0),
"DEFAULT_STRUT_RADIUS", 0.3,
"DEFAULT_BOND_TOLERANCE", 0.45,
"DEFAULT_MIN_BOND_DISTANCE", 0.4,
"DEFAULT_MAX_CONNECT_DISTANCE", 100000000,
"DEFAULT_MIN_CONNECT_DISTANCE", 0.1,
"MINIMIZATION_ATOM_MAX", 200,
"MINIMIZE_FIXED_RANGE", 5.0,
"MOUSE_NONE", -1,
"MULTIBOND_NEVER", 0,
"MULTIBOND_WIREFRAME", 1,
"MULTIBOND_NOTSMALL", 2,
"MULTIBOND_ALWAYS", 3,
"MAXIMUM_AUTO_BOND_COUNT", 20,
"madMultipleBondSmallMaximum", 500,
"ANGSTROMS_PER_BOHR", 0.5291772,
"altArgbsCpk", [0xFFFF1493, 0xFFBFA6A6, 0xFFFFFF30, 0xFF57178F, 0xFFFFFFC0, 0xFFFFFFA0, 0xFFD8D8D8, 0xFF505050, 0xFF404040, 0xFF105050],
"argbsAmino", [0xFFBEA06E, 0xFFC8C8C8, 0xFF145AFF, 0xFF00DCDC, 0xFFE60A0A, 0xFFE6E600, 0xFF00DCDC, 0xFFE60A0A, 0xFFEBEBEB, 0xFF8282D2, 0xFF0F820F, 0xFF0F820F, 0xFF145AFF, 0xFFE6E600, 0xFF3232AA, 0xFFDC9682, 0xFFFA9600, 0xFFFA9600, 0xFFB45AB4, 0xFF3232AA, 0xFF0F820F, 0xFFFF69B4, 0xFFFF69B4, 0xFFBEA06E],
"argbShapelyBackbone", 0xFFB8B8B8,
"argbShapelySpecial", 0xFF5E005E,
"argbShapelyDefault", 0xFFFF00FF,
"argbsChainAtom", [0xFFffffff, 0xFFC0D0FF, 0xFFB0FFB0, 0xFFFFC0C8, 0xFFFFFF80, 0xFFFFC0FF, 0xFFB0F0F0, 0xFFFFD070, 0xFFF08080, 0xFFF5DEB3, 0xFF00BFFF, 0xFFCD5C5C, 0xFF66CDAA, 0xFF9ACD32, 0xFFEE82EE, 0xFF00CED1, 0xFF00FF7F, 0xFF3CB371, 0xFF00008B, 0xFFBDB76B, 0xFF006400, 0xFF800000, 0xFF808000, 0xFF800080, 0xFF008080, 0xFFB8860B, 0xFFB22222],
"argbsChainHetero", [0xFFffffff, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382]);
c$.FORMAL_CHARGE_COLIX_RED = c$.prototype.FORMAL_CHARGE_COLIX_RED = org.jmol.util.Elements.elementSymbols.length;
c$.FORMAL_CHARGE_COLIX_WHITE = c$.prototype.FORMAL_CHARGE_COLIX_WHITE = (org.jmol.viewer.JmolConstants.FORMAL_CHARGE_COLIX_RED + 4);
c$.FORMAL_CHARGE_COLIX_BLUE = c$.prototype.FORMAL_CHARGE_COLIX_BLUE = (org.jmol.viewer.JmolConstants.FORMAL_CHARGE_COLIX_WHITE + 7);
Clazz.defineStatics (c$,
"FORMAL_CHARGE_RANGE_SIZE", 12,
"argbsFormalCharge", [0xFFFF0000, 0xFFFF4040, 0xFFFF8080, 0xFFFFC0C0, 0xFFFFFFFF, 0xFFD8D8FF, 0xFFB4B4FF, 0xFF9090FF, 0xFF6C6CFF, 0xFF4848FF, 0xFF2424FF, 0xFF0000FF],
"FORMAL_CHARGE_INDEX_WHITE", 4);
c$.FORMAL_CHARGE_INDEX_MAX = c$.prototype.FORMAL_CHARGE_INDEX_MAX = org.jmol.viewer.JmolConstants.argbsFormalCharge.length;
c$.PARTIAL_CHARGE_COLIX_RED = c$.prototype.PARTIAL_CHARGE_COLIX_RED = (org.jmol.viewer.JmolConstants.FORMAL_CHARGE_COLIX_BLUE + 1);
c$.PARTIAL_CHARGE_COLIX_WHITE = c$.prototype.PARTIAL_CHARGE_COLIX_WHITE = (org.jmol.viewer.JmolConstants.PARTIAL_CHARGE_COLIX_RED + 15);
c$.PARTIAL_CHARGE_COLIX_BLUE = c$.prototype.PARTIAL_CHARGE_COLIX_BLUE = (org.jmol.viewer.JmolConstants.PARTIAL_CHARGE_COLIX_WHITE + 15);
Clazz.defineStatics (c$,
"PARTIAL_CHARGE_RANGE_SIZE", 31,
"argbsRwbScale", [0xFFFF0000, 0xFFFF1010, 0xFFFF2020, 0xFFFF3030, 0xFFFF4040, 0xFFFF5050, 0xFFFF6060, 0xFFFF7070, 0xFFFF8080, 0xFFFF9090, 0xFFFFA0A0, 0xFFFFB0B0, 0xFFFFC0C0, 0xFFFFD0D0, 0xFFFFE0E0, 0xFFFFFFFF, 0xFFE0E0FF, 0xFFD0D0FF, 0xFFC0C0FF, 0xFFB0B0FF, 0xFFA0A0FF, 0xFF9090FF, 0xFF8080FF, 0xFF7070FF, 0xFF6060FF, 0xFF5050FF, 0xFF4040FF, 0xFF3030FF, 0xFF2020FF, 0xFF1010FF, 0xFF0000FF],
"argbsRoygbScale", [0xFFFF0000, 0xFFFF2000, 0xFFFF4000, 0xFFFF6000, 0xFFFF8000, 0xFFFFA000, 0xFFFFC000, 0xFFFFE000, 0xFFFFF000, 0xFFFFFF00, 0xFFF0F000, 0xFFE0FF00, 0xFFC0FF00, 0xFFA0FF00, 0xFF80FF00, 0xFF60FF00, 0xFF40FF00, 0xFF20FF00, 0xFF00FF00, 0xFF00FF20, 0xFF00FF40, 0xFF00FF60, 0xFF00FF80, 0xFF00FFA0, 0xFF00FFC0, 0xFF00FFE0, 0xFF00FFFF, 0xFF00E0FF, 0xFF00C0FF, 0xFF00A0FF, 0xFF0080FF, 0xFF0060FF, 0xFF0040FF, 0xFF0020FF, 0xFF0000FF],
"argbsIsosurfacePositive", 0xFF5020A0,
"argbsIsosurfaceNegative", 0xFFA02050,
"specialAtomNames", [null, "N", "CA", "C", "O", "O1", "O5'", "C5'", "C4'", "C3'", "O3'", "C2'", "C1'", "P", "OD1", "OD2", "OE1", "OE2", "SG", null, null, null, null, null, null, null, null, null, null, null, null, null, "N1", "C2", "N3", "C4", "C5", "C6", "O2", "N7", "C8", "N9", "N4", "N2", "N6", "C5M", "O6", "O4", "S4", "C7", "H1", "H2", "H3", null, null, null, null, null, null, null, null, null, null, null, "OXT", "H", "1H", "2H", "3H", "HA", "1HA", "2HA", "H5T", "O5T", "O1P", "OP1", "O2P", "OP2", "O4'", "O2'", "1H5'", "2H5'", "H4'", "H3'", "1H2'", "2H2'", "2HO'", "H1'", "H3T", "HO3'", "HO5'", "HA2", "HA3", "HA2", "H5'", "H5''", "H2'", "H2''", "HO2'", "O3P", "OP3"]);
c$.ATOMID_MAX = c$.prototype.ATOMID_MAX = org.jmol.viewer.JmolConstants.specialAtomNames.length;
Clazz.defineStatics (c$,
"ATOMID_AMINO_NITROGEN", 1,
"ATOMID_ALPHA_CARBON", 2,
"ATOMID_CARBONYL_CARBON", 3,
"ATOMID_CARBONYL_OXYGEN", 4,
"ATOMID_O1", 5,
"ATOMID_ALPHA_ONLY_MASK", 4,
"ATOMID_PROTEIN_MASK", 14,
"ATOMID_O5_PRIME", 6,
"ATOMID_C4_PRIME", 8,
"ATOMID_C3_PRIME", 9,
"ATOMID_O3_PRIME", 10,
"ATOMID_C1_PRIME", 12,
"ATOMID_NUCLEIC_MASK", 8128,
"ATOMID_NUCLEIC_PHOSPHORUS", 13,
"ATOMID_PHOSPHORUS_ONLY_MASK", 8192,
"ATOMID_DISTINGUISHING_ATOM_MAX", 14,
"ATOMID_CARBONYL_OD1", 14,
"ATOMID_CARBONYL_OD2", 15,
"ATOMID_CARBONYL_OE1", 16,
"ATOMID_CARBONYL_OE2", 17,
"ATOMID_SG", 18,
"ATOMID_N1", 32,
"ATOMID_C2", 33,
"ATOMID_N3", 34,
"ATOMID_C4", 35,
"ATOMID_C5", 36,
"ATOMID_C6", 37,
"ATOMID_O2", 38,
"ATOMID_N7", 39,
"ATOMID_C8", 40,
"ATOMID_N9", 41,
"ATOMID_N4", 42,
"ATOMID_N2", 43,
"ATOMID_N6", 44,
"ATOMID_C5M", 45,
"ATOMID_O6", 46,
"ATOMID_O4", 47,
"ATOMID_S4", 48,
"ATOMID_C7", 49,
"ATOMID_BACKBONE_MIN", 64,
"ATOMID_TERMINATING_OXT", 64,
"ATOMID_H5T_TERMINUS", 72,
"ATOMID_O5T_TERMINUS", 73,
"ATOMID_O1P", 74,
"ATOMID_OP1", 75,
"ATOMID_O2P", 76,
"ATOMID_OP2", 77,
"ATOMID_O2_PRIME", 79,
"ATOMID_H3T_TERMINUS", 88,
"ATOMID_HO3_PRIME", 89,
"ATOMID_HO5_PRIME", 90,
"htSpecialAtoms", null,
"GROUPID_ARGININE", 2,
"GROUPID_ASPARAGINE", 3,
"GROUPID_ASPARTATE", 4,
"GROUPID_CYSTEINE", 5,
"GROUPID_GLUTAMINE", 6,
"GROUPID_GLUTAMATE", 7,
"GROUPID_HISTIDINE", 9,
"GROUPID_LYSINE", 12,
"GROUPID_PROLINE", 15,
"GROUPID_TRYPTOPHAN", 19,
"GROUPID_AMINO_MAX", 24,
"GROUPID_NUCLEIC_MAX", 42,
"GROUPID_WATER", 42,
"GROUPID_SOLVENT_MIN", 45,
"GROUPID_ION_MIN", 46,
"GROUPID_ION_MAX", 48,
"predefinedGroup3Names", ["", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "G", "C", "A", "T", "U", "I", "DG", "DC", "DA", "DT", "DU", "DI", "+G", "+C", "+A", "+T", "+U", "+I", "HOH", "DOD", "WAT", "UREA", "PO4", "SO4"],
"naNoH", "A3;A1;C3;G3;I3",
"aaSp2", "ARGN;ASNN;ASNO;ASPO;GLNN;GLNO;GLUO;HISN;HISC;PHECTRPC;TRPN;TYRC",
"aaPlus", "LYSN",
"pdbBondInfo", ["", "N N CA HA C O CB HB?", "N N CA HA C O CB HB2@HB3 CG HG2@HG3 CD D NE HE CZ NH1 NH1 HH11@HH12 NH2 HH21@HH22", "N N CA HA C O CB B CG OD1 ND2 HD21@HD22", "N N CA HA C O CB B CG OD1", "N N CA HA C O CB B SG HG", "N N CA HA C O CB B CG G CD OE1 NE2 HE21@HE22", "N N CA HA C O CB B CG G CD OE1", "N N CA HA2@HA3 C O", "N N CA HA C O CB B CG CD2 ND1 CE1 ND1 HD1 CD2 HD2 CE1 HE1 NE2 HE2", "N N CA HA C O CB HB CG1 HG12@HG13 CG2 HG2? CD1 HD1?", "N N CA HA C O CB HB2@HB3 CG HG CD1 HD1? CD2 HD2?", "N N CA HA C O CB B CG G CD HD2@HD3 CE HE3@HE2 NZ HZ?", "N N CA HA C O CB HB2@HB3 CG HG2@HG3 CE HE?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 CZ HZ", "N H CA HA C O CB B CG G CD HD2@HD3", "N N CA HA C O CB B OG HG", "N N CA HA C O CB HB OG1 HG1 CG2 HG2?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 NE1 HE1 CE3 CZ3 CE3 HE3 CZ2 CH2 CZ2 HZ2 CZ3 HZ3 CH2 HH2", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 OH HH", "N N CA HA C O CB HB CG1 HG1? CG2 HG2?", "CA HA C O CB HB2@HB1 C H", "CA HA C O CB HB1 CB HB2 CG HG1 CG HG2", "", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H21@H22", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H21@H22", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2", "P OP1 C5' H5'@H5'' C4' H4' C3' H3' C2' H2'@H2'' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2'@H2'' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2"],
"pdbHydrogenCount", [0, 6, 16, 7, 6, 6, 9, 8, 4, 9, 12, 12, 14, 10, 10, 8, 6, 8, 11, 10, 10, 3, 5, 0, 13, 13, 13, -1, 12, 12, 13, 13, 13, 14, 12, 12],
"argbsShapely", [0xFFFF00FF, 0xFF00007C, 0xFFFF7C70, 0xFF8CFF8C, 0xFFA00042, 0xFFFFFF70, 0xFFFF4C4C, 0xFF660000, 0xFFFFFFFF, 0xFF7070FF, 0xFF004C00, 0xFF455E45, 0xFF4747B8, 0xFF534C52, 0xFFB8A042, 0xFF525252, 0xFFFF7042, 0xFFB84C00, 0xFF4F4600, 0xFF8C704C, 0xFFFF8CFF, 0xFFFF00FF, 0xFFFF00FF, 0xFFFF00FF, 0xFFFF7070, 0xFFFF8C4B, 0xFFA0A0FF, 0xFFA0FFA0, 0xFFFF8080, 0xFF80FFFF, 0xFFFF7070, 0xFFFF8C4B, 0xFFA0A0FF, 0xFFA0FFA0, 0xFFFF8080, 0xFF80FFFF, 0xFFFF7070, 0xFFFF8C4B, 0xFFA0A0FF, 0xFFA0FFA0, 0xFFFF8080, 0xFF80FFFF],
"allCarbohydrates", ",[AHR],[AMU],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLC],[GUP],[LXC],[MAN],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[GCU],[MTL],[NAG],[NDG],[RHA],[SOR],[SOL],[SOE],[XYL],[A2G],[LBT],[NGA],[SIA],[SLB],[AFL],[AGC],[GLB],[NAN],[RAA]",
"group3List", null,
"group3Count", 0,
"predefinedGroup1Names", ['\0', 'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'A', 'G', '?', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'I'],
"predefinedVariable", ["@_1H _H & !(_2H,_3H)", "@_12C _C & !(_13C,_14C)", "@_14N _N & !(_15N)", "@water _g>=42 & _g<45, oxygen & connected(2) & connected(2, hydrogen), (hydrogen) & connected(oxygen & connected(2) & connected(2, hydrogen))", "@solvent water, (_g>=45 & _g<48)", "@ligand !(_g<46,protein,nucleic,water)", "@turn structure=1", "@sheet structure=2", "@helix structure=3", "@helix310 substructure=7", "@helixalpha substructure=8", "@helixpi substructure=9", "@bonded bondcount>0"],
"predefinedStatic", ["@amino _g>0 & _g<=23", "@acidic asp,glu", "@basic arg,his,lys", "@charged acidic,basic", "@negative acidic", "@positive basic", "@neutral amino&!(acidic,basic)", "@polar amino&!hydrophobic", "@cyclic his,phe,pro,trp,tyr", "@acyclic amino&!cyclic", "@aliphatic ala,gly,ile,leu,val", "@aromatic his,phe,trp,tyr", "@cystine within(group, (cys.sg or cyx.sg) and connected(cys.sg or cyx.sg))", "@buried ala,cys,ile,leu,met,phe,trp,val", "@surface amino&!buried", "@hydrophobic ala,gly,ile,leu,met,phe,pro,trp,tyr,val", "@mainchain backbone", "@small ala,gly,ser", "@medium asn,asp,cys,pro,thr,val", "@large arg,glu,gln,his,ile,leu,lys,met,phe,trp,tyr", "@c nucleic & ([C] or [DC] or within(group,_a=42))", "@g nucleic & ([G] or [DG] or within(group,_a=43))", "@cg c,g", "@a nucleic & ([A] or [DA] or within(group,_a=44))", "@t nucleic & ([T] or [DT] or within(group,_a=45 | _a=49))", "@at a,t", "@i nucleic & ([I] or [DI] or within(group,_a=46) & !g)", "@u nucleic & ([U] or [DU] or within(group,_a=47) & !t)", "@tu nucleic & within(group,_a=48)", "@ions _g>=46&_g<48", "@alpha _a=2", "@backbone (protein,nucleic) & (_a>0 & _a<14 || _a>=64) | _H & protein & connected(*.N)", "@spine protein & _a>0 & _a<= 3 || nucleic & (_a >= 6 & _a <= 10 || _a=13)", "@sidechain (protein,nucleic) & !backbone", "@base nucleic & !backbone", "@dynamic_flatring search('[a]')"],
"MODELKIT_ZAP_STRING", "1 0 C 0 0",
"MODELKIT_ZAP_TITLE", "Jmol Model Kit",
"ADD_HYDROGEN_TITLE", "Viewer.AddHydrogens",
"DEFAULT_FONTFACE", "SansSerif",
"DEFAULT_FONTSTYLE", "Plain",
"LABEL_MINIMUM_FONTSIZE", 6,
"LABEL_MAXIMUM_FONTSIZE", 63,
"LABEL_DEFAULT_FONTSIZE", 13,
"LABEL_DEFAULT_X_OFFSET", 4,
"LABEL_DEFAULT_Y_OFFSET", 4,
"MEASURE_DEFAULT_FONTSIZE", 15,
"AXES_DEFAULT_FONTSIZE", 14,
"SHAPE_BALLS", 0,
"SHAPE_STICKS", 1,
"SHAPE_HSTICKS", 2,
"SHAPE_SSSTICKS", 3,
"SHAPE_STRUTS", 4,
"SHAPE_LABELS", 5,
"SHAPE_MEASURES", 6,
"SHAPE_STARS", 7,
"SHAPE_HALOS", 8,
"SHAPE_MIN_SECONDARY", 9,
"SHAPE_BACKBONE", 9,
"SHAPE_TRACE", 10,
"SHAPE_CARTOON", 11,
"SHAPE_STRANDS", 12,
"SHAPE_MESHRIBBON", 13,
"SHAPE_RIBBONS", 14,
"SHAPE_ROCKETS", 15,
"SHAPE_MAX_SECONDARY", 16,
"SHAPE_MIN_SPECIAL", 16,
"SHAPE_DOTS", 16,
"SHAPE_DIPOLES", 17,
"SHAPE_VECTORS", 18,
"SHAPE_GEOSURFACE", 19,
"SHAPE_ELLIPSOIDS", 20,
"SHAPE_MAX_SIZE_ZERO_ON_RESTRICT", 21,
"SHAPE_POLYHEDRA", 21,
"SHAPE_MIN_HAS_ID", 22,
"SHAPE_MIN_MESH_COLLECTION", 22,
"SHAPE_DRAW", 22,
"SHAPE_MAX_SPECIAL", 23,
"SHAPE_MIN_SURFACE", 23,
"SHAPE_ISOSURFACE", 23,
"SHAPE_CONTACT", 24,
"SHAPE_LCAOCARTOON", 25,
"SHAPE_MO", 26,
"SHAPE_PMESH", 27,
"SHAPE_PLOT3D", 28,
"SHAPE_MAX_SURFACE", 29,
"SHAPE_MAX_MESH_COLLECTION", 29,
"SHAPE_ECHO", 29,
"SHAPE_MAX_HAS_ID", 30,
"SHAPE_AXES", 30,
"SHAPE_BBCAGE", 31,
"SHAPE_UCCAGE", 32,
"SHAPE_HOVER", 33,
"SHAPE_FRANK", 34,
"SHAPE_MAX", 35,
"shapeClassBases", ["Balls", "Sticks", "Hsticks", "Sssticks", "Struts", "Labels", "Measures", "Stars", "Halos", "Backbone", "Trace", "Cartoon", "Strands", "MeshRibbon", "Ribbons", "Rockets", "Dots", "Dipoles", "Vectors", "GeoSurface", "Ellipsoids", "Polyhedra", "Draw", "Isosurface", "Contact", "LcaoCartoon", "MolecularOrbital", "Pmesh", "Plot3D", "Echo", "Axes", "Bbcage", "Uccage", "Hover", "Frank"],
"ATOM_IN_FRAME", 1,
"ATOM_SLABBED", 2,
"CURSOR_DEFAULT", 0,
"CURSOR_HAND", 1,
"CURSOR_CROSSHAIR", 2,
"CURSOR_MOVE", 3,
"CURSOR_WAIT", 4,
"CURSOR_ZOOM", 5);
{
if (org.jmol.viewer.JmolConstants.argbsFormalCharge.length != 12) {
org.jmol.util.Logger.error ("formal charge color table length");
throw  new NullPointerException ();
}if (org.jmol.viewer.JmolConstants.shapeClassBases.length != 35) {
org.jmol.util.Logger.error ("shapeClassBases wrong length");
throw  new NullPointerException ();
}if (org.jmol.viewer.JmolConstants.argbsAmino.length != 24) {
org.jmol.util.Logger.error ("argbsAmino wrong length");
throw  new NullPointerException ();
}if (org.jmol.viewer.JmolConstants.argbsShapely.length != 42) {
org.jmol.util.Logger.error ("argbsShapely wrong length");
throw  new NullPointerException ();
}if (org.jmol.viewer.JmolConstants.argbsChainHetero.length != org.jmol.viewer.JmolConstants.argbsChainAtom.length) {
org.jmol.util.Logger.error ("argbsChainHetero wrong length");
throw  new NullPointerException ();
}if (org.jmol.viewer.JmolConstants.shapeClassBases.length != 35) {
org.jmol.util.Logger.error ("the shapeClassBases array has the wrong length");
throw  new NullPointerException ();
}}});
// 
//// org\jmol\util\Int2IntHash.js 
// 
Clazz.declarePackage ("org.jmol.util");
c$ = Clazz.decorateAsClass (function () {
this.entryCount = 0;
this.entries = null;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Int2IntHash");
Clazz.makeConstructor (c$, 
function (initialCapacity) {
this.entries =  new Array (initialCapacity);
}, "~N");
Clazz.defineMethod (c$, "get", 
function (key) {
var entries = this.entries;
var hash = (key & 0x7FFFFFFF) % entries.length;
for (var e = entries[hash]; e != null; e = e.next) if (e.key == key) return e.value;

return -2147483648;
}, "~N");
Clazz.defineMethod (c$, "put", 
function (key, value) {
var entries = this.entries;
var hash = (key & 0x7FFFFFFF) % entries.length;
for (var e = entries[hash]; e != null; e = e.next) if (e.key == key) {
e.value = value;
return;
}
if (this.entryCount > entries.length) this.rehash ();
entries = this.entries;
hash = (key & 0x7FFFFFFF) % entries.length;
entries[hash] =  new org.jmol.util.Int2IntHash.Entry (key, value, entries[hash]);
++this.entryCount;
}, "~N,~N");
Clazz.defineMethod (c$, "rehash", 
($fz = function () {
var oldEntries = this.entries;
var oldSize = oldEntries.length;
var newSize = oldSize * 2 + 1;
var newEntries =  new Array (newSize);
for (var i = oldSize; --i >= 0; ) {
for (var e = oldEntries[i]; e != null; ) {
var t = e;
e = e.next;
var hash = (t.key & 0x7FFFFFFF) % newSize;
t.next = newEntries[hash];
newEntries[hash] = t;
}
}
this.entries = newEntries;
}, $fz.isPrivate = true, $fz));
Clazz.pu$h ();
c$ = Clazz.decorateAsClass (function () {
this.key = 0;
this.value = 0;
this.next = null;
Clazz.instantialize (this, arguments);
}, org.jmol.util.Int2IntHash, "Entry");
Clazz.makeConstructor (c$, 
function (a, b, c) {
this.key = a;
this.value = b;
this.next = c;
}, "~N,~N,org.jmol.util.Int2IntHash.Entry");
c$ = Clazz.p0p ();
// 
//// org\jmol\util\Colix.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.ArrayUtil", "$.Int2IntHash"], "org.jmol.util.Colix", ["java.lang.Float", "$.IndexOutOfBoundsException", "org.jmol.constant.EnumPalette", "org.jmol.util.ColorUtil", "$.Escape", "$.Logger", "$.Parser", "$.Shader", "$.StringXBuilder"], function () {
c$ = Clazz.declareType (org.jmol.util, "Colix");
Clazz.makeConstructor (c$, 
function () {
});
c$.getColix = Clazz.defineMethod (c$, "getColix", 
function (argb) {
if (argb == 0) return 0;
var translucentFlag = 0;
if ((argb & 0xFF000000) != (-16777216)) {
argb |= 0xFF000000;
translucentFlag = 8192;
}var c = org.jmol.util.Colix.colixHash.get (argb);
if ((c & 3) == 3) translucentFlag = 0;
return (c > 0 ? (c | translucentFlag) : (org.jmol.util.Colix.allocateColix (argb) | translucentFlag));
}, "~N");
c$.allocateColix = Clazz.defineMethod (c$, "allocateColix", 
function (argb) {
if ((argb & 0xFF000000) != (-16777216)) throw  new IndexOutOfBoundsException ();
for (var i = org.jmol.util.Colix.colixMax; --i >= 4; ) if (argb == org.jmol.util.Colix.argbs[i]) return i;

if (org.jmol.util.Colix.colixMax == org.jmol.util.Colix.argbs.length) {
var oldSize = org.jmol.util.Colix.colixMax;
var newSize = oldSize * 2;
if (newSize > 2048) newSize = 2048;
($t$ = org.jmol.util.Colix.argbs = org.jmol.util.ArrayUtil.arrayCopyI (org.jmol.util.Colix.argbs, newSize), org.jmol.util.Colix.prototype.argbs = org.jmol.util.Colix.argbs, $t$);
if (org.jmol.util.Colix.argbsGreyscale != null) ($t$ = org.jmol.util.Colix.argbsGreyscale = org.jmol.util.ArrayUtil.arrayCopyI (org.jmol.util.Colix.argbsGreyscale, newSize), org.jmol.util.Colix.prototype.argbsGreyscale = org.jmol.util.Colix.argbsGreyscale, $t$);
($t$ = org.jmol.util.Colix.ashades = org.jmol.util.ArrayUtil.arrayCopyII (org.jmol.util.Colix.ashades, newSize), org.jmol.util.Colix.prototype.ashades = org.jmol.util.Colix.ashades, $t$);
if (org.jmol.util.Colix.ashadesGreyscale != null) ($t$ = org.jmol.util.Colix.ashadesGreyscale = org.jmol.util.ArrayUtil.arrayCopyII (org.jmol.util.Colix.ashadesGreyscale, newSize), org.jmol.util.Colix.prototype.ashadesGreyscale = org.jmol.util.Colix.ashadesGreyscale, $t$);
}org.jmol.util.Colix.argbs[org.jmol.util.Colix.colixMax] = argb;
if (org.jmol.util.Colix.argbsGreyscale != null) org.jmol.util.Colix.argbsGreyscale[org.jmol.util.Colix.colixMax] = org.jmol.util.ColorUtil.calcGreyscaleRgbFromRgb (argb);
org.jmol.util.Colix.colixHash.put (argb, org.jmol.util.Colix.colixMax);
return (org.jmol.util.Colix.colixMax < 2047 ? ($t$ = org.jmol.util.Colix.colixMax ++, org.jmol.util.Colix.prototype.colixMax = org.jmol.util.Colix.colixMax, $t$) : org.jmol.util.Colix.colixMax);
}, "~N");
c$.calcArgbsGreyscale = Clazz.defineMethod (c$, "calcArgbsGreyscale", 
($fz = function () {
if (org.jmol.util.Colix.argbsGreyscale != null) return;
var a =  Clazz.newIntArray (org.jmol.util.Colix.argbs.length, 0);
for (var i = org.jmol.util.Colix.argbs.length; --i >= 4; ) a[i] = org.jmol.util.ColorUtil.calcGreyscaleRgbFromRgb (org.jmol.util.Colix.argbs[i]);

($t$ = org.jmol.util.Colix.argbsGreyscale = a, org.jmol.util.Colix.prototype.argbsGreyscale = org.jmol.util.Colix.argbsGreyscale, $t$);
}, $fz.isPrivate = true, $fz));
c$.getArgbGreyscale = Clazz.defineMethod (c$, "getArgbGreyscale", 
function (colix) {
if (org.jmol.util.Colix.argbsGreyscale == null) org.jmol.util.Colix.calcArgbsGreyscale ();
return org.jmol.util.Colix.argbsGreyscale[colix & -30721];
}, "~N");
c$.getShadesArgb = Clazz.defineMethod (c$, "getShadesArgb", 
function (argb, asGrey) {
if (asGrey) {
if (org.jmol.util.Colix.argbsGreyscale == null) org.jmol.util.Colix.calcArgbsGreyscale ();
org.jmol.util.Colix.argbsGreyscale[2047] = org.jmol.util.ColorUtil.calcGreyscaleRgbFromRgb (argb);
}return org.jmol.util.Colix.ashades[2047] = org.jmol.util.Shader.getShades (argb, false);
}, "~N,~B");
c$.getShades = Clazz.defineMethod (c$, "getShades", 
function (colix) {
colix &= -30721;
var shades = org.jmol.util.Colix.ashades[colix];
if (shades == null) shades = org.jmol.util.Colix.ashades[colix] = org.jmol.util.Shader.getShades (org.jmol.util.Colix.argbs[colix], false);
return shades;
}, "~N");
c$.getShadesGreyscale = Clazz.defineMethod (c$, "getShadesGreyscale", 
function (colix) {
colix &= -30721;
if (org.jmol.util.Colix.ashadesGreyscale == null) ($t$ = org.jmol.util.Colix.ashadesGreyscale = org.jmol.util.ArrayUtil.newInt2 (org.jmol.util.Colix.ashades.length), org.jmol.util.Colix.prototype.ashadesGreyscale = org.jmol.util.Colix.ashadesGreyscale, $t$);
var shadesGreyscale = org.jmol.util.Colix.ashadesGreyscale[colix];
if (shadesGreyscale == null) shadesGreyscale = org.jmol.util.Colix.ashadesGreyscale[colix] = org.jmol.util.Shader.getShades (org.jmol.util.Colix.argbs[colix], true);
return shadesGreyscale;
}, "~N");
c$.flushShades = Clazz.defineMethod (c$, "flushShades", 
function () {
for (var i = org.jmol.util.Colix.colixMax; --i >= 0; ) org.jmol.util.Colix.ashades[i] = null;

($t$ = org.jmol.util.Shader.sphereShadingCalculated = false, org.jmol.util.Shader.prototype.sphereShadingCalculated = org.jmol.util.Shader.sphereShadingCalculated, $t$);
});
c$.getColixO = Clazz.defineMethod (c$, "getColixO", 
function (obj) {
if (obj == null) return 0;
if (Clazz.instanceOf (obj, org.jmol.constant.EnumPalette)) return ((obj) === org.jmol.constant.EnumPalette.NONE ? 0 : 2);
if (Clazz.instanceOf (obj, Integer)) return org.jmol.util.Colix.getColix ((obj).intValue ());
if (Clazz.instanceOf (obj, String)) return org.jmol.util.Colix.getColixS (obj);
if (Clazz.instanceOf (obj, Byte)) return ((obj).byteValue () == 0 ? 0 : 2);
if (org.jmol.util.Logger.debugging) {
org.jmol.util.Logger.debug ("?? getColix(" + obj + ")");
}return 22;
}, "~O");
c$.applyColorTranslucencyLevel = Clazz.defineMethod (c$, "applyColorTranslucencyLevel", 
function (colix, translucentLevel) {
if (translucentLevel == 0) return (colix & -30721);
if (translucentLevel < 0) return (colix & -30721 | 30720);
if (Float.isNaN (translucentLevel) || translucentLevel >= 255 || translucentLevel == 1.0) return ((colix & -30721) | 16384);
var iLevel = Clazz.doubleToInt (Math.floor (translucentLevel < 1 ? translucentLevel * 256 : translucentLevel <= 9 ? (Clazz.doubleToInt (Math.floor (translucentLevel - 1))) << 5 : translucentLevel < 15 ? 256 : translucentLevel));
iLevel = (iLevel >> 5) % 16;
return (colix & -30721 | (iLevel << 11));
}, "~N,~N");
c$.isColixLastAvailable = Clazz.defineMethod (c$, "isColixLastAvailable", 
function (colix) {
return (colix > 0 && (colix & 2047) == 2047);
}, "~N");
c$.getArgb = Clazz.defineMethod (c$, "getArgb", 
function (colix) {
return org.jmol.util.Colix.argbs[colix & -30721];
}, "~N");
c$.isColixColorInherited = Clazz.defineMethod (c$, "isColixColorInherited", 
function (colix) {
switch (colix) {
case 0:
case 1:
return true;
default:
return (colix & -30721) == 1;
}
}, "~N");
c$.getColixInherited = Clazz.defineMethod (c$, "getColixInherited", 
function (myColix, parentColix) {
switch (myColix) {
case 0:
return parentColix;
case 1:
return (parentColix & -30721);
default:
return ((myColix & -30721) == 1 ? (parentColix & -30721 | myColix & 30720) : myColix);
}
}, "~N,~N");
c$.isColixTranslucent = Clazz.defineMethod (c$, "isColixTranslucent", 
function (colix) {
return ((colix & 30720) != 0);
}, "~N");
c$.getChangeableColixIndex = Clazz.defineMethod (c$, "getChangeableColixIndex", 
function (colix) {
return (colix >= 0 ? -1 : (colix & 2047));
}, "~N");
c$.getColixTranslucent3 = Clazz.defineMethod (c$, "getColixTranslucent3", 
function (colix, isTranslucent, translucentLevel) {
if (colix == 0) colix = 1;
colix &= -30721;
return (isTranslucent ? org.jmol.util.Colix.applyColorTranslucencyLevel (colix, translucentLevel) : colix);
}, "~N,~B,~N");
c$.copyColixTranslucency = Clazz.defineMethod (c$, "copyColixTranslucency", 
function (colixFrom, colixTo) {
return org.jmol.util.Colix.getColixTranslucent3 (colixTo, org.jmol.util.Colix.isColixTranslucent (colixFrom), org.jmol.util.Colix.getColixTranslucencyLevel (colixFrom));
}, "~N,~N");
c$.getColixTranslucencyFractional = Clazz.defineMethod (c$, "getColixTranslucencyFractional", 
function (colix) {
var translevel = org.jmol.util.Colix.getColixTranslucencyLevel (colix);
return (translevel == -1 ? 0.5 : translevel == 0 ? 0 : translevel == 255 ? 1 : translevel / 256);
}, "~N");
c$.getColixTranslucencyLevel = Clazz.defineMethod (c$, "getColixTranslucencyLevel", 
function (colix) {
var logAlpha = (colix >> 11) & 0xF;
switch (logAlpha) {
case 0:
return 0;
case 1:
case 2:
case 3:
case 4:
case 5:
case 6:
case 7:
return logAlpha << 5;
case 15:
return -1;
default:
return 255;
}
}, "~N");
c$.getColixS = Clazz.defineMethod (c$, "getColixS", 
function (colorName) {
var argb = org.jmol.util.ColorUtil.getArgbFromString (colorName);
if (argb != 0) return org.jmol.util.Colix.getColix (argb);
if ("none".equalsIgnoreCase (colorName)) return 0;
if ("opaque".equalsIgnoreCase (colorName)) return 1;
return 2;
}, "~S");
c$.getColixArray = Clazz.defineMethod (c$, "getColixArray", 
function (colorNames) {
if (colorNames == null || colorNames.length == 0) return null;
var colors = org.jmol.util.Parser.getTokens (colorNames);
var colixes =  Clazz.newShortArray (colors.length, 0);
for (var j = 0; j < colors.length; j++) {
colixes[j] = org.jmol.util.Colix.getColix (org.jmol.util.ColorUtil.getArgbFromString (colors[j]));
if (colixes[j] == 0) return null;
}
return colixes;
}, "~S");
c$.getHexCode = Clazz.defineMethod (c$, "getHexCode", 
function (colix) {
return org.jmol.util.Escape.escapeColor (org.jmol.util.Colix.getArgb (colix));
}, "~N");
c$.getHexCodes = Clazz.defineMethod (c$, "getHexCodes", 
function (colixes) {
if (colixes == null) return null;
var s =  new org.jmol.util.StringXBuilder ();
for (var i = 0; i < colixes.length; i++) s.append (i == 0 ? "" : " ").append (org.jmol.util.Colix.getHexCode (colixes[i]));

return s.toString ();
}, "~A");
c$.getColixTranslucent = Clazz.defineMethod (c$, "getColixTranslucent", 
function (argb) {
var a = (argb >> 24) & 0xFF;
if (a == 0xFF) return org.jmol.util.Colix.getColix (argb);
return org.jmol.util.Colix.getColixTranslucent3 (org.jmol.util.Colix.getColix (argb), true, a / 255);
}, "~N");
Clazz.defineStatics (c$,
"INHERIT_ALL", 0,
"INHERIT_COLOR", 1,
"USE_PALETTE", 2,
"RAW_RGB", 3,
"SPECIAL_COLIX_MAX", 4,
"colixMax", 4,
"argbs",  Clazz.newIntArray (128, 0),
"argbsGreyscale", null);
c$.ashades = c$.prototype.ashades = org.jmol.util.ArrayUtil.newInt2 (128);
Clazz.defineStatics (c$,
"ashadesGreyscale", null);
c$.colixHash = c$.prototype.colixHash =  new org.jmol.util.Int2IntHash (256);
Clazz.defineStatics (c$,
"RAW_RGB_INT", 3,
"UNMASK_CHANGEABLE_TRANSLUCENT", 0x07FF,
"CHANGEABLE_MASK", 0x8000,
"LAST_AVAILABLE_COLIX", 2047,
"TRANSLUCENT_SHIFT", 11,
"ALPHA_SHIFT", 13,
"TRANSLUCENT_MASK", 30720,
"TRANSLUCENT_SCREENED", 30720,
"TRANSPARENT", 16384,
"TRANSLUCENT_50", 8192,
"OPAQUE_MASK", -30721,
"BLACK", 4,
"ORANGE", 5,
"PINK", 6,
"BLUE", 7,
"WHITE", 8,
"CYAN", 9,
"RED", 10,
"GREEN", 11,
"GRAY", 12,
"SILVER", 13,
"LIME", 14,
"MAROON", 15,
"NAVY", 16,
"OLIVE", 17,
"PURPLE", 18,
"TEAL", 19,
"MAGENTA", 20,
"YELLOW", 21,
"HOTPINK", 22,
"GOLD", 23,
"predefinedArgbs", [0xFF000000, 0xFFFFA500, 0xFFFFC0CB, 0xFF0000FF, 0xFFFFFFFF, 0xFF00FFFF, 0xFFFF0000, 0xFF008000, 0xFF808080, 0xFFC0C0C0, 0xFF00FF00, 0xFF800000, 0xFF000080, 0xFF808000, 0xFF800080, 0xFF008080, 0xFFFF00FF, 0xFFFFFF00, 0xFFFF69B4, 0xFFFFD700]);
{
for (var i = 0; i < org.jmol.util.Colix.predefinedArgbs.length; ++i) org.jmol.util.Colix.getColix (org.jmol.util.Colix.predefinedArgbs[i]);

}});
// 
//// org\jmol\util\Eigen.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Eigen", ["java.lang.Float", "java.util.Arrays", "org.jmol.util.Escape", "$.Logger", "$.Matrix3f", "$.Quadric", "$.Vector3f"], function () {
c$ = Clazz.decorateAsClass (function () {
this.n = 0;
this.d = null;
this.e = null;
this.V = null;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Eigen");
Clazz.makeConstructor (c$, 
function (n) {
this.n = n;
this.V =  Clazz.newDoubleArray (n, n, 0);
this.d =  Clazz.newDoubleArray (n, 0);
this.e =  Clazz.newDoubleArray (n, 0);
}, "~N");
c$.newM = Clazz.defineMethod (c$, "newM", 
function (m) {
var e =  new org.jmol.util.Eigen (m.length);
e.calc (m);
return e;
}, "~A");
c$.getUnitVectors = Clazz.defineMethod (c$, "getUnitVectors", 
function (m, unitVectors, lengths) {
org.jmol.util.Eigen.newM (m).set (unitVectors, lengths);
org.jmol.util.Eigen.sort (unitVectors, lengths);
}, "~A,~A,~A");
Clazz.defineMethod (c$, "set", 
($fz = function (unitVectors, lengths) {
var eigenVectors = this.getEigenvectorsFloatTransposed ();
var eigenValues = this.getRealEigenvalues ();
for (var i = 0; i < this.n; i++) {
if (unitVectors[i] == null) unitVectors[i] =  new org.jmol.util.Vector3f ();
unitVectors[i].setA (eigenVectors[i]);
lengths[i] = Math.sqrt (Math.abs (eigenValues[i]));
}
}, $fz.isPrivate = true, $fz), "~A,~A");
Clazz.defineMethod (c$, "calc", 
function (A) {
for (var i = 0; i < this.n; i++) {
for (var j = 0; j < this.n; j++) {
this.V[i][j] = A[i][j];
}
}
this.tred2 ();
this.tql2 ();
}, "~A");
Clazz.defineMethod (c$, "getRealEigenvalues", 
function () {
return this.d;
});
Clazz.defineMethod (c$, "getImagEigenvalues", 
function () {
return this.e;
});
Clazz.defineMethod (c$, "getEigenvalues", 
function () {
return this.d;
});
Clazz.defineMethod (c$, "getEigenvectorsFloatTransposed", 
function () {
var f =  Clazz.newFloatArray (this.n, this.n, 0);
for (var i = this.n; --i >= 0; ) for (var j = this.n; --j >= 0; ) f[j][i] = this.V[i][j];


return f;
});
Clazz.defineMethod (c$, "getEigenVectors3", 
function () {
var v =  new Array (3);
for (var i = 0; i < 3; i++) {
v[i] = org.jmol.util.Vector3f.new3 (this.V[0][i], this.V[1][i], this.V[2][i]);
}
return v;
});
Clazz.defineMethod (c$, "tred2", 
($fz = function () {
for (var j = 0; j < this.n; j++) {
this.d[j] = this.V[this.n - 1][j];
}
for (var i = this.n - 1; i > 0; i--) {
var scale = 0.0;
var h = 0.0;
for (var k = 0; k < i; k++) {
scale = scale + Math.abs (this.d[k]);
}
if (scale == 0.0) {
this.e[i] = this.d[i - 1];
for (var j = 0; j < i; j++) {
this.d[j] = this.V[i - 1][j];
this.V[i][j] = 0.0;
this.V[j][i] = 0.0;
}
} else {
for (var k = 0; k < i; k++) {
this.d[k] /= scale;
h += this.d[k] * this.d[k];
}
var f = this.d[i - 1];
var g = Math.sqrt (h);
if (f > 0) {
g = -g;
}this.e[i] = scale * g;
h = h - f * g;
this.d[i - 1] = f - g;
for (var j = 0; j < i; j++) {
this.e[j] = 0.0;
}
for (var j = 0; j < i; j++) {
f = this.d[j];
this.V[j][i] = f;
g = this.e[j] + this.V[j][j] * f;
for (var k = j + 1; k <= i - 1; k++) {
g += this.V[k][j] * this.d[k];
this.e[k] += this.V[k][j] * f;
}
this.e[j] = g;
}
f = 0.0;
for (var j = 0; j < i; j++) {
this.e[j] /= h;
f += this.e[j] * this.d[j];
}
var hh = f / (h + h);
for (var j = 0; j < i; j++) {
this.e[j] -= hh * this.d[j];
}
for (var j = 0; j < i; j++) {
f = this.d[j];
g = this.e[j];
for (var k = j; k <= i - 1; k++) {
this.V[k][j] -= (f * this.e[k] + g * this.d[k]);
}
this.d[j] = this.V[i - 1][j];
this.V[i][j] = 0.0;
}
}this.d[i] = h;
}
for (var i = 0; i < this.n - 1; i++) {
this.V[this.n - 1][i] = this.V[i][i];
this.V[i][i] = 1.0;
var h = this.d[i + 1];
if (h != 0.0) {
for (var k = 0; k <= i; k++) {
this.d[k] = this.V[k][i + 1] / h;
}
for (var j = 0; j <= i; j++) {
var g = 0.0;
for (var k = 0; k <= i; k++) {
g += this.V[k][i + 1] * this.V[k][j];
}
for (var k = 0; k <= i; k++) {
this.V[k][j] -= g * this.d[k];
}
}
}for (var k = 0; k <= i; k++) {
this.V[k][i + 1] = 0.0;
}
}
for (var j = 0; j < this.n; j++) {
this.d[j] = this.V[this.n - 1][j];
this.V[this.n - 1][j] = 0.0;
}
this.V[this.n - 1][this.n - 1] = 1.0;
this.e[0] = 0.0;
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "tql2", 
($fz = function () {
for (var i = 1; i < this.n; i++) {
this.e[i - 1] = this.e[i];
}
this.e[this.n - 1] = 0.0;
var f = 0.0;
var tst1 = 0.0;
var eps = Math.pow (2.0, -52.0);
for (var l = 0; l < this.n; l++) {
tst1 = Math.max (tst1, Math.abs (this.d[l]) + Math.abs (this.e[l]));
var m = l;
while (m < this.n) {
if (Math.abs (this.e[m]) <= eps * tst1) {
break;
}m++;
}
if (m > l) {
var iter = 0;
do {
iter = iter + 1;
var g = this.d[l];
var p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
var r = org.jmol.util.Eigen.hypot (p, 1.0);
if (p < 0) {
r = -r;
}this.d[l] = this.e[l] / (p + r);
this.d[l + 1] = this.e[l] * (p + r);
var dl1 = this.d[l + 1];
var h = g - this.d[l];
for (var i = l + 2; i < this.n; i++) {
this.d[i] -= h;
}
f = f + h;
p = this.d[m];
var c = 1.0;
var c2 = c;
var c3 = c;
var el1 = this.e[l + 1];
var s = 0.0;
var s2 = 0.0;
for (var i = m - 1; i >= l; i--) {
c3 = c2;
c2 = c;
s2 = s;
g = c * this.e[i];
h = c * p;
r = org.jmol.util.Eigen.hypot (p, this.e[i]);
this.e[i + 1] = s * r;
s = this.e[i] / r;
c = p / r;
p = c * this.d[i] - s * g;
this.d[i + 1] = h + s * (c * g + s * this.d[i]);
for (var k = 0; k < this.n; k++) {
h = this.V[k][i + 1];
this.V[k][i + 1] = s * this.V[k][i] + c * h;
this.V[k][i] = c * this.V[k][i] - s * h;
}
}
p = -s * s2 * c3 * el1 * this.e[l] / dl1;
this.e[l] = s * p;
this.d[l] = c * p;
} while (Math.abs (this.e[l]) > eps * tst1);
}this.d[l] = this.d[l] + f;
this.e[l] = 0.0;
}
for (var i = 0; i < this.n - 1; i++) {
var k = i;
var p = this.d[i];
for (var j = i + 1; j < this.n; j++) {
if (this.d[j] < p) {
k = j;
p = this.d[j];
}}
if (k != i) {
this.d[k] = this.d[i];
this.d[i] = p;
for (var j = 0; j < this.n; j++) {
p = this.V[j][i];
this.V[j][i] = this.V[j][k];
this.V[j][k] = p;
}
}}
}, $fz.isPrivate = true, $fz));
c$.hypot = Clazz.defineMethod (c$, "hypot", 
($fz = function (a, b) {
var r;
if (Math.abs (a) > Math.abs (b)) {
r = b / a;
r = Math.abs (a) * Math.sqrt (1 + r * r);
} else if (b != 0) {
r = a / b;
r = Math.abs (b) * Math.sqrt (1 + r * r);
} else {
r = 0.0;
}return r;
}, $fz.isPrivate = true, $fz), "~N,~N");
c$.getEllipsoidDD = Clazz.defineMethod (c$, "getEllipsoidDD", 
function (a) {
var eigen =  new org.jmol.util.Eigen (3);
eigen.calc (a);
var m =  new org.jmol.util.Matrix3f ();
var mm =  Clazz.newFloatArray (9, 0);
for (var i = 0, p = 0; i < 3; i++) for (var j = 0; j < 3; j++) mm[p++] = a[i][j];


m.setA (mm);
var evec = eigen.getEigenVectors3 ();
var n =  new org.jmol.util.Vector3f ();
var cross =  new org.jmol.util.Vector3f ();
for (var i = 0; i < 3; i++) {
n.setT (evec[i]);
m.transform (n);
cross.cross (n, evec[i]);
org.jmol.util.Logger.info ("v[i], n, n x v[i]" + evec[i] + " " + n + " " + cross);
n.setT (evec[i]);
n.normalize ();
cross.cross (evec[i], evec[(i + 1) % 3]);
org.jmol.util.Logger.info ("draw id eigv" + i + " " + org.jmol.util.Escape.escapePt (evec[i]) + " color " + (i == 0 ? "red" : i == 1 ? "green" : "blue") + " # " + n + " " + cross);
}
org.jmol.util.Logger.info ("eigVl (" + eigen.d[0] + " + " + eigen.e[0] + "I) (" + eigen.d[1] + " + " + eigen.e[1] + "I) (" + eigen.d[2] + " + " + eigen.e[2] + "I)");
var unitVectors =  new Array (3);
var lengths =  Clazz.newFloatArray (3, 0);
eigen.set (unitVectors, lengths);
org.jmol.util.Eigen.sort (unitVectors, lengths);
return  new org.jmol.util.Quadric (unitVectors, lengths, false);
}, "~A");
c$.getEllipsoid = Clazz.defineMethod (c$, "getEllipsoid", 
function (vectors, lengths, isThermal) {
var unitVectors =  new Array (vectors.length);
for (var i = vectors.length; --i >= 0; ) unitVectors[i] = org.jmol.util.Vector3f.newV (vectors[i]);

org.jmol.util.Eigen.sort (unitVectors, lengths);
return  new org.jmol.util.Quadric (unitVectors, lengths, isThermal);
}, "~A,~A,~B");
c$.sort = Clazz.defineMethod (c$, "sort", 
($fz = function (vectors, lengths) {
var o = [[vectors[0], Float.$valueOf (Math.abs (lengths[0]))], [vectors[1], Float.$valueOf (Math.abs (lengths[1]))], [vectors[2], Float.$valueOf (Math.abs (lengths[2]))]];
java.util.Arrays.sort (o,  new org.jmol.util.Eigen.EigenSort ());
for (var i = 0; i < 3; i++) {
vectors[i] = org.jmol.util.Vector3f.newV (o[i][0]);
vectors[i].normalize ();
lengths[i] = (o[i][1]).floatValue ();
}
}, $fz.isPrivate = true, $fz), "~A,~A");
Clazz.pu$h ();
c$ = Clazz.declareType (org.jmol.util.Eigen, "EigenSort", null, java.util.Comparator);
Clazz.overrideMethod (c$, "compare", 
function (a, b) {
var c = (a[1]).floatValue ();
var d = (b[1]).floatValue ();
return (c < d ? -1 : c > d ? 1 : 0);
}, "~A,~A");
c$ = Clazz.p0p ();
});
// 
//// org\jmol\util\Quaternion.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.Point4f"], "org.jmol.util.Quaternion", ["java.lang.Float", "org.jmol.util.AxisAngle4f", "$.Escape", "$.Logger", "$.Matrix3f", "$.Point3f", "$.TextFormat", "$.Vector3f"], function () {
c$ = Clazz.decorateAsClass (function () {
this.q0 = 0;
this.q1 = 0;
this.q2 = 0;
this.q3 = 0;
this.mat = null;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Quaternion");
Clazz.makeConstructor (c$, 
function () {
this.q0 = 1;
});
c$.newQ = Clazz.defineMethod (c$, "newQ", 
function (q) {
var q1 =  new org.jmol.util.Quaternion ();
q1.set (q);
return q1;
}, "org.jmol.util.Quaternion");
c$.newVA = Clazz.defineMethod (c$, "newVA", 
function (pt, theta) {
var q =  new org.jmol.util.Quaternion ();
q.setTA (pt, theta);
return q;
}, "org.jmol.util.Tuple3f,~N");
c$.newM = Clazz.defineMethod (c$, "newM", 
function (mat) {
var q =  new org.jmol.util.Quaternion ();
q.setM (mat);
return q;
}, "org.jmol.util.Matrix3f");
c$.newAA = Clazz.defineMethod (c$, "newAA", 
function (a) {
var q =  new org.jmol.util.Quaternion ();
q.setAA (a);
return q;
}, "org.jmol.util.AxisAngle4f");
c$.newP4 = Clazz.defineMethod (c$, "newP4", 
function (pt) {
var q =  new org.jmol.util.Quaternion ();
q.setP4 (pt);
return q;
}, "org.jmol.util.Point4f");
c$.new4 = Clazz.defineMethod (c$, "new4", 
function (q0, q1, q2, q3) {
var q =  new org.jmol.util.Quaternion ();
if (q0 < -1) {
q.q0 = -1;
return q;
}if (q0 > 1) {
q.q0 = 1;
return q;
}q.q0 = q0;
q.q1 = q1;
q.q2 = q2;
q.q3 = q3;
return q;
}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "set", 
function (q) {
this.q0 = q.q0;
this.q1 = q.q1;
this.q2 = q.q2;
this.q3 = q.q3;
}, "org.jmol.util.Quaternion");
Clazz.defineMethod (c$, "setP4", 
($fz = function (pt) {
var factor = (pt == null ? 0 : pt.distance (org.jmol.util.Quaternion.qZero));
if (factor == 0) {
this.q0 = 1;
return;
}this.q0 = pt.w / factor;
this.q1 = pt.x / factor;
this.q2 = pt.y / factor;
this.q3 = pt.z / factor;
}, $fz.isPrivate = true, $fz), "org.jmol.util.Point4f");
Clazz.defineMethod (c$, "setTA", 
function (pt, theta) {
if (pt.x == 0 && pt.y == 0 && pt.z == 0) {
this.q0 = 1;
return;
}var fact = (Math.sin (theta / 2 * 3.141592653589793 / 180) / Math.sqrt (pt.x * pt.x + pt.y * pt.y + pt.z * pt.z));
this.q0 = (Math.cos (theta / 2 * 3.141592653589793 / 180));
this.q1 = (pt.x * fact);
this.q2 = (pt.y * fact);
this.q3 = (pt.z * fact);
}, "org.jmol.util.Tuple3f,~N");
Clazz.defineMethod (c$, "setAA", 
function (a) {
var aa = org.jmol.util.AxisAngle4f.newAA (a);
if (aa.angle == 0) aa.y = 1;
var m3 =  new org.jmol.util.Matrix3f ();
m3.setAA (aa);
this.setM (m3);
}, "org.jmol.util.AxisAngle4f");
Clazz.defineMethod (c$, "setM", 
function (mat) {
this.mat = mat;
var trace = mat.m00 + mat.m11 + mat.m22;
var temp;
var w;
var x;
var y;
var z;
if (trace >= 0.5) {
w = Math.sqrt (1.0 + trace);
x = (mat.m21 - mat.m12) / w;
y = (mat.m02 - mat.m20) / w;
z = (mat.m10 - mat.m01) / w;
} else if ((temp = mat.m00 + mat.m00 - trace) >= 0.5) {
x = Math.sqrt (1.0 + temp);
w = (mat.m21 - mat.m12) / x;
y = (mat.m10 + mat.m01) / x;
z = (mat.m20 + mat.m02) / x;
} else if ((temp = mat.m11 + mat.m11 - trace) >= 0.5 || mat.m11 > mat.m22) {
y = Math.sqrt (1.0 + temp);
w = (mat.m02 - mat.m20) / y;
x = (mat.m10 + mat.m01) / y;
z = (mat.m21 + mat.m12) / y;
} else {
z = Math.sqrt (1.0 + mat.m22 + mat.m22 - trace);
w = (mat.m10 - mat.m01) / z;
x = (mat.m20 + mat.m02) / z;
y = (mat.m21 + mat.m12) / z;
}this.q0 = (w * 0.5);
this.q1 = (x * 0.5);
this.q2 = (y * 0.5);
this.q3 = (z * 0.5);
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "setRef", 
function (qref) {
if (qref == null) {
this.mul (this.getFixFactor ());
return;
}if (this.dot (qref) >= 0) return;
this.q0 *= -1;
this.q1 *= -1;
this.q2 *= -1;
this.q3 *= -1;
}, "org.jmol.util.Quaternion");
c$.getQuaternionFrame = Clazz.defineMethod (c$, "getQuaternionFrame", 
function (center, x, xy) {
var vA = org.jmol.util.Vector3f.newV (x);
vA.sub (center);
var vB = org.jmol.util.Vector3f.newV (xy);
vB.sub (center);
return org.jmol.util.Quaternion.getQuaternionFrameV (vA, vB, null, false);
}, "org.jmol.util.Point3f,org.jmol.util.Tuple3f,org.jmol.util.Tuple3f");
c$.getQuaternionFrameV = Clazz.defineMethod (c$, "getQuaternionFrameV", 
function (vA, vB, vC, yBased) {
if (vC == null) {
vC =  new org.jmol.util.Vector3f ();
vC.cross (vA, vB);
if (yBased) vA.cross (vB, vC);
}var vBprime =  new org.jmol.util.Vector3f ();
vBprime.cross (vC, vA);
vA.normalize ();
vBprime.normalize ();
vC.normalize ();
var mat =  new org.jmol.util.Matrix3f ();
mat.setColumnV (0, vA);
mat.setColumnV (1, vBprime);
mat.setColumnV (2, vC);
var q = org.jmol.util.Quaternion.newM (mat);
return q;
}, "org.jmol.util.Vector3f,org.jmol.util.Vector3f,org.jmol.util.Vector3f,~B");
Clazz.defineMethod (c$, "getMatrix", 
function () {
if (this.mat == null) this.setMatrix ();
return this.mat;
});
Clazz.defineMethod (c$, "setMatrix", 
($fz = function () {
this.mat =  new org.jmol.util.Matrix3f ();
this.mat.m00 = this.q0 * this.q0 + this.q1 * this.q1 - this.q2 * this.q2 - this.q3 * this.q3;
this.mat.m01 = 2 * this.q1 * this.q2 - 2 * this.q0 * this.q3;
this.mat.m02 = 2 * this.q1 * this.q3 + 2 * this.q0 * this.q2;
this.mat.m10 = 2 * this.q1 * this.q2 + 2 * this.q0 * this.q3;
this.mat.m11 = this.q0 * this.q0 - this.q1 * this.q1 + this.q2 * this.q2 - this.q3 * this.q3;
this.mat.m12 = 2 * this.q2 * this.q3 - 2 * this.q0 * this.q1;
this.mat.m20 = 2 * this.q1 * this.q3 - 2 * this.q0 * this.q2;
this.mat.m21 = 2 * this.q2 * this.q3 + 2 * this.q0 * this.q1;
this.mat.m22 = this.q0 * this.q0 - this.q1 * this.q1 - this.q2 * this.q2 + this.q3 * this.q3;
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "add", 
function (x) {
return org.jmol.util.Quaternion.newVA (this.getNormal (), this.getTheta () + x);
}, "~N");
Clazz.defineMethod (c$, "mul", 
function (x) {
return (x == 1 ? org.jmol.util.Quaternion.new4 (this.q0, this.q1, this.q2, this.q3) : org.jmol.util.Quaternion.newVA (this.getNormal (), this.getTheta () * x));
}, "~N");
Clazz.defineMethod (c$, "mulQ", 
function (p) {
return org.jmol.util.Quaternion.new4 (this.q0 * p.q0 - this.q1 * p.q1 - this.q2 * p.q2 - this.q3 * p.q3, this.q0 * p.q1 + this.q1 * p.q0 + this.q2 * p.q3 - this.q3 * p.q2, this.q0 * p.q2 + this.q2 * p.q0 + this.q3 * p.q1 - this.q1 * p.q3, this.q0 * p.q3 + this.q3 * p.q0 + this.q1 * p.q2 - this.q2 * p.q1);
}, "org.jmol.util.Quaternion");
Clazz.defineMethod (c$, "div", 
function (p) {
return this.mulQ (p.inv ());
}, "org.jmol.util.Quaternion");
Clazz.defineMethod (c$, "divLeft", 
function (p) {
return this.inv ().mulQ (p);
}, "org.jmol.util.Quaternion");
Clazz.defineMethod (c$, "dot", 
function (q) {
return this.q0 * q.q0 + this.q1 * q.q1 + this.q2 * q.q2 + this.q3 * q.q3;
}, "org.jmol.util.Quaternion");
Clazz.defineMethod (c$, "inv", 
function () {
return org.jmol.util.Quaternion.new4 (this.q0, -this.q1, -this.q2, -this.q3);
});
Clazz.defineMethod (c$, "negate", 
function () {
return org.jmol.util.Quaternion.new4 (-this.q0, -this.q1, -this.q2, -this.q3);
});
Clazz.defineMethod (c$, "getFixFactor", 
($fz = function () {
return (this.q0 < 0 || this.q0 == 0 && (this.q1 < 0 || this.q1 == 0 && (this.q2 < 0 || this.q2 == 0 && this.q3 < 0)) ? -1 : 1);
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "getVector", 
function (i) {
return this.getVectorS (i, 1);
}, "~N");
Clazz.defineMethod (c$, "getVectorS", 
($fz = function (i, scale) {
if (i == -1) {
scale *= this.getFixFactor ();
return org.jmol.util.Vector3f.new3 (this.q1 * scale, this.q2 * scale, this.q3 * scale);
}if (this.mat == null) this.setMatrix ();
var v =  new org.jmol.util.Vector3f ();
this.mat.getColumnV (i, v);
if (scale != 1) v.scale (scale);
return v;
}, $fz.isPrivate = true, $fz), "~N,~N");
Clazz.defineMethod (c$, "getNormal", 
function () {
var v = org.jmol.util.Quaternion.getRawNormal (this);
v.scale (this.getFixFactor ());
return v;
});
c$.getRawNormal = Clazz.defineMethod (c$, "getRawNormal", 
($fz = function (q) {
var v = org.jmol.util.Vector3f.new3 (q.q1, q.q2, q.q3);
if (v.length () == 0) return org.jmol.util.Vector3f.new3 (0, 0, 1);
v.normalize ();
return v;
}, $fz.isPrivate = true, $fz), "org.jmol.util.Quaternion");
Clazz.defineMethod (c$, "getTheta", 
function () {
return (Math.acos (Math.abs (this.q0)) * 2 * 180 / 3.141592653589793);
});
Clazz.defineMethod (c$, "getThetaRadians", 
function () {
return (Math.acos (Math.abs (this.q0)) * 2);
});
Clazz.defineMethod (c$, "getNormalDirected", 
function (v0) {
var v = this.getNormal ();
if (v.x * v0.x + v.y * v0.y + v.z * v0.z < 0) {
v.scale (-1);
}return v;
}, "org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "get3dProjection", 
function (v3d) {
v3d.set (this.q1, this.q2, this.q3);
return v3d;
}, "org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "getThetaDirected", 
function (axisAngle) {
var theta = this.getTheta ();
var v = this.getNormal ();
if (axisAngle.x * this.q1 + axisAngle.y * this.q2 + axisAngle.z * this.q3 < 0) {
v.scale (-1);
theta = -theta;
}axisAngle.set (v.x, v.y, v.z, theta);
return axisAngle;
}, "org.jmol.util.Point4f");
Clazz.defineMethod (c$, "getThetaDirectedV", 
function (vector) {
var theta = this.getTheta ();
var v = this.getNormal ();
if (vector.x * this.q1 + vector.y * this.q2 + vector.z * this.q3 < 0) {
v.scale (-1);
theta = -theta;
}return theta;
}, "org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "toPoint4f", 
function () {
return org.jmol.util.Point4f.new4 (this.q1, this.q2, this.q3, this.q0);
});
Clazz.defineMethod (c$, "toAxisAngle4f", 
function () {
var theta = 2 * Math.acos (Math.abs (this.q0));
var sinTheta2 = Math.sin (theta / 2);
var v = this.getNormal ();
if (sinTheta2 < 0) {
v.scale (-1);
theta = 3.141592653589793 - theta;
}return org.jmol.util.AxisAngle4f.newVA (v, theta);
});
Clazz.defineMethod (c$, "transformPt", 
function (pt) {
if (this.mat == null) this.setMatrix ();
var ptNew = org.jmol.util.Point3f.newP (pt);
this.mat.transform (ptNew);
return ptNew;
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "transformP2", 
function (pt, ptNew) {
if (this.mat == null) this.setMatrix ();
this.mat.transform2 (pt, ptNew);
}, "org.jmol.util.Tuple3f,org.jmol.util.Tuple3f");
Clazz.defineMethod (c$, "transform", 
function (v) {
if (this.mat == null) this.setMatrix ();
var vNew = org.jmol.util.Vector3f.newV (v);
this.mat.transform (vNew);
return vNew;
}, "org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "leftDifference", 
function (q2) {
var q2adjusted = (this.dot (q2) < 0 ? q2.negate () : q2);
return this.inv ().mulQ (q2adjusted);
}, "org.jmol.util.Quaternion");
Clazz.defineMethod (c$, "rightDifference", 
function (q2) {
var q2adjusted = (this.dot (q2) < 0 ? q2.negate () : q2);
return this.mulQ (q2adjusted.inv ());
}, "org.jmol.util.Quaternion");
Clazz.defineMethod (c$, "getInfo", 
function () {
var axis = this.toAxisAngle4f ();
return org.jmol.util.TextFormat.sprintf ("%10.6f%10.6f%10.6f%10.6f  %6.2f  %10.5f %10.5f %10.5f", "F", [[this.q0, this.q1, this.q2, this.q3, (axis.angle * 180 / 3.141592653589793), axis.x, axis.y, axis.z]]);
});
Clazz.defineMethod (c$, "draw", 
function (prefix, id, ptCenter, scale) {
var strV = " VECTOR " + org.jmol.util.Escape.escapePt (ptCenter) + " ";
if (scale == 0) scale = 1;
return "draw " + prefix + "x" + id + strV + org.jmol.util.Escape.escapePt (this.getVectorS (0, scale)) + " color red\n" + "draw " + prefix + "y" + id + strV + org.jmol.util.Escape.escapePt (this.getVectorS (1, scale)) + " color green\n" + "draw " + prefix + "z" + id + strV + org.jmol.util.Escape.escapePt (this.getVectorS (2, scale)) + " color blue\n";
}, "~S,~S,org.jmol.util.Point3f,~N");
Clazz.overrideMethod (c$, "toString", 
function () {
return "{" + this.q1 + " " + this.q2 + " " + this.q3 + " " + this.q0 + "}";
});
c$.div = Clazz.defineMethod (c$, "div", 
function (data1, data2, nMax, isRelative) {
var n;
if (data1 == null || data2 == null || (n = Math.min (data1.length, data2.length)) == 0) return null;
if (nMax > 0 && n > nMax) n = nMax;
var dqs =  new Array (n);
for (var i = 0; i < n; i++) {
if (data1[i] == null || data2[i] == null) return null;
dqs[i] = (isRelative ? data1[i].divLeft (data2[i]) : data1[i].div (data2[i]));
}
return dqs;
}, "~A,~A,~N,~B");
c$.sphereMean = Clazz.defineMethod (c$, "sphereMean", 
function (data, retStddev, criterion) {
if (data == null || data.length == 0) return  new org.jmol.util.Quaternion ();
if (retStddev == null) retStddev =  Clazz.newFloatArray (1, 0);
if (data.length == 1) {
retStddev[0] = 0;
return org.jmol.util.Quaternion.newQ (data[0]);
}var diff = 3.4028235E38;
var lastStddev = 3.4028235E38;
var qMean = org.jmol.util.Quaternion.simpleAverage (data);
var maxIter = 100;
var iter = 0;
while (diff > criterion && lastStddev != 0 && iter < maxIter) {
qMean = org.jmol.util.Quaternion.newMean (data, qMean);
retStddev[0] = org.jmol.util.Quaternion.stdDev (data, qMean);
diff = Math.abs (retStddev[0] - lastStddev);
lastStddev = retStddev[0];
org.jmol.util.Logger.info (++iter + " sphereMean " + qMean + " stddev=" + lastStddev + " diff=" + diff);
}
return qMean;
}, "~A,~A,~N");
c$.simpleAverage = Clazz.defineMethod (c$, "simpleAverage", 
($fz = function (ndata) {
var mean = org.jmol.util.Vector3f.new3 (0, 0, 1);
var v = ndata[0].getNormal ();
mean.add (v);
for (var i = ndata.length; --i >= 0; ) mean.add (ndata[i].getNormalDirected (mean));

mean.sub (v);
mean.normalize ();
var f = 0;
for (var i = ndata.length; --i >= 0; ) f += Math.abs (ndata[i].get3dProjection (v).dot (mean));

if (f != 0) mean.scale (f / ndata.length);
f = Math.sqrt (1 - mean.lengthSquared ());
if (Float.isNaN (f)) f = 0;
return org.jmol.util.Quaternion.newP4 (org.jmol.util.Point4f.new4 (mean.x, mean.y, mean.z, f));
}, $fz.isPrivate = true, $fz), "~A");
c$.newMean = Clazz.defineMethod (c$, "newMean", 
($fz = function (data, mean) {
var sum =  new org.jmol.util.Vector3f ();
var v;
var q;
var dq;
for (var i = data.length; --i >= 0; ) {
q = data[i];
dq = q.div (mean);
v = dq.getNormal ();
v.scale (dq.getTheta ());
sum.add (v);
}
sum.scale (1 / data.length);
var dqMean = org.jmol.util.Quaternion.newVA (sum, sum.length ());
return dqMean.mulQ (mean);
}, $fz.isPrivate = true, $fz), "~A,org.jmol.util.Quaternion");
c$.stdDev = Clazz.defineMethod (c$, "stdDev", 
($fz = function (data, mean) {
var sum = 0;
var sum2 = 0;
var n = data.length;
for (var i = n; --i >= 0; ) {
var dq = data[i].div (mean);
var theta = dq.getTheta ();
sum += theta;
sum2 += theta * theta;
}
sum2 = sum2 - sum * sum / n;
if (sum2 < 0) sum2 = 0;
return Math.sqrt (sum2 / (n - 1));
}, $fz.isPrivate = true, $fz), "~A,org.jmol.util.Quaternion");
c$.qZero = c$.prototype.qZero =  new org.jmol.util.Point4f ();
});
// 
//// org\jmol\constant\EnumPalette.js 
// 
Clazz.declarePackage ("org.jmol.constant");
Clazz.load (["java.lang.Enum"], "org.jmol.constant.EnumPalette", null, function () {
c$ = Clazz.decorateAsClass (function () {
this.$$name = null;
this.id = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.constant, "EnumPalette", Enum);
Clazz.makeConstructor (c$, 
($fz = function (name, id) {
this.$$name = name;
this.id = id;
}, $fz.isPrivate = true, $fz), "~S,~N");
c$.pidOf = Clazz.defineMethod (c$, "pidOf", 
function (value) {
return (Clazz.instanceOf (value, org.jmol.constant.EnumPalette) ? (value).id : Clazz.instanceOf (value, Byte) ? (value).byteValue () : org.jmol.constant.EnumPalette.UNKNOWN.id);
}, "~O");
c$.isPaletteVariable = Clazz.defineMethod (c$, "isPaletteVariable", 
function (pid) {
return ((pid & 64) != 0);
}, "~N");
c$.getPalette = Clazz.defineMethod (c$, "getPalette", 
function (paletteName) {
if (paletteName.indexOf ('_') < 0) for (var item, $item = 0, $$item = org.jmol.constant.EnumPalette.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (paletteName.equalsIgnoreCase (item.$$name)) return item;

return (paletteName.indexOf ("property_") == 0 ? org.jmol.constant.EnumPalette.PROPERTY : org.jmol.constant.EnumPalette.UNKNOWN);
}, "~S");
c$.getPaletteID = Clazz.defineMethod (c$, "getPaletteID", 
function (paletteName) {
if (paletteName.indexOf ('_') < 0) for (var item, $item = 0, $$item = org.jmol.constant.EnumPalette.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (paletteName.equalsIgnoreCase (item.$$name)) return item.id;

return (paletteName.indexOf ("property_") == 0 ? org.jmol.constant.EnumPalette.PROPERTY.id : org.jmol.constant.EnumPalette.UNKNOWN.id);
}, "~S");
c$.getPaletteName = Clazz.defineMethod (c$, "getPaletteName", 
function (pid) {
for (var item, $item = 0, $$item = org.jmol.constant.EnumPalette.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (item.id == pid) return item.$$name;

return null;
}, "~N");
c$.argbsCpkRasmol = [16716947, 33554431, 50315467, 62005794, 83951360, 113821896, 126849023, 149946368, 165324064, 184549631, 203590434, 226525328, 249210144, 268412160, 285198386, 285277952, 343965840, 377520272, 411074704, 427851920, 452961536, 480586282, 497363498, 514140714, 598026794, 796950672, 899686640, 956278016, 1339729184];
c$.argbsCpk = [0xFFFF1493, 0xFFFFFFFF, 0xFFD9FFFF, 0xFFCC80FF, 0xFFC2FF00, 0xFFFFB5B5, 0xFF909090, 0xFF3050F8, 0xFFFF0D0D, 0xFF90E050, 0xFFB3E3F5, 0xFFAB5CF2, 0xFF8AFF00, 0xFFBFA6A6, 0xFFF0C8A0, 0xFFFF8000, 0xFFFFFF30, 0xFF1FF01F, 0xFF80D1E3, 0xFF8F40D4, 0xFF3DFF00, 0xFFE6E6E6, 0xFFBFC2C7, 0xFFA6A6AB, 0xFF8A99C7, 0xFF9C7AC7, 0xFFE06633, 0xFFF090A0, 0xFF50D050, 0xFFC88033, 0xFF7D80B0, 0xFFC28F8F, 0xFF668F8F, 0xFFBD80E3, 0xFFFFA100, 0xFFA62929, 0xFF5CB8D1, 0xFF702EB0, 0xFF00FF00, 0xFF94FFFF, 0xFF94E0E0, 0xFF73C2C9, 0xFF54B5B5, 0xFF3B9E9E, 0xFF248F8F, 0xFF0A7D8C, 0xFF006985, 0xFFC0C0C0, 0xFFFFD98F, 0xFFA67573, 0xFF668080, 0xFF9E63B5, 0xFFD47A00, 0xFF940094, 0xFF429EB0, 0xFF57178F, 0xFF00C900, 0xFF70D4FF, 0xFFFFFFC7, 0xFFD9FFC7, 0xFFC7FFC7, 0xFFA3FFC7, 0xFF8FFFC7, 0xFF61FFC7, 0xFF45FFC7, 0xFF30FFC7, 0xFF1FFFC7, 0xFF00FF9C, 0xFF00E675, 0xFF00D452, 0xFF00BF38, 0xFF00AB24, 0xFF4DC2FF, 0xFF4DA6FF, 0xFF2194D6, 0xFF267DAB, 0xFF266696, 0xFF175487, 0xFFD0D0E0, 0xFFFFD123, 0xFFB8B8D0, 0xFFA6544D, 0xFF575961, 0xFF9E4FB5, 0xFFAB5C00, 0xFF754F45, 0xFF428296, 0xFF420066, 0xFF007D00, 0xFF70ABFA, 0xFF00BAFF, 0xFF00A1FF, 0xFF008FFF, 0xFF0080FF, 0xFF006BFF, 0xFF545CF2, 0xFF785CE3, 0xFF8A4FE3, 0xFFA136D4, 0xFFB31FD4, 0xFFB31FBA, 0xFFB30DA6, 0xFFBD0D87, 0xFFC70066, 0xFFCC0059, 0xFFD1004F, 0xFFD90045, 0xFFE00038, 0xFFE6002E, 0xFFEB0026];
Clazz.defineEnumConstant (c$, "UNKNOWN", 0, [null, 0xFF]);
Clazz.defineEnumConstant (c$, "NONE", 1, ["none", 0]);
Clazz.defineEnumConstant (c$, "CPK", 2, ["cpk", 1]);
Clazz.defineEnumConstant (c$, "PARTIAL_CHARGE", 3, ["partialcharge", 2]);
Clazz.defineEnumConstant (c$, "FORMAL_CHARGE", 4, ["formalcharge", 3]);
Clazz.defineEnumConstant (c$, "TEMP", 5, ["temperature", 68]);
Clazz.defineEnumConstant (c$, "FIXEDTEMP", 6, ["fixedtemperature", 5]);
Clazz.defineEnumConstant (c$, "SURFACE", 7, ["surfacedistance", 70]);
Clazz.defineEnumConstant (c$, "STRUCTURE", 8, ["structure", 7]);
Clazz.defineEnumConstant (c$, "AMINO", 9, ["amino", 8]);
Clazz.defineEnumConstant (c$, "SHAPELY", 10, ["shapely", 9]);
Clazz.defineEnumConstant (c$, "CHAIN", 11, ["chain", 10]);
Clazz.defineEnumConstant (c$, "GROUP", 12, ["group", 75]);
Clazz.defineEnumConstant (c$, "MONOMER", 13, ["monomer", 76]);
Clazz.defineEnumConstant (c$, "MOLECULE", 14, ["molecule", 77]);
Clazz.defineEnumConstant (c$, "ALTLOC", 15, ["altloc", 14]);
Clazz.defineEnumConstant (c$, "INSERTION", 16, ["insertion", 15]);
Clazz.defineEnumConstant (c$, "JMOL", 17, ["jmol", 16]);
Clazz.defineEnumConstant (c$, "RASMOL", 18, ["rasmol", 17]);
Clazz.defineEnumConstant (c$, "TYPE", 19, ["type", 18]);
Clazz.defineEnumConstant (c$, "ENERGY", 20, ["energy", 19]);
Clazz.defineEnumConstant (c$, "PROPERTY", 21, ["property", 84]);
Clazz.defineEnumConstant (c$, "VARIABLE", 22, ["variable", 85]);
Clazz.defineEnumConstant (c$, "STRAIGHTNESS", 23, ["straightness", 86]);
Clazz.defineEnumConstant (c$, "POLYMER", 24, ["polymer", 87]);
});
// 
//// org\jmol\util\ColorUtil.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["java.util.Hashtable"], "org.jmol.util.ColorUtil", ["org.jmol.util.Parser", "$.Point3f", "$.TextFormat"], function () {
c$ = Clazz.declareType (org.jmol.util, "ColorUtil");
c$.getArgbFromString = Clazz.defineMethod (c$, "getArgbFromString", 
function (strColor) {
var len = 0;
if (strColor == null || (len = strColor.length) == 0) return 0;
var red;
var grn;
var blu;
if (strColor.charAt (0) == '[' && strColor.charAt (len - 1) == ']') {
var check;
if (strColor.indexOf (",") >= 0) {
var tokens = org.jmol.util.TextFormat.splitChars (strColor.substring (1, strColor.length - 1), ",");
if (tokens.length != 3) return 0;
red = org.jmol.util.Parser.parseFloatStr (tokens[0]);
grn = org.jmol.util.Parser.parseFloatStr (tokens[1]);
blu = org.jmol.util.Parser.parseFloatStr (tokens[2]);
return org.jmol.util.ColorUtil.colorTriadToInt (red, grn, blu);
}switch (len) {
case 9:
check = "x";
break;
case 10:
check = "0x";
break;
default:
return 0;
}
if (strColor.indexOf (check) != 1) return 0;
strColor = "#" + strColor.substring (len - 7, len - 1);
len = 7;
}if (len == 7 && strColor.charAt (0) == '#') {
try {
red = org.jmol.util.Parser.parseIntRadix (strColor.substring (1, 3), 16);
grn = org.jmol.util.Parser.parseIntRadix (strColor.substring (3, 5), 16);
blu = org.jmol.util.Parser.parseIntRadix (strColor.substring (5, 7), 16);
return org.jmol.util.ColorUtil.colorTriadToInt (red, grn, blu);
} catch (e) {
if (Clazz.exceptionOf (e, NumberFormatException)) {
return 0;
} else {
throw e;
}
}
}var boxedArgb = org.jmol.util.ColorUtil.mapJavaScriptColors.get (strColor.toLowerCase ());
return (boxedArgb == null ? 0 : boxedArgb.intValue ());
}, "~S");
c$.colorTriadToInt = Clazz.defineMethod (c$, "colorTriadToInt", 
function (x, y, z) {
if (x <= 1 && y <= 1 && z <= 1) {
if (x > 0) x = x * 256 - 1;
if (y > 0) y = y * 256 - 1;
if (z > 0) z = z * 256 - 1;
}return org.jmol.util.ColorUtil.rgb (Clazz.floatToInt (x), Clazz.floatToInt (y), Clazz.floatToInt (z));
}, "~N,~N,~N");
c$.rgb = Clazz.defineMethod (c$, "rgb", 
function (red, grn, blu) {
return 0xFF000000 | (red << 16) | (grn << 8) | blu;
}, "~N,~N,~N");
c$.colorPointFromString = Clazz.defineMethod (c$, "colorPointFromString", 
function (colorName, pt) {
return org.jmol.util.ColorUtil.colorPointFromInt (org.jmol.util.ColorUtil.getArgbFromString (colorName), pt);
}, "~S,org.jmol.util.Point3f");
c$.colorPointFromInt2 = Clazz.defineMethod (c$, "colorPointFromInt2", 
function (color) {
return org.jmol.util.Point3f.new3 ((color >> 16) & 0xFF, (color >> 8) & 0xFF, color & 0xFF);
}, "~N");
c$.colorPtToInt = Clazz.defineMethod (c$, "colorPtToInt", 
function (pt) {
return org.jmol.util.ColorUtil.colorTriadToInt (pt.x, pt.y, pt.z);
}, "org.jmol.util.Point3f");
c$.colorPointFromInt = Clazz.defineMethod (c$, "colorPointFromInt", 
function (color, pt) {
pt.z = color & 0xFF;
pt.y = (color >> 8) & 0xFF;
pt.x = (color >> 16) & 0xFF;
return pt;
}, "~N,org.jmol.util.Point3f");
c$.calcGreyscaleRgbFromRgb = Clazz.defineMethod (c$, "calcGreyscaleRgbFromRgb", 
function (rgb) {
var grey = (Clazz.doubleToInt (((2989 * ((rgb >> 16) & 0xFF)) + (5870 * ((rgb >> 8) & 0xFF)) + (1140 * (rgb & 0xFF)) + 5000) / 10000)) & 0xFFFFFF;
return org.jmol.util.ColorUtil.rgb (grey, grey, grey);
}, "~N");
Clazz.defineStatics (c$,
"colorNames", ["black", "pewhite", "pecyan", "pepurple", "pegreen", "peblue", "peviolet", "pebrown", "pepink", "peyellow", "pedarkgreen", "peorange", "pelightblue", "pedarkcyan", "pedarkgray", "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen", "bluetint", "greenblue", "greentint", "grey", "pinktint", "redorange", "yellowtint"],
"colorArgbs", [0xFF000000, 0xFFffffff, 0xFF00ffff, 0xFFd020ff, 0xFF00ff00, 0xFF6060ff, 0xFFff80c0, 0xFFa42028, 0xFFffd8d8, 0xFFffff00, 0xFF00c000, 0xFFffb000, 0xFFb0b0ff, 0xFF00a0a0, 0xFF606060, 0xFFF0F8FF, 0xFFFAEBD7, 0xFF00FFFF, 0xFF7FFFD4, 0xFFF0FFFF, 0xFFF5F5DC, 0xFFFFE4C4, 0xFFFFEBCD, 0xFF0000FF, 0xFF8A2BE2, 0xFFA52A2A, 0xFFDEB887, 0xFF5F9EA0, 0xFF7FFF00, 0xFFD2691E, 0xFFFF7F50, 0xFF6495ED, 0xFFFFF8DC, 0xFFDC143C, 0xFF00FFFF, 0xFF00008B, 0xFF008B8B, 0xFFB8860B, 0xFFA9A9A9, 0xFF006400, 0xFFBDB76B, 0xFF8B008B, 0xFF556B2F, 0xFFFF8C00, 0xFF9932CC, 0xFF8B0000, 0xFFE9967A, 0xFF8FBC8F, 0xFF483D8B, 0xFF2F4F4F, 0xFF00CED1, 0xFF9400D3, 0xFFFF1493, 0xFF00BFFF, 0xFF696969, 0xFF1E90FF, 0xFFB22222, 0xFFFFFAF0, 0xFF228B22, 0xFFFF00FF, 0xFFDCDCDC, 0xFFF8F8FF, 0xFFFFD700, 0xFFDAA520, 0xFF808080, 0xFF008000, 0xFFADFF2F, 0xFFF0FFF0, 0xFFFF69B4, 0xFFCD5C5C, 0xFF4B0082, 0xFFFFFFF0, 0xFFF0E68C, 0xFFE6E6FA, 0xFFFFF0F5, 0xFF7CFC00, 0xFFFFFACD, 0xFFADD8E6, 0xFFF08080, 0xFFE0FFFF, 0xFFFAFAD2, 0xFF90EE90, 0xFFD3D3D3, 0xFFFFB6C1, 0xFFFFA07A, 0xFF20B2AA, 0xFF87CEFA, 0xFF778899, 0xFFB0C4DE, 0xFFFFFFE0, 0xFF00FF00, 0xFF32CD32, 0xFFFAF0E6, 0xFFFF00FF, 0xFF800000, 0xFF66CDAA, 0xFF0000CD, 0xFFBA55D3, 0xFF9370DB, 0xFF3CB371, 0xFF7B68EE, 0xFF00FA9A, 0xFF48D1CC, 0xFFC71585, 0xFF191970, 0xFFF5FFFA, 0xFFFFE4E1, 0xFFFFE4B5, 0xFFFFDEAD, 0xFF000080, 0xFFFDF5E6, 0xFF808000, 0xFF6B8E23, 0xFFFFA500, 0xFFFF4500, 0xFFDA70D6, 0xFFEEE8AA, 0xFF98FB98, 0xFFAFEEEE, 0xFFDB7093, 0xFFFFEFD5, 0xFFFFDAB9, 0xFFCD853F, 0xFFFFC0CB, 0xFFDDA0DD, 0xFFB0E0E6, 0xFF800080, 0xFFFF0000, 0xFFBC8F8F, 0xFF4169E1, 0xFF8B4513, 0xFFFA8072, 0xFFF4A460, 0xFF2E8B57, 0xFFFFF5EE, 0xFFA0522D, 0xFFC0C0C0, 0xFF87CEEB, 0xFF6A5ACD, 0xFF708090, 0xFFFFFAFA, 0xFF00FF7F, 0xFF4682B4, 0xFFD2B48C, 0xFF008080, 0xFFD8BFD8, 0xFFFF6347, 0xFF40E0D0, 0xFFEE82EE, 0xFFF5DEB3, 0xFFFFFFFF, 0xFFF5F5F5, 0xFFFFFF00, 0xFF9ACD32, 0xFFAFD7FF, 0xFF2E8B57, 0xFF98FFB3, 0xFF808080, 0xFFFFABBB, 0xFFFF4500, 0xFFF6F675]);
c$.mapJavaScriptColors = c$.prototype.mapJavaScriptColors =  new java.util.Hashtable ();
{
for (var i = org.jmol.util.ColorUtil.colorNames.length; --i >= 0; ) org.jmol.util.ColorUtil.mapJavaScriptColors.put (org.jmol.util.ColorUtil.colorNames[i], Integer.$valueOf (org.jmol.util.ColorUtil.colorArgbs[i]));

}});
// 
//// org\jmol\util\Shader.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (["org.jmol.util.ArrayUtil"], "org.jmol.util.Shader", ["org.jmol.util.ColorUtil"], function () {
c$ = Clazz.declareType (org.jmol.util, "Shader");
c$.getShades = Clazz.defineMethod (c$, "getShades", 
function (rgb, greyScale) {
var shades =  Clazz.newIntArray (64, 0);
if (rgb == 0) return shades;
var red0 = ((rgb >> 16) & 0xFF);
var grn0 = ((rgb >> 8) & 0xFF);
var blu0 = (rgb & 0xFF);
var red = 0;
var grn = 0;
var blu = 0;
var f = org.jmol.util.Shader.ambientFraction;
while (true) {
red = red0 * f + 0.5;
grn = grn0 * f + 0.5;
blu = blu0 * f + 0.5;
if (f > 0 && red < 4 && grn < 4 && blu < 4) {
red0++;
grn0++;
blu0++;
if (f < 0.1) f += 0.1;
rgb = org.jmol.util.ColorUtil.rgb (Clazz.doubleToInt (Math.floor (red0)), Clazz.doubleToInt (Math.floor (grn0)), Clazz.doubleToInt (Math.floor (blu0)));
continue;
}break;
}
f = (1 - f) / 52;
var redStep = red0 * f;
var grnStep = grn0 * f;
var bluStep = blu0 * f;
var i;
for (i = 0; i < 52; ++i) {
shades[i] = org.jmol.util.ColorUtil.rgb (Clazz.doubleToInt (Math.floor (red)), Clazz.doubleToInt (Math.floor (grn)), Clazz.doubleToInt (Math.floor (blu)));
red += redStep;
grn += grnStep;
blu += bluStep;
}
shades[i++] = rgb;
f = org.jmol.util.Shader.intenseFraction / (64 - i);
redStep = (255.5 - red) * f;
grnStep = (255.5 - grn) * f;
bluStep = (255.5 - blu) * f;
for (; i < 64; i++) {
red += redStep;
grn += grnStep;
blu += bluStep;
shades[i] = org.jmol.util.ColorUtil.rgb (Clazz.doubleToInt (Math.floor (red)), Clazz.doubleToInt (Math.floor (grn)), Clazz.doubleToInt (Math.floor (blu)));
}
if (greyScale) for (; --i >= 0; ) shades[i] = org.jmol.util.ColorUtil.calcGreyscaleRgbFromRgb (shades[i]);

return shades;
}, "~N,~B");
c$.getShadeIndex = Clazz.defineMethod (c$, "getShadeIndex", 
function (x, y, z) {
var magnitude = Math.sqrt (x * x + y * y + z * z);
return Math.round (org.jmol.util.Shader.getFloatShadeIndexNormalized ((x / magnitude), (y / magnitude), (z / magnitude)) * 63);
}, "~N,~N,~N");
c$.getShadeIndexNormalized = Clazz.defineMethod (c$, "getShadeIndexNormalized", 
function (x, y, z) {
return Math.round (org.jmol.util.Shader.getFloatShadeIndexNormalized (x, y, z) * 63);
}, "~N,~N,~N");
c$.getFp8ShadeIndex = Clazz.defineMethod (c$, "getFp8ShadeIndex", 
function (x, y, z) {
var magnitude = Math.sqrt (x * x + y * y + z * z);
return Clazz.doubleToInt (Math.floor (org.jmol.util.Shader.getFloatShadeIndexNormalized ((x / magnitude), (y / magnitude), (z / magnitude)) * 63 * (256)));
}, "~N,~N,~N");
c$.getFloatShadeIndexNormalized = Clazz.defineMethod (c$, "getFloatShadeIndexNormalized", 
($fz = function (x, y, z) {
var NdotL = x * org.jmol.util.Shader.xLight + y * org.jmol.util.Shader.yLight + z * org.jmol.util.Shader.zLight;
if (NdotL <= 0) return 0;
var intensity = NdotL * org.jmol.util.Shader.diffuseFactor;
if (org.jmol.util.Shader.specularOn) {
var k_specular = 2 * NdotL * z - org.jmol.util.Shader.zLight;
if (k_specular > 0) {
if (org.jmol.util.Shader.usePhongExponent) {
k_specular = Math.pow (k_specular, org.jmol.util.Shader.phongExponent);
} else {
for (var n = org.jmol.util.Shader.specularExponent; --n >= 0 && k_specular > .0001; ) k_specular *= k_specular;

}intensity += k_specular * org.jmol.util.Shader.specularFactor;
}}if (intensity > 1) return 1;
return intensity;
}, $fz.isPrivate = true, $fz), "~N,~N,~N");
c$.getDitheredNoisyShadeIndex = Clazz.defineMethod (c$, "getDitheredNoisyShadeIndex", 
function (x, y, z, r) {
var fp8ShadeIndex = Clazz.doubleToInt (Math.floor (org.jmol.util.Shader.getFloatShadeIndexNormalized (x / r, y / r, z / r) * 63 * (256)));
var shadeIndex = fp8ShadeIndex >> 8;
if ((fp8ShadeIndex & 0xFF) > org.jmol.util.Shader.nextRandom8Bit ()) ++shadeIndex;
var random16bit = org.jmol.util.Shader.seed & 0xFFFF;
if (random16bit < 21845 && shadeIndex > 0) --shadeIndex;
 else if (random16bit > 43690 && shadeIndex < 63) ++shadeIndex;
return shadeIndex;
}, "~N,~N,~N,~N");
c$.calcSphereShading = Clazz.defineMethod (c$, "calcSphereShading", 
function () {
var xF = -127.5;
for (var i = 0; i < 256; ++xF, ++i) {
var yF = -127.5;
for (var j = 0; j < 256; ++yF, ++j) {
var shadeIndex = 0;
var z2 = 16900 - xF * xF - yF * yF;
if (z2 > 0) {
var z = Math.sqrt (z2);
shadeIndex = org.jmol.util.Shader.getDitheredNoisyShadeIndex (xF, yF, z, 130);
}org.jmol.util.Shader.sphereShadeIndexes[(j << 8) + i] = shadeIndex;
}
}
($t$ = org.jmol.util.Shader.sphereShadingCalculated = true, org.jmol.util.Shader.prototype.sphereShadingCalculated = org.jmol.util.Shader.sphereShadingCalculated, $t$);
});
c$.nextRandom8Bit = Clazz.defineMethod (c$, "nextRandom8Bit", 
function () {
var t = org.jmol.util.Shader.seed;
($t$ = org.jmol.util.Shader.seed = t = ((t << 16) + (t << 1) + t) & 0x7FFFFFFF, org.jmol.util.Shader.prototype.seed = org.jmol.util.Shader.seed, $t$);
return t >> 23;
});
c$.getEllipsoidShade = Clazz.defineMethod (c$, "getEllipsoidShade", 
function (x, y, z, radius, mDeriv) {
var tx = mDeriv.m00 * x + mDeriv.m01 * y + mDeriv.m02 * z + mDeriv.m03;
var ty = mDeriv.m10 * x + mDeriv.m11 * y + mDeriv.m12 * z + mDeriv.m13;
var tz = mDeriv.m20 * x + mDeriv.m21 * y + mDeriv.m22 * z + mDeriv.m23;
var f = Math.min (radius / 2, 45) / Math.sqrt (tx * tx + ty * ty + tz * tz);
var i = Clazz.floatToInt (-tx * f);
var j = Clazz.floatToInt (-ty * f);
var k = Clazz.floatToInt (tz * f);
var outside = i < -20 || i >= 20 || j < -20 || j >= 20 || k < 0 || k >= 40;
if (outside) {
while (i % 2 == 0 && j % 2 == 0 && k % 2 == 0 && i + j + k > 0) {
i >>= 1;
j >>= 1;
k >>= 1;
}
outside = i < -20 || i >= 20 || j < -20 || j >= 20 || k < 0 || k >= 40;
}if (outside) ($t$ = org.jmol.util.Shader.nOut ++, org.jmol.util.Shader.prototype.nOut = org.jmol.util.Shader.nOut, $t$);
 else ($t$ = org.jmol.util.Shader.nIn ++, org.jmol.util.Shader.prototype.nIn = org.jmol.util.Shader.nIn, $t$);
return (outside ? org.jmol.util.Shader.getShadeIndex (i, j, k) : org.jmol.util.Shader.ellipsoidShades[i + 20][j + 20][k]);
}, "~N,~N,~N,~N,org.jmol.util.Matrix4f");
c$.createEllipsoidShades = Clazz.defineMethod (c$, "createEllipsoidShades", 
function () {
($t$ = org.jmol.util.Shader.ellipsoidShades =  Clazz.newByteArray (40, 40, 40, 0), org.jmol.util.Shader.prototype.ellipsoidShades = org.jmol.util.Shader.ellipsoidShades, $t$);
for (var ii = 0; ii < 40; ii++) for (var jj = 0; jj < 40; jj++) for (var kk = 0; kk < 40; kk++) org.jmol.util.Shader.ellipsoidShades[ii][jj][kk] = org.jmol.util.Shader.getShadeIndex (ii - 20, jj - 20, kk);



});
c$.flushSphereCache = Clazz.defineMethod (c$, "flushSphereCache", 
function () {
for (var i = 128; --i >= 0; ) org.jmol.util.Shader.sphereShapeCache[i] = null;

($t$ = org.jmol.util.Shader.ellipsoidShades = null, org.jmol.util.Shader.prototype.ellipsoidShades = org.jmol.util.Shader.ellipsoidShades, $t$);
});
Clazz.defineStatics (c$,
"shadeIndexMax", 64,
"shadeIndexLast", 63,
"shadeIndexNormal", 52,
"shadeIndexNoisyLimit", 56,
"xLightsource", -1,
"yLightsource", -1,
"zLightsource", 2.5);
c$.magnitudeLight = c$.prototype.magnitudeLight = Math.sqrt (8.25);
c$.xLight = c$.prototype.xLight = -1.0 / org.jmol.util.Shader.magnitudeLight;
c$.yLight = c$.prototype.yLight = -1.0 / org.jmol.util.Shader.magnitudeLight;
c$.zLight = c$.prototype.zLight = 2.5 / org.jmol.util.Shader.magnitudeLight;
Clazz.defineStatics (c$,
"specularOn", true,
"usePhongExponent", false,
"ambientPercent", 45,
"diffusePercent", 84,
"specularExponent", 6,
"specularPercent", 22,
"specularPower", 40,
"phongExponent", 64);
c$.ambientFraction = c$.prototype.ambientFraction = org.jmol.util.Shader.ambientPercent / 100;
c$.diffuseFactor = c$.prototype.diffuseFactor = org.jmol.util.Shader.diffusePercent / 100;
c$.intenseFraction = c$.prototype.intenseFraction = org.jmol.util.Shader.specularPower / 100;
c$.specularFactor = c$.prototype.specularFactor = org.jmol.util.Shader.specularPercent / 100;
Clazz.defineStatics (c$,
"sphereShadingCalculated", false,
"sphereShadeIndexes",  Clazz.newByteArray (65536, 0),
"seed", 0x12345679,
"SLIM", 20,
"SDIM", 40,
"maxSphereCache", 128);
c$.sphereShapeCache = c$.prototype.sphereShapeCache = org.jmol.util.ArrayUtil.newInt2 (128);
Clazz.defineStatics (c$,
"ellipsoidShades", null,
"nOut", 0,
"nIn", 0);
});
// 
//// org\jmol\util\Quadric.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.Quadric", ["org.jmol.util.Eigen"], function () {
c$ = Clazz.decorateAsClass (function () {
this.lengths = null;
this.vectors = null;
this.isThermalEllipsoid = true;
this.$scale = 1;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Quadric");
Clazz.defineMethod (c$, "scale", 
function (f) {
for (var i = 0; i < 3; i++) this.lengths[i] *= f;

}, "~N");
Clazz.overrideMethod (c$, "toString", 
function () {
return (this.vectors == null ? "" + this.lengths[0] : this.vectors[0] + "\t" + this.lengths[0] + "\n" + this.vectors[1] + "\t" + this.lengths[1] + "\n" + this.vectors[2] + "\t" + this.lengths[2] + "\n");
});
Clazz.makeConstructor (c$, 
function (vectors, lengths, isThermal) {
this.vectors = vectors;
this.lengths = lengths;
this.isThermalEllipsoid = isThermal;
}, "~A,~A,~B");
Clazz.makeConstructor (c$, 
function (bcart) {
this.isThermalEllipsoid = true;
this.lengths =  Clazz.newFloatArray (3, 0);
this.vectors =  new Array (3);
org.jmol.util.Quadric.getAxesForEllipsoid (bcart, this.vectors, this.lengths);
for (var i = 0; i < 3; i++) this.lengths[i] *= org.jmol.util.Quadric.ONE_OVER_ROOT2_PI;

}, "~A");
Clazz.defineMethod (c$, "rotate", 
function (mat) {
if (this.vectors != null) for (var i = 0; i < 3; i++) mat.transformV (this.vectors[i]);

}, "org.jmol.util.Matrix4f");
Clazz.defineMethod (c$, "setSize", 
function (size) {
this.$scale = (this.isThermalEllipsoid ? org.jmol.util.Quadric.getRadius (size) : size < 1 ? 0 : size / 100.0);
}, "~N");
c$.getAxesForEllipsoid = Clazz.defineMethod (c$, "getAxesForEllipsoid", 
function (coef, unitVectors, lengths) {
var mat =  Clazz.newDoubleArray (3, 3, 0);
mat[0][0] = coef[0];
mat[1][1] = coef[1];
mat[2][2] = coef[2];
mat[0][1] = mat[1][0] = coef[3] / 2;
mat[0][2] = mat[2][0] = coef[4] / 2;
mat[1][2] = mat[2][1] = coef[5] / 2;
org.jmol.util.Eigen.getUnitVectors (mat, unitVectors, lengths);
}, "~A,~A,~A");
c$.setEllipsoidMatrix = Clazz.defineMethod (c$, "setEllipsoidMatrix", 
function (unitAxes, lengths, vTemp, mat) {
for (var i = 0; i < 3; i++) {
vTemp.setT (unitAxes[i]);
vTemp.scale (lengths[i]);
mat.setColumnV (i, vTemp);
}
mat.invertM (mat);
return mat;
}, "~A,~A,org.jmol.util.Vector3f,org.jmol.util.Matrix3f");
c$.getEquationForQuadricWithCenter = Clazz.defineMethod (c$, "getEquationForQuadricWithCenter", 
function (x, y, z, mToElliptical, vTemp, mTemp, coef, mDeriv) {
vTemp.set (x, y, z);
mToElliptical.transform (vTemp);
var f = 1 - vTemp.dot (vTemp);
mTemp.transposeM (mToElliptical);
mTemp.transform (vTemp);
mTemp.mul (mToElliptical);
coef[0] = mTemp.m00 / f;
coef[1] = mTemp.m11 / f;
coef[2] = mTemp.m22 / f;
coef[3] = mTemp.m01 * 2 / f;
coef[4] = mTemp.m02 * 2 / f;
coef[5] = mTemp.m12 * 2 / f;
coef[6] = -2 * vTemp.x / f;
coef[7] = -2 * vTemp.y / f;
coef[8] = -2 * vTemp.z / f;
coef[9] = -1;
if (mDeriv == null) return;
mDeriv.setIdentity ();
mDeriv.m00 = (2 * coef[0]);
mDeriv.m11 = (2 * coef[1]);
mDeriv.m22 = (2 * coef[2]);
mDeriv.m01 = mDeriv.m10 = coef[3];
mDeriv.m02 = mDeriv.m20 = coef[4];
mDeriv.m12 = mDeriv.m21 = coef[5];
mDeriv.m03 = coef[6];
mDeriv.m13 = coef[7];
mDeriv.m23 = coef[8];
}, "~N,~N,~N,org.jmol.util.Matrix3f,org.jmol.util.Vector3f,org.jmol.util.Matrix3f,~A,org.jmol.util.Matrix4f");
c$.getQuardricZ = Clazz.defineMethod (c$, "getQuardricZ", 
function (x, y, coef, zroot) {
var b_2a = (coef[4] * x + coef[5] * y + coef[8]) / coef[2] / 2;
var c_a = (coef[0] * x * x + coef[1] * y * y + coef[3] * x * y + coef[6] * x + coef[7] * y - 1) / coef[2];
var f = b_2a * b_2a - c_a;
if (f < 0) return false;
f = Math.sqrt (f);
zroot[0] = (-b_2a - f);
zroot[1] = (-b_2a + f);
return true;
}, "~N,~N,~A,~A");
c$.getOctant = Clazz.defineMethod (c$, "getOctant", 
function (pt) {
var i = 0;
if (pt.x < 0) i += 1;
if (pt.y < 0) i += 2;
if (pt.z < 0) i += 4;
return i;
}, "org.jmol.util.Point3f");
c$.getRadius = Clazz.defineMethod (c$, "getRadius", 
function (prob) {
return org.jmol.util.Quadric.crtval[prob < 1 ? 0 : prob > 99 ? 98 : prob - 1];
}, "~N");
c$.ONE_OVER_ROOT2_PI = c$.prototype.ONE_OVER_ROOT2_PI = (Math.sqrt (0.5) / 3.141592653589793);
Clazz.defineStatics (c$,
"crtval", [0.3389, 0.4299, 0.4951, 0.5479, 0.5932, 0.6334, 0.6699, 0.7035, 0.7349, 0.7644, 0.7924, 0.8192, 0.8447, 0.8694, 0.8932, 0.9162, 0.9386, 0.9605, 0.9818, 1.0026, 1.0230, 1.0430, 1.0627, 1.0821, 1.1012, 1.1200, 1.1386, 1.1570, 1.1751, 1.1932, 1.2110, 1.2288, 1.2464, 1.2638, 1.2812, 1.2985, 1.3158, 1.3330, 1.3501, 1.3672, 1.3842, 1.4013, 1.4183, 1.4354, 1.4524, 1.4695, 1.4866, 1.5037, 1.5209, 1.5382, 1.5555, 1.5729, 1.5904, 1.6080, 1.6257, 1.6436, 1.6616, 1.6797, 1.6980, 1.7164, 1.7351, 1.7540, 1.7730, 1.7924, 1.8119, 1.8318, 1.8519, 1.8724, 1.8932, 1.9144, 1.9360, 1.9580, 1.9804, 2.0034, 2.0269, 2.0510, 2.0757, 2.1012, 2.1274, 2.1544, 2.1824, 2.2114, 2.2416, 2.2730, 2.3059, 2.3404, 2.3767, 2.4153, 2.4563, 2.5003, 2.5478, 2.5997, 2.6571, 2.7216, 2.7955, 2.8829, 2.9912, 3.1365, 3.3682]);
});
// 
//// org\jmol\util\AxisAngle4f.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.AxisAngle4f", ["org.jmol.util.Tuple3f"], function () {
c$ = Clazz.decorateAsClass (function () {
this.x = 0;
this.y = 0;
this.z = 0;
this.angle = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "AxisAngle4f", null, java.io.Serializable);
Clazz.makeConstructor (c$, 
function () {
this.z = 1.0;
});
c$.new4 = Clazz.defineMethod (c$, "new4", 
function (x, y, z, angle) {
var a =  new org.jmol.util.AxisAngle4f ();
a.set4 (x, y, z, angle);
return a;
}, "~N,~N,~N,~N");
c$.newAA = Clazz.defineMethod (c$, "newAA", 
function (a1) {
var a =  new org.jmol.util.AxisAngle4f ();
a.set4 (a1.x, a1.y, a1.z, a1.angle);
return a;
}, "org.jmol.util.AxisAngle4f");
c$.newVA = Clazz.defineMethod (c$, "newVA", 
function (axis, angle) {
var a =  new org.jmol.util.AxisAngle4f ();
a.setVA (axis, angle);
return a;
}, "org.jmol.util.Vector3f,~N");
Clazz.defineMethod (c$, "setVA", 
function (axis, angle) {
this.x = axis.x;
this.y = axis.y;
this.z = axis.z;
this.angle = angle;
}, "org.jmol.util.Vector3f,~N");
Clazz.defineMethod (c$, "set4", 
function (x, y, z, angle) {
this.x = x;
this.y = y;
this.z = z;
this.angle = angle;
}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "setAA", 
function (a) {
this.x = a.x;
this.y = a.y;
this.z = a.z;
this.angle = a.angle;
}, "org.jmol.util.AxisAngle4f");
Clazz.defineMethod (c$, "setM", 
function (m1) {
this.setFromMat (m1.m00, m1.m01, m1.m02, m1.m10, m1.m11, m1.m12, m1.m20, m1.m21, m1.m22);
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "setFromMat", 
($fz = function (m00, m01, m02, m10, m11, m12, m20, m21, m22) {
var cos = (m00 + m11 + m22 - 1.0) * 0.5;
this.x = (m21 - m12);
this.y = (m02 - m20);
this.z = (m10 - m01);
var sin = 0.5 * Math.sqrt (this.x * this.x + this.y * this.y + this.z * this.z);
this.angle = Math.atan2 (sin, cos);
}, $fz.isPrivate = true, $fz), "~N,~N,~N,~N,~N,~N,~N,~N,~N");
Clazz.overrideMethod (c$, "toString", 
function () {
return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.angle + ")";
});
Clazz.overrideMethod (c$, "equals", 
function (o) {
if (!(Clazz.instanceOf (o, org.jmol.util.AxisAngle4f))) return false;
var a1 = o;
return this.x == a1.x && this.y == a1.y && this.z == a1.z && this.angle == a1.angle;
}, "~O");
Clazz.overrideMethod (c$, "hashCode", 
function () {
return org.jmol.util.Tuple3f.floatToIntBits0 (this.x) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.y) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.z) ^ org.jmol.util.Tuple3f.floatToIntBits0 (this.angle);
});
});
// 
//// org\jmol\api\JmolViewer.js 
// 
Clazz.declarePackage ("org.jmol.api");
Clazz.load (null, "org.jmol.api.JmolViewer", ["java.util.Hashtable"], function () {
c$ = Clazz.decorateAsClass (function () {
this.menuStructure = null;
this.apiPlatform = null;
this.fileAdapter = null;
Clazz.instantialize (this, arguments);
}, org.jmol.api, "JmolViewer");
c$.allocateViewer = Clazz.defineMethod (c$, "allocateViewer", 
function (display, modelAdapter, fullName, documentBase, codeBase, commandOptions, statusListener, implementedPlatform) {
var info =  new java.util.Hashtable ();
if (display != null) info.put ("display", display);
if (modelAdapter != null) info.put ("adapter", modelAdapter);
if (statusListener != null) info.put ("statusListener", statusListener);
if (implementedPlatform != null) info.put ("platform", implementedPlatform);
if (commandOptions != null) info.put ("options", commandOptions);
if (fullName != null) info.put ("fullName", fullName);
if (documentBase != null) info.put ("documentBase", documentBase);
if (codeBase != null) info.put ("codeBase", codeBase);
return  new org.jmol.viewer.Viewer (info);
}, "~O,org.jmol.api.JmolAdapter,~S,java.net.URL,java.net.URL,~S,org.jmol.api.JmolStatusListener,org.jmol.api.ApiPlatform");
c$.allocateViewer = Clazz.defineMethod (c$, "allocateViewer", 
function (container, jmolAdapter) {
return org.jmol.api.JmolViewer.allocateViewer (container, jmolAdapter, null, null, null, null, null, null);
}, "~O,org.jmol.api.JmolAdapter");
c$.allocateViewer = Clazz.defineMethod (c$, "allocateViewer", 
function (display, modelAdapter, fullName, documentBase, codeBase, commandOptions, statusListener) {
return org.jmol.api.JmolViewer.allocateViewer (display, modelAdapter, fullName, documentBase, codeBase, commandOptions, statusListener, null);
}, "~O,org.jmol.api.JmolAdapter,~S,java.net.URL,java.net.URL,~S,org.jmol.api.JmolStatusListener");
Clazz.defineMethod (c$, "setConsole", 
function (console) {
this.getProperty ("DATA_API", "getAppConsole", console);
}, "org.jmol.api.JmolAppConsoleInterface");
c$.getJmolVersion = Clazz.defineMethod (c$, "getJmolVersion", 
function () {
return org.jmol.viewer.Viewer.getJmolVersion ();
});
c$.checkOption = Clazz.defineMethod (c$, "checkOption", 
function (viewer, option) {
var testFlag = viewer.getParameter (option);
return (Clazz.instanceOf (testFlag, Boolean) && (testFlag).booleanValue () || Clazz.instanceOf (testFlag, Integer) && (testFlag).intValue () != 0);
}, "org.jmol.api.JmolViewer,~S");
Clazz.defineMethod (c$, "openFileAsync", 
function (fileName) {
this.openFileAsyncPDB (fileName, false);
}, "~S");
Clazz.defineMethod (c$, "mouseEvent", 
function (id, x, y, modifiers, when) {
this.handleOldJvm10Event (id, x, y, modifiers, when);
}, "~N,~N,~N,~N,~N");
Clazz.defineMethod (c$, "getFileAdapter", 
function () {
return (this.fileAdapter == null ? this.fileAdapter = this.apiPlatform.getFileAdapter () : this.fileAdapter);
});
Clazz.defineMethod (c$, "renderScreenImage", 
function (g, currentSize, rectClip) {
this.apiPlatform.renderScreenImage (this, g, currentSize);
}, "~O,~O,~O");
Clazz.defineMethod (c$, "getJsObjectInfo", 
function (jsObject, method, args) {
return this.apiPlatform.getJsObjectInfo (jsObject, method, args);
}, "~A,~S,~A");
c$.getJmolValueAsString = Clazz.defineMethod (c$, "getJmolValueAsString", 
function (jmolViewer, $var) {
return (jmolViewer == null ? "" : "" + jmolViewer.getParameter ($var));
}, "org.jmol.api.JmolViewer,~S");
});
// 
//// org\jmol\atomdata\AtomDataServer.js 
// 
Clazz.declarePackage ("org.jmol.atomdata");
Clazz.declareInterface (org.jmol.atomdata, "AtomDataServer");
// 
//// org\jmol\constant\EnumVdw.js 
// 
Clazz.declarePackage ("org.jmol.constant");
Clazz.load (["java.lang.Enum"], "org.jmol.constant.EnumVdw", null, function () {
c$ = Clazz.decorateAsClass (function () {
this.pt = 0;
this.type = null;
this.type2 = null;
Clazz.instantialize (this, arguments);
}, org.jmol.constant, "EnumVdw", Enum);
Clazz.makeConstructor (c$, 
($fz = function (pt, type, type2) {
this.pt = pt;
this.type = type;
this.type2 = type2;
}, $fz.isPrivate = true, $fz), "~N,~S,~S");
Clazz.defineMethod (c$, "getVdwLabel", 
function () {
return (this.type == null ? this.type2 : this.type);
});
c$.getVdwType = Clazz.defineMethod (c$, "getVdwType", 
function (label) {
if (label != null) for (var item, $item = 0, $$item = org.jmol.constant.EnumVdw.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (label.equalsIgnoreCase (item.type)) return item;

return null;
}, "~S");
c$.getVdwType2 = Clazz.defineMethod (c$, "getVdwType2", 
function (label) {
if (label != null) for (var item, $item = 0, $$item = org.jmol.constant.EnumVdw.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (label.equalsIgnoreCase (item.type2)) return item;

return null;
}, "~S");
Clazz.defineEnumConstant (c$, "JMOL", 0, [0, "Jmol", null]);
Clazz.defineEnumConstant (c$, "BABEL", 1, [1, "Babel", null]);
Clazz.defineEnumConstant (c$, "RASMOL", 2, [2, "RasMol", null]);
Clazz.defineEnumConstant (c$, "BABEL21", 3, [3, "Babel21", null]);
Clazz.defineEnumConstant (c$, "AUTO_JMOL", 4, [0, null, "Jmol"]);
Clazz.defineEnumConstant (c$, "AUTO_BABEL", 5, [1, null, "Babel"]);
Clazz.defineEnumConstant (c$, "AUTO_RASMOL", 6, [2, null, "RasMol"]);
Clazz.defineEnumConstant (c$, "AUTO", 7, [0, "Auto", null]);
Clazz.defineEnumConstant (c$, "USER", 8, [-1, "User", null]);
Clazz.defineEnumConstant (c$, "ADPMAX", 9, [-1, null, "adpmax"]);
Clazz.defineEnumConstant (c$, "ADPMIN", 10, [-1, null, "adpmin"]);
Clazz.defineEnumConstant (c$, "HYDRO", 11, [-1, null, "hydrophobic"]);
Clazz.defineEnumConstant (c$, "IONIC", 12, [-1, null, "ionic"]);
Clazz.defineEnumConstant (c$, "TEMP", 13, [-1, null, "temperature"]);
Clazz.defineEnumConstant (c$, "NOJMOL", 14, [-1, null, null]);
Clazz.defineEnumConstant (c$, "NADA", 15, [-1, null, null]);
});
// 
//// org\jmol\atomdata\RadiusData.js 
// 
Clazz.declarePackage ("org.jmol.atomdata");
Clazz.load (["java.lang.Enum", "org.jmol.constant.EnumVdw"], "org.jmol.atomdata.RadiusData", ["java.lang.Float", "org.jmol.util.StringXBuilder"], function () {
c$ = Clazz.decorateAsClass (function () {
this.info = null;
this.factorType = null;
this.vdwType = null;
this.value = NaN;
this.valueExtended = 0;
this.values = null;
Clazz.instantialize (this, arguments);
}, org.jmol.atomdata, "RadiusData");
Clazz.prepareFields (c$, function () {
this.factorType = org.jmol.atomdata.RadiusData.EnumType.ABSOLUTE;
this.vdwType = org.jmol.constant.EnumVdw.AUTO;
});
Clazz.makeConstructor (c$, 
function (values, value, factorType, vdwType) {
if (values != null) {
this.values = values;
this.value = 2147483647;
return;
}if (factorType == null) return;
this.factorType = factorType;
this.value = value;
if (vdwType != null) this.vdwType = vdwType;
}, "~A,~N,org.jmol.atomdata.RadiusData.EnumType,org.jmol.constant.EnumVdw");
Clazz.overrideMethod (c$, "toString", 
function () {
if (Float.isNaN (this.value)) return "";
var sb =  new org.jmol.util.StringXBuilder ();
switch (this.factorType) {
case org.jmol.atomdata.RadiusData.EnumType.ABSOLUTE:
sb.appendF (this.value);
break;
case org.jmol.atomdata.RadiusData.EnumType.OFFSET:
sb.append (this.value > 0 ? "+" : "").appendF (this.value);
break;
case org.jmol.atomdata.RadiusData.EnumType.FACTOR:
sb.appendI (Clazz.floatToInt (this.value * 100)).append ("%");
if (this.vdwType !== org.jmol.constant.EnumVdw.AUTO) sb.append (this.vdwType.getVdwLabel ());
break;
case org.jmol.atomdata.RadiusData.EnumType.SCREEN:
sb.appendI (Clazz.floatToInt (this.value));
}
return sb.toString ();
});
Clazz.pu$h ();
c$ = Clazz.declareType (org.jmol.atomdata.RadiusData, "EnumType", Enum);
Clazz.defineEnumConstant (c$, "ABSOLUTE", 0, []);
Clazz.defineEnumConstant (c$, "OFFSET", 1, []);
Clazz.defineEnumConstant (c$, "FACTOR", 2, []);
Clazz.defineEnumConstant (c$, "SCREEN", 3, []);
c$ = Clazz.p0p ();
});
// 
//// org\jmol\util\CommandHistory.js 
// 
Clazz.declarePackage ("org.jmol.util");
Clazz.load (null, "org.jmol.util.CommandHistory", ["java.util.ArrayList"], function () {
c$ = Clazz.decorateAsClass (function () {
this.commandList = null;
this.maxSize = 100;
this.nextCommand = 0;
this.cursorPos = 0;
this.isOn = true;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "CommandHistory");
Clazz.makeConstructor (c$, 
function () {
this.reset (100);
});
Clazz.makeConstructor (c$, 
function (maxSize) {
this.reset (maxSize);
}, "~N");
Clazz.defineMethod (c$, "clear", 
function () {
this.reset (this.maxSize);
});
Clazz.defineMethod (c$, "reset", 
function (maxSize) {
this.maxSize = maxSize;
this.commandList =  new java.util.ArrayList ();
this.nextCommand = 0;
this.commandList.add ("");
this.cursorPos = 0;
}, "~N");
Clazz.defineMethod (c$, "setMaxSize", 
function (maxSize) {
if (maxSize == this.maxSize) return;
if (maxSize < 2) maxSize = 2;
while (this.nextCommand > maxSize) {
this.commandList.remove (0);
this.nextCommand--;
}
if (this.nextCommand > maxSize) this.nextCommand = maxSize - 1;
this.cursorPos = this.nextCommand;
this.maxSize = maxSize;
}, "~N");
Clazz.defineMethod (c$, "getCommandUp", 
function () {
if (this.cursorPos <= 0) return null;
this.cursorPos--;
var str = this.getCommand ();
if (str.endsWith ("#??")) this.removeCommand (this.cursorPos--);
if (this.cursorPos < 0) this.cursorPos = 0;
return str;
});
Clazz.defineMethod (c$, "getCommandDown", 
function () {
if (this.cursorPos >= this.nextCommand) return null;
this.cursorPos++;
return this.getCommand ();
});
Clazz.defineMethod (c$, "getCommand", 
($fz = function () {
return this.commandList.get (this.cursorPos);
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "addCommand", 
function (strCommand) {
if (!this.isOn && !strCommand.endsWith ("#??")) return;
if (strCommand.endsWith ("#----")) return;
var i;
while ((i = strCommand.indexOf ("\n")) >= 0) {
var str = strCommand.substring (0, i);
if (str.length > 0) this.addCommandLine (str);
strCommand = strCommand.substring (i + 1);
}
if (strCommand.length > 0) this.addCommandLine (strCommand);
}, "~S");
Clazz.defineMethod (c$, "getSetHistory", 
function (n) {
this.isOn = (n == -2 ? this.isOn : true);
switch (n) {
case 0:
this.isOn = false;
this.clear ();
return "";
case -2147483648:
case -2:
this.clear ();
return "";
case -1:
return this.getCommandUp ();
case 1:
return this.getCommandDown ();
default:
if (n < 0) {
this.setMaxSize (-2 - n);
return "";
}n = Math.max (this.nextCommand - n, 0);
}
var str = "";
for (var i = n; i < this.nextCommand; i++) if (!this.commandList.get (i).toUpperCase ().startsWith ("WRITE HISTORY")) str += this.commandList.get (i) + "\n";

return str;
}, "~N");
Clazz.defineMethod (c$, "removeCommand", 
function () {
return this.removeCommand (this.nextCommand - 1);
});
Clazz.defineMethod (c$, "removeCommand", 
function (n) {
if (n < 0 || n >= this.nextCommand) return "";
var str = this.commandList.remove (n);
this.nextCommand--;
return str;
}, "~N");
Clazz.defineMethod (c$, "addCommandLine", 
($fz = function (command) {
if (command == null || command.length == 0) return;
if (command.endsWith ("#--")) return;
if (this.nextCommand >= this.maxSize) {
this.commandList.remove (0);
this.nextCommand = this.maxSize - 1;
}this.commandList.add (this.nextCommand, command);
this.nextCommand++;
this.cursorPos = this.nextCommand;
this.commandList.add (this.nextCommand, "");
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineStatics (c$,
"ERROR_FLAG", "#??",
"NOHISTORYLINE_FLAG", "#--",
"NOHISTORYATALL_FLAG", "#----",
"DEFAULT_MAX_SIZE", 100);
});
// 
//// org\jmol\util\Dimension.js 
// 
Clazz.declarePackage ("org.jmol.util");
c$ = Clazz.decorateAsClass (function () {
this.height = 0;
this.width = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.util, "Dimension");
// 
//// org\jmol\viewer\Viewer.js 
// 
Clazz.declarePackage ("org.jmol.viewer");
Clazz.load (["java.lang.Enum", "org.jmol.api.JmolViewer", "org.jmol.atomdata.AtomDataServer", "java.util.ArrayList", "org.jmol.atomdata.RadiusData", "org.jmol.i18n.GT", "org.jmol.util.CommandHistory", "$.Dimension"], "org.jmol.viewer.Viewer", ["java.io.BufferedOutputStream", "$.BufferedReader", "$.BufferedWriter", "$.File", "$.FileWriter", "$.StringReader", "java.lang.Boolean", "$.Character", "$.Double", "$.Float", "$.Runtime", "$.Thread", "java.util.Date", "$.Hashtable", "org.jmol.adapter.smarter.SmarterJmolAdapter", "org.jmol.api.Interface", "org.jmol.constant.EnumAxesMode", "$.EnumFileStatus", "$.EnumStereoMode", "$.EnumVdw", "org.jmol.io.Base64", "$.CifDataReader", "$.JmolBinary", "$.OutputStringBuilder", "org.jmol.modelset.Group", "org.jmol.script.ScriptCompiler", "$.ScriptEvaluator", "$.ScriptVariable", "$.ScriptVariableInt", "$.Token", "org.jmol.shape.Shape", "org.jmol.thread.ScriptDelayThread", "$.TimeoutThread", "org.jmol.util.ArrayUtil", "$.BitSet", "$.BitSetUtil", "$.Colix", "$.ColorUtil", "$.Elements", "$.Escape", "$.GData", "$.JmolMolecule", "$.Logger", "$.Measure", "$.Parser", "$.Point3f", "$.Point3i", "$.StringXBuilder", "$.TempArray", "$.TextFormat", "$.Vector3f", "org.jmol.viewer.ActionManager", "$.AnimationManager", "$.ColorManager", "$.DataManager", "$.FileManager", "$.JmolConstants", "$.ModelManager", "$.PropertyManager", "$.ScriptManager", "$.SelectionManager", "$.ShapeManager", "$.StateManager", "$.StatusManager", "$.TransformManager", "org.jmol.viewer.binding.Binding"], function () {
c$ = Clazz.decorateAsClass (function () {
this.display = null;
this.gdata = null;
this.modelAdapter = null;
this.isJS2D = false;
this.isJS3D = false;
this.access = null;
this.commandHistory = null;
this.colorManager = null;
this.compiler = null;
this.definedAtomSets = null;
this.symmetry = null;
this.smilesMatcher = null;
this.eval = null;
this.animationManager = null;
this.dataManager = null;
this.fileManager = null;
this.actionManager = null;
this.shapeManager = null;
this.modelManager = null;
this.modelSet = null;
this.repaintManager = null;
this.scriptManager = null;
this.selectionManager = null;
this.stateManager = null;
this.global = null;
this.statusManager = null;
this.tempManager = null;
this.transformManager = null;
this.htmlName = "";
this.fullName = "";
this.syncId = "";
this.appletDocumentBase = "";
this.appletCodeBase = "";
this.logFilePath = "";
this.multiTouch = false;
this.isSilent = false;
this.$isApplet = false;
this.applet = null;
this.viewerOptions = null;
this.$isPreviewOnly = false;
this.haveDisplay = false;
this.autoExit = false;
this.mustRender = false;
this.isPrintOnly = false;
this.isSyntaxAndFileCheck = false;
this.isSyntaxCheck = false;
this.listCommands = false;
this.useCommandThread = false;
this.$isSignedApplet = false;
this.isSignedAppletLocal = false;
this.commandOptions = null;
this.$noGraphicsAllowed = false;
this.mouse = null;
this.mouseEnabled = true;
this.noneSelected = false;
this.ligandModels = null;
this.ligandModelSet = null;
this.bsFrameOffsets = null;
this.frameOffsets = null;
this.wasInMotion = false;
this.motionEventNumber = 0;
this.refreshing = true;
this.axesAreTainted = false;
this.dimScreen = null;
this.maximumSize = 2147483647;
this.imageFontScaling = 1;
this.antialiasDisplay = false;
this.insertedCommand = "";
this.scriptIndex = 0;
this.isScriptQueued = true;
this.isSingleThreaded = false;
this.hoverAtomIndex = -1;
this.hoverText = null;
this.hoverEnabled = true;
this.currentCursor = 0;
this.prevFrame = -2147483648;
this.language = null;
this.rd = null;
this.frankOn = true;
this.scriptEditorVisible = false;
this.appConsole = null;
this.scriptEditor = null;
this.jmolpopup = null;
this.modelkitPopup = null;
this.headlessImage = null;
this.isTainted = true;
this.movingSelected = false;
this.showSelected = false;
this.rotateBondIndex = -1;
this.rotatePrev1 = -1;
this.rotatePrev2 = -1;
this.bsRotateBranch = null;
this.creatingImage = false;
this.errorMessage = null;
this.errorMessageUntranslated = null;
this.currentShapeID = -1;
this.currentShapeState = null;
this.privateKey = 0;
this.logFile = null;
this.$isKiosk = false;
this.minimizer = null;
this.executor = null;
this.displayLoadErrors = true;
this.$isParallel = false;
this.actionStates = null;
this.actionStatesRedo = null;
this.undoWorking = false;
this.stateScriptVersionInt = 0;
this.jsExporter3D = null;
this.htPdbBondInfo = null;
this.timeouts = null;
this.scriptDelayThread = null;
this.queueOnHold = false;
Clazz.instantialize (this, arguments);
}, org.jmol.viewer, "Viewer", org.jmol.api.JmolViewer, org.jmol.atomdata.AtomDataServer);
Clazz.prepareFields (c$, function () {
this.commandHistory =  new org.jmol.util.CommandHistory ();
this.dimScreen =  new org.jmol.util.Dimension ();
this.language = org.jmol.i18n.GT.getLanguage ();
this.rd =  new org.jmol.atomdata.RadiusData (null, 0, null, null);
this.privateKey = Math.random ();
this.actionStates =  new java.util.ArrayList ();
this.actionStatesRedo =  new java.util.ArrayList ();
});
Clazz.defineMethod (c$, "finalize", 
function () {
org.jmol.util.Logger.debug ("viewer finalize " + this);
Clazz.superCall (this, org.jmol.viewer.Viewer, "finalize", []);
});
Clazz.defineMethod (c$, "isRestricted", 
function (a) {
return this.access === a;
}, "org.jmol.viewer.Viewer.ACCESS");
Clazz.overrideMethod (c$, "getModelAdapter", 
function () {
if (this.modelAdapter == null) this.modelAdapter =  new org.jmol.adapter.smarter.SmarterJmolAdapter ();
return this.modelAdapter;
});
Clazz.defineMethod (c$, "getSymmetry", 
function () {
if (this.symmetry == null) this.symmetry = org.jmol.api.Interface.getOptionInterface ("symmetry.Symmetry");
return this.symmetry;
});
Clazz.defineMethod (c$, "getSymmetryInfo", 
function (bsAtoms, xyz, op, pt, pt2, id, type) {
return this.modelSet.getSymmetryInfo (bsAtoms, xyz, op, pt, pt2, id, type);
}, "org.jmol.util.BitSet,~S,~N,org.jmol.util.Point3f,org.jmol.util.Point3f,~S,~N");
Clazz.defineMethod (c$, "clearModelDependentObjects", 
($fz = function () {
this.setFrameOffsets (null);
this.stopMinimization ();
this.minimizer = null;
if (this.smilesMatcher != null) {
this.smilesMatcher = null;
}if (this.symmetry != null) {
this.symmetry = null;
}}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "getSmilesMatcher", 
function () {
if (this.smilesMatcher == null) {
this.smilesMatcher = org.jmol.api.Interface.getOptionInterface ("smiles.SmilesMatcher");
}return this.smilesMatcher;
});
Clazz.overrideMethod (c$, "getSmartsMatch", 
function (smarts, bsSelected) {
if (bsSelected == null) bsSelected = this.getSelectionSet (false);
return this.getSmilesMatcher ().getSubstructureSet (smarts, this.getModelSet ().atoms, this.getAtomCount (), bsSelected, true, false);
}, "~S,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getGlobalSettings", 
function () {
return this.global;
});
Clazz.defineMethod (c$, "getStatusManager", 
function () {
return this.statusManager;
});
Clazz.overrideMethod (c$, "isApplet", 
function () {
return this.$isApplet;
});
c$.allocateViewer = Clazz.defineMethod (c$, "allocateViewer", 
function (display, modelAdapter, fullName, documentBase, codeBase, commandOptions, statusListener, implementedPlatform) {
var info =  new java.util.Hashtable ();
info.put ("display", display);
info.put ("adapter", modelAdapter);
info.put ("statusListener", statusListener);
info.put ("platform", implementedPlatform);
info.put ("options", commandOptions);
info.put ("fullName", fullName);
info.put ("documentBase", documentBase);
info.put ("codeBase", codeBase);
return  new org.jmol.viewer.Viewer (info);
}, "~O,org.jmol.api.JmolAdapter,~S,java.net.URL,java.net.URL,~S,org.jmol.api.JmolStatusListener,org.jmol.api.ApiPlatform");
Clazz.makeConstructor (c$, 
function (info) {
Clazz.superConstructor (this, org.jmol.viewer.Viewer, []);
this.setOptions (info);
}, "java.util.Map");
Clazz.defineMethod (c$, "getViewerOptions", 
function () {
return this.viewerOptions;
});
Clazz.defineMethod (c$, "setOptions", 
($fz = function (info) {
this.viewerOptions = info;
if (org.jmol.util.Logger.debugging) {
org.jmol.util.Logger.debug ("Viewer constructor " + this);
}this.modelAdapter = info.get ("adapter");
var statusListener = info.get ("statusListener");
this.fullName = info.get ("fullName");
if (this.fullName == null) this.fullName = "";
var o = info.get ("codeBase");
this.appletCodeBase = (o == null ? "" : o.toString ());
o = info.get ("documentBase");
this.appletDocumentBase = (o == null ? "" : o.toString ());
o = info.get ("options");
this.commandOptions = (o == null ? "" : o.toString ());
if (info.containsKey ("debug") || this.commandOptions.indexOf ("-debug") >= 0) org.jmol.util.Logger.setLogLevel (5);
this.$isSignedApplet = this.checkOption ("signedApplet", "-signed");
this.$isApplet = this.$isSignedApplet || this.checkOption ("applet", "-applet");
var i = this.fullName.indexOf ("__");
this.htmlName = (i < 0 ? this.fullName : this.fullName.substring (0, i));
this.syncId = (i < 0 ? "" : this.fullName.substring (i + 2, this.fullName.length - 2));
if (this.$isApplet) {
{
if(typeof Jmol != "undefined") this.applet =
Jmol._applets[this.htmlName.split("_object")[0]];
}if (info.containsKey ("maximumSize")) this.setMaximumSize ((info.get ("maximumSize")).intValue ());
}this.access = (this.checkOption ("access:READSPT", "-r") ? org.jmol.viewer.Viewer.ACCESS.READSPT : this.checkOption ("access:NONE", "-R") ? org.jmol.viewer.Viewer.ACCESS.NONE : org.jmol.viewer.Viewer.ACCESS.ALL);
this.$isPreviewOnly = info.containsKey ("previewOnly");
if (this.$isPreviewOnly) info.remove ("previewOnly");
this.isPrintOnly = this.checkOption ("printOnly", "-p");
o = info.get ("platform");
var platform = "unknown";
if (o == null) {
o = (this.commandOptions.contains ("platform=") ? this.commandOptions.substring (this.commandOptions.indexOf ("platform=") + 9) : "org.jmol.awt.Platform");
}if (Clazz.instanceOf (o, String)) {
platform = o;
this.isJS3D = (platform.indexOf (".awtjs.") >= 0);
this.isJS2D = (platform.indexOf ("2d") >= 0);
o = org.jmol.api.Interface.getInterface (platform);
}this.apiPlatform = o;
this.display = info.get ("display");
this.isSingleThreaded = this.apiPlatform.isSingleThreaded ();
this.$noGraphicsAllowed = (this.display == null && this.checkOption ("noGraphics", "-n"));
this.haveDisplay = (!this.$noGraphicsAllowed && !this.isHeadless () && !this.checkOption ("isDataOnly", "\0"));
if (this.haveDisplay) {
this.mustRender = true;
this.multiTouch = this.checkOption ("multiTouch", "-multitouch");
{
if (this.isJS2D) this.display =
document.getElementById(this.display);
}} else {
this.display = null;
}this.apiPlatform.setViewer (this, this.display);
o = info.get ("graphicsAdapter");
if (o == null && !this.isJS3D) o = org.jmol.api.Interface.getInterface ("org.jmol.g3d.Graphics3D");
this.gdata = (o == null ?  new org.jmol.util.GData () : o);
this.gdata.initialize (this.apiPlatform);
this.stateManager =  new org.jmol.viewer.StateManager (this);
this.colorManager =  new org.jmol.viewer.ColorManager (this, this.gdata);
this.statusManager =  new org.jmol.viewer.StatusManager (this);
this.scriptManager =  new org.jmol.viewer.ScriptManager (this);
this.transformManager =  new org.jmol.viewer.TransformManager (this, 2147483647, 0);
this.selectionManager =  new org.jmol.viewer.SelectionManager (this);
if (this.haveDisplay) {
this.actionManager = (this.multiTouch ? org.jmol.api.Interface.getOptionInterface ("multitouch.ActionManagerMT") :  new org.jmol.viewer.ActionManager ());
this.actionManager.setViewer (this, this.commandOptions + "-multitouch-" + info.get ("multiTouch"));
this.mouse = this.apiPlatform.getMouseManager (this, this.actionManager);
if (this.multiTouch && !this.checkOption ("-simulated", "-simulated")) this.apiPlatform.setTransparentCursor (this.display);
}this.modelManager =  new org.jmol.viewer.ModelManager (this);
this.shapeManager =  new org.jmol.viewer.ShapeManager (this);
this.tempManager =  new org.jmol.util.TempArray ();
this.dataManager =  new org.jmol.viewer.DataManager (this);
this.animationManager =  new org.jmol.viewer.AnimationManager (this);
o = info.get ("repaintManager");
if (o == null) o = (org.jmol.api.Interface.getOptionInterface ("render.RepaintManager"));
if (o != null && !o.equals ("")) (this.repaintManager = o).set (this, this.shapeManager);
this.initialize (true);
this.fileManager =  new org.jmol.viewer.FileManager (this);
this.compiler =  new org.jmol.script.ScriptCompiler (this);
this.definedAtomSets =  new java.util.Hashtable ();
this.eval =  new org.jmol.script.ScriptEvaluator (this);
this.setJmolStatusListener (statusListener);
if (this.$isApplet) {
org.jmol.util.Logger.info ("viewerOptions: \n" + org.jmol.util.Escape.escapeMap (this.viewerOptions));
($t$ = org.jmol.viewer.Viewer.jsDocumentBase = this.appletDocumentBase, org.jmol.viewer.Viewer.prototype.jsDocumentBase = org.jmol.viewer.Viewer.jsDocumentBase, $t$);
i = org.jmol.viewer.Viewer.jsDocumentBase.indexOf ("#");
if (i >= 0) ($t$ = org.jmol.viewer.Viewer.jsDocumentBase = org.jmol.viewer.Viewer.jsDocumentBase.substring (0, i), org.jmol.viewer.Viewer.prototype.jsDocumentBase = org.jmol.viewer.Viewer.jsDocumentBase, $t$);
i = org.jmol.viewer.Viewer.jsDocumentBase.lastIndexOf ("?");
if (i >= 0) ($t$ = org.jmol.viewer.Viewer.jsDocumentBase = org.jmol.viewer.Viewer.jsDocumentBase.substring (0, i), org.jmol.viewer.Viewer.prototype.jsDocumentBase = org.jmol.viewer.Viewer.jsDocumentBase, $t$);
i = org.jmol.viewer.Viewer.jsDocumentBase.lastIndexOf ("/");
if (i >= 0) ($t$ = org.jmol.viewer.Viewer.jsDocumentBase = org.jmol.viewer.Viewer.jsDocumentBase.substring (0, i), org.jmol.viewer.Viewer.prototype.jsDocumentBase = org.jmol.viewer.Viewer.jsDocumentBase, $t$);
this.fileManager.setAppletContext (this.appletDocumentBase);
var appletProxy = info.get ("appletProxy");
if (appletProxy != null) this.setStringProperty ("appletProxy", appletProxy);
if (this.$isSignedApplet) {
this.logFilePath = org.jmol.util.TextFormat.simpleReplace (this.appletCodeBase, "file://", "");
this.logFilePath = org.jmol.util.TextFormat.simpleReplace (this.logFilePath, "file:/", "");
if (this.logFilePath.indexOf ("//") >= 0) this.logFilePath = null;
 else this.isSignedAppletLocal = true;
} else {
this.logFilePath = null;
}} else {
this.gdata.setBackgroundTransparent (this.checkOption ("backgroundTransparent", "-b"));
this.isSilent = this.checkOption ("silent", "-i");
if (this.isSilent) org.jmol.util.Logger.setLogLevel (3);
this.isSyntaxAndFileCheck = this.checkOption ("checkLoad", "-C");
this.isSyntaxCheck = this.isSyntaxAndFileCheck || this.checkOption ("check", "-c");
this.listCommands = this.checkOption ("listCommands", "-l");
this.autoExit = this.checkOption ("exit", "-x");
this.cd (".");
if (this.isHeadless ()) {
this.headlessImage = info.get ("headlessImage");
o = info.get ("headlistMaxTimeMs");
if (o == null) o = Integer.$valueOf (60000);
this.setTimeout ("" + Math.random (), (o).intValue (), "exitJmol");
}}this.useCommandThread = !this.isHeadless () && this.checkOption ("useCommandThread", "-threaded");
if (this.useCommandThread) this.scriptManager.startCommandWatcher (true);
this.setStartupBooleans ();
this.setIntProperty ("_nProcessors", org.jmol.viewer.Viewer.nProcessors);
o = info.get ("menuFile");
if (o != null) this.getProperty ("DATA_API", "setMenu", this.getFileAsString (o));
if (!this.isSilent) {
org.jmol.util.Logger.info ("(C) 2012 Jmol Development" + "\nJmol Version: " + org.jmol.viewer.Viewer.getJmolVersion () + "\njava.vendor: " + org.jmol.viewer.Viewer.strJavaVendor + "\njava.version: " + org.jmol.viewer.Viewer.strJavaVersion + "\nos.name: " + org.jmol.viewer.Viewer.strOSName + "\nAccess: " + this.access + "\nmemory: " + this.getParameter ("_memory") + "\nprocessors available: " + org.jmol.viewer.Viewer.nProcessors + "\nuseCommandThread: " + this.useCommandThread + (!this.$isApplet ? "" : "\nappletId:" + this.htmlName + (this.$isSignedApplet ? " (signed)" : "")));
}this.zap (false, true, false);
this.global.setParamS ("language", org.jmol.i18n.GT.getLanguage ());
this.stateManager.setJmolDefaults ();
}, $fz.isPrivate = true, $fz), "java.util.Map");
Clazz.defineMethod (c$, "checkOption", 
($fz = function (key1, key2) {
return (this.viewerOptions.containsKey (key1) || this.commandOptions.indexOf (key2) >= 0);
}, $fz.isPrivate = true, $fz), "~S,~S");
Clazz.defineMethod (c$, "isPreviewOnly", 
function () {
return this.$isPreviewOnly;
});
Clazz.defineMethod (c$, "isHeadless", 
function () {
return this.apiPlatform.isHeadless ();
});
Clazz.defineMethod (c$, "setStartupBooleans", 
($fz = function () {
this.setBooleanProperty ("_applet", this.$isApplet);
this.setBooleanProperty ("_signedApplet", this.$isSignedApplet);
this.setBooleanProperty ("_headless", this.apiPlatform.isHeadless ());
this.setStringProperty ("_restrict", "\"" + this.access + "\"");
this.setBooleanProperty ("_useCommandThread", this.useCommandThread);
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "noGraphicsAllowed", 
function () {
return this.$noGraphicsAllowed;
});
c$.getJmolVersion = Clazz.overrideMethod (c$, "getJmolVersion", 
function () {
return org.jmol.viewer.JmolConstants.version + "  " + org.jmol.viewer.JmolConstants.date;
});
Clazz.defineMethod (c$, "getExportDriverList", 
function () {
return (this.isRestricted (org.jmol.viewer.Viewer.ACCESS.ALL) ? this.global.getParameter ("exportDrivers") : "");
});
Clazz.defineMethod (c$, "getHtmlName", 
function () {
return this.htmlName;
});
Clazz.overrideMethod (c$, "getDisplay", 
function () {
return this.display;
});
Clazz.defineMethod (c$, "clearMouse", 
function () {
this.mouse.clear ();
});
Clazz.defineMethod (c$, "disposeMouse", 
function () {
this.mouse.dispose ();
this.mouse = null;
});
Clazz.overrideMethod (c$, "handleOldJvm10Event", 
function (id, x, y, modifiers, time) {
return this.mouse.handleOldJvm10Event (id, x, y, modifiers, time);
}, "~N,~N,~N,~N,~N");
Clazz.defineMethod (c$, "reset", 
function (includingSpin) {
this.modelSet.calcBoundBoxDimensions (null, 1);
this.axesAreTainted = true;
this.transformManager.homePosition (includingSpin);
if (this.modelSet.setCrystallographicDefaults ()) this.stateManager.setCrystallographicDefaults ();
 else this.setAxesModeMolecular (false);
this.prevFrame = -2147483648;
if (!this.getSpinOn ()) this.refresh (1, "Viewer:homePosition()");
}, "~B");
Clazz.overrideMethod (c$, "homePosition", 
function () {
this.evalString ("reset spin");
});
Clazz.defineMethod (c$, "getAppletInfo", 
function () {
var info =  new java.util.Hashtable ();
info.put ("htmlName", this.htmlName);
info.put ("syncId", this.syncId);
info.put ("fullName", this.fullName);
if (this.$isApplet) {
info.put ("documentBase", this.appletDocumentBase);
info.put ("codeBase", this.appletCodeBase);
info.put ("registry", this.statusManager.getRegistryInfo ());
}info.put ("version", org.jmol.viewer.JmolConstants.version);
info.put ("date", org.jmol.viewer.JmolConstants.date);
info.put ("javaVendor", org.jmol.viewer.Viewer.strJavaVendor);
info.put ("javaVersion", org.jmol.viewer.Viewer.strJavaVersion);
info.put ("operatingSystem", org.jmol.viewer.Viewer.strOSName);
return info;
});
Clazz.defineMethod (c$, "initialize", 
function (clearUserVariables) {
this.global = this.stateManager.getGlobalSettings (this.global, clearUserVariables);
this.setStartupBooleans ();
this.global.setParamI ("_width", this.dimScreen.width);
this.global.setParamI ("_height", this.dimScreen.height);
if (this.haveDisplay) {
this.global.setParamB ("_is2D", this.isJS2D);
this.global.setParamB ("_multiTouchClient", this.actionManager.isMTClient ());
this.global.setParamB ("_multiTouchServer", this.actionManager.isMTServer ());
}this.colorManager.resetElementColors ();
this.setObjectColor ("background", "black");
this.setObjectColor ("axis1", "red");
this.setObjectColor ("axis2", "green");
this.setObjectColor ("axis3", "blue");
org.jmol.util.GData.setAmbientPercent (this.global.ambientPercent);
org.jmol.util.GData.setDiffusePercent (this.global.diffusePercent);
org.jmol.util.GData.setSpecular (this.global.specular);
org.jmol.util.GData.setSpecularPercent (this.global.specularPercent);
org.jmol.util.GData.setSpecularPower (-this.global.specularExponent);
org.jmol.util.GData.setPhongExponent (this.global.phongExponent);
org.jmol.util.GData.setSpecularPower (this.global.specularPower);
if (this.modelSet != null) this.animationManager.setAnimationOn (false);
this.animationManager.setAnimationFps (this.global.animationFps);
this.statusManager.setAllowStatusReporting (this.global.statusReporting);
this.setBooleanProperty ("antialiasDisplay", this.global.antialiasDisplay);
this.setTransformManagerDefaults ();
}, "~B");
Clazz.defineMethod (c$, "listSavedStates", 
function () {
return this.stateManager.listSavedStates ();
});
Clazz.defineMethod (c$, "saveOrientation", 
function (saveName) {
this.stateManager.saveOrientation (saveName);
}, "~S");
Clazz.defineMethod (c$, "restoreOrientation", 
function (saveName, timeSeconds) {
return this.stateManager.restoreOrientation (saveName, timeSeconds, true);
}, "~S,~N");
Clazz.defineMethod (c$, "restoreRotation", 
function (saveName, timeSeconds) {
this.stateManager.restoreOrientation (saveName, timeSeconds, false);
}, "~S,~N");
Clazz.defineMethod (c$, "saveModelOrientation", 
function () {
this.modelSet.saveModelOrientation (this.animationManager.currentModelIndex, this.stateManager.getOrientation ());
});
Clazz.defineMethod (c$, "getOrientation", 
function () {
return this.stateManager.getOrientation ();
});
Clazz.defineMethod (c$, "getSavedOrienationText", 
function (name) {
return this.stateManager.getSavedOrientationText (name);
}, "~S");
Clazz.defineMethod (c$, "restoreModelOrientation", 
function (modelIndex) {
var o = this.modelSet.getModelOrientation (modelIndex);
if (o != null) o.restore (-1, true);
}, "~N");
Clazz.defineMethod (c$, "restoreModelRotation", 
function (modelIndex) {
var o = this.modelSet.getModelOrientation (modelIndex);
if (o != null) o.restore (-1, false);
}, "~N");
Clazz.defineMethod (c$, "saveBonds", 
function (saveName) {
this.stateManager.saveBonds (saveName);
}, "~S");
Clazz.defineMethod (c$, "restoreBonds", 
function (saveName) {
this.clearModelDependentObjects ();
return this.stateManager.restoreBonds (saveName);
}, "~S");
Clazz.defineMethod (c$, "saveState", 
function (saveName) {
this.stateManager.saveState (saveName);
}, "~S");
Clazz.defineMethod (c$, "deleteSavedState", 
function (saveName) {
this.stateManager.deleteSaved ("State_" + saveName);
}, "~S");
Clazz.defineMethod (c$, "getSavedState", 
function (saveName) {
return this.stateManager.getSavedState (saveName);
}, "~S");
Clazz.defineMethod (c$, "saveStructure", 
function (saveName) {
this.stateManager.saveStructure (saveName);
}, "~S");
Clazz.defineMethod (c$, "getSavedStructure", 
function (saveName) {
return this.stateManager.getSavedStructure (saveName);
}, "~S");
Clazz.defineMethod (c$, "saveCoordinates", 
function (saveName, bsSelected) {
this.stateManager.saveCoordinates (saveName, bsSelected);
}, "~S,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getSavedCoordinates", 
function (saveName) {
return this.stateManager.getSavedCoordinates (saveName);
}, "~S");
Clazz.defineMethod (c$, "saveSelection", 
function (saveName) {
this.stateManager.saveSelection (saveName, this.getSelectionSet (false));
this.stateManager.restoreSelection (saveName);
}, "~S");
Clazz.defineMethod (c$, "restoreSelection", 
function (saveName) {
return this.stateManager.restoreSelection (saveName);
}, "~S");
Clazz.defineMethod (c$, "getMatrixtransform", 
function () {
return this.transformManager.getMatrixtransform ();
});
Clazz.defineMethod (c$, "getRotationQuaternion", 
function () {
return this.transformManager.getRotationQuaternion ();
});
Clazz.overrideMethod (c$, "getRotationRadius", 
function () {
return this.transformManager.getRotationRadius ();
});
Clazz.defineMethod (c$, "setRotationRadius", 
function (angstroms, doAll) {
if (doAll) angstroms = this.transformManager.setRotationRadius (angstroms, false);
if (this.modelSet.setRotationRadius (this.animationManager.currentModelIndex, angstroms)) this.global.setParamF ("rotationRadius", angstroms);
}, "~N,~B");
Clazz.defineMethod (c$, "getRotationCenter", 
function () {
return this.transformManager.getRotationCenter ();
});
Clazz.defineMethod (c$, "setCenterAt", 
function (relativeTo, pt) {
if (this.isJmolDataFrame ()) return;
this.transformManager.setCenterAt (relativeTo, pt);
}, "~S,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "setCenterBitSet", 
function (bsCenter, doScale) {
var center = (org.jmol.util.BitSetUtil.cardinalityOf (bsCenter) > 0 ? this.getAtomSetCenter (bsCenter) : null);
if (this.isJmolDataFrame ()) return;
this.transformManager.setNewRotationCenter (center, doScale);
}, "org.jmol.util.BitSet,~B");
Clazz.defineMethod (c$, "setNewRotationCenter", 
function (center) {
if (this.isJmolDataFrame ()) return;
this.transformManager.setNewRotationCenter (center, true);
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "getNavigationCenter", 
function () {
return this.transformManager.getNavigationCenter ();
});
Clazz.defineMethod (c$, "getNavigationDepthPercent", 
function () {
return this.transformManager.getNavigationDepthPercent ();
});
Clazz.defineMethod (c$, "navigate", 
function (keyWhere, modifiers) {
if (this.isJmolDataFrame ()) return;
this.transformManager.navigateKey (keyWhere, modifiers);
if (!this.transformManager.vibrationOn && keyWhere != 0) this.refresh (1, "Viewer:navigate()");
}, "~N,~N");
Clazz.defineMethod (c$, "getNavigationOffset", 
function () {
return this.transformManager.getNavigationOffset ();
});
Clazz.defineMethod (c$, "getNavigationOffsetPercent", 
function (XorY) {
return this.transformManager.getNavigationOffsetPercent (XorY);
}, "~S");
Clazz.defineMethod (c$, "isNavigating", 
function () {
return this.transformManager.isNavigating ();
});
Clazz.defineMethod (c$, "isInPosition", 
function (axis, degrees) {
return this.transformManager.isInPosition (axis, degrees);
}, "org.jmol.util.Vector3f,~N");
Clazz.defineMethod (c$, "move", 
function (eval, dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps) {
this.transformManager.move (eval, dRot, dZoom, dTrans, dSlab, floatSecondsTotal, fps);
this.moveUpdate (floatSecondsTotal);
}, "org.jmol.script.ScriptEvaluator,org.jmol.util.Vector3f,~N,org.jmol.util.Vector3f,~N,~N,~N");
Clazz.defineMethod (c$, "waitForMoveTo", 
function () {
return this.global.waitForMoveTo;
});
Clazz.defineMethod (c$, "stopMotion", 
function () {
this.transformManager.stopMotion ();
});
Clazz.defineMethod (c$, "setRotationMatrix", 
function (rotationMatrix) {
this.transformManager.setRotation (rotationMatrix);
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "moveTo", 
function (eval, floatSecondsTotal, center, rotAxis, degrees, rotationMatrix, zoom, xTrans, yTrans, rotationRadius, navCenter, xNav, yNav, navDepth) {
if (!this.haveDisplay) floatSecondsTotal = 0;
this.setTainted (true);
this.transformManager.moveTo (eval, floatSecondsTotal, center, rotAxis, degrees, rotationMatrix, zoom, xTrans, yTrans, rotationRadius, navCenter, xNav, yNav, navDepth);
}, "org.jmol.script.ScriptEvaluator,~N,org.jmol.util.Point3f,org.jmol.util.Vector3f,~N,org.jmol.util.Matrix3f,~N,~N,~N,~N,org.jmol.util.Point3f,~N,~N,~N");
Clazz.defineMethod (c$, "moveUpdate", 
function (floatSecondsTotal) {
if (floatSecondsTotal > 0) this.requestRepaintAndWait ();
 else if (floatSecondsTotal == 0) this.setSync ();
}, "~N");
Clazz.defineMethod (c$, "getMoveToText", 
function (timespan) {
return this.transformManager.getMoveToText (timespan, false);
}, "~N");
Clazz.defineMethod (c$, "navigateList", 
function (eval, list) {
if (this.isJmolDataFrame ()) return;
this.transformManager.navigateList (eval, list);
}, "org.jmol.script.ScriptEvaluator,java.util.List");
Clazz.defineMethod (c$, "navigatePt", 
function (center) {
this.transformManager.setNavigatePt (center);
this.setSync ();
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "navigateAxis", 
function (rotAxis, degrees) {
this.transformManager.navigateAxis (rotAxis, degrees);
this.setSync ();
}, "org.jmol.util.Vector3f,~N");
Clazz.defineMethod (c$, "navTranslatePercent", 
function (x, y) {
if (this.isJmolDataFrame ()) return;
this.transformManager.navTranslatePercent (0, x, y);
this.setSync ();
}, "~N,~N");
Clazz.defineMethod (c$, "setMouseEnabled", 
function (TF) {
this.mouseEnabled = TF;
}, "~B");
Clazz.overrideMethod (c$, "processEvent", 
function (groupID, eventType, touchID, iData, pt, time) {
this.actionManager.processEvent (groupID, eventType, touchID, iData, pt, time);
}, "~N,~N,~N,~N,org.jmol.util.Point3f,~N");
Clazz.defineMethod (c$, "zoomBy", 
function (pixels) {
if (this.mouseEnabled) this.transformManager.zoomBy (pixels);
this.refresh (2, this.statusManager.syncingMouse ? "Mouse: zoomBy " + pixels : "");
}, "~N");
Clazz.defineMethod (c$, "zoomByFactor", 
function (factor, x, y) {
if (this.mouseEnabled) this.transformManager.zoomByFactor (factor, x, y);
this.refresh (2, !this.statusManager.syncingMouse ? "" : "Mouse: zoomByFactor " + factor + (x == 2147483647 ? "" : " " + x + " " + y));
}, "~N,~N,~N");
Clazz.defineMethod (c$, "rotateXYBy", 
function (xDelta, yDelta) {
if (this.mouseEnabled) this.transformManager.rotateXYBy (xDelta, yDelta, null);
this.refresh (2, this.statusManager.syncingMouse ? "Mouse: rotateXYBy " + xDelta + " " + yDelta : "");
}, "~N,~N");
Clazz.defineMethod (c$, "spinXYBy", 
function (xDelta, yDelta, speed) {
if (this.mouseEnabled) this.transformManager.spinXYBy (xDelta, yDelta, speed);
if (xDelta == 0 && yDelta == 0) return;
this.refresh (2, this.statusManager.syncingMouse ? "Mouse: spinXYBy " + xDelta + " " + yDelta + " " + speed : "");
}, "~N,~N,~N");
Clazz.defineMethod (c$, "rotateZBy", 
function (zDelta, x, y) {
if (this.mouseEnabled) this.transformManager.rotateZBy (zDelta, x, y);
this.refresh (2, this.statusManager.syncingMouse ? "Mouse: rotateZBy " + zDelta + (x == 2147483647 ? "" : " " + x + " " + y) : "");
}, "~N,~N,~N");
Clazz.defineMethod (c$, "rotateSelected", 
function (deltaX, deltaY, bsSelected) {
if (this.isJmolDataFrame ()) return;
if (this.mouseEnabled) {
this.transformManager.rotateXYBy (deltaX, deltaY, this.setMovableBitSet (bsSelected, false));
this.refreshMeasures (true);
}this.refresh (2, this.statusManager.syncingMouse ? "Mouse: rotateMolecule " + deltaX + " " + deltaY : "");
}, "~N,~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "setMovableBitSet", 
($fz = function (bsSelected, checkMolecule) {
if (bsSelected == null) bsSelected = this.getSelectionSet (false);
bsSelected = org.jmol.util.BitSetUtil.copy (bsSelected);
org.jmol.util.BitSetUtil.andNot (bsSelected, this.getMotionFixedAtoms ());
if (checkMolecule && !this.global.allowMoveAtoms) bsSelected = this.modelSet.getMoleculeBitSet (bsSelected);
return bsSelected;
}, $fz.isPrivate = true, $fz), "org.jmol.util.BitSet,~B");
Clazz.defineMethod (c$, "translateXYBy", 
function (xDelta, yDelta) {
if (this.mouseEnabled) this.transformManager.translateXYBy (xDelta, yDelta);
this.refresh (2, this.statusManager.syncingMouse ? "Mouse: translateXYBy " + xDelta + " " + yDelta : "");
}, "~N,~N");
Clazz.defineMethod (c$, "centerAt", 
function (x, y, pt) {
if (this.mouseEnabled) this.transformManager.centerAt (x, y, pt);
this.refresh (2, this.statusManager.syncingMouse ? "Mouse: centerAt " + x + " " + y + " " + pt.x + " " + pt.y + " " + pt.z : "");
}, "~N,~N,org.jmol.util.Point3f");
Clazz.overrideMethod (c$, "rotateFront", 
function () {
this.transformManager.rotateFront ();
this.refresh (1, "Viewer:rotateFront()");
});
Clazz.overrideMethod (c$, "rotateX", 
function (angleRadians) {
this.transformManager.rotateX (angleRadians);
this.refresh (1, "Viewer:rotateX()");
}, "~N");
Clazz.overrideMethod (c$, "rotateY", 
function (angleRadians) {
this.transformManager.rotateY (angleRadians);
this.refresh (1, "Viewer:rotateY()");
}, "~N");
Clazz.overrideMethod (c$, "rotateZ", 
function (angleRadians) {
this.transformManager.rotateZ (angleRadians);
this.refresh (1, "Viewer:rotateZ()");
}, "~N");
Clazz.overrideMethod (c$, "rotateXDeg", 
function (angleDegrees) {
this.rotateX (angleDegrees * 0.017453292);
}, "~N");
Clazz.overrideMethod (c$, "rotateYDeg", 
function (angleDegrees) {
this.rotateY (angleDegrees * 0.017453292);
}, "~N");
Clazz.defineMethod (c$, "translate", 
function (xyz, x, type, bsAtoms) {
var xy = (type == '\0' ? Clazz.floatToInt (x) : type == '%' ? this.transformManager.percentToPixels (xyz, x) : this.transformManager.angstromsToPixels (x * (type == 'n' ? 10 : 1)));
if (bsAtoms != null) {
if (xy == 0) return;
this.transformManager.setSelectedTranslation (bsAtoms, xyz, xy);
} else {
switch (xyz) {
case 'X':
case 'x':
if (type == '\0') this.transformManager.translateToPercent ('x', x);
 else this.transformManager.translateXYBy (xy, 0);
break;
case 'Y':
case 'y':
if (type == '\0') this.transformManager.translateToPercent ('y', x);
 else this.transformManager.translateXYBy (0, xy);
break;
case 'Z':
case 'z':
if (type == '\0') this.transformManager.translateToPercent ('z', x);
 else this.transformManager.translateZBy (xy);
break;
}
}this.refresh (1, "Viewer:translate()");
}, "~S,~N,~S,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getTranslationXPercent", 
function () {
return this.transformManager.getTranslationXPercent ();
});
Clazz.defineMethod (c$, "getTranslationYPercent", 
function () {
return this.transformManager.getTranslationYPercent ();
});
Clazz.defineMethod (c$, "getTranslationZPercent", 
function () {
return this.transformManager.getTranslationZPercent ();
});
Clazz.defineMethod (c$, "getTranslationScript", 
function () {
return this.transformManager.getTranslationScript ();
});
Clazz.overrideMethod (c$, "getZoomPercent", 
function () {
return Clazz.floatToInt (this.getZoomSetting ());
});
Clazz.defineMethod (c$, "getZoomSetting", 
function () {
return this.transformManager.getZoomSetting ();
});
Clazz.overrideMethod (c$, "getZoomPercentFloat", 
function () {
return this.transformManager.getZoomPercentFloat ();
});
Clazz.defineMethod (c$, "getMaxZoomPercent", 
function () {
return 200000;
});
Clazz.defineMethod (c$, "slabReset", 
function () {
this.transformManager.slabReset ();
});
Clazz.defineMethod (c$, "getZoomEnabled", 
function () {
return this.transformManager.zoomEnabled;
});
Clazz.defineMethod (c$, "getSlabEnabled", 
function () {
return this.transformManager.slabEnabled;
});
Clazz.defineMethod (c$, "getSlabByMolecule", 
function () {
return this.global.slabByMolecule;
});
Clazz.defineMethod (c$, "getSlabByAtom", 
function () {
return this.global.slabByAtom;
});
Clazz.defineMethod (c$, "slabByPixels", 
function (pixels) {
this.transformManager.slabByPercentagePoints (pixels);
this.refresh (3, "slabByPixels");
}, "~N");
Clazz.defineMethod (c$, "depthByPixels", 
function (pixels) {
this.transformManager.depthByPercentagePoints (pixels);
this.refresh (3, "depthByPixels");
}, "~N");
Clazz.defineMethod (c$, "slabDepthByPixels", 
function (pixels) {
this.transformManager.slabDepthByPercentagePoints (pixels);
this.refresh (3, "slabDepthByPixels");
}, "~N");
Clazz.defineMethod (c$, "slabInternal", 
function (plane, isDepth) {
this.transformManager.slabInternal (plane, isDepth);
}, "org.jmol.util.Point4f,~B");
Clazz.defineMethod (c$, "slabToPercent", 
function (percentSlab) {
this.transformManager.slabToPercent (percentSlab);
}, "~N");
Clazz.defineMethod (c$, "depthToPercent", 
function (percentDepth) {
this.transformManager.depthToPercent (percentDepth);
}, "~N");
Clazz.defineMethod (c$, "setSlabDepthInternal", 
function (isDepth) {
this.transformManager.setSlabDepthInternal (isDepth);
}, "~B");
Clazz.defineMethod (c$, "zValueFromPercent", 
function (zPercent) {
return this.transformManager.zValueFromPercent (zPercent);
}, "~N");
Clazz.overrideMethod (c$, "getUnscaledTransformMatrix", 
function () {
return this.transformManager.getUnscaledTransformMatrix ();
});
Clazz.defineMethod (c$, "finalizeTransformParameters", 
function () {
this.transformManager.finalizeTransformParameters ();
this.gdata.setSlab (this.transformManager.slabValue);
this.gdata.setDepth (this.transformManager.depthValue);
this.gdata.setZShade (this.transformManager.zShadeEnabled, this.transformManager.zSlabValue, this.transformManager.zDepthValue, this.global.zShadePower);
});
Clazz.defineMethod (c$, "rotatePoint", 
function (pt, ptRot) {
this.transformManager.rotatePoint (pt, ptRot);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "transformPt", 
function (pointAngstroms) {
return this.transformManager.transformPoint (pointAngstroms);
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "transformPtVib", 
function (pointAngstroms, vibrationVector) {
return this.transformManager.transformPointVib (pointAngstroms, vibrationVector);
}, "org.jmol.util.Point3f,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "transformPtScr", 
function (pointAngstroms, pointScreen) {
this.transformManager.transformPointScr (pointAngstroms, pointScreen);
}, "org.jmol.util.Point3f,org.jmol.util.Point3i");
Clazz.defineMethod (c$, "transformPtNoClip", 
function (pointAngstroms, pt) {
this.transformManager.transformPointNoClip2 (pointAngstroms, pt);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "transformPt3f", 
function (pointAngstroms, pointScreen) {
this.transformManager.transformPoint2 (pointAngstroms, pointScreen);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "transformPoints", 
function (pointsAngstroms, pointsScreens) {
this.transformManager.transformPoints (pointsAngstroms.length, pointsAngstroms, pointsScreens);
}, "~A,~A");
Clazz.defineMethod (c$, "transformVector", 
function (vectorAngstroms, vectorTransformed) {
this.transformManager.transformVector (vectorAngstroms, vectorTransformed);
}, "org.jmol.util.Vector3f,org.jmol.util.Vector3f");
Clazz.defineMethod (c$, "unTransformPoint", 
function (pointScreen, pointAngstroms) {
this.transformManager.unTransformPoint (pointScreen, pointAngstroms);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "getScalePixelsPerAngstrom", 
function (asAntialiased) {
return this.transformManager.scalePixelsPerAngstrom * (asAntialiased || !this.antialiasDisplay ? 1 : 0.5);
}, "~B");
Clazz.defineMethod (c$, "scaleToScreen", 
function (z, milliAngstroms) {
return this.transformManager.scaleToScreen (z, milliAngstroms);
}, "~N,~N");
Clazz.defineMethod (c$, "unscaleToScreen", 
function (z, screenDistance) {
return this.transformManager.unscaleToScreen (z, screenDistance);
}, "~N,~N");
Clazz.defineMethod (c$, "scaleToPerspective", 
function (z, sizeAngstroms) {
return this.transformManager.scaleToPerspective (z, sizeAngstroms);
}, "~N,~N");
Clazz.defineMethod (c$, "setSpin", 
function (key, value) {
if (!org.jmol.util.Parser.isOneOf (key, "x;y;z;fps;X;Y;Z;FPS")) return;
var i = "x;y;z;fps;X;Y;Z;FPS".indexOf (key);
switch (i) {
case 0:
this.transformManager.setSpinXYZ (value, NaN, NaN);
break;
case 2:
this.transformManager.setSpinXYZ (NaN, value, NaN);
break;
case 4:
this.transformManager.setSpinXYZ (NaN, NaN, value);
break;
case 6:
default:
this.transformManager.setSpinFps (value);
break;
case 10:
this.transformManager.setNavXYZ (value, NaN, NaN);
break;
case 12:
this.transformManager.setNavXYZ (NaN, value, NaN);
break;
case 14:
this.transformManager.setNavXYZ (NaN, NaN, value);
break;
case 16:
this.transformManager.setNavFps (value);
break;
}
this.global.setParamI ((i < 10 ? "spin" : "nav") + key, value);
}, "~S,~N");
Clazz.defineMethod (c$, "getSpinState", 
function () {
return this.transformManager.getSpinState (false);
});
Clazz.defineMethod (c$, "setSpinOn", 
function (spinOn) {
if (spinOn) this.transformManager.setSpinOn ();
 else this.transformManager.setSpinOff ();
}, "~B");
Clazz.defineMethod (c$, "getSpinOn", 
function () {
return this.transformManager.getSpinOn ();
});
Clazz.defineMethod (c$, "setNavOn", 
function (navOn) {
this.transformManager.setNavOn (navOn);
}, "~B");
Clazz.defineMethod (c$, "getNavOn", 
function () {
return this.transformManager.getNavOn ();
});
Clazz.defineMethod (c$, "setNavXYZ", 
function (x, y, z) {
this.transformManager.setNavXYZ (Clazz.floatToInt (x), Clazz.floatToInt (y), Clazz.floatToInt (z));
}, "~N,~N,~N");
Clazz.defineMethod (c$, "getOrientationText", 
function (type, name) {
return (name == null ? this.transformManager.getOrientationText (type) : this.stateManager.getSavedOrientationText (name));
}, "~N,~S");
Clazz.defineMethod (c$, "getOrientationInfo", 
function () {
return this.transformManager.getOrientationInfo ();
});
Clazz.defineMethod (c$, "getMatrixRotate", 
function () {
return this.transformManager.getMatrixRotate ();
});
Clazz.defineMethod (c$, "getAxisAngle", 
function (axisAngle) {
this.transformManager.getAxisAngle (axisAngle);
}, "org.jmol.util.AxisAngle4f");
Clazz.defineMethod (c$, "getTransformText", 
function () {
return this.transformManager.getTransformText ();
});
Clazz.defineMethod (c$, "getRotation", 
function (matrixRotation) {
this.transformManager.getRotation (matrixRotation);
}, "org.jmol.util.Matrix3f");
Clazz.defineMethod (c$, "getCurrentColorRange", 
function () {
return this.colorManager.getPropertyColorRange ();
});
Clazz.defineMethod (c$, "setDefaultColors", 
($fz = function (isRasmol) {
this.colorManager.setDefaultColors (isRasmol);
this.global.setParamB ("colorRasmol", isRasmol);
this.global.setParamS ("defaultColorScheme", (isRasmol ? "rasmol" : "jmol"));
}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "getDefaultTranslucent", 
function () {
return this.global.defaultTranslucent;
});
Clazz.defineMethod (c$, "getColorArgbOrGray", 
function (colix) {
return this.gdata.getColorArgbOrGray (colix);
}, "~N");
Clazz.defineMethod (c$, "setRubberbandArgb", 
function (argb) {
this.colorManager.setRubberbandArgb (argb);
}, "~N");
Clazz.defineMethod (c$, "getColixRubberband", 
function () {
return this.colorManager.colixRubberband;
});
Clazz.defineMethod (c$, "setElementArgb", 
function (elementNumber, argb) {
this.global.setParamS ("=color " + org.jmol.util.Elements.elementNameFromNumber (elementNumber), org.jmol.util.Escape.escapeColor (argb));
this.colorManager.setElementArgb (elementNumber, argb);
}, "~N,~N");
Clazz.defineMethod (c$, "getVectorScale", 
function () {
return this.global.vectorScale;
});
Clazz.defineMethod (c$, "getVectorSymmetry", 
function () {
return this.global.vectorSymmetry;
});
Clazz.overrideMethod (c$, "setVectorScale", 
function (scale) {
this.global.setParamF ("vectorScale", scale);
this.global.vectorScale = scale;
}, "~N");
Clazz.defineMethod (c$, "getDefaultDrawArrowScale", 
function () {
return this.global.defaultDrawArrowScale;
});
Clazz.defineMethod (c$, "getVibrationScale", 
function () {
return this.global.vibrationScale;
});
Clazz.defineMethod (c$, "getVibrationPeriod", 
function () {
return this.global.vibrationPeriod;
});
Clazz.defineMethod (c$, "isVibrationOn", 
function () {
return this.transformManager.vibrationOn;
});
Clazz.overrideMethod (c$, "setVibrationScale", 
function (scale) {
this.transformManager.setVibrationScale (scale);
this.global.vibrationScale = scale;
this.global.setParamF ("vibrationScale", scale);
}, "~N");
Clazz.defineMethod (c$, "setVibrationOff", 
function () {
this.transformManager.setVibrationPeriod (0);
});
Clazz.overrideMethod (c$, "setVibrationPeriod", 
function (period) {
this.transformManager.setVibrationPeriod (period);
period = Math.abs (period);
this.global.vibrationPeriod = period;
this.global.setParamF ("vibrationPeriod", period);
}, "~N");
Clazz.defineMethod (c$, "setObjectColor", 
function (name, colorName) {
if (colorName == null || colorName.length == 0) return;
this.setObjectArgb (name, org.jmol.util.ColorUtil.getArgbFromString (colorName));
}, "~S,~S");
Clazz.defineMethod (c$, "setObjectArgb", 
function (name, argb) {
var objId = org.jmol.viewer.StateManager.getObjectIdFromName (name);
if (objId < 0) {
if (name.equalsIgnoreCase ("axes")) {
this.setObjectArgb ("axis1", argb);
this.setObjectArgb ("axis2", argb);
this.setObjectArgb ("axis3", argb);
}return;
}this.global.objColors[objId] = argb;
switch (objId) {
case 0:
this.gdata.setBackgroundArgb (argb);
this.colorManager.setColixBackgroundContrast (argb);
break;
}
this.global.setParamS (name + "Color", org.jmol.util.Escape.escapeColor (argb));
}, "~S,~N");
Clazz.defineMethod (c$, "setBackgroundImage", 
function (fileName, image) {
this.global.backgroundImageFileName = fileName;
this.gdata.setBackgroundImage (image);
}, "~S,~O");
Clazz.defineMethod (c$, "getObjectArgb", 
function (objId) {
return this.global.objColors[objId];
}, "~N");
Clazz.defineMethod (c$, "getObjectColix", 
function (objId) {
var argb = this.getObjectArgb (objId);
if (argb == 0) return this.getColixBackgroundContrast ();
return org.jmol.util.Colix.getColix (argb);
}, "~N");
Clazz.defineMethod (c$, "getObjectState", 
function (name) {
var objId = org.jmol.viewer.StateManager.getObjectIdFromName (name.equalsIgnoreCase ("axes") ? "axis" : name);
if (objId < 0) return "";
var mad = this.getObjectMad (objId);
var s =  new org.jmol.util.StringXBuilder ().append ("\n");
org.jmol.shape.Shape.appendCmd (s, name + (mad == 0 ? " off" : mad == 1 ? " on" : mad == -1 ? " dotted" : mad < 20 ? " " + mad : " " + (mad / 2000)));
return s.toString ();
}, "~S");
Clazz.overrideMethod (c$, "setColorBackground", 
function (colorName) {
this.setObjectColor ("background", colorName);
}, "~S");
Clazz.overrideMethod (c$, "getBackgroundArgb", 
function () {
return this.getObjectArgb (0);
});
Clazz.defineMethod (c$, "setObjectMad", 
function (iShape, name, mad) {
var objId = org.jmol.viewer.StateManager.getObjectIdFromName (name.equalsIgnoreCase ("axes") ? "axis" : name);
if (objId < 0) return;
if (mad == -2 || mad == -4) {
var m = mad + 3;
mad = this.getObjectMad (objId);
if (mad == 0) mad = m;
}this.global.setParamB ("show" + name, mad != 0);
this.global.objStateOn[objId] = (mad != 0);
if (mad == 0) return;
this.global.objMad[objId] = mad;
this.setShapeSize (iShape, mad, null);
}, "~N,~S,~N");
Clazz.defineMethod (c$, "getObjectMad", 
function (objId) {
return (this.global.objStateOn[objId] ? this.global.objMad[objId] : 0);
}, "~N");
Clazz.defineMethod (c$, "setPropertyColorScheme", 
function (scheme, isTranslucent, isOverloaded) {
this.global.propertyColorScheme = scheme;
if (scheme.startsWith ("translucent ")) {
isTranslucent = true;
scheme = scheme.substring (12).trim ();
}this.colorManager.setPropertyColorScheme (scheme, isTranslucent, isOverloaded);
}, "~S,~B,~B");
Clazz.defineMethod (c$, "getPropertyColorScheme", 
function () {
return this.global.propertyColorScheme;
});
Clazz.defineMethod (c$, "getColixBackgroundContrast", 
function () {
return this.colorManager.colixBackgroundContrast;
});
Clazz.defineMethod (c$, "getSpecularState", 
function () {
return this.global.getSpecularState ();
});
Clazz.defineMethod (c$, "getColixAtomPalette", 
function (atom, pid) {
return this.colorManager.getColixAtomPalette (atom, pid);
}, "org.jmol.modelset.Atom,~N");
Clazz.defineMethod (c$, "getColixBondPalette", 
function (bond, pid) {
return this.colorManager.getColixBondPalette (bond, pid);
}, "org.jmol.modelset.Bond,~N");
Clazz.defineMethod (c$, "getColorSchemeList", 
function (colorScheme) {
return this.colorManager.getColorSchemeList (colorScheme);
}, "~S");
Clazz.defineMethod (c$, "setUserScale", 
function (scale) {
this.colorManager.setUserScale (scale);
}, "~A");
Clazz.defineMethod (c$, "getColixForPropertyValue", 
function (val) {
return this.colorManager.getColixForPropertyValue (val);
}, "~N");
Clazz.defineMethod (c$, "getColorPointForPropertyValue", 
function (val) {
return org.jmol.util.ColorUtil.colorPointFromInt2 (this.gdata.getColorArgbOrGray (this.colorManager.getColixForPropertyValue (val)));
}, "~N");
Clazz.defineMethod (c$, "select", 
function (bs, isGroup, addRemove, isQuiet) {
if (isGroup) bs = this.getUndeletedGroupAtomBits (bs);
this.selectionManager.select (bs, addRemove, isQuiet);
this.shapeManager.setShapeSizeBs (1, 2147483647, null, null);
}, "org.jmol.util.BitSet,~B,Boolean,~B");
Clazz.overrideMethod (c$, "setSelectionSet", 
function (set) {
this.select (set, false, null, true);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "selectBonds", 
function (bs) {
this.shapeManager.setShapeSizeBs (1, 2147483647, null, bs);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "displayAtoms", 
function (bs, isDisplay, isGroup, addRemove, isQuiet) {
if (isGroup) bs = this.getUndeletedGroupAtomBits (bs);
if (isDisplay) this.selectionManager.display (this.modelSet, bs, addRemove, isQuiet);
 else this.selectionManager.hide (this.modelSet, bs, addRemove, isQuiet);
}, "org.jmol.util.BitSet,~B,~B,Boolean,~B");
Clazz.defineMethod (c$, "getUndeletedGroupAtomBits", 
($fz = function (bs) {
bs = this.getAtomBits (1087373318, bs);
org.jmol.util.BitSetUtil.andNot (bs, this.selectionManager.getDeletedAtoms ());
return bs;
}, $fz.isPrivate = true, $fz), "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getHiddenSet", 
function () {
return this.selectionManager.getHiddenSet ();
});
Clazz.defineMethod (c$, "isSelected", 
function (atomIndex) {
return this.selectionManager.isSelected (atomIndex);
}, "~N");
Clazz.defineMethod (c$, "isInSelectionSubset", 
function (atomIndex) {
return this.selectionManager.isInSelectionSubset (atomIndex);
}, "~N");
Clazz.defineMethod (c$, "reportSelection", 
function (msg) {
if (this.modelSet.getSelectionHaloEnabled ()) this.setTainted (true);
if (this.isScriptQueued || this.global.debugScript) this.scriptStatus (msg);
}, "~S");
Clazz.defineMethod (c$, "getAtomSetCenter", 
function (bs) {
return this.modelSet.getAtomSetCenter (bs);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "clearAtomSets", 
($fz = function () {
this.setSelectionSubset (null);
this.definedAtomSets.clear ();
}, $fz.isPrivate = true, $fz));
Clazz.overrideMethod (c$, "selectAll", 
function () {
this.selectionManager.selectAll (false);
});
Clazz.defineMethod (c$, "setNoneSelected", 
function (noneSelected) {
this.noneSelected = noneSelected;
}, "~B");
Clazz.defineMethod (c$, "getNoneSelected", 
function () {
return (this.noneSelected ? Boolean.TRUE : Boolean.FALSE);
});
Clazz.overrideMethod (c$, "clearSelection", 
function () {
this.selectionManager.clearSelection (true);
this.global.setParamB ("hideNotSelected", false);
});
Clazz.defineMethod (c$, "setSelectionSubset", 
function (subset) {
this.selectionManager.setSelectionSubset (subset);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getSelectionSubset", 
function () {
return this.selectionManager.getSelectionSubset ();
});
Clazz.defineMethod (c$, "invertSelection", 
function () {
this.selectionManager.invertSelection ();
});
Clazz.defineMethod (c$, "getSelectionSet", 
function (includeDeleted) {
return this.selectionManager.getSelectionSet (includeDeleted);
}, "~B");
Clazz.defineMethod (c$, "setSelectedAtom", 
function (atomIndex, TF) {
this.selectionManager.setSelectedAtom (atomIndex, TF);
}, "~N,~B");
Clazz.defineMethod (c$, "isAtomSelected", 
function (atomIndex) {
return this.selectionManager.isAtomSelected (atomIndex);
}, "~N");
Clazz.overrideMethod (c$, "getSelectionCount", 
function () {
return this.selectionManager.getSelectionCount ();
});
Clazz.defineMethod (c$, "setFormalCharges", 
function (formalCharge) {
this.modelSet.setFormalCharges (this.getSelectionSet (false), formalCharge);
}, "~N");
Clazz.overrideMethod (c$, "addSelectionListener", 
function (listener) {
this.selectionManager.addListener (listener);
}, "org.jmol.api.JmolSelectionListener");
Clazz.overrideMethod (c$, "removeSelectionListener", 
function (listener) {
this.selectionManager.addListener (listener);
}, "org.jmol.api.JmolSelectionListener");
Clazz.defineMethod (c$, "getAtomBitSetEval", 
function (eval, atomExpression) {
if (eval == null) eval =  new org.jmol.script.ScriptEvaluator (this);
return org.jmol.script.ScriptEvaluator.getAtomBitSet (eval, atomExpression);
}, "org.jmol.script.ScriptEvaluator,~O");
Clazz.defineMethod (c$, "getAtomBitSet", 
function (atomExpression) {
return this.getAtomBitSetEval (this.eval, atomExpression);
}, "~O");
Clazz.defineMethod (c$, "getAtomBitSetVector", 
function (atomExpression) {
return org.jmol.script.ScriptEvaluator.getAtomBitSetVector (this.eval, this.getAtomCount (), atomExpression);
}, "~O");
Clazz.overrideMethod (c$, "setModeMouse", 
function (modeMouse) {
if (modeMouse == -1) {
if (this.mouse != null) {
this.mouse.dispose ();
this.mouse = null;
}this.clearScriptQueue ();
this.clearThreads ();
this.haltScriptExecution ();
this.scriptManager.clear ();
this.gdata.destroy ();
if (this.jmolpopup != null) this.jmolpopup.dispose ();
if (this.modelkitPopup != null) this.modelkitPopup.dispose ();
try {
if (this.appConsole != null) {
this.appConsole.dispose ();
this.appConsole = null;
}if (this.scriptEditor != null) {
this.scriptEditor.dispose ();
this.scriptEditor = null;
}} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
}}, "~N");
Clazz.defineMethod (c$, "getRubberBandSelection", 
function () {
return (this.haveDisplay ? this.actionManager.getRubberBand () : null);
});
Clazz.defineMethod (c$, "isBound", 
function (action, gesture) {
return (this.haveDisplay && this.actionManager.isBound (action, gesture));
}, "~N,~N");
Clazz.defineMethod (c$, "getCursorX", 
function () {
return (this.haveDisplay ? this.actionManager.getCurrentX () : 0);
});
Clazz.defineMethod (c$, "getCursorY", 
function () {
return (this.haveDisplay ? this.actionManager.getCurrentY () : 0);
});
Clazz.defineMethod (c$, "getDefaultDirectory", 
function () {
return this.global.defaultDirectory;
});
Clazz.overrideMethod (c$, "getBufferedInputStream", 
function (fullPathName) {
return this.fileManager.getBufferedInputStream (fullPathName);
}, "~S");
Clazz.defineMethod (c$, "getBufferedReaderOrErrorMessageFromName", 
function (name, fullPathNameReturn, isBinary) {
return this.fileManager.getBufferedReaderOrErrorMessageFromName (name, fullPathNameReturn, isBinary, true);
}, "~S,~A,~B");
Clazz.defineMethod (c$, "setLoadParameters", 
($fz = function (htParams, isAppend) {
if (htParams == null) htParams =  new java.util.Hashtable ();
htParams.put ("viewer", this);
if (this.global.atomTypes.length > 0) htParams.put ("atomTypes", this.global.atomTypes);
if (!htParams.containsKey ("lattice")) htParams.put ("lattice", this.global.getDefaultLattice ());
if (this.global.applySymmetryToBonds) htParams.put ("applySymmetryToBonds", Boolean.TRUE);
if (this.global.pdbGetHeader) htParams.put ("getHeader", Boolean.TRUE);
if (this.global.pdbSequential) htParams.put ("isSequential", Boolean.TRUE);
htParams.put ("stateScriptVersionInt", Integer.$valueOf (this.stateScriptVersionInt));
if (!htParams.containsKey ("filter")) {
var filter = this.getDefaultLoadFilter ();
if (filter.length > 0) htParams.put ("filter", filter);
}if (isAppend && !this.global.appendNew && this.getAtomCount () > 0) htParams.put ("merging", Boolean.TRUE);
return htParams;
}, $fz.isPrivate = true, $fz), "java.util.Map,~B");
Clazz.overrideMethod (c$, "openFileAsync", 
function (fileName) {
this.openFileAsyncPDB (fileName, false);
}, "~S");
Clazz.overrideMethod (c$, "openFileAsyncPDB", 
function (fileName, pdbCartoons) {
fileName = fileName.trim ();
var allowScript = (!fileName.startsWith ("\t"));
if (!allowScript) fileName = fileName.substring (1);
fileName = fileName.$replace ('\\', '/');
if (this.$isApplet && fileName.indexOf ("://") < 0) fileName = "file://" + (fileName.startsWith ("/") ? "" : "/") + fileName;
var cmd = null;
if (fileName.endsWith ("jvxl")) cmd = "isosurface ";
 else if (!fileName.endsWith (".spt")) {
var type = this.fileManager.getFileTypeName (fileName);
if (type == null) {
type = org.jmol.io.JmolBinary.determineSurfaceTypeIs (this.getBufferedInputStream (fileName));
if (type != null) {
this.evalString ("if (_filetype == 'Pdb') { isosurface sigma 1.0 within 2.0 {*} " + org.jmol.util.Escape.escapeStr (fileName) + " mesh nofill }; else; { isosurface " + org.jmol.util.Escape.escapeStr (fileName) + "}");
return;
}} else if (type.equals ("Jmol")) {
cmd = "load ";
} else if (type.equals ("Cube")) {
cmd = "isosurface sign red blue ";
} else if (!type.equals ("spt")) {
cmd = this.global.defaultDropScript;
cmd = org.jmol.util.TextFormat.simpleReplace (cmd, "%FILE", fileName);
cmd = org.jmol.util.TextFormat.simpleReplace (cmd, "%ALLOWCARTOONS", "" + pdbCartoons);
this.evalString (cmd);
return;
}}if (allowScript && this.scriptEditorVisible && cmd == null) this.showEditor ([fileName, this.getFileAsString (fileName)]);
 else this.evalString ((cmd == null ? "script " : cmd) + org.jmol.util.Escape.escapeStr (fileName));
}, "~S,~B");
Clazz.defineMethod (c$, "openFile", 
function (fileName) {
this.zap (true, true, false);
return this.loadModelFromFile (null, fileName, null, null, false, null, null, 0);
}, "~S");
Clazz.overrideMethod (c$, "openFiles", 
function (fileNames) {
this.zap (true, true, false);
return this.loadModelFromFile (null, null, fileNames, null, false, null, null, 0);
}, "~A");
Clazz.overrideMethod (c$, "openReader", 
function (fullPathName, fileName, reader) {
this.zap (true, true, false);
return this.loadModelFromFile (fullPathName, fileName, null, reader, false, null, null, 0);
}, "~S,~S,java.io.Reader");
Clazz.overrideMethod (c$, "openDOM", 
function (DOMNode) {
this.zap (true, true, false);
return this.loadModelFromFile ("?", "?", null, DOMNode, false, null, null, 0);
}, "~O");
Clazz.defineMethod (c$, "loadModelFromFile", 
function (fullPathName, fileName, fileNames, reader, isAppend, htParams, loadScript, tokType) {
if (htParams == null) htParams = this.setLoadParameters (null, isAppend);
var atomSetCollection;
var saveInfo = this.fileManager.getFileInfo ();
if (fileNames != null) {
if (loadScript == null) {
loadScript =  new org.jmol.util.StringXBuilder ().append ("load files");
for (var i = 0; i < fileNames.length; i++) loadScript.append (" /*file*/$FILENAME" + (i + 1) + "$");

}var timeBegin = System.currentTimeMillis ();
atomSetCollection = this.fileManager.createAtomSetCollectionFromFiles (fileNames, this.setLoadParameters (htParams, isAppend), isAppend);
var ms = System.currentTimeMillis () - timeBegin;
var msg = "";
for (var i = 0; i < fileNames.length; i++) msg += (i == 0 ? "" : ",") + fileNames[i];

org.jmol.util.Logger.info ("openFiles(" + fileNames.length + ") " + ms + " ms");
fileNames = htParams.get ("fullPathNames");
var fileTypes = htParams.get ("fileTypes");
var s = loadScript.toString ();
for (var i = 0; i < fileNames.length; i++) {
var fname = fileNames[i];
if (fileTypes != null && fileTypes[i] != null) fname = fileTypes[i] + "::" + fname;
s = org.jmol.util.TextFormat.simpleReplace (s, "$FILENAME" + (i + 1) + "$", org.jmol.util.Escape.escapeStr (fname.$replace ('\\', '/')));
}
loadScript =  new org.jmol.util.StringXBuilder ().append (s);
} else if (reader == null) {
if (loadScript == null) loadScript =  new org.jmol.util.StringXBuilder ().append ("load /*file*/$FILENAME$");
atomSetCollection = this.openFile (fileName, isAppend, htParams, loadScript);
} else if (Clazz.instanceOf (reader, java.io.Reader)) {
atomSetCollection = this.fileManager.createAtomSetCollectionFromReader (fullPathName, fileName, reader, htParams);
} else {
atomSetCollection = this.fileManager.createAtomSetCollectionFromDOM (reader, htParams);
}if (tokType != 0) {
this.fileManager.setFileInfo (saveInfo);
return this.loadAtomDataAndReturnError (atomSetCollection, tokType);
}if (htParams.containsKey ("isData")) return atomSetCollection;
if (loadScript != null) {
var fname = htParams.get ("fullPathName");
if (fname == null) fname = "";
if (htParams.containsKey ("loadScript")) loadScript = htParams.get ("loadScript");
htParams.put ("loadScript", loadScript =  new org.jmol.util.StringXBuilder ().append (org.jmol.util.TextFormat.simpleReplace (loadScript.toString (), "$FILENAME$", org.jmol.util.Escape.escapeStr (fname.$replace ('\\', '/')))));
}return this.createModelSetAndReturnError (atomSetCollection, isAppend, loadScript);
}, "~S,~S,~A,~O,~B,java.util.Map,org.jmol.util.StringXBuilder,~N");
Clazz.defineMethod (c$, "setLigandModel", 
function (id, data) {
id = id.toUpperCase ();
if (this.ligandModels == null) this.ligandModels =  new java.util.Hashtable ();
this.ligandModels.put (id + "_data", data);
}, "~S,~S");
Clazz.defineMethod (c$, "getLigandModel", 
function (id) {
if (id == null) {
if (this.ligandModelSet != null) {
var e = this.ligandModels.entrySet ().iterator ();
while (e.hasNext ()) {
var entry = e.next ();
if (Clazz.instanceOf (entry.getValue (), Boolean)) e.remove ();
}
}return null;
}id = id.toUpperCase ();
if (this.ligandModelSet == null) this.ligandModelSet =  new java.util.Hashtable ();
this.ligandModelSet.put (id, Boolean.TRUE);
if (this.ligandModels == null) this.ligandModels =  new java.util.Hashtable ();
var model = this.ligandModels.get (id);
var data;
var fname = null;
if (Clazz.instanceOf (model, Boolean)) return null;
if (model == null) model = this.ligandModels.get (id + "_data");
var isError = false;
if (model == null) {
fname = this.setLoadFormat ("#" + id, '#', false);
if (fname.length == 0) return null;
this.scriptEcho ("fetching " + fname);
model = this.getFileAsString (fname);
isError = ((model).indexOf ("java.") == 0);
if (!isError) this.ligandModels.put (id + "_data", model);
}if (!isError && Clazz.instanceOf (model, String)) {
data = model;
if (data.length != 0) {
var htParams =  new java.util.Hashtable ();
htParams.put ("modelOnly", Boolean.TRUE);
model = this.getModelAdapter ().getAtomSetCollectionReader ("ligand", null, org.jmol.io.JmolBinary.getBufferedReaderForString (data), htParams);
isError = (Clazz.instanceOf (model, String));
if (!isError) {
model = this.getModelAdapter ().getAtomSetCollection (model);
isError = (Clazz.instanceOf (model, String));
if (fname != null && !isError) this.scriptEcho (this.getModelAdapter ().getAtomSetCollectionAuxiliaryInfo (model).get ("modelLoadNote"));
}}}if (isError) {
this.scriptEcho (model.toString ());
this.ligandModels.put (id, Boolean.FALSE);
return null;
}return model;
}, "~S");
Clazz.defineMethod (c$, "openFile", 
($fz = function (fileName, isAppend, htParams, loadScript) {
if (fileName == null) return null;
if (fileName.indexOf ("[]") >= 0) {
return null;
}var atomSetCollection;
var msg = "openFile(" + fileName + ")";
org.jmol.util.Logger.startTimer (msg);
htParams = this.setLoadParameters (htParams, isAppend);
var isLoadVariable = fileName.startsWith ("@");
var haveFileData = (htParams.containsKey ("fileData"));
if (fileName.indexOf ('$') == 0) htParams.put ("smilesString", fileName.substring (1));
var isString = (fileName.equalsIgnoreCase ("string") || fileName.equals ("Jmol Model Kit"));
var strModel = null;
if (haveFileData) {
strModel = htParams.get ("fileData");
if (htParams.containsKey ("isData")) {
return this.loadInlineScript (strModel, '\0', isAppend, htParams);
}} else if (isString) {
strModel = this.modelSet.getInlineData (-1);
if (strModel == null) if (this.isModelKitMode ()) strModel = "1 0 C 0 0";
 else return "cannot find string data";
if (loadScript != null) htParams.put ("loadScript", loadScript =  new org.jmol.util.StringXBuilder ().append (org.jmol.util.TextFormat.simpleReplace (loadScript.toString (), "$FILENAME$", "data \"model inline\"\n" + strModel + "end \"model inline\"")));
}if (strModel != null) {
if (!isAppend) this.zap (true, false, false);
atomSetCollection = this.fileManager.createAtomSetCollectionFromString (strModel, loadScript, htParams, isAppend, isLoadVariable || haveFileData && !isString);
} else {
atomSetCollection = this.fileManager.createAtomSetCollectionFromFile (fileName, htParams, isAppend);
}org.jmol.util.Logger.checkTimer (msg, false);
return atomSetCollection;
}, $fz.isPrivate = true, $fz), "~S,~B,java.util.Map,org.jmol.util.StringXBuilder");
Clazz.overrideMethod (c$, "openStringInline", 
function (strModel) {
return this.openStringInlineParams (strModel, null, false);
}, "~S");
Clazz.defineMethod (c$, "loadInline", 
function (strModel) {
return this.loadInlineScript (strModel, this.global.inlineNewlineChar, false, null);
}, "~S");
Clazz.defineMethod (c$, "loadInline", 
function (strModel, newLine) {
return this.loadInlineScript (strModel, newLine, false, null);
}, "~S,~S");
Clazz.defineMethod (c$, "loadInline", 
function (strModel, isAppend) {
return this.loadInlineScript (strModel, '\0', isAppend, null);
}, "~S,~B");
Clazz.defineMethod (c$, "loadInline", 
function (arrayModels) {
return this.loadInline (arrayModels, false);
}, "~A");
Clazz.defineMethod (c$, "loadInline", 
function (arrayModels, isAppend) {
if (arrayModels == null || arrayModels.length == 0) return null;
return this.openStringsInline (arrayModels, null, isAppend);
}, "~A,~B");
Clazz.defineMethod (c$, "loadInline", 
function (arrayData, isAppend) {
if (arrayData == null || arrayData.size () == 0) return null;
if (!isAppend) this.zap (true, false, false);
var atomSetCollection = this.fileManager.createAtomSeCollectionFromArrayData (arrayData, this.setLoadParameters (null, isAppend), isAppend);
return this.createModelSetAndReturnError (atomSetCollection, isAppend, null);
}, "java.util.List,~B");
Clazz.defineMethod (c$, "loadInlineScript", 
($fz = function (strModel, newLine, isAppend, htParams) {
if (strModel == null || strModel.length == 0) return null;
if (strModel.startsWith ("LOAD files")) {
this.script (strModel);
return null;
}strModel = this.fixInlineString (strModel, newLine);
if (newLine.charCodeAt (0) != 0) org.jmol.util.Logger.info ("loading model inline, " + strModel.length + " bytes, with newLine character " + (newLine).charCodeAt (0) + " isAppend=" + isAppend);
org.jmol.util.Logger.debug (strModel);
var datasep = this.getDataSeparator ();
var i;
if (datasep != null && datasep !== "" && (i = strModel.indexOf (datasep)) >= 0 && strModel.indexOf ("# Jmol state") < 0) {
var n = 2;
while ((i = strModel.indexOf (datasep, i + 1)) >= 0) n++;

var strModels =  new Array (n);
var pt = 0;
var pt0 = 0;
for (i = 0; i < n; i++) {
pt = strModel.indexOf (datasep, pt0);
if (pt < 0) pt = strModel.length;
strModels[i] = strModel.substring (pt0, pt);
pt0 = pt + datasep.length;
}
return this.openStringsInline (strModels, htParams, isAppend);
}return this.openStringInlineParams (strModel, htParams, isAppend);
}, $fz.isPrivate = true, $fz), "~S,~S,~B,java.util.Map");
Clazz.defineMethod (c$, "fixInlineString", 
function (strModel, newLine) {
var i;
if (strModel.indexOf ("\\/n") >= 0) {
strModel = org.jmol.util.TextFormat.simpleReplace (strModel, "\n", "");
strModel = org.jmol.util.TextFormat.simpleReplace (strModel, "\\/n", "\n");
newLine = String.fromCharCode ( 0);
}if (newLine.charCodeAt (0) != 0 && newLine != '\n') {
var repEmpty = (strModel.indexOf ('\n') >= 0);
var len = strModel.length;
for (i = 0; i < len && strModel.charAt (i) == ' '; ++i) {
}
if (i < len && strModel.charAt (i) == newLine) strModel = strModel.substring (i + 1);
if (repEmpty) strModel = org.jmol.util.TextFormat.simpleReplace (strModel, "" + newLine, "");
 else strModel = strModel.$replace (newLine, '\n');
}return strModel;
}, "~S,~S");
Clazz.defineMethod (c$, "openStringInlineParams", 
($fz = function (strModel, htParams, isAppend) {
var br =  new java.io.BufferedReader ( new java.io.StringReader (strModel));
var type = this.getModelAdapter ().getFileTypeName (br);
if (type == null) return "unknown file type";
if (type.equals ("spt")) {
return "cannot open script inline";
}htParams = this.setLoadParameters (htParams, isAppend);
var loadScript = htParams.get ("loadScript");
var isLoadCommand = htParams.containsKey ("isData");
if (loadScript == null) loadScript =  new org.jmol.util.StringXBuilder ();
if (!isAppend) this.zap (true, false, false);
var atomSetCollection = this.fileManager.createAtomSetCollectionFromString (strModel, loadScript, htParams, isAppend, isLoadCommand);
return this.createModelSetAndReturnError (atomSetCollection, isAppend, loadScript);
}, $fz.isPrivate = true, $fz), "~S,java.util.Map,~B");
Clazz.defineMethod (c$, "openStringsInline", 
($fz = function (arrayModels, htParams, isAppend) {
var loadScript =  new org.jmol.util.StringXBuilder ();
if (!isAppend) this.zap (true, false, false);
var atomSetCollection = this.fileManager.createAtomSeCollectionFromStrings (arrayModels, loadScript, this.setLoadParameters (htParams, isAppend), isAppend);
return this.createModelSetAndReturnError (atomSetCollection, isAppend, loadScript);
}, $fz.isPrivate = true, $fz), "~A,java.util.Map,~B");
Clazz.defineMethod (c$, "getInlineChar", 
function () {
return this.global.inlineNewlineChar;
});
Clazz.defineMethod (c$, "getDataSeparator", 
function () {
return this.global.getParameter ("dataseparator");
});
Clazz.defineMethod (c$, "createModelSetAndReturnError", 
($fz = function (atomSetCollection, isAppend, loadScript) {
var fullPathName = this.fileManager.getFullPathName ();
var fileName = this.fileManager.getFileName ();
var errMsg;
if (loadScript == null) {
this.setBooleanProperty ("preserveState", false);
loadScript =  new org.jmol.util.StringXBuilder ().append ("load \"???\"");
}if (Clazz.instanceOf (atomSetCollection, String)) {
errMsg = atomSetCollection;
this.setFileLoadStatus (org.jmol.constant.EnumFileStatus.NOT_LOADED, fullPathName, null, null, errMsg);
if (this.displayLoadErrors && !isAppend && !errMsg.equals ("#CANCELED#")) this.zapMsg (errMsg);
return errMsg;
}if (isAppend) this.clearAtomSets ();
 else if (this.getModelkitMode () && !fileName.equals ("Jmol Model Kit")) this.setModelKitMode (false);
this.setFileLoadStatus (org.jmol.constant.EnumFileStatus.CREATING_MODELSET, fullPathName, fileName, null, null);
this.pushHoldRepaintWhy ("createModelSet");
this.setErrorMessage (null, null);
try {
var bsNew =  new org.jmol.util.BitSet ();
this.modelSet = this.modelManager.createModelSet (fullPathName, fileName, loadScript, atomSetCollection, bsNew, isAppend);
if (bsNew.cardinality () > 0) {
var jmolScript = this.modelSet.getModelSetAuxiliaryInfoValue ("jmolscript");
if (this.modelSet.getModelSetAuxiliaryInfoBoolean ("doMinimize")) this.minimize (2147483647, 0, bsNew, null, 0, true, true, true);
 else this.addHydrogens (bsNew, false, true);
if (jmolScript != null) this.modelSet.getModelSetAuxiliaryInfo ().put ("jmolscript", jmolScript);
}this.initializeModel (isAppend);
} catch (er) {
if (Clazz.exceptionOf (er, Error)) {
this.handleError (er, true);
errMsg = this.getShapeErrorState ();
errMsg = ("ERROR creating model: " + er + (errMsg.length == 0 ? "" : "|" + errMsg));
this.zapMsg (errMsg);
this.setErrorMessage (errMsg, null);
} else {
throw er;
}
}
this.popHoldRepaintWhy ("createModelSet");
errMsg = this.getErrorMessage ();
this.setFileLoadStatus (org.jmol.constant.EnumFileStatus.CREATED, fullPathName, fileName, this.getModelSetName (), errMsg);
if (isAppend) {
this.selectAll ();
this.setTainted (true);
this.axesAreTainted = true;
}atomSetCollection = null;
System.gc ();
return errMsg;
}, $fz.isPrivate = true, $fz), "~O,~B,org.jmol.util.StringXBuilder");
Clazz.defineMethod (c$, "loadAtomDataAndReturnError", 
($fz = function (atomSetCollection, tokType) {
if (Clazz.instanceOf (atomSetCollection, String)) return atomSetCollection;
this.setErrorMessage (null, null);
try {
this.modelManager.createAtomDataSet (atomSetCollection, tokType);
switch (tokType) {
case 4166:
this.setStatusFrameChanged (-2147483648);
break;
case 1649412112:
this.shapeManager.deleteVdwDependentShapes (null);
break;
}
} catch (er) {
if (Clazz.exceptionOf (er, Error)) {
this.handleError (er, true);
var errMsg = this.getShapeErrorState ();
errMsg = ("ERROR adding atom data: " + er + (errMsg.length == 0 ? "" : "|" + errMsg));
this.zapMsg (errMsg);
this.setErrorMessage (errMsg, null);
this.setParallel (false);
} else {
throw er;
}
}
return this.getErrorMessage ();
}, $fz.isPrivate = true, $fz), "~O,~N");
Clazz.defineMethod (c$, "writeCurrentFile", 
function (os) {
var filename = this.getFullPathName ();
if (filename.equals ("string") || filename.indexOf ("[]") >= 0 || filename.equals ("JSNode")) {
var str = this.getCurrentFileAsString ();
var bos =  new java.io.BufferedOutputStream (os);
var sb =  new org.jmol.io.OutputStringBuilder (bos);
sb.append (str);
return sb.toString ();
}var pathName = this.modelManager.getModelSetPathName ();
return (pathName == null ? "" : this.getFileAsBytes (pathName, os));
}, "java.io.OutputStream");
Clazz.overrideMethod (c$, "getEmbeddedFileState", 
function (filename) {
return this.fileManager.getEmbeddedFileState (filename);
}, "~S");
Clazz.overrideMethod (c$, "getFileAsBytes", 
function (pathName, os) {
return this.fileManager.getFileAsBytes (pathName, os, true);
}, "~S,java.io.OutputStream");
Clazz.defineMethod (c$, "getCurrentFileAsString", 
function () {
var filename = this.getFullPathName ();
if (filename.equals ("string") || filename.equals ("Jmol Model Kit")) return this.modelSet.getInlineData (this.getCurrentModelIndex ());
if (filename.indexOf ("[]") >= 0) return filename;
if (filename === "JSNode") return "<DOM NODE>";
var pathName = this.modelManager.getModelSetPathName ();
if (pathName == null) return null;
return this.getFileAsStringBin (pathName, 2147483647, true, false);
});
Clazz.defineMethod (c$, "getFullPathName", 
function () {
return this.fileManager.getFullPathName ();
});
Clazz.defineMethod (c$, "getFileName", 
function () {
return this.fileManager.getFileName ();
});
Clazz.defineMethod (c$, "getFullPathNameOrError", 
function (filename) {
return this.fileManager.getFullPathNameOrError (filename);
}, "~S");
Clazz.overrideMethod (c$, "getFileAsString", 
function (name) {
return this.getFileAsStringBin (name, 2147483647, false, false);
}, "~S");
Clazz.defineMethod (c$, "getFileAsStringBin", 
function (name, nBytesMax, doSpecialLoad, allowBinary) {
if (name == null) return this.getCurrentFileAsString ();
var data =  new Array (2);
data[0] = name;
this.getFileAsStringFM (data, nBytesMax, doSpecialLoad, allowBinary);
return data[1];
}, "~S,~N,~B,~B");
Clazz.defineMethod (c$, "getFileAsStringBin", 
function (data, nBytesMax, doSpecialLoad) {
return this.getFileAsStringFM (data, nBytesMax, doSpecialLoad, true);
}, "~A,~N,~B");
Clazz.defineMethod (c$, "getFileAsStringFM", 
($fz = function (data, nBytesMax, doSpecialLoad, allowBinary) {
return this.fileManager.getFileDataOrErrorAsString (data, nBytesMax, doSpecialLoad, allowBinary);
}, $fz.isPrivate = true, $fz), "~A,~N,~B,~B");
Clazz.defineMethod (c$, "getFilePath", 
function (name, asShortName) {
return this.fileManager.getFilePath (name, false, asShortName);
}, "~S,~B");
Clazz.defineMethod (c$, "getFileInfo", 
function () {
return this.fileManager.getFileInfo ();
});
Clazz.defineMethod (c$, "setFileInfo", 
function (fileInfo) {
this.fileManager.setFileInfo (fileInfo);
}, "~A");
Clazz.defineMethod (c$, "autoCalculate", 
function (tokProperty) {
switch (tokProperty) {
case 1112539149:
this.modelSet.getSurfaceDistanceMax ();
break;
case 1112539148:
this.modelSet.calculateStraightness ();
break;
}
}, "~N");
Clazz.defineMethod (c$, "getSurfaceDistanceMax", 
function () {
return this.modelSet.getSurfaceDistanceMax ();
});
Clazz.defineMethod (c$, "calculateStraightness", 
function () {
this.modelSet.setHaveStraightness (false);
this.modelSet.calculateStraightness ();
});
Clazz.defineMethod (c$, "calculateSurface", 
function (bsSelected, envelopeRadius) {
if (bsSelected == null) bsSelected = this.getSelectionSet (false);
if (envelopeRadius == 3.4028235E38 || envelopeRadius == -1) this.addStateScriptRet ("calculate surfaceDistance " + (envelopeRadius == 3.4028235E38 ? "FROM" : "WITHIN"), null, bsSelected, null, "", false, true);
return this.modelSet.calculateSurface (bsSelected, envelopeRadius);
}, "org.jmol.util.BitSet,~N");
Clazz.defineMethod (c$, "getStructureList", 
function () {
return this.global.getStructureList ();
});
Clazz.defineMethod (c$, "setStructureList", 
function (list, type) {
this.global.setStructureList (list, type);
this.modelSet.setStructureList (this.getStructureList ());
}, "~A,org.jmol.constant.EnumStructure");
Clazz.defineMethod (c$, "getDefaultStructureDSSP", 
function () {
return this.global.defaultStructureDSSP;
});
Clazz.defineMethod (c$, "getDefaultStructure", 
function (bsAtoms, bsAllAtoms) {
if (bsAtoms == null) bsAtoms = this.getSelectionSet (false);
return this.modelSet.getDefaultStructure (bsAtoms, bsAllAtoms);
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "calculateStructures", 
function (bsAtoms, asDSSP, setStructure) {
if (bsAtoms == null) bsAtoms = this.getSelectionSet (false);
return this.modelSet.calculateStructures (bsAtoms, asDSSP, this.global.dsspCalcHydrogen, setStructure);
}, "org.jmol.util.BitSet,~B,~B");
Clazz.overrideMethod (c$, "getSelectedAtomIterator", 
function (bsSelected, isGreaterOnly, modelZeroBased, isMultiModel) {
return this.modelSet.getSelectedAtomIterator (bsSelected, isGreaterOnly, modelZeroBased, false, isMultiModel);
}, "org.jmol.util.BitSet,~B,~B,~B");
Clazz.overrideMethod (c$, "setIteratorForAtom", 
function (iterator, atomIndex, distance) {
this.modelSet.setIteratorForAtom (iterator, -1, atomIndex, distance, null);
}, "org.jmol.api.AtomIndexIterator,~N,~N");
Clazz.overrideMethod (c$, "setIteratorForPoint", 
function (iterator, modelIndex, pt, distance) {
this.modelSet.setIteratorForPoint (iterator, modelIndex, pt, distance);
}, "org.jmol.api.AtomIndexIterator,~N,org.jmol.util.Point3f,~N");
Clazz.overrideMethod (c$, "fillAtomData", 
function (atomData, mode) {
atomData.programInfo = "Jmol Version " + org.jmol.viewer.Viewer.getJmolVersion ();
atomData.fileName = this.getFileName ();
this.modelSet.fillAtomData (atomData, mode);
}, "org.jmol.atomdata.AtomData,~N");
Clazz.defineMethod (c$, "addStateScript", 
function (script, addFrameNumber, postDefinitions) {
return this.addStateScriptRet (script, null, null, null, null, addFrameNumber, postDefinitions);
}, "~S,~B,~B");
Clazz.defineMethod (c$, "addStateScriptRet", 
function (script1, bsBonds, bsAtoms1, bsAtoms2, script2, addFrameNumber, postDefinitions) {
return this.modelSet.addStateScript (script1, bsBonds, bsAtoms1, bsAtoms2, script2, addFrameNumber, postDefinitions);
}, "~S,org.jmol.util.BitSet,org.jmol.util.BitSet,org.jmol.util.BitSet,~S,~B,~B");
Clazz.defineMethod (c$, "getEchoStateActive", 
function () {
return this.modelSet.getEchoStateActive ();
});
Clazz.defineMethod (c$, "setEchoStateActive", 
function (TF) {
this.modelSet.setEchoStateActive (TF);
}, "~B");
Clazz.defineMethod (c$, "zap", 
function (notify, resetUndo, zapModelKit) {
this.clearThreads ();
if (this.modelSet != null) {
this.ligandModelSet = null;
this.clearModelDependentObjects ();
this.fileManager.clear ();
this.clearRepaintManager (-1);
this.animationManager.clear ();
this.transformManager.clear ();
this.selectionManager.clear ();
this.clearAllMeasurements ();
this.clearMinimization ();
this.gdata.clear ();
this.modelSet = this.modelManager.zap ();
if (this.haveDisplay) {
this.mouse.clear ();
this.clearTimeouts ();
this.actionManager.clear ();
}this.stateManager.clear (this.global);
this.tempManager.clear ();
this.colorManager.clear ();
this.definedAtomSets.clear ();
this.dataManager.clear ();
if (resetUndo) {
if (zapModelKit && this.isModelKitMode ()) {
this.loadInline ("1 0 C 0 0");
this.setRotationRadius (5.0, true);
this.setStringProperty ("picking", "assignAtom_C");
this.setStringProperty ("picking", "assignBond_p");
}this.undoClear ();
}System.gc ();
} else {
this.modelSet = this.modelManager.zap ();
}this.initializeModel (false);
if (notify) this.setFileLoadStatus (org.jmol.constant.EnumFileStatus.ZAPPED, null, (resetUndo ? "resetUndo" : this.getZapName ()), null, null);
if (org.jmol.util.Logger.debugging) org.jmol.util.Logger.checkMemory ();
}, "~B,~B,~B");
Clazz.defineMethod (c$, "zapMsg", 
($fz = function (msg) {
this.zap (true, true, false);
this.echoMessage (msg);
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "echoMessage", 
function (msg) {
var iShape = 29;
this.loadShape (iShape);
this.setShapeProperty (iShape, "font", this.getFont3D ("SansSerif", "Plain", 9));
this.setShapeProperty (iShape, "target", "error");
this.setShapeProperty (iShape, "text", msg);
}, "~S");
Clazz.defineMethod (c$, "initializeModel", 
($fz = function (isAppend) {
this.clearThreads ();
if (isAppend) {
this.animationManager.initializePointers (1);
return;
}this.reset (true);
this.selectAll ();
this.rotatePrev1 = this.rotateBondIndex = -1;
this.movingSelected = false;
this.noneSelected = false;
this.hoverEnabled = true;
this.transformManager.setCenter ();
this.clearAtomSets ();
this.animationManager.initializePointers (1);
this.setCurrentModelIndex (0);
this.setBackgroundModelIndex (-1);
this.setFrankOn (this.getShowFrank ());
this.startHoverWatcher (true);
this.setTainted (true);
this.finalizeTransformParameters ();
}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "startHoverWatcher", 
function (tf) {
if (this.haveDisplay && this.hoverEnabled) this.actionManager.startHoverWatcher (tf);
}, "~B");
Clazz.overrideMethod (c$, "getModelSetName", 
function () {
if (this.modelSet == null) return null;
return this.modelSet.getModelSetName ();
});
Clazz.overrideMethod (c$, "getModelSetFileName", 
function () {
return this.modelManager.getModelSetFileName ();
});
Clazz.defineMethod (c$, "getUnitCellInfoText", 
function () {
return this.modelSet.getUnitCellInfoText ();
});
Clazz.defineMethod (c$, "getUnitCellInfo", 
function (infoType) {
var symmetry = this.getCurrentUnitCell ();
if (symmetry == null) return NaN;
return symmetry.getUnitCellInfoType (infoType);
}, "~N");
Clazz.defineMethod (c$, "getSpaceGroupInfo", 
function (spaceGroup) {
return this.modelSet.getSpaceGroupInfo (-1, spaceGroup, 0, null, null, null);
}, "~S");
Clazz.defineMethod (c$, "getPolymerPointsAndVectors", 
function (bs, vList) {
this.modelSet.getPolymerPointsAndVectors (bs, vList);
}, "org.jmol.util.BitSet,java.util.List");
Clazz.defineMethod (c$, "getModelSetProperty", 
function (strProp) {
return this.modelSet.getModelSetProperty (strProp);
}, "~S");
Clazz.defineMethod (c$, "getModelSetAuxiliaryInfoValue", 
function (strKey) {
return this.modelSet.getModelSetAuxiliaryInfoValue (strKey);
}, "~S");
Clazz.overrideMethod (c$, "getModelSetPathName", 
function () {
return this.modelManager.getModelSetPathName ();
});
Clazz.defineMethod (c$, "getModelSetTypeName", 
function () {
return this.modelSet.getModelSetTypeName ();
});
Clazz.overrideMethod (c$, "haveFrame", 
function () {
return this.haveModelSet ();
});
Clazz.defineMethod (c$, "haveModelSet", 
function () {
return this.modelSet != null;
});
Clazz.defineMethod (c$, "clearBfactorRange", 
function () {
this.modelSet.clearBfactorRange ();
});
Clazz.defineMethod (c$, "getHybridizationAndAxes", 
function (atomIndex, z, x, lcaoType) {
return this.modelSet.getHybridizationAndAxes (atomIndex, 0, z, x, lcaoType, true, true);
}, "~N,org.jmol.util.Vector3f,org.jmol.util.Vector3f,~S");
Clazz.defineMethod (c$, "getMoleculeBitSet", 
function (atomIndex) {
return this.modelSet.getMoleculeBitSetForAtom (atomIndex);
}, "~N");
Clazz.defineMethod (c$, "getModelUndeletedAtomsBitSet", 
function (modelIndex) {
var bs = this.modelSet.getModelAtomBitSetIncludingDeleted (modelIndex, true);
this.excludeAtoms (bs, false);
return bs;
}, "~N");
Clazz.defineMethod (c$, "getModelBitSet", 
function (atomList, allTrajectories) {
return this.modelSet.getModelBitSet (atomList, allTrajectories);
}, "org.jmol.util.BitSet,~B");
Clazz.defineMethod (c$, "getModelUndeletedAtomsBitSetBs", 
function (bsModels) {
var bs = this.modelSet.getModelAtomBitSetIncludingDeletedBs (bsModels);
this.excludeAtoms (bs, false);
return bs;
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "excludeAtoms", 
function (bs, ignoreSubset) {
this.selectionManager.excludeAtoms (bs, ignoreSubset);
}, "org.jmol.util.BitSet,~B");
Clazz.defineMethod (c$, "getModelSet", 
function () {
return this.modelSet;
});
Clazz.defineMethod (c$, "getBoundBoxCommand", 
function (withOptions) {
return this.modelSet.getBoundBoxCommand (withOptions);
}, "~B");
Clazz.defineMethod (c$, "setBoundBox", 
function (pt1, pt2, byCorner, scale) {
this.modelSet.setBoundBox (pt1, pt2, byCorner, scale);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,~B,~N");
Clazz.overrideMethod (c$, "getBoundBoxCenter", 
function () {
return this.modelSet.getBoundBoxCenter (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "getAverageAtomPoint", 
function () {
return this.modelSet.getAverageAtomPoint ();
});
Clazz.defineMethod (c$, "calcBoundBoxDimensions", 
function (bs, scale) {
this.modelSet.calcBoundBoxDimensions (bs, scale);
this.axesAreTainted = true;
}, "org.jmol.util.BitSet,~N");
Clazz.defineMethod (c$, "getBoxInfo", 
function (bs, scale) {
return this.modelSet.getBoxInfo (bs, scale);
}, "org.jmol.util.BitSet,~N");
Clazz.defineMethod (c$, "calcRotationRadius", 
function (center) {
return this.modelSet.calcRotationRadius (this.animationManager.currentModelIndex, center);
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "calcRotationRadiusBs", 
function (bs) {
return this.modelSet.calcRotationRadiusBs (bs);
}, "org.jmol.util.BitSet");
Clazz.overrideMethod (c$, "getBoundBoxCornerVector", 
function () {
return this.modelSet.getBoundBoxCornerVector ();
});
Clazz.defineMethod (c$, "getBoundBoxVertices", 
function () {
return this.modelSet.getBboxVertices ();
});
Clazz.defineMethod (c$, "getBoundBoxInfo", 
function () {
return this.modelSet.getBoundBoxInfo ();
});
Clazz.defineMethod (c$, "getBoundBoxModels", 
function () {
return this.modelSet.getBoundBoxModels ();
});
Clazz.defineMethod (c$, "getBoundBoxCenterX", 
function () {
return Clazz.doubleToInt (this.dimScreen.width / 2);
});
Clazz.defineMethod (c$, "getBoundBoxCenterY", 
function () {
return Clazz.doubleToInt (this.dimScreen.height / 2);
});
Clazz.overrideMethod (c$, "getModelCount", 
function () {
return this.modelSet.getModelCount ();
});
Clazz.defineMethod (c$, "getModelInfoAsString", 
function () {
return this.modelSet.getModelInfoAsString ();
});
Clazz.defineMethod (c$, "getSymmetryInfoAsString", 
function () {
return this.modelSet.getSymmetryInfoAsString ();
});
Clazz.defineMethod (c$, "getSymmetryOperation", 
function (spaceGroup, symop, pt1, pt2, labelOnly) {
return this.modelSet.getSymmetryOperation (this.animationManager.currentModelIndex, spaceGroup, symop, pt1, pt2, null, labelOnly);
}, "~S,~N,org.jmol.util.Point3f,org.jmol.util.Point3f,~B");
Clazz.overrideMethod (c$, "getModelSetProperties", 
function () {
return this.modelSet.getModelSetProperties ();
});
Clazz.overrideMethod (c$, "getModelSetAuxiliaryInfo", 
function () {
return this.modelSet.getModelSetAuxiliaryInfo ();
});
Clazz.overrideMethod (c$, "getModelNumber", 
function (modelIndex) {
if (modelIndex < 0) return modelIndex;
return this.modelSet.getModelNumber (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "getModelFileNumber", 
function (modelIndex) {
if (modelIndex < 0) return 0;
return this.modelSet.getModelFileNumber (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getModelNumberDotted", 
function (modelIndex) {
return modelIndex < 0 ? "0" : this.modelSet == null ? null : this.modelSet.getModelNumberDotted (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getModelName", 
function (modelIndex) {
return this.modelSet == null ? null : this.modelSet.getModelName (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getModelProperties", 
function (modelIndex) {
return this.modelSet.getModelProperties (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getModelProperty", 
function (modelIndex, propertyName) {
return this.modelSet.getModelProperty (modelIndex, propertyName);
}, "~N,~S");
Clazz.defineMethod (c$, "getModelFileInfo", 
function () {
return this.modelSet.getModelFileInfo (this.getVisibleFramesBitSet ());
});
Clazz.defineMethod (c$, "getModelFileInfoAll", 
function () {
return this.modelSet.getModelFileInfo (null);
});
Clazz.overrideMethod (c$, "getModelAuxiliaryInfo", 
function (modelIndex) {
return this.modelSet.getModelAuxiliaryInfo (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getModelAuxiliaryInfoValue", 
function (modelIndex, keyName) {
return this.modelSet.getModelAuxiliaryInfoValue (modelIndex, keyName);
}, "~N,~S");
Clazz.defineMethod (c$, "getModelNumberIndex", 
function (modelNumber, useModelNumber, doSetTrajectory) {
return this.modelSet.getModelNumberIndex (modelNumber, useModelNumber, doSetTrajectory);
}, "~N,~B,~B");
Clazz.defineMethod (c$, "modelSetHasVibrationVectors", 
function () {
return this.modelSet.modelSetHasVibrationVectors ();
});
Clazz.overrideMethod (c$, "modelHasVibrationVectors", 
function (modelIndex) {
return this.modelSet.modelHasVibrationVectors (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getChainCount", 
function () {
return this.modelSet.getChainCount (true);
});
Clazz.overrideMethod (c$, "getChainCountInModel", 
function (modelIndex) {
return this.modelSet.getChainCountInModel (modelIndex, false);
}, "~N");
Clazz.defineMethod (c$, "getChainCountInModelWater", 
function (modelIndex, countWater) {
return this.modelSet.getChainCountInModel (modelIndex, countWater);
}, "~N,~B");
Clazz.overrideMethod (c$, "getGroupCount", 
function () {
return this.modelSet.getGroupCount ();
});
Clazz.overrideMethod (c$, "getGroupCountInModel", 
function (modelIndex) {
return this.modelSet.getGroupCountInModel (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getPolymerCount", 
function () {
return this.modelSet.getBioPolymerCount ();
});
Clazz.overrideMethod (c$, "getPolymerCountInModel", 
function (modelIndex) {
return this.modelSet.getBioPolymerCountInModel (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getAtomCount", 
function () {
return this.modelSet.getAtomCount ();
});
Clazz.overrideMethod (c$, "getAtomCountInModel", 
function (modelIndex) {
return this.modelSet.getAtomCountInModel (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getBondCount", 
function () {
return this.modelSet.getBondCount ();
});
Clazz.overrideMethod (c$, "getBondCountInModel", 
function (modelIndex) {
return this.modelSet.getBondCountInModel (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "getBondsForSelectedAtoms", 
function (bsAtoms) {
return this.modelSet.getBondsForSelectedAtoms (bsAtoms, this.global.bondModeOr || org.jmol.util.BitSetUtil.cardinalityOf (bsAtoms) == 1);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "frankClicked", 
function (x, y) {
return !this.global.disablePopupMenu && this.getShowFrank () && this.shapeManager.checkFrankclicked (x, y);
}, "~N,~N");
Clazz.defineMethod (c$, "frankClickedModelKit", 
function (x, y) {
return !this.global.disablePopupMenu && this.isModelKitMode () && x >= 0 && y >= 0 && x < 40 && y < 80;
}, "~N,~N");
Clazz.overrideMethod (c$, "findNearestAtomIndex", 
function (x, y) {
return this.findNearestAtomIndexMovable (x, y, false);
}, "~N,~N");
Clazz.defineMethod (c$, "findNearestAtomIndexMovable", 
function (x, y, mustBeMovable) {
return (this.modelSet == null || !this.getAtomPicking () ? -1 : this.modelSet.findNearestAtomIndex (x, y, mustBeMovable ? this.selectionManager.getMotionFixedAtoms () : null));
}, "~N,~N,~B");
Clazz.defineMethod (c$, "findAtomsInRectangle", 
function (rect) {
return this.modelSet.findAtomsInRectangle (rect, this.getVisibleFramesBitSet ());
}, "org.jmol.util.Rectangle");
Clazz.defineMethod (c$, "toCartesian", 
function (pt, asAbsolute) {
var unitCell = this.getCurrentUnitCell ();
if (unitCell != null) unitCell.toCartesian (pt, asAbsolute);
}, "org.jmol.util.Point3f,~B");
Clazz.defineMethod (c$, "toFractional", 
function (pt, asAbsolute) {
var unitCell = this.getCurrentUnitCell ();
if (unitCell != null) unitCell.toFractional (pt, asAbsolute);
}, "org.jmol.util.Point3f,~B");
Clazz.defineMethod (c$, "toUnitCell", 
function (pt, offset) {
var unitCell = this.getCurrentUnitCell ();
if (unitCell != null) unitCell.toUnitCell (pt, offset);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "setCurrentUnitCell", 
function (isosurfaceId) {
var data = [isosurfaceId, null];
this.shapeManager.getShapePropertyData (23, "unitCell", data);
this.modelSet.setUnitCell (this.getCurrentModelIndex (), data[1]);
}, "~S");
Clazz.defineMethod (c$, "setCurrentUnitCellPts", 
function (points) {
this.modelSet.setUnitCell (this.getCurrentModelIndex (), this.getSymmetry ().getUnitCell (points));
}, "~A");
Clazz.defineMethod (c$, "setCurrentUnitCellOffset", 
function (ijk) {
this.modelSet.setUnitCellOffset (this.animationManager.currentModelIndex, null, ijk);
}, "~N");
Clazz.defineMethod (c$, "setCurrentUnitCellOffsetPt", 
function (pt) {
this.modelSet.setUnitCellOffset (this.animationManager.currentModelIndex, pt, 0);
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "getFractionalRelative", 
function () {
return this.global.fractionalRelative;
});
Clazz.defineMethod (c$, "addUnitCellOffset", 
function (pt) {
var unitCell = this.getCurrentUnitCell ();
if (unitCell == null) return;
pt.add (unitCell.getCartesianOffset ());
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "setAtomData", 
function (type, name, coordinateData, isDefault) {
this.modelSet.setAtomData (type, name, coordinateData, isDefault);
this.refreshMeasures (true);
}, "~N,~S,~S,~B");
Clazz.overrideMethod (c$, "setCenterSelected", 
function () {
this.setCenterBitSet (this.getSelectionSet (false), true);
});
Clazz.defineMethod (c$, "getApplySymmetryToBonds", 
function () {
return this.global.applySymmetryToBonds;
});
Clazz.defineMethod (c$, "setApplySymmetryToBonds", 
function (TF) {
this.global.applySymmetryToBonds = TF;
}, "~B");
Clazz.overrideMethod (c$, "setBondTolerance", 
function (bondTolerance) {
this.global.setParamF ("bondTolerance", bondTolerance);
this.global.bondTolerance = bondTolerance;
}, "~N");
Clazz.overrideMethod (c$, "getBondTolerance", 
function () {
return this.global.bondTolerance;
});
Clazz.overrideMethod (c$, "setMinBondDistance", 
function (minBondDistance) {
this.global.setParamF ("minBondDistance", minBondDistance);
this.global.minBondDistance = minBondDistance;
}, "~N");
Clazz.overrideMethod (c$, "getMinBondDistance", 
function () {
return this.global.minBondDistance;
});
Clazz.defineMethod (c$, "getAtomIndices", 
function (bs) {
return this.modelSet.getAtomIndices (bs);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getAtomBits", 
function (tokType, specInfo) {
return this.modelSet.getAtomBits (tokType, specInfo);
}, "~N,~O");
Clazz.defineMethod (c$, "getSequenceBits", 
function (specInfo, bs) {
return this.modelSet.getSequenceBits (specInfo, bs);
}, "~S,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getAtomsNearPt", 
function (distance, coord) {
var bs =  new org.jmol.util.BitSet ();
this.modelSet.getAtomsWithin (distance, coord, bs, -1);
return bs;
}, "~N,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "getAtomsNearPts", 
function (distance, points, bsInclude) {
return this.modelSet.getAtomsWithinBs (distance, points, bsInclude);
}, "~N,~A,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getAtomsNearPlane", 
function (distance, plane) {
return this.modelSet.getAtomsWithin (distance, plane);
}, "~N,org.jmol.util.Point4f");
Clazz.defineMethod (c$, "getAtomsWithinRadius", 
function (distance, bs, withinAllModels, rd) {
return this.modelSet.getAtomsWithinBs (distance, bs, withinAllModels, rd);
}, "~N,org.jmol.util.BitSet,~B,org.jmol.atomdata.RadiusData");
Clazz.defineMethod (c$, "getAtomsConnected", 
function (min, max, intType, bs) {
return this.modelSet.getAtomsConnected (min, max, intType, bs);
}, "~N,~N,~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getBranchBitSet", 
function (atomIndex, atomIndexNot) {
if (atomIndex < 0 || atomIndex >= this.getAtomCount ()) return  new org.jmol.util.BitSet ();
return org.jmol.util.JmolMolecule.getBranchBitSet (this.modelSet.atoms, atomIndex, this.getModelUndeletedAtomsBitSet (this.modelSet.atoms[atomIndex].modelIndex), null, atomIndexNot, true, true);
}, "~N,~N");
Clazz.defineMethod (c$, "getAtomIndexFromAtomNumber", 
function (atomNumber) {
return this.modelSet.getAtomIndexFromAtomNumber (atomNumber, this.getVisibleFramesBitSet ());
}, "~N");
Clazz.overrideMethod (c$, "getElementsPresentBitSet", 
function (modelIndex) {
return this.modelSet.getElementsPresentBitSet (modelIndex);
}, "~N");
Clazz.overrideMethod (c$, "getHeteroList", 
function (modelIndex) {
return this.modelSet.getHeteroList (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "getVisibleSet", 
function () {
return this.modelSet.getVisibleSet ();
});
Clazz.defineMethod (c$, "getClickableSet", 
function () {
return this.modelSet.getClickableSet ();
});
Clazz.defineMethod (c$, "calcSelectedGroupsCount", 
function () {
this.modelSet.calcSelectedGroupsCount (this.getSelectionSet (false));
});
Clazz.defineMethod (c$, "calcSelectedMonomersCount", 
function () {
this.modelSet.calcSelectedMonomersCount (this.getSelectionSet (false));
});
Clazz.defineMethod (c$, "calcSelectedMoleculesCount", 
function () {
this.modelSet.calcSelectedMoleculesCount (this.getSelectionSet (false));
});
Clazz.defineMethod (c$, "getFileHeader", 
function () {
return this.modelSet.getFileHeader (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "getFileData", 
function () {
return this.modelSet.getFileData (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "getCifData", 
function (modelIndex) {
var name = this.getModelFileName (modelIndex);
var data = this.getFileAsString (name);
if (data == null) return null;
return org.jmol.io.CifDataReader.readCifData ( new java.io.BufferedReader ( new java.io.StringReader (data)));
}, "~N");
Clazz.defineMethod (c$, "getPDBHeader", 
function () {
return this.modelSet.getPDBHeader (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "getModelInfo", 
function (atomExpression) {
return this.modelSet.getModelInfo (this.getModelBitSet (this.getAtomBitSet (atomExpression), false));
}, "~O");
Clazz.defineMethod (c$, "getLigandInfo", 
function (atomExpression) {
return this.modelSet.getLigandInfo (this.getAtomBitSet (atomExpression));
}, "~O");
Clazz.defineMethod (c$, "getAuxiliaryInfo", 
function (atomExpression) {
return this.modelSet.getAuxiliaryInfo (this.getModelBitSet (this.getAtomBitSet (atomExpression), false));
}, "~O");
Clazz.defineMethod (c$, "getAllAtomInfo", 
function (atomExpression) {
return this.modelSet.getAllAtomInfo (this.getAtomBitSet (atomExpression));
}, "~O");
Clazz.defineMethod (c$, "getAllBondInfo", 
function (atomExpression) {
return this.modelSet.getAllBondInfo (this.getAtomBitSet (atomExpression));
}, "~O");
Clazz.defineMethod (c$, "getMoleculeInfo", 
function (atomExpression) {
return this.modelSet.getMoleculeInfo (this.getAtomBitSet (atomExpression));
}, "~O");
Clazz.defineMethod (c$, "getChimeInfo", 
function (tok) {
return this.modelSet.getChimeInfo (tok, this.getSelectionSet (true));
}, "~N");
Clazz.defineMethod (c$, "getAllChainInfo", 
function (atomExpression) {
return this.modelSet.getAllChainInfo (this.getAtomBitSet (atomExpression));
}, "~O");
Clazz.defineMethod (c$, "getAllPolymerInfo", 
function (atomExpression) {
return this.modelSet.getAllPolymerInfo (this.getAtomBitSet (atomExpression));
}, "~O");
Clazz.defineMethod (c$, "getWrappedState", 
function (fileName, scripts, isImage, asJmolZip, width, height) {
if (isImage && !this.global.imageState && !asJmolZip || !this.global.preserveState) return "";
var s = this.getStateInfo (null, width, height);
if (asJmolZip) {
if (fileName != null) this.fileManager.clearPngjCache (fileName);
return org.jmol.io.JmolBinary.createZipSet (this.fileManager, this, null, s, scripts, true);
}try {
s = org.jmol.viewer.JmolConstants.embedScript (org.jmol.viewer.FileManager.setScriptFileReferences (s, ".", null, null));
} catch (e) {
org.jmol.util.Logger.error ("state could not be saved: " + e.getMessage ());
s = "Jmol " + org.jmol.viewer.Viewer.getJmolVersion ();
}
return s;
}, "~S,~A,~B,~B,~N,~N");
Clazz.defineMethod (c$, "getStateInfo", 
function () {
return this.getStateInfo (null, 0, 0);
});
Clazz.defineMethod (c$, "getStateInfo", 
function (type, width, height) {
if (!this.global.preserveState) return "";
var isAll = (type == null || type.equalsIgnoreCase ("all"));
var s =  new org.jmol.util.StringXBuilder ();
var sfunc = (isAll ?  new org.jmol.util.StringXBuilder ().append ("function _setState() {\n") : null);
if (isAll) s.append ("# Jmol state version " + org.jmol.viewer.Viewer.getJmolVersion () + ";\n");
if (this.$isApplet && isAll) {
org.jmol.viewer.StateManager.appendCmd (s, "# fullName = " + org.jmol.util.Escape.escapeStr (this.fullName));
org.jmol.viewer.StateManager.appendCmd (s, "# documentBase = " + org.jmol.util.Escape.escapeStr (this.appletDocumentBase));
org.jmol.viewer.StateManager.appendCmd (s, "# codeBase = " + org.jmol.util.Escape.escapeStr (this.appletCodeBase));
s.append ("\n");
}if (isAll || type.equalsIgnoreCase ("windowState")) s.append (this.global.getWindowState (sfunc, width, height));
if (isAll || type.equalsIgnoreCase ("fileState")) s.append (this.fileManager.getState (sfunc));
if (isAll || type.equalsIgnoreCase ("definedState")) s.append (this.modelSet.getDefinedState (sfunc, true));
if (isAll || type.equalsIgnoreCase ("variableState")) s.append (this.global.getState (sfunc));
if (isAll || type.equalsIgnoreCase ("dataState")) this.dataManager.getDataState (s, sfunc, this.modelSet.getAtomicPropertyState (-1, null));
if (isAll || type.equalsIgnoreCase ("modelState")) s.append (this.modelSet.getState (sfunc, true, this.getBooleanProperty ("saveProteinStructureState")));
if (isAll || type.equalsIgnoreCase ("colorState")) s.append (this.colorManager.getState (sfunc));
if (isAll || type.equalsIgnoreCase ("frameState")) s.append (this.animationManager.getState (sfunc));
if (isAll || type.equalsIgnoreCase ("perspectiveState")) s.append (this.transformManager.getState (sfunc));
if (isAll || type.equalsIgnoreCase ("selectionState")) s.append (this.selectionManager.getState (sfunc));
if (sfunc != null) {
org.jmol.viewer.StateManager.appendCmd (sfunc, "set refreshing true");
org.jmol.viewer.StateManager.appendCmd (sfunc, "set antialiasDisplay " + this.global.antialiasDisplay);
org.jmol.viewer.StateManager.appendCmd (sfunc, "set antialiasTranslucent " + this.global.antialiasTranslucent);
org.jmol.viewer.StateManager.appendCmd (sfunc, "set antialiasImages " + this.global.antialiasImages);
if (this.getSpinOn ()) org.jmol.viewer.StateManager.appendCmd (sfunc, "spin on");
sfunc.append ("}\n\n_setState;\n");
}if (isAll) s.appendSB (sfunc);
return s.toString ();
}, "~S,~N,~N");
Clazz.defineMethod (c$, "getStructureState", 
function () {
return this.modelSet.getState (null, false, true);
});
Clazz.defineMethod (c$, "getProteinStructureState", 
function () {
return this.modelSet.getProteinStructureState (this.getSelectionSet (false), false, false, 3);
});
Clazz.defineMethod (c$, "getCoordinateState", 
function (bsSelected) {
return this.modelSet.getAtomicPropertyState (2, bsSelected);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "setCurrentColorRange", 
function (label) {
var data = this.getDataFloat (label);
var bs = (data == null ? null : (this.dataManager.getData (label))[2]);
if (bs != null && this.isRangeSelected ()) bs.and (this.getSelectionSet (false));
this.setCurrentColorRangeData (data, bs);
}, "~S");
Clazz.defineMethod (c$, "setCurrentColorRangeData", 
function (data, bs) {
this.colorManager.setPropertyColorRangeData (data, bs, this.global.propertyColorScheme);
}, "~A,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "setCurrentColorRange", 
function (min, max) {
this.colorManager.setPropertyColorRange (min, max);
}, "~N,~N");
Clazz.defineMethod (c$, "setData", 
function (type, data, arrayCount, matchField, matchFieldColumnCount, field, fieldColumnCount) {
this.dataManager.setData (type, data, arrayCount, this.getAtomCount (), matchField, matchFieldColumnCount, field, fieldColumnCount);
}, "~S,~A,~N,~N,~N,~N,~N");
Clazz.defineMethod (c$, "getData", 
function (type) {
return this.dataManager.getData (type);
}, "~S");
Clazz.defineMethod (c$, "getDataFloat", 
function (label) {
return this.dataManager.getDataFloatA (label);
}, "~S");
Clazz.defineMethod (c$, "getDataFloat2D", 
function (label) {
return this.dataManager.getDataFloat2D (label);
}, "~S");
Clazz.defineMethod (c$, "getDataFloat3D", 
function (label) {
return this.dataManager.getDataFloat3D (label);
}, "~S");
Clazz.defineMethod (c$, "getDataFloatAt", 
function (label, atomIndex) {
return this.dataManager.getDataFloat (label, atomIndex);
}, "~S,~N");
Clazz.overrideMethod (c$, "getAltLocListInModel", 
function (modelIndex) {
return this.modelSet.getAltLocListInModel (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "setConformation", 
function () {
return this.modelSet.setConformation (this.getSelectionSet (false));
});
Clazz.defineMethod (c$, "getConformation", 
function (iModel, conformationIndex, doSet) {
return this.modelSet.getConformation (iModel, conformationIndex, doSet);
}, "~N,~N,~B");
Clazz.defineMethod (c$, "autoHbond", 
function (bsFrom, bsTo, onlyIfHaveCalculated) {
if (bsFrom == null) bsFrom = bsTo = this.getSelectionSet (false);
return this.modelSet.autoHbond (bsFrom, bsTo, onlyIfHaveCalculated);
}, "org.jmol.util.BitSet,org.jmol.util.BitSet,~B");
Clazz.defineMethod (c$, "getHbondsAngleMin", 
function () {
return this.global.hbondsAngleMinimum;
});
Clazz.defineMethod (c$, "getHbondsDistanceMax", 
function () {
return this.global.hbondsDistanceMaximum;
});
Clazz.defineMethod (c$, "getHbondsRasmol", 
function () {
return this.global.hbondsRasmol;
});
Clazz.overrideMethod (c$, "havePartialCharges", 
function () {
return this.modelSet.getPartialCharges () != null;
});
Clazz.defineMethod (c$, "getCurrentUnitCell", 
function () {
return this.modelSet.getUnitCell (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "getModelUnitCell", 
function (modelIndex) {
return this.modelSet.getUnitCell (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "getDefaultMeasurementLabel", 
function (nPoints) {
switch (nPoints) {
case 2:
return this.global.defaultDistanceLabel;
case 3:
return this.global.defaultAngleLabel;
default:
return this.global.defaultTorsionLabel;
}
}, "~N");
Clazz.overrideMethod (c$, "getMeasurementCount", 
function () {
var count = this.getShapePropertyAsInt (6, "count");
return count <= 0 ? 0 : count;
});
Clazz.overrideMethod (c$, "getMeasurementStringValue", 
function (i) {
var str = "" + this.getShapePropertyIndex (6, "stringValue", i);
return str;
}, "~N");
Clazz.defineMethod (c$, "getMeasurementInfo", 
function () {
return this.getShapeProperty (6, "info");
});
Clazz.defineMethod (c$, "getMeasurementInfoAsString", 
function () {
return this.getShapeProperty (6, "infostring");
});
Clazz.overrideMethod (c$, "getMeasurementCountPlusIndices", 
function (i) {
var List = this.getShapePropertyIndex (6, "countPlusIndices", i);
return List;
}, "~N");
Clazz.defineMethod (c$, "setPendingMeasurement", 
function (measurementPending) {
this.setShapeProperty (6, "pending", measurementPending);
}, "org.jmol.modelset.MeasurementPending");
Clazz.defineMethod (c$, "getPendingMeasurement", 
function () {
return this.getShapeProperty (6, "pending");
});
Clazz.defineMethod (c$, "clearAllMeasurements", 
function () {
this.setShapeProperty (6, "clear", null);
});
Clazz.overrideMethod (c$, "clearMeasurements", 
function () {
this.evalString ("measures delete");
});
Clazz.defineMethod (c$, "getJustifyMeasurements", 
function () {
return this.global.justifyMeasurements;
});
Clazz.defineMethod (c$, "setAnimation", 
function (tok) {
switch (tok) {
case 1073742098:
this.animationManager.reverseAnimation ();
case 1073742096:
case 266287:
if (!this.animationManager.$animationOn) this.animationManager.resumeAnimation ();
return;
case 20487:
if (this.animationManager.$animationOn && !this.animationManager.animationPaused) this.animationManager.pauseAnimation ();
return;
case 1073742037:
this.animationManager.setAnimationNext ();
return;
case 1073742108:
this.animationManager.setAnimationPrevious ();
return;
case 1073741942:
case 1073742126:
this.animationManager.rewindAnimation ();
return;
case 1073741993:
this.animationManager.setAnimationLast ();
return;
}
}, "~N");
Clazz.defineMethod (c$, "setAnimationDirection", 
function (direction) {
this.animationManager.setAnimationDirection (direction);
}, "~N");
Clazz.defineMethod (c$, "getAnimationDirection", 
function () {
return this.animationManager.animationDirection;
});
Clazz.defineMethod (c$, "getAnimationInfo", 
function () {
return this.animationManager.getAnimationInfo ();
});
Clazz.overrideMethod (c$, "setAnimationFps", 
function (fps) {
if (fps < 1) fps = 1;
if (fps > 50) fps = 50;
this.global.setParamI ("animationFps", fps);
this.animationManager.setAnimationFps (fps);
}, "~N");
Clazz.overrideMethod (c$, "getAnimationFps", 
function () {
return this.animationManager.animationFps;
});
Clazz.defineMethod (c$, "setAnimationReplayMode", 
function (replayMode, firstFrameDelay, lastFrameDelay) {
this.animationManager.setAnimationReplayMode (replayMode, firstFrameDelay, lastFrameDelay);
}, "org.jmol.constant.EnumAnimationMode,~N,~N");
Clazz.defineMethod (c$, "getAnimationReplayMode", 
function () {
return this.animationManager.animationReplayMode;
});
Clazz.defineMethod (c$, "setAnimationOn", 
function (animationOn) {
var wasAnimating = this.animationManager.$animationOn;
if (animationOn == wasAnimating) return;
this.animationManager.setAnimationOn (animationOn);
}, "~B");
Clazz.defineMethod (c$, "setAnimationRange", 
function (modelIndex1, modelIndex2) {
this.animationManager.setAnimationRange (modelIndex1, modelIndex2);
}, "~N,~N");
Clazz.overrideMethod (c$, "getVisibleFramesBitSet", 
function () {
var bs = org.jmol.util.BitSetUtil.copy (this.animationManager.getVisibleFramesBitSet ());
this.modelSet.selectDisplayedTrajectories (bs);
return bs;
});
Clazz.defineMethod (c$, "isAnimationOn", 
function () {
return this.animationManager.$animationOn;
});
Clazz.defineMethod (c$, "setCurrentModelIndex", 
function (modelIndex) {
if (modelIndex == -2147483648) {
this.prevFrame = -2147483648;
this.setCurrentModelIndexClear (this.animationManager.currentModelIndex, true);
return;
}this.animationManager.setCurrentModelIndex (modelIndex, true);
}, "~N");
Clazz.defineMethod (c$, "setTrajectory", 
function (modelIndex) {
this.modelSet.setTrajectory (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "setTrajectoryBs", 
function (bsModels) {
this.modelSet.setTrajectoryBs (bsModels);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "isTrajectory", 
function (modelIndex) {
return this.modelSet.isTrajectory (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "getBitSetTrajectories", 
function () {
return this.modelSet.getBitSetTrajectories ();
});
Clazz.defineMethod (c$, "getTrajectoryInfo", 
function () {
return this.modelSet.getTrajectoryInfo ();
});
Clazz.defineMethod (c$, "setFrameOffset", 
function (modelIndex) {
this.transformManager.setFrameOffset (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "setFrameOffsets", 
function (bsAtoms) {
this.bsFrameOffsets = bsAtoms;
this.transformManager.setFrameOffsets (this.frameOffsets = this.modelSet.getFrameOffsets (this.bsFrameOffsets));
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getFrameOffsets", 
function () {
return this.bsFrameOffsets;
});
Clazz.defineMethod (c$, "setCurrentModelIndexClear", 
function (modelIndex, clearBackground) {
this.animationManager.setCurrentModelIndex (modelIndex, clearBackground);
}, "~N,~B");
Clazz.defineMethod (c$, "getCurrentModelIndex", 
function () {
return this.animationManager.currentModelIndex;
});
Clazz.overrideMethod (c$, "getDisplayModelIndex", 
function () {
return this.animationManager.currentModelIndex;
});
Clazz.defineMethod (c$, "haveFileSet", 
function () {
return (this.getModelCount () > 1 && this.getModelNumber (2147483647) > 2000000);
});
Clazz.defineMethod (c$, "setBackgroundModelIndex", 
function (modelIndex) {
this.animationManager.setBackgroundModelIndex (modelIndex);
this.global.setParamS ("backgroundModel", this.modelSet.getModelNumberDotted (modelIndex));
}, "~N");
Clazz.defineMethod (c$, "setFrameVariables", 
function () {
this.global.setParamS ("_firstFrame", this.getModelNumberDotted (this.animationManager.firstModelIndex));
this.global.setParamS ("_lastFrame", this.getModelNumberDotted (this.animationManager.lastModelIndex));
this.global.setParamF ("_animTimeSec", this.animationManager.getAnimRunTimeSeconds ());
});
Clazz.overrideMethod (c$, "getMotionEventNumber", 
function () {
return this.motionEventNumber;
});
Clazz.overrideMethod (c$, "setInMotion", 
function (inMotion) {
if ( new Boolean (this.wasInMotion ^ inMotion).valueOf ()) {
this.animationManager.inMotion = inMotion;
if (inMotion) {
this.startHoverWatcher (false);
++this.motionEventNumber;
} else {
this.startHoverWatcher (true);
this.refresh (3, "viewer stInMotion " + inMotion);
}this.wasInMotion = inMotion;
}}, "~B");
Clazz.defineMethod (c$, "getInMotion", 
function () {
return this.animationManager.inMotion;
});
Clazz.defineMethod (c$, "setRefreshing", 
($fz = function (TF) {
this.refreshing = TF;
}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "getRefreshing", 
function () {
return this.refreshing;
});
Clazz.overrideMethod (c$, "pushHoldRepaint", 
function () {
this.pushHoldRepaintWhy (null);
});
Clazz.defineMethod (c$, "pushHoldRepaintWhy", 
function (why) {
if (this.repaintManager != null) {
this.repaintManager.pushHoldRepaint ();
}}, "~S");
Clazz.overrideMethod (c$, "popHoldRepaint", 
function () {
if (this.repaintManager != null) {
this.repaintManager.popHoldRepaint (true);
}});
Clazz.defineMethod (c$, "popHoldRepaintWhy", 
function (why) {
if (this.repaintManager != null) {
this.repaintManager.popHoldRepaint (!why.equals ("pause"));
}}, "~S");
Clazz.overrideMethod (c$, "refresh", 
function (mode, strWhy) {
if (this.repaintManager == null || !this.refreshing) return;
if (mode == 6 && this.getInMotion ()) return;
{
if (typeof Jmol == "undefined") return;
if (this.isJS2D) {
if (mode == 7)return;
if (mode > 0) this.repaintManager.repaintIfReady();
} else if (mode == 2 || mode == 7) {
this.transformManager.finalizeTransformParameters();
if (Jmol._refresh)
Jmol._refresh(this.applet, mode, strWhy,
[this.transformManager.fixedRotationCenter,
this.transformManager.getRotationQuaternion(),
this.transformManager.xTranslationFraction,
this.transformManager.yTranslationFraction,
this.transformManager.modelRadius,
this.transformManager.scalePixelsPerAngstrom,
this.transformManager.zoomPercent
]);
if (mode == 7)return;
}
}if (mode % 3 != 0 && this.statusManager.doSync ()) this.statusManager.setSync (mode == 2 ? strWhy : null);
}, "~N,~S");
Clazz.defineMethod (c$, "requestRepaintAndWait", 
function () {
if (!this.haveDisplay || this.repaintManager == null) return;
this.repaintManager.requestRepaintAndWait ();
this.setSync ();
});
Clazz.defineMethod (c$, "clearShapeRenderers", 
function () {
this.clearRepaintManager (-1);
});
Clazz.defineMethod (c$, "isRepaintPending", 
function () {
return (this.repaintManager == null ? false : this.repaintManager.isRepaintPending ());
});
Clazz.overrideMethod (c$, "notifyViewerRepaintDone", 
function () {
if (this.repaintManager != null) this.repaintManager.repaintDone ();
this.animationManager.repaintDone ();
});
Clazz.defineMethod (c$, "areAxesTainted", 
function () {
var TF = this.axesAreTainted;
this.axesAreTainted = false;
return TF;
});
Clazz.defineMethod (c$, "setMaximumSize", 
($fz = function (x) {
this.maximumSize = Math.max (x, 100);
}, $fz.isPrivate = true, $fz), "~N");
Clazz.overrideMethod (c$, "setScreenDimension", 
function (width, height) {
height = Math.min (height, this.maximumSize);
width = Math.min (width, this.maximumSize);
if (this.isStereoDouble ()) width = Clazz.doubleToInt ((width + 1) / 2);
if (this.dimScreen.width == width && this.dimScreen.height == height) return;
this.resizeImage (width, height, false, false, true);
}, "~N,~N");
Clazz.defineMethod (c$, "getImageFontScaling", 
function () {
return this.imageFontScaling;
});
Clazz.defineMethod (c$, "resizeImage", 
($fz = function (width, height, isImageWrite, isExport, isReset) {
if (!isImageWrite && this.creatingImage) return;
if (!isExport && !isImageWrite) this.setShapeProperty (5, "clearBoxes", null);
this.antialiasDisplay = (isReset ? this.global.antialiasDisplay : isImageWrite && !isExport ? this.global.antialiasImages : false);
this.imageFontScaling = (isReset || width <= 0 ? 1 : Clazz.doubleToInt ((this.global.zoomLarge == (height > width) ? height : width) / this.getScreenDim ())) * (this.antialiasDisplay ? 2 : 1);
if (width > 0) {
this.dimScreen.width = width;
this.dimScreen.height = height;
if (!isImageWrite) {
this.global.setParamI ("_width", width);
this.global.setParamI ("_height", height);
this.setStatusResized (width, height);
}} else {
width = this.dimScreen.width;
height = this.dimScreen.height;
}this.transformManager.setScreenParameters (width, height, isImageWrite || isReset ? this.global.zoomLarge : false, this.antialiasDisplay, false, false);
this.gdata.setWindowParameters (width, height, this.antialiasDisplay);
}, $fz.isPrivate = true, $fz), "~N,~N,~B,~B,~B");
Clazz.overrideMethod (c$, "getScreenWidth", 
function () {
return this.dimScreen.width;
});
Clazz.overrideMethod (c$, "getScreenHeight", 
function () {
return this.dimScreen.height;
});
Clazz.defineMethod (c$, "getScreenDim", 
function () {
return (this.global.zoomLarge == (this.dimScreen.height > this.dimScreen.width) ? this.dimScreen.height : this.dimScreen.width);
});
Clazz.overrideMethod (c$, "generateOutput", 
function (type, fileName, width, height) {
if (this.$noGraphicsAllowed || this.repaintManager == null) return null;
var fName = null;
if (fileName != null) {
fileName[0] = this.getFileNameFromDialog (fileName[0], -2147483648);
if (fileName[0] == null) return null;
fName = fileName[0];
}this.mustRender = true;
var saveWidth = this.dimScreen.width;
var saveHeight = this.dimScreen.height;
this.resizeImage (width, height, true, true, false);
this.setModelVisibility ();
var data = this.repaintManager.renderExport (type, this.gdata, this.modelSet, fName);
this.resizeImage (saveWidth, saveHeight, true, true, true);
return data;
}, "~S,~A,~N,~N");
Clazz.defineMethod (c$, "clearRepaintManager", 
($fz = function (iShape) {
if (this.repaintManager != null) this.repaintManager.clear (iShape);
}, $fz.isPrivate = true, $fz), "~N");
Clazz.overrideMethod (c$, "renderScreenImageStereo", 
function (gLeft, gRight, width, height) {
if (this.updateWindow (width, height)) {
if (gRight == null) {
this.getScreenImageBuffer (gLeft);
} else {
this.render1 (gRight, this.getImage (true), 0, 0);
this.render1 (gLeft, this.getImage (false), 0, 0);
}}this.notifyViewerRepaintDone ();
}, "~O,~O,~N,~N");
Clazz.defineMethod (c$, "updateJS", 
function (width, height) {
{
if (this.isJS2D) {
this.renderScreenImageStereo(this.apiPlatform.context, null, width, height);
return;
}
if (this.updateWindow(width, height)){ this.render(); }
this.notifyViewerRepaintDone();
}}, "~N,~N");
Clazz.defineMethod (c$, "updateWindow", 
($fz = function (width, height) {
if (!this.refreshing || this.creatingImage) return false;
if (this.isTainted || this.getSlabEnabled ()) this.setModelVisibility ();
this.isTainted = false;
if (this.repaintManager != null) {
if (width != 0) this.setScreenDimension (width, height);
}return true;
}, $fz.isPrivate = true, $fz), "~N,~N");
Clazz.defineMethod (c$, "renderScreenImage", 
function (g, width, height) {
this.renderScreenImageStereo (g, null, width, height);
}, "~O,~N,~N");
Clazz.defineMethod (c$, "getImage", 
($fz = function (isDouble) {
{
if (!this.isJS2D)return null;
}var image = null;
try {
this.gdata.beginRendering (this.transformManager.getStereoRotationMatrix (isDouble));
this.render ();
this.gdata.endRendering ();
image = this.gdata.getScreenImage ();
} catch (er) {
if (Clazz.exceptionOf (er, Error)) {
this.handleError (er, false);
this.setErrorMessage ("Error during rendering: " + er, null);
} else {
throw er;
}
}
return image;
}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "isAntialiased", 
function () {
return this.antialiasDisplay;
});
Clazz.defineMethod (c$, "render", 
($fz = function () {
if (this.modelSet == null || !this.mustRender || !this.refreshing && !this.creatingImage || this.repaintManager == null) return;
var antialias2 = this.antialiasDisplay && this.global.antialiasTranslucent;
this.finalizeTransformParameters ();
this.shapeManager.finalizeAtoms (this.transformManager.bsSelectedAtoms, this.transformManager.ptOffset);
var minMax = this.shapeManager.transformAtoms ();
this.transformManager.bsSelectedAtoms = null;
{
if (!this.isJS2D) { this.repaintManager.renderExport("JS",
this.gdata, this.modelSet, null);
this.notifyViewerRepaintDone(); return; }
}this.repaintManager.render (this.gdata, this.modelSet, true, minMax);
if (this.gdata.setPass2 (antialias2)) {
this.transformManager.setAntialias (antialias2);
this.repaintManager.render (this.gdata, this.modelSet, false, null);
this.transformManager.setAntialias (this.antialiasDisplay);
}}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "getStereoImage", 
($fz = function (stereoMode) {
this.gdata.beginRendering (this.transformManager.getStereoRotationMatrix (true));
this.render ();
this.gdata.endRendering ();
this.gdata.snapshotAnaglyphChannelBytes ();
this.gdata.beginRendering (this.transformManager.getStereoRotationMatrix (false));
this.render ();
this.gdata.endRendering ();
this.gdata.applyAnaglygh (stereoMode, this.transformManager.stereoColors);
return this.gdata.getScreenImage ();
}, $fz.isPrivate = true, $fz), "org.jmol.constant.EnumStereoMode");
Clazz.defineMethod (c$, "render1", 
($fz = function (graphic, img, x, y) {
if (graphic != null && img != null) {
this.apiPlatform.drawImage (graphic, img, x, y, this.dimScreen.width, this.dimScreen.height);
}this.gdata.releaseScreenImage ();
}, $fz.isPrivate = true, $fz), "~O,~O,~N,~N");
Clazz.overrideMethod (c$, "getScreenImageBuffer", 
function (graphic) {
{
if (!this.isJS2D)return null
}{
var mergeImages = (graphic == null && this.isStereoDouble ());
var imageBuffer = (this.transformManager.stereoMode.isBiColor () ? this.getStereoImage (this.transformManager.stereoMode) : this.getImage (this.isStereoDouble ()));
var imageBuffer2 = null;
if (mergeImages) {
imageBuffer2 = this.apiPlatform.newBufferedImage (imageBuffer, this.dimScreen.width << 1, this.dimScreen.height);
graphic = this.apiPlatform.getGraphics (imageBuffer2);
}if (graphic != null) {
if (this.isStereoDouble ()) {
this.render1 (graphic, imageBuffer, this.dimScreen.width, 0);
imageBuffer = this.getImage (false);
}this.render1 (graphic, imageBuffer, 0, 0);
}return (mergeImages ? imageBuffer2 : imageBuffer);
}}, "~O");
Clazz.overrideMethod (c$, "getImageAs", 
function (type, quality, width, height, fileName, os) {
{
if (!this.isJS2D)return null
}return this.getImageAsWithComment (type, quality, width, height, fileName, null, os, "");
}, "~S,~N,~N,~N,~S,java.io.OutputStream");
Clazz.defineMethod (c$, "getImageAsWithComment", 
function (type, quality, width, height, fileName, scripts, os, comment) {
{
if (!this.isJS2D)return null
}var saveWidth = this.dimScreen.width;
var saveHeight = this.dimScreen.height;
this.mustRender = true;
this.resizeImage (width, height, true, false, false);
this.setModelVisibility ();
this.creatingImage = true;
var c = null;
var bytes = null;
type = type.toLowerCase ();
if (!org.jmol.util.Parser.isOneOf (type, "jpg;jpeg;jpg64;jpeg64")) try {
c = org.jmol.api.Interface.getOptionInterface ("export.image.ImageCreator");
} catch (er) {
if (Clazz.exceptionOf (er, Error)) {
} else {
throw er;
}
}
if (c == null) {
try {
bytes = this.apiPlatform.getJpgImage (this, quality, comment);
if (type.equals ("jpg64") || type.equals ("jpeg64")) bytes = (bytes == null ? "" : org.jmol.io.Base64.getBase64 (bytes).toString ());
} catch (er) {
if (Clazz.exceptionOf (er, Error)) {
this.releaseScreenImage ();
this.handleError (er, false);
this.setErrorMessage ("Error creating image: " + er, null);
bytes = this.getErrorMessage ();
} else {
throw er;
}
}
} else {
c.setViewer (this, this.privateKey);
try {
bytes = c.getImageBytes (type, quality, fileName, scripts, null, os);
} catch (e$$) {
if (Clazz.exceptionOf (e$$, java.io.IOException)) {
var e = e$$;
{
bytes = e;
this.setErrorMessage ("Error creating image: " + e, null);
}
} else if (Clazz.exceptionOf (e$$, Error)) {
var er = e$$;
{
this.handleError (er, false);
this.setErrorMessage ("Error creating image: " + er, null);
bytes = this.getErrorMessage ();
}
} else {
throw e$$;
}
}
}this.creatingImage = false;
this.resizeImage (saveWidth, saveHeight, true, false, true);
return bytes;
}, "~S,~N,~N,~N,~S,~A,java.io.OutputStream,~S");
Clazz.overrideMethod (c$, "releaseScreenImage", 
function () {
this.gdata.releaseScreenImage ();
});
Clazz.defineMethod (c$, "getAllowEmbeddedScripts", 
function () {
return this.global.allowEmbeddedScripts && !this.$isPreviewOnly;
});
Clazz.overrideMethod (c$, "evalFile", 
function (strFilename) {
var ptWait = strFilename.indexOf (" -noqueue");
if (ptWait >= 0) {
return this.evalStringWaitStatusQueued ("String", strFilename.substring (0, ptWait), "", true, false, false);
}return this.scriptManager.addScript (strFilename, true, false);
}, "~S");
Clazz.defineMethod (c$, "getInsertedCommand", 
function () {
var s = this.insertedCommand;
this.insertedCommand = "";
if (org.jmol.util.Logger.debugging && s !== "") org.jmol.util.Logger.debug ("inserting: " + s);
return s;
});
Clazz.overrideMethod (c$, "script", 
function (strScript) {
return this.evalStringQuietSync (strScript, false, true);
}, "~S");
Clazz.overrideMethod (c$, "evalString", 
function (strScript) {
return this.evalStringQuietSync (strScript, false, true);
}, "~S");
Clazz.overrideMethod (c$, "evalStringQuiet", 
function (strScript) {
return this.evalStringQuietSync (strScript, true, true);
}, "~S");
Clazz.defineMethod (c$, "evalStringQuietSync", 
function (strScript, isQuiet, allowSyncScript) {
if (allowSyncScript && this.statusManager.syncingScripts && strScript.indexOf ("#NOSYNC;") < 0) this.syncScript (strScript + " #NOSYNC;", null, 0);
if (this.eval.isExecutionPaused () && strScript.charAt (0) != '!') strScript = '!' + org.jmol.util.TextFormat.trim (strScript, "\n\r\t ");
var isInsert = (strScript.length > 0 && strScript.charAt (0) == '!');
if (isInsert) strScript = strScript.substring (1);
var msg = this.checkScriptExecution (strScript, isInsert);
if (msg != null) return msg;
if (this.isScriptExecuting () && (isInsert || this.eval.isExecutionPaused ())) {
this.insertedCommand = strScript;
if (strScript.indexOf ("moveto ") == 0) this.scriptManager.flushQueue ("moveto ");
return "!" + strScript;
}this.insertedCommand = "";
if (isQuiet) strScript += "\u0001## EDITOR_IGNORE ##";
return this.scriptManager.addScript (strScript, false, isQuiet && !this.getMessageStyleChime ());
}, "~S,~B,~B");
Clazz.defineMethod (c$, "checkScriptExecution", 
($fz = function (strScript, isInsert) {
var str = strScript;
if (str.indexOf ("\1##") >= 0) str = str.substring (0, str.indexOf ("\1##"));
if (this.checkResume (str)) return "script processing resumed";
if (this.checkStepping (str)) return "script processing stepped";
if (this.checkHalt (str, isInsert)) return "script execution halted";
return null;
}, $fz.isPrivate = true, $fz), "~S,~B");
Clazz.defineMethod (c$, "usingScriptQueue", 
function () {
return this.global.useScriptQueue;
});
Clazz.defineMethod (c$, "clearScriptQueue", 
function () {
this.scriptManager.clearQueue ();
});
Clazz.defineMethod (c$, "setScriptQueue", 
($fz = function (TF) {
this.global.useScriptQueue = TF;
if (!TF) this.clearScriptQueue ();
}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "checkResume", 
function (str) {
if (str.equalsIgnoreCase ("resume")) {
this.setScriptStatus ("", "execution resumed", 0, null);
this.resumeScriptExecution ();
return true;
}return false;
}, "~S");
Clazz.defineMethod (c$, "checkStepping", 
function (str) {
if (str.equalsIgnoreCase ("step")) {
this.stepScriptExecution ();
return true;
}if (str.equalsIgnoreCase ("?")) {
this.scriptStatus (this.eval.getNextStatement ());
return true;
}return false;
}, "~S");
Clazz.overrideMethod (c$, "checkHalt", 
function (str, isInsert) {
if (str.equalsIgnoreCase ("pause")) {
this.pauseScriptExecution ();
if (this.scriptEditorVisible) this.setScriptStatus ("", "paused -- type RESUME to continue", 0, null);
return true;
}if (str.equalsIgnoreCase ("menu")) {
this.getProperty ("DATA_API", "getPopupMenu", "\0");
return true;
}str = str.toLowerCase ();
var exitScript = false;
var haltType = null;
if (str.startsWith ("exit")) {
this.haltScriptExecution ();
this.clearScriptQueue ();
this.clearTimeouts ();
exitScript = str.equals (haltType = "exit");
} else if (str.startsWith ("quit")) {
this.haltScriptExecution ();
exitScript = str.equals (haltType = "quit");
}if (haltType == null) return false;
if (isInsert) {
this.clearThreads ();
this.queueOnHold = false;
}if (isInsert || this.waitForMoveTo ()) {
this.stopMotion ();
}org.jmol.util.Logger.info (this.isSyntaxCheck ? haltType + " -- stops script checking" : (isInsert ? "!" : "") + haltType + " received");
this.isSyntaxCheck = false;
return exitScript;
}, "~S,~B");
Clazz.overrideMethod (c$, "scriptWait", 
function (strScript) {
return this.evalWait ("JSON", strScript, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated", false);
}, "~S");
Clazz.overrideMethod (c$, "scriptWaitStatus", 
function (strScript, statusList) {
return this.evalWait ("object", strScript, statusList, false);
}, "~S,~S");
Clazz.defineMethod (c$, "evalStringWaitStatus", 
function (returnType, strScript, statusList) {
return this.evalWait (returnType, strScript, statusList, true);
}, "~S,~S,~S");
Clazz.defineMethod (c$, "evalWait", 
($fz = function (returnType, strScript, statusList, doTranslate) {
this.scriptManager.waitForQueue ();
var doTranslateTemp = org.jmol.i18n.GT.getDoTranslate ();
if (!doTranslate) org.jmol.i18n.GT.setDoTranslate (false);
var ret = this.evalStringWaitStatusQueued (returnType, strScript, statusList, false, false, false);
if (!doTranslate) org.jmol.i18n.GT.setDoTranslate (doTranslateTemp);
return ret;
}, $fz.isPrivate = true, $fz), "~S,~S,~S,~B");
Clazz.defineMethod (c$, "evalStringWaitStatusQueued", 
function (returnType, strScript, statusList, isScriptFile, isQuiet, isQueued) {
if (strScript == null) return null;
var str = this.checkScriptExecution (strScript, false);
if (str != null) return str;
var outputBuffer = (statusList == null || statusList.equals ("output") ?  new org.jmol.util.StringXBuilder () : null);
var oldStatusList = this.statusManager.getStatusList ();
this.getProperty ("String", "jmolStatus", statusList);
if (this.isSyntaxCheck) org.jmol.util.Logger.info ("--checking script:\n" + this.eval.getScript () + "\n----\n");
var historyDisabled = (strScript.indexOf (")") == 0);
if (historyDisabled) strScript = strScript.substring (1);
historyDisabled = historyDisabled || !isQueued;
this.setErrorMessage (null, null);
var isOK = (isScriptFile ? this.eval.compileScriptFile (strScript, isQuiet) : this.eval.compileScriptString (strScript, isQuiet));
var strErrorMessage = this.eval.getErrorMessage ();
var strErrorMessageUntranslated = this.eval.getErrorMessageUntranslated ();
this.setErrorMessage (strErrorMessage, strErrorMessageUntranslated);
this.refresh (7, "script complete");
if (isOK) {
this.isScriptQueued = isQueued;
if (!isQuiet) this.setScriptStatus (null, strScript, -2 - (++this.scriptIndex), null);
this.eval.evaluateCompiledScript (this.isSyntaxCheck, this.isSyntaxAndFileCheck, historyDisabled, this.listCommands, outputBuffer, isQueued || !this.isSingleThreaded);
} else {
this.scriptStatus (strErrorMessage);
this.setScriptStatus ("Jmol script terminated", strErrorMessage, 1, strErrorMessageUntranslated);
this.setStateScriptVersion (null);
}if (strErrorMessage != null && this.autoExit) this.exitJmol ();
if (this.isSyntaxCheck) {
if (strErrorMessage == null) org.jmol.util.Logger.info ("--script check ok");
 else org.jmol.util.Logger.error ("--script check error\n" + strErrorMessageUntranslated);
org.jmol.util.Logger.info ("(use 'exit' to stop checking)");
}this.isScriptQueued = true;
if (returnType.equalsIgnoreCase ("String")) return strErrorMessageUntranslated;
if (outputBuffer != null) return (strErrorMessageUntranslated == null ? outputBuffer.toString () : strErrorMessageUntranslated);
var info = this.getProperty (returnType, "jmolStatus", statusList);
this.getProperty ("object", "jmolStatus", oldStatusList);
return info;
}, "~S,~S,~S,~B,~B,~B");
Clazz.defineMethod (c$, "exitJmol", 
function () {
if (this.$isApplet) return;
if (this.headlessImage != null) {
try {
var p = this.headlessImage;
if (this.isHeadless ()) this.createImage (p[0], p[1], null, (p[2]).intValue (), (p[3]).intValue (), (p[4]).intValue ());
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
}org.jmol.util.Logger.debug ("exitJmol -- exiting");
System.out.flush ();
System.exit (0);
});
Clazz.defineMethod (c$, "scriptCheckRet", 
($fz = function (strScript, returnContext) {
if (strScript.indexOf (")") == 0 || strScript.indexOf ("!") == 0) strScript = strScript.substring (1);
var sc = ( new org.jmol.script.ScriptEvaluator (this)).checkScriptSilent (strScript);
if (returnContext || sc.errorMessage == null) return sc;
return sc.errorMessage;
}, $fz.isPrivate = true, $fz), "~S,~B");
Clazz.overrideMethod (c$, "scriptCheck", 
function (strScript) {
return this.scriptCheckRet (strScript, false);
}, "~S");
Clazz.overrideMethod (c$, "isScriptExecuting", 
function () {
return this.eval.isScriptExecuting ();
});
Clazz.overrideMethod (c$, "haltScriptExecution", 
function () {
this.eval.haltExecution ();
this.setStringPropertyTok ("pathForAllFiles", 545259570, "");
this.clearTimeouts ();
});
Clazz.defineMethod (c$, "resumeScriptExecution", 
function () {
this.eval.resumePausedExecution ();
});
Clazz.defineMethod (c$, "stepScriptExecution", 
function () {
this.eval.stepPausedExecution ();
});
Clazz.defineMethod (c$, "pauseScriptExecution", 
function () {
this.eval.pauseExecution (true);
});
Clazz.defineMethod (c$, "getDefaultLoadFilter", 
function () {
return this.global.defaultLoadFilter;
});
Clazz.defineMethod (c$, "getDefaultLoadScript", 
function () {
return this.global.defaultLoadScript;
});
Clazz.defineMethod (c$, "resolveDatabaseFormat", 
function (fileName) {
if (org.jmol.viewer.Viewer.hasDatabasePrefix (fileName)) fileName = this.setLoadFormat (fileName, fileName.charAt (0), false);
return fileName;
}, "~S");
c$.isDatabaseCode = Clazz.defineMethod (c$, "isDatabaseCode", 
function (ch) {
return (ch == '$' || ch == '=' || ch == ':');
}, "~S");
c$.hasDatabasePrefix = Clazz.defineMethod (c$, "hasDatabasePrefix", 
function (fileName) {
return (fileName.length != 0 && org.jmol.viewer.Viewer.isDatabaseCode (fileName.charAt (0)));
}, "~S");
Clazz.defineMethod (c$, "setLoadFormat", 
function (name, type, withPrefix) {
var format;
var f = name.substring (1);
switch (type) {
case '=':
case '#':
if (name.startsWith ("==")) {
f = f.substring (1);
type = '#';
}var s = (type == '=' ? this.global.loadFormat : this.global.loadLigandFormat);
if (f.indexOf (".") > 0 && s.indexOf ("%FILE.") >= 0) s = s.substring (0, s.indexOf ("%FILE") + 5);
return org.jmol.util.TextFormat.formatStringS (s, "FILE", f);
case ':':
format = this.global.pubChemFormat;
var fl = f.toLowerCase ();
try {
f = "cid/" + String.valueOf (Integer.$valueOf (f).intValue ());
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
if (fl.startsWith ("smiles:")) {
format += "?POST?smiles=" + f.substring (7);
f = "smiles";
} else if (fl.startsWith ("cid:")) {
f = "cid/" + f.substring (4);
} else {
if (fl.startsWith ("name:")) f = f.substring (5);
if (fl.startsWith ("cas:")) f = f.substring (4);
f = "name/" + org.jmol.util.Escape.escapeUrl (f);
}} else {
throw e;
}
}
return org.jmol.util.TextFormat.formatStringS (format, "FILE", f);
case '$':
if (f.startsWith ("$")) {
f = f.substring (1);
format = org.jmol.util.TextFormat.simpleReplace (this.global.smilesUrlFormat, "&get3d=True", "");
return org.jmol.util.TextFormat.formatStringS (format, "FILE", org.jmol.util.Escape.escapeUrl (f));
}case 'N':
case '2':
case 'I':
case 'K':
case '/':
f = org.jmol.util.Escape.escapeUrl (f);
switch (type) {
case 'N':
format = this.global.nihResolverFormat + "/names";
break;
case '2':
format = this.global.nihResolverFormat + "/image";
break;
case 'I':
format = this.global.nihResolverFormat + "/stdinchi";
break;
case 'K':
format = this.global.nihResolverFormat + "/inchikey";
break;
case '/':
format = this.global.nihResolverFormat + "/";
break;
default:
format = this.global.smilesUrlFormat;
break;
}
return (withPrefix ? "MOL3D::" : "") + org.jmol.util.TextFormat.formatStringS (format, "FILE", f);
case '_':
var server = org.jmol.viewer.FileManager.fixFileNameVariables (this.global.edsUrlFormat, f);
var strCutoff = org.jmol.viewer.FileManager.fixFileNameVariables (this.global.edsUrlCutoff, f);
return [server, strCutoff];
}
return name.substring (1);
}, "~S,~S,~B");
Clazz.defineMethod (c$, "getElectronDensityLoadInfo", 
function () {
return [this.global.edsUrlFormat, this.global.edsUrlCutoff, this.global.edsUrlOptions];
});
Clazz.defineMethod (c$, "getStandardLabelFormat", 
function (type) {
switch (type) {
default:
case 0:
return "%[identify]";
case 1:
return this.global.defaultLabelXYZ;
case 2:
return this.global.defaultLabelPDB;
}
}, "~N");
Clazz.defineMethod (c$, "getRibbonAspectRatio", 
function () {
return this.global.ribbonAspectRatio;
});
Clazz.defineMethod (c$, "getSheetSmoothing", 
function () {
return this.global.sheetSmoothing;
});
Clazz.defineMethod (c$, "getSsbondsBackbone", 
function () {
return this.global.ssbondsBackbone;
});
Clazz.defineMethod (c$, "getHbondsBackbone", 
function () {
return this.global.hbondsBackbone;
});
Clazz.defineMethod (c$, "getHbondsSolid", 
function () {
return this.global.hbondsSolid;
});
Clazz.defineMethod (c$, "getAdditionalHydrogens", 
function (bsAtoms, doAll, justCarbon, vConnections) {
if (bsAtoms == null) bsAtoms = this.getSelectionSet (false);
var nTotal =  Clazz.newIntArray (1, 0);
var pts = this.modelSet.calculateHydrogens (bsAtoms, nTotal, doAll, justCarbon, vConnections);
var points =  new Array (nTotal[0]);
for (var i = 0, pt = 0; i < pts.length; i++) if (pts[i] != null) for (var j = 0; j < pts[i].length; j++) points[pt++] = pts[i][j];


return points;
}, "org.jmol.util.BitSet,~B,~B,java.util.List");
Clazz.defineMethod (c$, "addHydrogens", 
function (bsAtoms, asScript, isSilent) {
var doAll = (bsAtoms == null);
if (bsAtoms == null) bsAtoms = this.getModelUndeletedAtomsBitSet (this.getVisibleFramesBitSet ().length () - 1);
var bsB =  new org.jmol.util.BitSet ();
if (bsAtoms.cardinality () == 0) return bsB;
var modelIndex = this.modelSet.atoms[bsAtoms.nextSetBit (0)].modelIndex;
if (modelIndex != this.modelSet.getModelCount () - 1) return bsB;
var vConnections =  new java.util.ArrayList ();
var pts = this.getAdditionalHydrogens (bsAtoms, doAll, false, vConnections);
var wasAppendNew = false;
wasAppendNew = this.getAppendNew ();
if (pts.length > 0) {
this.clearModelDependentObjects ();
try {
bsB = (asScript ? this.modelSet.addHydrogens (vConnections, pts) : this.addHydrogensInline (bsAtoms, vConnections, pts));
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
System.out.println (e.getMessage ());
} else {
throw e;
}
}
if (wasAppendNew) this.setAppendNew (true);
}if (!isSilent) this.scriptStatus (org.jmol.i18n.GT._ ("{0} hydrogens added", pts.length));
return bsB;
}, "org.jmol.util.BitSet,~B,~B");
Clazz.defineMethod (c$, "addHydrogensInline", 
($fz = function (bsAtoms, vConnections, pts) {
var modelIndex = this.getAtomModelIndex (bsAtoms.nextSetBit (0));
if (modelIndex != this.modelSet.getModelCount () - 1) return  new org.jmol.util.BitSet ();
var bsA = this.getModelUndeletedAtomsBitSet (modelIndex);
this.setAppendNew (false);
var atomIndex = this.modelSet.getAtomCount ();
var atomno = this.modelSet.getAtomCountInModel (modelIndex);
var sbConnect =  new org.jmol.util.StringXBuilder ();
for (var i = 0; i < vConnections.size (); i++) {
var a = vConnections.get (i);
sbConnect.append (";  connect 0 100 ").append ("({" + (atomIndex++) + "}) ").append ("({" + a.index + "}) group;");
}
var sb =  new org.jmol.util.StringXBuilder ();
sb.appendI (pts.length).append ("\n").append ("Viewer.AddHydrogens").append ("#noautobond").append ("\n");
for (var i = 0; i < pts.length; i++) sb.append ("H ").appendF (pts[i].x).append (" ").appendF (pts[i].y).append (" ").appendF (pts[i].z).append (" - - - - ").appendI (++atomno).appendC ('\n');

this.loadInlineScript (sb.toString (), '\n', true, null);
this.eval.runScriptBuffer (sbConnect.toString (), null);
var bsB = this.getModelUndeletedAtomsBitSet (modelIndex);
bsB.andNot (bsA);
return bsB;
}, $fz.isPrivate = true, $fz), "org.jmol.util.BitSet,java.util.List,~A");
Clazz.overrideMethod (c$, "setMarBond", 
function (marBond) {
this.global.bondRadiusMilliAngstroms = marBond;
this.global.setParamI ("bondRadiusMilliAngstroms", marBond);
this.setShapeSize (1, marBond * 2, org.jmol.util.BitSetUtil.setAll (this.getAtomCount ()));
}, "~N");
Clazz.defineMethod (c$, "setHoverLabel", 
function (strLabel) {
this.loadShape (33);
this.setShapeProperty (33, "label", strLabel);
this.hoverEnabled = (strLabel != null);
}, "~S");
Clazz.defineMethod (c$, "hoverOn", 
function (atomIndex, action) {
this.setStatusAtomHovered (atomIndex, this.getAtomInfoXYZ (atomIndex, false));
if (!this.hoverEnabled) return;
if (this.isModelKitMode ()) {
if (this.isAtomAssignable (atomIndex)) this.highlight (org.jmol.util.BitSetUtil.newAndSetBit (atomIndex));
this.refresh (3, "hover on atom");
return;
}if (this.eval != null && this.isScriptExecuting () || atomIndex == this.hoverAtomIndex || this.global.hoverDelayMs == 0) return;
if (!this.isInSelectionSubset (atomIndex)) return;
this.loadShape (33);
if (this.isBound (action, 30) && this.getPickingMode () == 2 && this.modelSet.atoms[atomIndex].isShapeVisible (org.jmol.viewer.JmolConstants.getShapeVisibilityFlag (5))) {
this.setShapeProperty (33, "specialLabel", org.jmol.i18n.GT._ ("Drag to move label"));
}this.setShapeProperty (33, "text", null);
this.setShapeProperty (33, "target", Integer.$valueOf (atomIndex));
this.hoverText = null;
this.hoverAtomIndex = atomIndex;
this.refresh (3, "hover on atom");
}, "~N,~N");
Clazz.defineMethod (c$, "getHoverDelay", 
function () {
return this.global.modelKitMode ? 20 : this.global.hoverDelayMs;
});
Clazz.defineMethod (c$, "hoverOnPt", 
function (x, y, text, id, pt) {
if (!this.hoverEnabled) return;
if (this.eval != null && this.isScriptExecuting ()) return;
this.loadShape (33);
this.setShapeProperty (33, "xy", org.jmol.util.Point3i.new3 (x, y, 0));
this.setShapeProperty (33, "target", null);
this.setShapeProperty (33, "specialLabel", null);
this.setShapeProperty (33, "text", text);
this.hoverAtomIndex = -1;
this.hoverText = text;
if (id != null && pt != null) this.setStatusObjectHovered (id, text, pt);
this.refresh (3, "hover on point");
}, "~N,~N,~S,~S,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "hoverOff", 
function () {
if (this.isModelKitMode ()) this.highlight (null);
if (!this.hoverEnabled) return;
var isHover = (this.hoverText != null || this.hoverAtomIndex >= 0);
if (this.hoverAtomIndex >= 0) {
this.setShapeProperty (33, "target", null);
this.hoverAtomIndex = -1;
}if (this.hoverText != null) {
this.setShapeProperty (33, "text", null);
this.hoverText = null;
}this.setShapeProperty (33, "specialLabel", null);
if (isHover) this.refresh (3, "hover off");
});
Clazz.defineMethod (c$, "getBfactor100Hi", 
function () {
return this.modelSet.getBfactor100Hi ();
});
Clazz.defineMethod (c$, "getColix", 
function (object) {
return org.jmol.util.Colix.getColixO (object);
}, "~O");
Clazz.defineMethod (c$, "getRasmolSetting", 
function (tok) {
switch (tok) {
case 1613758476:
return this.global.rasmolHydrogenSetting;
case 1613758470:
return this.global.rasmolHeteroSetting;
}
return false;
}, "~N");
Clazz.defineMethod (c$, "getDebugScript", 
function () {
return this.global.debugScript;
});
Clazz.overrideMethod (c$, "setDebugScript", 
function (debugScript) {
this.global.debugScript = debugScript;
this.global.setParamB ("debugScript", debugScript);
this.eval.setDebugging ();
}, "~B");
Clazz.defineMethod (c$, "clearClickCount", 
function () {
this.setTainted (true);
});
Clazz.defineMethod (c$, "getCursor", 
function () {
return this.currentCursor;
});
Clazz.defineMethod (c$, "setCursor", 
function (cursor) {
if (this.$isKiosk || this.currentCursor == cursor || this.multiTouch || !this.haveDisplay) return;
this.apiPlatform.setCursor (this.currentCursor = cursor, this.display);
}, "~N");
Clazz.defineMethod (c$, "setPickingMode", 
function (strMode, pickingMode) {
if (!this.haveDisplay) return;
this.showSelected = false;
var option = null;
if (strMode != null) {
var pt = strMode.indexOf ("_");
if (pt >= 0) {
option = strMode.substring (pt + 1);
strMode = strMode.substring (0, pt);
}pickingMode = org.jmol.viewer.ActionManager.getPickingMode (strMode);
}if (pickingMode < 0) pickingMode = 1;
this.actionManager.setPickingMode (pickingMode);
this.global.setParamS ("picking", org.jmol.viewer.ActionManager.getPickingModeName (this.actionManager.getAtomPickingMode ()));
if (option == null || option.length == 0) return;
option = Character.toUpperCase (option.charAt (0)) + (option.length == 1 ? "" : option.substring (1, 2));
switch (pickingMode) {
case 32:
this.setAtomPickingOption (option);
break;
case 33:
this.setBondPickingOption (option);
break;
default:
org.jmol.util.Logger.error ("Bad picking mode: " + strMode + "_" + option);
}
}, "~S,~N");
Clazz.defineMethod (c$, "getPickingMode", 
function () {
return (this.haveDisplay ? this.actionManager.getAtomPickingMode () : 0);
});
Clazz.defineMethod (c$, "getDrawPicking", 
function () {
return this.global.drawPicking;
});
Clazz.defineMethod (c$, "isModelKitMode", 
function () {
return this.global.modelKitMode;
});
Clazz.defineMethod (c$, "getBondPicking", 
function () {
return this.global.bondPicking || this.global.modelKitMode;
});
Clazz.defineMethod (c$, "getAtomPicking", 
($fz = function () {
return this.global.atomPicking;
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "setPickingStyle", 
function (style, pickingStyle) {
if (!this.haveDisplay) return;
if (style != null) pickingStyle = org.jmol.viewer.ActionManager.getPickingStyle (style);
if (pickingStyle < 0) pickingStyle = 0;
this.actionManager.setPickingStyle (pickingStyle);
this.global.setParamS ("pickingStyle", org.jmol.viewer.ActionManager.getPickingStyleName (this.actionManager.getPickingStyle ()));
}, "~S,~N");
Clazz.defineMethod (c$, "getDrawHover", 
function () {
return this.haveDisplay && this.global.drawHover;
});
Clazz.overrideMethod (c$, "getAtomInfo", 
function (atomOrPointIndex) {
return (atomOrPointIndex >= 0 ? this.modelSet.getAtomInfo (atomOrPointIndex, null) : this.shapeManager.getShapePropertyIndex (6, "pointInfo", -atomOrPointIndex));
}, "~N");
Clazz.defineMethod (c$, "getAtomInfoXYZ", 
function (atomIndex, useChimeFormat) {
return this.modelSet.getAtomInfoXYZ (atomIndex, useChimeFormat);
}, "~N,~B");
Clazz.defineMethod (c$, "setSync", 
($fz = function () {
if (this.statusManager.doSync ()) this.statusManager.setSync (null);
}, $fz.isPrivate = true, $fz));
Clazz.overrideMethod (c$, "setJmolCallbackListener", 
function (jmolCallbackListener) {
this.statusManager.setJmolCallbackListener (jmolCallbackListener);
}, "org.jmol.api.JmolCallbackListener");
Clazz.overrideMethod (c$, "setJmolStatusListener", 
function (jmolStatusListener) {
this.statusManager.setJmolStatusListener (jmolStatusListener, null);
}, "org.jmol.api.JmolStatusListener");
Clazz.defineMethod (c$, "getMessageQueue", 
function () {
return this.statusManager.getMessageQueue ();
});
Clazz.defineMethod (c$, "getStatusChanged", 
function (statusNameList) {
return this.statusManager.getStatusChanged (statusNameList);
}, "~S");
Clazz.defineMethod (c$, "menuEnabled", 
function () {
return (!this.global.disablePopupMenu && this.getPopupMenu () != null);
});
Clazz.defineMethod (c$, "popupMenu", 
function (x, y, type) {
if (!this.haveDisplay || !this.refreshing || this.$isPreviewOnly || this.global.disablePopupMenu) return;
switch (type) {
case 'j':
try {
this.getPopupMenu ();
this.jmolpopup.show (x, y);
} catch (e) {
this.global.disablePopupMenu = true;
}
break;
case 'a':
case 'b':
case 'm':
this.modelkitPopup = this.apiPlatform.getMenuPopup (this, null, type);
if (this.modelkitPopup != null) this.modelkitPopup.show (x, y);
break;
}
}, "~N,~N,~S");
Clazz.defineMethod (c$, "getMenu", 
function (type) {
this.getPopupMenu ();
if (type.equals ("\0")) {
this.popupMenu (this.dimScreen.width - 120, 0, 'j');
return "OK";
}return (this.jmolpopup == null ? "" : this.jmolpopup.getMenuAsString ("Jmol version " + org.jmol.viewer.Viewer.getJmolVersion () + "|_GET_MENU|" + type));
}, "~S");
Clazz.defineMethod (c$, "getPopupMenu", 
($fz = function () {
if (this.jmolpopup == null) {
this.jmolpopup = this.apiPlatform.getMenuPopup (this, this.menuStructure, 'j');
if (this.jmolpopup == null) {
this.global.disablePopupMenu = true;
return null;
}}return this.jmolpopup.getMenuAsObject ();
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "setMenu", 
function (fileOrText, isFile) {
if (isFile) org.jmol.util.Logger.info ("Setting menu " + (fileOrText.length == 0 ? "to Jmol defaults" : "from file " + fileOrText));
if (fileOrText.length == 0) fileOrText = null;
 else if (isFile) fileOrText = this.getFileAsString (fileOrText);
this.getProperty ("DATA_API", "setMenu", fileOrText);
this.statusManager.setCallbackFunction ("menu", fileOrText);
}, "~S,~B");
Clazz.defineMethod (c$, "setStatusFrameChanged", 
function (frameNo) {
var modelIndex = this.animationManager.currentModelIndex;
if (frameNo == -2147483648) {
this.prevFrame = -2147483648;
frameNo = modelIndex;
}this.transformManager.setVibrationPeriod (NaN);
var firstIndex = this.animationManager.firstModelIndex;
var lastIndex = this.animationManager.lastModelIndex;
if (firstIndex == lastIndex) modelIndex = firstIndex;
var frameID = this.getModelFileNumber (modelIndex);
var fileNo = frameID;
var modelNo = frameID % 1000000;
var firstNo = this.getModelFileNumber (firstIndex);
var lastNo = this.getModelFileNumber (lastIndex);
var strModelNo;
if (fileNo == 0) {
strModelNo = this.getModelNumberDotted (firstIndex);
if (firstIndex != lastIndex) strModelNo += " - " + this.getModelNumberDotted (lastIndex);
if (Clazz.doubleToInt (firstNo / 1000000) == Clazz.doubleToInt (lastNo / 1000000)) fileNo = firstNo;
} else {
strModelNo = this.getModelNumberDotted (modelIndex);
}if (fileNo != 0) fileNo = (fileNo < 1000000 ? 1 : Clazz.doubleToInt (fileNo / 1000000));
this.global.setParamI ("_currentFileNumber", fileNo);
this.global.setParamI ("_currentModelNumberInFile", modelNo);
this.global.setParamI ("_frameID", frameID);
this.global.setParamS ("_modelNumber", strModelNo);
this.global.setParamS ("_modelName", (modelIndex < 0 ? "" : this.getModelName (modelIndex)));
this.global.setParamS ("_modelTitle", (modelIndex < 0 ? "" : this.getModelTitle (modelIndex)));
this.global.setParamS ("_modelFile", (modelIndex < 0 ? "" : this.getModelFileName (modelIndex)));
if (modelIndex == this.prevFrame) {
return;
}this.prevFrame = modelIndex;
this.statusManager.setStatusFrameChanged (frameNo, fileNo, modelNo, (this.animationManager.animationDirection < 0 ? -firstNo : firstNo), (this.animationManager.currentDirection < 0 ? -lastNo : lastNo));
this.sendJSpecViewModelChange (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "sendJSpecViewModelChange", 
($fz = function (modelIndex) {
var syncMode = ("sync on".equals (this.modelSet.getModelSetAuxiliaryInfoValue ("jmolscript")) ? 1 : this.statusManager.getSyncMode ());
if (syncMode != 1) return;
var peak = this.getModelAuxiliaryInfoValue (modelIndex, "jdxModelSelect");
if (peak != null) this.sendJSpecView (peak);
}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineMethod (c$, "scriptEcho", 
function (strEcho) {
if (!org.jmol.util.Logger.isActiveLevel (4)) return;
{
System.out.println(strEcho);
}this.statusManager.setScriptEcho (strEcho, this.isScriptQueued);
if (this.listCommands && strEcho != null && strEcho.indexOf ("$[") == 0) org.jmol.util.Logger.info (strEcho);
}, "~S");
Clazz.defineMethod (c$, "notifyError", 
function (errType, errMsg, errMsgUntranslated) {
this.global.setParamS ("_errormessage", errMsgUntranslated);
this.statusManager.notifyError (errType, errMsg, errMsgUntranslated);
}, "~S,~S,~S");
Clazz.defineMethod (c$, "jsEval", 
function (strEval) {
return this.statusManager.jsEval (strEval);
}, "~S");
Clazz.defineMethod (c$, "setStatusAtomHovered", 
function (atomIndex, info) {
this.global.setParamI ("_atomhovered", atomIndex);
this.statusManager.setStatusAtomHovered (atomIndex, info);
}, "~N,~S");
Clazz.defineMethod (c$, "setStatusObjectHovered", 
function (id, info, pt) {
this.global.setParamS ("_objecthovered", id);
this.statusManager.setStatusObjectHovered (id, info, pt);
}, "~S,~S,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "setFileLoadStatus", 
($fz = function (ptLoad, fullPathName, fileName, modelName, strError) {
this.setErrorMessage (strError, null);
this.global.setParamI ("_loadPoint", ptLoad.getCode ());
var doCallback = (ptLoad !== org.jmol.constant.EnumFileStatus.CREATING_MODELSET);
this.statusManager.setFileLoadStatus (fullPathName, fileName, modelName, strError, ptLoad.getCode (), doCallback);
if (doCallback) this.sendJSpecViewModelChange (this.getCurrentModelIndex ());
}, $fz.isPrivate = true, $fz), "org.jmol.constant.EnumFileStatus,~S,~S,~S,~S");
Clazz.defineMethod (c$, "getZapName", 
function () {
return (this.getModelkitMode () ? "Jmol Model Kit" : "zapped");
});
Clazz.defineMethod (c$, "setStatusMeasuring", 
function (status, intInfo, strMeasure, value) {
this.statusManager.setStatusMeasuring (status, intInfo, strMeasure, value);
}, "~S,~N,~S,~N");
Clazz.defineMethod (c$, "notifyMinimizationStatus", 
function () {
var step = this.getParameter ("_minimizationStep");
var ff = this.getParameter ("_minimizationForceField");
this.statusManager.notifyMinimizationStatus (this.getParameter ("_minimizationStatus"), Clazz.instanceOf (step, String) ? Integer.$valueOf (0) : step, this.getParameter ("_minimizationEnergy"), (step.toString ().equals ("0") ? Float.$valueOf (0) : this.getParameter ("_minimizationEnergyDiff")), ff);
});
Clazz.defineMethod (c$, "setStatusAtomPicked", 
function (atomIndex, info) {
if (info == null) {
info = this.global.pickLabel;
if (info.length == 0) info = this.getAtomInfoXYZ (atomIndex, this.getMessageStyleChime ());
 else info = this.modelSet.getAtomInfo (atomIndex, info);
}this.global.setPicked (atomIndex);
this.global.setParamS ("_pickinfo", info);
this.statusManager.setStatusAtomPicked (atomIndex, info);
var syncMode = this.statusManager.getSyncMode ();
if (syncMode != 1) return;
var peak = this.modelSet.getPeakAtomRecord (atomIndex);
if (peak != null) this.sendJSpecView (peak + " src=\"JmolAtomSelect\"");
}, "~N,~S");
Clazz.defineMethod (c$, "sendJSpecView", 
($fz = function (peak) {
var msg = org.jmol.util.Parser.getQuotedAttribute (peak, "title");
if (msg != null) this.scriptEcho (org.jmol.util.Logger.debugging ? peak : msg);
peak = this.fullName + "JSpecView: " + peak;
org.jmol.util.Logger.info ("Jmol>JSV " + peak);
this.statusManager.syncSend (peak, ">", 0);
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "setStatusResized", 
function (width, height) {
this.statusManager.setStatusResized (width, height);
}, "~N,~N");
Clazz.defineMethod (c$, "scriptStatus", 
function (strStatus) {
this.setScriptStatus (strStatus, "", 0, null);
}, "~S");
Clazz.defineMethod (c$, "scriptStatusMsg", 
function (strStatus, statusMessage) {
this.setScriptStatus (strStatus, statusMessage, 0, null);
}, "~S,~S");
Clazz.defineMethod (c$, "setScriptStatus", 
function (strStatus, statusMessage, msWalltime, strErrorMessageUntranslated) {
this.statusManager.setScriptStatus (strStatus, statusMessage, msWalltime, strErrorMessageUntranslated);
}, "~S,~S,~N,~S");
Clazz.defineMethod (c$, "getModelTitle", 
($fz = function (modelIndex) {
return this.modelSet == null ? null : this.modelSet.getModelTitle (modelIndex);
}, $fz.isPrivate = true, $fz), "~N");
Clazz.overrideMethod (c$, "getModelFileName", 
function (modelIndex) {
return this.modelSet == null ? null : this.modelSet.getModelFileName (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "dialogAsk", 
function (type, fileName) {
return (this.$isKiosk || !this.isRestricted (org.jmol.viewer.Viewer.ACCESS.ALL) ? null : this.statusManager.dialogAsk (type, fileName));
}, "~S,~S");
Clazz.defineMethod (c$, "getScriptDelay", 
function () {
return this.global.scriptDelay;
});
Clazz.overrideMethod (c$, "showUrl", 
function (urlString) {
if (urlString == null) return;
if (urlString.indexOf (":") < 0) {
var base = this.fileManager.getAppletDocumentBase ();
if (base === "") base = this.fileManager.getFullPathName ();
if (base.indexOf ("/") >= 0) {
base = base.substring (0, base.lastIndexOf ("/") + 1);
} else if (base.indexOf ("\\") >= 0) {
base = base.substring (0, base.lastIndexOf ("\\") + 1);
}urlString = base + urlString;
}org.jmol.util.Logger.info ("showUrl:" + urlString);
this.statusManager.showUrl (urlString);
}, "~S");
Clazz.defineMethod (c$, "setMeshCreator", 
function (meshCreator) {
this.loadShape (23);
this.setShapeProperty (23, "meshCreator", meshCreator);
}, "~O");
Clazz.defineMethod (c$, "showConsole", 
function (showConsole) {
if (!this.haveDisplay) return;
try {
if (this.appConsole == null) this.getProperty ("DATA_API", "getAppConsole", Boolean.TRUE);
this.appConsole.setVisible (showConsole);
} catch (e) {
}
}, "~B");
Clazz.defineMethod (c$, "clearConsole", 
function () {
this.statusManager.clearConsole ();
});
Clazz.defineMethod (c$, "getParameterEscaped", 
function (key) {
return this.global.getParameterEscaped (key, 0);
}, "~S");
Clazz.overrideMethod (c$, "getParameter", 
function (key) {
return this.global.getParameter (key);
}, "~S");
Clazz.defineMethod (c$, "getOrSetNewVariable", 
function (key, doSet) {
return this.global.getOrSetNewVariable (key, doSet);
}, "~S,~B");
Clazz.defineMethod (c$, "setUserVariable", 
function (name, value) {
return this.global.setUserVariable (name, value);
}, "~S,org.jmol.script.ScriptVariable");
Clazz.defineMethod (c$, "unsetProperty", 
function (key) {
key = key.toLowerCase ();
if (key.equals ("all") || key.equals ("variables")) this.fileManager.setPathForAllFiles ("");
this.global.unsetUserVariable (key);
}, "~S");
Clazz.defineMethod (c$, "getVariableList", 
function () {
return this.global.getVariableList ();
});
Clazz.overrideMethod (c$, "getBooleanProperty", 
function (key) {
key = key.toLowerCase ();
if (this.global.htBooleanParameterFlags.containsKey (key)) return this.global.htBooleanParameterFlags.get (key).booleanValue ();
if (key.endsWith ("p!")) {
if (this.actionManager == null) return false;
var s = this.actionManager.getPickingState ().toLowerCase ();
key = key.substring (0, key.length - 2) + ";";
return (s.indexOf (key) >= 0);
}if (key.equalsIgnoreCase ("__appletReady")) {
this.statusManager.setStatusAppletReady (this.fullName, true);
return true;
}if (key.equalsIgnoreCase ("__appletDestroyed")) {
this.statusManager.setStatusAppletReady (this.htmlName, false);
return true;
}if (key.equalsIgnoreCase ("executionPaused")) return this.eval.isExecutionPaused ();
if (key.equalsIgnoreCase ("executionStepping")) return this.eval.isExecutionStepping ();
if (key.equalsIgnoreCase ("haveBFactors")) return (this.modelSet.getBFactors () != null);
if (key.equalsIgnoreCase ("colorRasmol")) return this.colorManager.getDefaultColorRasmol ();
if (key.equalsIgnoreCase ("frank")) return this.getShowFrank ();
if (key.equalsIgnoreCase ("spinOn")) return this.getSpinOn ();
if (key.equalsIgnoreCase ("isNavigating")) return this.isNavigating ();
if (key.equalsIgnoreCase ("showSelections")) return this.modelSet.getSelectionHaloEnabled ();
if (this.global.htUserVariables.containsKey (key)) {
var t = this.global.getUserVariable (key);
if (t.tok == 1048589) return true;
if (t.tok == 1048588) return false;
}org.jmol.util.Logger.error ("viewer.getBooleanProperty(" + key + ") - unrecognized");
return false;
}, "~S");
Clazz.overrideMethod (c$, "setStringProperty", 
function (key, value) {
if (value == null) return;
if (key.charAt (0) == '_') {
this.global.setParamS (key, value);
return;
}var tok = org.jmol.script.Token.getTokFromName (key);
switch (org.jmol.script.Token.getParamType (tok)) {
case 603979776:
this.setBooleanPropertyTok (key, tok, org.jmol.script.ScriptVariable.newVariable (4, value).asBoolean ());
break;
case 553648128:
this.setIntPropertyTok (key, tok, org.jmol.script.ScriptVariable.newVariable (4, value).asInt ());
break;
case 570425344:
this.setFloatPropertyTok (key, tok, org.jmol.util.Parser.parseFloatStr (value));
break;
default:
this.setStringPropertyTok (key, tok, value);
}
}, "~S,~S");
Clazz.defineMethod (c$, "setStringPropertyTok", 
($fz = function (key, tok, value) {
switch (tok) {
case 545259548:
this.global.defaultDropScript = value;
break;
case 545259570:
value = this.fileManager.setPathForAllFiles (value);
break;
case 545259558:
this.setUnits (value, false);
return;
case 545259560:
this.global.forceField = value;
this.minimizer = null;
break;
case 545259569:
this.global.nmrUrlFormat = value;
break;
case 545259568:
this.setUnits (value, true);
return;
case 545259566:
this.global.loadLigandFormat = value;
break;
case 545259543:
this.global.defaultLabelPDB = value;
break;
case 545259544:
this.global.defaultLabelXYZ = value;
break;
case 545259549:
this.global.defaultLoadFilter = value;
break;
case 545259567:
value = this.setLogFile (value);
if (value == null) return;
break;
case 545259559:
break;
case 545259524:
this.global.atomTypes = value;
break;
case 545259538:
break;
case 545259576:
this.global.pickLabel = value;
break;
case 545259580:
if (value.length == 2 && value.startsWith ("R")) this.global.quaternionFrame = value.substring (0, 2);
 else this.global.quaternionFrame = "" + (value.toLowerCase () + "p").charAt (0);
if (!org.jmol.util.Parser.isOneOf (this.global.quaternionFrame, "RC;RP;a;b;c;n;p;q;x;")) this.global.quaternionFrame = "p";
this.modelSet.setHaveStraightness (false);
break;
case 545259555:
this.setDefaultVdw (value);
return;
case 545259564:
 new org.jmol.i18n.GT (value);
this.language = org.jmol.i18n.GT.getLanguage ();
this.modelkitPopup = null;
if (this.jmolpopup != null) {
this.jmolpopup.dispose ();
this.jmolpopup = null;
this.getPopupMenu ();
}this.statusManager.setCallbackFunction ("language", this.language);
value = org.jmol.i18n.GT.getLanguage ();
break;
case 545259565:
this.global.loadFormat = value;
break;
case 545259534:
this.setObjectColor ("background", value);
return;
case 545259528:
this.setObjectColor ("axis1", value);
return;
case 545259530:
this.setObjectColor ("axis2", value);
return;
case 545259532:
this.setObjectColor ("axis3", value);
return;
case 545259536:
this.setObjectColor ("boundbox", value);
return;
case 545259586:
this.setObjectColor ("unitcell", value);
return;
case 545259578:
this.setPropertyColorScheme (value, false, false);
break;
case 545259562:
this.setShapeProperty (33, "atomLabel", value);
break;
case 545259547:
this.global.defaultDistanceLabel = value;
break;
case 545259542:
this.global.defaultAngleLabel = value;
break;
case 545259554:
this.global.defaultTorsionLabel = value;
break;
case 545259550:
this.global.defaultLoadScript = value;
break;
case 545259522:
this.fileManager.setAppletProxy (value);
break;
case 545259546:
if (value == null) value = "";
value = value.$replace ('\\', '/');
this.global.defaultDirectory = value;
break;
case 545259561:
this.global.helpPath = value;
break;
case 545259552:
if (!value.equalsIgnoreCase ("RasMol")) value = "Jmol";
this.setDefaultsType (value);
break;
case 545259545:
this.setDefaultColors (value.equalsIgnoreCase ("rasmol"));
return;
case 545259572:
this.setPickingMode (value, 0);
return;
case 545259574:
this.setPickingStyle (value, 0);
return;
case 545259540:
break;
default:
if (key.toLowerCase ().endsWith ("callback")) {
this.statusManager.setCallbackFunction (key, (value.length == 0 || value.equalsIgnoreCase ("none") ? null : value));
break;
}if (!this.global.htNonbooleanParameterValues.containsKey (key.toLowerCase ())) {
this.global.setUserVariable (key, org.jmol.script.ScriptVariable.newVariable (4, value));
return;
}break;
}
this.global.setParamS (key, value);
}, $fz.isPrivate = true, $fz), "~S,~N,~S");
Clazz.overrideMethod (c$, "setFloatProperty", 
function (key, value) {
if (Float.isNaN (value)) return;
if (key.charAt (0) == '_') {
this.global.setParamF (key, value);
return;
}var tok = org.jmol.script.Token.getTokFromName (key);
switch (org.jmol.script.Token.getParamType (tok)) {
case 545259520:
this.setStringPropertyTok (key, tok, "" + value);
break;
case 603979776:
this.setBooleanPropertyTok (key, tok, value != 0);
break;
case 553648128:
this.setIntPropertyTok (key, tok, Clazz.floatToInt (value));
break;
default:
this.setFloatPropertyTok (key, tok, value);
}
}, "~S,~N");
Clazz.defineMethod (c$, "setFloatPropertyTok", 
($fz = function (key, tok, value) {
switch (tok) {
case 570425368:
this.global.multipleBondRadiusFactor = value;
break;
case 570425369:
this.global.multipleBondSpacing = value;
break;
case 570425393:
this.transformManager.setSlabRange (value);
break;
case 570425365:
this.global.minimizationCriterion = value;
break;
case 570425359:
if (this.haveDisplay) this.actionManager.setGestureSwipeFactor (value);
break;
case 570425366:
if (this.haveDisplay) this.actionManager.setMouseDragFactor (value);
break;
case 570425367:
if (this.haveDisplay) this.actionManager.setMouseWheelFactor (value);
break;
case 570425408:
this.global.strutLengthMaximum = value;
break;
case 570425406:
this.global.strutDefaultRadius = value;
break;
case 570425376:
this.setSpin ("X", Clazz.floatToInt (value));
break;
case 570425378:
this.setSpin ("Y", Clazz.floatToInt (value));
break;
case 570425380:
this.setSpin ("Z", Clazz.floatToInt (value));
break;
case 570425370:
if (Float.isNaN (value)) return;
this.setSpin ("FPS", Clazz.floatToInt (value));
break;
case 570425363:
this.global.loadAtomDataTolerance = value;
break;
case 570425360:
this.global.hbondsAngleMinimum = value;
break;
case 570425361:
this.global.hbondsDistanceMaximum = value;
break;
case 570425382:
this.global.pointGroupDistanceTolerance = value;
break;
case 570425384:
this.global.pointGroupLinearTolerance = value;
break;
case 570425358:
this.global.ellipsoidAxisDiameter = value;
break;
case 570425398:
this.setSpin ("x", Clazz.floatToInt (value));
break;
case 570425400:
this.setSpin ("y", Clazz.floatToInt (value));
break;
case 570425402:
this.setSpin ("z", Clazz.floatToInt (value));
break;
case 570425396:
this.setSpin ("fps", Clazz.floatToInt (value));
break;
case 570425352:
this.global.defaultDrawArrowScale = value;
break;
case 570425354:
this.global.defaultTranslucent = value;
break;
case 570425346:
this.setAxesScale (value);
break;
case 570425416:
this.transformManager.setVisualRange (value);
this.refresh (1, "set visualRange");
break;
case 570425371:
this.setNavigationDepthPercent (value);
break;
case 570425374:
this.global.navigationSpeed = value;
break;
case 570425372:
this.transformManager.setNavigationSlabOffsetPercent (value);
break;
case 570425350:
this.transformManager.setCameraDepthPercent (value);
this.refresh (1, "set cameraDepth");
break;
case 570425388:
this.setRotationRadius (value, true);
return;
case 570425362:
this.global.hoverDelayMs = Clazz.floatToInt (value * 1000);
break;
case 570425392:
this.global.sheetSmoothing = value;
break;
case 570425356:
value = org.jmol.viewer.Viewer.checkFloatRange (value, -10, 10);
this.global.dipoleScale = value;
break;
case 570425404:
this.transformManager.setStereoDegrees (value);
break;
case 1649410065:
this.setVectorScale (value);
return;
case 570425412:
this.setVibrationPeriod (value);
return;
case 570425414:
this.setVibrationScale (value);
return;
case 570425348:
this.setBondTolerance (value);
return;
case 570425364:
this.setMinBondDistance (value);
return;
case 570425390:
this.transformManager.setScaleAngstromsPerInch (value);
break;
case 570425394:
value = org.jmol.viewer.Viewer.checkFloatRange (value, 0, 10);
this.global.solventProbeRadius = value;
break;
default:
if (!this.global.htNonbooleanParameterValues.containsKey (key.toLowerCase ())) {
this.global.setUserVariable (key, org.jmol.script.ScriptVariable.newVariable (3,  new Float (value)));
return;
}}
this.global.setParamF (key, value);
}, $fz.isPrivate = true, $fz), "~S,~N,~N");
Clazz.overrideMethod (c$, "setIntProperty", 
function (key, value) {
if (value == -2147483648) return;
if (key.charAt (0) == '_') {
this.global.setParamI (key, value);
return;
}var tok = org.jmol.script.Token.getTokFromName (key);
switch (org.jmol.script.Token.getParamType (tok)) {
case 545259520:
this.setStringPropertyTok (key, tok, "" + value);
break;
case 603979776:
this.setBooleanPropertyTok (key, tok, value != 0);
break;
case 570425344:
this.setFloatPropertyTok (key, tok, value);
break;
default:
this.setIntPropertyTok (key, tok, value);
}
}, "~S,~N");
Clazz.defineMethod (c$, "setIntPropertyTok", 
($fz = function (key, tok, value) {
switch (tok) {
case 553648151:
this.global.meshScale = value;
break;
case 553648153:
this.global.minPixelSelRadius = value;
break;
case 553648149:
this.global.isosurfacePropertySmoothingPower = value;
break;
case 553648165:
this.global.repaintWaitMs = value;
break;
case 553648170:
this.global.smallMoleculeMaxAtoms = value;
break;
case 553648152:
this.global.minimizationSteps = value;
break;
case 553648184:
this.global.strutSpacing = value;
break;
case 553648156:
value = org.jmol.viewer.Viewer.checkIntRange (value, 0, 1000);
org.jmol.util.GData.setPhongExponent (value);
break;
case 553648146:
this.global.helixStep = value;
this.modelSet.setHaveStraightness (false);
break;
case 553648144:
this.global.dotScale = value;
break;
case 553648143:
this.global.dotDensity = value;
break;
case 553648138:
this.global.delayMaximumMs = value;
break;
case 553648150:
org.jmol.util.Logger.setLogLevel (value);
org.jmol.util.Logger.info ("logging level set to " + value);
this.global.setParamI ("logLevel", value);
this.eval.setDebugging ();
return;
case 553648134:
switch (org.jmol.constant.EnumAxesMode.getAxesMode (value)) {
case org.jmol.constant.EnumAxesMode.MOLECULAR:
this.setAxesModeMolecular (true);
return;
case org.jmol.constant.EnumAxesMode.BOUNDBOX:
this.setAxesModeMolecular (false);
return;
case org.jmol.constant.EnumAxesMode.UNITCELL:
this.setAxesModeUnitCell (true);
return;
}
return;
case 553648178:
this.setStrandCount (0, value);
return;
case 553648182:
this.setStrandCount (12, value);
return;
case 553648180:
this.setStrandCount (13, value);
return;
case 553648155:
return;
case 536870922:
this.global.scriptDelay = value;
break;
case 553648176:
if (value < 0) value = org.jmol.viewer.Viewer.checkIntRange (value, -10, -1);
 else value = org.jmol.viewer.Viewer.checkIntRange (value, 0, 100);
org.jmol.util.GData.setSpecularPower (value);
break;
case 553648172:
value = org.jmol.viewer.Viewer.checkIntRange (-value, -10, -1);
org.jmol.util.GData.setSpecularPower (value);
break;
case 553648136:
this.setMarBond (value);
return;
case 536870924:
this.setBooleanPropertyTok (key, tok, value == 1);
return;
case 553648174:
value = org.jmol.viewer.Viewer.checkIntRange (value, 0, 100);
org.jmol.util.GData.setSpecularPercent (value);
break;
case 553648142:
value = org.jmol.viewer.Viewer.checkIntRange (value, 0, 100);
org.jmol.util.GData.setDiffusePercent (value);
break;
case 553648130:
value = org.jmol.viewer.Viewer.checkIntRange (value, 0, 100);
org.jmol.util.GData.setAmbientPercent (value);
break;
case 553648186:
this.transformManager.zDepthToPercent (value);
break;
case 553648188:
this.transformManager.zSlabToPercent (value);
break;
case 554176526:
this.transformManager.depthToPercent (value);
break;
case 554176565:
this.transformManager.slabToPercent (value);
break;
case 553648190:
this.global.zShadePower = Math.max (value, 1);
break;
case 553648166:
this.global.ribbonAspectRatio = value;
break;
case 553648158:
this.global.pickingSpinRate = (value < 1 ? 1 : value);
break;
case 553648132:
this.setAnimationFps (value);
break;
case 553648154:
this.setPercentVdwAtom (value);
break;
case 553648147:
this.global.hermiteLevel = value;
break;
case 553648145:
case 553648148:
case 553648160:
case 553648159:
case 553648162:
case 553648164:
break;
default:
if (!this.global.htNonbooleanParameterValues.containsKey (key)) {
this.global.setUserVariable (key,  new org.jmol.script.ScriptVariableInt (value));
return;
}}
this.global.setParamI (key, value);
}, $fz.isPrivate = true, $fz), "~S,~N,~N");
c$.checkIntRange = Clazz.defineMethod (c$, "checkIntRange", 
($fz = function (value, min, max) {
return (value < min ? min : value > max ? max : value);
}, $fz.isPrivate = true, $fz), "~N,~N,~N");
c$.checkFloatRange = Clazz.defineMethod (c$, "checkFloatRange", 
($fz = function (value, min, max) {
return (value < min ? min : value > max ? max : value);
}, $fz.isPrivate = true, $fz), "~N,~N,~N");
Clazz.overrideMethod (c$, "setBooleanProperty", 
function (key, value) {
if (key.charAt (0) == '_') {
this.global.setParamB (key, value);
return;
}var tok = org.jmol.script.Token.getTokFromName (key);
switch (org.jmol.script.Token.getParamType (tok)) {
case 545259520:
this.setStringPropertyTok (key, tok, "" + value);
break;
case 553648128:
this.setIntPropertyTok (key, tok, value ? 1 : 0);
break;
case 570425344:
this.setFloatPropertyTok (key, tok, value ? 1 : 0);
break;
default:
this.setBooleanPropertyTok (key, tok, value);
}
}, "~S,~B");
Clazz.defineMethod (c$, "setBooleanPropertyTok", 
($fz = function (key, tok, value) {
var doRepaint = true;
switch (tok) {
case 603979820:
this.global.cartoonFancy = value;
break;
case 603979934:
this.global.showTiming = value;
break;
case 603979973:
this.global.vectorSymmetry = value;
break;
case 603979870:
this.global.isosurfaceKey = value;
break;
case 603979888:
this.global.partialDots = value;
break;
case 603979874:
this.global.legacyAutoBonding = value;
break;
case 603979825:
this.global.defaultStructureDSSP = value;
break;
case 603979834:
this.global.dsspCalcHydrogen = value;
break;
case 603979782:
this.global.allowModelkit = value;
if (!value) this.setModelKitMode (false);
break;
case 603979882:
this.setModelKitMode (value);
break;
case 603979884:
this.global.multiProcessor = value && (org.jmol.viewer.Viewer.nProcessors > 1);
break;
case 603979883:
this.global.monitorEnergy = value;
break;
case 603979853:
this.global.hbondsRasmol = value;
break;
case 603979880:
this.global.minimizationRefresh = value;
break;
case 603979881:
this.global.minimizationSilent = value;
break;
case 603979969:
this.global.useArcBall = value;
break;
case 603979869:
if (value) {
this.$isKiosk = true;
this.global.disablePopupMenu = true;
if (this.display != null) this.apiPlatform.setTransparentCursor (this.display);
}break;
case 603979974:
this.global.waitForMoveTo = value;
break;
case 603979875:
this.global.logCommands = true;
break;
case 603979876:
this.global.logGestures = true;
break;
case 603979784:
this.global.allowMultiTouch = value;
break;
case 603979893:
this.global.preserveState = value;
this.modelSet.setPreserveState (value);
this.undoClear ();
break;
case 603979955:
this.global.strutsMultiple = value;
break;
case 603979842:
break;
case 603979938:
this.global.slabByAtom = value;
break;
case 603979940:
this.global.slabByMolecule = value;
break;
case 603979902:
this.global.saveProteinStructureState = value;
break;
case 603979780:
this.global.allowGestures = value;
break;
case 603979868:
this.global.imageState = value;
break;
case 603979970:
this.global.useMinimizationThread = value;
break;
case 603979781:
if (this.global.disablePopupMenu) value = false;
this.global.allowKeyStrokes = value;
break;
case 603979831:
this.global.dragSelected = value;
this.showSelected = false;
break;
case 603979924:
this.global.showKeyStrokes = value;
break;
case 603979844:
this.global.fontCaching = value;
break;
case 603979796:
this.global.atomPicking = value;
break;
case 603979814:
this.highlight (null);
this.global.bondPicking = value;
break;
case 603979906:
this.global.selectAllModels = value;
break;
case 603979879:
this.global.messageStyleChime = value;
break;
case 603979891:
this.global.pdbSequential = value;
break;
case 603979889:
this.global.pdbAddHydrogens = value;
break;
case 603979890:
this.global.pdbGetHeader = value;
break;
case 603979837:
this.global.ellipsoidAxes = value;
break;
case 603979836:
this.global.ellipsoidArcs = value;
break;
case 603979838:
this.global.ellipsoidBall = value;
break;
case 603979839:
this.global.ellipsoidDots = value;
break;
case 603979840:
this.global.ellipsoidFill = value;
break;
case 603979845:
this.global.fontScaling = value;
break;
case 603979956:
this.setSyncTarget (0, value);
break;
case 603979958:
this.setSyncTarget (1, value);
break;
case 603979976:
this.global.wireframeRotation = value;
break;
case 603979871:
this.global.isosurfacePropertySmoothing = value;
break;
case 603979833:
this.global.drawPicking = value;
break;
case 603979786:
this.setAntialias (0, value);
break;
case 603979790:
this.setAntialias (1, value);
break;
case 603979788:
this.setAntialias (2, value);
break;
case 603979944:
this.global.smartAromatic = value;
break;
case 603979794:
this.setApplySymmetryToBonds (value);
break;
case 603979792:
this.setAppendNew (value);
break;
case 603979800:
this.global.autoFps = value;
break;
case 603979972:
org.jmol.util.TextFormat.setUseNumberLocalization (this.global.useNumberLocalization = value);
break;
case 1611272202:
key = "showFrank";
this.setFrankOn (value);
break;
case 603979918:
this.setFrankOn (value);
break;
case 1613758488:
key = "solventProbe";
this.global.solventOn = value;
break;
case 603979948:
this.global.solventOn = value;
break;
case 603979835:
this.setDynamicMeasurements (value);
break;
case 603979785:
this.global.allowRotateSelected = value;
break;
case 603979783:
this.global.allowMoveAtoms = value;
this.global.allowRotateSelected = value;
this.global.dragSelected = value;
this.showSelected = false;
break;
case 536870922:
this.setIntPropertyTok ("showScript", tok, value ? 1 : 0);
return;
case 603979778:
this.global.allowEmbeddedScripts = value;
break;
case 603979887:
this.global.navigationPeriodic = value;
break;
case 603979984:
this.transformManager.setZShadeEnabled (value);
return;
case 603979832:
if (this.haveDisplay) this.global.drawHover = value;
break;
case 603979886:
this.setNavigationMode (value);
break;
case 603979885:
return;
case 603979860:
this.global.hideNavigationPoint = value;
break;
case 603979930:
this.global.showNavigationPointAlways = value;
break;
case 603979896:
this.setRefreshing (value);
break;
case 603979872:
this.global.justifyMeasurements = value;
break;
case 603979952:
this.global.ssbondsBackbone = value;
break;
case 603979852:
this.global.hbondsBackbone = value;
break;
case 603979854:
this.global.hbondsSolid = value;
break;
case 536870924:
org.jmol.util.GData.setSpecular (value);
break;
case 603979942:
this.transformManager.setSlabEnabled (value);
return;
case 603979980:
this.transformManager.setZoomEnabled (value);
return;
case 603979864:
this.global.highResolutionFlag = value;
break;
case 603979967:
this.global.traceAlpha = value;
break;
case 603979982:
this.global.zoomLarge = value;
this.transformManager.scaleFitToScreen (false, value, false, true);
break;
case 603979873:
org.jmol.i18n.GT.setDoTranslate (value);
break;
case 603979862:
this.selectionManager.setHideNotSelected (value);
break;
case 603979904:
this.setScriptQueue (value);
break;
case 603979830:
this.global.dotSurface = value;
break;
case 603979829:
this.global.dotsSelectedOnly = value;
break;
case 1611141171:
this.setSelectionHalos (value);
break;
case 603979910:
this.global.rasmolHydrogenSetting = value;
break;
case 603979908:
this.global.rasmolHeteroSetting = value;
break;
case 603979928:
this.global.showMultipleBonds = value;
break;
case 603979920:
this.global.showHiddenSelectionHalos = value;
break;
case 603979975:
this.transformManager.setWindowCentered (value);
break;
case 603979828:
this.global.displayCellParameters = value;
break;
case 603979960:
this.global.testFlag1 = value;
break;
case 603979962:
this.global.testFlag2 = value;
break;
case 603979964:
this.global.testFlag3 = value;
break;
case 603979966:
this.jmolTest ();
this.global.testFlag4 = value;
break;
case 603979898:
this.global.ribbonBorder = value;
break;
case 603979818:
this.global.cartoonBaseEdges = value;
break;
case 603979819:
this.global.cartoonRockets = value;
break;
case 603979900:
this.global.rocketBarrels = value;
break;
case 603979850:
this.gdata.setGreyscaleMode (this.global.greyscaleRendering = value);
break;
case 603979878:
this.global.measurementLabels = value;
break;
case 603979810:
this.setAxesModeMolecular (!value);
return;
case 603979804:
this.setAxesModeMolecular (value);
return;
case 603979808:
this.setAxesModeUnitCell (value);
return;
case 603979806:
this.setAxesOrientationRasmol (value);
return;
case 603979822:
this.setStringPropertyTok ("defaultcolorscheme", 545259545, value ? "rasmol" : "jmol");
return;
case 603979824:
this.setDebugScript (value);
return;
case 603979892:
this.setPerspectiveDepth (value);
return;
case 603979798:
this.setAutoBond (value);
return;
case 603979914:
this.setShowAxes (value);
return;
case 603979916:
this.setShowBbcage (value);
return;
case 603979922:
this.setShowHydrogens (value);
return;
case 603979926:
this.setShowMeasurements (value);
return;
case 603979936:
this.setShowUnitCell (value);
return;
case 603979812:
doRepaint = false;
this.global.bondModeOr = value;
break;
case 603979978:
doRepaint = false;
this.global.zeroBasedXyzRasmol = value;
this.reset (true);
break;
case 603979894:
doRepaint = false;
this.global.rangeSelected = value;
break;
case 603979877:
doRepaint = false;
this.global.measureAllModels = value;
break;
case 603979954:
doRepaint = false;
this.statusManager.setAllowStatusReporting (value);
break;
case 603979821:
doRepaint = false;
this.global.chainCaseSensitive = value;
break;
case 603979858:
doRepaint = false;
this.global.hideNameInPopup = value;
break;
case 603979826:
doRepaint = false;
this.global.disablePopupMenu = value;
break;
case 603979846:
doRepaint = false;
this.global.forceAutoBond = value;
break;
case 603979848:
doRepaint = false;
this.global.fractionalRelative = value;
break;
default:
if (!this.global.htBooleanParameterFlags.containsKey (key.toLowerCase ())) {
this.global.setUserVariable (key, org.jmol.script.ScriptVariable.getBoolean (value));
return;
}}
this.global.setParamB (key, value);
if (doRepaint) this.setTainted (true);
}, $fz.isPrivate = true, $fz), "~S,~N,~B");
Clazz.defineMethod (c$, "setModelKitMode", 
($fz = function (value) {
if (this.actionManager == null) return;
if (value || this.global.modelKitMode) {
this.setPickingMode (null, value ? 33 : 1);
this.setPickingMode (null, value ? 32 : 1);
}var isChange = (this.global.modelKitMode != value);
this.global.modelKitMode = value;
this.highlight (null);
if (value) {
this.setNavigationMode (false);
this.selectAll ();
this.setAtomPickingOption ("C");
this.setBondPickingOption ("p");
if (!this.$isApplet) this.popupMenu (0, 0, 'm');
if (isChange) this.statusManager.setCallbackFunction ("modelkit", "ON");
this.global.modelKitMode = true;
if (this.getAtomCount () == 0) this.zap (false, true, true);
} else {
this.actionManager.setPickingMode (-1);
this.setStringProperty ("pickingStyle", "toggle");
this.setBooleanProperty ("bondPicking", false);
if (isChange) this.statusManager.setCallbackFunction ("modelkit", "OFF");
}}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "getModelkitMode", 
function () {
return this.global.modelKitMode;
});
Clazz.defineMethod (c$, "getLanguage", 
function () {
return this.language;
});
Clazz.defineMethod (c$, "setSmilesString", 
function (s) {
if (s == null) this.global.removeParam ("_smilesString");
 else this.global.setParamS ("_smilesString", s);
}, "~S");
Clazz.defineMethod (c$, "removeUserVariable", 
function (key) {
this.global.removeUserVariable (key);
if (key.endsWith ("callback")) this.statusManager.setCallbackFunction (key, null);
}, "~S");
Clazz.defineMethod (c$, "isJmolVariable", 
function (key) {
return this.global.isJmolVariable (key);
}, "~S");
Clazz.defineMethod (c$, "jmolTest", 
($fz = function () {
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "isPdbSequential", 
function () {
return this.global.pdbSequential;
});
Clazz.defineMethod (c$, "getSelectAllModels", 
function () {
return this.global.selectAllModels;
});
Clazz.defineMethod (c$, "getMessageStyleChime", 
function () {
return this.global.messageStyleChime;
});
Clazz.defineMethod (c$, "getFontCaching", 
function () {
return this.global.fontCaching;
});
Clazz.defineMethod (c$, "getFontScaling", 
function () {
return this.global.fontScaling;
});
Clazz.defineMethod (c$, "showParameter", 
function (key, ifNotSet, nMax) {
var sv = "" + this.global.getParameterEscaped (key, nMax);
if (ifNotSet || sv.indexOf ("<not defined>") < 0) this.showString (key + " = " + sv, false);
}, "~S,~B,~N");
Clazz.defineMethod (c$, "showString", 
function (str, isPrint) {
if (this.isScriptQueued && (!this.isSilent || isPrint) && !this.isSingleThreaded) org.jmol.util.Logger.warn (str);
this.scriptEcho (str);
}, "~S,~B");
Clazz.defineMethod (c$, "getAllSettings", 
function (prefix) {
return this.global.getAllSettings (prefix);
}, "~S");
Clazz.defineMethod (c$, "getBindingInfo", 
function (qualifiers) {
return (this.haveDisplay ? this.actionManager.getBindingInfo (qualifiers) : "");
}, "~S");
Clazz.defineMethod (c$, "getDelayMaximum", 
function () {
return (this.haveDisplay ? this.global.delayMaximumMs : 1);
});
Clazz.defineMethod (c$, "getDotSurfaceFlag", 
function () {
return this.global.dotSurface;
});
Clazz.defineMethod (c$, "getDotsSelectedOnlyFlag", 
function () {
return this.global.dotsSelectedOnly;
});
Clazz.defineMethod (c$, "getDotDensity", 
function () {
return this.global.dotDensity;
});
Clazz.defineMethod (c$, "getDotScale", 
function () {
return this.global.dotScale;
});
Clazz.defineMethod (c$, "getMeshScale", 
function () {
return this.global.meshScale;
});
Clazz.defineMethod (c$, "isRangeSelected", 
function () {
return this.global.rangeSelected;
});
Clazz.defineMethod (c$, "getIsosurfaceKey", 
function () {
return this.global.isosurfaceKey;
});
Clazz.defineMethod (c$, "getIsosurfacePropertySmoothing", 
function (asPower) {
return (asPower ? this.global.isosurfacePropertySmoothingPower : this.global.isosurfacePropertySmoothing ? 1 : 0);
}, "~B");
Clazz.defineMethod (c$, "getWireframeRotation", 
function () {
return this.global.wireframeRotation;
});
Clazz.defineMethod (c$, "isWindowCentered", 
function () {
return this.transformManager.isWindowCentered ();
});
Clazz.defineMethod (c$, "setNavigationDepthPercent", 
function (percent) {
this.transformManager.setNavigationDepthPercent (percent);
this.refresh (1, "set navigationDepth");
}, "~N");
Clazz.defineMethod (c$, "getNavigationSpeed", 
function () {
return this.global.navigationSpeed;
});
Clazz.defineMethod (c$, "getShowNavigationPoint", 
function () {
if (!this.global.navigationMode || !this.transformManager.canNavigate ()) return false;
return (this.isNavigating () && !this.global.hideNavigationPoint || this.global.showNavigationPointAlways || this.getInMotion ());
});
Clazz.defineMethod (c$, "getSolventProbeRadius", 
function () {
return this.global.solventProbeRadius;
});
Clazz.defineMethod (c$, "getCurrentSolventProbeRadius", 
function () {
return this.global.solventOn ? this.global.solventProbeRadius : 0;
});
Clazz.defineMethod (c$, "getSolventOn", 
function () {
return this.global.solventOn;
});
Clazz.defineMethod (c$, "getShowTiming", 
function () {
return this.global.showTiming;
});
Clazz.defineMethod (c$, "getTestFlag", 
function (i) {
switch (i) {
case 1:
return this.global.testFlag1;
case 2:
return this.global.testFlag2;
case 3:
return this.global.testFlag3;
case 4:
return this.global.testFlag4;
}
return false;
}, "~N");
Clazz.overrideMethod (c$, "setPerspectiveDepth", 
function (perspectiveDepth) {
this.global.setParamB ("perspectiveDepth", perspectiveDepth);
this.transformManager.setPerspectiveDepth (perspectiveDepth);
}, "~B");
Clazz.overrideMethod (c$, "setAxesOrientationRasmol", 
function (TF) {
this.global.setParamB ("axesOrientationRasmol", TF);
this.global.axesOrientationRasmol = TF;
this.reset (true);
}, "~B");
Clazz.overrideMethod (c$, "getAxesOrientationRasmol", 
function () {
return this.global.axesOrientationRasmol;
});
Clazz.defineMethod (c$, "setAxesScale", 
function (scale) {
scale = org.jmol.viewer.Viewer.checkFloatRange (scale, -100, 100);
this.global.axesScale = scale;
this.axesAreTainted = true;
}, "~N");
Clazz.defineMethod (c$, "getAxisPoints", 
function () {
return (this.getObjectMad (1) == 0 || this.getAxesMode () !== org.jmol.constant.EnumAxesMode.UNITCELL || (this.getShapeProperty (30, "axesTypeXY")).booleanValue () || this.getShapeProperty (30, "origin") != null ? null : this.getShapeProperty (30, "axisPoints"));
});
Clazz.defineMethod (c$, "getAxesScale", 
function () {
return this.global.axesScale;
});
Clazz.defineMethod (c$, "resetError", 
function () {
this.global.removeParam ("_errormessage");
});
Clazz.defineMethod (c$, "setAxesModeMolecular", 
($fz = function (TF) {
this.global.axesMode = (TF ? org.jmol.constant.EnumAxesMode.MOLECULAR : org.jmol.constant.EnumAxesMode.BOUNDBOX);
this.axesAreTainted = true;
this.global.removeParam ("axesunitcell");
this.global.removeParam (TF ? "axeswindow" : "axesmolecular");
this.global.setParamI ("axesMode", this.global.axesMode.getCode ());
this.global.setParamB (TF ? "axesMolecular" : "axesWindow", true);
}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "setAxesModeUnitCell", 
function (TF) {
this.global.axesMode = (TF ? org.jmol.constant.EnumAxesMode.UNITCELL : org.jmol.constant.EnumAxesMode.BOUNDBOX);
this.axesAreTainted = true;
this.global.removeParam ("axesmolecular");
this.global.removeParam (TF ? "axeswindow" : "axesunitcell");
this.global.setParamB (TF ? "axesUnitcell" : "axesWindow", true);
this.global.setParamI ("axesMode", this.global.axesMode.getCode ());
}, "~B");
Clazz.defineMethod (c$, "getAxesMode", 
function () {
return this.global.axesMode;
});
Clazz.defineMethod (c$, "getDisplayCellParameters", 
function () {
return this.global.displayCellParameters;
});
Clazz.overrideMethod (c$, "getPerspectiveDepth", 
function () {
return this.transformManager.getPerspectiveDepth ();
});
Clazz.overrideMethod (c$, "setSelectionHalos", 
function (TF) {
if (this.modelSet == null || TF == this.modelSet.getSelectionHaloEnabled ()) return;
this.global.setParamB ("selectionHalos", TF);
this.loadShape (8);
this.modelSet.setSelectionHaloEnabled (TF);
}, "~B");
Clazz.defineMethod (c$, "getSelectionHaloEnabled", 
function (isRenderer) {
var flag = this.modelSet.getSelectionHaloEnabled () || isRenderer && this.showSelected;
if (isRenderer) this.showSelected = false;
return flag;
}, "~B");
Clazz.defineMethod (c$, "getBondSelectionModeOr", 
function () {
return this.global.bondModeOr;
});
Clazz.defineMethod (c$, "getChainCaseSensitive", 
function () {
return this.global.chainCaseSensitive;
});
Clazz.defineMethod (c$, "getRibbonBorder", 
function () {
return this.global.ribbonBorder;
});
Clazz.defineMethod (c$, "getCartoonFlag", 
function (tok) {
switch (tok) {
case 603979819:
return this.global.cartoonRockets;
case 603979820:
return this.global.cartoonFancy;
case 603979900:
return this.global.rocketBarrels;
case 603979818:
return this.global.cartoonBaseEdges;
}
return false;
}, "~N");
Clazz.defineMethod (c$, "setStrandCount", 
($fz = function (type, value) {
value = org.jmol.viewer.Viewer.checkIntRange (value, 0, 20);
switch (type) {
case 12:
this.global.strandCountForStrands = value;
break;
case 13:
this.global.strandCountForMeshRibbon = value;
break;
default:
this.global.strandCountForStrands = value;
this.global.strandCountForMeshRibbon = value;
break;
}
this.global.setParamI ("strandCount", value);
this.global.setParamI ("strandCountForStrands", this.global.strandCountForStrands);
this.global.setParamI ("strandCountForMeshRibbon", this.global.strandCountForMeshRibbon);
}, $fz.isPrivate = true, $fz), "~N,~N");
Clazz.defineMethod (c$, "getStrandCount", 
function (type) {
return (type == 12 ? this.global.strandCountForStrands : this.global.strandCountForMeshRibbon);
}, "~N");
Clazz.defineMethod (c$, "getHideNameInPopup", 
function () {
return this.global.hideNameInPopup;
});
Clazz.defineMethod (c$, "getNavigationPeriodic", 
function () {
return this.global.navigationPeriodic;
});
Clazz.defineMethod (c$, "setNavigationMode", 
($fz = function (TF) {
this.global.navigationMode = TF;
this.transformManager.setNavigationMode (TF);
}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "getNavigationMode", 
function () {
return this.global.navigationMode;
});
Clazz.defineMethod (c$, "setTransformManagerDefaults", 
($fz = function () {
this.transformManager.setCameraDepthPercent (this.global.cameraDepth);
this.transformManager.setPerspectiveDepth (this.global.perspectiveDepth);
this.transformManager.setStereoDegrees (-5);
this.transformManager.setVisualRange (this.global.visualRange);
this.transformManager.setSpinOff ();
this.transformManager.setVibrationPeriod (0);
this.transformManager.setFrameOffsets (this.frameOffsets);
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "getCameraFactors", 
function () {
return this.transformManager.getCameraFactors ();
});
Clazz.defineMethod (c$, "getZoomLarge", 
function () {
return this.global.zoomLarge;
});
Clazz.defineMethod (c$, "getTraceAlpha", 
function () {
return this.global.traceAlpha;
});
Clazz.defineMethod (c$, "getHermiteLevel", 
function () {
return (this.getSpinOn () ? 0 : this.global.hermiteLevel);
});
Clazz.defineMethod (c$, "getHighResolution", 
function () {
return this.global.highResolutionFlag;
});
Clazz.defineMethod (c$, "getLoadState", 
function (htParams) {
return this.global.getLoadState (htParams);
}, "java.util.Map");
Clazz.overrideMethod (c$, "setAutoBond", 
function (TF) {
this.global.setParamB ("autobond", TF);
this.global.autoBond = TF;
}, "~B");
Clazz.overrideMethod (c$, "getAutoBond", 
function () {
return this.global.autoBond;
});
Clazz.defineMethod (c$, "makeConnections", 
function (minDistance, maxDistance, order, connectOperation, bsA, bsB, bsBonds, isBonds, addGroup, energy) {
this.clearModelDependentObjects ();
this.clearMinimization ();
return this.modelSet.makeConnections (minDistance, maxDistance, order, connectOperation, bsA, bsB, bsBonds, isBonds, addGroup, energy);
}, "~N,~N,~N,~N,org.jmol.util.BitSet,org.jmol.util.BitSet,org.jmol.util.BitSet,~B,~B,~N");
Clazz.overrideMethod (c$, "rebond", 
function () {
this.rebondState (false);
});
Clazz.defineMethod (c$, "rebondState", 
function (isStateScript) {
this.clearModelDependentObjects ();
this.modelSet.deleteAllBonds ();
var isLegacy = isStateScript && this.checkAutoBondLegacy ();
this.modelSet.autoBondBs4 (null, null, null, null, this.getMadBond (), isLegacy);
this.addStateScript ((isLegacy ? "set legacyAutoBonding TRUE;connect;set legacyAutoBonding FALSE;" : "connect;"), false, true);
}, "~B");
Clazz.defineMethod (c$, "setPdbConectBonding", 
function (isAuto, isStateScript) {
this.clearModelDependentObjects ();
this.modelSet.deleteAllBonds ();
var bsExclude =  new org.jmol.util.BitSet ();
this.modelSet.setPdbConectBonding (0, 0, bsExclude);
if (isAuto) {
var isLegacy = isStateScript && this.checkAutoBondLegacy ();
this.modelSet.autoBondBs4 (null, null, bsExclude, null, this.getMadBond (), isLegacy);
this.addStateScript ((isLegacy ? "set legacyAutoBonding TRUE;connect PDB AUTO;set legacyAutoBonding FALSE;" : "connect PDB auto;"), false, true);
return;
}this.addStateScript ("connect PDB;", false, true);
}, "~B,~B");
Clazz.defineMethod (c$, "getGreyscaleRendering", 
function () {
return this.global.greyscaleRendering;
});
Clazz.defineMethod (c$, "getDisablePopupMenu", 
function () {
return this.global.disablePopupMenu;
});
Clazz.defineMethod (c$, "getForceAutoBond", 
function () {
return this.global.forceAutoBond;
});
Clazz.overrideMethod (c$, "setPercentVdwAtom", 
function (value) {
this.global.setParamI ("percentVdwAtom", value);
this.global.percentVdwAtom = value;
this.rd.value = value / 100;
this.rd.factorType = org.jmol.atomdata.RadiusData.EnumType.FACTOR;
this.rd.vdwType = org.jmol.constant.EnumVdw.AUTO;
this.setShapeSize (0, this.rd, null);
}, "~N");
Clazz.overrideMethod (c$, "getPercentVdwAtom", 
function () {
return this.global.percentVdwAtom;
});
Clazz.defineMethod (c$, "getDefaultRadiusData", 
function () {
return this.rd;
});
Clazz.overrideMethod (c$, "getMadBond", 
function () {
return (this.global.bondRadiusMilliAngstroms * 2);
});
Clazz.defineMethod (c$, "getMarBond", 
function () {
return this.global.bondRadiusMilliAngstroms;
});
Clazz.defineMethod (c$, "getModeMultipleBond", 
function () {
return this.global.modeMultipleBond;
});
Clazz.defineMethod (c$, "getShowMultipleBonds", 
function () {
return this.global.showMultipleBonds;
});
Clazz.defineMethod (c$, "getMultipleBondSpacing", 
function () {
return this.global.multipleBondSpacing;
});
Clazz.defineMethod (c$, "getMultipleBondRadiusFactor", 
function () {
return this.global.multipleBondRadiusFactor;
});
Clazz.overrideMethod (c$, "setShowHydrogens", 
function (TF) {
this.global.setParamB ("showHydrogens", TF);
this.global.showHydrogens = TF;
}, "~B");
Clazz.overrideMethod (c$, "getShowHydrogens", 
function () {
return this.global.showHydrogens;
});
Clazz.defineMethod (c$, "getShowHiddenSelectionHalos", 
function () {
return this.global.showHiddenSelectionHalos;
});
Clazz.overrideMethod (c$, "setShowBbcage", 
function (value) {
this.setObjectMad (31, "boundbox", (value ? -4 : 0));
this.global.setParamB ("showBoundBox", value);
}, "~B");
Clazz.overrideMethod (c$, "getShowBbcage", 
function () {
return this.getObjectMad (4) != 0;
});
Clazz.defineMethod (c$, "setShowUnitCell", 
function (value) {
this.setObjectMad (32, "unitcell", (value ? -2 : 0));
this.global.setParamB ("showUnitCell", value);
}, "~B");
Clazz.defineMethod (c$, "getShowUnitCell", 
function () {
return this.getObjectMad (5) != 0;
});
Clazz.overrideMethod (c$, "setShowAxes", 
function (value) {
this.setObjectMad (30, "axes", (value ? -2 : 0));
this.global.setParamB ("showAxes", value);
}, "~B");
Clazz.overrideMethod (c$, "getShowAxes", 
function () {
return this.getObjectMad (1) != 0;
});
Clazz.overrideMethod (c$, "setFrankOn", 
function (TF) {
if (this.$isPreviewOnly) TF = false;
this.frankOn = TF;
this.setObjectMad (34, "frank", (TF ? 1 : 0));
}, "~B");
Clazz.defineMethod (c$, "getShowFrank", 
function () {
if (this.$isPreviewOnly || this.$isApplet && this.creatingImage) return false;
return (this.$isSignedApplet && !this.isSignedAppletLocal || this.frankOn);
});
Clazz.defineMethod (c$, "isSignedApplet", 
function () {
return this.$isSignedApplet;
});
Clazz.overrideMethod (c$, "setShowMeasurements", 
function (TF) {
this.global.setParamB ("showMeasurements", TF);
this.global.showMeasurements = TF;
}, "~B");
Clazz.overrideMethod (c$, "getShowMeasurements", 
function () {
return this.global.showMeasurements;
});
Clazz.defineMethod (c$, "getShowMeasurementLabels", 
function () {
return this.global.measurementLabels;
});
Clazz.defineMethod (c$, "getMeasureAllModelsFlag", 
function () {
return this.global.measureAllModels;
});
Clazz.defineMethod (c$, "setUnits", 
function (units, isDistance) {
this.global.setUnits (units);
if (isDistance) {
this.global.setUnits (units);
this.setShapeProperty (6, "reformatDistances", null);
} else {
}}, "~S,~B");
Clazz.defineMethod (c$, "getMeasureDistanceUnits", 
function () {
return this.global.measureDistanceUnits;
});
Clazz.defineMethod (c$, "getEnergyUnits", 
function () {
return this.global.energyUnits;
});
Clazz.defineMethod (c$, "setAppendNew", 
function (value) {
this.global.appendNew = value;
}, "~B");
Clazz.defineMethod (c$, "getAppendNew", 
function () {
return this.global.appendNew;
});
Clazz.defineMethod (c$, "getAutoFps", 
function () {
return this.global.autoFps;
});
Clazz.overrideMethod (c$, "setRasmolDefaults", 
function () {
this.setDefaultsType ("RasMol");
});
Clazz.overrideMethod (c$, "setJmolDefaults", 
function () {
this.setDefaults ();
});
Clazz.defineMethod (c$, "setDefaultsType", 
($fz = function (type) {
if (type.equalsIgnoreCase ("RasMol")) {
this.stateManager.setRasMolDefaults ();
return;
}this.setDefaults ();
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "setDefaults", 
($fz = function () {
this.setShapeSize (0, this.rd, this.getModelUndeletedAtomsBitSet (-1));
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "getZeroBasedXyzRasmol", 
function () {
return this.global.zeroBasedXyzRasmol;
});
Clazz.defineMethod (c$, "setAntialias", 
($fz = function (mode, TF) {
switch (mode) {
case 0:
this.global.antialiasDisplay = TF;
break;
case 1:
this.global.antialiasTranslucent = TF;
break;
case 2:
this.global.antialiasImages = TF;
return;
}
this.resizeImage (0, 0, false, false, true);
}, $fz.isPrivate = true, $fz), "~N,~B");
Clazz.defineMethod (c$, "allocTempPoints", 
function (size) {
return this.tempManager.allocTempPoints (size);
}, "~N");
Clazz.defineMethod (c$, "freeTempPoints", 
function (tempPoints) {
this.tempManager.freeTempPoints (tempPoints);
}, "~A");
Clazz.defineMethod (c$, "allocTempScreens", 
function (size) {
return this.tempManager.allocTempScreens (size);
}, "~N");
Clazz.defineMethod (c$, "freeTempScreens", 
function (tempScreens) {
this.tempManager.freeTempScreens (tempScreens);
}, "~A");
Clazz.defineMethod (c$, "allocTempEnum", 
function (size) {
return this.tempManager.allocTempEnum (size);
}, "~N");
Clazz.defineMethod (c$, "freeTempEnum", 
function (temp) {
this.tempManager.freeTempEnum (temp);
}, "~A");
Clazz.defineMethod (c$, "getFont3D", 
function (fontFace, fontStyle, fontSize) {
return this.gdata.getFont3DFSS (fontFace, fontStyle, fontSize);
}, "~S,~S,~N");
Clazz.defineMethod (c$, "formatText", 
function (text0) {
var i;
if ((i = text0.indexOf ("@{")) < 0 && (i = text0.indexOf ("%{")) < 0) return text0;
var text = text0;
var isEscaped = (text.indexOf ("\\") >= 0);
if (isEscaped) {
text = org.jmol.util.TextFormat.simpleReplace (text, "\\%", "\1");
text = org.jmol.util.TextFormat.simpleReplace (text, "\\@", "\2");
isEscaped = !text.equals (text0);
}text = org.jmol.util.TextFormat.simpleReplace (text, "%{", "@{");
var name;
while ((i = text.indexOf ("@{")) >= 0) {
i++;
var i0 = i + 1;
var len = text.length;
i = org.jmol.script.ScriptCompiler.ichMathTerminator (text, i, len);
if (i >= len) return text;
name = text.substring (i0, i);
if (name.length == 0) return text;
var v = this.evaluateExpression (name);
if (Clazz.instanceOf (v, org.jmol.util.Point3f)) v = org.jmol.util.Escape.escapePt (v);
text = text.substring (0, i0 - 2) + v.toString () + text.substring (i + 1);
}
if (isEscaped) {
text = org.jmol.util.TextFormat.simpleReplace (text, "\2", "@");
text = org.jmol.util.TextFormat.simpleReplace (text, "\1", "%");
}return text;
}, "~S");
Clazz.defineMethod (c$, "getElementSymbol", 
function (i) {
return this.modelSet.getElementSymbol (i);
}, "~N");
Clazz.defineMethod (c$, "getElementNumber", 
function (i) {
return this.modelSet.getElementNumber (i);
}, "~N");
Clazz.overrideMethod (c$, "getAtomName", 
function (i) {
return this.modelSet.getAtomName (i);
}, "~N");
Clazz.overrideMethod (c$, "getAtomNumber", 
function (i) {
return this.modelSet.getAtomNumber (i);
}, "~N");
Clazz.defineMethod (c$, "getAtomGroupQuaternions", 
function (bsAtoms, nMax) {
return this.modelSet.getAtomGroupQuaternions (bsAtoms, nMax, this.getQuaternionFrame ());
}, "org.jmol.util.BitSet,~N");
Clazz.defineMethod (c$, "getAtomQuaternion", 
function (i) {
return this.modelSet.getQuaternion (i, this.getQuaternionFrame ());
}, "~N");
Clazz.overrideMethod (c$, "getAtomPoint3f", 
function (i) {
return this.modelSet.atoms[i];
}, "~N");
Clazz.defineMethod (c$, "getAtomPointVector", 
function (bs) {
return this.modelSet.getAtomPointVector (bs);
}, "org.jmol.util.BitSet");
Clazz.overrideMethod (c$, "getAtomRadius", 
function (i) {
return this.modelSet.getAtomRadius (i);
}, "~N");
Clazz.overrideMethod (c$, "getAtomArgb", 
function (i) {
return this.gdata.getColorArgbOrGray (this.modelSet.getAtomColix (i));
}, "~N");
Clazz.defineMethod (c$, "getAtomChain", 
function (i) {
return this.modelSet.getAtomChain (i);
}, "~N");
Clazz.overrideMethod (c$, "getAtomModelIndex", 
function (i) {
return this.modelSet.atoms[i].modelIndex;
}, "~N");
Clazz.defineMethod (c$, "getAtomSequenceCode", 
function (i) {
return this.modelSet.atoms[i].getSeqcodeString ();
}, "~N");
Clazz.overrideMethod (c$, "getBondRadius", 
function (i) {
return this.modelSet.getBondRadius (i);
}, "~N");
Clazz.overrideMethod (c$, "getBondOrder", 
function (i) {
return this.modelSet.getBondOrder (i);
}, "~N");
Clazz.defineMethod (c$, "assignAromaticBonds", 
function () {
this.modelSet.assignAromaticBonds ();
});
Clazz.defineMethod (c$, "getSmartAromatic", 
function () {
return this.global.smartAromatic;
});
Clazz.defineMethod (c$, "resetAromatic", 
function () {
this.modelSet.resetAromatic ();
});
Clazz.overrideMethod (c$, "getBondArgb1", 
function (i) {
return this.gdata.getColorArgbOrGray (this.modelSet.getBondColix1 (i));
}, "~N");
Clazz.overrideMethod (c$, "getBondModelIndex", 
function (i) {
return this.modelSet.getBondModelIndex (i);
}, "~N");
Clazz.overrideMethod (c$, "getBondArgb2", 
function (i) {
return this.gdata.getColorArgbOrGray (this.modelSet.getBondColix2 (i));
}, "~N");
Clazz.overrideMethod (c$, "getPolymerLeadMidPoints", 
function (modelIndex, polymerIndex) {
return this.modelSet.getPolymerLeadMidPoints (modelIndex, polymerIndex);
}, "~N,~N");
Clazz.defineMethod (c$, "setStereoMode", 
function (twoColors, stereoMode, degrees) {
this.setFloatProperty ("stereoDegrees", degrees);
this.setBooleanProperty ("greyscaleRendering", stereoMode.isBiColor ());
if (twoColors != null) this.transformManager.setStereoMode2 (twoColors);
 else this.transformManager.setStereoMode (stereoMode);
}, "~A,org.jmol.constant.EnumStereoMode,~N");
Clazz.defineMethod (c$, "isStereoDouble", 
function () {
return this.transformManager.stereoMode === org.jmol.constant.EnumStereoMode.DOUBLE;
});
Clazz.overrideMethod (c$, "getOperatingSystemName", 
function () {
return org.jmol.viewer.Viewer.strOSName;
});
Clazz.overrideMethod (c$, "getJavaVendor", 
function () {
return org.jmol.viewer.Viewer.strJavaVendor;
});
Clazz.overrideMethod (c$, "getJavaVersion", 
function () {
return org.jmol.viewer.Viewer.strJavaVersion;
});
Clazz.defineMethod (c$, "getGraphicsData", 
function () {
return this.gdata;
});
Clazz.overrideMethod (c$, "showModelSetDownload", 
function () {
return true;
});
Clazz.defineMethod (c$, "isScriptEditorVisible", 
function () {
return this.scriptEditorVisible;
});
Clazz.overrideMethod (c$, "getProperty", 
function (returnType, infoType, paramInfo) {
if (!"DATA_API".equals (returnType)) return org.jmol.viewer.PropertyManager.getProperty (this, returnType, infoType, paramInfo);
switch (("scriptCheck.........scriptContext.......scriptEditor........scriptEditorState...getAppConsole.......getScriptEditor.....setMenu.............spaceGroupInfo......disablePopupMenu....defaultDirectory....getPopupMenu........shapeManager........consoleText.........").indexOf (infoType)) {
case 0:
return this.scriptCheckRet (paramInfo, true);
case 20:
return this.eval.getScriptContext ();
case 40:
this.showEditor (paramInfo);
return null;
case 60:
this.scriptEditorVisible = (paramInfo).booleanValue ();
return null;
case 80:
if (this.$isKiosk) {
this.appConsole = null;
} else if (Clazz.instanceOf (paramInfo, org.jmol.api.JmolAppConsoleInterface)) {
this.appConsole = paramInfo;
} else if (paramInfo != null && !(paramInfo).booleanValue ()) {
this.appConsole = null;
} else if (this.appConsole == null && paramInfo != null && (paramInfo).booleanValue ()) {
for (var i = 0; i < 4 && this.appConsole == null; i++) {
this.appConsole = (this.$isApplet ? org.jmol.api.Interface.getOptionInterface ("console.AppletConsole") : org.jmol.api.Interface.getApplicationInterface ("jmolpanel.AppConsole")).getAppConsole (this);
if (this.appConsole == null) try {
Thread.currentThread ().wait (100);
} catch (e) {
if (Clazz.exceptionOf (e, InterruptedException)) {
} else {
throw e;
}
}
}
}this.scriptEditor = (this.appConsole == null ? null : this.appConsole.getScriptEditor ());
return this.appConsole;
case 100:
if (this.appConsole == null && paramInfo != null && (paramInfo).booleanValue ()) {
this.getProperty ("DATA_API", "getAppConsole", Boolean.TRUE);
this.scriptEditor = (this.appConsole == null ? null : this.appConsole.getScriptEditor ());
}return this.scriptEditor;
case 120:
if (this.jmolpopup != null) this.jmolpopup.dispose ();
this.jmolpopup = null;
return this.menuStructure = paramInfo;
case 140:
return this.getSpaceGroupInfo (null);
case 160:
this.global.disablePopupMenu = true;
return null;
case 180:
return this.global.defaultDirectory;
case 200:
if (Clazz.instanceOf (paramInfo, String)) return this.getMenu (paramInfo);
return this.getPopupMenu ();
case 220:
return this.shapeManager.getProperty (paramInfo);
case 240:
return (this.appConsole == null ? "" : this.appConsole.getText ());
}
org.jmol.util.Logger.error ("ERROR in getProperty DATA_API: " + infoType);
return null;
}, "~S,~S,~O");
Clazz.defineMethod (c$, "showEditor", 
function (file_text) {
if (file_text == null) file_text = [null, null];
if (file_text[1] == null) file_text[1] = "<no data>";
var filename = file_text[0];
var msg = file_text[1];
var scriptEditor = this.getProperty ("DATA_API", "getScriptEditor", Boolean.TRUE);
if (scriptEditor == null) return;
if (msg != null) {
scriptEditor.setFilename (filename);
scriptEditor.output (org.jmol.io.JmolBinary.getEmbeddedScript (msg));
}scriptEditor.setVisible (true);
}, "~A");
Clazz.defineMethod (c$, "getModelExtract", 
function (atomExpression, doTransform, type) {
return this.modelSet.getModelExtract (this.getAtomBitSet (atomExpression), doTransform, false, type);
}, "~O,~B,~S");
Clazz.defineMethod (c$, "setTainted", 
function (TF) {
this.isTainted = this.axesAreTainted = (TF && (this.refreshing || this.creatingImage));
}, "~B");
Clazz.defineMethod (c$, "notifyMouseClicked", 
function (x, y, action, mode) {
var modifiers = org.jmol.viewer.binding.Binding.getModifiers (action);
var clickCount = org.jmol.viewer.binding.Binding.getClickCount (action);
this.global.setParamI ("_mouseX", x);
this.global.setParamI ("_mouseY", this.dimScreen.height - y);
this.global.setParamI ("_mouseAction", action);
this.global.setParamI ("_mouseModifiers", modifiers);
this.global.setParamI ("_clickCount", clickCount);
return this.statusManager.setStatusClicked (x, this.dimScreen.height - y, action, clickCount, mode);
}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "checkObjectClicked", 
function (x, y, modifiers) {
return this.shapeManager.checkObjectClicked (x, y, modifiers, this.getVisibleFramesBitSet ());
}, "~N,~N,~N");
Clazz.defineMethod (c$, "checkObjectHovered", 
function (x, y) {
return (this.shapeManager != null && this.shapeManager.checkObjectHovered (x, y, this.getVisibleFramesBitSet (), this.getBondPicking ()));
}, "~N,~N");
Clazz.defineMethod (c$, "checkObjectDragged", 
function (prevX, prevY, x, y, action) {
var iShape = 0;
switch (this.getPickingMode ()) {
case 2:
iShape = 5;
break;
case 4:
iShape = 22;
break;
}
if (this.shapeManager.checkObjectDragged (prevX, prevY, x, y, action, this.getVisibleFramesBitSet (), iShape)) {
this.refresh (1, "checkObjectDragged");
if (iShape == 22) this.scriptEcho (this.getShapeProperty (22, "command"));
}}, "~N,~N,~N,~N,~N");
Clazz.defineMethod (c$, "rotateAxisAngleAtCenter", 
function (eval, rotCenter, rotAxis, degreesPerSecond, endDegrees, isSpin, bsSelected) {
var isOK = this.transformManager.rotateAxisAngleAtCenter (eval, rotCenter, rotAxis, degreesPerSecond, endDegrees, isSpin, bsSelected);
if (isOK) this.refresh (-1, "rotateAxisAngleAtCenter");
return isOK;
}, "org.jmol.script.ScriptEvaluator,org.jmol.util.Point3f,org.jmol.util.Vector3f,~N,~N,~B,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "rotateAboutPointsInternal", 
function (eval, point1, point2, degreesPerSecond, endDegrees, isSpin, bsSelected, translation, finalPoints) {
var isOK = this.transformManager.rotateAboutPointsInternal (eval, point1, point2, degreesPerSecond, endDegrees, false, isSpin, bsSelected, false, translation, finalPoints);
if (isOK) this.refresh (-1, "rotateAxisAboutPointsInternal");
return isOK;
}, "org.jmol.script.ScriptEvaluator,org.jmol.util.Point3f,org.jmol.util.Point3f,~N,~N,~B,org.jmol.util.BitSet,org.jmol.util.Vector3f,java.util.List");
Clazz.defineMethod (c$, "getPickingSpinRate", 
function () {
return this.global.pickingSpinRate;
});
Clazz.defineMethod (c$, "startSpinningAxis", 
function (pt1, pt2, isClockwise) {
if (this.getSpinOn () || this.getNavOn ()) {
this.setSpinOn (false);
this.setNavOn (false);
return;
}this.transformManager.rotateAboutPointsInternal (null, pt1, pt2, this.global.pickingSpinRate, 3.4028235E38, isClockwise, true, null, false, null, null);
}, "org.jmol.util.Point3f,org.jmol.util.Point3f,~B");
Clazz.defineMethod (c$, "getModelDipole", 
function () {
return this.modelSet.getModelDipole (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "calculateMolecularDipole", 
function () {
return this.modelSet.calculateMolecularDipole (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "getDipoleScale", 
function () {
return this.global.dipoleScale;
});
Clazz.defineMethod (c$, "getAtomIdentityInfo", 
function (atomIndex, info) {
this.modelSet.getAtomIdentityInfo (atomIndex, info);
}, "~N,java.util.Map");
Clazz.defineMethod (c$, "setDefaultLattice", 
function (ptLattice) {
this.global.setDefaultLattice (ptLattice);
this.global.setParamS ("defaultLattice", org.jmol.util.Escape.escapePt (ptLattice));
}, "org.jmol.util.Point3f");
Clazz.defineMethod (c$, "getDefaultLattice", 
function () {
return this.global.getDefaultLattice ();
});
Clazz.defineMethod (c$, "getTaintedAtoms", 
function (type) {
return this.modelSet.getTaintedAtoms (type);
}, "~N");
Clazz.defineMethod (c$, "setTaintedAtoms", 
function (bs, type) {
this.modelSet.setTaintedAtoms (bs, type);
}, "org.jmol.util.BitSet,~N");
Clazz.defineMethod (c$, "getData", 
function (atomExpression, type) {
var exp = "";
if (type.equalsIgnoreCase ("MOL") || type.equalsIgnoreCase ("SDF") || type.equalsIgnoreCase ("V2000") || type.equalsIgnoreCase ("V3000") || type.equalsIgnoreCase ("XYZVIB") || type.equalsIgnoreCase ("CD")) return this.getModelExtract (atomExpression, false, type);
if (type.toLowerCase ().indexOf ("property_") == 0) exp = "{selected}.label(\"%{" + type + "}\")";
 else if (type.equalsIgnoreCase ("CML")) return this.getModelCml (this.getAtomBitSet (atomExpression), 2147483647, true);
 else if (type.equalsIgnoreCase ("PDB")) exp = "{selected and not hetero}.label(\"ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines";
 else if (type.equalsIgnoreCase ("XYZRN")) exp = "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %8.3x %8.3y %8.3z %4.2[vdw] 1 [%n]%r.%a#%i\").lines";
 else if (type.startsWith ("USER:")) exp = "{selected}.label(\"" + type.substring (5) + "\").lines";
 else exp = "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %10.5x %10.5y %10.5z\").lines";
if (!atomExpression.equals ("selected")) exp = org.jmol.util.TextFormat.simpleReplace (exp, "selected", atomExpression);
return this.evaluateExpression (exp);
}, "~S,~S");
Clazz.defineMethod (c$, "getModelCml", 
function (bs, nAtomsMax, addBonds) {
return this.modelSet.getModelCml (bs, nAtomsMax, addBonds);
}, "org.jmol.util.BitSet,~N,~B");
Clazz.defineMethod (c$, "evaluateExpression", 
function (stringOrTokens) {
return org.jmol.script.ScriptEvaluator.evaluateExpression (this, stringOrTokens, false);
}, "~O");
Clazz.defineMethod (c$, "evaluateExpressionAsVariable", 
function (stringOrTokens) {
return org.jmol.script.ScriptEvaluator.evaluateExpression (this, stringOrTokens, true);
}, "~O");
Clazz.defineMethod (c$, "getHelixData", 
function (bs, tokType) {
return this.modelSet.getHelixData (bs, tokType);
}, "org.jmol.util.BitSet,~N");
Clazz.defineMethod (c$, "getPdbData", 
function (bs, sb) {
if (bs == null) bs = this.getSelectionSet (true);
return this.modelSet.getPdbAtomData (bs, sb);
}, "org.jmol.util.BitSet,org.jmol.io.OutputStringBuilder");
Clazz.defineMethod (c$, "isJmolDataFrameForModel", 
function (modelIndex) {
return this.modelSet.isJmolDataFrameForModel (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "isJmolDataFrame", 
function () {
return this.modelSet.isJmolDataFrameForModel (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "getJmolDataFrameIndex", 
function (modelIndex, type) {
return this.modelSet.getJmolDataFrameIndex (modelIndex, type);
}, "~N,~S");
Clazz.defineMethod (c$, "setJmolDataFrame", 
function (type, modelIndex, dataIndex) {
this.modelSet.setJmolDataFrame (type, modelIndex, dataIndex);
}, "~S,~N,~N");
Clazz.defineMethod (c$, "setFrameTitle", 
function (modelIndex, title) {
this.modelSet.setFrameTitle (org.jmol.util.BitSetUtil.newAndSetBit (modelIndex), title);
}, "~N,~S");
Clazz.defineMethod (c$, "setFrameTitleObj", 
function (title) {
this.loadShape (29);
this.modelSet.setFrameTitle (this.getVisibleFramesBitSet (), title);
}, "~O");
Clazz.defineMethod (c$, "getFrameTitle", 
function () {
return this.modelSet.getFrameTitle (this.animationManager.currentModelIndex);
});
Clazz.defineMethod (c$, "getJmolFrameType", 
function (modelIndex) {
return this.modelSet.getJmolFrameType (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "getJmolDataSourceFrame", 
function (modelIndex) {
return this.modelSet.getJmolDataSourceFrame (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "setAtomProperty", 
function (bs, tok, iValue, fValue, sValue, values, list) {
if (tok == 1649412112) this.shapeManager.deleteVdwDependentShapes (bs);
this.clearMinimization ();
this.modelSet.setAtomProperty (bs, tok, iValue, fValue, sValue, values, list);
switch (tok) {
case 1112541185:
case 1112541186:
case 1112541187:
case 1112541188:
case 1112541189:
case 1112541190:
case 1112539151:
case 1112539152:
case 1112539153:
case 1087375365:
this.refreshMeasures (true);
}
}, "org.jmol.util.BitSet,~N,~N,~N,~S,~A,~A");
Clazz.defineMethod (c$, "checkCoordinatesChanged", 
function () {
this.modelSet.recalculatePositionDependentQuantities (null, null);
this.refreshMeasures (true);
});
Clazz.defineMethod (c$, "setAtomCoord", 
function (atomIndex, x, y, z) {
this.modelSet.setAtomCoord (atomIndex, x, y, z);
}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "setAtomCoordRelative", 
function (atomIndex, x, y, z) {
this.modelSet.setAtomCoordRelative (atomIndex, x, y, z);
}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "setAtomCoord", 
function (bs, tokType, xyzValues) {
if (bs.cardinality () == 0) return;
this.modelSet.setAtomCoord (bs, tokType, xyzValues);
this.checkMinimization ();
this.statusManager.setStatusAtomMoved (bs);
}, "org.jmol.util.BitSet,~N,~O");
Clazz.defineMethod (c$, "setAtomCoordRelative", 
function (offset, bs) {
if (bs == null) bs = this.getSelectionSet (false);
if (bs.cardinality () == 0) return;
this.modelSet.setAtomCoordRelative (offset, bs);
this.checkMinimization ();
this.statusManager.setStatusAtomMoved (bs);
}, "org.jmol.util.Tuple3f,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "allowRotateSelected", 
function () {
return this.global.allowRotateSelected;
});
Clazz.defineMethod (c$, "invertAtomCoordPt", 
function (pt, bs) {
this.modelSet.invertSelected (pt, null, -1, null, bs);
this.checkMinimization ();
this.statusManager.setStatusAtomMoved (bs);
}, "org.jmol.util.Point3f,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "invertAtomCoordPlane", 
function (plane, bs) {
this.modelSet.invertSelected (null, plane, -1, null, bs);
this.checkMinimization ();
this.statusManager.setStatusAtomMoved (bs);
}, "org.jmol.util.Point4f,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "invertSelected", 
function (pt, plane, iAtom, invAtoms) {
var bs = this.getSelectionSet (false);
if (bs.cardinality () == 0) return;
this.modelSet.invertSelected (pt, plane, iAtom, invAtoms, bs);
this.checkMinimization ();
this.statusManager.setStatusAtomMoved (bs);
}, "org.jmol.util.Point3f,org.jmol.util.Point4f,~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "moveAtoms", 
function (mNew, matrixRotate, translation, center, isInternal, bsAtoms) {
if (bsAtoms.cardinality () == 0) return;
this.modelSet.moveAtoms (mNew, matrixRotate, translation, bsAtoms, center, isInternal);
this.checkMinimization ();
this.statusManager.setStatusAtomMoved (bsAtoms);
}, "org.jmol.util.Matrix3f,org.jmol.util.Matrix3f,org.jmol.util.Vector3f,org.jmol.util.Point3f,~B,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "moveSelected", 
function (deltaX, deltaY, deltaZ, x, y, bsSelected, isTranslation, asAtoms) {
if (deltaZ == 0) return;
if (x == -2147483648) this.rotateBondIndex = -1;
if (this.isJmolDataFrame ()) return;
if (deltaX == -2147483648) {
this.showSelected = true;
this.loadShape (8);
this.refresh (6, "moveSelected");
return;
}if (deltaX == 2147483647) {
if (!this.showSelected) return;
this.showSelected = false;
this.refresh (6, "moveSelected");
return;
}if (this.movingSelected) return;
this.movingSelected = true;
this.stopMinimization ();
if (this.rotateBondIndex >= 0 && x != -2147483648) {
this.actionRotateBond (deltaX, deltaY, x, y);
} else {
bsSelected = this.setMovableBitSet (bsSelected, !asAtoms);
if (bsSelected.cardinality () != 0) {
if (isTranslation) {
var ptCenter = this.getAtomSetCenter (bsSelected);
this.transformManager.finalizeTransformParameters ();
var f = (this.global.antialiasDisplay ? 2 : 1);
var ptScreen = this.transformPt (ptCenter);
var ptScreenNew;
if (deltaZ != -2147483648) ptScreenNew = org.jmol.util.Point3f.new3 (ptScreen.x, ptScreen.y, ptScreen.z + deltaZ + 0.5);
 else ptScreenNew = org.jmol.util.Point3f.new3 (ptScreen.x + deltaX * f + 0.5, ptScreen.y + deltaY * f + 0.5, ptScreen.z);
var ptNew =  new org.jmol.util.Point3f ();
this.unTransformPoint (ptScreenNew, ptNew);
ptNew.sub (ptCenter);
this.setAtomCoordRelative (ptNew, bsSelected);
} else {
this.transformManager.rotateXYBy (deltaX, deltaY, bsSelected);
}}}this.refresh (2, "");
this.movingSelected = false;
}, "~N,~N,~N,~N,~N,org.jmol.util.BitSet,~B,~B");
Clazz.defineMethod (c$, "highlightBond", 
function (index, isHover) {
if (isHover && !this.hoverEnabled) return;
var bs = null;
if (index >= 0) {
var b = this.modelSet.getBonds ()[index];
var i = b.getAtomIndex2 ();
if (!this.isAtomAssignable (i)) return;
bs = org.jmol.util.BitSetUtil.newAndSetBit (i);
bs.set (b.getAtomIndex1 ());
}this.highlight (bs);
this.refresh (3, "highlightBond");
}, "~N,~B");
Clazz.defineMethod (c$, "highlight", 
function (bs) {
if (bs != null) this.loadShape (8);
this.setShapeProperty (8, "highlight", bs);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "setRotateBondIndex", 
function (index) {
var haveBond = (this.rotateBondIndex >= 0);
if (!haveBond && index < 0) return;
this.rotatePrev1 = -1;
this.bsRotateBranch = null;
if (index == -2147483648) return;
this.rotateBondIndex = index;
this.highlightBond (index, false);
}, "~N");
Clazz.defineMethod (c$, "getRotateBondIndex", 
function () {
return this.rotateBondIndex;
});
Clazz.defineMethod (c$, "actionRotateBond", 
function (deltaX, deltaY, x, y) {
if (this.rotateBondIndex < 0) return;
var bsBranch = this.bsRotateBranch;
var atom1;
var atom2;
if (bsBranch == null) {
var b = this.modelSet.getBonds ()[this.rotateBondIndex];
atom1 = b.getAtom1 ();
atom2 = b.getAtom2 ();
this.undoMoveActionClear (atom1.index, 2, true);
var pt = org.jmol.util.Point3f.new3 (x, y, Clazz.doubleToInt ((atom1.screenZ + atom2.screenZ) / 2));
this.transformManager.unTransformPoint (pt, pt);
if (atom2.getCovalentBondCount () == 1 || pt.distance (atom1) < pt.distance (atom2) && atom1.getCovalentBondCount () != 1) {
var a = atom1;
atom1 = atom2;
atom2 = a;
}if (org.jmol.util.Measure.computeAngleABC (pt, atom1, atom2, true) > 90 || org.jmol.util.Measure.computeAngleABC (pt, atom2, atom1, true) > 90) {
bsBranch = this.getBranchBitSet (atom2.index, atom1.index);
}if (bsBranch != null) for (var n = 0, i = atom1.getBonds ().length; --i >= 0; ) {
if (bsBranch.get (atom1.getBondedAtomIndex (i)) && ++n == 2) {
bsBranch = null;
break;
}}
if (bsBranch == null) {
bsBranch = this.getMoleculeBitSet (atom1.index);
}this.bsRotateBranch = bsBranch;
this.rotatePrev1 = atom1.index;
this.rotatePrev2 = atom2.index;
} else {
atom1 = this.modelSet.atoms[this.rotatePrev1];
atom2 = this.modelSet.atoms[this.rotatePrev2];
}var v1 = org.jmol.util.Vector3f.new3 (atom2.screenX - atom1.screenX, atom2.screenY - atom1.screenY, 0);
var v2 = org.jmol.util.Vector3f.new3 (deltaX, deltaY, 0);
v1.cross (v1, v2);
var degrees = (v1.z > 0 ? 1 : -1) * v2.length ();
var bs = org.jmol.util.BitSetUtil.copy (bsBranch);
bs.andNot (this.selectionManager.getMotionFixedAtoms ());
this.rotateAboutPointsInternal (this.eval, atom1, atom2, 0, degrees, false, bs, null, null);
}, "~N,~N,~N,~N");
Clazz.defineMethod (c$, "refreshMeasures", 
function (andStopMinimization) {
this.setShapeProperty (6, "refresh", null);
if (andStopMinimization) this.stopMinimization ();
}, "~B");
Clazz.defineMethod (c$, "setDynamicMeasurements", 
function (TF) {
this.global.dynamicMeasurements = TF;
}, "~B");
Clazz.defineMethod (c$, "getDynamicMeasurements", 
function () {
return this.global.dynamicMeasurements;
});
Clazz.defineMethod (c$, "functionXY", 
function (functionName, nX, nY) {
var data = null;
if (functionName.indexOf ("file:") == 0) data = this.getFileAsString (functionName.substring (5));
 else if (functionName.indexOf ("data2d_") != 0) return this.statusManager.functionXY (functionName, nX, nY);
nX = Math.abs (nX);
nY = Math.abs (nY);
var fdata;
if (data == null) {
fdata = this.getDataFloat2D (functionName);
if (fdata != null) return fdata;
data = "";
}fdata =  Clazz.newFloatArray (nX, nY, 0);
var f =  Clazz.newFloatArray (nX * nY, 0);
org.jmol.util.Parser.parseStringInfestedFloatArray (data, null, f);
for (var i = 0, n = 0; i < nX; i++) for (var j = 0; j < nY; j++) fdata[i][j] = f[n++];


return fdata;
}, "~S,~N,~N");
Clazz.defineMethod (c$, "functionXYZ", 
function (functionName, nX, nY, nZ) {
var data = null;
if (functionName.indexOf ("file:") == 0) data = this.getFileAsString (functionName.substring (5));
 else if (functionName.indexOf ("data3d_") != 0) return this.statusManager.functionXYZ (functionName, nX, nY, nZ);
nX = Math.abs (nX);
nY = Math.abs (nY);
nZ = Math.abs (nZ);
var xyzdata;
if (data == null) {
xyzdata = this.getDataFloat3D (functionName);
if (xyzdata != null) return xyzdata;
data = "";
}xyzdata =  Clazz.newFloatArray (nX, nY, nZ, 0);
var f =  Clazz.newFloatArray (nX * nY * nZ, 0);
org.jmol.util.Parser.parseStringInfestedFloatArray (data, null, f);
for (var i = 0, n = 0; i < nX; i++) for (var j = 0; j < nY; j++) for (var k = 0; k < nZ; k++) xyzdata[i][j][k] = f[n++];



return xyzdata;
}, "~S,~N,~N,~N");
Clazz.defineMethod (c$, "showNMR", 
function (smiles) {
this.showUrl (this.global.nmrUrlFormat + org.jmol.util.Escape.escapeUrl (this.getChemicalInfo (smiles, '/', "smiles")));
}, "~S");
Clazz.defineMethod (c$, "getHelp", 
function (what) {
if (this.global.helpPath.indexOf ("?") < 0) {
if (what.length > 0 && what.indexOf ("?") != 0) what = "?search=" + org.jmol.util.TextFormat.simpleReplace (what, " ", "%20");
what += (what.length == 0 ? "?ver=" : "&ver=") + org.jmol.viewer.JmolConstants.version;
} else {
what = "&" + what;
}this.showUrl (this.global.helpPath + what);
}, "~S");
Clazz.defineMethod (c$, "show2D", 
function (smiles) {
this.showUrl (this.setLoadFormat ("_" + smiles, '2', false));
}, "~S");
Clazz.defineMethod (c$, "getChemicalInfo", 
function (smiles, type, info) {
var s = this.setLoadFormat ("_" + smiles, type, false);
if (type == '/') s += org.jmol.util.TextFormat.simpleReplace (info, " ", "%20");
return this.getFileAsStringBin (s, 2147483647, false, false);
}, "~S,~S,~S");
Clazz.defineMethod (c$, "addCommand", 
function (command) {
if (this.autoExit || !this.haveDisplay || !this.getPreserveState ()) return;
this.commandHistory.addCommand (org.jmol.util.TextFormat.replaceAllCharacters (command, "\r\n\t", " "));
}, "~S");
Clazz.defineMethod (c$, "removeCommand", 
function () {
return this.commandHistory.removeCommand ();
});
Clazz.overrideMethod (c$, "getSetHistory", 
function (howFarBack) {
return this.commandHistory.getSetHistory (howFarBack);
}, "~N");
Clazz.overrideMethod (c$, "writeTextFile", 
function (fileName, data) {
this.createImage (fileName, "txt", data, -2147483648, 0, 0);
}, "~S,~S");
Clazz.overrideMethod (c$, "clipImage", 
function (text) {
if (!this.isRestricted (org.jmol.viewer.Viewer.ACCESS.ALL)) return "no";
var c;
try {
c = org.jmol.api.Interface.getOptionInterface ("export.image.ImageCreator");
c.setViewer (this, this.privateKey);
return c.clipImage (text);
} catch (er) {
if (Clazz.exceptionOf (er, Error)) {
return org.jmol.i18n.GT._ ("clipboard is not accessible -- use signed applet");
} else {
throw er;
}
}
}, "~S");
Clazz.defineMethod (c$, "createImageSet", 
function (fileName, type, text_or_bytes, scripts, quality, width, height, bsFrames, nVibes, fullPath) {
if (bsFrames == null && nVibes == 0) return this.createImagePathCheck (fileName, type, text_or_bytes, scripts, quality, width, height, fullPath, true);
var info = "";
var n = 0;
fileName = this.getFileNameFromDialog (fileName, quality);
if (fullPath != null) fullPath[0] = fileName;
if (fileName == null) return null;
var ptDot = fileName.indexOf (".");
if (ptDot < 0) ptDot = fileName.length;
var froot = fileName.substring (0, ptDot);
var fext = fileName.substring (ptDot);
var sb =  new org.jmol.util.StringXBuilder ();
text_or_bytes = [""];
if (bsFrames == null) {
this.transformManager.vibrationOn = true;
sb =  new org.jmol.util.StringXBuilder ();
for (var i = 0; i < nVibes; i++) {
for (var j = 0; j < 20; j++) {
this.transformManager.setVibrationT (j / 20 + 0.2501);
if (!this.writeFrame (++n, froot, fext, fullPath, type, text_or_bytes, quality, width, height, sb)) return "ERROR WRITING FILE SET: \n" + info;
}
}
this.setVibrationOff ();
} else {
for (var i = bsFrames.nextSetBit (0); i >= 0; i = bsFrames.nextSetBit (i + 1)) {
this.setCurrentModelIndex (i);
if (!this.writeFrame (++n, froot, fext, fullPath, type, text_or_bytes, quality, width, height, sb)) return "ERROR WRITING FILE SET: \n" + info;
}
}if (info.length == 0) info = "OK\n";
return info + "\n" + n + " files created";
}, "~S,~S,~O,~A,~N,~N,~N,org.jmol.util.BitSet,~N,~A");
Clazz.defineMethod (c$, "writeFrame", 
($fz = function (n, froot, fext, fullPath, type, text_or_bytes, quality, width, height, sb) {
var fileName = "0000" + n;
fileName = froot + fileName.substring (fileName.length - 4) + fext;
if (fullPath != null) fullPath[0] = fileName;
var msg = this.createImagePathCheck (fileName, type, text_or_bytes, null, quality, width, height, null, false);
this.scriptEcho (msg);
sb.append (msg).append ("\n");
return msg.startsWith ("OK");
}, $fz.isPrivate = true, $fz), "~N,~S,~S,~A,~S,~O,~N,~N,~N,org.jmol.util.StringXBuilder");
Clazz.defineMethod (c$, "getCreatingImage", 
function () {
return this.creatingImage;
});
Clazz.defineMethod (c$, "createZip", 
function (fileName, type, stateInfo, scripts) {
return this.createImagePathCheck (fileName, type, stateInfo, scripts, -2147483648, -1, -1, null, true);
}, "~S,~S,~S,~A");
Clazz.overrideMethod (c$, "createImage", 
function (fileName, type, text_or_bytes, quality, width, height) {
return this.createImagePathCheck (fileName, type, text_or_bytes, null, quality, width, height, null, true);
}, "~S,~S,~O,~N,~N,~N");
Clazz.defineMethod (c$, "createImagePathCheck", 
($fz = function (fileName, type, text_or_bytes, scripts, quality, width, height, fullPath, doCheck) {
if (type.equals ("JMOL")) type = "ZIPALL";
var saveWidth = this.dimScreen.width;
var saveHeight = this.dimScreen.height;
this.creatingImage = true;
if (quality != -2147483648) {
this.mustRender = true;
this.resizeImage (width, height, true, false, false);
this.setModelVisibility ();
}var err = null;
try {
if (fileName == null) {
err = this.clipImage (text_or_bytes);
} else {
if (doCheck) fileName = this.getFileNameFromDialog (fileName, quality);
if (fullPath != null) fullPath[0] = fileName;
if (fileName == null) {
err = "CANCELED";
} else if (type.equals ("ZIP") || type.equals ("ZIPALL")) {
if (scripts != null && type.equals ("ZIP")) type = "ZIPALL";
err = org.jmol.io.JmolBinary.createZipSet (this.fileManager, this, fileName, text_or_bytes, scripts, type.equals ("ZIPALL"));
} else if (type.equals ("SCENE")) {
err = this.createSceneSet (fileName, text_or_bytes, width, height);
} else {
if (!type.equals ("OutputStream")) err = this.statusManager.createImage (fileName, type, text_or_bytes, quality);
if (err == null) {
var c = org.jmol.api.Interface.getOptionInterface ("export.image.ImageCreator");
c.setViewer (this, this.privateKey);
err = c.createImage (fileName, type, text_or_bytes, scripts, quality);
if (Clazz.instanceOf (err, String)) this.statusManager.createImage (err, type, null, quality);
}}}} catch (er) {
er.printStackTrace ();
org.jmol.util.Logger.error (this.setErrorMessage ((err = "ERROR creating image??: " + er), null));
}
this.creatingImage = false;
if (quality != -2147483648) {
this.resizeImage (saveWidth, saveHeight, true, false, true);
}return ("CANCELED".equals (err) ? null : err);
}, $fz.isPrivate = true, $fz), "~S,~S,~O,~A,~N,~N,~N,~A,~B");
Clazz.defineMethod (c$, "getFileNameFromDialog", 
($fz = function (fileName, quality) {
if (fileName == null || this.$isKiosk) return null;
var useDialog = (fileName.indexOf ("?") == 0);
if (useDialog) fileName = fileName.substring (1);
useDialog = new Boolean (useDialog | this.$isApplet).valueOf ();
fileName = org.jmol.viewer.FileManager.getLocalPathForWritingFile (this, fileName);
if (useDialog) fileName = this.dialogAsk (quality == -2147483648 ? "save" : "saveImage", fileName);
return fileName;
}, $fz.isPrivate = true, $fz), "~S,~N");
Clazz.defineMethod (c$, "setSyncTarget", 
($fz = function (mode, TF) {
switch (mode) {
case 0:
this.statusManager.syncingMouse = TF;
break;
case 1:
this.statusManager.syncingScripts = TF;
break;
case 2:
this.statusManager.syncSend (TF ? "GET_GRAPHICS" : "SET_GRAPHICS_OFF", "*", 0);
if (Float.isNaN (this.transformManager.stereoDegrees)) this.setFloatProperty ("stereoDegrees", -5);
if (TF) {
this.setBooleanProperty ("_syncMouse", false);
this.setBooleanProperty ("_syncScript", false);
}return;
}
if (!this.statusManager.syncingScripts && !this.statusManager.syncingMouse) this.refresh (-1, "set sync");
}, $fz.isPrivate = true, $fz), "~N,~B");
Clazz.overrideMethod (c$, "syncScript", 
function (script, applet, port) {
if ("GET_GRAPHICS".equalsIgnoreCase (script)) {
this.statusManager.setSyncDriver (5);
this.statusManager.syncSend (script, applet, 0);
this.setBooleanProperty ("_syncMouse", false);
this.setBooleanProperty ("_syncScript", false);
return;
}if ("=".equals (applet)) {
applet = "~";
this.statusManager.setSyncDriver (2);
}var disableSend = "~".equals (applet);
if (port > 0 || !disableSend && !".".equals (applet)) {
this.statusManager.syncSend (script, applet, port);
if (!"*".equals (applet) || script.startsWith ("{")) return;
}if (script.equalsIgnoreCase ("on") || script.equalsIgnoreCase ("true")) {
this.statusManager.setSyncDriver (1);
return;
}if (script.equalsIgnoreCase ("off") || script.equalsIgnoreCase ("false")) {
this.statusManager.setSyncDriver (0);
return;
}if (script.equalsIgnoreCase ("slave")) {
this.statusManager.setSyncDriver (2);
return;
}var syncMode = this.statusManager.getSyncMode ();
if (syncMode == 0) return;
if (syncMode != 1) disableSend = false;
if (org.jmol.util.Logger.debugging) org.jmol.util.Logger.debug (this.htmlName + " syncing with script: " + script);
if (disableSend) this.statusManager.setSyncDriver (3);
if (script.indexOf ("Mouse: ") != 0) {
if (script.startsWith ("Select: ")) {
var filename = org.jmol.util.Parser.getQuotedAttribute (script, "file");
var modelID = org.jmol.util.Parser.getQuotedAttribute (script, "model");
var baseModel = org.jmol.util.Parser.getQuotedAttribute (script, "baseModel");
var atoms = org.jmol.util.Parser.getQuotedAttribute (script, "atoms");
var select = org.jmol.util.Parser.getQuotedAttribute (script, "select");
var script2 = org.jmol.util.Parser.getQuotedAttribute (script, "script");
var isNIH = (modelID != null && modelID.startsWith ("$"));
if (isNIH) filename = (modelID.substring (1).equals (this.getParameter ("_smilesstring")) ? null : modelID);
var id = (isNIH || modelID == null ? null : (filename == null ? "" : filename + "#") + modelID);
if ("".equals (baseModel)) id += ".baseModel";
var modelIndex = (id == null ? -3 : this.getModelIndexFromId (id));
if (modelIndex == -2) return;
script = (modelIndex == -1 && filename != null ? script = "load " + org.jmol.util.Escape.escapeStr (filename) : "");
if (id != null) script += ";model " + org.jmol.util.Escape.escapeStr (id);
if (atoms != null) script += ";select visible & (@" + org.jmol.util.TextFormat.simpleReplace (atoms, ",", " or @") + ")";
 else if (select != null) script += ";select visible & (" + select + ")";
if (script2 != null) script += ";" + script2;
} else if (script.toLowerCase ().startsWith ("jspecview")) {
if (!disableSend) this.statusManager.syncSend (this.fullName + "JSpecView" + script.substring (9), ">", 0);
return;
}System.out.println ("Jmol executing script for JSpecView: " + script);
this.evalStringQuietSync (script, true, false);
return;
}var tokens = org.jmol.util.Parser.getTokens (script);
var key = tokens[1];
switch (tokens.length) {
case 3:
if (key.equals ("zoomByFactor")) this.zoomByFactor (org.jmol.util.Parser.parseFloatStr (tokens[2]), 2147483647, 2147483647);
 else if (key.equals ("zoomBy")) this.zoomBy (org.jmol.util.Parser.parseInt (tokens[2]));
 else if (key.equals ("rotateZBy")) this.rotateZBy (org.jmol.util.Parser.parseInt (tokens[2]), 2147483647, 2147483647);
break;
case 4:
if (key.equals ("rotateXYBy")) this.rotateXYBy (org.jmol.util.Parser.parseFloatStr (tokens[2]), org.jmol.util.Parser.parseFloatStr (tokens[3]));
 else if (key.equals ("translateXYBy")) this.translateXYBy (org.jmol.util.Parser.parseInt (tokens[2]), org.jmol.util.Parser.parseInt (tokens[3]));
 else if (key.equals ("rotateMolecule")) this.rotateSelected (org.jmol.util.Parser.parseFloatStr (tokens[2]), org.jmol.util.Parser.parseFloatStr (tokens[3]), null);
break;
case 5:
if (key.equals ("spinXYBy")) this.spinXYBy (org.jmol.util.Parser.parseInt (tokens[2]), org.jmol.util.Parser.parseInt (tokens[3]), org.jmol.util.Parser.parseFloatStr (tokens[4]));
 else if (key.equals ("zoomByFactor")) this.zoomByFactor (org.jmol.util.Parser.parseFloatStr (tokens[2]), org.jmol.util.Parser.parseInt (tokens[3]), org.jmol.util.Parser.parseInt (tokens[4]));
 else if (key.equals ("rotateZBy")) this.rotateZBy (org.jmol.util.Parser.parseInt (tokens[2]), org.jmol.util.Parser.parseInt (tokens[3]), org.jmol.util.Parser.parseInt (tokens[4]));
 else if (key.equals ("rotateArcBall")) this.rotateArcBall (org.jmol.util.Parser.parseInt (tokens[2]), org.jmol.util.Parser.parseInt (tokens[3]), org.jmol.util.Parser.parseFloatStr (tokens[4]));
break;
case 7:
if (key.equals ("centerAt")) this.centerAt (org.jmol.util.Parser.parseInt (tokens[2]), org.jmol.util.Parser.parseInt (tokens[3]), org.jmol.util.Point3f.new3 (org.jmol.util.Parser.parseFloatStr (tokens[4]), org.jmol.util.Parser.parseFloatStr (tokens[5]), org.jmol.util.Parser.parseFloatStr (tokens[6])));
}
if (disableSend) this.setSyncDriver (4);
}, "~S,~S,~N");
Clazz.defineMethod (c$, "getModelIndexFromId", 
function (id) {
return this.modelSet.getModelIndexFromId (id);
}, "~S");
Clazz.defineMethod (c$, "setSyncDriver", 
function (mode) {
this.statusManager.setSyncDriver (mode);
}, "~N");
Clazz.defineMethod (c$, "getPartialCharges", 
function () {
return this.modelSet.getPartialCharges ();
});
Clazz.defineMethod (c$, "getAtomicPotentials", 
function (isMep, bsSelected, bsIgnore, fileName) {
var potentials =  Clazz.newFloatArray (this.getAtomCount (), 0);
var m = org.jmol.api.Interface.getOptionInterface ("quantum.MlpCalculation");
var data = (fileName == null ? null : this.getFileAsString (fileName));
m.assignPotentials (this.modelSet.atoms, potentials, this.getSmartsMatch ("a", bsSelected), this.getSmartsMatch ("/noAromatic/[$(C=O),$(O=C),$(NC=O)]", bsSelected), bsIgnore, data);
return potentials;
}, "~B,org.jmol.util.BitSet,org.jmol.util.BitSet,~S");
Clazz.defineMethod (c$, "setProteinType", 
function (type, bs) {
this.modelSet.setProteinType (bs == null ? this.getSelectionSet (false) : bs, type);
}, "org.jmol.constant.EnumStructure,org.jmol.util.BitSet");
Clazz.overrideMethod (c$, "getBondPoint3f1", 
function (i) {
return this.modelSet.getBondAtom1 (i);
}, "~N");
Clazz.overrideMethod (c$, "getBondPoint3f2", 
function (i) {
return this.modelSet.getBondAtom2 (i);
}, "~N");
Clazz.defineMethod (c$, "getVibrationVector", 
function (atomIndex) {
return this.modelSet.getVibrationVector (atomIndex, false);
}, "~N");
Clazz.defineMethod (c$, "getVanderwaalsMar", 
function (i) {
return (this.dataManager.defaultVdw === org.jmol.constant.EnumVdw.USER ? this.dataManager.userVdwMars[i] : org.jmol.util.Elements.getVanderwaalsMar (i, this.dataManager.defaultVdw));
}, "~N");
Clazz.defineMethod (c$, "getVanderwaalsMarType", 
function (i, type) {
if (type == null) type = this.dataManager.defaultVdw;
 else switch (type) {
case org.jmol.constant.EnumVdw.USER:
if (this.dataManager.bsUserVdws == null) type = this.dataManager.defaultVdw;
 else return this.dataManager.userVdwMars[i];
break;
case org.jmol.constant.EnumVdw.AUTO:
case org.jmol.constant.EnumVdw.JMOL:
case org.jmol.constant.EnumVdw.BABEL:
case org.jmol.constant.EnumVdw.RASMOL:
if (this.dataManager.defaultVdw !== org.jmol.constant.EnumVdw.AUTO) type = this.dataManager.defaultVdw;
break;
}
return (org.jmol.util.Elements.getVanderwaalsMar (i, type));
}, "~N,org.jmol.constant.EnumVdw");
Clazz.defineMethod (c$, "setDefaultVdw", 
function (type) {
var vType = org.jmol.constant.EnumVdw.getVdwType (type);
if (vType == null) vType = org.jmol.constant.EnumVdw.AUTO;
this.dataManager.setDefaultVdw (vType);
this.global.setParamS ("defaultVDW", this.getDefaultVdwTypeNameOrData (-2147483648, null));
}, "~S");
Clazz.defineMethod (c$, "getDefaultVdwTypeNameOrData", 
function (iMode, vType) {
return this.dataManager.getDefaultVdwNameOrData (iMode, vType, null);
}, "~N,org.jmol.constant.EnumVdw");
Clazz.defineMethod (c$, "deleteAtoms", 
function (bs, fullModels) {
this.clearModelDependentObjects ();
if (!fullModels) {
this.modelSet.deleteAtoms (bs);
var n = this.selectionManager.deleteAtoms (bs);
this.setTainted (true);
return n;
}if (bs.cardinality () == 0) return 0;
this.setCurrentModelIndexClear (0, false);
this.animationManager.setAnimationOn (false);
var bsD0 = org.jmol.util.BitSetUtil.copy (this.getDeletedAtoms ());
var bsDeleted = this.modelSet.deleteModels (bs);
this.selectionManager.processDeletedModelAtoms (bsDeleted);
this.setAnimationRange (0, 0);
this.eval.deleteAtomsInVariables (bsDeleted);
this.clearRepaintManager (-1);
this.animationManager.clear ();
this.animationManager.initializePointers (1);
this.setCurrentModelIndexClear (this.getModelCount () > 1 ? -1 : 0, this.getModelCount () > 1);
this.hoverAtomIndex = -1;
this.setFileLoadStatus (org.jmol.constant.EnumFileStatus.DELETED, null, null, null, null);
this.refreshMeasures (true);
if (bsD0 != null) bsDeleted.andNot (bsD0);
return org.jmol.util.BitSetUtil.cardinalityOf (bsDeleted);
}, "org.jmol.util.BitSet,~B");
Clazz.defineMethod (c$, "deleteBonds", 
function (bsDeleted) {
this.modelSet.deleteBonds (bsDeleted, false);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "deleteModelAtoms", 
function (firstAtomIndex, nAtoms, bsDeleted) {
this.selectionManager.deleteModelAtoms (bsDeleted);
org.jmol.util.BitSetUtil.deleteBits (this.getFrameOffsets (), bsDeleted);
this.setFrameOffsets (this.getFrameOffsets ());
this.dataManager.deleteModelAtoms (firstAtomIndex, nAtoms, bsDeleted);
}, "~N,~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getDeletedAtoms", 
function () {
return this.selectionManager.getDeletedAtoms ();
});
Clazz.defineMethod (c$, "getQuaternionFrame", 
function () {
return this.global.quaternionFrame.charAt (this.global.quaternionFrame.length == 2 ? 1 : 0);
});
Clazz.defineMethod (c$, "getHelixStep", 
function () {
return this.global.helixStep;
});
Clazz.defineMethod (c$, "calculatePointGroup", 
function () {
return this.modelSet.calculatePointGroup (this.getSelectionSet (false));
});
Clazz.defineMethod (c$, "getPointGroupInfo", 
function (atomExpression) {
return this.modelSet.getPointGroupInfo (this.getAtomBitSet (atomExpression));
}, "~O");
Clazz.defineMethod (c$, "getPointGroupAsString", 
function (asDraw, type, index, scale) {
return this.modelSet.getPointGroupAsString (this.getSelectionSet (false), asDraw, type, index, scale);
}, "~B,~S,~N,~N");
Clazz.defineMethod (c$, "getPointGroupTolerance", 
function (type) {
switch (type) {
case 0:
return this.global.pointGroupDistanceTolerance;
case 1:
return this.global.pointGroupLinearTolerance;
}
return 0;
}, "~N");
Clazz.defineMethod (c$, "getFileAsImage", 
function (pathName, retFileNameOrError) {
return this.fileManager.getFileAsImage (pathName, retFileNameOrError);
}, "~S,~A");
Clazz.defineMethod (c$, "cd", 
function (dir) {
if (dir == null) {
dir = ".";
} else if (dir.length == 0) {
this.setStringProperty ("defaultDirectory", "");
dir = ".";
}dir = this.fileManager.getDefaultDirectory (dir + (dir.equals ("=") ? "" : dir.endsWith ("/") ? "X.spt" : "/X.spt"));
if (dir.length > 0) this.setStringProperty ("defaultDirectory", dir);
var path = this.fileManager.getFilePath (dir + "/", true, false);
if (path.startsWith ("file:/")) org.jmol.viewer.FileManager.setLocalPath (this, dir, false);
return dir;
}, "~S");
Clazz.defineMethod (c$, "setErrorMessage", 
function (errMsg, errMsgUntranslated) {
this.errorMessageUntranslated = errMsgUntranslated;
return (this.errorMessage = errMsg);
}, "~S,~S");
Clazz.overrideMethod (c$, "getErrorMessage", 
function () {
return this.errorMessage;
});
Clazz.overrideMethod (c$, "getErrorMessageUn", 
function () {
return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
});
Clazz.defineMethod (c$, "setShapeErrorState", 
function (shapeID, state) {
this.currentShapeID = shapeID;
this.currentShapeState = state;
}, "~N,~S");
Clazz.defineMethod (c$, "getShapeErrorState", 
function () {
if (this.currentShapeID < 0) return "";
if (this.modelSet != null) this.shapeManager.releaseShape (this.currentShapeID);
this.clearRepaintManager (this.currentShapeID);
return org.jmol.viewer.JmolConstants.getShapeClassName (this.currentShapeID, false) + " " + this.currentShapeState;
});
Clazz.defineMethod (c$, "handleError", 
function (er, doClear) {
try {
if (doClear) this.zapMsg ("" + er);
this.undoClear ();
if (org.jmol.util.Logger.getLogLevel () == 0) org.jmol.util.Logger.setLogLevel (4);
this.setCursor (0);
this.setBooleanProperty ("refreshing", true);
this.fileManager.setPathForAllFiles ("");
org.jmol.util.Logger.error ("viewer handling error condition: " + er);
this.notifyError ("Error", "doClear=" + doClear + "; " + er, "" + er);
} catch (e1) {
try {
org.jmol.util.Logger.error ("Could not notify error " + er + ": due to " + e1);
} catch (er2) {
}
}
}, "Error,~B");
Clazz.defineMethod (c$, "getAtomicCharges", 
function () {
return this.modelSet.getAtomicCharges ();
});
Clazz.defineMethod (c$, "getFunction", 
function (name) {
return this.stateManager.getFunction (name);
}, "~S");
Clazz.defineMethod (c$, "addFunction", 
function (f) {
this.stateManager.addFunction (f);
}, "org.jmol.script.ScriptFunction");
Clazz.defineMethod (c$, "removeFunction", 
function (name) {
this.stateManager.removeFunction (name);
}, "~S");
Clazz.defineMethod (c$, "clearFunctions", 
function () {
this.stateManager.clearFunctions ();
});
Clazz.defineMethod (c$, "isFunction", 
function (name) {
return this.stateManager.isFunction (name);
}, "~S");
Clazz.defineMethod (c$, "getFunctionCalls", 
function (selectedFunction) {
return this.stateManager.getFunctionCalls (selectedFunction);
}, "~S");
Clazz.defineMethod (c$, "showMessage", 
function (s) {
if (!this.isPrintOnly) org.jmol.util.Logger.warn (s);
}, "~S");
Clazz.defineMethod (c$, "getMoInfo", 
function (modelIndex) {
return this.modelSet.getMoInfo (modelIndex);
}, "~N");
Clazz.defineMethod (c$, "getContextVariables", 
function () {
return this.eval.getContextVariables ();
});
Clazz.overrideMethod (c$, "checkPrivateKey", 
function (privateKey) {
return privateKey == this.privateKey;
}, "~N");
Clazz.defineMethod (c$, "bindAction", 
function (desc, name, range1, range2) {
if (this.haveDisplay) this.actionManager.bindAction (desc, name, range1, range2);
}, "~S,~S,org.jmol.util.Point3f,org.jmol.util.Point3f");
Clazz.defineMethod (c$, "unBindAction", 
function (desc, name) {
if (this.haveDisplay) this.actionManager.unbindAction (desc, name);
}, "~S,~S");
Clazz.defineMethod (c$, "getMouseInfo", 
function () {
return (this.haveDisplay ? this.actionManager.getMouseInfo () : null);
});
Clazz.defineMethod (c$, "getFrontPlane", 
function () {
return this.transformManager.getFrontPlane ();
});
Clazz.defineMethod (c$, "getPlaneIntersection", 
function (type, plane, scale, flags) {
return this.modelSet.getPlaneIntersection (type, plane, scale, flags, this.animationManager.currentModelIndex);
}, "~N,org.jmol.util.Point4f,~N,~N");
Clazz.defineMethod (c$, "getOutputStream", 
function (localName, fullPath) {
if (!this.isRestricted (org.jmol.viewer.Viewer.ACCESS.ALL)) return null;
var ret = this.createImagePathCheck (localName, "OutputStream", null, null, -2147483648, 0, 0, fullPath, true);
if (Clazz.instanceOf (ret, String)) {
org.jmol.util.Logger.error (ret);
return null;
}return ret;
}, "~S,~A");
Clazz.defineMethod (c$, "calculateStruts", 
function (bs1, bs2) {
return this.modelSet.calculateStruts (bs1 == null ? this.getSelectionSet (false) : bs1, bs2 == null ? this.getSelectionSet (false) : bs2);
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getStrutsMultiple", 
function () {
return this.global.strutsMultiple;
});
Clazz.defineMethod (c$, "getStrutSpacingMinimum", 
function () {
return this.global.strutSpacing;
});
Clazz.defineMethod (c$, "getStrutLengthMaximum", 
function () {
return this.global.strutLengthMaximum;
});
Clazz.defineMethod (c$, "getStrutDefaultRadius", 
function () {
return this.global.strutDefaultRadius;
});
Clazz.defineMethod (c$, "getPreserveState", 
function () {
return this.global.preserveState;
});
Clazz.defineMethod (c$, "getDragSelected", 
function () {
return this.global.dragSelected && !this.global.modelKitMode;
});
Clazz.defineMethod (c$, "getLoadAtomDataTolerance", 
function () {
return this.global.loadAtomDataTolerance;
});
Clazz.defineMethod (c$, "getAllowGestures", 
function () {
return this.global.allowGestures;
});
Clazz.defineMethod (c$, "getLogGestures", 
function () {
return this.global.logGestures;
});
Clazz.defineMethod (c$, "allowMultiTouch", 
function () {
return this.global.allowMultiTouch;
});
Clazz.defineMethod (c$, "logCommands", 
function () {
return this.global.logCommands;
});
Clazz.defineMethod (c$, "getLogFile", 
function () {
return (this.logFile == null ? "" : this.logFile);
});
Clazz.defineMethod (c$, "setLogFile", 
($fz = function (value) {
var path = null;
if (this.logFilePath == null || value.indexOf ("\\") >= 0 || value.indexOf ("/") >= 0) {
value = null;
} else if (value.length > 0) {
if (!value.startsWith ("JmolLog_")) value = "JmolLog_" + value;
try {
path = (this.$isApplet ? this.logFilePath + value : ( new java.io.File (this.logFilePath + value).getAbsolutePath ()));
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
value = null;
} else {
throw e;
}
}
}if (value == null || !this.isRestricted (org.jmol.viewer.Viewer.ACCESS.ALL)) {
org.jmol.util.Logger.info (org.jmol.i18n.GT._ ("Cannot set log file path."));
value = null;
} else {
if (path != null) org.jmol.util.Logger.info (org.jmol.i18n.GT._ ("Setting log file to {0}", path));
this.logFile = path;
}return value;
}, $fz.isPrivate = true, $fz), "~S");
Clazz.overrideMethod (c$, "log", 
function (data) {
try {
if (data == null) return;
var doClear = (data.equals ("$CLEAR$"));
if (data.indexOf ("$NOW$") >= 0) data = org.jmol.util.TextFormat.simpleReplace (data, "$NOW$", ( new java.util.Date ()).toString ());
if (this.logFile == null) {
System.out.println (data);
return;
}var fstream =  new java.io.FileWriter (this.logFile, !doClear);
var out =  new java.io.BufferedWriter (fstream);
if (!doClear) {
out.write (data);
out.write (10);
}out.close ();
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
org.jmol.util.Logger.debug ("cannot log " + data);
} else {
throw e;
}
}
}, "~S");
Clazz.defineMethod (c$, "isKiosk", 
function () {
return this.$isKiosk;
});
Clazz.defineMethod (c$, "hasFocus", 
function () {
return (this.haveDisplay && (this.$isKiosk || this.apiPlatform.hasFocus (this.display)));
});
Clazz.defineMethod (c$, "setFocus", 
function () {
if (this.haveDisplay && !this.apiPlatform.hasFocus (this.display)) this.apiPlatform.requestFocusInWindow (this.display);
});
Clazz.defineMethod (c$, "getMinimizer", 
function (createNew) {
if (this.minimizer == null && createNew) {
this.minimizer = org.jmol.api.Interface.getOptionInterface ("minimize.Minimizer");
this.minimizer.setProperty ("viewer", this);
}return this.minimizer;
}, "~B");
Clazz.defineMethod (c$, "stopMinimization", 
function () {
if (this.minimizer != null) {
this.minimizer.setProperty ("stop", null);
}});
Clazz.defineMethod (c$, "clearMinimization", 
function () {
if (this.minimizer != null) this.minimizer.setProperty ("clear", null);
});
Clazz.defineMethod (c$, "getMinimizationInfo", 
function () {
return (this.minimizer == null ? "" : this.minimizer.getProperty ("log", 0));
});
Clazz.defineMethod (c$, "useMinimizationThread", 
function () {
return this.global.useMinimizationThread && !this.autoExit;
});
Clazz.defineMethod (c$, "checkMinimization", 
($fz = function () {
this.refreshMeasures (true);
if (!this.global.monitorEnergy) return;
this.minimize (0, 0, this.getModelUndeletedAtomsBitSet (-1), null, 0, false, true, false);
this.echoMessage (this.getParameter ("_minimizationForceField") + " Energy = " + this.getParameter ("_minimizationEnergy"));
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "minimize", 
function (steps, crit, bsSelected, bsFixed, rangeFixed, addHydrogen, isSilent, asScript) {
var ff = this.global.forceField;
var bsInFrame = this.getModelUndeletedAtomsBitSetBs (this.getVisibleFramesBitSet ());
if (bsSelected == null) bsSelected = this.getModelUndeletedAtomsBitSet (this.getVisibleFramesBitSet ().length () - 1);
 else bsSelected.and (bsInFrame);
if (rangeFixed <= 0) rangeFixed = 5.0;
var bsMotionFixed = org.jmol.util.BitSetUtil.copy (bsFixed == null ? this.selectionManager.getMotionFixedAtoms () : bsFixed);
var haveFixed = (bsMotionFixed.cardinality () > 0);
if (haveFixed) bsSelected.andNot (bsMotionFixed);
var bsNearby = this.getAtomsWithinRadius (rangeFixed, bsSelected, true, null);
bsNearby.andNot (bsSelected);
if (haveFixed) {
bsMotionFixed.and (bsNearby);
} else {
bsMotionFixed = bsNearby;
}bsMotionFixed.and (bsInFrame);
if (addHydrogen) bsSelected.or (this.addHydrogens (bsSelected, asScript, isSilent));
if (bsSelected.cardinality () > 200) {
org.jmol.util.Logger.error ("Too many atoms for minimization (>200)");
return;
}try {
if (!isSilent) org.jmol.util.Logger.info ("Minimizing " + bsSelected.cardinality () + " atoms");
this.getMinimizer (true).minimize (steps, crit, bsSelected, bsMotionFixed, haveFixed, isSilent, ff);
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
org.jmol.util.Logger.error ("Minimization error: " + e.getMessage ());
} else {
throw e;
}
}
}, "~N,~N,org.jmol.util.BitSet,org.jmol.util.BitSet,~N,~B,~B,~B");
Clazz.defineMethod (c$, "setMotionFixedAtoms", 
function (bs) {
this.selectionManager.setMotionFixedAtoms (bs);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getMotionFixedAtoms", 
function () {
return this.selectionManager.getMotionFixedAtoms ();
});
Clazz.defineMethod (c$, "useArcBall", 
function () {
return this.global.useArcBall;
});
Clazz.defineMethod (c$, "rotateArcBall", 
function (x, y, factor) {
this.transformManager.rotateArcBall (x, y, factor);
this.refresh (2, this.statusManager.syncingMouse ? "Mouse: rotateArcBall " + x + " " + y + " " + factor : "");
}, "~N,~N,~N");
Clazz.defineMethod (c$, "getAtomicPropertyState", 
function (commands, type, bs, name, data) {
this.modelSet.getAtomicPropertyStateBuffer (commands, type, bs, name, data);
}, "org.jmol.util.StringXBuilder,~N,org.jmol.util.BitSet,~S,~A");
Clazz.defineMethod (c$, "getCenterAndPoints", 
function (atomSets, addCenter) {
return this.modelSet.getCenterAndPoints (atomSets, addCenter);
}, "java.util.List,~B");
Clazz.defineMethod (c$, "getSmallMoleculeMaxAtoms", 
function () {
return this.global.smallMoleculeMaxAtoms;
});
Clazz.defineMethod (c$, "streamFileData", 
function (fileName, type, type2, modelIndex, parameters) {
var msg = null;
var fullPath =  new Array (1);
var os = this.getOutputStream (fileName, fullPath);
if (os == null) return "";
var sb;
if (type.equals ("PDB") || type.equals ("PQR")) {
sb =  new org.jmol.io.OutputStringBuilder ( new java.io.BufferedOutputStream (os));
sb.type = type;
msg = this.getPdbData (null, sb);
} else if (type.equals ("FILE")) {
msg = this.writeCurrentFile (os);
} else if (type.equals ("PLOT")) {
sb =  new org.jmol.io.OutputStringBuilder ( new java.io.BufferedOutputStream (os));
msg = this.modelSet.getPdbData (modelIndex, type2, this.getSelectionSet (false), parameters, sb);
}if (msg != null) msg = "OK " + msg + " " + fullPath[0];
try {
os.flush ();
os.close ();
} catch (e) {
if (Clazz.exceptionOf (e, java.io.IOException)) {
} else {
throw e;
}
}
return msg;
}, "~S,~S,~S,~N,~A");
Clazz.defineMethod (c$, "getPdbData", 
function (modelIndex, type, parameters) {
return this.modelSet.getPdbData (modelIndex, type, this.getSelectionSet (false), parameters, null);
}, "~N,~S,~A");
Clazz.defineMethod (c$, "getRepaintWait", 
function () {
return this.global.repaintWaitMs;
});
Clazz.defineMethod (c$, "getGroupsWithin", 
function (nResidues, bs) {
return this.modelSet.getGroupsWithin (nResidues, bs);
}, "~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getExecutor", 
function () {
if (this.executor != null || org.jmol.viewer.Viewer.nProcessors < 2) return this.executor;
try {
this.executor = (org.jmol.api.Interface.getOptionInterface ("parallel.ScriptParallelProcessor")).getExecutor ();
} catch (e$$) {
if (Clazz.exceptionOf (e$$, Exception)) {
var e = e$$;
{
this.executor = null;
}
} else if (Clazz.exceptionOf (e$$, Error)) {
var er = e$$;
{
this.executor = null;
}
} else {
throw e$$;
}
}
if (this.executor == null) org.jmol.util.Logger.error ("parallel processing is not available");
return this.executor;
});
Clazz.defineMethod (c$, "evalParallel", 
function (context, shapeManager) {
this.displayLoadErrors = false;
var isOK = org.jmol.script.ScriptEvaluator.evaluateParallel (this, context, (shapeManager == null ? this.shapeManager : shapeManager));
this.displayLoadErrors = true;
return isOK;
}, "org.jmol.script.ScriptContext,org.jmol.viewer.ShapeManager");
Clazz.defineMethod (c$, "getShapeInfo", 
function () {
return this.shapeManager.getShapeInfo ();
});
Clazz.defineMethod (c$, "togglePickingLabel", 
function (bs) {
if (bs == null) bs = this.getSelectionSet (false);
this.loadShape (5);
this.shapeManager.setShapePropertyBs (5, "toggleLabel", null, bs);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "loadShape", 
function (shapeID) {
this.shapeManager.loadShape (shapeID);
}, "~N");
Clazz.defineMethod (c$, "setShapeSize", 
function (shapeID, mad, bsSelected) {
if (bsSelected == null) bsSelected = this.getSelectionSet (false);
this.shapeManager.setShapeSizeBs (shapeID, mad, null, bsSelected);
}, "~N,~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "setShapeSize", 
function (shapeID, rd, bsAtoms) {
this.shapeManager.setShapeSizeBs (shapeID, 0, rd, bsAtoms);
}, "~N,org.jmol.atomdata.RadiusData,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "setShapeProperty", 
function (shapeID, propertyName, value) {
if (shapeID < 0) return;
this.shapeManager.setShapePropertyBs (shapeID, propertyName, value, null);
}, "~N,~S,~O");
Clazz.defineMethod (c$, "getShapeProperty", 
function (shapeType, propertyName) {
return this.shapeManager.getShapePropertyIndex (shapeType, propertyName, -2147483648);
}, "~N,~S");
Clazz.defineMethod (c$, "getShapePropertyData", 
function (shapeType, propertyName, data) {
return this.shapeManager.getShapePropertyData (shapeType, propertyName, data);
}, "~N,~S,~A");
Clazz.defineMethod (c$, "getShapePropertyIndex", 
function (shapeType, propertyName, index) {
return this.shapeManager.getShapePropertyIndex (shapeType, propertyName, index);
}, "~N,~S,~N");
Clazz.defineMethod (c$, "getShapePropertyAsInt", 
($fz = function (shapeID, propertyName) {
var value = this.getShapeProperty (shapeID, propertyName);
return value == null || !(Clazz.instanceOf (value, Integer)) ? -2147483648 : (value).intValue ();
}, $fz.isPrivate = true, $fz), "~N,~S");
Clazz.defineMethod (c$, "setModelVisibility", 
function () {
if (this.shapeManager == null) return;
this.shapeManager.setModelVisibility ();
});
Clazz.defineMethod (c$, "resetShapes", 
function (andCreateNew) {
this.shapeManager.resetShapes ();
if (andCreateNew) {
this.shapeManager.loadDefaultShapes (this.modelSet);
this.clearRepaintManager (-1);
}}, "~B");
Clazz.defineMethod (c$, "setAtomLabel", 
function (value, i) {
this.shapeManager.setAtomLabel (value, i);
}, "~S,~N");
Clazz.defineMethod (c$, "deleteShapeAtoms", 
function (value, bs) {
this.shapeManager.deleteShapeAtoms (value, bs);
}, "~A,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getShapeState", 
function (commands, isAll, iShape) {
this.shapeManager.getShapeState (commands, isAll, iShape);
}, "org.jmol.util.StringXBuilder,~B,~N");
Clazz.defineMethod (c$, "resetBioshapes", 
function (bsAllAtoms) {
this.shapeManager.resetBioshapes (bsAllAtoms);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getAtomShapeValue", 
function (tok, group, atomIndex) {
return this.shapeManager.getAtomShapeValue (tok, group, atomIndex);
}, "~N,org.jmol.modelset.Group,~N");
Clazz.defineMethod (c$, "mergeShapes", 
function (newShapes) {
this.shapeManager.mergeShapes (newShapes);
}, "~A");
Clazz.defineMethod (c$, "getShapeManager", 
function () {
return this.shapeManager;
});
Clazz.defineMethod (c$, "setParallel", 
function (TF) {
return (this.$isParallel = this.global.multiProcessor && TF);
}, "~B");
Clazz.defineMethod (c$, "isParallel", 
function () {
return this.global.multiProcessor && this.$isParallel;
});
Clazz.defineMethod (c$, "getRenderableBitSet", 
function () {
return this.shapeManager.getRenderableBitSet ();
});
Clazz.defineMethod (c$, "setAtomPickingOption", 
($fz = function (option) {
if (this.haveDisplay) this.actionManager.setAtomPickingOption (option);
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "setBondPickingOption", 
($fz = function (option) {
if (this.haveDisplay) this.actionManager.setBondPickingOption (option);
}, $fz.isPrivate = true, $fz), "~S");
Clazz.defineMethod (c$, "undoClear", 
function () {
this.actionStates.clear ();
this.actionStatesRedo.clear ();
});
Clazz.defineMethod (c$, "undoMoveAction", 
function (action, n) {
switch (action) {
case 4165:
case 4139:
switch (n) {
case -2:
this.undoClear ();
break;
case -1:
(action == 4165 ? this.actionStates : this.actionStatesRedo).clear ();
break;
case 0:
n = 2147483647;
default:
if (n > 100) n = (action == 4165 ? this.actionStates : this.actionStatesRedo).size ();
for (var i = 0; i < n; i++) this.undoMoveActionClear (0, action, true);

}
break;
}
}, "~N,~N");
Clazz.defineMethod (c$, "undoMoveActionClear", 
function (taintedAtom, type, clearRedo) {
if (!this.global.preserveState) return;
var modelIndex = (taintedAtom >= 0 ? this.modelSet.atoms[taintedAtom].modelIndex : this.modelSet.getModelCount () - 1);
switch (type) {
case 4139:
case 4165:
this.stopMinimization ();
var s = "";
var list1;
var list2;
switch (type) {
default:
case 4165:
list1 = this.actionStates;
list2 = this.actionStatesRedo;
break;
case 4139:
list1 = this.actionStatesRedo;
list2 = this.actionStates;
if (this.actionStatesRedo.size () == 1) return;
break;
}
if (list1.size () == 0 || this.undoWorking) return;
this.undoWorking = true;
list2.add (0, list1.remove (0));
s = this.actionStatesRedo.get (0);
if (type == 4165 && list2.size () == 1) {
var pt = [1];
type = org.jmol.util.Parser.parseIntNext (s, pt);
taintedAtom = org.jmol.util.Parser.parseIntNext (s, pt);
this.undoMoveActionClear (taintedAtom, type, false);
}if (this.modelSet.getModels ()[modelIndex].isModelkit () || s.indexOf ("zap ") < 0) {
if (org.jmol.util.Logger.debugging) this.log (s);
this.evalStringQuiet (s);
} else {
this.actionStates.clear ();
}break;
default:
if (this.undoWorking && clearRedo) return;
this.undoWorking = true;
var bs;
var sb =  new org.jmol.util.StringXBuilder ();
sb.append ("#" + type + " " + taintedAtom + " " + ( new java.util.Date ()) + "\n");
if (taintedAtom >= 0) {
bs = this.getModelUndeletedAtomsBitSet (modelIndex);
this.modelSet.taintAtoms (bs, type);
sb.append (this.modelSet.getAtomicPropertyState (-1, null));
} else {
bs = this.getModelUndeletedAtomsBitSet (modelIndex);
sb.append ("zap ");
sb.append (org.jmol.util.Escape.escape (bs)).append (";");
org.jmol.viewer.DataManager.getInlineData (sb, this.modelSet.getModelExtract (bs, false, true, "MOL"), true, null);
sb.append ("set refreshing false;").append (this.actionManager.getPickingState ()).append (this.transformManager.getMoveToText (0, false)).append ("set refreshing true;");
}if (clearRedo) {
this.actionStates.add (0, sb.toString ());
this.actionStatesRedo.clear ();
} else {
this.actionStatesRedo.add (1, sb.toString ());
}if (this.actionStates.size () == 100) {
this.actionStates.remove (99);
}}
this.undoWorking = !clearRedo;
}, "~N,~N,~B");
Clazz.defineMethod (c$, "assignBond", 
function (bondIndex, type) {
try {
var bsAtoms = this.modelSet.setBondOrder (bondIndex, type);
if (bsAtoms == null || type == '0') this.refresh (3, "setBondOrder");
 else this.addHydrogens (bsAtoms, false, true);
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
org.jmol.util.Logger.error ("assignBond failed");
} else {
throw e;
}
}
}, "~N,~S");
Clazz.defineMethod (c$, "assignAtom", 
function (atomIndex, pt, type) {
if (type.equals ("X")) this.setRotateBondIndex (-1);
if (this.modelSet.atoms[atomIndex].modelIndex != this.modelSet.getModelCount () - 1) return;
this.clearModelDependentObjects ();
if (pt == null) {
this.modelSet.assignAtom (atomIndex, type, true);
this.modelSet.setAtomNamesAndNumbers (atomIndex, -1, null);
this.refresh (3, "assignAtom");
return;
}var atom = this.modelSet.atoms[atomIndex];
var bs = org.jmol.util.BitSetUtil.newAndSetBit (atomIndex);
var pts = [pt];
var vConnections =  new java.util.ArrayList ();
vConnections.add (atom);
try {
bs = this.addHydrogensInline (bs, vConnections, pts);
atomIndex = bs.nextSetBit (0);
this.modelSet.assignAtom (atomIndex, type, false);
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
this.modelSet.setAtomNamesAndNumbers (atomIndex, -1, null);
}, "~N,org.jmol.util.Point3f,~S");
Clazz.defineMethod (c$, "assignConnect", 
function (index, index2) {
this.clearModelDependentObjects ();
var connections = org.jmol.util.ArrayUtil.newFloat2 (1);
connections[0] = [index, index2];
this.modelSet.connect (connections);
this.modelSet.assignAtom (index, ".", true);
this.modelSet.assignAtom (index2, ".", true);
this.refresh (3, "assignConnect");
}, "~N,~N");
Clazz.defineMethod (c$, "moveAtomWithHydrogens", 
function (atomIndex, deltaX, deltaY, deltaZ, bsAtoms) {
this.stopMinimization ();
if (bsAtoms == null) {
var atom = this.modelSet.atoms[atomIndex];
bsAtoms = org.jmol.util.BitSetUtil.newAndSetBit (atomIndex);
var bonds = atom.getBonds ();
if (bonds != null) for (var i = 0; i < bonds.length; i++) {
var atom2 = bonds[i].getOtherAtom (atom);
if (atom2.getElementNumber () == 1) bsAtoms.set (atom2.index);
}
}this.moveSelected (deltaX, deltaY, deltaZ, -2147483648, -2147483648, bsAtoms, true, true);
}, "~N,~N,~N,~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "appendLoadStates", 
function (commands) {
if (this.ligandModelSet != null) {
for (var key, $key = this.ligandModelSet.keySet ().iterator (); $key.hasNext () && ((key = $key.next ()) || true);) {
var data = this.ligandModels.get (key + "_data");
if (data != null) commands.append ("  ").append (org.jmol.util.Escape.encapsulateData ("ligand_" + key, data.trim () + "\n", 0));
}
}this.modelSet.appendLoadStates (commands);
}, "org.jmol.util.StringXBuilder");
c$.getInlineData = Clazz.defineMethod (c$, "getInlineData", 
function (loadScript, strModel, isAppend) {
org.jmol.viewer.DataManager.getInlineData (loadScript, strModel, isAppend, null);
}, "org.jmol.util.StringXBuilder,~S,~B");
Clazz.defineMethod (c$, "isAtomPDB", 
function (i) {
return this.modelSet.isAtomPDB (i);
}, "~N");
Clazz.defineMethod (c$, "isModelPDB", 
function (i) {
return this.modelSet.getModels ()[i].isBioModel;
}, "~N");
Clazz.defineMethod (c$, "isAtomAssignable", 
function (i) {
return this.modelSet.isAtomAssignable (i);
}, "~N");
Clazz.overrideMethod (c$, "deleteMeasurement", 
function (i) {
this.setShapeProperty (6, "delete", Integer.$valueOf (i));
}, "~N");
Clazz.defineMethod (c$, "haveModelKit", 
function () {
return this.modelSet.haveModelKit ();
});
Clazz.defineMethod (c$, "getModelKitStateBitSet", 
function (bs, bsDeleted) {
return this.modelSet.getModelKitStateBitset (bs, bsDeleted);
}, "org.jmol.util.BitSet,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "getSmiles", 
function (index1, index2, bsSelected, isBioSmiles, allowUnmatchedRings, addCrossLinks, addComment) {
var atoms = this.getModelSet ().atoms;
if (bsSelected == null) {
if (index1 < 0 || index2 < 0) {
bsSelected = this.getSelectionSet (true);
} else {
if (isBioSmiles) {
if (index1 > index2) {
var i = index1;
index1 = index2;
index2 = i;
}index1 = atoms[index1].getGroup ().firstAtomIndex;
index2 = atoms[index2].getGroup ().lastAtomIndex;
}bsSelected =  new org.jmol.util.BitSet ();
bsSelected.setBits (index1, index2 + 1);
}}var comment = (addComment ? org.jmol.viewer.Viewer.getJmolVersion () + " " + this.getModelName (this.getCurrentModelIndex ()) : null);
return this.getSmilesMatcher ().getSmiles (atoms, this.getAtomCount (), bsSelected, isBioSmiles, allowUnmatchedRings, addCrossLinks, comment);
}, "~N,~N,org.jmol.util.BitSet,~B,~B,~B,~B");
Clazz.defineMethod (c$, "connect", 
function (connections) {
this.modelSet.connect (connections);
}, "~A");
Clazz.defineMethod (c$, "prompt", 
function (label, data, list, asButtons) {
return (this.$isKiosk ? "null" : this.apiPlatform.prompt (label, data, list, asButtons));
}, "~S,~S,~A,~B");
Clazz.defineMethod (c$, "getMenuName", 
function (i) {
var script = "" + this.getModelNumberDotted (i);
var entryName = this.getModelName (i);
if (!entryName.equals (script)) entryName = script + ": " + entryName;
if (entryName.length > 50) entryName = entryName.substring (0, 45) + "...";
return entryName;
}, "~N");
Clazz.defineMethod (c$, "getColorEncoder", 
function (colorScheme) {
return this.colorManager.getColorEncoder (colorScheme);
}, "~S");
Clazz.defineMethod (c$, "displayBonds", 
function (bs, isDisplay) {
this.modelSet.displayBonds (bs, isDisplay);
}, "org.jmol.modelset.Bond.BondSet,~B");
Clazz.defineMethod (c$, "getModelAtomProperty", 
function (atom, text) {
return this.modelSet.getModelAtomProperty (atom, text);
}, "org.jmol.modelset.Atom,~S");
Clazz.defineMethod (c$, "setStateScriptVersion", 
function (version) {
if (version != null) {
try {
var tokens = org.jmol.util.Parser.getTokens (version.$replace ('.', ' ').$replace ('_', ' '));
var main = Integer.$valueOf (tokens[0]).intValue ();
var sub = Integer.$valueOf (tokens[1]).intValue ();
var minor = Integer.$valueOf (tokens[2]).intValue ();
if (minor == -2147483648) minor = 0;
this.stateScriptVersionInt = main * 10000 + sub * 100 + minor;
this.global.legacyAutoBonding = (this.stateScriptVersionInt < 110924);
return;
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
}this.setBooleanProperty ("legacyautobonding", false);
this.stateScriptVersionInt = 2147483647;
}, "~S");
Clazz.defineMethod (c$, "checkAutoBondLegacy", 
function () {
return this.global.legacyAutoBonding;
});
Clazz.defineMethod (c$, "initializeExporter", 
function (type, fileName) {
if (this.jsExporter3D != null) {
this.jsExporter3D.initializeOutput (type, this, this.privateKey, this.gdata, null);
return this.jsExporter3D;
}var isJS = type.equals ("JS");
var output = (fileName == null ?  new org.jmol.util.StringXBuilder () : fileName);
var export3D = null;
try {
var export3Dclass = Class.forName (isJS ? "org.jmol.exportjs.Export3D" : "org.jmol.export.Export3D");
export3D = export3Dclass.newInstance ();
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
return null;
} else {
throw e;
}
}
var exporter = export3D.initializeExporter (type, this, this.privateKey, this.gdata, output);
if (isJS && exporter != null) this.jsExporter3D = export3D;
return (exporter == null ? null : export3D);
}, "~S,~S");
Clazz.defineMethod (c$, "setPrivateKeyForShape", 
function (iShape) {
this.setShapeProperty (iShape, "privateKey", Double.$valueOf (this.privateKey));
}, "~N");
Clazz.defineMethod (c$, "getMouseEnabled", 
function () {
return this.refreshing && !this.creatingImage;
});
Clazz.defineMethod (c$, "getPartialDots", 
function () {
return this.global.partialDots;
});
Clazz.defineMethod (c$, "setZslabPoint", 
function (pt) {
this.transformManager.setZslabPoint (pt);
}, "org.jmol.util.Point3f");
Clazz.overrideMethod (c$, "calcAtomsMinMax", 
function (bs, boxInfo) {
this.modelSet.calcAtomsMinMax (bs, boxInfo);
}, "org.jmol.util.BitSet,org.jmol.util.BoxInfo");
Clazz.overrideMethod (c$, "evalFunctionFloat", 
function (func, params, values) {
return this.eval.evalFunctionFloat (func, params, values);
}, "~O,~O,~A");
Clazz.overrideMethod (c$, "getObjectMap", 
function (map, withDollar) {
this.shapeManager.getObjectMap (map, withDollar);
}, "java.util.Map,~B");
Clazz.defineMethod (c$, "getPdbBondInfo", 
function (group3) {
if (this.htPdbBondInfo == null) this.htPdbBondInfo =  new java.util.Hashtable ();
var info = this.htPdbBondInfo.get (group3);
if (info != null) return info;
info = org.jmol.viewer.JmolConstants.getPdbBondInfo (org.jmol.modelset.Group.lookupGroupID (group3));
this.htPdbBondInfo.put (group3, info);
return info;
}, "~S");
Clazz.defineMethod (c$, "setPicked", 
function (iAtom) {
this.global.setPicked (iAtom);
}, "~N");
Clazz.defineMethod (c$, "runScriptImmediately", 
function (script) {
try {
this.eval.runScript (script);
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
return false;
} else {
throw e;
}
}
return true;
}, "~S");
Clazz.defineMethod (c$, "allowSpecAtom", 
function () {
return this.modelSet.allowSpecAtom ();
});
Clazz.defineMethod (c$, "getMinPixelSelRadius", 
function () {
return this.global.minPixelSelRadius;
});
Clazz.defineMethod (c$, "setFrameDelayMs", 
function (millis) {
this.modelSet.setFrameDelayMs (millis, this.getVisibleFramesBitSet ());
}, "~N");
Clazz.defineMethod (c$, "getFrameDelayMs", 
function (i) {
return this.modelSet.getFrameDelayMs (i);
}, "~N");
Clazz.defineMethod (c$, "getJspecViewProperties", 
function (myParam) {
return this.statusManager.getJspecViewProperties ("" + myParam);
}, "~O");
Clazz.defineMethod (c$, "getBaseModelBitSet", 
function () {
return this.modelSet.getBaseModelBitSet (this.getCurrentModelIndex ());
});
Clazz.defineMethod (c$, "getTimeouts", 
function () {
return this.timeouts;
});
Clazz.defineMethod (c$, "clearTimeouts", 
function () {
if (this.timeouts != null) org.jmol.thread.TimeoutThread.clear (this.timeouts);
});
Clazz.defineMethod (c$, "setTimeout", 
function (name, mSec, script) {
if (!this.haveDisplay || this.isHeadless () || this.autoExit) return;
if (name == null) {
this.clearTimeouts ();
return;
}if (this.timeouts == null) {
this.timeouts =  new java.util.Hashtable ();
}org.jmol.thread.TimeoutThread.setTimeout (this, this.timeouts, name, mSec, script);
}, "~S,~N,~S");
Clazz.defineMethod (c$, "triggerTimeout", 
function (name) {
if (!this.haveDisplay || this.timeouts == null) return;
org.jmol.thread.TimeoutThread.trigger (this.timeouts, name);
}, "~S");
Clazz.defineMethod (c$, "clearTimeout", 
function (name) {
this.setTimeout (name, 0, null);
}, "~S");
Clazz.defineMethod (c$, "showTimeout", 
function (name) {
return (this.haveDisplay ? org.jmol.thread.TimeoutThread.showTimeout (this.timeouts, name) : "");
}, "~S");
Clazz.defineMethod (c$, "calculatePartialCharges", 
function (bsSelected) {
if (bsSelected == null || bsSelected.cardinality () == 0) bsSelected = this.getModelUndeletedAtomsBitSetBs (this.getVisibleFramesBitSet ());
this.getMinimizer (true).calculatePartialCharges (this.modelSet.getBonds (), this.modelSet.getBondCount (), this.modelSet.atoms, bsSelected);
}, "org.jmol.util.BitSet");
Clazz.defineMethod (c$, "cachePut", 
function (key, data) {
this.fileManager.cachePut (key, data);
}, "~S,~O");
Clazz.defineMethod (c$, "cacheClear", 
function () {
this.fileManager.cacheClear ();
this.fileManager.clearPngjCache (null);
});
Clazz.defineMethod (c$, "setCurrentModelID", 
function (id) {
var modelIndex = this.getCurrentModelIndex ();
if (modelIndex >= 0) this.modelSet.setModelAuxiliaryInfo (modelIndex, "modelID", id);
}, "~S");
Clazz.defineMethod (c$, "setCentroid", 
function (iAtom0, iAtom1, minmax) {
this.modelSet.setCentroid (iAtom0, iAtom1, minmax);
}, "~N,~N,~A");
Clazz.defineMethod (c$, "getPathForAllFiles", 
function () {
return this.fileManager.getPathForAllFiles ();
});
Clazz.defineMethod (c$, "createSceneSet", 
function (sceneFile, type, width, height) {
var script0 = this.getFileAsString (sceneFile);
if (script0 == null) return "no such file: " + sceneFile;
sceneFile = org.jmol.util.TextFormat.simpleReplace (sceneFile, ".spt", "");
var fileRoot = sceneFile;
var fileExt = type.toLowerCase ();
var scenes = org.jmol.util.TextFormat.splitChars (script0, "pause scene ");
var htScenes =  new java.util.Hashtable ();
var list =  new java.util.ArrayList ();
var script = org.jmol.io.JmolBinary.getSceneScript (scenes, htScenes, list);
org.jmol.util.Logger.debug (script);
script0 = org.jmol.util.TextFormat.simpleReplace (script0, "pause scene", "delay " + this.animationManager.lastFrameDelay + " # scene");
var str = [script0, script, null];
this.saveState ("_scene0");
var nFiles = 0;
if (scenes[0] !== "") this.zap (true, true, false);
var iSceneLast = -1;
for (var i = 0; i < scenes.length - 1; i++) {
try {
var iScene = list.get (i).intValue ();
if (iScene > iSceneLast) this.showString ("Creating Scene " + iScene, false);
this.eval.runScript (scenes[i]);
if (iScene <= iSceneLast) continue;
iSceneLast = iScene;
str[2] = "all";
var fileName = fileRoot + "_scene_" + iScene + ".all." + fileExt;
var msg = this.createImagePathCheck (fileName, "PNGJ", null, str, -1, width, height, null, false);
str[0] = null;
str[2] = "min";
fileName = fileRoot + "_scene_" + iScene + ".min." + fileExt;
msg += "\n" + this.createImagePathCheck (fileName, "PNGJ", null, str, -1, Math.min (width, 200), Math.min (height, 200), null, false);
this.showString (msg, false);
nFiles += 2;
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
return "script error " + e.getMessage ();
} else {
throw e;
}
}
}
try {
this.eval.runScript (this.getSavedState ("_scene0"));
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
return "OK " + nFiles + " files created";
}, "~S,~S,~N,~N");
Clazz.overrideMethod (c$, "cacheFile", 
function (fileName, bytes) {
this.fileManager.cachePut (fileName, bytes);
}, "~S,~A");
Clazz.defineMethod (c$, "cacheFileByName", 
function (fileName, isAdd) {
return this.fileManager.cacheFileByName (fileName, isAdd);
}, "~S,~B");
Clazz.defineMethod (c$, "cacheList", 
function () {
return this.fileManager.cacheList ();
});
Clazz.defineMethod (c$, "delayScript", 
function (eval, millis) {
if (this.autoExit) return;
if (this.scriptDelayThread != null) this.scriptDelayThread.interrupt ();
this.scriptDelayThread =  new org.jmol.thread.ScriptDelayThread (eval, this, millis);
this.scriptDelayThread.run ();
}, "org.jmol.script.ScriptEvaluator,~N");
Clazz.defineMethod (c$, "clearThreads", 
($fz = function () {
if (this.scriptDelayThread != null) {
this.scriptDelayThread.interrupt ();
this.scriptDelayThread = null;
}this.stopMinimization ();
this.setVibrationOff ();
this.setSpinOn (false);
this.setNavOn (false);
this.setAnimationOn (false);
}, $fz.isPrivate = true, $fz));
Clazz.pu$h ();
c$ = Clazz.declareType (org.jmol.viewer.Viewer, "ACCESS", Enum);
Clazz.defineEnumConstant (c$, "NONE", 0, []);
Clazz.defineEnumConstant (c$, "READSPT", 1, []);
Clazz.defineEnumConstant (c$, "ALL", 2, []);
c$ = Clazz.p0p ();
c$.strJavaVendor = c$.prototype.strJavaVendor = System.getProperty ("java.vendor", "j2s");
c$.strOSName = c$.prototype.strOSName = System.getProperty ("os.name", "j2s");
c$.strJavaVersion = c$.prototype.strJavaVersion = System.getProperty ("java.version", "0.0");
Clazz.defineStatics (c$,
"jsDocumentBase", "",
"STATE_VERSION_STAMP", "# Jmol state version ",
"SYNC_GRAPHICS_MESSAGE", "GET_GRAPHICS",
"SYNC_NO_GRAPHICS_MESSAGE", "SET_GRAPHICS_OFF",
"nProcessors", 1);
{
try {
($t$ = org.jmol.viewer.Viewer.nProcessors = Runtime.getRuntime ().availableProcessors (), org.jmol.viewer.Viewer.prototype.nProcessors = org.jmol.viewer.Viewer.nProcessors, $t$);
} catch (e) {
}
}Clazz.defineStatics (c$,
"MAX_ACTION_UNDO", 100);
});
// 
//// java\io\InputStream.js 
// 
Clazz.load (null, "java.io.InputStream", ["java.io.IOException", "java.lang.IndexOutOfBoundsException", "$.NullPointerException"], function () {
c$ = Clazz.declareType (java.io, "InputStream");
Clazz.defineMethod (c$, "read", 
function (b, off, len) {
if (b == null) {
throw  new NullPointerException ();
} else if (off < 0 || len < 0 || len > b.length - off) {
throw  new IndexOutOfBoundsException ();
} else if (len == 0) {
return 0;
}var c = this.readByteAsInt ();
if (c == -1) {
return -1;
}b[off] = c;
var i = 1;
try {
for (; i < len; i++) {
c = this.readByteAsInt ();
if (c == -1) {
break;
}b[off + i] = c;
}
} catch (ee) {
if (Clazz.exceptionOf (ee, java.io.IOException)) {
} else {
throw ee;
}
}
return i;
}, "~A,~N,~N");
Clazz.defineMethod (c$, "skip", 
function (n) {
var remaining = n;
var nr;
if (java.io.InputStream.skipBuffer == null) ($t$ = java.io.InputStream.skipBuffer =  Clazz.newByteArray (2048, 0), java.io.InputStream.prototype.skipBuffer = java.io.InputStream.skipBuffer, $t$);
var localSkipBuffer = java.io.InputStream.skipBuffer;
if (n <= 0) {
return 0;
}while (remaining > 0) {
nr = this.read (localSkipBuffer, 0, Math.min (2048, remaining));
if (nr < 0) {
break;
}remaining -= nr;
}
return n - remaining;
}, "~N");
Clazz.defineMethod (c$, "available", 
function () {
return 0;
});
Clazz.defineMethod (c$, "close", 
function () {
});
Clazz.defineMethod (c$, "mark", 
function (readlimit) {
}, "~N");
Clazz.defineMethod (c$, "reset", 
function () {
throw  new java.io.IOException ("mark/reset not supported");
});
Clazz.defineMethod (c$, "markSupported", 
function () {
return false;
});
Clazz.defineStatics (c$,
"SKIP_BUFFER_SIZE", 2048,
"skipBuffer", null);
});
// 
//// java\io\OutputStream.js 
// 
Clazz.load (["java.io.Closeable", "$.Flushable"], "java.io.OutputStream", ["java.lang.IndexOutOfBoundsException", "$.NullPointerException"], function () {
c$ = Clazz.declareType (java.io, "OutputStream", null, [java.io.Closeable, java.io.Flushable]);
Clazz.defineMethod (c$, "write", 
function (b, off, len) {
if (b == null) {
throw  new NullPointerException ();
} else if ((off < 0) || (off > b.length) || (len < 0) || ((off + len) > b.length) || ((off + len) < 0)) {
throw  new IndexOutOfBoundsException ();
} else if (len == 0) {
return;
}for (var i = 0; i < len; i++) {
this.writeByteAsInt (b[off + i]);
}
}, "~A,~N,~N");
Clazz.overrideMethod (c$, "flush", 
function () {
});
Clazz.overrideMethod (c$, "close", 
function () {
});
});
// 
//// java\io\FilterOutputStream.js 
// 
Clazz.load (["java.io.OutputStream"], "java.io.FilterOutputStream", ["java.lang.IndexOutOfBoundsException"], function () {
c$ = Clazz.decorateAsClass (function () {
this.out = null;
Clazz.instantialize (this, arguments);
}, java.io, "FilterOutputStream", java.io.OutputStream);
Clazz.makeConstructor (c$, 
function (out) {
Clazz.superConstructor (this, java.io.FilterOutputStream, []);
this.out = out;
}, "java.io.OutputStream");
Clazz.defineMethod (c$, "writeByteAsInt", 
function (b) {
this.out.writeByteAsInt (b);
}, "~N");
Clazz.defineMethod (c$, "write", 
function (b, off, len) {
if ((off | len | (b.length - (len + off)) | (off + len)) < 0) throw  new IndexOutOfBoundsException ();
for (var i = 0; i < len; i++) {
this.writeByteAsInt (b[off + i]);
}
}, "~A,~N,~N");
Clazz.defineMethod (c$, "flush", 
function () {
this.out.flush ();
});
Clazz.defineMethod (c$, "close", 
function () {
try {
this.flush ();
} catch (ignored) {
if (Clazz.exceptionOf (ignored, java.io.IOException)) {
} else {
throw ignored;
}
}
this.out.close ();
});
});
// 
//// java\io\BufferedOutputStream.js 
// 
$_L(["java.io.FilterOutputStream"],"java.io.BufferedOutputStream",["java.lang.ArrayIndexOutOfBoundsException","$.IllegalArgumentException","$.NullPointerException",null],function(){
c$=$_C(function(){
this.buf=null;
this.count=0;
$_Z(this,arguments);
},java.io,"BufferedOutputStream",java.io.FilterOutputStream);
$_K(c$,
function(out){
$_R(this,java.io.BufferedOutputStream,[out]);
this.buf=$_A(8192,0);
},"java.io.OutputStream");
$_K(c$,
function(out,size){
$_R(this,java.io.BufferedOutputStream,[out]);
if(size<=0){
throw new IllegalArgumentException(("K0058"));
}this.buf=$_A(size,0);
},"java.io.OutputStream,~N");
$_V(c$,"flush",
function(){
if(this.count>0){
this.out.write(this.buf,0,this.count);
}this.count=0;
this.out.flush();
});
$_M(c$,"write",
function(buffer,offset,length){
if(buffer==null){
throw new NullPointerException(("K0047"));
}if(offset<0||offset>buffer.length-length||length<0){
throw new ArrayIndexOutOfBoundsException(("K002f"));
}if(this.count==0&&length>=this.buf.length){
this.out.write(buffer,offset,length);
return;
}var available=this.buf.length-this.count;
if(length<available){
available=length;
}if(available>0){
System.arraycopy(buffer,offset,this.buf,this.count,available);
this.count+=available;
}if(this.count==this.buf.length){
this.out.write(this.buf,0,this.buf.length);
this.count=0;
if(length>available){
offset+=available;
available=length-available;
if(available>=this.buf.length){
this.out.write(buffer,offset,available);
}else{
System.arraycopy(buffer,offset,this.buf,this.count,available);
this.count+=available;
}}}},"~A,~N,~N");
$_M(c$,"write",
function(oneByte){
if(this.count==this.buf.length){
this.out.write(this.buf,0,this.count);
this.count=0;
}this.buf[this.count++]=oneByte;
},"~N");
});
// 
//// java\io\Reader.js 
// 
Clazz.load (["java.io.Closeable"], "java.io.Reader", ["java.io.IOException", "java.lang.IllegalArgumentException", "$.NullPointerException"], function () {
c$ = Clazz.decorateAsClass (function () {
this.lock = null;
this.skipBuffer = null;
Clazz.instantialize (this, arguments);
}, java.io, "Reader", null, java.io.Closeable);
Clazz.makeConstructor (c$, 
function (lock) {
if (lock == null) {
throw  new NullPointerException ();
}this.lock = lock;
}, "~O");
Clazz.defineMethod (c$, "skip", 
function (n) {
if (n < 0) throw  new IllegalArgumentException ("skip value is negative");
var nn = Math.min (n, 8192);
{
if ((this.skipBuffer == null) || (this.skipBuffer.length < nn)) this.skipBuffer =  Clazz.newCharArray (nn, '\0');
var r = n;
while (r > 0) {
var nc = this.read (this.skipBuffer, 0, Math.min (r, nn));
if (nc == -1) break;
r -= nc;
}
return n - r;
}}, "~N");
Clazz.defineMethod (c$, "ready", 
function () {
return false;
});
Clazz.defineMethod (c$, "markSupported", 
function () {
return false;
});
Clazz.defineMethod (c$, "mark", 
function (readAheadLimit) {
throw  new java.io.IOException ("mark() not supported");
}, "~N");
Clazz.defineMethod (c$, "reset", 
function () {
throw  new java.io.IOException ("reset() not supported");
});
Clazz.defineStatics (c$,
"maxSkipBufferSize", 8192);
});
// 
//// java\io\BufferedReader.js 
// 
Clazz.load (["java.io.Reader"], "java.io.BufferedReader", ["java.io.IOException", "java.lang.IllegalArgumentException", "$.IndexOutOfBoundsException", "org.jmol.util.StringXBuilder"], function () {
c$ = Clazz.decorateAsClass (function () {
this.$in = null;
this.cb = null;
this.nChars = 0;
this.nextChar = 0;
this.markedChar = -1;
this.readAheadLimit = 0;
this.skipLF = false;
this.markedSkipLF = false;
Clazz.instantialize (this, arguments);
}, java.io, "BufferedReader", java.io.Reader);
Clazz.defineMethod (c$, "setSize", 
($fz = function (sz) {
if (sz <= 0) throw  new IllegalArgumentException ("Buffer size <= 0");
this.cb =  Clazz.newCharArray (sz, '\0');
this.nextChar = this.nChars = 0;
}, $fz.isPrivate = true, $fz), "~N");
Clazz.makeConstructor (c$, 
function ($in) {
Clazz.superConstructor (this, java.io.BufferedReader, [$in]);
this.$in = $in;
this.setSize (java.io.BufferedReader.defaultCharBufferSize);
}, "java.io.Reader");
Clazz.defineMethod (c$, "ensureOpen", 
($fz = function () {
if (this.$in == null) throw  new java.io.IOException ("Stream closed");
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "fill", 
($fz = function () {
var dst;
if (this.markedChar <= -1) {
dst = 0;
} else {
var delta = this.nextChar - this.markedChar;
if (delta >= this.readAheadLimit) {
this.markedChar = -2;
this.readAheadLimit = 0;
dst = 0;
} else {
if (this.readAheadLimit <= this.cb.length) {
System.arraycopy (this.cb, this.markedChar, this.cb, 0, delta);
this.markedChar = 0;
dst = delta;
} else {
var ncb =  Clazz.newCharArray (this.readAheadLimit, '\0');
System.arraycopy (this.cb, this.markedChar, ncb, 0, delta);
this.cb = ncb;
this.markedChar = 0;
dst = delta;
}this.nextChar = this.nChars = delta;
}}var n;
do {
n = this.$in.read (this.cb, dst, this.cb.length - dst);
} while (n == 0);
if (n > 0) {
this.nChars = dst + n;
this.nextChar = dst;
}}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "read1", 
($fz = function (cbuf, off, len) {
if (this.nextChar >= this.nChars) {
if (len >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
return this.$in.read (cbuf, off, len);
}this.fill ();
}if (this.nextChar >= this.nChars) return -1;
if (this.skipLF) {
this.skipLF = false;
if (this.cb[this.nextChar] == '\n') {
this.nextChar++;
if (this.nextChar >= this.nChars) this.fill ();
if (this.nextChar >= this.nChars) return -1;
}}var n = Math.min (len, this.nChars - this.nextChar);
System.arraycopy (this.cb, this.nextChar, cbuf, off, n);
this.nextChar += n;
return n;
}, $fz.isPrivate = true, $fz), "~A,~N,~N");
Clazz.defineMethod (c$, "read", 
function (cbuf, off, len) {
{
this.ensureOpen ();
if ((off < 0) || (off > cbuf.length) || (len < 0) || ((off + len) > cbuf.length) || ((off + len) < 0)) {
throw  new IndexOutOfBoundsException ();
} else if (len == 0) {
return 0;
}var n = this.read1 (cbuf, off, len);
if (n <= 0) return n;
while ((n < len) && this.$in.ready ()) {
var n1 = this.read1 (cbuf, off + n, len - n);
if (n1 <= 0) break;
n += n1;
}
return n;
}}, "~A,~N,~N");
Clazz.defineMethod (c$, "readLine1", 
($fz = function (ignoreLF) {
var s = null;
var startChar;
{
this.ensureOpen ();
var omitLF = ignoreLF || this.skipLF;
for (; ; ) {
if (this.nextChar >= this.nChars) this.fill ();
if (this.nextChar >= this.nChars) {
if (s != null && s.length () > 0) return s.toString ();
return null;
}var eol = false;
var c = String.fromCharCode (0);
var i;
if (omitLF && (this.cb[this.nextChar] == '\n')) this.nextChar++;
this.skipLF = false;
omitLF = false;
charLoop : for (i = this.nextChar; i < this.nChars; i++) {
c = this.cb[i];
if ((c == '\n') || (c == '\r')) {
eol = true;
break charLoop;
}}
startChar = this.nextChar;
this.nextChar = i;
if (eol) {
var str;
if (s == null) {
str =  String.instantialize (this.cb, startChar, i - startChar);
} else {
s.appendCB (this.cb, startChar, i - startChar);
str = s.toString ();
}this.nextChar++;
if (c == '\r') {
this.skipLF = true;
}return str;
}if (s == null) s = org.jmol.util.StringXBuilder.newN (java.io.BufferedReader.defaultExpectedLineLength);
s.appendCB (this.cb, startChar, i - startChar);
}
}}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "readLine", 
function () {
return this.readLine1 (false);
});
Clazz.overrideMethod (c$, "skip", 
function (n) {
if (n < 0) {
throw  new IllegalArgumentException ("skip value is negative");
}{
this.ensureOpen ();
var r = n;
while (r > 0) {
if (this.nextChar >= this.nChars) this.fill ();
if (this.nextChar >= this.nChars) break;
if (this.skipLF) {
this.skipLF = false;
if (this.cb[this.nextChar] == '\n') {
this.nextChar++;
}}var d = this.nChars - this.nextChar;
if (r <= d) {
this.nextChar += r;
r = 0;
break;
}r -= d;
this.nextChar = this.nChars;
}
return n - r;
}}, "~N");
Clazz.defineMethod (c$, "ready", 
function () {
{
this.ensureOpen ();
if (this.skipLF) {
if (this.nextChar >= this.nChars && this.$in.ready ()) {
this.fill ();
}if (this.nextChar < this.nChars) {
if (this.cb[this.nextChar] == '\n') this.nextChar++;
this.skipLF = false;
}}return (this.nextChar < this.nChars) || this.$in.ready ();
}});
Clazz.overrideMethod (c$, "markSupported", 
function () {
return true;
});
Clazz.overrideMethod (c$, "mark", 
function (readAheadLimit) {
if (readAheadLimit < 0) {
throw  new IllegalArgumentException ("Read-ahead limit < 0");
}{
this.ensureOpen ();
this.readAheadLimit = readAheadLimit;
this.markedChar = this.nextChar;
this.markedSkipLF = this.skipLF;
}}, "~N");
Clazz.overrideMethod (c$, "reset", 
function () {
{
this.ensureOpen ();
if (this.markedChar < 0) throw  new java.io.IOException ((this.markedChar == -2) ? "Mark invalid" : "Stream not marked");
this.nextChar = this.markedChar;
this.skipLF = this.markedSkipLF;
}});
Clazz.defineMethod (c$, "close", 
function () {
{
if (this.$in == null) return;
this.$in.close ();
this.$in = null;
this.cb = null;
}});
Clazz.defineStatics (c$,
"INVALIDATED", -2,
"UNMARKED", -1,
"defaultCharBufferSize", 8192,
"defaultExpectedLineLength", 80);
});
// 
//// java\io\Writer.js 
// 
$_L(["java.io.Closeable","$.Flushable","java.lang.Appendable"],"java.io.Writer",["java.lang.NullPointerException","$.StringIndexOutOfBoundsException"],function(){
c$=$_C(function(){
this.lock=null;
$_Z(this,arguments);
},java.io,"Writer",null,[Appendable,java.io.Closeable,java.io.Flushable]);
$_K(c$,
function(){
this.lock=this;
});
$_K(c$,
function(lock){
if(lock!=null){
this.lock=lock;
}else{
throw new NullPointerException();
}},"~O");
$_M(c$,"write",
function(buf){
this.write(buf,0,buf.length);
},"~A");
$_M(c$,"write",
function(oneChar){
{
var oneCharArray=$_A(1,'\0');
oneCharArray[0]=String.fromCharCode(oneChar);
this.write(oneCharArray);
}},"~N");
$_M(c$,"write",
function(str){
var buf=$_A(str.length,'\0');
str.getChars(0,buf.length,buf,0);
{
this.write(buf);
}},"~S");
$_M(c$,"write",
function(str,offset,count){
if(count>=0){
var buf=$_A(count,'\0');
str.getChars(offset,offset+count,buf,0);
{
this.write(buf);
}}else{
throw new StringIndexOutOfBoundsException();
}},"~S,~N,~N");
$_M(c$,"append",
function(c){
this.write(c.charCodeAt(0));
return this;
},"~N");
$_M(c$,"append",
function(csq){
if(null==csq){
this.write("null");
}else{
this.write(csq.toString());
}return this;
},"CharSequence");
$_M(c$,"append",
function(csq,start,end){
if(null==csq){
this.write("null".substring(start,end));
}else{
this.write(csq.subSequence(start,end).toString());
}return this;
},"CharSequence,~N,~N");
$_S(c$,
"TOKEN_NULL","null");
});
// 
//// java\io\BufferedWriter.js 
// 
$_L(["java.io.Writer"],"java.io.BufferedWriter",["java.io.IOException","java.lang.IllegalArgumentException","$.IndexOutOfBoundsException","$.StringIndexOutOfBoundsException",null],function(){
c$=$_C(function(){
this.out=null;
this.buf=null;
this.pos=0;
this.lineSeparator="\r\n";
$_Z(this,arguments);
},java.io,"BufferedWriter",java.io.Writer);
$_K(c$,
function(out){
$_R(this,java.io.BufferedWriter,[out]);
this.out=out;
this.buf=$_A(8192,'\0');
},"java.io.Writer");
$_K(c$,
function(out,size){
$_R(this,java.io.BufferedWriter,[out]);
if(size>0){
this.out=out;
this.buf=$_A(size,'\0');
}else{
throw new IllegalArgumentException(("K0058"));
}},"java.io.Writer,~N");
$_M(c$,"close",
function(){
{
if(this.isOpen()){
this.flush();
this.out.close();
this.buf=null;
this.out=null;
}}});
$_M(c$,"flush",
function(){
{
if(this.isOpen()){
if(this.pos>0){
this.out.write(this.buf,0,this.pos);
}this.pos=0;
this.out.flush();
}else{
throw new java.io.IOException(("K005d"));
}}});
$_M(c$,"isOpen",
($fz=function(){
return this.out!=null;
},$fz.isPrivate=true,$fz));
$_M(c$,"newLine",
function(){
this.write("\r\n",0,"\r\n".length);
});
$_M(c$,"write",
function(cbuf,offset,count){
{
if(!this.isOpen()){
throw new java.io.IOException(("K005d"));
}if(offset<0||offset>cbuf.length-count||count<0){
throw new IndexOutOfBoundsException();
}if(this.pos==0&&count>=this.buf.length){
this.out.write(cbuf,offset,count);
return;
}var available=this.buf.length-this.pos;
if(count<available){
available=count;
}if(available>0){
System.arraycopy(cbuf,offset,this.buf,this.pos,available);
this.pos+=available;
}if(this.pos==this.buf.length){
this.out.write(this.buf,0,this.buf.length);
this.pos=0;
if(count>available){
offset+=available;
available=count-available;
if(available>=this.buf.length){
this.out.write(cbuf,offset,available);
return;
}System.arraycopy(cbuf,offset,this.buf,this.pos,available);
this.pos+=available;
}}}},"~A,~N,~N");
$_M(c$,"write",
function(oneChar){
{
if(this.isOpen()){
if(this.pos>=this.buf.length){
this.out.write(this.buf,0,this.buf.length);
this.pos=0;
}this.buf[this.pos++]=String.fromCharCode(oneChar);
}else{
throw new java.io.IOException(("K005d"));
}}},"~N");
$_M(c$,"write",
function(str,offset,count){
{
if(!this.isOpen()){
throw new java.io.IOException(("K005d"));
}if(count<=0){
return;
}if(offset>str.length-count||offset<0){
throw new StringIndexOutOfBoundsException();
}if(this.pos==0&&count>=this.buf.length){
var chars=$_A(count,'\0');
str.getChars(offset,offset+count,chars,0);
this.out.write(chars,0,count);
return;
}var available=this.buf.length-this.pos;
if(count<available){
available=count;
}if(available>0){
str.getChars(offset,offset+available,this.buf,this.pos);
this.pos+=available;
}if(this.pos==this.buf.length){
this.out.write(this.buf,0,this.buf.length);
this.pos=0;
if(count>available){
offset+=available;
available=count-available;
if(available>=this.buf.length){
var chars=$_A(count,'\0');
str.getChars(offset,offset+available,chars,0);
this.out.write(chars,0,available);
return;
}str.getChars(offset,offset+available,this.buf,this.pos);
this.pos+=available;
}}}},"~S,~N,~N");
});
// 
//// java\io\StringReader.js 
// 
$_L(["java.io.Reader"],"java.io.StringReader",["java.io.IOException","java.lang.ArrayIndexOutOfBoundsException","$.IllegalArgumentException",null],function(){
c$=$_C(function(){
this.str=null;
this.markpos=-1;
this.pos=0;
this.count=0;
$_Z(this,arguments);
},java.io,"StringReader",java.io.Reader);
$_K(c$,
function(str){
$_R(this,java.io.StringReader,[str]);
this.str=str;
this.count=str.length;
},"~S");
$_V(c$,"close",
function(){
{
if(this.isOpen()){
this.str=null;
}}});
$_M(c$,"isOpen",
($fz=function(){
return this.str!=null;
},$fz.isPrivate=true,$fz));
$_V(c$,"mark",
function(readLimit){
if(readLimit>=0){
{
if(this.isOpen()){
this.markpos=this.pos;
}else{
throw new java.io.IOException(("K0083"));
}}}else{
throw new IllegalArgumentException();
}},"~N");
$_V(c$,"markSupported",
function(){
return true;
});
$_M(c$,"read",
function(){
{
if(this.isOpen()){
if(this.pos!=this.count){
return this.str.charAt(this.pos++);
}return-1;
}throw new java.io.IOException(("K0083"));
}});
$_M(c$,"read",
function(buf,offset,len){
if(0<=offset&&offset<=buf.length&&0<=len&&len<=buf.length-offset){
{
if(this.isOpen()){
if(this.pos==this.count){
return-1;
}var end=this.pos+len>this.count?this.count:this.pos+len;
this.str.getChars(this.pos,end,buf,offset);
var read=end-this.pos;
this.pos=end;
return read;
}throw new java.io.IOException(("K0083"));
}}throw new ArrayIndexOutOfBoundsException();
},"~A,~N,~N");
$_V(c$,"ready",
function(){
{
if(this.isOpen()){
return true;
}throw new java.io.IOException(("K0083"));
}});
$_V(c$,"reset",
function(){
{
if(this.isOpen()){
this.pos=this.markpos!=-1?this.markpos:0;
}else{
throw new java.io.IOException(("K0083"));
}}});
$_V(c$,"skip",
function(ns){
{
if(this.isOpen()){
if(ns<=0){
return 0;
}var skipped=0;
if(ns<this.count-this.pos){
this.pos=this.pos+ns;
skipped=ns;
}else{
skipped=this.count-this.pos;
this.pos=this.count;
}return skipped;
}throw new java.io.IOException(("K0083"));
}},"~N");
});
// 
//// java\lang\Thread.js 
// 
$_L(null,"java.lang.Thread",["java.lang.IllegalArgumentException","$.ThreadGroup","java.util.Date"],function(){
c$=$_C(function(){
this.target=null;
this.group=null;
this.name=null;
this.priority=0;
$_Z(this,arguments);
},java.lang,"Thread",null,Runnable);
c$.currentThread=$_M(c$,"currentThread",
function(){
if(Thread.J2S_THREAD==null){
($t$=Thread.J2S_THREAD=new Thread(),Thread.prototype.J2S_THREAD=Thread.J2S_THREAD,$t$);
}return Thread.J2S_THREAD;
});
c$.sleep=$_M(c$,"sleep",
function(millis){
Clazz.alert("Thread.sleep is not implemented in Java2Script!");
},"~N");
$_K(c$,
function(){
});
$_K(c$,
function(target){
this.init(null,target,"Thread-"+new java.util.Date().getTime()+Math.random(),0);
},"Runnable");
$_K(c$,
function(group,target){
this.init(group,target,"Thread-"+new java.util.Date().getTime()+Math.random(),0);
},"ThreadGroup,Runnable");
$_K(c$,
function(name){
this.init(null,null,name,0);
},"~S");
$_K(c$,
function(group,name){
this.init(group,null,name,0);
},"ThreadGroup,~S");
$_K(c$,
function(target,name){
this.init(null,target,name,0);
},"Runnable,~S");
$_K(c$,
function(group,target,name){
this.init(group,target,name,0);
},"ThreadGroup,Runnable,~S");
$_K(c$,
function(group,target,name,stackSize){
this.init(group,target,name,stackSize);
},"ThreadGroup,Runnable,~S,~N");
$_M(c$,"init",
($fz=function(g,target,name,stackSize){
if(g==null){
g=new ThreadGroup();
}this.group=g;
this.target=target;
this.name=name;
this.priority=5;
},$fz.isPrivate=true,$fz),"ThreadGroup,Runnable,~S,~N");
$_M(c$,"start",
function(){
window.setTimeout((function(runnable){
return function(){
runnable.run();
};
})(this),0);
});
$_M(c$,"run",
function(){
if(this.target!=null){
this.target.run();
}});
$_M(c$,"setPriority",
function(newPriority){
if(newPriority>10||newPriority<1){
throw new IllegalArgumentException();
}this.priority=newPriority;
},"~N");
$_M(c$,"getPriority",
function(){
return this.priority;
});


$_M(c$,"interrupt",
function(){
 //not implemented
});

$_M(c$,"setName",
function(name){
this.name=name;
},"~S");
$_M(c$,"getName",
function(){
return String.valueOf(this.name);
});
$_M(c$,"getThreadGroup",
function(){
return this.group;
});
$_V(c$,"toString",
function(){
var group=this.getThreadGroup();
if(group!=null){
return"Thread["+this.getName()+","+this.getPriority()+","+group.getName()+"]";
}else{
return"Thread["+this.getName()+","+this.getPriority()+","+""+"]";
}});
$_S(c$,
"MIN_PRIORITY",1,
"NORM_PRIORITY",5,
"MAX_PRIORITY",10,
"J2S_THREAD",null);
});
// 
//// org\jmol\constant\EnumQuantumShell.js 
// 
Clazz.declarePackage ("org.jmol.constant");
Clazz.load (["java.lang.Enum"], "org.jmol.constant.EnumQuantumShell", ["org.jmol.util.StringXBuilder"], function () {
c$ = Clazz.decorateAsClass (function () {
this.tag = null;
this.tag2 = null;
this.id = 0;
this.idSpherical = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.constant, "EnumQuantumShell", Enum);
Clazz.makeConstructor (c$, 
($fz = function (tag, tag2, id, idSpherical) {
this.tag = tag;
this.tag2 = tag2;
this.id = id;
this.idSpherical = idSpherical;
}, $fz.isPrivate = true, $fz), "~S,~S,~N,~N");
c$.getNewDfCoefMap = Clazz.defineMethod (c$, "getNewDfCoefMap", 
function () {
return [ Clazz.newIntArray (1, 0),  Clazz.newIntArray (3, 0),  Clazz.newIntArray (4, 0),  Clazz.newIntArray (5, 0),  Clazz.newIntArray (6, 0),  Clazz.newIntArray (7, 0),  Clazz.newIntArray (10, 0)];
});
c$.getQuantumShellTagID = Clazz.defineMethod (c$, "getQuantumShellTagID", 
function (tag) {
if (tag.equals ("L")) return org.jmol.constant.EnumQuantumShell.SP.id;
var item = org.jmol.constant.EnumQuantumShell.getQuantumShell (tag);
return (item == null ? -1 : item.id);
}, "~S");
c$.getQuantumShell = Clazz.defineMethod (c$, "getQuantumShell", 
($fz = function (tag) {
for (var item, $item = 0, $$item = org.jmol.constant.EnumQuantumShell.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (item.tag.equals (tag) || item.tag2.equals (tag)) return item;

return null;
}, $fz.isPrivate = true, $fz), "~S");
c$.getQuantumShellTagIDSpherical = Clazz.defineMethod (c$, "getQuantumShellTagIDSpherical", 
function (tag) {
if (tag.equals ("L")) return org.jmol.constant.EnumQuantumShell.SP.idSpherical;
var item = org.jmol.constant.EnumQuantumShell.getQuantumShell (tag);
return (item == null ? -1 : item.idSpherical);
}, "~S");
c$.getItem = Clazz.defineMethod (c$, "getItem", 
function (id) {
switch (id) {
case 0:
return org.jmol.constant.EnumQuantumShell.S;
case 1:
return org.jmol.constant.EnumQuantumShell.P;
case 2:
return org.jmol.constant.EnumQuantumShell.SP;
case 3:
return org.jmol.constant.EnumQuantumShell.D_SPHERICAL;
case 4:
return org.jmol.constant.EnumQuantumShell.D_CARTESIAN;
case 5:
return org.jmol.constant.EnumQuantumShell.F_SPHERICAL;
case 6:
return org.jmol.constant.EnumQuantumShell.F_CARTESIAN;
case 7:
return org.jmol.constant.EnumQuantumShell.G_SPHERICAL;
case 8:
return org.jmol.constant.EnumQuantumShell.G_CARTESIAN;
case 9:
return org.jmol.constant.EnumQuantumShell.H_SPHERICAL;
case 10:
return org.jmol.constant.EnumQuantumShell.H_CARTESIAN;
}
return null;
}, "~N");
c$.getQuantumShellTag = Clazz.defineMethod (c$, "getQuantumShellTag", 
function (id) {
for (var item, $item = 0, $$item = org.jmol.constant.EnumQuantumShell.values (); $item < $$item.length && ((item = $$item[$item]) || true); $item++) if (item.id == id) return item.tag;

return "" + id;
}, "~N");
c$.getMOString = Clazz.defineMethod (c$, "getMOString", 
function (lc) {
var sb =  new org.jmol.util.StringXBuilder ();
if (lc.length == 2) return "" + Clazz.floatToInt (lc[0] < 0 ? -lc[1] : lc[1]);
sb.appendC ('[');
for (var i = 0; i < lc.length; i += 2) {
if (i > 0) sb.append (", ");
sb.appendF (lc[i]).append (" ").appendI (Clazz.floatToInt (lc[i + 1]));
}
sb.appendC (']');
return sb.toString ();
}, "~A");
c$.SUPPORTED_BASIS_FUNCTIONS = "SPLDF";
Clazz.defineEnumConstant (c$, "S", 0, ["S", "S", 0, 0]);
Clazz.defineEnumConstant (c$, "P", 1, ["P", "X", 1, 1]);
Clazz.defineEnumConstant (c$, "SP", 2, ["SP", "SP", 2, 2]);
Clazz.defineEnumConstant (c$, "D_SPHERICAL", 3, ["5D", "5D", 3, 3]);
Clazz.defineEnumConstant (c$, "D_CARTESIAN", 4, ["D", "XX", 4, 3]);
Clazz.defineEnumConstant (c$, "F_SPHERICAL", 5, ["7F", "7F", 5, 5]);
Clazz.defineEnumConstant (c$, "F_CARTESIAN", 6, ["F", "XXX", 6, 5]);
Clazz.defineEnumConstant (c$, "G_SPHERICAL", 7, ["9G", "9G", 7, 7]);
Clazz.defineEnumConstant (c$, "G_CARTESIAN", 8, ["G", "XXXX", 8, 7]);
Clazz.defineEnumConstant (c$, "H_SPHERICAL", 9, ["10H", "10H", 9, 9]);
Clazz.defineEnumConstant (c$, "H_CARTESIAN", 10, ["H", "XXXXX", 10, 9]);
});
// 
//// org\jmol\api\JmolAdapter.js 
// 
Clazz.declarePackage ("org.jmol.api");
Clazz.load (["org.jmol.constant.EnumQuantumShell"], "org.jmol.api.JmolAdapter", ["java.util.Hashtable", "org.jmol.api.JmolViewer", "org.jmol.modelset.Group", "org.jmol.util.Elements", "org.jmol.viewer.JmolConstants"], function () {
c$ = Clazz.decorateAsClass (function () {
this.adapterName = null;
Clazz.instantialize (this, arguments);
}, org.jmol.api, "JmolAdapter");
c$.getShellEnumeration = Clazz.defineMethod (c$, "getShellEnumeration", 
function (i) {
return org.jmol.constant.EnumQuantumShell.getItem (i);
}, "~N");
c$.getNewDfCoefMap = Clazz.defineMethod (c$, "getNewDfCoefMap", 
function () {
return org.jmol.constant.EnumQuantumShell.getNewDfCoefMap ();
});
c$.getElementSymbol = Clazz.defineMethod (c$, "getElementSymbol", 
function (elementNumber) {
return org.jmol.util.Elements.elementSymbolFromNumber (elementNumber);
}, "~N");
c$.getElementNumber = Clazz.defineMethod (c$, "getElementNumber", 
function (elementSymbol) {
return org.jmol.util.Elements.elementNumberFromSymbol (elementSymbol, false);
}, "~S");
c$.getNaturalIsotope = Clazz.defineMethod (c$, "getNaturalIsotope", 
function (elementNumber) {
return org.jmol.util.Elements.getNaturalIsotope (elementNumber);
}, "~N");
c$.isHetero = Clazz.defineMethod (c$, "isHetero", 
function (group3) {
return org.jmol.viewer.JmolConstants.isHetero (group3);
}, "~S");
c$.getQuantumShellTagID = Clazz.defineMethod (c$, "getQuantumShellTagID", 
function (tag) {
return org.jmol.constant.EnumQuantumShell.getQuantumShellTagID (tag);
}, "~S");
c$.getQuantumShellTagIDSpherical = Clazz.defineMethod (c$, "getQuantumShellTagIDSpherical", 
function (tag) {
return org.jmol.constant.EnumQuantumShell.getQuantumShellTagIDSpherical (tag);
}, "~S");
c$.lookupGroupID = Clazz.defineMethod (c$, "lookupGroupID", 
function (group3) {
return org.jmol.modelset.Group.lookupGroupID (group3);
}, "~S");
c$.getBondingRadiusFloat = Clazz.defineMethod (c$, "getBondingRadiusFloat", 
function (atomicNumberWithIsotope, charge) {
return org.jmol.util.Elements.getBondingRadiusFloat (atomicNumberWithIsotope, charge);
}, "~N,~N");
Clazz.makeConstructor (c$, 
function (adapterName) {
this.adapterName = adapterName;
}, "~S");
Clazz.defineMethod (c$, "getAdapterName", 
function () {
return this.adapterName;
});
Clazz.defineMethod (c$, "getAtomSetCollectionFromReader", 
function (name, type, bufferedReader, htParams) {
if (htParams == null) htParams =  new java.util.Hashtable ();
if (!htParams.containsKey ("viewer")) htParams.put ("viewer", org.jmol.api.JmolViewer.allocateViewer (null, this));
var a = this.getAtomSetCollectionReader (name, type, bufferedReader, htParams);
if (Clazz.instanceOf (a, String)) return a;
return this.getAtomSetCollection (a);
}, "~S,~S,java.io.BufferedReader,java.util.Map");
Clazz.defineMethod (c$, "openBufferedReader", 
function (name, bufferedReader) {
return this.getAtomSetCollectionFromReader (name, null, bufferedReader, null);
}, "~S,java.io.BufferedReader");
Clazz.defineMethod (c$, "openBufferedReader", 
function (name, bufferedReader, htParams) {
return this.getAtomSetCollectionFromReader (name, null, bufferedReader, htParams);
}, "~S,java.io.BufferedReader,java.util.Map");
Clazz.defineMethod (c$, "openBufferedReader", 
function (name, type, bufferedReader) {
return this.getAtomSetCollectionFromReader (name, type, bufferedReader, null);
}, "~S,~S,java.io.BufferedReader");
Clazz.defineMethod (c$, "finish", 
function (atomSetCollection) {
}, "~O");
c$.canonizeAlphaDigit = Clazz.defineMethod (c$, "canonizeAlphaDigit", 
function (ch) {
if ((ch >= 'A' && ch <= 'Z') || (ch >= 'a' && ch <= 'z') || (ch >= '0' && ch <= '9')) return ch;
return '\0';
}, "~S");
c$.canonizeChainID = Clazz.defineMethod (c$, "canonizeChainID", 
function (chainID) {
return org.jmol.api.JmolAdapter.canonizeAlphaDigit (chainID);
}, "~S");
c$.canonizeInsertionCode = Clazz.defineMethod (c$, "canonizeInsertionCode", 
function (insertionCode) {
return org.jmol.api.JmolAdapter.canonizeAlphaDigit (insertionCode);
}, "~S");
c$.canonizeAlternateLocationID = Clazz.defineMethod (c$, "canonizeAlternateLocationID", 
function (altLoc) {
return org.jmol.api.JmolAdapter.canonizeAlphaDigit (altLoc);
}, "~S");
Clazz.defineStatics (c$,
"ORDER_COVALENT_SINGLE", 1,
"ORDER_COVALENT_DOUBLE", 2,
"ORDER_COVALENT_TRIPLE", 3,
"ORDER_AROMATIC", 515,
"ORDER_AROMATIC_SINGLE", 513,
"ORDER_AROMATIC_DOUBLE", 514,
"ORDER_HBOND", 2048,
"ORDER_STEREO_NEAR", 1025,
"ORDER_STEREO_FAR", 1041,
"ORDER_PARTIAL01", 33,
"ORDER_PARTIAL12", 66,
"ORDER_PARTIAL23", 97,
"ORDER_PARTIAL32", 100,
"ORDER_UNSPECIFIED", 17);
c$.SHELL_S = c$.prototype.SHELL_S = org.jmol.constant.EnumQuantumShell.S.id;
c$.SHELL_P = c$.prototype.SHELL_P = org.jmol.constant.EnumQuantumShell.P.id;
c$.SHELL_SP = c$.prototype.SHELL_SP = org.jmol.constant.EnumQuantumShell.SP.id;
c$.SHELL_L = c$.prototype.SHELL_L = org.jmol.constant.EnumQuantumShell.SP.id;
c$.SHELL_D_SPHERICAL = c$.prototype.SHELL_D_SPHERICAL = org.jmol.constant.EnumQuantumShell.D_SPHERICAL.id;
c$.SHELL_D_CARTESIAN = c$.prototype.SHELL_D_CARTESIAN = org.jmol.constant.EnumQuantumShell.D_CARTESIAN.id;
c$.SHELL_F_SPHERICAL = c$.prototype.SHELL_F_SPHERICAL = org.jmol.constant.EnumQuantumShell.F_SPHERICAL.id;
c$.SHELL_F_CARTESIAN = c$.prototype.SHELL_F_CARTESIAN = org.jmol.constant.EnumQuantumShell.F_CARTESIAN.id;
c$.SUPPORTED_BASIS_FUNCTIONS = c$.prototype.SUPPORTED_BASIS_FUNCTIONS = "SPLDF";
c$.NOTE_SCRIPT_FILE = c$.prototype.NOTE_SCRIPT_FILE = "NOTE: file recognized as a script file: ";
Clazz.defineStatics (c$,
"cellParamNames", ["_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma"]);
});
// 
//// org\jmol\adapter\smarter\SmarterJmolAdapter.js 
// 
Clazz.declarePackage ("org.jmol.adapter.smarter");
Clazz.load (["org.jmol.api.JmolAdapter"], "org.jmol.adapter.smarter.SmarterJmolAdapter", ["org.jmol.adapter.smarter.AtomIterator", "$.AtomSetCollection", "$.BondIterator", "$.Resolver", "$.StructureIterator", "org.jmol.util.Logger"], function () {
c$ = Clazz.declareType (org.jmol.adapter.smarter, "SmarterJmolAdapter", org.jmol.api.JmolAdapter);
Clazz.makeConstructor (c$, 
function () {
Clazz.superConstructor (this, org.jmol.adapter.smarter.SmarterJmolAdapter, ["SmarterJmolAdapter"]);
});
Clazz.overrideMethod (c$, "getFileTypeName", 
function (atomSetCollectionOrReader) {
if (Clazz.instanceOf (atomSetCollectionOrReader, org.jmol.adapter.smarter.AtomSetCollection)) return (atomSetCollectionOrReader).getFileTypeName ();
if (Clazz.instanceOf (atomSetCollectionOrReader, java.io.BufferedReader)) return org.jmol.adapter.smarter.Resolver.getFileType (atomSetCollectionOrReader);
return null;
}, "~O");
Clazz.overrideMethod (c$, "getAtomSetCollectionReader", 
function (name, type, bufferedReader, htParams) {
return org.jmol.adapter.smarter.SmarterJmolAdapter.staticGetAtomSetCollectionReader (name, type, bufferedReader, htParams);
}, "~S,~S,java.io.BufferedReader,java.util.Map");
c$.staticGetAtomSetCollectionReader = Clazz.defineMethod (c$, "staticGetAtomSetCollectionReader", 
function (name, type, bufferedReader, htParams) {
try {
var ret = org.jmol.adapter.smarter.Resolver.getAtomCollectionReader (name, type, bufferedReader, htParams, -1);
if (Clazz.instanceOf (ret, String)) {
try {
bufferedReader.close ();
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
} else {
throw e;
}
}
} else {
(ret).setup (name, htParams, bufferedReader);
}return ret;
} catch (e) {
try {
bufferedReader.close ();
} catch (ex) {
if (Clazz.exceptionOf (ex, Exception)) {
} else {
throw ex;
}
}
bufferedReader = null;
org.jmol.util.Logger.error ("" + e);
return "" + e;
}
}, "~S,~S,java.io.BufferedReader,java.util.Map");
Clazz.defineMethod (c$, "getAtomSetCollectionFromReader", 
function (fname, reader, htParams) {
var ret = org.jmol.adapter.smarter.Resolver.getAtomCollectionReader (fname, null, reader, htParams, -1);
if (Clazz.instanceOf (ret, org.jmol.adapter.smarter.AtomSetCollectionReader)) {
(ret).setup (fname, htParams, reader);
return (ret).readData ();
}return "" + ret;
}, "~S,java.io.BufferedReader,java.util.Map");
Clazz.overrideMethod (c$, "getAtomSetCollection", 
function (atomSetCollectionReader) {
return org.jmol.adapter.smarter.SmarterJmolAdapter.staticGetAtomSetCollection (atomSetCollectionReader);
}, "~O");
c$.staticGetAtomSetCollection = Clazz.defineMethod (c$, "staticGetAtomSetCollection", 
function (a) {
var br = null;
try {
br = a.reader;
var ret = a.readData ();
if (!(Clazz.instanceOf (ret, org.jmol.adapter.smarter.AtomSetCollection))) return ret;
var atomSetCollection = ret;
if (atomSetCollection.errorMessage != null) return atomSetCollection.errorMessage;
return atomSetCollection;
} catch (e) {
try {
System.out.println (e.toString ());
} catch (ee) {
if (Clazz.exceptionOf (ee, Exception)) {
org.jmol.util.Logger.error (e.toString ());
} else {
throw ee;
}
}
try {
br.close ();
} catch (ex) {
if (Clazz.exceptionOf (ex, Exception)) {
} else {
throw ex;
}
}
br = null;
org.jmol.util.Logger.error ("" + e);
return "" + e;
}
}, "org.jmol.adapter.smarter.AtomSetCollectionReader");
Clazz.overrideMethod (c$, "getAtomSetCollectionReaders", 
function (fileReader, names, types, htParams, getReadersOnly) {
var size = names.length;
var readers = (getReadersOnly ?  new Array (size) : null);
var atomsets = (getReadersOnly ? null :  new Array (size));
for (var i = 0; i < size; i++) {
try {
var reader = fileReader.getBufferedReaderOrBinaryDocument (i, false);
if (!(Clazz.instanceOf (reader, java.io.BufferedReader))) return reader;
var ret = org.jmol.adapter.smarter.Resolver.getAtomCollectionReader (names[i], (types == null ? null : types[i]), reader, htParams, i);
if (!(Clazz.instanceOf (ret, org.jmol.adapter.smarter.AtomSetCollectionReader))) return ret;
var r = ret;
if (r.isBinary) {
r.setup (names[i], htParams, fileReader.getBufferedReaderOrBinaryDocument (i, true));
} else {
r.setup (names[i], htParams, reader);
}if (getReadersOnly) {
readers[i] = r;
} else {
ret = r.readData ();
if (!(Clazz.instanceOf (ret, org.jmol.adapter.smarter.AtomSetCollection))) return ret;
atomsets[i] = ret;
if (atomsets[i].errorMessage != null) return atomsets[i].errorMessage;
}} catch (e) {
org.jmol.util.Logger.error ("" + e);
return "" + e;
}
}
if (getReadersOnly) return readers;
return this.getAtomSetCollectionFromSet (readers, atomsets, htParams);
}, "org.jmol.api.JmolFilesReaderInterface,~A,~A,java.util.Map,~B");
Clazz.overrideMethod (c$, "getAtomSetCollectionFromSet", 
function (readerSet, atomsets, htParams) {
var readers = readerSet;
var asc = (atomsets == null ?  new Array (readers.length) : atomsets);
if (atomsets == null) {
for (var i = 0; i < readers.length; i++) {
try {
var ret = readers[i].readData ();
if (!(Clazz.instanceOf (ret, org.jmol.adapter.smarter.AtomSetCollection))) return ret;
asc[i] = ret;
if (asc[i].errorMessage != null) return asc[i].errorMessage;
} catch (e) {
org.jmol.util.Logger.error ("" + e);
return "" + e;
}
}
}var result;
if (htParams.containsKey ("trajectorySteps")) {
result = asc[0];
try {
result.finalizeTrajectoryAs (htParams.get ("trajectorySteps"), htParams.get ("vibrationSteps"));
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
if (result.errorMessage == null) result.errorMessage = "" + e;
} else {
throw e;
}
}
} else {
result =  new org.jmol.adapter.smarter.AtomSetCollection ("Array", null, asc, null);
}return (result.errorMessage == null ? result : result.errorMessage);
}, "~O,~O,java.util.Map");
Clazz.overrideMethod (c$, "getAtomSetCollectionFromDOM", 
function (DOMNode, htParams) {
try {
var ret = org.jmol.adapter.smarter.Resolver.DOMResolve (DOMNode, htParams);
if (!(Clazz.instanceOf (ret, org.jmol.adapter.smarter.AtomSetCollectionReader))) return ret;
var a = ret;
a.setup ("DOM node", htParams, null);
ret = a.readDataObject (DOMNode);
if (!(Clazz.instanceOf (ret, org.jmol.adapter.smarter.AtomSetCollection))) return ret;
var asc = ret;
if (asc.errorMessage != null) return asc.errorMessage;
return asc;
} catch (e) {
org.jmol.util.Logger.error ("" + e);
return "" + e;
}
}, "~O,java.util.Map");
Clazz.overrideMethod (c$, "finish", 
function (atomSetCollection) {
(atomSetCollection).finish ();
}, "~O");
Clazz.overrideMethod (c$, "getAtomSetCollectionName", 
function (atomSetCollection) {
return (atomSetCollection).getCollectionName ();
}, "~O");
Clazz.overrideMethod (c$, "getAtomSetCollectionAuxiliaryInfo", 
function (atomSetCollection) {
return (atomSetCollection).getAtomSetCollectionAuxiliaryInfoMap ();
}, "~O");
Clazz.overrideMethod (c$, "getAtomSetCount", 
function (atomSetCollection) {
return (atomSetCollection).getAtomSetCount ();
}, "~O");
Clazz.overrideMethod (c$, "getAtomSetNumber", 
function (atomSetCollection, atomSetIndex) {
return (atomSetCollection).getAtomSetNumber (atomSetIndex);
}, "~O,~N");
Clazz.overrideMethod (c$, "getAtomSetName", 
function (atomSetCollection, atomSetIndex) {
return (atomSetCollection).getAtomSetName (atomSetIndex);
}, "~O,~N");
Clazz.overrideMethod (c$, "getAtomSetAuxiliaryInfo", 
function (atomSetCollection, atomSetIndex) {
return (atomSetCollection).getAtomSetAuxiliaryInfo (atomSetIndex);
}, "~O,~N");
Clazz.overrideMethod (c$, "getHydrogenAtomCount", 
function (atomSetCollection) {
return (atomSetCollection).getHydrogenAtomCount ();
}, "~O");
Clazz.overrideMethod (c$, "getBondList", 
function (atomSetCollection) {
return (atomSetCollection).getBondList ();
}, "~O");
Clazz.overrideMethod (c$, "getAtomCount", 
function (atomSetCollection) {
var a = atomSetCollection;
return (a.bsAtoms == null ? a.getAtomCount () : a.bsAtoms.cardinality ());
}, "~O");
Clazz.overrideMethod (c$, "coordinatesAreFractional", 
function (atomSetCollection) {
return (atomSetCollection).coordinatesAreFractional;
}, "~O");
Clazz.overrideMethod (c$, "getNotionalUnitcell", 
function (atomSetCollection) {
return (atomSetCollection).notionalUnitCell;
}, "~O");
Clazz.overrideMethod (c$, "getPdbScaleMatrix", 
function (atomSetCollection) {
var a = (atomSetCollection).notionalUnitCell;
if (a.length < 22) return null;
var b =  Clazz.newFloatArray (16, 0);
for (var i = 0; i < 16; i++) b[i] = a[6 + i];

return b;
}, "~O");
Clazz.overrideMethod (c$, "getPdbScaleTranslate", 
function (atomSetCollection) {
var a = (atomSetCollection).notionalUnitCell;
if (a.length < 22) return null;
var b =  Clazz.newFloatArray (3, 0);
b[0] = a[9];
b[1] = a[13];
b[2] = a[17];
return b;
}, "~O");
Clazz.overrideMethod (c$, "getAtomIterator", 
function (atomSetCollection) {
return  new org.jmol.adapter.smarter.AtomIterator (atomSetCollection);
}, "~O");
Clazz.overrideMethod (c$, "getBondIterator", 
function (atomSetCollection) {
return  new org.jmol.adapter.smarter.BondIterator (atomSetCollection);
}, "~O");
Clazz.overrideMethod (c$, "getStructureIterator", 
function (atomSetCollection) {
return (atomSetCollection).getStructureCount () == 0 ? null :  new org.jmol.adapter.smarter.StructureIterator (atomSetCollection);
}, "~O");
Clazz.defineStatics (c$,
"PATH_KEY", ".PATH");
c$.PATH_SEPARATOR = c$.prototype.PATH_SEPARATOR = System.getProperty ("path.separator", "/");
});
// 
//// org\jmol\api\Interface.js 
// 
Clazz.declarePackage ("org.jmol.api");
Clazz.load (null, "org.jmol.api.Interface", ["org.jmol.util.Logger"], function () {
c$ = Clazz.declareType (org.jmol.api, "Interface");
c$.getOptionInterface = Clazz.defineMethod (c$, "getOptionInterface", 
function (name) {
return org.jmol.api.Interface.getInterface ("org.jmol." + name);
}, "~S");
c$.getApplicationInterface = Clazz.defineMethod (c$, "getApplicationInterface", 
function (name) {
return org.jmol.api.Interface.getInterface ("org.openscience.jmol.app." + name);
}, "~S");
c$.getInterface = Clazz.defineMethod (c$, "getInterface", 
function (name) {
try {
var x = Class.forName (name);
return (x == null ? null : x.newInstance ());
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
org.jmol.util.Logger.error ("Interface.java Error creating instance for " + name + ": \n" + e.getMessage ());
return null;
} else {
throw e;
}
}
}, "~S");
});
// 
//// java\lang\ThreadGroup.js 
// 
$_L(null,"java.lang.ThreadGroup",["java.lang.NullPointerException","$.Thread"],function(){
c$=$_C(function(){
this.parent=null;
this.name=null;
this.maxPriority=0;
$_Z(this,arguments);
},java.lang,"ThreadGroup");
$_K(c$,
function(){
this.name="system";
this.maxPriority=10;
});
$_K(c$,
function(name){
this.construct(Thread.currentThread().getThreadGroup(),name);
},"~S");
$_K(c$,
function(parent,name){
if(parent==null){
throw new NullPointerException();
}this.name=name;
this.parent=parent;
this.maxPriority=10;
},"ThreadGroup,~S");
$_M(c$,"getName",
function(){
return this.name;
});
$_M(c$,"getParent",
function(){
return this.parent;
});
$_M(c$,"getMaxPriority",
function(){
return this.maxPriority;
});
});
// 
//// org\jmol\constant\EnumAxesMode.js 
// 
Clazz.declarePackage ("org.jmol.constant");
Clazz.load (["java.lang.Enum"], "org.jmol.constant.EnumAxesMode", null, function () {
c$ = Clazz.decorateAsClass (function () {
this.code = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.constant, "EnumAxesMode", Enum);
Clazz.makeConstructor (c$, 
($fz = function (code) {
this.code = code;
}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineMethod (c$, "getCode", 
function () {
return this.code;
});
c$.getAxesMode = Clazz.defineMethod (c$, "getAxesMode", 
function (code) {
for (var mode, $mode = 0, $$mode = org.jmol.constant.EnumAxesMode.values (); $mode < $$mode.length && ((mode = $$mode[$mode]) || true); $mode++) {
if (mode.getCode () == code) {
return mode;
}}
return null;
}, "~N");
Clazz.defineEnumConstant (c$, "BOUNDBOX", 0, [0]);
Clazz.defineEnumConstant (c$, "MOLECULAR", 1, [1]);
Clazz.defineEnumConstant (c$, "UNITCELL", 2, [2]);
});
// 
//// org\jmol\constant\EnumFileStatus.js 
// 
Clazz.declarePackage ("org.jmol.constant");
Clazz.load (["java.lang.Enum"], "org.jmol.constant.EnumFileStatus", null, function () {
c$ = Clazz.decorateAsClass (function () {
this.code = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.constant, "EnumFileStatus", Enum);
Clazz.defineMethod (c$, "getCode", 
function () {
return this.code;
});
Clazz.makeConstructor (c$, 
($fz = function (code) {
this.code = code;
}, $fz.isPrivate = true, $fz), "~N");
Clazz.defineEnumConstant (c$, "DELETED", 0, [5]);
Clazz.defineEnumConstant (c$, "CREATED", 1, [3]);
Clazz.defineEnumConstant (c$, "CREATING_MODELSET", 2, [2]);
Clazz.defineEnumConstant (c$, "ZAPPED", 3, [0]);
Clazz.defineEnumConstant (c$, "NOT_LOADED", 4, [-1]);
});
// 
//// org\jmol\api\JmolAdapterAtomIterator.js 
// 
Clazz.declarePackage ("org.jmol.api");
c$ = Clazz.declareType (org.jmol.api, "JmolAdapterAtomIterator");
Clazz.defineMethod (c$, "getAtomSetIndex", 
function () {
return 0;
});
Clazz.defineMethod (c$, "getAtomSymmetry", 
function () {
return null;
});
Clazz.defineMethod (c$, "getAtomSite", 
function () {
return -2147483648;
});
Clazz.defineMethod (c$, "getElementNumber", 
function () {
return -1;
});
Clazz.defineMethod (c$, "getAtomName", 
function () {
return null;
});
Clazz.defineMethod (c$, "getFormalCharge", 
function () {
return 0;
});
Clazz.defineMethod (c$, "getPartialCharge", 
function () {
return NaN;
});
Clazz.defineMethod (c$, "getEllipsoid", 
function () {
return null;
});
Clazz.defineMethod (c$, "getRadius", 
function () {
return NaN;
});
Clazz.defineMethod (c$, "getVectorX", 
function () {
return NaN;
});
Clazz.defineMethod (c$, "getVectorY", 
function () {
return NaN;
});
Clazz.defineMethod (c$, "getVectorZ", 
function () {
return NaN;
});
Clazz.defineMethod (c$, "getBfactor", 
function () {
return NaN;
});
Clazz.defineMethod (c$, "getOccupancy", 
function () {
return 100;
});
Clazz.defineMethod (c$, "getIsHetero", 
function () {
return false;
});
Clazz.defineMethod (c$, "getAtomSerial", 
function () {
return -2147483648;
});
Clazz.defineMethod (c$, "getChainID", 
function () {
return '\0';
});
Clazz.defineMethod (c$, "getAlternateLocationID", 
function () {
return '\0';
});
Clazz.defineMethod (c$, "getGroup3", 
function () {
return null;
});
Clazz.defineMethod (c$, "getSequenceNumber", 
function () {
return -2147483648;
});
Clazz.defineMethod (c$, "getInsertionCode", 
function () {
return '\0';
});
// 
//// org\jmol\adapter\smarter\AtomIterator.js 
// 
Clazz.declarePackage ("org.jmol.adapter.smarter");
Clazz.load (["org.jmol.api.JmolAdapterAtomIterator"], "org.jmol.adapter.smarter.AtomIterator", ["java.lang.Float", "org.jmol.api.JmolAdapter"], function () {
c$ = Clazz.decorateAsClass (function () {
this.iatom = 0;
this.atom = null;
this.atomCount = 0;
this.atoms = null;
this.bsAtoms = null;
Clazz.instantialize (this, arguments);
}, org.jmol.adapter.smarter, "AtomIterator", org.jmol.api.JmolAdapterAtomIterator);
Clazz.makeConstructor (c$, 
function (atomSetCollection) {
Clazz.superConstructor (this, org.jmol.adapter.smarter.AtomIterator, []);
this.atomCount = atomSetCollection.getAtomCount ();
this.atoms = atomSetCollection.getAtoms ();
this.bsAtoms = atomSetCollection.bsAtoms;
this.iatom = 0;
}, "org.jmol.adapter.smarter.AtomSetCollection");
Clazz.overrideMethod (c$, "hasNext", 
function () {
if (this.iatom == this.atomCount) return false;
while ((this.atom = this.atoms[this.iatom++]) == null || (this.bsAtoms != null && !this.bsAtoms.get (this.atom.atomIndex))) if (this.iatom == this.atomCount) return false;

this.atoms[this.iatom - 1] = null;
return true;
});
Clazz.overrideMethod (c$, "getAtomSetIndex", 
function () {
return this.atom.atomSetIndex;
});
Clazz.overrideMethod (c$, "getAtomSymmetry", 
function () {
return this.atom.bsSymmetry;
});
Clazz.overrideMethod (c$, "getAtomSite", 
function () {
return this.atom.atomSite + 1;
});
Clazz.overrideMethod (c$, "getUniqueID", 
function () {
return Integer.$valueOf (this.atom.atomIndex);
});
Clazz.overrideMethod (c$, "getElementNumber", 
function () {
return (this.atom.elementNumber > 0 ? this.atom.elementNumber : org.jmol.api.JmolAdapter.getElementNumber (this.atom.getElementSymbol ()));
});
Clazz.overrideMethod (c$, "getAtomName", 
function () {
return this.atom.atomName;
});
Clazz.overrideMethod (c$, "getFormalCharge", 
function () {
return this.atom.formalCharge;
});
Clazz.overrideMethod (c$, "getPartialCharge", 
function () {
return this.atom.partialCharge;
});
Clazz.overrideMethod (c$, "getEllipsoid", 
function () {
return this.atom.ellipsoid;
});
Clazz.overrideMethod (c$, "getRadius", 
function () {
return this.atom.radius;
});
Clazz.overrideMethod (c$, "getX", 
function () {
return this.atom.x;
});
Clazz.overrideMethod (c$, "getY", 
function () {
return this.atom.y;
});
Clazz.overrideMethod (c$, "getZ", 
function () {
return this.atom.z;
});
Clazz.overrideMethod (c$, "getVectorX", 
function () {
return this.atom.vectorX;
});
Clazz.overrideMethod (c$, "getVectorY", 
function () {
return this.atom.vectorY;
});
Clazz.overrideMethod (c$, "getVectorZ", 
function () {
return this.atom.vectorZ;
});
Clazz.overrideMethod (c$, "getBfactor", 
function () {
return Float.isNaN (this.atom.bfactor) && this.atom.anisoBorU != null ? this.atom.anisoBorU[7] * 100 : this.atom.bfactor;
});
Clazz.overrideMethod (c$, "getOccupancy", 
function () {
return this.atom.occupancy;
});
Clazz.overrideMethod (c$, "getIsHetero", 
function () {
return this.atom.isHetero;
});
Clazz.overrideMethod (c$, "getAtomSerial", 
function () {
return this.atom.atomSerial;
});
Clazz.overrideMethod (c$, "getChainID", 
function () {
return org.jmol.api.JmolAdapter.canonizeChainID (this.atom.chainID);
});
Clazz.overrideMethod (c$, "getAlternateLocationID", 
function () {
return org.jmol.api.JmolAdapter.canonizeAlternateLocationID (this.atom.alternateLocationID);
});
Clazz.overrideMethod (c$, "getGroup3", 
function () {
return this.atom.group3;
});
Clazz.overrideMethod (c$, "getSequenceNumber", 
function () {
return this.atom.sequenceNumber;
});
Clazz.overrideMethod (c$, "getInsertionCode", 
function () {
return org.jmol.api.JmolAdapter.canonizeInsertionCode (this.atom.insertionCode);
});
Clazz.overrideMethod (c$, "getXYZ", 
function () {
return this.atom;
});
});
// 
//// org\jmol\adapter\smarter\AtomSetCollection.js 
// 
Clazz.declarePackage ("org.jmol.adapter.smarter");
Clazz.load (["java.util.Hashtable", "org.jmol.util.Point3f"], "org.jmol.adapter.smarter.AtomSetCollection", ["java.lang.Boolean", "$.Float", "java.util.ArrayList", "$.Collections", "$.Properties", "org.jmol.adapter.smarter.Atom", "$.Bond", "$.SmarterJmolAdapter", "org.jmol.api.Interface", "org.jmol.util.ArrayUtil", "$.BitSet", "$.BitSetUtil", "$.Escape", "$.Logger", "$.Matrix4f", "$.Parser", "$.Point3i", "$.Quadric", "$.StringXBuilder", "$.TextFormat", "$.Vector3f"], function () {
c$ = Clazz.decorateAsClass (function () {
this.fileTypeName = null;
this.collectionName = null;
this.atomSetCollectionAuxiliaryInfo = null;
this.bsAtoms = null;
this.atomCount = 0;
this.atoms = null;
this.bondCount = 0;
this.bonds = null;
this.structureCount = 0;
this.structures = null;
this.atomSetCount = 0;
this.currentAtomSetIndex = -1;
this.atomSetNumbers = null;
this.atomSetAtomIndexes = null;
this.atomSetAtomCounts = null;
this.atomSetBondCounts = null;
this.atomSetAuxiliaryInfo = null;
this.latticeCells = null;
this.errorMessage = null;
this.coordinatesAreFractional = false;
this.isTrajectory = false;
this.trajectoryStepCount = 0;
this.trajectorySteps = null;
this.vibrationSteps = null;
this.trajectoryNames = null;
this.doFixPeriodic = false;
this.notionalUnitCell = null;
this.allowMultiple = false;
this.vConnect = null;
this.connectNextAtomIndex = 0;
this.connectNextAtomSet = 0;
this.connectLast = null;
this.symmetryRange = 0;
this.doCentroidUnitCell = false;
this.centroidPacked = false;
this.ptSupercell = null;
this.fmatSupercell = null;
this.symmetry = null;
this.haveUnitCell = false;
this.doNormalize = true;
this.doPackUnitCell = false;
this.rminx = 0;
this.rminy = 0;
this.rminz = 0;
this.rmaxx = 0;
this.rmaxy = 0;
this.rmaxz = 0;
this.ptOffset = null;
this.unitCellOffset = null;
this.minXYZ = null;
this.maxXYZ = null;
this.minXYZ0 = null;
this.maxXYZ0 = null;
this.haveAnisou = false;
this.dtype = 3;
this.unitCellTranslations = null;
this.baseSymmetryAtomCount = 0;
this.cartesians = null;
this.bondCount0 = 0;
this.bondIndex0 = 0;
this.applySymmetryToBonds = false;
this.checkSpecial = true;
this.ptTemp = null;
this.ptTemp1 = null;
this.ptTemp2 = null;
this.atomSymbolicMap = null;
this.haveMappedSerials = false;
Clazz.instantialize (this, arguments);
}, org.jmol.adapter.smarter, "AtomSetCollection");
Clazz.prepareFields (c$, function () {
this.atomSetCollectionAuxiliaryInfo =  new java.util.Hashtable ();
this.atoms =  new Array (256);
this.bonds =  new Array (256);
this.structures =  new Array (16);
this.atomSetNumbers =  Clazz.newIntArray (16, 0);
this.atomSetAtomIndexes =  Clazz.newIntArray (16, 0);
this.atomSetAtomCounts =  Clazz.newIntArray (16, 0);
this.atomSetBondCounts =  Clazz.newIntArray (16, 0);
this.atomSetAuxiliaryInfo =  new Array (16);
this.notionalUnitCell =  Clazz.newFloatArray (6, 0);
this.ptOffset =  new org.jmol.util.Point3f ();
this.ptTemp =  new org.jmol.util.Point3f ();
this.ptTemp1 =  new org.jmol.util.Point3f ();
this.ptTemp2 =  new org.jmol.util.Point3f ();
this.atomSymbolicMap =  new java.util.Hashtable ();
});
Clazz.defineMethod (c$, "getFileTypeName", 
function () {
return this.fileTypeName;
});
Clazz.defineMethod (c$, "getCollectionName", 
function () {
return this.collectionName;
});
Clazz.defineMethod (c$, "setCollectionName", 
function (collectionName) {
if (collectionName != null) {
collectionName = collectionName.trim ();
if (collectionName.length == 0) return;
this.collectionName = collectionName;
}}, "~S");
Clazz.defineMethod (c$, "getAtomSetCollectionAuxiliaryInfoMap", 
function () {
return this.atomSetCollectionAuxiliaryInfo;
});
Clazz.defineMethod (c$, "clearGlobalBoolean", 
function (globalIndex) {
this.atomSetCollectionAuxiliaryInfo.remove (org.jmol.adapter.smarter.AtomSetCollection.globalBooleans[globalIndex]);
}, "~N");
Clazz.defineMethod (c$, "setGlobalBoolean", 
function (globalIndex) {
this.setAtomSetCollectionAuxiliaryInfo (org.jmol.adapter.smarter.AtomSetCollection.globalBooleans[globalIndex], Boolean.TRUE);
}, "~N");
Clazz.defineMethod (c$, "getGlobalBoolean", 
function (globalIndex) {
return (this.getAtomSetCollectionAuxiliaryInfo (org.jmol.adapter.smarter.AtomSetCollection.globalBooleans[globalIndex]) === Boolean.TRUE);
}, "~N");
Clazz.defineMethod (c$, "getAtomCount", 
function () {
return this.atomCount;
});
Clazz.defineMethod (c$, "getHydrogenAtomCount", 
function () {
var n = 0;
for (var i = 0; i < this.atomCount; i++) if (this.atoms[i].elementNumber == 1 || this.atoms[i].elementSymbol.equals ("H")) n++;

return n;
});
Clazz.defineMethod (c$, "getAtoms", 
function () {
return this.atoms;
});
Clazz.defineMethod (c$, "getAtom", 
function (i) {
return this.atoms[i];
}, "~N");
Clazz.defineMethod (c$, "getBondCount", 
function () {
return this.bondCount;
});
Clazz.defineMethod (c$, "getBonds", 
function () {
return this.bonds;
});
Clazz.defineMethod (c$, "getBond", 
function (i) {
return this.bonds[i];
}, "~N");
Clazz.defineMethod (c$, "getStructureCount", 
function () {
return this.structureCount;
});
Clazz.defineMethod (c$, "getStructures", 
function () {
return this.structures;
});
Clazz.defineMethod (c$, "getAtomSetCount", 
function () {
return this.atomSetCount;
});
Clazz.defineMethod (c$, "getCurrentAtomSetIndex", 
function () {
return this.currentAtomSetIndex;
});
Clazz.defineMethod (c$, "setCurrentAtomSetIndex", 
function (i) {
this.currentAtomSetIndex = i;
}, "~N");
Clazz.defineMethod (c$, "setDoFixPeriodic", 
function () {
this.doFixPeriodic = true;
});
Clazz.makeConstructor (c$, 
function (fileTypeName, atomSetCollectionReader, array, list) {
this.fileTypeName = fileTypeName;
this.allowMultiple = (atomSetCollectionReader == null || atomSetCollectionReader.desiredVibrationNumber < 0);
var p =  new java.util.Properties ();
p.put ("PATH_KEY", ".PATH");
p.put ("PATH_SEPARATOR", org.jmol.adapter.smarter.SmarterJmolAdapter.PATH_SEPARATOR);
this.setAtomSetCollectionAuxiliaryInfo ("properties", p);
if (array != null) {
var n = 0;
for (var i = 0; i < array.length; i++) if (array[i].atomCount > 0) this.appendAtomSetCollection (n++, array[i]);

if (n > 1) this.setAtomSetCollectionAuxiliaryInfo ("isMultiFile", Boolean.TRUE);
} else if (list != null) {
this.setAtomSetCollectionAuxiliaryInfo ("isMultiFile", Boolean.TRUE);
this.appendAtomSetCollectionList (list);
}}, "~S,org.jmol.adapter.smarter.AtomSetCollectionReader,~A,java.util.List");
Clazz.defineMethod (c$, "appendAtomSetCollectionList", 
($fz = function (list) {
var n = list.size ();
if (n == 0) {
this.errorMessage = "No file found!";
return;
}for (var i = 0; i < n; i++) {
var o = list.get (i);
if (Clazz.instanceOf (o, java.util.List)) this.appendAtomSetCollectionList (o);
 else this.appendAtomSetCollection (i, o);
}
}, $fz.isPrivate = true, $fz), "java.util.List");
Clazz.defineMethod (c$, "setTrajectory", 
function () {
if (!this.isTrajectory) {
this.trajectorySteps =  new java.util.ArrayList ();
}this.isTrajectory = true;
this.addTrajectoryStep ();
});
Clazz.defineMethod (c$, "appendAtomSetCollection", 
function (collectionIndex, collection) {
var existingAtomsCount = this.atomCount;
this.setAtomSetCollectionAuxiliaryInfo ("loadState", collection.getAtomSetCollectionAuxiliaryInfo ("loadState"));
if (collection.bsAtoms != null) {
if (this.bsAtoms == null) this.bsAtoms =  new org.jmol.util.BitSet ();
for (var i = collection.bsAtoms.nextSetBit (0); i >= 0; i = collection.bsAtoms.nextSetBit (i + 1)) this.bsAtoms.set (existingAtomsCount + i);

}var clonedAtoms = 0;
for (var atomSetNum = 0; atomSetNum < collection.atomSetCount; atomSetNum++) {
this.newAtomSet ();
var info = this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = collection.atomSetAuxiliaryInfo[atomSetNum];
var atomInfo = info.get ("PDB_CONECT_firstAtom_count_max");
if (atomInfo != null) atomInfo[0] += existingAtomsCount;
this.setAtomSetAuxiliaryInfo ("title", collection.collectionName);
this.setAtomSetName (collection.getAtomSetName (atomSetNum));
for (var atomNum = 0; atomNum < collection.atomSetAtomCounts[atomSetNum]; atomNum++) {
try {
if (this.bsAtoms != null) this.bsAtoms.set (this.atomCount);
this.newCloneAtom (collection.atoms[clonedAtoms]);
} catch (e) {
if (Clazz.exceptionOf (e, Exception)) {
this.errorMessage = "appendAtomCollection error: " + e;
} else {
throw e;
}
}
clonedAtoms++;
}
for (var i = 0; i < collection.structureCount; i++) if (collection.structures[i] != null && (collection.structures[i].atomSetIndex == atomSetNum || collection.structures[i].atomSetIndex == -1)) this.addStructure (collection.structures[i]);

this.atomSetNumbers[this.currentAtomSetIndex] = (collectionIndex < 0 ? this.currentAtomSetIndex + 1 : ((collectionIndex + 1) * 1000000) + collection.atomSetNumbers[atomSetNum]);
}
for (var bondNum = 0; bondNum < collection.bondCount; bondNum++) {
var bond = collection.bonds[bondNum];
this.addNewBondWithOrder (bond.atomIndex1 + existingAtomsCount, bond.atomIndex2 + existingAtomsCount, bond.order);
}
for (var i = org.jmol.adapter.smarter.AtomSetCollection.globalBooleans.length; --i >= 0; ) if (collection.getGlobalBoolean (i)) this.setGlobalBoolean (i);

}, "~N,org.jmol.adapter.smarter.AtomSetCollection");
Clazz.defineMethod (c$, "setNoAutoBond", 
function () {
this.setAtomSetCollectionAuxiliaryInfo ("noAutoBond", Boolean.TRUE);
});
Clazz.defineMethod (c$, "freeze", 
function (reverseModels) {
if (reverseModels) this.reverseAtomSets ();
if (this.trajectoryStepCount > 1) this.finalizeTrajectory ();
this.getList (true);
this.getList (false);
for (var i = 0; i < this.atomSetCount; i++) {
this.setAtomSetAuxiliaryInfoForSet ("initialAtomCount", Integer.$valueOf (this.atomSetAtomCounts[i]), i);
this.setAtomSetAuxiliaryInfoForSet ("initialBondCount", Integer.$valueOf (this.atomSetBondCounts[i]), i);
}
}, "~B");
Clazz.defineMethod (c$, "reverseAtomSets", 
($fz = function () {
this.reverseArray (this.atomSetAtomIndexes);
this.reverseArray (this.atomSetNumbers);
this.reverseArray (this.atomSetAtomCounts);
this.reverseArray (this.atomSetBondCounts);
org.jmol.adapter.smarter.AtomSetCollection.reverseList (this.trajectorySteps);
org.jmol.adapter.smarter.AtomSetCollection.reverseList (this.trajectoryNames);
org.jmol.adapter.smarter.AtomSetCollection.reverseList (this.vibrationSteps);
this.reverseObject (this.atomSetAuxiliaryInfo);
for (var i = 0; i < this.atomCount; i++) this.atoms[i].atomSetIndex = this.atomSetCount - 1 - this.atoms[i].atomSetIndex;

for (var i = 0; i < this.structureCount; i++) if (this.structures[i].atomSetIndex >= 0) this.structures[i].atomSetIndex = this.atomSetCount - 1 - this.structures[i].atomSetIndex;

for (var i = 0; i < this.bondCount; i++) this.bonds[i].atomSetIndex = this.atomSetCount - 1 - this.atoms[this.bonds[i].atomIndex1].atomSetIndex;

this.reverseSets (this.structures, this.structureCount);
this.reverseSets (this.bonds, this.bondCount);
var lists = org.jmol.util.ArrayUtil.createArrayOfArrayList (this.atomSetCount);
for (var i = 0; i < this.atomSetCount; i++) lists[i] =  new java.util.ArrayList ();

for (var i = 0; i < this.atomCount; i++) lists[this.atoms[i].atomSetIndex].add (this.atoms[i]);

var newIndex =  Clazz.newIntArray (this.atomCount, 0);
var n = this.atomCount;
for (var i = this.atomSetCount; --i >= 0; ) for (var j = lists[i].size (); --j >= 0; ) {
var a = this.atoms[--n] = lists[i].get (j);
newIndex[a.atomIndex] = n;
a.atomIndex = n;
}

for (var i = 0; i < this.bondCount; i++) {
this.bonds[i].atomIndex1 = newIndex[this.bonds[i].atomIndex1];
this.bonds[i].atomIndex2 = newIndex[this.bonds[i].atomIndex2];
}
for (var i = 0; i < this.atomSetCount; i++) {
var conect = this.getAtomSetAuxiliaryInfoValue (i, "PDB_CONECT_firstAtom_count_max");
if (conect == null) continue;
conect[0] = newIndex[conect[0]];
conect[1] = this.atomSetAtomCounts[i];
}
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "reverseSets", 
($fz = function (o, n) {
var lists = org.jmol.util.ArrayUtil.createArrayOfArrayList (this.atomSetCount);
for (var i = 0; i < this.atomSetCount; i++) lists[i] =  new java.util.ArrayList ();

for (var i = 0; i < n; i++) {
var index = o[i].atomSetIndex;
if (index < 0) return;
lists[o[i].atomSetIndex].add (o[i]);
}
for (var i = this.atomSetCount; --i >= 0; ) for (var j = lists[i].size (); --j >= 0; ) o[--n] = lists[i].get (j);


}, $fz.isPrivate = true, $fz), "~A,~N");
Clazz.defineMethod (c$, "reverseObject", 
($fz = function (o) {
var n = this.atomSetCount;
for (var i = Clazz.doubleToInt (n / 2); --i >= 0; ) org.jmol.util.ArrayUtil.swap (o, i, n - 1 - i);

}, $fz.isPrivate = true, $fz), "~A");
c$.reverseList = Clazz.defineMethod (c$, "reverseList", 
($fz = function (list) {
if (list == null) return;
java.util.Collections.reverse (list);
}, $fz.isPrivate = true, $fz), "java.util.List");
Clazz.defineMethod (c$, "reverseArray", 
($fz = function (a) {
var n = this.atomSetCount;
for (var i = Clazz.doubleToInt (n / 2); --i >= 0; ) org.jmol.util.ArrayUtil.swapInt (a, i, n - 1 - i);

}, $fz.isPrivate = true, $fz), "~A");
Clazz.defineMethod (c$, "getList", 
($fz = function (isAltLoc) {
var i;
for (i = this.atomCount; --i >= 0; ) if (this.atoms[i] != null && (isAltLoc ? this.atoms[i].alternateLocationID : this.atoms[i].insertionCode) != '\0') break;

if (i < 0) return;
var lists =  new Array (this.atomSetCount);
for (i = 0; i < this.atomSetCount; i++) lists[i] = "";

var pt;
for (i = 0; i < this.atomCount; i++) {
if (this.atoms[i] == null) continue;
var id = (isAltLoc ? this.atoms[i].alternateLocationID : this.atoms[i].insertionCode);
if (id != '\0' && lists[pt = this.atoms[i].atomSetIndex].indexOf (id) < 0) lists[pt] += id;
}
var type = (isAltLoc ? "altLocs" : "insertionCodes");
for (i = 0; i < this.atomSetCount; i++) if (lists[i].length > 0) this.setAtomSetAuxiliaryInfoForSet (type, lists[i], i);

}, $fz.isPrivate = true, $fz), "~B");
Clazz.defineMethod (c$, "finish", 
function () {
this.atoms = null;
this.atomSetAtomCounts =  Clazz.newIntArray (16, 0);
this.atomSetAuxiliaryInfo =  new Array (16);
this.atomSetCollectionAuxiliaryInfo =  new java.util.Hashtable ();
this.atomSetCount = 0;
this.atomSetNumbers =  Clazz.newIntArray (16, 0);
this.atomSymbolicMap =  new java.util.Hashtable ();
this.bonds = null;
this.cartesians = null;
this.connectLast = null;