Clazz.declarePackage ("org.jmol.shape");
Clazz.load (["org.jmol.shape.Shape", "org.jmol.util.Point3i"], "org.jmol.shape.Sticks", ["java.util.Hashtable", "org.jmol.constant.EnumPalette", "org.jmol.util.BitSet", "$.BitSetUtil", "$.Colix", "$.Escape", "$.JmolEdge", "$.Point3f"], function () {
c$ = Clazz.decorateAsClass (function () {
this.myMask = 0;
this.reportAll = false;
this.bsOrderSet = null;
this.bsSizeSet = null;
this.bsColixSet = null;
this.selectedBonds = null;
this.ptXY = null;
Clazz.instantialize (this, arguments);
}, org.jmol.shape, "Sticks", org.jmol.shape.Shape);
Clazz.prepareFields (c$, function () {
this.ptXY =  new org.jmol.util.Point3i ();
});
Clazz.defineMethod (c$, "initShape", 
function () {
Clazz.superCall (this, org.jmol.shape.Sticks, "initShape", []);
this.myMask = 1023;
this.reportAll = false;
});
Clazz.overrideMethod (c$, "setSize", 
function (size, bsSelected) {
if (size == 2147483647) {
this.selectedBonds = org.jmol.util.BitSetUtil.copy (bsSelected);
return;
}if (size == -2147483648) {
if (this.bsOrderSet == null) this.bsOrderSet =  new org.jmol.util.BitSet ();
this.bsOrderSet.or (bsSelected);
return;
}if (this.bsSizeSet == null) this.bsSizeSet =  new org.jmol.util.BitSet ();
var iter = (this.selectedBonds != null ? this.modelSet.getBondIterator (this.selectedBonds) : this.modelSet.getBondIteratorForType (this.myMask, bsSelected));
var mad = size;
while (iter.hasNext ()) {
this.bsSizeSet.set (iter.nextIndex ());
iter.next ().setMad (mad);
}
}, "~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "setProperty", 
function (propertyName, value, bs) {
if ("type" === propertyName) {
this.myMask = (value).intValue ();
return;
}if ("reportAll" === propertyName) {
this.reportAll = true;
return;
}if ("reset" === propertyName) {
this.bsOrderSet = null;
this.bsSizeSet = null;
this.bsColixSet = null;
this.selectedBonds = null;
return;
}if ("bondOrder" === propertyName) {
if (this.bsOrderSet == null) this.bsOrderSet =  new org.jmol.util.BitSet ();
var order = (value).shortValue ();
var iter = (this.selectedBonds != null ? this.modelSet.getBondIterator (this.selectedBonds) : this.modelSet.getBondIteratorForType (65535, bs));
while (iter.hasNext ()) {
this.bsOrderSet.set (iter.nextIndex ());
iter.next ().setOrder (order);
}
return;
}if ("color" === propertyName) {
if (this.bsColixSet == null) this.bsColixSet =  new org.jmol.util.BitSet ();
var colix = org.jmol.util.Colix.getColixO (value);
var pal = (Clazz.instanceOf (value, org.jmol.constant.EnumPalette) ? value : null);
if (pal === org.jmol.constant.EnumPalette.TYPE || pal === org.jmol.constant.EnumPalette.ENERGY) {
var isEnergy = (pal === org.jmol.constant.EnumPalette.ENERGY);
var iter = (this.selectedBonds != null ? this.modelSet.getBondIterator (this.selectedBonds) : this.modelSet.getBondIteratorForType (this.myMask, bs));
while (iter.hasNext ()) {
this.bsColixSet.set (iter.nextIndex ());
var bond = iter.next ();
if (isEnergy) {
bond.setColix (this.setColixB (colix, pal.id, bond));
bond.setPaletteID (pal.id);
} else {
bond.setColix (org.jmol.util.Colix.getColix (org.jmol.util.JmolEdge.getArgbHbondType (bond.order)));
}}
return;
}if (colix == 2 && pal !== org.jmol.constant.EnumPalette.CPK) return;
var iter = (this.selectedBonds != null ? this.modelSet.getBondIterator (this.selectedBonds) : this.modelSet.getBondIteratorForType (this.myMask, bs));
while (iter.hasNext ()) {
var iBond = iter.nextIndex ();
var bond = iter.next ();
bond.setColix (colix);
this.bsColixSet.setBitTo (iBond, (colix != 0 && colix != 2));
}
return;
}if ("translucency" === propertyName) {
if (this.bsColixSet == null) this.bsColixSet =  new org.jmol.util.BitSet ();
var isTranslucent = ((value).equals ("translucent"));
var iter = (this.selectedBonds != null ? this.modelSet.getBondIterator (this.selectedBonds) : this.modelSet.getBondIteratorForType (this.myMask, bs));
while (iter.hasNext ()) {
this.bsColixSet.set (iter.nextIndex ());
iter.next ().setTranslucent (isTranslucent, this.translucentLevel);
}
return;
}if ("deleteModelAtoms" === propertyName) {
return;
}Clazz.superCall (this, org.jmol.shape.Sticks, "setProperty", [propertyName, value, bs]);
}, "~S,~O,org.jmol.util.BitSet");
Clazz.overrideMethod (c$, "getProperty", 
function (property, index) {
if (property.equals ("selectionState")) return (this.selectedBonds != null ? "select BONDS " + org.jmol.util.Escape.escape (this.selectedBonds) + "\n" : "");
if (property.equals ("sets")) return [this.bsOrderSet, this.bsSizeSet, this.bsColixSet];
return null;
}, "~S,~N");
Clazz.overrideMethod (c$, "setModelClickability", 
function () {
var bonds = this.modelSet.getBonds ();
for (var i = this.modelSet.getBondCount (); --i >= 0; ) {
var bond = bonds[i];
if ((bond.getShapeVisibilityFlags () & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden (bond.getAtomIndex1 ()) || this.modelSet.isAtomHidden (bond.getAtomIndex2 ())) continue;
bond.getAtom1 ().setClickable (this.myVisibilityFlag);
bond.getAtom2 ().setClickable (this.myVisibilityFlag);
}
});
Clazz.overrideMethod (c$, "getShapeState", 
function () {
var temp =  new java.util.Hashtable ();
var temp2 =  new java.util.Hashtable ();
var haveTainted = false;
var bonds = this.modelSet.getBonds ();
var r;
var bondCount = this.modelSet.getBondCount ();
if (this.reportAll || this.bsSizeSet != null) {
var i0 = (this.reportAll ? bondCount - 1 : this.bsSizeSet.nextSetBit (0));
for (var i = i0; i >= 0; i = (this.reportAll ? i - 1 : this.bsSizeSet.nextSetBit (i + 1))) org.jmol.shape.Shape.setStateInfo (temp, i, "wireframe " + ((r = bonds[i].getMad ()) == 1 ? "on" : "" + (r / 2000)));

}if (this.reportAll || this.bsOrderSet != null) {
var i0 = (this.reportAll ? bondCount - 1 : this.bsOrderSet.nextSetBit (0));
for (var i = i0; i >= 0; i = (this.reportAll ? i - 1 : this.bsOrderSet.nextSetBit (i + 1))) {
var bond = bonds[i];
if (this.reportAll || (bond.order & 131072) == 0) org.jmol.shape.Shape.setStateInfo (temp, i, "bondOrder " + org.jmol.util.JmolEdge.getBondOrderNameFromOrder (bond.order));
}
}if (this.bsColixSet != null) for (var i = this.bsColixSet.nextSetBit (0); i >= 0; i = this.bsColixSet.nextSetBit (i + 1)) {
var colix = bonds[i].getColix ();
if ((colix & -30721) == 2) org.jmol.shape.Shape.setStateInfo (temp, i, this.getColorCommand ("bonds", org.jmol.constant.EnumPalette.CPK.id, colix));
 else org.jmol.shape.Shape.setStateInfo (temp, i, this.getColorCommandUnk ("bonds", colix));
}
return org.jmol.shape.Shape.getShapeCommandsSel (temp, null, "select BONDS") + "\n" + (haveTainted ? org.jmol.shape.Shape.getShapeCommandsSel (temp2, null, "select BONDS") + "\n" : "");
});
Clazz.overrideMethod (c$, "checkObjectHovered", 
function (x, y, bsVisible) {
var pt =  new org.jmol.util.Point3f ();
var bond = this.findPickedBond (x, y, bsVisible, pt);
if (bond == null) return false;
this.viewer.highlightBond (bond.index, true);
return true;
}, "~N,~N,org.jmol.util.BitSet");
Clazz.overrideMethod (c$, "checkObjectClicked", 
function (x, y, modifiers, bsVisible) {
var pt =  new org.jmol.util.Point3f ();
var bond = this.findPickedBond (x, y, bsVisible, pt);
if (bond == null) return null;
var modelIndex = bond.getAtom1 ().modelIndex;
var info = bond.getIdentity ();
var map =  new java.util.Hashtable ();
map.put ("pt", pt);
map.put ("index", Integer.$valueOf (bond.index));
map.put ("modelIndex", Integer.$valueOf (modelIndex));
map.put ("model", this.viewer.getModelNumberDotted (modelIndex));
map.put ("type", "bond");
map.put ("info", info);
this.viewer.setStatusAtomPicked (-3, "[\"bond\",\"" + bond.getIdentity () + "\"," + pt.x + "," + pt.y + "," + pt.z + "]");
return map;
}, "~N,~N,~N,org.jmol.util.BitSet");
Clazz.defineMethod (c$, "findPickedBond", 
($fz = function (x, y, bsVisible, pt) {
var dmin2 = 100;
if (this.gdata.isAntialiased ()) {
x <<= 1;
y <<= 1;
dmin2 <<= 1;
}var pickedBond = null;
var v =  new org.jmol.util.Point3f ();
var bonds = this.modelSet.getBonds ();
for (var i = this.modelSet.getBondCount (); --i >= 0; ) {
var bond = bonds[i];
if (bond.getShapeVisibilityFlags () == 0) continue;
var atom1 = bond.getAtom1 ();
var atom2 = bond.getAtom2 ();
if (!atom1.isVisible (0) || !atom2.isVisible (0)) continue;
v.setT (atom1);
v.add (atom2);
v.scale (0.5);
var d2 = this.coordinateInRange (x, y, v, dmin2, this.ptXY);
if (d2 >= 0) {
var f = 1 * (this.ptXY.x - atom1.screenX) / (atom2.screenX - atom1.screenX);
if (f < 0.4 || f > 0.6) continue;
dmin2 = d2;
pickedBond = bond;
pt.setT (v);
}}
return pickedBond;
}, $fz.isPrivate = true, $fz), "~N,~N,org.jmol.util.BitSet,org.jmol.util.Point3f");
Clazz.defineStatics (c$,
"MAX_BOND_CLICK_DISTANCE_SQUARED", 100);
});
