Clazz.declarePackage ("org.jmol.adapter.readers.simple");
Clazz.load (["org.jmol.adapter.smarter.AtomSetCollectionReader"], "org.jmol.adapter.readers.simple.HyperChemReader", ["java.lang.Exception"], function () {
c$ = Clazz.decorateAsClass (function () {
this.atomIndex = 0;
this.baseAtomIndex = 0;
Clazz.instantialize (this, arguments);
}, org.jmol.adapter.readers.simple, "HyperChemReader", org.jmol.adapter.smarter.AtomSetCollectionReader);
Clazz.overrideMethod (c$, "checkLine", 
function () {
if (this.line.length == 0 || this.line.charAt (0) == ';') return true;
if (this.line.startsWith ("mol ")) {
if (!this.doGetModel (++this.modelNumber, null)) return this.checkLastModel ();
this.processMol ();
return true;
}if (!this.doProcessLines) return true;
if (this.line.startsWith ("atom ")) {
this.processAtom ();
return true;
}if (this.line.startsWith ("endmol ")) {
this.applySymmetryAndSetTrajectory ();
return true;
}return true;
});
Clazz.defineMethod (c$, "processMol", 
($fz = function () {
this.atomSetCollection.newAtomSet ();
var molName = this.getMolName ();
this.atomSetCollection.setAtomSetName (molName);
this.atomIndex = 0;
this.baseAtomIndex = this.atomSetCollection.getAtomCount ();
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "getMolName", 
($fz = function () {
this.parseTokenStr (this.line);
this.parseToken ();
return this.parseToken ();
}, $fz.isPrivate = true, $fz));
Clazz.defineMethod (c$, "processAtom", 
($fz = function () {
var fileAtomNumber = this.parseIntAt (this.line, 5);
if (fileAtomNumber - 1 != this.atomIndex) {
throw  new Exception ("bad atom number sequence ... expected:" + (this.atomIndex + 1) + " found:" + fileAtomNumber);
}var atom = this.atomSetCollection.addNewAtom ();
this.parseToken ();
atom.elementSymbol = this.parseToken ();
this.parseToken ();
this.parseToken ();
atom.partialCharge = this.parseFloat ();
this.setAtomCoordXYZ (atom, this.parseFloat (), this.parseFloat (), this.parseFloat ());
var bondCount = this.parseInt ();
for (var i = 0; i < bondCount; ++i) {
var otherAtomNumber = this.parseInt ();
var bondTypeToken = this.parseToken ();
if (otherAtomNumber > this.atomIndex) continue;
var bondOrder;
switch (bondTypeToken.charAt (0)) {
case 's':
bondOrder = 1;
break;
case 'd':
bondOrder = 2;
break;
case 't':
bondOrder = 3;
break;
case 'a':
bondOrder = 515;
break;
default:
throw  new Exception ("unrecognized bond type:" + bondTypeToken + " atom #" + fileAtomNumber);
}
this.atomSetCollection.addNewBondWithOrder (this.baseAtomIndex + this.atomIndex, this.baseAtomIndex + otherAtomNumber - 1, bondOrder);
}
++this.atomIndex;
}, $fz.isPrivate = true, $fz));
});
