Clazz.declarePackage ("org.jmol.script");
Clazz.load (["java.util.Hashtable"], "org.jmol.script.Token", ["java.lang.Boolean", "java.util.ArrayList", "$.Arrays", "org.jmol.util.ArrayUtil", "$.Logger"], function () {
c$ = Clazz.decorateAsClass (function () {
this.tok = 0;
this.value = null;
this.intValue = 2147483647;
Clazz.instantialize (this, arguments);
}, org.jmol.script, "Token");
Clazz.makeConstructor (c$, 
function () {
});
Clazz.makeConstructor (c$, 
function (tok) {
this.tok = tok;
}, "~N");
c$.newTokenIntVal = Clazz.defineMethod (c$, "newTokenIntVal", 
function (tok, intValue, value) {
var token =  new org.jmol.script.Token (tok);
token.intValue = intValue;
token.value = value;
return token;
}, "~N,~N,~O");
c$.newTokenObj = Clazz.defineMethod (c$, "newTokenObj", 
function (tok, value) {
var token =  new org.jmol.script.Token (tok);
token.value = value;
return token;
}, "~N,~O");
c$.newToken = Clazz.defineMethod (c$, "newToken", 
function (tok, intValue) {
var token =  new org.jmol.script.Token (tok);
token.intValue = intValue;
return token;
}, "~N,~N");
c$.intToken = Clazz.defineMethod (c$, "intToken", 
function (intValue) {
var token =  new org.jmol.script.Token (2);
token.intValue = intValue;
return token;
}, "~N");
c$.tokAttr = Clazz.defineMethod (c$, "tokAttr", 
function (a, b) {
return (a & b) == (b & b);
}, "~N,~N");
c$.tokAttrOr = Clazz.defineMethod (c$, "tokAttrOr", 
function (a, b1, b2) {
return (a & b1) == (b1 & b1) || (a & b2) == (b2 & b2);
}, "~N,~N,~N");
c$.getPrecedence = Clazz.defineMethod (c$, "getPrecedence", 
function (tokOperator) {
return ((tokOperator >> 4) & 0xF);
}, "~N");
c$.getMaxMathParams = Clazz.defineMethod (c$, "getMaxMathParams", 
function (tokCommand) {
return ((tokCommand >> 9) & 0x7);
}, "~N");
c$.addToken = Clazz.defineMethod (c$, "addToken", 
function (ident, token) {
org.jmol.script.Token.tokenMap.put (ident, token);
}, "~S,org.jmol.script.Token");
c$.getTokenFromName = Clazz.defineMethod (c$, "getTokenFromName", 
function (name) {
return org.jmol.script.Token.tokenMap.get (name);
}, "~S");
c$.getTokFromName = Clazz.defineMethod (c$, "getTokFromName", 
function (name) {
var token = org.jmol.script.Token.getTokenFromName (name.toLowerCase ());
return (token == null ? 0 : token.tok);
}, "~S");
c$.nameOf = Clazz.defineMethod (c$, "nameOf", 
function (tok) {
for (var token, $token = org.jmol.script.Token.tokenMap.values ().iterator (); $token.hasNext () && ((token = $token.next ()) || true);) {
if (token.tok == tok) return "" + token.value;
}
return "0x" + Integer.toHexString (tok);
}, "~N");
Clazz.overrideMethod (c$, "toString", 
function () {
return "Token[" + org.jmol.script.Token.astrType[this.tok < 14 ? this.tok : 14] + "(" + (this.tok % (512)) + "/0x" + Integer.toHexString (this.tok) + ")" + ((this.intValue == 2147483647) ? "" : " intValue=" + this.intValue + "(0x" + Integer.toHexString (this.intValue) + ")") + ((this.value == null) ? "" : Clazz.instanceOf (this.value, String) ? " value=\"" + this.value + "\"" : " value=" + this.value) + "]";
});
c$.getCommandSet = Clazz.defineMethod (c$, "getCommandSet", 
function (strBegin) {
var cmds = "";
var htSet =  new java.util.Hashtable ();
var nCmds = 0;
var s = (strBegin == null || strBegin.length == 0 ? null : strBegin.toLowerCase ());
var isMultiCharacter = (s != null && s.length > 1);
for (var entry, $entry = org.jmol.script.Token.tokenMap.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var name = entry.getKey ();
var token = entry.getValue ();
if ((token.tok & 4096) != 0 && (s == null || name.indexOf (s) == 0) && (isMultiCharacter || (token.value).equals (name))) htSet.put (name, Boolean.TRUE);
}
for (var entry, $entry = htSet.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var name = entry.getKey ();
if (name.charAt (name.length - 1) != 's' || !htSet.containsKey (name.substring (0, name.length - 1))) cmds += (nCmds++ == 0 ? "" : ";") + name;
}
return cmds;
}, "~S");
c$.getAtomPropertiesLike = Clazz.defineMethod (c$, "getAtomPropertiesLike", 
function (type) {
type = type.toLowerCase ();
var v =  new java.util.ArrayList ();
var isAll = (type.length == 0);
for (var entry, $entry = org.jmol.script.Token.tokenMap.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var name = entry.getKey ();
if (name.charAt (0) == '_') continue;
var token = entry.getValue ();
if (org.jmol.script.Token.tokAttr (token.tok, 1078984704) && (isAll || name.toLowerCase ().startsWith (type))) {
if (isAll || !(token.value).toLowerCase ().startsWith (type)) token = org.jmol.script.Token.newTokenObj (token.tok, name);
v.add (token);
}}
return (v.size () == 0 ? null : v);
}, "~S");
c$.getTokensLike = Clazz.defineMethod (c$, "getTokensLike", 
function (type) {
var attr = (type.equals ("setparam") ? 536870912 : type.equals ("misc") ? 1073741824 : type.equals ("mathfunc") ? 135266304 : 4096);
var notattr = (attr == 536870912 ? 1610612736 : 0);
var v =  new java.util.ArrayList ();
for (var entry, $entry = org.jmol.script.Token.tokenMap.entrySet ().iterator (); $entry.hasNext () && ((entry = $entry.next ()) || true);) {
var name = entry.getKey ();
var token = entry.getValue ();
if (org.jmol.script.Token.tokAttr (token.tok, attr) && (notattr == 0 || !org.jmol.script.Token.tokAttr (token.tok, notattr))) v.add (name);
}
var a = v.toArray ( new Array (v.size ()));
java.util.Arrays.sort (a);
return a;
}, "~S");
c$.getSettableTokFromString = Clazz.defineMethod (c$, "getSettableTokFromString", 
function (s) {
var tok = org.jmol.script.Token.getTokFromName (s);
return (tok != 0 && org.jmol.script.Token.tokAttr (tok, 2048) && !org.jmol.script.Token.tokAttr (tok, 1141899264) ? tok : 0);
}, "~S");
c$.completeCommand = Clazz.defineMethod (c$, "completeCommand", 
function (map, isSet, asCommand, str, n) {
if (map == null) map = org.jmol.script.Token.tokenMap;
 else asCommand = false;
var v =  new java.util.ArrayList ();
str = str.toLowerCase ();
for (var name, $name = map.keySet ().iterator (); $name.hasNext () && ((name = $name.next ()) || true);) {
if (!name.startsWith (str)) continue;
var tok = org.jmol.script.Token.getTokFromName (name);
if (asCommand ? org.jmol.script.Token.tokAttr (tok, 4096) : isSet ? org.jmol.script.Token.tokAttr (tok, 536870912) && !org.jmol.script.Token.tokAttr (tok, 1610612736) : true) v.add (name);
}
return org.jmol.util.ArrayUtil.sortedItem (v, n);
}, "java.util.Map,~B,~B,~S,~N");
c$.getParamType = Clazz.defineMethod (c$, "getParamType", 
function (tok) {
if (!org.jmol.script.Token.tokAttr (tok, 536870912)) return 0;
return tok & 662700032;
}, "~N");
Clazz.defineStatics (c$,
"nada", 0,
"integer", 2,
"decimal", 3,
"string", 4,
"seqcode", 5,
"hash", 6,
"varray", 7,
"point3f", 8,
"point4f", 9,
"bitset", 10,
"matrix3f", 11,
"matrix4f", 12,
"listf", 13,
"keyword", 14,
"astrType", ["nada", "identifier", "integer", "decimal", "string", "seqcode", "hash", "array", "point", "point4", "bitset", "matrix3f", "matrix4f", "listf", "keyword"],
"setparam", (536870912),
"misc", (1073741824),
"deprecatedparam", 1610612736,
"identifier", 1073741824,
"scriptCommand", (4096),
"atomExpressionCommand", 12288,
"implicitStringCommand", 20480,
"mathExpressionCommand", 36864,
"flowCommand", 102400,
"shapeCommand", 135168,
"noArgs", (262144),
"defaultON", (524288),
"expression", (1048576),
"predefinedset", 3145728,
"atomproperty", 1078984704,
"strproperty", 1087373312,
"intproperty", 1095761920,
"floatproperty", 1112539136,
"PROPERTYFLAGS", 1137704960,
"strparam", 545259520,
"intparam", 553648128,
"floatparam", 570425344,
"booleanparam", 603979776,
"paramTypes", (662700032),
"mathproperty", 1141899264,
"mathfunc", 135266304,
"mathop", 269484032,
"comparator", 269484288,
"center", 12289,
"define", 1060866,
"$delete", 12291,
"display", 1610625028,
"fixed", 1060869,
"hide", 12294,
"restrict", 12295,
"subset", 3158024,
"zap", 1060873,
"print", 36865,
"returncmd", 36866,
"set", 1085443,
"$var", 36868,
"log", 36869,
"echo", 537022465,
"help", 20482,
"hover", 544771,
"message", 20485,
"pause", 20487,
"elseif", 102402,
"elsecmd", 364547,
"endifcmd", 364548,
"whilecmd", 102406,
"breakcmd", 102407,
"continuecmd", 102408,
"end", 1150985,
"switchcmd", 102410,
"casecmd", 102411,
"catchcmd", 102412,
"defaultcmd", 102413,
"trycmd", 364558,
"animation", 4097,
"assign", 4098,
"background", 1610616835,
"bind", 4100,
"bondorder", 4101,
"calculate", 4102,
"cd", 1069064,
"centerAt", 4105,
"connect", 4106,
"console", 528395,
"delay", 528397,
"depth", 554176526,
"exit", 266255,
"exitjmol", 266256,
"font", 4114,
"frame", 4115,
"gotocmd", 20500,
"hbond", 1612189718,
"history", 1610616855,
"initialize", 266264,
"invertSelected", 4121,
"loop", 528410,
"mapProperty", 1052700,
"minimize", 4126,
"move", 4128,
"moveto", 4130,
"navigate", 4131,
"parallel", 102436,
"plot", 4133,
"pop", 266278,
"process", 102439,
"push", 266280,
"quit", 266281,
"ramachandran", 1052714,
"redomove", 4139,
"refresh", 266284,
"reset", 4141,
"restore", 4142,
"resume", 266287,
"rotate", 528432,
"rotateSelected", 4145,
"save", 4146,
"selectionhalos", 1611141171,
"show", 4148,
"slab", 554176565,
"spin", 1611141175,
"ssbond", 1611141176,
"step", 266298,
"stereo", 528443,
"sync", 4156,
"timeout", 536875070,
"translate", 4160,
"translateSelected", 4162,
"unbind", 4164,
"undomove", 4165,
"vibration", 4166,
"zoom", 4168,
"zoomTo", 4170,
"axes", 1611272194,
"dipole", 135174,
"draw", 135176,
"frank", 1611272202,
"isosurface", 135180,
"lcaocartoon", 135182,
"measurements", 537006096,
"mo", 1183762,
"pmesh", 135188,
"plot3d", 135190,
"polyhedra", 135192,
"struts", 1708058,
"unitcell", 1614417948,
"vector", 135198,
"wireframe", 659488,
"expressionBegin", 1048577,
"expressionEnd", 1048578,
"all", 1048579,
"branch", 1048580,
"coord", 1048582,
"dollarsign", 1048583,
"per", 1048584,
"isaromatic", 1048585,
"leftbrace", 1048586,
"none", 1048587,
"off", 1048588,
"on", 1048589,
"rightbrace", 1048590,
"semicolon", 1048591,
"spec_alternate", 1048607,
"spec_atom", 1048608,
"spec_chain", 1048609,
"spec_model", 1048610,
"spec_model2", 1048611,
"spec_name_pattern", 1048612,
"spec_resid", 1048613,
"spec_seqcode", 1048614,
"spec_seqcode_range", 1048615,
"amino", 3145730,
"dna", 3145732,
"hetero", 1613758470,
"helixalpha", 3145735,
"helix310", 3145736,
"helixpi", 3145738,
"hydrogen", 1613758476,
"nucleic", 3145742,
"protein", 3145744,
"purine", 3145746,
"pyrimidine", 3145748,
"rna", 3145750,
"solvent", 1613758488,
"sidechain", 3145754,
"surface", 3145756,
"thismodel", 3145758,
"sheet", 3145760,
"spine", 3145762,
"carbohydrate", 3145764,
"clickable", 3145766,
"displayed", 3145768,
"hidden", 3145770,
"specialposition", 3145772,
"visible", 3145774,
"basemodel", 3145776,
"leftparen", 269484048,
"rightparen", 269484049,
"opIf", 806354977,
"colon", 269484066,
"comma", 269484080,
"leftsquare", 269484096,
"rightsquare", 269484097,
"opOr", 269484112,
"opXor", 269484113,
"opToggle", 269484114,
"opAnd", 269484128,
"opNot", 269484144,
"opAND", 269484160,
"opGT", 269484432,
"opGE", 269484433,
"opLE", 269484434,
"opLT", 269484435,
"opEQ", 269484436,
"opNE", 269484438,
"minus", 269484192,
"plus", 269484193,
"divide", 269484208,
"times", 269484209,
"percent", 269484210,
"leftdivide", 269484211,
"unaryMinus", 269484224,
"minusMinus", 269484225,
"plusPlus", 269484226,
"timestimes", 269484227,
"propselector", 269484241,
"andequals", 269484242,
"minmaxmask", 480,
"min", 32,
"max", 64,
"average", 96,
"sum", 128,
"sum2", 160,
"stddev", 192,
"selectedfloat", 224,
"allfloat", 256,
"settable", 2048,
"atoms", 1141899265,
"bonds", 1678770178,
"length", 1141899267,
"lines", 1141899268,
"reverse", 1141899269,
"size", 1141899270,
"type", 1141899272,
"boundbox", 1679429641,
"xyz", 1146095626,
"fracxyz", 1146095627,
"screenxyz", 1146095628,
"fuxyz", 1146095629,
"unitxyz", 1146093582,
"vibxyz", 1146095631,
"w", 1141899280,
"keys", 1141899281,
"occupancy", 1129318401,
"radius", 1666189314,
"structure", 1641025539,
"atomtype", 1087375361,
"atomname", 1087375362,
"altloc", 1087373315,
"chain", 1087373316,
"element", 1087375365,
"group", 1087373318,
"group1", 1087373319,
"sequence", 1087373320,
"identify", 1087373321,
"insertion", 1087373322,
"shape", 1087373323,
"strucid", 1087373324,
"symbol", 1087375373,
"symmetry", 1089470478,
"atomno", 1095763969,
"atomid", 1095761922,
"atomindex", 1095761923,
"bondcount", 1095761924,
"cell", 1095761925,
"configuration", 1095766022,
"elemisono", 1095761927,
"elemno", 1095763976,
"formalcharge", 1632634889,
"groupid", 1095761930,
"groupindex", 1095761931,
"model", 1095766028,
"modelindex", 1095761933,
"molecule", 1095761934,
"polymer", 1095761935,
"polymerlength", 1095761936,
"resno", 1095761937,
"site", 1095761938,
"strucno", 1095761939,
"valence", 1095763988,
"adpmax", 1112539137,
"adpmin", 1112539138,
"covalent", 1112539139,
"eta", 1112539140,
"mass", 1112539141,
"omega", 1112539142,
"phi", 1112539143,
"psi", 1112539144,
"screenx", 1112539145,
"screeny", 1112539146,
"screenz", 1112539147,
"straightness", 1112539148,
"surfacedistance", 1112539149,
"theta", 1112539150,
"unitx", 1112539151,
"unity", 1112539152,
"unitz", 1112539153,
"atomx", 1112541185,
"atomy", 1112541186,
"atomz", 1112541187,
"fracx", 1112541188,
"fracy", 1112541189,
"fracz", 1112541190,
"fux", 1112541191,
"fuy", 1112541192,
"fuz", 1112541193,
"hydrophobic", 1114638346,
"ionic", 1112541195,
"partialcharge", 1112541196,
"property", 1716520973,
"selected", 1114638350,
"temperature", 1112541199,
"vanderwaals", 1649412112,
"vectorscale", 1649410065,
"vibx", 1112541202,
"viby", 1112541203,
"vibz", 1112541204,
"x", 1112541205,
"y", 1112541206,
"z", 1112541207,
"backbone", 1115297793,
"cartoon", 1113200642,
"dots", 1113198595,
"ellipsoid", 1113198596,
"geosurface", 1113198597,
"halo", 1113200646,
"meshRibbon", 1113200647,
"ribbon", 1113200649,
"rocket", 1113200650,
"spacefill", 1113200651,
"star", 1113200652,
"strands", 1650071565,
"trace", 1113200654,
"angle", 135266305,
"array", 135266306,
"axisangle", 135266307,
"color", 1766856708,
"compare", 135270405,
"connected", 135266310,
"data", 135270407,
"format", 1288701960,
"$function", 135368713,
"getproperty", 135270410,
"label", 1826248715,
"helix", 137363468,
"measure", 1746538509,
"now", 135266318,
"plane", 135266319,
"point", 135266320,
"quaternion", 135270417,
"sort", 1276117010,
"count", 1276117011,
"within", 135266324,
"write", 135270421,
"cache", 135270422,
"acos", 135266819,
"sin", 135266820,
"cos", 135266821,
"sqrt", 135266822,
"file", 1229984263,
"forcmd", 135369224,
"ifcmd", 135369225,
"abs", 135266826,
"javascript", 135287308,
"div", 1276117504,
"dot", 1276117505,
"join", 1276117506,
"mul", 1276117507,
"split", 1276117508,
"sub", 1276117509,
"trim", 1276117510,
"volume", 1313866247,
"col", 1276117512,
"row", 1276117513,
"cross", 135267329,
"load", 135271426,
"random", 135267332,
"script", 135271429,
"substructure", 1238369286,
"search", 135267335,
"smiles", 135267336,
"contact", 135402505,
"add", 1276118017,
"distance", 1276118018,
"find", 1276118532,
"replace", 1276118019,
"hkl", 135267841,
"intersection", 135267842,
"prompt", 135304707,
"select", 135280132,
"bin", 1276118529,
"symop", 1297090050,
"bondmode", 1610612737,
"fontsize", 1610612738,
"measurementnumbers", 1610612739,
"scale3d", 1610612740,
"togglelabel", 1610612741,
"backgroundmodel", 536870914,
"debug", 536870916,
"defaultlattice", 536870918,
"highlight", 536870920,
"showscript", 536870922,
"specular", 536870924,
"trajectory", 536870926,
"undo", 536870928,
"usercolorscheme", 536870930,
"appletproxy", 545259522,
"atomtypes", 545259524,
"axescolor", 545259526,
"axis1color", 545259528,
"axis2color", 545259530,
"axis3color", 545259532,
"backgroundcolor", 545259534,
"boundboxcolor", 545259536,
"currentlocalpath", 545259538,
"dataseparator", 545259540,
"defaultanglelabel", 545259542,
"defaultlabelpdb", 545259543,
"defaultlabelxyz", 545259544,
"defaultcolorscheme", 545259545,
"defaultdirectory", 545259546,
"defaultdistancelabel", 545259547,
"defaultdropscript", 545259548,
"defaultloadfilter", 545259549,
"defaultloadscript", 545259550,
"defaults", 545259552,
"defaulttorsionlabel", 545259554,
"defaultvdw", 545259555,
"edsurlcutoff", 545259556,
"edsurlformat", 545259557,
"energyunits", 545259558,
"filecachedirectory", 545259559,
"forcefield", 545259560,
"helppath", 545259561,
"hoverlabel", 545259562,
"language", 545259564,
"loadformat", 545259565,
"loadligandformat", 545259566,
"logfile", 545259567,
"measurementunits", 545259568,
"nmrurlformat", 545259569,
"pathforallfiles", 545259570,
"picking", 545259572,
"pickingstyle", 545259574,
"picklabel", 545259576,
"propertycolorscheme", 545259578,
"quaternionframe", 545259580,
"smilesurlformat", 545259582,
"smiles2dimageformat", 545259584,
"unitcellcolor", 545259586,
"axesscale", 570425346,
"bondtolerance", 570425348,
"cameradepth", 570425350,
"defaultdrawarrowscale", 570425352,
"defaulttranslucent", 570425354,
"dipolescale", 570425356,
"ellipsoidaxisdiameter", 570425358,
"gestureswipefactor", 570425359,
"hbondsangleminimum", 570425360,
"hbondsdistancemaximum", 570425361,
"hoverdelay", 570425362,
"loadatomdatatolerance", 570425363,
"minbonddistance", 570425364,
"minimizationcriterion", 570425365,
"mousedragfactor", 570425366,
"mousewheelfactor", 570425367,
"multiplebondradiusfactor", 570425368,
"multiplebondspacing", 570425369,
"navfps", 570425370,
"navigationdepth", 570425371,
"navigationslab", 570425372,
"navigationspeed", 570425374,
"navx", 570425376,
"navy", 570425378,
"navz", 570425380,
"pointgroupdistancetolerance", 570425382,
"pointgrouplineartolerance", 570425384,
"rotationradius", 570425388,
"scaleangstromsperinch", 570425390,
"sheetsmoothing", 570425392,
"slabrange", 570425393,
"solventproberadius", 570425394,
"spinfps", 570425396,
"spinx", 570425398,
"spiny", 570425400,
"spinz", 570425402,
"stereodegrees", 570425404,
"strutdefaultradius", 570425406,
"strutlengthmaximum", 570425408,
"vibrationperiod", 570425412,
"vibrationscale", 570425414,
"visualrange", 570425416,
"ambientpercent", 553648130,
"animationfps", 553648132,
"axesmode", 553648134,
"bondradiusmilliangstroms", 553648136,
"delaymaximumms", 553648138,
"diffusepercent", 553648142,
"dotdensity", 553648143,
"dotscale", 553648144,
"ellipsoiddotcount", 553648145,
"helixstep", 553648146,
"hermitelevel", 553648147,
"historylevel", 553648148,
"isosurfacepropertysmoothingpower", 553648149,
"loglevel", 553648150,
"meshscale", 553648151,
"minimizationsteps", 553648152,
"minpixelselradius", 553648153,
"percentvdwatom", 553648154,
"perspectivemodel", 553648155,
"phongexponent", 553648156,
"pickingspinrate", 553648158,
"propertyatomnumberfield", 553648159,
"propertyatomnumbercolumncount", 553648160,
"propertydatacolumncount", 553648162,
"propertydatafield", 553648164,
"repaintwaitms", 553648165,
"ribbonaspectratio", 553648166,
"scriptreportinglevel", 553648168,
"smallmoleculemaxatoms", 553648170,
"specularexponent", 553648172,
"specularpercent", 553648174,
"specularpower", 553648176,
"strandcount", 553648178,
"strandcountformeshribbon", 553648180,
"strandcountforstrands", 553648182,
"strutspacing", 553648184,
"zdepth", 553648186,
"zslab", 553648188,
"zshadepower", 553648190,
"allowembeddedscripts", 603979778,
"allowgestures", 603979780,
"allowkeystrokes", 603979781,
"allowmodelkit", 603979782,
"allowmoveatoms", 603979783,
"allowmultitouch", 603979784,
"allowrotateselected", 603979785,
"antialiasdisplay", 603979786,
"antialiasimages", 603979788,
"antialiastranslucent", 603979790,
"appendnew", 603979792,
"applysymmetrytobonds", 603979794,
"atompicking", 603979796,
"autobond", 603979798,
"autofps", 603979800,
"axesmolecular", 603979804,
"axesorientationrasmol", 603979806,
"axesunitcell", 603979808,
"axeswindow", 603979810,
"bondmodeor", 603979812,
"bondpicking", 603979814,
"cartoonbaseedges", 603979818,
"cartoonrockets", 603979819,
"cartoonfancy", 603979820,
"chaincasesensitive", 603979821,
"colorrasmol", 603979822,
"debugscript", 603979824,
"defaultstructuredssp", 603979825,
"disablepopupmenu", 603979826,
"displaycellparameters", 603979828,
"dotsselectedonly", 603979829,
"dotsurface", 603979830,
"dragselected", 603979831,
"drawhover", 603979832,
"drawpicking", 603979833,
"dsspcalchydrogen", 603979834,
"dynamicmeasurements", 603979835,
"ellipsoidarcs", 603979836,
"ellipsoidaxes", 603979837,
"ellipsoidball", 603979838,
"ellipsoiddots", 603979839,
"ellipsoidfill", 603979840,
"filecaching", 603979842,
"fontcaching", 603979844,
"fontscaling", 603979845,
"forceautobond", 603979846,
"fractionalrelative", 603979848,
"greyscalerendering", 603979850,
"hbondsbackbone", 603979852,
"hbondsrasmol", 603979853,
"hbondssolid", 603979854,
"hidenameinpopup", 603979858,
"hidenavigationpoint", 603979860,
"hidenotselected", 603979862,
"highresolution", 603979864,
"imagestate", 603979868,
"iskiosk", 603979869,
"isosurfacekey", 603979870,
"isosurfacepropertysmoothing", 603979871,
"justifymeasurements", 603979872,
"languagetranslation", 603979873,
"legacyautobonding", 603979874,
"logcommands", 603979875,
"loggestures", 603979876,
"measureallmodels", 603979877,
"measurementlabels", 603979878,
"messagestylechime", 603979879,
"minimizationrefresh", 603979880,
"minimizationsilent", 603979881,
"modelkitmode", 603979882,
"monitorenergy", 603979883,
"multiprocessor", 603979884,
"navigatesurface", 603979885,
"navigationmode", 603979886,
"navigationperiodic", 603979887,
"partialdots", 603979888,
"pdbaddhydrogens", 603979889,
"pdbgetheader", 603979890,
"pdbsequential", 603979891,
"perspectivedepth", 603979892,
"preservestate", 603979893,
"rangeselected", 603979894,
"refreshing", 603979896,
"ribbonborder", 603979898,
"rocketbarrels", 603979900,
"saveproteinstructurestate", 603979902,
"scriptqueue", 603979904,
"selectallmodels", 603979906,
"selecthetero", 603979908,
"selecthydrogen", 603979910,
"showaxes", 603979914,
"showboundbox", 603979916,
"showfrank", 603979918,
"showhiddenselectionhalos", 603979920,
"showhydrogens", 603979922,
"showkeystrokes", 603979924,
"showmeasurements", 603979926,
"showmultiplebonds", 603979928,
"shownavigationpointalways", 603979930,
"showtiming", 603979934,
"showunitcell", 603979936,
"slabbyatom", 603979938,
"slabbymolecule", 603979940,
"slabenabled", 603979942,
"smartaromatic", 603979944,
"solventprobe", 603979948,
"ssbondsbackbone", 603979952,
"statusreporting", 603979954,
"strutsmultiple", 603979955,
"syncmouse", 603979956,
"syncscript", 603979958,
"testflag1", 603979960,
"testflag2", 603979962,
"testflag3", 603979964,
"testflag4", 603979966,
"tracealpha", 603979967,
"usearcball", 603979969,
"useminimizationthread", 603979970,
"usenumberlocalization", 603979972,
"vectorsymmetry", 603979973,
"waitformoveto", 603979974,
"windowcentered", 603979975,
"wireframerotation", 603979976,
"zerobasedxyzrasmol", 603979978,
"zoomenabled", 603979980,
"zoomlarge", 603979982,
"zshade", 603979984,
"absolute", 1073741826,
"addhydrogens", 1073741828,
"adjust", 1073741830,
"align", 1073741832,
"allconnected", 1073741834,
"angstroms", 1073741836,
"anisotropy", 1073741838,
"append", 1073741839,
"arc", 1074790416,
"area", 1073741842,
"aromatic", 1076887572,
"arrow", 1073741846,
"as", 1073741848,
"atomicorbital", 1073741850,
"auto", 1073741852,
"axis", 1073741854,
"babel", 1073741856,
"babel21", 1073741858,
"back", 1073741860,
"barb", 1073741861,
"backlit", 1073741862,
"basepair", 1073741864,
"binary", 1073741866,
"blockdata", 1073741868,
"bondset", 1073741870,
"bottom", 1073741871,
"brillouin", 1073741872,
"cancel", 1073741874,
"cap", 1074790451,
"cavity", 1073741876,
"centroid", 1073741877,
"check", 1073741878,
"chemical", 1073741879,
"circle", 1073741880,
"clash", 1073741881,
"clear", 1073741882,
"clipboard", 1073741884,
"collapsed", 1073741886,
"colorscheme", 1073741888,
"command", 1073741890,
"commands", 1073741892,
"constraint", 1073741894,
"contour", 1073741896,
"contourlines", 1073741898,
"contours", 1073741900,
"corners", 1073741902,
"create", 1073741904,
"criterion", 1073741905,
"crossed", 1073741906,
"curve", 1073741908,
"cutoff", 1073741910,
"cylinder", 1073741912,
"density", 1073741914,
"dssp", 1073741915,
"diameter", 1073741916,
"direction", 1073741918,
"discrete", 1073741920,
"displacement", 1073741922,
"distancefactor", 1073741924,
"dotted", 1073741926,
"downsample", 1073741928,
"drawing", 1073741929,
"eccentricity", 1073741930,
"ed", 1074790508,
"edges", 1073741934,
"energy", 1073741935,
"error", 1073741936,
"facecenteroffset", 1073741937,
"fill", 1073741938,
"filter", 1073741940,
"first", 1073741942,
"fixedtemp", 1073741946,
"flat", 1073741948,
"fps", 1074790526,
"from", 1073741952,
"front", 1073741954,
"frontedges", 1073741956,
"frontlit", 1073741958,
"frontonly", 1073741960,
"full", 1073741961,
"fullplane", 1073741962,
"fullylit", 1073741964,
"functionxy", 1073741966,
"functionxyz", 1073741968,
"gridpoints", 1073741970,
"homo", 1073741973,
"id", 1074790550,
"ignore", 1073741976,
"inchi", 1073741977,
"inchikey", 1073741978,
"image", 1073741979,
"$in", 1073741980,
"increment", 1073741981,
"info", 1073741982,
"inline", 1073741983,
"insideout", 1073741984,
"interior", 1073741986,
"internal", 1073741988,
"intramolecular", 1073741989,
"intermolecular", 1073741990,
"jmol", 1073741992,
"last", 1073741993,
"lattice", 1073741994,
"lighting", 1073741995,
"left", 1073741996,
"line", 1073741998,
"link", 1073741999,
"linedata", 1073742000,
"list", 1073742001,
"lobe", 1073742002,
"lonepair", 1073742004,
"lp", 1073742006,
"lumo", 1073742008,
"manifest", 1073742010,
"maxset", 1073742014,
"menu", 1073742015,
"mep", 1073742016,
"mesh", 1073742018,
"middle", 1073742019,
"minset", 1073742020,
"mlp", 1073742022,
"mode", 1073742024,
"modify", 1073742025,
"modifyorcreate", 1073742026,
"modelbased", 1073742028,
"molecular", 1073742030,
"monomer", 1073742032,
"mrc", 1073742033,
"msms", 1073742034,
"name", 1073742035,
"nci", 1073742036,
"next", 1073742037,
"nmr", 1073742038,
"nocontourlines", 1073742039,
"nocross", 1073742040,
"nodebug", 1073742041,
"nodots", 1073742042,
"noedges", 1073742044,
"nofill", 1073742046,
"nohead", 1073742048,
"noload", 1073742050,
"nomesh", 1073742052,
"noplane", 1073742054,
"normal", 1073742056,
"notfrontonly", 1073742058,
"notriangles", 1073742060,
"obj", 1073742062,
"object", 1073742064,
"offset", 1073742066,
"offsetside", 1073742068,
"once", 1073742070,
"only", 1073742072,
"opaque", 1073742074,
"orbital", 1073742076,
"orientation", 1073742077,
"origin", 1073742078,
"out", 1073742079,
"packed", 1073742080,
"palindrome", 1073742082,
"parameters", 1073742083,
"path", 1073742084,
"pdb", 1074790662,
"pdbheader", 1073742088,
"period", 1073742090,
"perpendicular", 1073742092,
"phase", 1073742094,
"play", 1073742096,
"playrev", 1073742098,
"pocket", 1073742100,
"pointgroup", 1073742102,
"pointsperangstrom", 1073742104,
"polygon", 1073742106,
"prev", 1073742108,
"probe", 1073742109,
"rad", 1073742110,
"radical", 1073742112,
"range", 1073742114,
"rasmol", 1073742116,
"reference", 1073742118,
"remove", 1073742119,
"residue", 1073742120,
"resolution", 1073742122,
"reversecolor", 1073742124,
"rewind", 1073742126,
"right", 1073742128,
"rotate45", 1073742130,
"rotation", 1073742132,
"rubberband", 1073742134,
"sasurface", 1073742136,
"scale", 1073742138,
"scene", 1073742139,
"selection", 1073742140,
"shapely", 1073742144,
"sigma", 1073742146,
"sign", 1073742147,
"silent", 1073742148,
"solid", 1073742150,
"spacegroup", 1073742152,
"sphere", 1073742154,
"squared", 1073742156,
"state", 1073742158,
"stop", 1073742162,
"supercell", 1073742163,
"ticks", 1073742164,
"title", 1073742166,
"titleformat", 1073742168,
"to", 1074790746,
"top", 1074790748,
"torsion", 1073742174,
"transform", 1073742176,
"translation", 1073742178,
"translucent", 1073742180,
"triangles", 1073742182,
"url", 1074790760,
"user", 1073742186,
"val", 1073742188,
"variable", 1073742190,
"variables", 1073742192,
"vertices", 1073742194,
"spacebeforesquare", 1073742195,
"width", 1073742196);
c$.tokenSpaceBeforeSquare = c$.prototype.tokenSpaceBeforeSquare = org.jmol.script.Token.newTokenObj (1073742195, " ");
c$.tokenOn = c$.prototype.tokenOn = org.jmol.script.Token.newTokenIntVal (1048589, 1, "on");
c$.tokenOff = c$.prototype.tokenOff = org.jmol.script.Token.newTokenIntVal (1048588, 0, "off");
c$.tokenAll = c$.prototype.tokenAll = org.jmol.script.Token.newTokenObj (1048579, "all");
c$.tokenIf = c$.prototype.tokenIf = org.jmol.script.Token.newTokenObj (135369225, "if");
c$.tokenAnd = c$.prototype.tokenAnd = org.jmol.script.Token.newTokenObj (269484128, "and");
c$.tokenAND = c$.prototype.tokenAND = org.jmol.script.Token.newTokenObj (269484160, "");
c$.tokenOr = c$.prototype.tokenOr = org.jmol.script.Token.newTokenObj (269484112, "or");
c$.tokenAndFALSE = c$.prototype.tokenAndFALSE = org.jmol.script.Token.newTokenObj (269484128, "and");
c$.tokenOrTRUE = c$.prototype.tokenOrTRUE = org.jmol.script.Token.newTokenObj (269484112, "or");
c$.tokenOpIf = c$.prototype.tokenOpIf = org.jmol.script.Token.newTokenObj (806354977, "?");
c$.tokenComma = c$.prototype.tokenComma = org.jmol.script.Token.newTokenObj (269484080, ",");
c$.tokenDefineString = c$.prototype.tokenDefineString = org.jmol.script.Token.newTokenIntVal (1060866, 4, "@");
c$.tokenPlus = c$.prototype.tokenPlus = org.jmol.script.Token.newTokenObj (269484193, "+");
c$.tokenMinus = c$.prototype.tokenMinus = org.jmol.script.Token.newTokenObj (269484192, "-");
c$.tokenTimes = c$.prototype.tokenTimes = org.jmol.script.Token.newTokenObj (269484209, "*");
c$.tokenDivide = c$.prototype.tokenDivide = org.jmol.script.Token.newTokenObj (269484208, "/");
c$.tokenLeftParen = c$.prototype.tokenLeftParen = org.jmol.script.Token.newTokenObj (269484048, "(");
c$.tokenRightParen = c$.prototype.tokenRightParen = org.jmol.script.Token.newTokenObj (269484049, ")");
c$.tokenArraySquare = c$.prototype.tokenArraySquare = org.jmol.script.Token.newTokenObj (135266306, "[");
c$.tokenArraySelector = c$.prototype.tokenArraySelector = org.jmol.script.Token.newTokenObj (269484096, "[");
c$.tokenExpressionBegin = c$.prototype.tokenExpressionBegin = org.jmol.script.Token.newTokenObj (1048577, "expressionBegin");
c$.tokenExpressionEnd = c$.prototype.tokenExpressionEnd = org.jmol.script.Token.newTokenObj (1048578, "expressionEnd");
c$.tokenConnected = c$.prototype.tokenConnected = org.jmol.script.Token.newTokenObj (135266310, "connected");
c$.tokenCoordinateBegin = c$.prototype.tokenCoordinateBegin = org.jmol.script.Token.newTokenObj (1048586, "{");
c$.tokenRightBrace = c$.prototype.tokenRightBrace = org.jmol.script.Token.newTokenObj (1048590, "}");
c$.tokenCoordinateEnd = c$.prototype.tokenCoordinateEnd = org.jmol.script.Token.tokenRightBrace;
c$.tokenColon = c$.prototype.tokenColon = org.jmol.script.Token.newTokenObj (269484066, ":");
c$.tokenSetCmd = c$.prototype.tokenSetCmd = org.jmol.script.Token.newTokenObj (1085443, "set");
c$.tokenSet = c$.prototype.tokenSet = org.jmol.script.Token.newTokenIntVal (1085443, 61, "");
c$.tokenSetArray = c$.prototype.tokenSetArray = org.jmol.script.Token.newTokenIntVal (1085443, 91, "");
c$.tokenSetProperty = c$.prototype.tokenSetProperty = org.jmol.script.Token.newTokenIntVal (1085443, 46, "");
c$.tokenSetVar = c$.prototype.tokenSetVar = org.jmol.script.Token.newTokenIntVal (1085443, 61, "var");
c$.tokenEquals = c$.prototype.tokenEquals = org.jmol.script.Token.newTokenObj (269484436, "=");
c$.tokenScript = c$.prototype.tokenScript = org.jmol.script.Token.newTokenObj (135271429, "script");
c$.tokenSwitch = c$.prototype.tokenSwitch = org.jmol.script.Token.newTokenObj (102410, "switch");
c$.tokenMap = c$.prototype.tokenMap =  new java.util.Hashtable ();
{
var arrayPairs = ["(", org.jmol.script.Token.tokenLeftParen, ")", org.jmol.script.Token.tokenRightParen, "and", org.jmol.script.Token.tokenAnd, "&", null, "&&", null, "or", org.jmol.script.Token.tokenOr, "|", null, "||", null, "?", org.jmol.script.Token.tokenOpIf, ",", org.jmol.script.Token.tokenComma, "+=",  new org.jmol.script.Token (269484242), "-=", null, "*=", null, "/=", null, "\\=", null, "&=", null, "|=", null, "not",  new org.jmol.script.Token (269484144), "!", null, "xor",  new org.jmol.script.Token (269484113), "tog",  new org.jmol.script.Token (269484114), "<",  new org.jmol.script.Token (269484435), "<=",  new org.jmol.script.Token (269484434), ">=",  new org.jmol.script.Token (269484433), ">",  new org.jmol.script.Token (269484432), "=", org.jmol.script.Token.tokenEquals, "==", null, "!=",  new org.jmol.script.Token (269484438), "<>", null, "within",  new org.jmol.script.Token (135266324), ".",  new org.jmol.script.Token (1048584), "[",  new org.jmol.script.Token (269484096), "]",  new org.jmol.script.Token (269484097), "{",  new org.jmol.script.Token (1048586), "}",  new org.jmol.script.Token (1048590), "$",  new org.jmol.script.Token (1048583), "%",  new org.jmol.script.Token (269484210), ":", org.jmol.script.Token.tokenColon, ";",  new org.jmol.script.Token (1048591), "++",  new org.jmol.script.Token (269484226), "--",  new org.jmol.script.Token (269484225), "**",  new org.jmol.script.Token (269484227), "+", org.jmol.script.Token.tokenPlus, "-", org.jmol.script.Token.tokenMinus, "*", org.jmol.script.Token.tokenTimes, "/", org.jmol.script.Token.tokenDivide, "\\",  new org.jmol.script.Token (269484211), "animation",  new org.jmol.script.Token (4097), "anim", null, "assign",  new org.jmol.script.Token (4098), "axes",  new org.jmol.script.Token (1611272194), "backbone",  new org.jmol.script.Token (1115297793), "background",  new org.jmol.script.Token (1610616835), "bind",  new org.jmol.script.Token (4100), "bondorder",  new org.jmol.script.Token (4101), "boundbox",  new org.jmol.script.Token (1679429641), "boundingBox", null, "break",  new org.jmol.script.Token (102407), "calculate",  new org.jmol.script.Token (4102), "cartoon",  new org.jmol.script.Token (1113200642), "cartoons", null, "case",  new org.jmol.script.Token (102411), "catch",  new org.jmol.script.Token (102412), "cd",  new org.jmol.script.Token (1069064), "center",  new org.jmol.script.Token (12289), "centre", null, "centerat",  new org.jmol.script.Token (4105), "color",  new org.jmol.script.Token (1766856708), "colour", null, "compare",  new org.jmol.script.Token (135270405), "configuration",  new org.jmol.script.Token (1095766022), "conformation", null, "config", null, "connect",  new org.jmol.script.Token (4106), "console",  new org.jmol.script.Token (528395), "contact",  new org.jmol.script.Token (135402505), "contacts", null, "continue",  new org.jmol.script.Token (102408), "data",  new org.jmol.script.Token (135270407), "default",  new org.jmol.script.Token (102413), "define",  new org.jmol.script.Token (1060866), "@", null, "delay",  new org.jmol.script.Token (528397), "delete",  new org.jmol.script.Token (12291), "density",  new org.jmol.script.Token (1073741914), "depth",  new org.jmol.script.Token (554176526), "dipole",  new org.jmol.script.Token (135174), "dipoles", null, "display",  new org.jmol.script.Token (1610625028), "dot",  new org.jmol.script.Token (1276117505), "dots",  new org.jmol.script.Token (1113198595), "draw",  new org.jmol.script.Token (135176), "echo",  new org.jmol.script.Token (537022465), "ellipsoid",  new org.jmol.script.Token (1113198596), "ellipsoids", null, "else",  new org.jmol.script.Token (364547), "elseif",  new org.jmol.script.Token (102402), "end",  new org.jmol.script.Token (1150985), "endif",  new org.jmol.script.Token (364548), "exit",  new org.jmol.script.Token (266255), "file",  new org.jmol.script.Token (1229984263), "files", null, "font",  new org.jmol.script.Token (4114), "for",  new org.jmol.script.Token (135369224), "format",  new org.jmol.script.Token (1288701960), "frame",  new org.jmol.script.Token (4115), "frames", null, "frank",  new org.jmol.script.Token (1611272202), "function",  new org.jmol.script.Token (135368713), "functions", null, "geosurface",  new org.jmol.script.Token (1113198597), "getProperty",  new org.jmol.script.Token (135270410), "goto",  new org.jmol.script.Token (20500), "halo",  new org.jmol.script.Token (1113200646), "halos", null, "helix",  new org.jmol.script.Token (137363468), "helixalpha",  new org.jmol.script.Token (3145735), "helix310",  new org.jmol.script.Token (3145736), "helixpi",  new org.jmol.script.Token (3145738), "hbond",  new org.jmol.script.Token (1612189718), "hbonds", null, "help",  new org.jmol.script.Token (20482), "hide",  new org.jmol.script.Token (12294), "history",  new org.jmol.script.Token (1610616855), "hover",  new org.jmol.script.Token (544771), "if",  new org.jmol.script.Token (135369225), "in",  new org.jmol.script.Token (1073741980), "initialize",  new org.jmol.script.Token (266264), "invertSelected",  new org.jmol.script.Token (4121), "isosurface",  new org.jmol.script.Token (135180), "javascript",  new org.jmol.script.Token (135287308), "label",  new org.jmol.script.Token (1826248715), "labels", null, "lcaoCartoon",  new org.jmol.script.Token (135182), "lcaoCartoons", null, "load",  new org.jmol.script.Token (135271426), "log",  new org.jmol.script.Token (36869), "loop",  new org.jmol.script.Token (528410), "measure",  new org.jmol.script.Token (1746538509), "measures", null, "monitor", null, "monitors", null, "meshribbon",  new org.jmol.script.Token (1113200647), "meshribbons", null, "message",  new org.jmol.script.Token (20485), "minimize",  new org.jmol.script.Token (4126), "minimization", null, "mo",  new org.jmol.script.Token (1183762), "model",  new org.jmol.script.Token (1095766028), "models", null, "move",  new org.jmol.script.Token (4128), "moveTo",  new org.jmol.script.Token (4130), "navigate",  new org.jmol.script.Token (4131), "navigation", null, "origin",  new org.jmol.script.Token (1073742078), "out",  new org.jmol.script.Token (1073742079), "parallel",  new org.jmol.script.Token (102436), "pause",  new org.jmol.script.Token (20487), "wait", null, "plot",  new org.jmol.script.Token (4133), "plot3d",  new org.jmol.script.Token (135190), "pmesh",  new org.jmol.script.Token (135188), "polygon",  new org.jmol.script.Token (1073742106), "polyhedra",  new org.jmol.script.Token (135192), "print",  new org.jmol.script.Token (36865), "process",  new org.jmol.script.Token (102439), "prompt",  new org.jmol.script.Token (135304707), "quaternion",  new org.jmol.script.Token (135270417), "quaternions", null, "quit",  new org.jmol.script.Token (266281), "ramachandran",  new org.jmol.script.Token (1052714), "rama", null, "refresh",  new org.jmol.script.Token (266284), "reset",  new org.jmol.script.Token (4141), "unset", null, "restore",  new org.jmol.script.Token (4142), "restrict",  new org.jmol.script.Token (12295), "return",  new org.jmol.script.Token (36866), "ribbon",  new org.jmol.script.Token (1113200649), "ribbons", null, "rocket",  new org.jmol.script.Token (1113200650), "rockets", null, "rotate",  new org.jmol.script.Token (528432), "rotateSelected",  new org.jmol.script.Token (4145), "save",  new org.jmol.script.Token (4146), "script", org.jmol.script.Token.tokenScript, "source", null, "select",  new org.jmol.script.Token (135280132), "selectionHalos",  new org.jmol.script.Token (1611141171), "selectionHalo", null, "showSelections", null, "set", org.jmol.script.Token.tokenSetCmd, "sheet",  new org.jmol.script.Token (3145760), "show",  new org.jmol.script.Token (4148), "slab",  new org.jmol.script.Token (554176565), "spacefill",  new org.jmol.script.Token (1113200651), "cpk", null, "spin",  new org.jmol.script.Token (1611141175), "ssbond",  new org.jmol.script.Token (1611141176), "ssbonds", null, "star",  new org.jmol.script.Token (1113200652), "stars", null, "step",  new org.jmol.script.Token (266298), "steps", null, "stereo",  new org.jmol.script.Token (528443), "strand",  new org.jmol.script.Token (1650071565), "strands", null, "structure",  new org.jmol.script.Token (1641025539), "_structure", null, "strucNo",  new org.jmol.script.Token (1095761939), "struts",  new org.jmol.script.Token (1708058), "strut", null, "subset",  new org.jmol.script.Token (3158024), "switch", org.jmol.script.Token.tokenSwitch, "synchronize",  new org.jmol.script.Token (4156), "sync", null, "trace",  new org.jmol.script.Token (1113200654), "translate",  new org.jmol.script.Token (4160), "translateSelected",  new org.jmol.script.Token (4162), "try",  new org.jmol.script.Token (364558), "unbind",  new org.jmol.script.Token (4164), "unitcell",  new org.jmol.script.Token (1614417948), "var",  new org.jmol.script.Token (36868), "vector",  new org.jmol.script.Token (135198), "vectors", null, "vibration",  new org.jmol.script.Token (4166), "while",  new org.jmol.script.Token (102406), "wireframe",  new org.jmol.script.Token (659488), "write",  new org.jmol.script.Token (135270421), "zap",  new org.jmol.script.Token (1060873), "zoom",  new org.jmol.script.Token (4168), "zoomTo",  new org.jmol.script.Token (4170), "atom",  new org.jmol.script.Token (1141899265), "atoms", null, "axis",  new org.jmol.script.Token (1073741854), "axisangle",  new org.jmol.script.Token (135266307), "basepair",  new org.jmol.script.Token (1073741864), "basepairs", null, "orientation",  new org.jmol.script.Token (1073742077), "orientations", null, "pdbheader",  new org.jmol.script.Token (1073742088), "polymer",  new org.jmol.script.Token (1095761935), "polymers", null, "residue",  new org.jmol.script.Token (1073742120), "residues", null, "rotation",  new org.jmol.script.Token (1073742132), "row",  new org.jmol.script.Token (1276117513), "sequence",  new org.jmol.script.Token (1087373320), "shape",  new org.jmol.script.Token (1087373323), "state",  new org.jmol.script.Token (1073742158), "symbol",  new org.jmol.script.Token (1087375373), "symmetry",  new org.jmol.script.Token (1089470478), "spaceGroup",  new org.jmol.script.Token (1073742152), "transform",  new org.jmol.script.Token (1073742176), "translation",  new org.jmol.script.Token (1073742178), "url",  new org.jmol.script.Token (1074790760), "abs",  new org.jmol.script.Token (135266826), "absolute",  new org.jmol.script.Token (1073741826), "acos",  new org.jmol.script.Token (135266819), "add",  new org.jmol.script.Token (1276118017), "adpmax",  new org.jmol.script.Token (1112539137), "adpmin",  new org.jmol.script.Token (1112539138), "align",  new org.jmol.script.Token (1073741832), "all", org.jmol.script.Token.tokenAll, "altloc",  new org.jmol.script.Token (1087373315), "altlocs", null, "amino",  new org.jmol.script.Token (3145730), "angle",  new org.jmol.script.Token (135266305), "array",  new org.jmol.script.Token (135266306), "as",  new org.jmol.script.Token (1073741848), "atomID",  new org.jmol.script.Token (1095761922), "_atomID", null, "_a", null, "atomIndex",  new org.jmol.script.Token (1095761923), "atomName",  new org.jmol.script.Token (1087375362), "atomno",  new org.jmol.script.Token (1095763969), "atomType",  new org.jmol.script.Token (1087375361), "atomX",  new org.jmol.script.Token (1112541185), "atomY",  new org.jmol.script.Token (1112541186), "atomZ",  new org.jmol.script.Token (1112541187), "average",  new org.jmol.script.Token (96), "babel",  new org.jmol.script.Token (1073741856), "babel21",  new org.jmol.script.Token (1073741858), "back",  new org.jmol.script.Token (1073741860), "backlit",  new org.jmol.script.Token (1073741862), "baseModel",  new org.jmol.script.Token (3145776), "bin",  new org.jmol.script.Token (1276118529), "bondCount",  new org.jmol.script.Token (1095761924), "bottom",  new org.jmol.script.Token (1073741871), "branch",  new org.jmol.script.Token (1048580), "brillouin",  new org.jmol.script.Token (1073741872), "bzone", null, "wignerSeitz", null, "cache",  new org.jmol.script.Token (135270422), "carbohydrate",  new org.jmol.script.Token (3145764), "cell",  new org.jmol.script.Token (1095761925), "chain",  new org.jmol.script.Token (1087373316), "chains", null, "clash",  new org.jmol.script.Token (1073741881), "clear",  new org.jmol.script.Token (1073741882), "clickable",  new org.jmol.script.Token (3145766), "clipboard",  new org.jmol.script.Token (1073741884), "connected",  new org.jmol.script.Token (135266310), "constraint",  new org.jmol.script.Token (1073741894), "contourLines",  new org.jmol.script.Token (1073741898), "coord",  new org.jmol.script.Token (1048582), "coordinates", null, "coords", null, "cos",  new org.jmol.script.Token (135266821), "cross",  new org.jmol.script.Token (135267329), "covalent",  new org.jmol.script.Token (1112539139), "direction",  new org.jmol.script.Token (1073741918), "displacement",  new org.jmol.script.Token (1073741922), "displayed",  new org.jmol.script.Token (3145768), "distance",  new org.jmol.script.Token (1276118018), "div",  new org.jmol.script.Token (1276117504), "DNA",  new org.jmol.script.Token (3145732), "dotted",  new org.jmol.script.Token (1073741926), "DSSP",  new org.jmol.script.Token (1073741915), "element",  new org.jmol.script.Token (1087375365), "elemno",  new org.jmol.script.Token (1095763976), "_e",  new org.jmol.script.Token (1095761927), "error",  new org.jmol.script.Token (1073741936), "fill",  new org.jmol.script.Token (1073741938), "find",  new org.jmol.script.Token (1276118532), "fixedTemperature",  new org.jmol.script.Token (1073741946), "forcefield",  new org.jmol.script.Token (545259560), "formalCharge",  new org.jmol.script.Token (1632634889), "charge", null, "eta",  new org.jmol.script.Token (1112539140), "front",  new org.jmol.script.Token (1073741954), "frontlit",  new org.jmol.script.Token (1073741958), "frontOnly",  new org.jmol.script.Token (1073741960), "fullylit",  new org.jmol.script.Token (1073741964), "fx",  new org.jmol.script.Token (1112541188), "fy",  new org.jmol.script.Token (1112541189), "fz",  new org.jmol.script.Token (1112541190), "fxyz",  new org.jmol.script.Token (1146095627), "fux",  new org.jmol.script.Token (1112541191), "fuy",  new org.jmol.script.Token (1112541192), "fuz",  new org.jmol.script.Token (1112541193), "fuxyz",  new org.jmol.script.Token (1146095629), "group",  new org.jmol.script.Token (1087373318), "groups", null, "group1",  new org.jmol.script.Token (1087373319), "groupID",  new org.jmol.script.Token (1095761930), "_groupID", null, "_g", null, "groupIndex",  new org.jmol.script.Token (1095761931), "hidden",  new org.jmol.script.Token (3145770), "highlight",  new org.jmol.script.Token (536870920), "hkl",  new org.jmol.script.Token (135267841), "hydrophobic",  new org.jmol.script.Token (1114638346), "hydrophobicity", null, "hydro", null, "id",  new org.jmol.script.Token (1074790550), "identify",  new org.jmol.script.Token (1087373321), "ident", null, "image",  new org.jmol.script.Token (1073741979), "info",  new org.jmol.script.Token (1073741982), "inline",  new org.jmol.script.Token (1073741983), "insertion",  new org.jmol.script.Token (1087373322), "insertions", null, "intramolecular",  new org.jmol.script.Token (1073741989), "intra", null, "intermolecular",  new org.jmol.script.Token (1073741990), "inter", null, "ionic",  new org.jmol.script.Token (1112541195), "ionicRadius", null, "isAromatic",  new org.jmol.script.Token (1048585), "Jmol",  new org.jmol.script.Token (1073741992), "join",  new org.jmol.script.Token (1276117506), "keys",  new org.jmol.script.Token (1141899281), "last",  new org.jmol.script.Token (1073741993), "left",  new org.jmol.script.Token (1073741996), "length",  new org.jmol.script.Token (1141899267), "lines",  new org.jmol.script.Token (1141899268), "list",  new org.jmol.script.Token (1073742001), "mass",  new org.jmol.script.Token (1112539141), "max",  new org.jmol.script.Token (64), "mep",  new org.jmol.script.Token (1073742016), "mesh",  new org.jmol.script.Token (1073742018), "middle",  new org.jmol.script.Token (1073742019), "min",  new org.jmol.script.Token (32), "mlp",  new org.jmol.script.Token (1073742022), "mode",  new org.jmol.script.Token (1073742024), "modify",  new org.jmol.script.Token (1073742025), "modifyOrCreate",  new org.jmol.script.Token (1073742026), "molecule",  new org.jmol.script.Token (1095761934), "molecules", null, "modelIndex",  new org.jmol.script.Token (1095761933), "monomer",  new org.jmol.script.Token (1073742032), "mul",  new org.jmol.script.Token (1276117507), "nci",  new org.jmol.script.Token (1073742036), "next",  new org.jmol.script.Token (1073742037), "noDots",  new org.jmol.script.Token (1073742042), "noFill",  new org.jmol.script.Token (1073742046), "noMesh",  new org.jmol.script.Token (1073742052), "none",  new org.jmol.script.Token (1048587), "null", null, "inherit", null, "normal",  new org.jmol.script.Token (1073742056), "noContourLines",  new org.jmol.script.Token (1073742039), "notFrontOnly",  new org.jmol.script.Token (1073742058), "noTriangles",  new org.jmol.script.Token (1073742060), "now",  new org.jmol.script.Token (135266318), "nucleic",  new org.jmol.script.Token (3145742), "occupancy",  new org.jmol.script.Token (1129318401), "off", org.jmol.script.Token.tokenOff, "false", null, "on", org.jmol.script.Token.tokenOn, "true", null, "omega",  new org.jmol.script.Token (1112539142), "only",  new org.jmol.script.Token (1073742072), "opaque",  new org.jmol.script.Token (1073742074), "partialCharge",  new org.jmol.script.Token (1112541196), "phi",  new org.jmol.script.Token (1112539143), "plane",  new org.jmol.script.Token (135266319), "planar", null, "play",  new org.jmol.script.Token (1073742096), "playRev",  new org.jmol.script.Token (1073742098), "point",  new org.jmol.script.Token (135266320), "points", null, "pointGroup",  new org.jmol.script.Token (1073742102), "polymerLength",  new org.jmol.script.Token (1095761936), "previous",  new org.jmol.script.Token (1073742108), "prev", null, "probe",  new org.jmol.script.Token (1073742109), "property",  new org.jmol.script.Token (1716520973), "properties", null, "protein",  new org.jmol.script.Token (3145744), "psi",  new org.jmol.script.Token (1112539144), "purine",  new org.jmol.script.Token (3145746), "pyrimidine",  new org.jmol.script.Token (3145748), "random",  new org.jmol.script.Token (135267332), "range",  new org.jmol.script.Token (1073742114), "rasmol",  new org.jmol.script.Token (1073742116), "replace",  new org.jmol.script.Token (1276118019), "resno",  new org.jmol.script.Token (1095761937), "resume",  new org.jmol.script.Token (266287), "rewind",  new org.jmol.script.Token (1073742126), "reverse",  new org.jmol.script.Token (1141899269), "right",  new org.jmol.script.Token (1073742128), "RNA",  new org.jmol.script.Token (3145750), "rubberband",  new org.jmol.script.Token (1073742134), "saSurface",  new org.jmol.script.Token (1073742136), "scale",  new org.jmol.script.Token (1073742138), "scene",  new org.jmol.script.Token (1073742139), "search",  new org.jmol.script.Token (135267335), "smarts", null, "selected",  new org.jmol.script.Token (1114638350), "shapely",  new org.jmol.script.Token (1073742144), "sidechain",  new org.jmol.script.Token (3145754), "sin",  new org.jmol.script.Token (135266820), "site",  new org.jmol.script.Token (1095761938), "size",  new org.jmol.script.Token (1141899270), "smiles",  new org.jmol.script.Token (135267336), "substructure",  new org.jmol.script.Token (1238369286), "solid",  new org.jmol.script.Token (1073742150), "sort",  new org.jmol.script.Token (1276117010), "specialPosition",  new org.jmol.script.Token (3145772), "sqrt",  new org.jmol.script.Token (135266822), "split",  new org.jmol.script.Token (1276117508), "stddev",  new org.jmol.script.Token (192), "straightness",  new org.jmol.script.Token (1112539148), "structureId",  new org.jmol.script.Token (1087373324), "supercell",  new org.jmol.script.Token (1073742163), "sub",  new org.jmol.script.Token (1276117509), "sum",  new org.jmol.script.Token (128), "sum2",  new org.jmol.script.Token (160), "surface",  new org.jmol.script.Token (3145756), "surfaceDistance",  new org.jmol.script.Token (1112539149), "symop",  new org.jmol.script.Token (1297090050), "sx",  new org.jmol.script.Token (1112539145), "sy",  new org.jmol.script.Token (1112539146), "sz",  new org.jmol.script.Token (1112539147), "sxyz",  new org.jmol.script.Token (1146095628), "temperature",  new org.jmol.script.Token (1112541199), "relativeTemperature", null, "theta",  new org.jmol.script.Token (1112539150), "thisModel",  new org.jmol.script.Token (3145758), "ticks",  new org.jmol.script.Token (1073742164), "top",  new org.jmol.script.Token (1074790748), "torsion",  new org.jmol.script.Token (1073742174), "trajectory",  new org.jmol.script.Token (536870926), "trajectories", null, "translucent",  new org.jmol.script.Token (1073742180), "triangles",  new org.jmol.script.Token (1073742182), "trim",  new org.jmol.script.Token (1276117510), "type",  new org.jmol.script.Token (1141899272), "ux",  new org.jmol.script.Token (1112539151), "uy",  new org.jmol.script.Token (1112539152), "uz",  new org.jmol.script.Token (1112539153), "uxyz",  new org.jmol.script.Token (1146093582), "user",  new org.jmol.script.Token (1073742186), "valence",  new org.jmol.script.Token (1095763988), "vanderWaals",  new org.jmol.script.Token (1649412112), "vdw", null, "vdwRadius", null, "visible",  new org.jmol.script.Token (3145774), "volume",  new org.jmol.script.Token (1313866247), "vx",  new org.jmol.script.Token (1112541202), "vy",  new org.jmol.script.Token (1112541203), "vz",  new org.jmol.script.Token (1112541204), "vxyz",  new org.jmol.script.Token (1146095631), "xyz",  new org.jmol.script.Token (1146095626), "w",  new org.jmol.script.Token (1141899280), "x",  new org.jmol.script.Token (1112541205), "y",  new org.jmol.script.Token (1112541206), "z",  new org.jmol.script.Token (1112541207), "addHydrogens",  new org.jmol.script.Token (1073741828), "allConnected",  new org.jmol.script.Token (1073741834), "angstroms",  new org.jmol.script.Token (1073741836), "anisotropy",  new org.jmol.script.Token (1073741838), "append",  new org.jmol.script.Token (1073741839), "arc",  new org.jmol.script.Token (1074790416), "area",  new org.jmol.script.Token (1073741842), "aromatic",  new org.jmol.script.Token (1076887572), "arrow",  new org.jmol.script.Token (1073741846), "auto",  new org.jmol.script.Token (1073741852), "barb",  new org.jmol.script.Token (1073741861), "binary",  new org.jmol.script.Token (1073741866), "blockData",  new org.jmol.script.Token (1073741868), "cancel",  new org.jmol.script.Token (1073741874), "cap",  new org.jmol.script.Token (1074790451), "cavity",  new org.jmol.script.Token (1073741876), "centroid",  new org.jmol.script.Token (1073741877), "check",  new org.jmol.script.Token (1073741878), "chemical",  new org.jmol.script.Token (1073741879), "circle",  new org.jmol.script.Token (1073741880), "collapsed",  new org.jmol.script.Token (1073741886), "col",  new org.jmol.script.Token (1276117512), "colorScheme",  new org.jmol.script.Token (1073741888), "command",  new org.jmol.script.Token (1073741890), "commands",  new org.jmol.script.Token (1073741892), "contour",  new org.jmol.script.Token (1073741896), "contours",  new org.jmol.script.Token (1073741900), "corners",  new org.jmol.script.Token (1073741902), "count",  new org.jmol.script.Token (1276117011), "criterion",  new org.jmol.script.Token (1073741905), "create",  new org.jmol.script.Token (1073741904), "crossed",  new org.jmol.script.Token (1073741906), "curve",  new org.jmol.script.Token (1073741908), "cutoff",  new org.jmol.script.Token (1073741910), "cylinder",  new org.jmol.script.Token (1073741912), "diameter",  new org.jmol.script.Token (1073741916), "discrete",  new org.jmol.script.Token (1073741920), "distanceFactor",  new org.jmol.script.Token (1073741924), "downsample",  new org.jmol.script.Token (1073741928), "drawing",  new org.jmol.script.Token (1073741929), "eccentricity",  new org.jmol.script.Token (1073741930), "ed",  new org.jmol.script.Token (1074790508), "edges",  new org.jmol.script.Token (1073741934), "energy",  new org.jmol.script.Token (1073741935), "exitJmol",  new org.jmol.script.Token (266256), "faceCenterOffset",  new org.jmol.script.Token (1073741937), "filter",  new org.jmol.script.Token (1073741940), "first",  new org.jmol.script.Token (1073741942), "fixed",  new org.jmol.script.Token (1060869), "fix", null, "flat",  new org.jmol.script.Token (1073741948), "fps",  new org.jmol.script.Token (1074790526), "from",  new org.jmol.script.Token (1073741952), "frontEdges",  new org.jmol.script.Token (1073741956), "full",  new org.jmol.script.Token (1073741961), "fullPlane",  new org.jmol.script.Token (1073741962), "functionXY",  new org.jmol.script.Token (1073741966), "functionXYZ",  new org.jmol.script.Token (1073741968), "gridPoints",  new org.jmol.script.Token (1073741970), "homo",  new org.jmol.script.Token (1073741973), "ignore",  new org.jmol.script.Token (1073741976), "InChI",  new org.jmol.script.Token (1073741977), "InChIKey",  new org.jmol.script.Token (1073741978), "increment",  new org.jmol.script.Token (1073741981), "insideout",  new org.jmol.script.Token (1073741984), "interior",  new org.jmol.script.Token (1073741986), "intersection",  new org.jmol.script.Token (135267842), "intersect", null, "internal",  new org.jmol.script.Token (1073741988), "lattice",  new org.jmol.script.Token (1073741994), "line",  new org.jmol.script.Token (1073741998), "lineData",  new org.jmol.script.Token (1073742000), "link",  new org.jmol.script.Token (1073741999), "lobe",  new org.jmol.script.Token (1073742002), "lonePair",  new org.jmol.script.Token (1073742004), "lp",  new org.jmol.script.Token (1073742006), "lumo",  new org.jmol.script.Token (1073742008), "manifest",  new org.jmol.script.Token (1073742010), "mapProperty",  new org.jmol.script.Token (1052700), "map", null, "maxSet",  new org.jmol.script.Token (1073742014), "menu",  new org.jmol.script.Token (1073742015), "minSet",  new org.jmol.script.Token (1073742020), "modelBased",  new org.jmol.script.Token (1073742028), "molecular",  new org.jmol.script.Token (1073742030), "mrc",  new org.jmol.script.Token (1073742033), "msms",  new org.jmol.script.Token (1073742034), "name",  new org.jmol.script.Token (1073742035), "nmr",  new org.jmol.script.Token (1073742038), "noCross",  new org.jmol.script.Token (1073742040), "noDebug",  new org.jmol.script.Token (1073742041), "noEdges",  new org.jmol.script.Token (1073742044), "noHead",  new org.jmol.script.Token (1073742048), "noLoad",  new org.jmol.script.Token (1073742050), "noPlane",  new org.jmol.script.Token (1073742054), "object",  new org.jmol.script.Token (1073742064), "obj",  new org.jmol.script.Token (1073742062), "offset",  new org.jmol.script.Token (1073742066), "offsetSide",  new org.jmol.script.Token (1073742068), "once",  new org.jmol.script.Token (1073742070), "orbital",  new org.jmol.script.Token (1073742076), "atomicOrbital",  new org.jmol.script.Token (1073741850), "packed",  new org.jmol.script.Token (1073742080), "palindrome",  new org.jmol.script.Token (1073742082), "parameters",  new org.jmol.script.Token (1073742083), "path",  new org.jmol.script.Token (1073742084), "pdb",  new org.jmol.script.Token (1074790662), "period",  new org.jmol.script.Token (1073742090), "periodic", null, "perpendicular",  new org.jmol.script.Token (1073742092), "perp", null, "phase",  new org.jmol.script.Token (1073742094), "pocket",  new org.jmol.script.Token (1073742100), "pointsPerAngstrom",  new org.jmol.script.Token (1073742104), "radical",  new org.jmol.script.Token (1073742112), "rad",  new org.jmol.script.Token (1073742110), "reference",  new org.jmol.script.Token (1073742118), "remove",  new org.jmol.script.Token (1073742119), "resolution",  new org.jmol.script.Token (1073742122), "reverseColor",  new org.jmol.script.Token (1073742124), "rotate45",  new org.jmol.script.Token (1073742130), "selection",  new org.jmol.script.Token (1073742140), "sigma",  new org.jmol.script.Token (1073742146), "sign",  new org.jmol.script.Token (1073742147), "silent",  new org.jmol.script.Token (1073742148), "sphere",  new org.jmol.script.Token (1073742154), "squared",  new org.jmol.script.Token (1073742156), "stop",  new org.jmol.script.Token (1073742162), "title",  new org.jmol.script.Token (1073742166), "titleFormat",  new org.jmol.script.Token (1073742168), "to",  new org.jmol.script.Token (1074790746), "value",  new org.jmol.script.Token (1073742188), "variable",  new org.jmol.script.Token (1073742190), "variables",  new org.jmol.script.Token (1073742192), "vertices",  new org.jmol.script.Token (1073742194), "width",  new org.jmol.script.Token (1073742196), "backgroundModel",  new org.jmol.script.Token (536870914), "debug",  new org.jmol.script.Token (536870916), "defaultLattice",  new org.jmol.script.Token (536870918), "measurements",  new org.jmol.script.Token (537006096), "measurement", null, "scale3D",  new org.jmol.script.Token (1610612740), "toggleLabel",  new org.jmol.script.Token (1610612741), "userColorScheme",  new org.jmol.script.Token (536870930), "timeout",  new org.jmol.script.Token (536875070), "timeouts", null, "appletProxy",  new org.jmol.script.Token (545259522), "atomTypes",  new org.jmol.script.Token (545259524), "axesColor",  new org.jmol.script.Token (545259526), "axis1Color",  new org.jmol.script.Token (545259528), "axis2Color",  new org.jmol.script.Token (545259530), "axis3Color",  new org.jmol.script.Token (545259532), "backgroundColor",  new org.jmol.script.Token (545259534), "bondmode",  new org.jmol.script.Token (1610612737), "boundBoxColor",  new org.jmol.script.Token (545259536), "boundingBoxColor", null, "currentLocalPath",  new org.jmol.script.Token (545259538), "dataSeparator",  new org.jmol.script.Token (545259540), "defaultAngleLabel",  new org.jmol.script.Token (545259542), "defaultColorScheme",  new org.jmol.script.Token (545259545), "defaultColors", null, "defaultDirectory",  new org.jmol.script.Token (545259546), "defaultDistanceLabel",  new org.jmol.script.Token (545259547), "defaultDropScript",  new org.jmol.script.Token (545259548), "defaultLabelPDB",  new org.jmol.script.Token (545259543), "defaultLabelXYZ",  new org.jmol.script.Token (545259544), "defaultLoadFilter",  new org.jmol.script.Token (545259549), "defaultLoadScript",  new org.jmol.script.Token (545259550), "defaults",  new org.jmol.script.Token (545259552), "defaultTorsionLabel",  new org.jmol.script.Token (545259554), "defaultVDW",  new org.jmol.script.Token (545259555), "edsUrlCutoff",  new org.jmol.script.Token (545259556), "edsUrlFormat",  new org.jmol.script.Token (545259557), "energyUnits",  new org.jmol.script.Token (545259558), "fileCacheDirectory",  new org.jmol.script.Token (545259559), "fontsize",  new org.jmol.script.Token (1610612738), "helpPath",  new org.jmol.script.Token (545259561), "hoverLabel",  new org.jmol.script.Token (545259562), "language",  new org.jmol.script.Token (545259564), "loadFormat",  new org.jmol.script.Token (545259565), "loadLigandFormat",  new org.jmol.script.Token (545259566), "logFile",  new org.jmol.script.Token (545259567), "measurementUnits",  new org.jmol.script.Token (545259568), "nmrUrlFormat",  new org.jmol.script.Token (545259569), "pathForAllFiles",  new org.jmol.script.Token (545259570), "picking",  new org.jmol.script.Token (545259572), "pickingStyle",  new org.jmol.script.Token (545259574), "pickLabel",  new org.jmol.script.Token (545259576), "propertyColorScheme",  new org.jmol.script.Token (545259578), "quaternionFrame",  new org.jmol.script.Token (545259580), "smilesUrlFormat",  new org.jmol.script.Token (545259582), "smiles2dImageFormat",  new org.jmol.script.Token (545259584), "unitCellColor",  new org.jmol.script.Token (545259586), "axesScale",  new org.jmol.script.Token (570425346), "axisScale", null, "bondTolerance",  new org.jmol.script.Token (570425348), "cameraDepth",  new org.jmol.script.Token (570425350), "defaultDrawArrowScale",  new org.jmol.script.Token (570425352), "defaultTranslucent",  new org.jmol.script.Token (570425354), "dipoleScale",  new org.jmol.script.Token (570425356), "ellipsoidAxisDiameter",  new org.jmol.script.Token (570425358), "gestureSwipeFactor",  new org.jmol.script.Token (570425359), "hbondsAngleMinimum",  new org.jmol.script.Token (570425360), "hbondsDistanceMaximum",  new org.jmol.script.Token (570425361), "hoverDelay",  new org.jmol.script.Token (570425362), "loadAtomDataTolerance",  new org.jmol.script.Token (570425363), "minBondDistance",  new org.jmol.script.Token (570425364), "minimizationCriterion",  new org.jmol.script.Token (570425365), "mouseDragFactor",  new org.jmol.script.Token (570425366), "mouseWheelFactor",  new org.jmol.script.Token (570425367), "navFPS",  new org.jmol.script.Token (570425370), "navigationDepth",  new org.jmol.script.Token (570425371), "navigationSlab",  new org.jmol.script.Token (570425372), "navigationSpeed",  new org.jmol.script.Token (570425374), "navX",  new org.jmol.script.Token (570425376), "navY",  new org.jmol.script.Token (570425378), "navZ",  new org.jmol.script.Token (570425380), "pointGroupDistanceTolerance",  new org.jmol.script.Token (570425382), "pointGroupLinearTolerance",  new org.jmol.script.Token (570425384), "radius",  new org.jmol.script.Token (1666189314), "rotationRadius",  new org.jmol.script.Token (570425388), "scaleAngstromsPerInch",  new org.jmol.script.Token (570425390), "sheetSmoothing",  new org.jmol.script.Token (570425392), "slabRange",  new org.jmol.script.Token (570425393), "solventProbeRadius",  new org.jmol.script.Token (570425394), "spinFPS",  new org.jmol.script.Token (570425396), "spinX",  new org.jmol.script.Token (570425398), "spinY",  new org.jmol.script.Token (570425400), "spinZ",  new org.jmol.script.Token (570425402), "stereoDegrees",  new org.jmol.script.Token (570425404), "strutDefaultRadius",  new org.jmol.script.Token (570425406), "strutLengthMaximum",  new org.jmol.script.Token (570425408), "vectorScale",  new org.jmol.script.Token (1649410065), "vectorSymmetry",  new org.jmol.script.Token (603979973), "vibrationPeriod",  new org.jmol.script.Token (570425412), "vibrationScale",  new org.jmol.script.Token (570425414), "visualRange",  new org.jmol.script.Token (570425416), "ambientPercent",  new org.jmol.script.Token (553648130), "ambient", null, "animationFps",  new org.jmol.script.Token (553648132), "axesMode",  new org.jmol.script.Token (553648134), "bondRadiusMilliAngstroms",  new org.jmol.script.Token (553648136), "delayMaximumMs",  new org.jmol.script.Token (553648138), "diffusePercent",  new org.jmol.script.Token (553648142), "diffuse", null, "dotDensity",  new org.jmol.script.Token (553648143), "dotScale",  new org.jmol.script.Token (553648144), "ellipsoidDotCount",  new org.jmol.script.Token (553648145), "helixStep",  new org.jmol.script.Token (553648146), "hermiteLevel",  new org.jmol.script.Token (553648147), "historyLevel",  new org.jmol.script.Token (553648148), "lighting",  new org.jmol.script.Token (1073741995), "logLevel",  new org.jmol.script.Token (553648150), "meshScale",  new org.jmol.script.Token (553648151), "minimizationSteps",  new org.jmol.script.Token (553648152), "minPixelSelRadius",  new org.jmol.script.Token (553648153), "percentVdwAtom",  new org.jmol.script.Token (553648154), "perspectiveModel",  new org.jmol.script.Token (553648155), "phongExponent",  new org.jmol.script.Token (553648156), "pickingSpinRate",  new org.jmol.script.Token (553648158), "propertyAtomNumberField",  new org.jmol.script.Token (553648159), "propertyAtomNumberColumnCount",  new org.jmol.script.Token (553648160), "propertyDataColumnCount",  new org.jmol.script.Token (553648162), "propertyDataField",  new org.jmol.script.Token (553648164), "repaintWaitMs",  new org.jmol.script.Token (553648165), "ribbonAspectRatio",  new org.jmol.script.Token (553648166), "scriptReportingLevel",  new org.jmol.script.Token (553648168), "showScript",  new org.jmol.script.Token (536870922), "smallMoleculeMaxAtoms",  new org.jmol.script.Token (553648170), "specular",  new org.jmol.script.Token (536870924), "specularExponent",  new org.jmol.script.Token (553648172), "specularPercent",  new org.jmol.script.Token (553648174), "specPercent", null, "specularPower",  new org.jmol.script.Token (553648176), "specpower", null, "strandCount",  new org.jmol.script.Token (553648178), "strandCountForMeshRibbon",  new org.jmol.script.Token (553648180), "strandCountForStrands",  new org.jmol.script.Token (553648182), "strutSpacing",  new org.jmol.script.Token (553648184), "zDepth",  new org.jmol.script.Token (553648186), "zSlab",  new org.jmol.script.Token (553648188), "zshadePower",  new org.jmol.script.Token (553648190), "allowEmbeddedScripts",  new org.jmol.script.Token (603979778), "allowGestures",  new org.jmol.script.Token (603979780), "allowKeyStrokes",  new org.jmol.script.Token (603979781), "allowModelKit",  new org.jmol.script.Token (603979782), "allowMoveAtoms",  new org.jmol.script.Token (603979783), "allowMultiTouch",  new org.jmol.script.Token (603979784), "allowRotateSelected",  new org.jmol.script.Token (603979785), "antialiasDisplay",  new org.jmol.script.Token (603979786), "antialiasImages",  new org.jmol.script.Token (603979788), "antialiasTranslucent",  new org.jmol.script.Token (603979790), "appendNew",  new org.jmol.script.Token (603979792), "applySymmetryToBonds",  new org.jmol.script.Token (603979794), "atomPicking",  new org.jmol.script.Token (603979796), "autobond",  new org.jmol.script.Token (603979798), "autoFPS",  new org.jmol.script.Token (603979800), "axesMolecular",  new org.jmol.script.Token (603979804), "axesOrientationRasmol",  new org.jmol.script.Token (603979806), "axesUnitCell",  new org.jmol.script.Token (603979808), "axesWindow",  new org.jmol.script.Token (603979810), "bondModeOr",  new org.jmol.script.Token (603979812), "bondPicking",  new org.jmol.script.Token (603979814), "bonds",  new org.jmol.script.Token (1678770178), "bond", null, "cartoonBaseEdges",  new org.jmol.script.Token (603979818), "cartoonFancy",  new org.jmol.script.Token (603979820), "cartoonRockets",  new org.jmol.script.Token (603979819), "chainCaseSensitive",  new org.jmol.script.Token (603979821), "colorRasmol",  new org.jmol.script.Token (603979822), "debugScript",  new org.jmol.script.Token (603979824), "defaultStructureDssp",  new org.jmol.script.Token (603979825), "disablePopupMenu",  new org.jmol.script.Token (603979826), "displayCellParameters",  new org.jmol.script.Token (603979828), "dotsSelectedOnly",  new org.jmol.script.Token (603979829), "dotSurface",  new org.jmol.script.Token (603979830), "dragSelected",  new org.jmol.script.Token (603979831), "drawHover",  new org.jmol.script.Token (603979832), "drawPicking",  new org.jmol.script.Token (603979833), "dsspCalculateHydrogenAlways",  new org.jmol.script.Token (603979834), "dynamicMeasurements",  new org.jmol.script.Token (603979835), "ellipsoidArcs",  new org.jmol.script.Token (603979836), "ellipsoidAxes",  new org.jmol.script.Token (603979837), "ellipsoidBall",  new org.jmol.script.Token (603979838), "ellipsoidDots",  new org.jmol.script.Token (603979839), "ellipsoidFill",  new org.jmol.script.Token (603979840), "fileCaching",  new org.jmol.script.Token (603979842), "fontCaching",  new org.jmol.script.Token (603979844), "fontScaling",  new org.jmol.script.Token (603979845), "forceAutoBond",  new org.jmol.script.Token (603979846), "fractionalRelative",  new org.jmol.script.Token (603979848), "greyscaleRendering",  new org.jmol.script.Token (603979850), "hbondsBackbone",  new org.jmol.script.Token (603979852), "hbondsRasmol",  new org.jmol.script.Token (603979853), "hbondsSolid",  new org.jmol.script.Token (603979854), "hetero",  new org.jmol.script.Token (1613758470), "hideNameInPopup",  new org.jmol.script.Token (603979858), "hideNavigationPoint",  new org.jmol.script.Token (603979860), "hideNotSelected",  new org.jmol.script.Token (603979862), "highResolution",  new org.jmol.script.Token (603979864), "hydrogen",  new org.jmol.script.Token (1613758476), "hydrogens", null, "imageState",  new org.jmol.script.Token (603979868), "isKiosk",  new org.jmol.script.Token (603979869), "isosurfaceKey",  new org.jmol.script.Token (603979870), "isosurfacePropertySmoothing",  new org.jmol.script.Token (603979871), "isosurfacePropertySmoothingPower",  new org.jmol.script.Token (553648149), "justifyMeasurements",  new org.jmol.script.Token (603979872), "languageTranslation",  new org.jmol.script.Token (603979873), "legacyAutoBonding",  new org.jmol.script.Token (603979874), "logCommands",  new org.jmol.script.Token (603979875), "logGestures",  new org.jmol.script.Token (603979876), "measureAllModels",  new org.jmol.script.Token (603979877), "measurementLabels",  new org.jmol.script.Token (603979878), "measurementNumbers",  new org.jmol.script.Token (1610612739), "messageStyleChime",  new org.jmol.script.Token (603979879), "minimizationRefresh",  new org.jmol.script.Token (603979880), "minimizationSilent",  new org.jmol.script.Token (603979881), "modelkitMode",  new org.jmol.script.Token (603979882), "monitorEnergy",  new org.jmol.script.Token (603979883), "multipleBondRadiusFactor",  new org.jmol.script.Token (570425368), "multipleBondSpacing",  new org.jmol.script.Token (570425369), "multiProcessor",  new org.jmol.script.Token (603979884), "navigateSurface",  new org.jmol.script.Token (603979885), "navigationMode",  new org.jmol.script.Token (603979886), "navigationPeriodic",  new org.jmol.script.Token (603979887), "partialDots",  new org.jmol.script.Token (603979888), "pdbAddHydrogens",  new org.jmol.script.Token (603979889), "pdbGetHeader",  new org.jmol.script.Token (603979890), "pdbSequential",  new org.jmol.script.Token (603979891), "perspectiveDepth",  new org.jmol.script.Token (603979892), "preserveState",  new org.jmol.script.Token (603979893), "rangeSelected",  new org.jmol.script.Token (603979894), "redoMove",  new org.jmol.script.Token (4139), "refreshing",  new org.jmol.script.Token (603979896), "ribbonBorder",  new org.jmol.script.Token (603979898), "rocketBarrels",  new org.jmol.script.Token (603979900), "saveProteinStructureState",  new org.jmol.script.Token (603979902), "scriptQueue",  new org.jmol.script.Token (603979904), "selectAllModels",  new org.jmol.script.Token (603979906), "selectHetero",  new org.jmol.script.Token (603979908), "selectHydrogen",  new org.jmol.script.Token (603979910), "showAxes",  new org.jmol.script.Token (603979914), "showBoundBox",  new org.jmol.script.Token (603979916), "showBoundingBox", null, "showFrank",  new org.jmol.script.Token (603979918), "showHiddenSelectionHalos",  new org.jmol.script.Token (603979920), "showHydrogens",  new org.jmol.script.Token (603979922), "showKeyStrokes",  new org.jmol.script.Token (603979924), "showMeasurements",  new org.jmol.script.Token (603979926), "showMultipleBonds",  new org.jmol.script.Token (603979928), "showNavigationPointAlways",  new org.jmol.script.Token (603979930), "showTiming",  new org.jmol.script.Token (603979934), "showUnitcell",  new org.jmol.script.Token (603979936), "slabByAtom",  new org.jmol.script.Token (603979938), "slabByMolecule",  new org.jmol.script.Token (603979940), "slabEnabled",  new org.jmol.script.Token (603979942), "smartAromatic",  new org.jmol.script.Token (603979944), "solvent",  new org.jmol.script.Token (1613758488), "solventProbe",  new org.jmol.script.Token (603979948), "ssBondsBackbone",  new org.jmol.script.Token (603979952), "statusReporting",  new org.jmol.script.Token (603979954), "strutsMultiple",  new org.jmol.script.Token (603979955), "syncMouse",  new org.jmol.script.Token (603979956), "syncScript",  new org.jmol.script.Token (603979958), "testFlag1",  new org.jmol.script.Token (603979960), "testFlag2",  new org.jmol.script.Token (603979962), "testFlag3",  new org.jmol.script.Token (603979964), "testFlag4",  new org.jmol.script.Token (603979966), "traceAlpha",  new org.jmol.script.Token (603979967), "undo",  new org.jmol.script.Token (536870928), "undoMove",  new org.jmol.script.Token (4165), "useArcBall",  new org.jmol.script.Token (603979969), "useMinimizationThread",  new org.jmol.script.Token (603979970), "useNumberLocalization",  new org.jmol.script.Token (603979972), "waitForMoveTo",  new org.jmol.script.Token (603979974), "windowCentered",  new org.jmol.script.Token (603979975), "wireframeRotation",  new org.jmol.script.Token (603979976), "zeroBasedXyzRasmol",  new org.jmol.script.Token (603979978), "zoomEnabled",  new org.jmol.script.Token (603979980), "zoomLarge",  new org.jmol.script.Token (603979982), "zShade",  new org.jmol.script.Token (603979984)];
var tokenLast = null;
var stringThis;
var tokenThis;
var lcase;
for (var i = 0; i + 1 < arrayPairs.length; i += 2) {
stringThis = arrayPairs[i];
lcase = stringThis.toLowerCase ();
tokenThis = arrayPairs[i + 1];
if (tokenThis == null) tokenThis = tokenLast;
if (tokenThis.value == null) tokenThis.value = stringThis;
if (org.jmol.script.Token.tokenMap.get (lcase) != null) org.jmol.util.Logger.error ("duplicate token definition:" + lcase);
org.jmol.script.Token.tokenMap.put (lcase, tokenThis);
tokenLast = tokenThis;
}
}});
