.TH ANSIBLE.LINEINFILE 5 "2012-09-30" "0.8" "ANSIBLE MODULES"
." generated from library/lineinfile
.SH NAME
lineinfile \- Ensure a particular line is in a file
." ------ DESCRIPTION
.SH DESCRIPTION
.PP
This module will search a file for a line, and ensure that it is present or absent. 
.PP
This is primarily useful when you want to change a single line in a file only. For other cases, see the \fIcopy\fR or \fItemplate\fR modules. 
." ------ OPTIONS
."
."
.SH OPTIONS

.IP state
Whether the line should be there or not.
.IR Choices :
present,absent. (default: present)
.IP name
The file to modify(required)
.IP insertafter
Used with \fIstate=present\fR. If specified, the line will be inserted after the specified regular expression. Two special values are available; \fCBOF\fR for inserting the line at the beginning of the file, and \fCEOF\fR for inserting the line at the end of the file.
.IR Choices :
BOF,EOF. (default: EOF)
.IP regexp
The regular expression to look for in the file. For \fIstate=present\fR, the pattern to replace. For \fIstate=absent\fR, the pattern of the line to remove.(required)
.IP line
Required for \fIstate=present\fR. The line to insert/replace into the file. Must match the value given to \fCregexp\fR.
.IP backup
Create a backup file including the timestamp information so you can get the original file back if you somehow clobbered it incorrectly.."
."
." ------ NOTES
."
."
." ------ EXAMPLES
.SH EXAMPLES
.PP
.nf
lineinfile name=/etc/selinux/config regexp=^SELINUX= line=SELINUX=disabled
.fi
.PP
.nf
lineinfile name=/etc/sudoers state=absent regexp="^%wheel"
.fi
." ------- AUTHOR
.SH SEE ALSO
.IR ansible (1),
.I http://ansible.github.com/modules.html#lineinfile